//////////////////////////////////////////////////////////////////////////////
//
// This software module was originally developed by
//
// Lei Wang, Zhongyang Huang
// (Panasonic Singapore Laboratories Pte Ltd)
//
// in the course of development of the MPEG-7 Experimentation Model.
//
// This software module is an implementation of a part of one or more MPEG-7
// Experimentation Model tools as specified by the MPEG-7 Requirements.
//
// ISO/IEC gives users of MPEG-7 free license to this software module or
// modifications thereof for use in hardware or software products claiming
// conformance to MPEG-7.
//
// Those intending to use this software module in hardware or software products
// are advised that its use may infringe existing patents. The original
// developer of this software module and his/her company, the subsequent
// editors and their companies, and ISO/IEC have no liability for use of this
// software module or modifications thereof in an implementation.
//
// Copyright is not released for non MPEG-7 conforming products. The
// organizations named above retain full right to use the code for their own
// purpose, assign or donate the code to a third party and inhibit third parties
// from using the code for non MPEG-7 conforming products.
//
// Copyright (c) 1998-2001.
//
// This notice must be included in all copies or derivative works.
//
// Applicable File Name:  EigenFaceData.h
//

using namespace XM;

// Hard coded FaceRecognition eigenface and meanface parameters
// MeanfaceDataTable is at the end

#include "FaceRecognitionExtraction.h"

char FaceRecognitionExtractionTool::EigenfaceDataTable[2576*48] =
{-3,-6,-6,-7,-7,-7,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-9,-9,-9,-9,-8,-8,-8,-8,-9,
-9,-9,-9,-9,-9,-9,-9,-8,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-8,-8,-8,-7,-7,-6,-5,-2,-6,-10,-11,-12,
-12,-12,-12,-12,-13,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-12,-12,-12,-12,-13,-13,-13,-13,-13,-14,
-14,-14,-14,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-13,-12,-11,-10,-8,-4,-6,-11,-11,-12,-12,-12,-12,-12,
-11,-11,-10,-10,-9,-9,-9,-9,-9,-9,-9,-9,-10,-9,-9,-9,-9,-9,-9,-10,-10,-11,-11,-12,-12,-13,-13,-13,-14,-14,
-14,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-12,-11,-9,-7,-3,-7,-11,-11,-12,-12,-11,-10,-10,-9,-8,-7,-6,
-6,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-6,-7,-8,-8,-9,-10,-11,-12,-12,-13,-14,-14,-15,-15,-16,
-16,-16,-16,-16,-16,-16,-15,-14,-14,-12,-11,-9,-6,-3,-7,-11,-11,-11,-9,-8,-7,-6,-4,-3,-2,-2,-1,-1,-1,-1,
-1,-1,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-4,-4,-5,-6,-7,-8,-9,-10,-11,-13,-14,-14,-15,-15,-16,-16,-16,-16,
-16,-16,-15,-14,-13,-12,-10,-7,-5,-3,-7,-10,-9,-8,-6,-5,-3,-2,0,0,1,1,1,2,2,2,2,2,2,2,
1,1,1,0,0,0,0,-1,-1,-1,-2,-3,-4,-5,-7,-8,-10,-11,-13,-14,-14,-15,-15,-16,-16,-16,-16,-16,-15,-14,
-13,-11,-9,-6,-5,-2,-6,-8,-7,-5,-3,-1,0,1,2,2,3,3,3,4,4,4,4,4,4,4,3,3,2,1,
1,1,1,0,0,0,-1,-1,-2,-3,-4,-6,-7,-9,-11,-12,-13,-14,-15,-15,-16,-16,-16,-15,-14,-13,-12,-9,-7,-5,
-4,-2,-5,-6,-4,-2,-1,1,2,2,3,4,4,4,4,4,5,5,4,4,3,3,2,2,1,0,0,0,0,0,
0,-1,-1,-1,-1,-2,-2,-3,-4,-5,-7,-9,-11,-12,-14,-14,-15,-15,-15,-14,-13,-11,-10,-7,-6,-4,-3,-1,-3,-4,
-2,0,1,2,3,3,4,4,4,4,4,4,4,4,3,3,2,1,1,1,0,-1,-1,-1,0,0,0,0,0,0,
0,-1,-1,-1,-2,-2,-3,-4,-6,-8,-10,-11,-12,-13,-13,-12,-11,-9,-7,-6,-4,-3,-2,-1,-2,-2,0,1,2,3,
3,4,4,4,4,4,4,3,3,3,2,2,1,1,1,1,0,-1,-1,-1,0,1,1,1,1,0,0,0,0,-1,
-1,-1,-1,-2,-3,-4,-5,-6,-8,-9,-9,-9,-8,-6,-5,-3,-2,-2,-1,-1,-1,0,1,3,3,3,4,4,4,4,
4,4,3,3,2,2,2,2,2,2,2,1,0,-1,0,0,0,1,1,1,1,0,0,0,0,-1,-1,-1,-1,-1,
-1,-2,-3,-3,-4,-4,-5,-5,-4,-4,-3,-3,-2,-2,-2,-1,0,1,2,3,3,4,4,5,4,4,4,3,3,3,
2,2,2,2,2,3,3,1,0,0,1,1,1,1,1,1,1,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,
-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-2,-1,0,1,2,3,3,4,4,5,4,4,3,3,3,2,2,2,2,2,
3,3,3,1,0,1,2,1,1,1,1,1,1,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,
-2,-2,-2,-2,-3,-3,-2,-1,1,2,3,3,3,4,4,4,4,4,3,3,2,2,2,2,2,2,3,3,2,1,
1,1,1,1,1,1,1,1,1,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,
-2,-2,-2,-1,1,2,3,3,4,4,5,4,4,3,3,2,2,2,1,1,1,2,3,3,2,0,1,2,2,1,
1,1,1,1,1,0,-1,-1,-1,-1,-1,0,0,0,-1,-1,-1,0,0,0,0,0,0,0,0,-1,-1,-2,-2,-1,
1,3,3,3,4,4,5,4,4,3,2,2,1,1,1,1,1,2,2,3,2,1,2,2,2,1,1,1,1,1,
1,0,0,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,2,3,3,3,
4,4,4,4,3,2,2,1,1,1,1,1,1,1,2,3,3,1,1,1,1,1,1,1,2,2,1,0,0,-1,
-1,-1,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,2,3,3,3,4,4,4,4,
3,2,2,1,1,1,1,1,1,1,2,3,3,1,1,1,1,1,1,1,2,2,1,1,0,0,0,0,1,1,
1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,2,3,3,3,4,4,4,4,3,2,1,1,
1,1,1,1,1,1,1,2,2,1,1,1,1,2,2,2,2,2,2,2,1,1,0,1,1,1,1,0,0,0,
1,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,3,4,4,4,4,4,3,2,1,1,1,1,1,1,
1,1,0,1,2,1,1,1,2,2,2,2,3,3,3,2,2,2,1,1,2,1,1,0,0,0,1,0,0,0,
0,0,0,0,0,0,0,0,0,0,2,3,3,4,4,4,4,4,3,2,2,1,1,1,1,1,1,0,0,0,
0,0,0,1,2,2,2,3,3,3,3,2,2,2,1,1,2,1,1,1,0,0,1,0,0,0,0,0,0,0,
0,0,0,0,0,0,2,3,3,4,4,4,4,4,3,2,2,1,1,1,1,1,1,0,0,-1,-1,0,0,0,
1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,
0,0,2,3,3,4,4,4,4,3,3,2,2,1,1,1,1,1,1,1,0,-1,-1,-2,-2,-1,-1,0,1,1,
1,1,1,0,0,0,0,0,1,0,0,1,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,2,3,
3,4,4,4,4,3,3,2,2,1,1,1,1,1,1,1,0,-1,-1,-2,-2,-1,-1,0,0,1,1,1,1,0,
0,0,0,0,0,0,0,1,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,2,3,3,4,4,4,
4,3,3,2,2,1,1,1,1,1,1,0,0,-1,-1,-1,0,0,1,1,1,2,2,2,1,1,1,1,1,1,
1,1,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,2,3,3,4,4,4,4,3,3,2,
1,1,1,1,1,1,1,0,0,0,0,0,0,1,2,2,2,2,3,3,2,2,2,2,1,1,1,1,1,1,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,3,3,4,4,4,3,3,2,1,1,1,1,
1,1,1,1,0,1,2,1,1,1,2,2,2,2,2,2,2,2,2,2,1,1,2,1,1,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,2,3,3,3,4,4,4,3,3,2,1,1,1,1,1,1,1,1,
1,2,2,1,1,0,1,2,2,2,2,2,2,2,1,1,0,1,1,1,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,2,3,3,3,4,4,4,4,3,2,1,1,1,1,1,1,1,1,2,3,2,1,
1,1,1,1,1,1,2,2,1,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,-1,-1,2,3,3,3,4,4,4,4,3,2,1,1,1,1,1,1,1,1,2,3,2,1,1,1,1,1,
1,1,1,1,1,0,0,-1,-1,-1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,
1,2,3,3,4,4,4,4,3,3,2,1,1,1,1,1,1,1,2,3,2,1,2,2,2,1,0,1,1,1,
1,0,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,1,2,3,3,
4,4,4,4,4,3,2,2,1,1,1,1,1,1,2,3,2,0,1,2,2,1,0,1,1,1,1,0,-1,-1,
-1,-1,-1,0,0,0,-1,-1,-1,-1,0,0,0,0,0,0,0,-1,-1,-2,-2,-1,0,2,3,3,3,4,4,4,
4,3,3,2,2,1,1,1,1,1,2,3,2,1,1,1,1,1,0,1,1,1,1,0,-1,-1,-1,-1,-1,-1,
-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-1,0,1,2,3,3,4,4,4,4,3,3,2,
2,2,2,1,1,1,2,3,3,1,0,1,1,1,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,
-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-3,-3,-2,-1,-1,0,2,3,3,3,4,4,4,4,3,3,3,2,2,1,
1,1,2,2,2,1,0,0,1,1,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-3,
-3,-3,-3,-3,-3,-3,-3,-3,-2,-1,-1,-1,1,2,3,3,4,4,4,4,4,3,3,2,2,2,1,1,1,1,
2,1,0,-1,-1,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-2,-2,-3,-3,-4,-5,-5,-5,-5,-4,
-4,-3,-3,-2,-2,-1,-2,-2,0,1,2,3,3,4,4,4,4,4,3,3,2,2,2,2,1,0,1,1,0,-1,
-2,-1,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-2,-2,-3,-4,-5,-7,-8,-9,-9,-9,-8,-7,-5,-4,-3,-2,
-2,-1,-3,-3,-2,0,1,2,3,3,4,4,4,4,4,4,4,3,3,3,2,1,0,0,0,-1,-1,-1,-1,0,
0,0,0,-1,-1,-1,-1,-2,-2,-2,-3,-5,-6,-8,-10,-11,-13,-13,-13,-12,-11,-9,-8,-6,-4,-3,-2,-1,-5,-6,
-4,-2,-1,1,2,2,3,3,4,4,4,4,4,4,4,4,3,3,2,2,1,0,0,0,0,-1,-1,-1,-1,-1,
-1,-2,-3,-3,-4,-5,-7,-9,-11,-13,-14,-15,-15,-15,-15,-14,-13,-11,-10,-8,-6,-4,-3,-1,-6,-8,-7,-5,-3,-2,
0,1,1,2,3,3,3,3,4,4,4,4,4,3,3,3,2,1,1,1,0,0,-1,-1,-1,-1,-2,-3,-5,-6,
-7,-9,-11,-12,-14,-15,-15,-16,-16,-16,-16,-15,-14,-13,-11,-9,-7,-5,-4,-2,-6,-10,-9,-8,-6,-5,-3,-2,-1,0,
1,1,1,1,2,2,2,2,2,1,1,1,0,0,0,0,-1,-1,-2,-2,-2,-3,-4,-6,-7,-9,-10,-12,-13,-14,
-15,-15,-16,-16,-16,-16,-16,-16,-15,-14,-13,-11,-9,-6,-4,-2,-7,-11,-11,-11,-9,-8,-7,-6,-5,-4,-3,-2,-2,-2,
-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-5,-5,-6,-7,-9,-10,-11,-12,-13,-14,-15,-15,-16,-16,-16,
-16,-16,-16,-16,-15,-14,-13,-12,-10,-7,-5,-3,-7,-11,-11,-12,-11,-11,-10,-10,-9,-8,-7,-7,-6,-6,-6,-6,-6,-6,
-6,-6,-7,-6,-6,-6,-6,-6,-6,-7,-7,-8,-9,-9,-10,-11,-12,-12,-13,-14,-15,-15,-15,-16,-16,-16,-16,-16,-16,-16,
-15,-14,-14,-12,-11,-8,-6,-3,-6,-11,-11,-12,-12,-12,-12,-12,-11,-11,-10,-10,-10,-9,-9,-9,-9,-9,-9,-10,-10,-9,
-9,-9,-9,-9,-10,-10,-10,-11,-11,-12,-12,-13,-13,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-12,
-11,-9,-7,-3,-6,-10,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-12,-12,
-12,-13,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-13,-12,-11,-10,-8,-4,
-3,-6,-6,-7,-7,-7,-7,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-9,-9,-9,-9,-9,-9,-9,-9,
-9,-9,-9,-9,-9,-9,-9,-8,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-8,-8,-8,-7,-7,-6,-5,-2,-5,-10,-9,-10,
-10,-11,-10,-10,-10,-11,-11,-11,-10,-10,-9,-8,-7,-6,-5,-4,-3,-2,-1,1,2,3,5,5,6,6,6,6,5,5,
5,4,3,2,2,2,2,2,2,2,2,2,2,3,3,4,4,5,5,6,6,4,-10,-16,-16,-17,-17,-18,-18,-18,
-18,-18,-17,-17,-16,-14,-12,-11,-8,-7,-5,-3,0,1,3,5,8,9,11,11,11,11,11,11,11,11,10,9,7,6,
5,5,4,3,3,3,3,3,4,5,5,6,7,9,9,10,10,7,-10,-16,-17,-18,-18,-19,-18,-18,-18,-17,-16,-14,
-11,-9,-7,-5,-3,-1,0,2,4,6,8,9,10,11,12,12,12,13,13,13,12,12,12,11,10,9,8,8,6,6,
4,3,3,3,3,4,4,5,7,9,10,10,10,7,-11,-17,-18,-19,-19,-19,-18,-17,-15,-13,-10,-7,-5,-3,-1,0,
3,4,6,7,7,9,10,11,12,13,13,14,14,14,14,14,14,13,13,13,12,10,9,8,8,7,6,5,4,3,
3,4,4,6,8,10,11,11,11,8,-11,-18,-19,-19,-18,-18,-16,-15,-11,-8,-4,-2,0,2,4,6,7,8,8,9,
9,9,10,10,12,13,14,15,15,15,15,15,15,14,14,14,13,12,10,8,8,7,7,6,6,5,4,4,5,7,
9,10,12,12,12,8,-11,-19,-19,-19,-17,-16,-14,-11,-6,-3,0,2,5,7,8,9,9,10,10,10,10,10,10,10,
12,13,15,16,16,16,16,16,15,14,14,14,14,13,12,10,9,8,6,6,6,6,6,6,6,8,10,12,13,13,
13,8,-12,-19,-19,-17,-14,-12,-7,-4,-1,2,5,8,10,11,12,12,12,12,12,12,12,12,11,11,13,14,16,16,
17,17,17,17,16,15,14,13,13,13,13,12,10,10,8,7,7,7,7,7,8,10,12,13,13,13,14,8,-12,-19,
-17,-14,-10,-7,-2,1,4,7,10,12,13,14,14,15,15,15,15,15,15,14,13,12,14,15,16,16,16,16,16,16,
16,15,14,13,12,12,13,13,13,12,10,9,9,8,8,9,10,12,13,13,13,13,14,9,-12,-17,-14,-9,-5,-2,
3,7,9,12,14,15,15,16,17,18,18,18,18,16,15,14,12,10,11,13,14,14,14,13,13,13,13,12,12,12,
11,11,12,13,13,13,13,13,12,11,11,11,12,12,13,13,13,13,13,8,-11,-14,-9,-6,-2,2,7,10,12,14,
15,16,17,18,18,19,19,18,17,16,14,13,10,7,8,9,11,11,12,11,10,10,9,9,9,9,9,9,10,10,
11,12,13,14,14,13,13,13,14,14,14,13,13,12,12,8,-9,-10,-6,-2,2,7,11,12,14,15,16,17,18,18,
18,18,18,17,15,14,12,10,8,6,7,8,9,10,10,11,10,9,8,8,8,8,7,7,7,7,8,8,10,12,
13,14,14,14,14,14,14,14,14,13,13,7,-6,-7,-3,1,7,10,12,13,14,16,17,17,17,17,17,17,16,15,
14,12,9,8,8,6,8,9,9,8,9,9,10,9,8,7,7,7,7,6,6,6,6,6,7,8,10,11,12,12,
12,13,13,13,13,12,12,7,-4,-4,1,5,10,11,13,14,15,16,17,17,17,17,16,15,14,14,13,12,7,6,
7,6,7,9,9,8,7,8,9,8,7,6,5,5,5,5,5,5,4,4,5,6,7,8,8,9,9,10,10,10,
10,10,11,6,-3,0,5,8,10,12,14,14,15,16,17,17,16,16,15,14,13,13,14,12,6,5,6,5,5,7,
8,8,7,7,7,7,6,5,5,5,4,4,4,3,3,3,4,4,5,5,6,7,7,7,7,7,7,7,8,5,
-1,3,7,9,11,12,14,15,15,16,16,16,15,15,14,13,13,13,14,12,6,5,6,5,5,6,7,7,7,6,
6,6,5,4,4,4,4,4,3,3,2,2,3,4,5,5,5,6,6,5,5,5,5,4,6,3,1,4,7,9,
11,13,14,14,15,15,15,15,14,14,13,13,12,12,14,12,6,5,5,4,4,5,6,7,7,6,6,6,5,4,
3,3,4,4,4,4,2,2,3,4,5,5,5,6,6,5,4,4,4,3,4,2,2,6,8,9,11,13,14,14,
15,15,14,13,13,13,12,12,11,12,13,12,7,5,5,3,1,5,7,7,7,6,6,6,5,4,3,3,3,4,
5,5,4,3,3,5,5,5,5,6,6,5,5,3,3,3,3,2,3,6,8,9,11,13,14,14,14,14,13,12,
12,12,11,11,11,11,12,12,8,6,4,2,0,4,7,7,7,6,7,7,5,4,4,3,4,4,5,6,6,4,
4,5,5,5,5,5,6,5,5,3,3,2,3,2,3,6,8,10,11,13,13,14,14,13,12,12,11,11,11,10,
10,10,10,11,9,6,4,3,4,6,7,7,7,9,10,9,7,6,5,4,4,4,5,6,7,6,5,5,5,4,
4,5,5,5,5,3,2,2,3,2,3,7,8,10,11,12,13,13,13,12,12,11,11,11,10,10,9,9,9,9,
8,7,5,5,6,7,7,8,10,11,11,11,10,9,7,5,4,5,4,5,7,6,6,5,4,4,4,4,4,4,
4,2,2,1,2,2,4,7,8,10,11,12,13,13,12,12,11,10,10,10,10,9,9,8,7,6,5,6,6,6,
7,8,9,11,12,12,11,10,10,10,8,6,4,5,4,4,5,5,5,4,3,3,3,3,3,4,4,2,1,0,
1,1,4,7,8,10,11,12,13,13,12,11,10,10,10,10,10,9,9,8,7,4,3,4,5,7,9,9,10,10,
10,10,9,8,8,9,7,5,3,4,3,3,2,3,4,4,3,2,2,2,2,3,3,1,0,0,1,0,4,7,
8,10,11,12,13,13,12,11,10,10,10,10,9,9,9,8,7,5,2,2,3,5,5,5,5,5,6,6,5,5,
5,6,6,4,2,2,2,2,1,2,3,3,3,2,2,1,1,2,3,1,0,-1,0,0,4,7,8,10,11,12,
13,13,12,11,10,10,10,10,9,9,9,8,7,5,2,2,2,4,4,4,4,5,5,5,5,4,4,6,5,4,
2,2,2,2,1,2,3,3,3,2,1,1,1,2,3,1,0,-1,0,0,4,7,8,10,11,12,12,12,12,11,
10,10,10,10,9,9,9,8,7,5,3,3,4,6,7,8,8,8,9,8,7,7,7,8,7,4,3,3,3,2,
1,2,4,3,2,2,2,2,2,2,3,1,0,-1,0,0,3,7,8,10,11,12,13,13,12,11,11,10,10,10,
10,9,9,8,7,6,5,5,5,5,6,7,8,9,11,11,10,9,9,9,7,4,3,4,3,3,4,4,4,4,
3,2,2,2,2,3,3,1,1,0,1,1,3,6,8,10,11,12,13,13,13,12,11,11,10,10,10,9,9,9,
9,9,7,6,5,4,5,6,6,7,9,10,10,9,8,8,6,4,3,4,4,4,6,5,5,4,3,3,2,2,
3,3,4,2,1,0,1,1,3,6,7,9,11,13,13,13,13,13,12,11,11,11,10,10,10,9,10,11,8,6,
4,2,3,6,7,6,6,7,8,8,6,5,4,3,3,3,4,5,6,5,4,4,4,3,3,3,4,4,4,2,
2,1,2,1,2,6,7,9,11,13,13,14,14,14,13,12,11,11,11,10,10,10,11,12,8,5,4,1,0,4,
6,7,6,5,6,6,4,3,3,2,3,3,4,5,5,3,3,4,4,3,4,4,5,4,4,2,2,1,2,2,
2,5,7,9,11,13,14,14,14,14,13,13,12,12,11,11,10,11,12,12,7,5,5,3,1,4,6,7,6,5,
5,6,4,3,2,2,3,3,4,4,3,2,2,4,4,3,4,5,5,4,4,2,2,2,2,1,0,4,7,8,
11,12,14,14,15,15,15,14,14,13,12,12,11,11,13,12,5,4,5,4,4,5,6,6,6,5,5,5,4,3,
2,3,3,3,3,3,1,1,2,3,3,4,4,4,5,4,4,3,3,2,3,2,-2,2,6,8,11,12,14,14,
15,15,15,15,15,14,13,13,12,12,13,11,5,4,6,6,5,6,7,6,6,5,5,5,4,3,3,3,3,3,
2,2,1,1,2,3,3,4,4,5,5,4,4,3,3,3,4,3,-3,-1,4,7,10,11,13,14,15,16,16,16,
15,15,14,13,12,12,13,11,5,4,5,5,4,6,7,6,6,6,6,6,4,4,4,4,3,3,2,2,2,2,
2,3,4,4,5,6,6,6,6,5,5,5,7,4,-5,-5,0,4,9,10,12,13,15,16,16,16,16,16,15,14,
13,13,13,11,6,5,6,6,6,8,7,6,6,7,7,7,5,5,4,4,4,4,4,3,3,3,3,4,5,6,
7,7,8,8,9,9,9,8,9,5,-7,-8,-4,0,6,9,11,13,14,15,16,17,17,16,16,16,15,14,13,11,
8,7,6,5,8,8,7,7,7,8,8,7,6,6,5,5,5,5,4,4,4,4,5,6,8,9,10,10,11,11,
12,12,11,11,11,7,-9,-11,-7,-4,1,6,10,11,13,14,15,16,17,17,17,17,17,16,14,13,11,9,7,5,
6,7,7,8,9,9,8,7,7,6,6,6,6,5,5,5,6,7,8,10,12,12,12,12,12,13,13,13,13,12,
12,7,-11,-15,-10,-7,-4,1,6,9,12,13,14,15,16,17,17,17,17,17,16,14,13,12,9,7,7,8,9,10,
10,9,8,8,8,8,8,7,7,7,8,8,9,10,11,12,13,12,12,11,12,12,12,12,12,12,12,7,-12,-18,
-15,-11,-7,-4,1,5,8,11,13,14,14,15,16,16,16,16,16,15,14,13,11,9,10,12,12,12,12,12,11,11,
11,11,10,10,10,10,10,10,11,11,12,11,11,10,10,10,11,11,12,12,12,12,13,8,-12,-19,-18,-15,-11,-8,
-5,-1,2,5,9,11,12,13,13,14,14,14,14,13,13,13,12,12,13,14,14,15,15,15,15,15,14,14,13,12,
11,11,12,12,12,10,9,9,8,7,7,8,9,11,12,12,13,13,13,8,-12,-19,-19,-18,-16,-13,-9,-6,-4,-1,
3,6,8,10,10,11,11,11,11,11,11,11,10,10,12,13,14,15,15,15,15,15,15,14,13,12,12,12,12,11,
10,9,7,6,6,6,7,7,8,10,11,12,13,13,13,7,-11,-19,-19,-19,-18,-17,-15,-13,-8,-6,-3,-1,2,5,
7,8,8,8,9,9,9,9,9,9,11,12,14,15,15,14,14,15,14,13,13,13,13,12,11,10,8,7,6,5,
5,6,6,6,6,8,9,11,12,12,11,6,-11,-18,-19,-19,-19,-18,-17,-16,-14,-10,-7,-5,-3,-1,2,4,5,6,
7,8,8,8,9,9,11,12,13,14,14,13,13,14,14,13,13,13,13,11,9,8,7,7,7,6,5,4,4,4,
5,6,8,10,11,11,11,6,-11,-17,-18,-19,-19,-19,-18,-18,-16,-15,-12,-10,-8,-6,-5,-3,0,2,4,5,6,7,
9,10,11,12,12,12,12,13,13,13,13,12,12,12,11,10,8,8,7,7,5,4,3,3,2,3,4,5,7,9,
10,10,10,7,-10,-16,-17,-18,-18,-19,-19,-19,-18,-18,-17,-16,-13,-11,-10,-8,-6,-4,-2,1,3,4,6,8,9,10,
11,11,12,12,12,12,11,11,11,10,9,8,7,6,5,4,3,2,2,2,2,3,3,4,6,8,9,9,9,6,
-10,-16,-16,-17,-17,-18,-18,-18,-18,-18,-18,-17,-16,-15,-14,-12,-10,-9,-6,-4,-1,1,3,4,7,9,10,10,11,11,
10,10,10,10,9,8,6,4,4,3,3,2,2,1,1,2,3,4,4,5,6,7,8,8,9,6,-5,-10,-9,-10,
-10,-11,-11,-11,-11,-11,-11,-11,-10,-10,-9,-8,-8,-7,-6,-5,-4,-3,-1,1,1,3,4,5,5,5,5,5,5,5,
4,3,2,1,1,1,1,1,1,1,1,1,1,2,2,3,3,3,4,5,5,3,-4,-8,-8,-11,-11,-12,-13,-14,
-14,-14,-14,-14,-14,-14,-13,-12,-12,-11,-10,-8,-7,-6,-4,-3,-2,0,1,2,3,4,4,4,4,4,4,3,3,3,
2,2,2,3,3,3,3,4,4,4,4,5,5,4,5,6,7,4,-9,-15,-17,-20,-21,-23,-24,-25,-27,-27,-27,-26,
-25,-24,-22,-20,-19,-17,-15,-12,-9,-6,-4,-1,1,2,5,6,6,7,7,7,7,7,7,6,5,5,5,5,4,4,
4,4,4,4,5,5,6,7,8,8,9,10,9,7,-10,-19,-21,-24,-25,-28,-28,-29,-30,-31,-31,-29,-26,-25,-23,-21,
-19,-17,-13,-9,-7,-5,-3,-1,0,1,3,4,5,6,7,8,8,8,8,7,7,7,7,7,7,7,6,5,5,5,
6,6,6,8,9,9,10,10,9,6,-13,-23,-25,-28,-29,-31,-32,-34,-35,-34,-32,-29,-26,-23,-21,-19,-15,-12,-10,-8,
-6,-4,-3,-3,-2,-1,1,2,3,5,6,7,7,8,7,7,8,8,8,8,9,8,8,8,7,6,6,7,7,8,
8,9,10,9,8,5,-14,-25,-28,-31,-33,-35,-36,-36,-34,-31,-27,-24,-21,-18,-14,-10,-7,-6,-4,-4,-3,-3,-3,-2,
-2,-1,0,0,1,3,5,6,6,7,8,7,8,9,9,8,8,8,9,8,8,8,7,6,8,8,8,9,8,7,
6,4,-17,-29,-33,-36,-38,-38,-35,-32,-27,-24,-21,-18,-14,-10,-7,-5,-3,-2,-1,-1,-1,-1,0,0,1,2,1,0,
0,0,1,2,2,4,6,7,8,9,9,9,8,9,8,8,8,9,9,9,8,7,8,8,8,8,6,3,-19,-34,
-37,-39,-37,-34,-28,-24,-21,-18,-14,-10,-6,-4,-3,-2,0,0,1,0,0,0,1,1,3,3,3,3,2,1,1,1,
1,2,2,3,4,7,10,10,10,11,11,10,9,9,10,10,10,9,9,9,9,9,7,3,-22,-37,-38,-36,-32,-27,
-22,-17,-14,-10,-6,-4,-3,-2,0,1,1,1,1,0,0,0,0,0,2,1,0,-1,-2,-2,-2,-1,-1,0,-1,-1,
0,3,6,7,8,9,10,10,11,10,10,10,10,9,10,9,8,8,6,3,-24,-37,-35,-31,-26,-21,-15,-10,-7,-4,
-2,-1,-1,0,1,1,0,0,-1,-2,-2,-2,-2,-4,-4,-4,-6,-7,-9,-10,-9,-9,-9,-8,-7,-8,-7,-5,-2,0,
2,4,6,7,8,9,8,8,7,8,8,7,6,7,4,2,-23,-34,-31,-27,-21,-15,-9,-5,-3,-2,-1,-1,-1,-1,
-1,-2,-2,-3,-5,-5,-5,-6,-8,-12,-12,-12,-11,-10,-11,-13,-14,-14,-14,-14,-14,-14,-14,-14,-12,-11,-8,-5,-2,1,
3,4,4,3,2,3,3,4,3,4,3,2,-21,-32,-27,-22,-15,-9,-5,-3,-2,-2,-2,-2,-3,-3,-3,-3,-5,-6,
-8,-7,-9,-11,-13,-15,-15,-15,-14,-11,-11,-12,-13,-15,-15,-16,-16,-16,-16,-16,-17,-17,-16,-14,-11,-7,-4,-2,-1,-1,
-2,-2,-1,0,-1,0,0,0,-20,-29,-23,-16,-9,-6,-4,-3,-3,-3,-3,-4,-5,-5,-6,-6,-8,-9,-9,-8,-11,-15,
-14,-13,-13,-14,-14,-13,-12,-12,-12,-14,-15,-16,-16,-17,-17,-17,-17,-17,-18,-17,-17,-15,-12,-9,-7,-5,-5,-6,-6,-5,
-5,-4,-4,-2,-19,-25,-17,-11,-6,-5,-4,-4,-4,-5,-5,-6,-7,-8,-8,-9,-9,-9,-7,-7,-13,-16,-11,-11,-12,-13,
-14,-14,-13,-13,-12,-14,-15,-16,-16,-17,-17,-17,-18,-18,-18,-18,-18,-18,-18,-15,-12,-10,-9,-9,-9,-8,-8,-7,-7,-4,
-17,-21,-12,-7,-5,-5,-4,-4,-5,-6,-7,-8,-9,-10,-10,-10,-10,-9,-6,-6,-13,-14,-9,-12,-16,-15,-14,-13,-12,-13,
-13,-13,-15,-16,-16,-17,-17,-18,-18,-19,-19,-18,-18,-18,-18,-18,-15,-13,-11,-10,-11,-11,-10,-9,-9,-6,-15,-15,-9,-7,
-5,-5,-5,-5,-6,-7,-8,-9,-10,-11,-10,-10,-10,-9,-5,-5,-12,-12,-6,-8,-10,-10,-11,-11,-11,-12,-13,-12,-15,-16,
-16,-17,-17,-18,-19,-20,-19,-18,-18,-18,-18,-18,-17,-15,-13,-12,-12,-12,-13,-12,-12,-8,-12,-11,-7,-7,-5,-5,-5,-5,
-6,-7,-8,-10,-10,-11,-10,-10,-10,-8,-5,-4,-10,-10,-3,-3,-4,-5,-8,-10,-10,-12,-13,-12,-16,-16,-16,-17,-18,-19,
-19,-19,-18,-17,-17,-17,-17,-18,-18,-16,-14,-14,-13,-13,-14,-14,-14,-9,-9,-9,-6,-6,-6,-5,-5,-5,-6,-7,-9,-10,
-11,-11,-10,-10,-9,-9,-5,-3,-8,-8,-3,-5,-6,-4,-6,-8,-10,-12,-12,-12,-16,-15,-16,-17,-18,-19,-19,-18,-15,-16,
-16,-16,-17,-18,-18,-17,-15,-14,-14,-14,-14,-14,-14,-9,-7,-7,-6,-6,-6,-4,-5,-6,-7,-8,-9,-10,-11,-11,-10,-10,
-9,-8,-5,-3,-8,-8,-4,-7,-8,-6,-6,-8,-11,-13,-12,-13,-15,-16,-17,-18,-18,-19,-18,-15,-13,-15,-17,-17,-17,-18,
-18,-18,-16,-15,-14,-14,-14,-14,-14,-9,-5,-6,-6,-6,-6,-5,-5,-6,-8,-9,-10,-11,-11,-11,-10,-10,-9,-9,-7,-4,
-7,-8,-4,-6,-7,-5,-6,-9,-13,-13,-13,-14,-15,-17,-19,-19,-19,-19,-17,-11,-10,-14,-17,-18,-17,-18,-19,-18,-17,-15,
-14,-14,-14,-14,-15,-9,-4,-6,-6,-6,-6,-5,-5,-7,-8,-10,-11,-11,-11,-11,-10,-9,-9,-9,-8,-7,-8,-10,-7,-6,
-7,-7,-9,-12,-13,-13,-13,-14,-15,-14,-16,-18,-18,-19,-15,-9,-7,-12,-16,-17,-18,-18,-19,-18,-17,-14,-13,-13,-13,-13,
-14,-9,-4,-6,-5,-6,-6,-6,-6,-7,-9,-10,-11,-11,-11,-11,-10,-9,-9,-9,-10,-10,-12,-14,-11,-10,-10,-10,-11,-12,
-12,-12,-13,-14,-13,-10,-13,-17,-18,-17,-12,-7,-6,-9,-13,-16,-17,-18,-19,-18,-16,-14,-13,-12,-13,-13,-14,-9,-4,-5,
-5,-6,-6,-6,-7,-8,-10,-11,-12,-11,-10,-11,-10,-9,-8,-8,-10,-13,-14,-16,-13,-11,-12,-12,-12,-12,-12,-12,-13,-14,
-14,-11,-15,-17,-17,-15,-10,-6,-6,-7,-11,-13,-16,-18,-19,-18,-15,-13,-12,-12,-13,-12,-13,-9,-3,-5,-6,-6,-6,-6,
-6,-8,-10,-12,-12,-11,-10,-11,-10,-9,-8,-8,-10,-13,-16,-16,-13,-11,-13,-13,-13,-12,-12,-11,-12,-13,-14,-13,-15,-16,
-15,-13,-8,-6,-6,-6,-9,-12,-15,-17,-19,-18,-15,-11,-11,-11,-12,-12,-13,-8,-3,-5,-6,-6,-6,-6,-6,-8,-10,-12,
-12,-11,-10,-11,-10,-9,-8,-8,-9,-13,-15,-16,-13,-11,-12,-13,-12,-12,-11,-10,-11,-13,-13,-12,-14,-15,-15,-12,-8,-6,
-5,-6,-9,-12,-14,-17,-18,-18,-15,-11,-10,-11,-12,-12,-13,-8,-4,-5,-5,-6,-6,-6,-6,-8,-10,-11,-11,-11,-10,-10,
-10,-9,-8,-8,-10,-12,-13,-14,-12,-9,-10,-10,-10,-10,-10,-10,-11,-12,-12,-9,-13,-16,-16,-14,-9,-6,-5,-7,-10,-13,
-15,-17,-18,-17,-15,-12,-11,-11,-12,-11,-12,-8,-4,-6,-5,-6,-6,-6,-6,-7,-9,-10,-11,-10,-10,-10,-10,-9,-8,-9,
-10,-10,-10,-12,-9,-8,-8,-8,-10,-10,-10,-10,-11,-12,-11,-8,-12,-16,-17,-16,-11,-6,-5,-8,-12,-14,-16,-17,-18,-17,
-15,-13,-11,-11,-12,-11,-12,-8,-5,-6,-6,-6,-6,-5,-5,-6,-8,-9,-10,-10,-10,-10,-9,-9,-8,-8,-8,-6,-7,-9,
-6,-6,-7,-6,-8,-10,-11,-11,-11,-12,-13,-12,-14,-16,-17,-17,-13,-7,-5,-10,-14,-16,-16,-17,-18,-17,-15,-13,-11,-11,
-12,-11,-13,-8,-6,-7,-6,-6,-5,-4,-4,-6,-7,-8,-9,-10,-10,-10,-10,-9,-8,-8,-6,-3,-6,-7,-4,-6,-7,-5,
-6,-9,-11,-12,-11,-12,-14,-15,-17,-17,-17,-18,-15,-10,-8,-12,-15,-16,-16,-16,-17,-17,-15,-13,-12,-12,-12,-12,-13,-8,
-7,-8,-6,-6,-6,-4,-4,-5,-6,-7,-8,-9,-10,-10,-9,-9,-8,-7,-4,-2,-7,-7,-4,-7,-8,-5,-5,-7,-10,-12,
-11,-12,-14,-15,-16,-16,-17,-18,-17,-13,-11,-14,-16,-15,-15,-16,-16,-16,-14,-13,-12,-12,-12,-12,-13,-8,-10,-9,-7,-6,
-6,-4,-4,-4,-5,-6,-7,-9,-9,-9,-9,-9,-8,-8,-3,-2,-8,-8,-2,-5,-6,-4,-6,-7,-9,-11,-11,-12,-14,-14,
-15,-15,-17,-18,-17,-16,-14,-14,-15,-15,-15,-16,-16,-15,-13,-12,-12,-12,-12,-12,-12,-8,-13,-12,-8,-7,-5,-5,-4,-4,
-4,-6,-7,-8,-9,-9,-9,-9,-9,-7,-3,-3,-9,-9,-2,-3,-3,-4,-7,-9,-9,-11,-11,-11,-14,-15,-15,-15,-16,-17,
-18,-18,-16,-16,-15,-15,-15,-16,-15,-14,-12,-11,-11,-11,-12,-11,-12,-7,-16,-16,-10,-7,-5,-5,-4,-4,-4,-5,-6,-7,
-8,-9,-8,-8,-9,-7,-4,-4,-11,-11,-5,-6,-8,-8,-10,-10,-10,-11,-12,-11,-14,-14,-15,-15,-16,-17,-18,-18,-18,-17,
-16,-16,-16,-16,-15,-13,-11,-10,-10,-11,-11,-10,-11,-7,-17,-23,-13,-8,-6,-5,-4,-4,-4,-4,-5,-6,-7,-8,-8,-8,
-8,-7,-4,-5,-12,-12,-8,-10,-14,-12,-12,-12,-11,-11,-11,-11,-14,-14,-15,-15,-16,-16,-17,-17,-17,-17,-16,-16,-16,-16,
-13,-11,-9,-9,-9,-9,-9,-8,-8,-5,-20,-27,-19,-12,-7,-5,-4,-3,-3,-3,-3,-4,-5,-5,-6,-7,-8,-7,-5,-6,
-12,-14,-9,-9,-10,-11,-12,-12,-11,-11,-11,-12,-13,-14,-15,-15,-16,-16,-16,-16,-16,-16,-16,-17,-16,-13,-10,-8,-7,-7,
-8,-7,-6,-6,-5,-3,-20,-30,-25,-17,-10,-7,-4,-3,-3,-2,-2,-3,-3,-3,-4,-4,-6,-7,-7,-6,-10,-12,-11,-11,
-10,-12,-12,-11,-10,-10,-11,-12,-13,-14,-14,-15,-15,-15,-15,-16,-16,-16,-15,-14,-11,-8,-6,-4,-4,-5,-5,-3,-3,-2,
-2,-1,-22,-32,-28,-23,-17,-10,-5,-4,-2,-2,-1,-2,-2,-1,-1,-1,-2,-4,-5,-5,-7,-9,-11,-13,-13,-13,-12,-10,
-9,-10,-11,-13,-13,-14,-14,-14,-14,-15,-15,-15,-15,-13,-10,-7,-4,-2,-1,0,-1,-1,0,0,1,1,1,1,-24,-35,
-32,-28,-23,-17,-10,-6,-3,-2,-1,-1,0,0,0,0,0,-1,-2,-3,-3,-4,-6,-9,-9,-9,-9,-8,-9,-11,-12,-12,
-12,-12,-12,-12,-12,-12,-11,-10,-8,-5,-3,0,2,3,3,3,3,3,4,4,4,5,4,3,-24,-38,-36,-32,-28,-23,
-17,-12,-8,-5,-2,-1,-1,0,1,2,1,1,0,0,0,0,0,-2,-2,-3,-4,-6,-7,-8,-8,-7,-7,-7,-6,-7,
-6,-5,-3,-1,2,3,5,6,8,8,7,6,6,7,7,7,6,7,5,3,-22,-37,-38,-37,-33,-29,-24,-19,-16,-12,
-7,-5,-3,-2,-1,0,1,1,1,1,1,2,1,1,3,2,1,0,-1,-1,-1,0,-1,0,0,0,1,3,6,7,
8,8,9,9,10,9,9,9,9,8,9,8,8,8,6,3,-19,-35,-38,-40,-39,-35,-30,-25,-23,-20,-16,-11,-7,-5,
-4,-3,-1,0,0,0,0,0,1,1,3,4,4,4,2,2,2,2,1,2,3,3,5,7,9,10,10,10,10,9,
8,8,8,9,9,8,9,9,9,9,7,3,-17,-29,-33,-37,-39,-40,-37,-34,-29,-27,-24,-20,-16,-12,-9,-6,-5,-4,
-3,-2,-2,-2,-2,-1,0,2,2,1,0,0,1,1,2,4,6,7,8,8,8,8,8,8,8,7,6,8,8,9,
7,7,8,9,8,8,6,3,-15,-26,-29,-32,-34,-36,-37,-37,-35,-32,-29,-27,-25,-22,-18,-14,-10,-8,-7,-6,-5,-5,
-4,-3,-3,-1,0,0,1,2,4,5,5,7,7,7,7,8,8,7,7,8,8,7,7,7,6,6,7,7,7,9,
9,8,6,3,-13,-23,-25,-28,-29,-31,-33,-35,-36,-35,-33,-31,-28,-26,-24,-22,-17,-14,-11,-10,-8,-5,-4,-3,-3,-1,
1,1,3,5,6,7,7,7,7,6,7,8,8,8,8,8,7,7,6,5,5,6,6,7,8,10,10,9,7,5,
-10,-19,-21,-24,-25,-28,-29,-30,-31,-32,-31,-30,-28,-27,-25,-24,-21,-19,-15,-11,-8,-6,-4,-2,0,2,3,4,5,6,
7,8,8,8,8,7,7,7,6,7,6,6,5,4,4,4,5,6,5,7,7,8,10,10,8,5,-9,-16,-17,-20,
-21,-24,-25,-26,-27,-28,-28,-27,-25,-25,-23,-22,-20,-19,-17,-14,-10,-8,-5,-2,0,2,4,6,6,7,7,7,7,7,
7,6,5,4,4,4,3,3,3,3,3,3,4,4,5,6,6,6,8,9,9,7,-3,-8,-8,-11,-11,-12,-13,-14,
-14,-14,-14,-14,-14,-14,-14,-13,-13,-12,-11,-9,-8,-7,-5,-3,-2,-1,1,2,2,3,4,4,4,4,4,3,2,2,
2,2,2,2,2,2,3,3,3,3,4,4,4,3,5,6,6,4,5,8,5,4,4,3,3,2,2,2,4,6,
7,7,7,7,5,5,6,7,6,6,5,4,3,4,3,2,3,3,3,4,3,3,5,5,5,5,6,5,4,4,
4,5,5,5,5,5,5,2,-1,-2,-3,-6,-7,-4,7,10,7,4,3,3,1,0,-1,0,2,7,9,9,9,9,
9,8,9,8,7,6,4,2,0,2,3,2,0,1,2,3,5,5,6,8,9,8,8,9,8,7,6,6,7,6,
5,5,1,0,-4,-8,-10,-11,-11,-5,5,7,4,4,3,1,-1,2,4,4,7,11,12,11,10,11,8,7,8,9,
7,3,0,-1,0,1,2,1,0,0,0,1,3,1,2,5,9,10,9,8,8,8,6,5,5,4,4,3,0,-2,
-7,-10,-12,-10,-10,-4,4,4,3,2,1,1,4,7,6,7,7,7,4,2,1,1,2,1,0,2,2,0,-1,1,
3,4,5,5,5,3,2,3,3,2,2,3,4,6,6,4,4,5,5,5,5,4,4,2,-1,-5,-10,-12,-12,-8,
-6,-2,2,3,0,0,1,5,6,4,4,3,1,-2,-4,-4,-5,-5,-5,-5,-5,-5,-3,-3,-5,-6,-5,-2,1,2,
2,1,3,5,6,7,9,8,5,7,9,6,5,6,7,7,6,5,3,-1,-3,-8,-10,-11,-9,-8,-6,-1,-1,-1,
-4,-2,2,4,4,2,-1,-1,-3,-6,-9,-10,-10,-8,-8,-7,-6,-7,-5,-4,-4,-5,-5,-4,-1,1,0,0,1,2,
3,6,11,13,9,9,11,12,8,7,8,7,5,5,4,1,-2,-10,-10,-7,-4,-4,-4,-1,-2,-5,-3,1,-1,-3,
-2,-1,-6,-7,-11,-13,-13,-12,-11,-10,-8,-8,-7,-6,-4,-3,-3,0,1,0,0,0,0,1,1,0,1,3,7,12,
11,8,7,9,7,8,9,8,6,5,2,1,-4,-9,-5,-2,-3,-2,-2,-1,-4,-4,-1,0,-3,-3,-5,-9,-13,-14,
-16,-16,-13,-11,-10,-10,-8,-6,-3,-1,1,1,0,2,-1,-1,-2,-2,-3,-4,-4,-3,-3,-3,1,6,8,7,7,8,
7,6,5,6,6,2,0,-1,-5,-4,-3,-5,-8,-3,-2,-3,-4,-2,-1,-4,-6,-6,-10,-14,-16,-17,-17,-15,-13,-11,
-10,-8,-5,-2,-1,1,1,-2,-1,2,-2,-3,-3,-1,1,0,0,0,0,0,1,1,2,2,3,4,6,5,3,0,
-1,-4,-6,-9,-8,-6,-3,-5,-3,2,2,0,-2,-4,-4,-4,-7,-10,-14,-16,-18,-18,-17,-15,-12,-10,-7,-6,-2,-2,
-3,-2,-2,-5,-1,5,2,1,0,-1,-2,-2,0,0,1,1,1,2,3,3,3,1,-1,1,0,-2,-2,-3,-4,-6,
-5,-4,-1,-2,1,3,1,1,-1,-6,-6,-5,-9,-14,-18,-18,-19,-18,-17,-16,-13,-10,-7,-5,-5,-5,-5,-2,-5,-7,
-1,2,4,3,1,-1,-2,-2,-1,-1,0,-1,-1,0,1,3,4,4,2,1,-2,-5,-3,-2,-2,-3,1,-1,0,-2,
-1,-2,-3,0,-3,-9,-7,-8,-13,-17,-19,-19,-20,-19,-17,-15,-14,-12,-10,-7,-6,-6,-5,-4,-7,-6,1,1,1,2,
2,1,-1,-3,-3,-1,-2,-2,-2,-2,-1,1,3,3,4,3,1,-1,-1,-3,-3,-1,-2,-1,0,-1,1,-1,-3,-2,
-5,-8,-8,-11,-18,-19,-20,-20,-20,-19,-17,-15,-14,-13,-11,-8,-7,-8,-7,-7,-8,-3,3,-1,1,1,1,-1,-1,-2,
-4,-2,-2,-1,-1,-2,-1,-1,0,0,2,3,3,3,3,2,1,2,2,2,0,-1,1,0,-1,-2,-4,-8,-11,-15,
-19,-21,-22,-21,-19,-18,-18,-17,-16,-14,-13,-12,-11,-9,-8,-8,-8,-2,3,2,3,1,0,-2,-1,-1,-3,-2,-1,-1,
-1,-1,-1,0,0,0,1,2,2,3,4,5,6,6,6,5,3,1,2,0,-1,-1,-5,-10,-15,-17,-19,-20,-22,-22,
-22,-21,-20,-18,-18,-16,-15,-14,-11,-12,-10,-9,-9,-4,-2,0,2,2,0,-1,-1,0,-2,-3,-2,-3,-2,-2,0,0,
-2,0,4,3,3,3,4,5,6,7,8,8,6,5,3,2,-2,-1,-7,-12,-15,-17,-21,-21,-22,-24,-25,-22,-19,-18,
-19,-19,-17,-15,-12,-12,-9,-9,-10,-5,-2,-1,2,2,-1,-3,-1,0,-3,-3,-4,-4,-3,-2,1,2,-2,0,5,3,
3,4,6,5,5,5,8,9,7,6,5,3,-1,-1,-8,-13,-16,-19,-20,-21,-23,-25,-24,-23,-20,-20,-20,-20,-18,-16,
-12,-11,-10,-10,-9,-5,-3,-4,-1,-1,-1,-3,-2,-1,-4,-5,-6,-5,-2,-1,1,1,-3,-3,6,2,2,5,6,5,
4,5,5,7,8,7,6,5,3,0,-8,-14,-16,-18,-20,-21,-24,-26,-26,-24,-22,-21,-21,-20,-18,-16,-14,-13,-11,-8,
-8,-7,-3,-2,-1,-2,-2,-4,-3,-3,-6,-7,-5,-4,-2,-2,0,-1,-5,-5,6,2,2,5,6,5,5,4,4,7,
8,8,7,6,3,1,-9,-14,-16,-18,-20,-22,-25,-27,-28,-26,-24,-23,-22,-22,-20,-18,-15,-13,-13,-7,-8,-9,-5,-2,
-2,-3,-2,-2,-2,-5,-7,-7,-5,-3,0,-1,1,-1,-6,-5,6,3,1,5,6,5,5,4,4,5,7,9,9,7,
4,2,-9,-14,-16,-18,-20,-22,-25,-28,-28,-27,-26,-24,-23,-22,-22,-20,-16,-13,-13,-8,-7,-8,-4,0,-2,-3,-2,-2,
-2,-4,-4,-3,-3,-3,2,2,1,-3,-7,-5,5,1,0,4,5,2,2,2,2,3,6,9,10,7,4,1,-9,-14,
-16,-18,-21,-22,-26,-29,-29,-26,-25,-24,-23,-22,-22,-21,-17,-14,-13,-8,-5,-5,-3,1,-1,-2,-1,0,-1,-1,0,0,
-6,-5,1,3,1,-4,-7,-2,4,1,0,3,4,0,0,1,1,2,4,9,11,8,4,2,-9,-14,-16,-18,-21,-23,
-27,-30,-30,-26,-25,-24,-23,-22,-22,-21,-19,-15,-12,-7,-3,-3,-4,-1,0,0,0,0,0,-1,-2,-2,-4,-3,2,2,
-1,-5,-8,-2,4,0,-1,2,3,-1,-2,-2,-2,0,2,7,10,8,4,2,-8,-15,-16,-18,-22,-25,-28,-30,-31,-28,
-26,-25,-25,-23,-22,-21,-19,-16,-14,-8,-6,-4,-7,-4,-3,-2,-1,-2,-5,-7,-6,-5,-3,-3,2,-1,-4,-7,-8,-5,
2,-2,-4,-1,0,-4,-4,-6,-5,-3,0,4,10,6,6,1,-8,-15,-16,-18,-22,-25,-28,-30,-32,-29,-27,-26,-26,-24,
-22,-21,-19,-17,-14,-9,-8,-8,-11,-9,-9,-8,-6,-7,-10,-11,-10,-9,-8,-8,-3,-4,-6,-8,-9,-6,1,-4,-6,-2,
-1,-6,-5,-7,-6,-4,-1,2,8,4,5,0,-9,-14,-16,-18,-21,-23,-27,-31,-31,-28,-27,-27,-26,-24,-23,-22,-20,-17,
-14,-10,-9,-13,-16,-14,-13,-13,-14,-13,-12,-12,-13,-14,-16,-14,-10,-8,-9,-12,-13,-7,-1,-5,-6,-3,-2,-7,-8,-8,
-8,-5,-2,3,5,4,-2,-1,-8,-14,-16,-18,-21,-23,-27,-31,-31,-29,-28,-28,-26,-25,-25,-23,-20,-17,-16,-12,-12,-16,
-15,-11,-13,-14,-15,-16,-17,-17,-16,-15,-20,-17,-11,-9,-11,-15,-17,-9,-3,-8,-9,-6,-5,-9,-10,-10,-9,-7,-4,2,
3,1,-4,-4,-8,-14,-16,-18,-21,-23,-27,-31,-32,-31,-30,-29,-28,-27,-26,-24,-20,-18,-17,-12,-13,-16,-11,-7,-10,-12,
-14,-15,-18,-21,-21,-19,-19,-16,-11,-11,-11,-16,-19,-14,-5,-10,-12,-9,-8,-10,-11,-11,-11,-9,-6,0,0,-2,-7,-6,
-8,-14,-16,-18,-21,-23,-27,-30,-31,-30,-29,-28,-28,-28,-26,-24,-22,-20,-19,-12,-13,-14,-8,-5,-5,-7,-9,-11,-15,-19,
-22,-21,-18,-15,-12,-13,-11,-14,-19,-16,-4,-10,-13,-10,-9,-10,-10,-12,-11,-9,-6,-2,-3,-4,-9,-6,-8,-14,-16,-18,
-21,-23,-27,-29,-30,-29,-28,-28,-28,-28,-26,-24,-23,-21,-19,-13,-13,-11,-6,-5,-4,-5,-8,-11,-12,-14,-18,-18,-15,-13,
-11,-13,-12,-14,-19,-17,-5,-11,-14,-12,-10,-11,-12,-13,-12,-9,-7,-4,-5,-7,-10,-7,-7,-13,-16,-19,-21,-22,-26,-29,
-29,-29,-28,-29,-30,-29,-27,-26,-23,-22,-19,-14,-13,-8,-5,-6,-3,-4,-7,-10,-10,-10,-14,-15,-15,-12,-10,-11,-11,-12,
-17,-15,-5,-10,-12,-11,-11,-12,-13,-13,-12,-8,-7,-6,-8,-9,-12,-9,-7,-12,-16,-18,-21,-22,-25,-28,-30,-29,-28,-29,
-30,-30,-28,-27,-24,-24,-18,-15,-15,-9,-5,-5,-3,-4,-9,-11,-9,-9,-13,-14,-15,-14,-12,-12,-11,-12,-16,-13,-7,-9,
-11,-12,-11,-12,-13,-12,-9,-7,-8,-8,-10,-11,-15,-10,-6,-10,-15,-17,-20,-22,-25,-27,-29,-29,-29,-30,-30,-29,-28,-27,
-24,-24,-19,-15,-15,-10,-8,-8,-9,-9,-12,-12,-10,-11,-12,-14,-14,-15,-14,-14,-13,-14,-17,-14,-10,-12,-13,-14,-13,-13,
-13,-11,-9,-8,-10,-10,-12,-13,-16,-10,-6,-9,-12,-16,-20,-22,-24,-26,-25,-26,-27,-28,-29,-28,-26,-26,-25,-23,-18,-17,
-17,-12,-6,-9,-12,-15,-15,-15,-12,-11,-15,-15,-15,-15,-16,-16,-15,-15,-16,-16,-16,-15,-15,-15,-15,-14,-13,-11,-11,-10,
-11,-13,-13,-14,-15,-10,-6,-10,-9,-12,-19,-21,-23,-24,-26,-26,-26,-25,-26,-26,-25,-22,-22,-22,-19,-17,-19,-17,-11,-12,
-11,-15,-16,-15,-14,-15,-18,-17,-18,-17,-17,-17,-17,-17,-17,-18,-16,-15,-16,-16,-16,-17,-17,-15,-14,-14,-15,-15,-13,-13,
-14,-9,-5,-11,-8,-9,-14,-19,-22,-23,-25,-26,-26,-25,-25,-25,-24,-22,-21,-22,-19,-15,-19,-21,-15,-13,-13,-15,-15,-14,
-15,-17,-19,-18,-19,-19,-19,-19,-19,-17,-15,-15,-15,-16,-19,-20,-20,-20,-19,-17,-18,-17,-15,-14,-12,-14,-16,-10,-4,-9,
-8,-7,-11,-15,-20,-21,-23,-24,-25,-25,-24,-22,-20,-20,-20,-21,-20,-16,-18,-21,-17,-14,-13,-15,-15,-15,-18,-19,-19,-19,
-19,-19,-20,-19,-18,-17,-15,-16,-17,-18,-21,-23,-20,-18,-17,-17,-13,-14,-13,-14,-12,-13,-13,-6,-5,-9,-8,-7,-9,-12,
-16,-19,-21,-22,-22,-21,-21,-20,-19,-18,-16,-17,-18,-16,-17,-19,-14,-11,-15,-15,-15,-16,-19,-20,-19,-19,-19,-19,-19,-18,
-17,-17,-16,-17,-19,-16,-16,-17,-16,-15,-15,-16,-14,-14,-11,-11,-8,-5,-7,-4,-6,-8,-8,-9,-10,-9,-12,-16,-19,-20,
-21,-20,-18,-18,-18,-18,-16,-14,-14,-12,-12,-14,-13,-12,-16,-18,-19,-17,-17,-19,-19,-19,-19,-19,-18,-17,-17,-16,-14,-12,
-8,-7,-8,-9,-9,-11,-13,-14,-14,-13,-10,-11,-9,-4,-4,-4,-5,-7,-7,-7,-9,-8,-9,-12,-15,-17,-19,-20,-18,-16,
-16,-17,-15,-15,-13,-10,-8,-9,-9,-8,-11,-14,-16,-18,-18,-19,-20,-19,-18,-19,-16,-11,-8,-8,-6,-3,0,0,0,1,
1,-2,-5,-6,-9,-9,-9,-11,-12,-6,-6,-5,-4,-8,-7,-6,-9,-10,-9,-7,-9,-11,-14,-17,-18,-17,-16,-16,-15,-14,
-13,-13,-10,-9,-9,-6,-6,-9,-11,-12,-13,-13,-13,-14,-15,-14,-9,-4,-2,-3,-1,4,3,4,6,4,3,2,-1,-3,
-6,-10,-8,-7,-7,-5,-6,-3,-2,-3,-8,-7,-5,-5,-5,-7,-8,-8,-8,-11,-14,-16,-16,-15,-15,-13,-13,-13,-12,-10,
-11,-11,-12,-12,-11,-12,-14,-15,-13,-13,-13,-9,-3,0,-1,1,5,7,4,5,5,4,3,3,2,-2,-4,-11,-12,-10,
-9,-7,-7,-3,1,1,-3,-4,-5,-4,-3,-6,-7,-7,-8,-10,-12,-12,-13,-13,-12,-13,-13,-13,-12,-12,-13,-14,-15,-14,
-13,-13,-13,-14,-12,-10,-8,-6,-3,-2,-3,1,4,2,3,3,4,5,4,3,1,-3,-6,-10,-11,-13,-13,-11,-8,-3,
3,3,1,0,-3,-4,-3,-3,-4,-4,-4,-4,-7,-9,-9,-9,-8,-9,-9,-8,-8,-11,-12,-12,-11,-11,-10,-10,-11,-12,
-10,-8,-6,-6,-4,-3,-1,2,3,2,2,3,4,4,4,3,3,0,-3,-6,-11,-12,-13,-11,-9,-3,5,6,3,3,
2,-2,-5,-4,-3,-4,-2,1,1,0,0,0,-2,-3,-3,-1,-3,-7,-10,-11,-10,-10,-9,-9,-9,-8,-6,-4,-2,-3,
-2,2,6,7,7,6,6,6,5,5,5,4,3,2,-2,-4,-8,-10,-12,-12,-13,-6,8,10,7,4,3,2,-1,-2,
-4,-4,-3,1,2,1,0,1,1,0,0,0,-1,-1,-3,-5,-5,-4,-3,-3,-3,-2,-1,1,2,2,3,5,6,5,
6,6,6,6,5,5,5,4,4,3,-1,-2,-6,-9,-11,-12,-14,-7,6,8,6,4,4,3,2,1,1,1,2,4,
5,5,4,4,2,2,3,3,3,3,2,2,1,2,2,1,2,2,2,3,2,3,4,4,4,4,4,4,4,4,
4,4,5,5,4,4,4,1,-2,-3,-4,-6,-8,-5,6,8,5,3,2,2,0,-2,-2,-3,-4,-5,-5,-5,-5,-5,
-5,-6,-7,-8,-8,-7,-8,-8,-9,-8,-8,-7,-6,-6,-5,-5,-5,-5,-4,-3,-2,-2,-2,-1,-1,0,0,1,1,1,
2,1,0,0,-1,-1,-1,1,4,3,5,6,3,0,-1,-3,-6,-8,-12,-14,-16,-17,-18,-18,-17,-16,-16,-16,-18,-18,
-17,-16,-16,-16,-14,-12,-11,-10,-9,-9,-10,-10,-10,-10,-9,-9,-9,-9,-8,-8,-6,-4,-3,-2,-1,0,0,0,1,1,
-1,-2,-1,3,6,5,4,1,-3,-5,-9,-12,-15,-18,-20,-22,-23,-24,-26,-26,-27,-27,-27,-28,-29,-28,-25,-21,-17,-13,
-7,-5,-6,-7,-8,-8,-8,-8,-7,-7,-7,-7,-9,-10,-9,-8,-7,-6,-3,-1,1,2,2,2,1,1,-1,-3,-2,2,
5,5,-1,-4,-9,-14,-18,-21,-22,-24,-24,-26,-29,-29,-29,-28,-28,-28,-30,-30,-31,-31,-28,-24,-19,-13,-10,-8,-7,-7,
-8,-8,-8,-9,-7,-6,-5,-6,-9,-11,-11,-10,-10,-8,-6,-4,-2,0,1,1,1,1,0,-2,0,2,3,2,-4,-10,
-16,-20,-24,-26,-27,-28,-29,-29,-29,-26,-24,-22,-21,-21,-22,-22,-23,-24,-23,-23,-21,-18,-14,-13,-10,-6,-4,-4,-3,-3,
-3,-4,-5,-6,-8,-11,-13,-13,-12,-10,-8,-6,-5,-4,-1,1,1,1,0,0,3,3,1,0,-6,-13,-17,-20,-23,-25,
-28,-27,-30,-29,-27,-24,-22,-20,-18,-17,-16,-14,-13,-12,-12,-14,-15,-13,-10,-9,-6,-3,-2,-1,1,2,2,1,-2,-5,
-7,-10,-13,-14,-12,-9,-5,-2,-1,-2,-1,1,1,1,0,1,4,3,1,2,-8,-16,-18,-22,-26,-27,-30,-29,-28,-27,
-25,-24,-22,-21,-18,-16,-14,-12,-10,-9,-7,-8,-7,-5,-3,-5,-5,-3,-2,0,2,2,5,4,1,-2,-4,-8,-11,-12,
-11,-10,-8,-5,-2,-1,0,0,-1,3,5,7,9,5,2,1,-8,-16,-21,-28,-32,-30,-29,-27,-28,-27,-27,-25,-23,-21,
-18,-16,-14,-10,-7,-6,-5,-5,-2,2,2,3,4,4,4,6,8,8,9,10,10,8,4,0,-2,-2,-3,-4,-5,-5,
-3,-1,0,1,6,10,10,10,11,7,6,4,-9,-23,-28,-34,-33,-30,-31,-29,-29,-29,-29,-27,-25,-22,-17,-13,-10,-7,
-4,-3,-3,-3,1,5,7,10,12,11,10,12,13,13,15,16,17,17,16,14,13,13,12,8,3,0,-2,-2,2,7,
11,13,12,13,14,13,11,7,-14,-30,-33,-33,-32,-30,-30,-30,-31,-31,-30,-28,-24,-19,-14,-9,-6,-2,0,-1,-1,2,
8,13,12,12,13,13,13,14,15,15,15,17,19,20,20,21,22,23,22,21,17,12,9,8,11,14,13,14,13,14,
14,12,10,5,-20,-35,-33,-30,-31,-31,-32,-32,-34,-32,-30,-26,-21,-15,-9,-4,0,4,5,1,0,8,16,17,13,13,
14,14,13,13,14,14,14,16,18,20,20,21,22,24,26,27,25,22,20,19,18,17,16,16,16,17,15,14,12,7,
-22,-33,-30,-29,-31,-33,-34,-35,-35,-32,-27,-22,-17,-11,-5,0,4,6,5,-1,0,11,16,9,6,11,13,13,11,11,
12,12,12,14,17,19,20,21,22,23,25,26,26,25,24,24,23,22,21,20,20,20,18,16,13,7,-21,-30,-29,-30,
-32,-34,-36,-36,-34,-30,-24,-17,-12,-7,-2,1,4,6,2,-5,-1,10,10,3,4,9,12,11,9,10,11,11,12,14,
17,19,21,21,22,23,23,24,25,26,27,27,26,26,26,25,24,23,21,19,14,7,-19,-28,-28,-31,-34,-35,-36,-36,
-33,-27,-20,-14,-8,-3,0,2,4,6,-1,-9,-3,5,3,2,7,8,9,9,8,8,10,11,12,15,18,20,21,22,
23,23,25,26,25,25,26,27,27,27,27,27,27,26,24,22,16,9,-18,-28,-29,-32,-35,-36,-37,-35,-30,-24,-17,-11,
-6,-3,-1,1,4,6,-2,-11,-6,0,-6,-8,-3,0,4,6,6,7,10,12,13,17,19,21,22,22,24,24,25,25,
25,24,25,26,26,26,26,27,29,29,27,25,19,12,-18,-28,-30,-33,-36,-37,-36,-33,-28,-22,-15,-10,-6,-3,-1,2,
4,5,-3,-12,-9,-4,-12,-16,-13,-7,0,4,5,7,11,12,14,17,20,22,23,23,24,24,23,23,22,22,23,24,
25,25,26,27,29,29,29,28,21,12,-18,-29,-30,-34,-37,-36,-35,-32,-26,-19,-13,-10,-6,-3,-1,1,5,5,-1,-12,
-8,-5,-13,-13,-7,-6,-3,1,5,8,12,13,14,15,17,21,23,23,23,21,21,21,19,20,22,23,23,23,24,26,
28,30,31,30,23,12,-18,-29,-30,-35,-37,-36,-34,-31,-24,-18,-13,-10,-6,-3,-1,1,4,5,0,-9,-7,-3,-10,-8,
-2,-6,-4,2,8,11,13,13,13,14,17,21,23,23,22,18,18,18,18,20,22,22,23,22,23,24,26,29,32,31,
24,13,-18,-29,-30,-34,-36,-36,-33,-29,-23,-18,-13,-9,-6,-3,-1,1,4,6,3,-5,-2,0,-5,-4,-1,-5,-1,6,
12,14,14,12,11,13,16,20,23,23,18,12,14,15,16,18,20,20,21,21,21,22,24,27,31,32,25,13,-18,-29,
-31,-35,-36,-36,-33,-28,-22,-17,-12,-9,-5,-2,-1,1,4,7,7,3,6,8,4,4,4,2,6,10,12,12,11,9,
8,10,13,18,21,20,14,7,12,13,13,15,17,18,19,20,19,20,22,25,30,32,26,14,-18,-29,-31,-34,-36,-35,
-33,-28,-22,-17,-13,-9,-5,-2,-1,1,3,8,10,9,12,16,15,16,11,9,11,11,9,8,8,7,6,7,11,16,
19,17,10,7,9,11,10,12,14,16,17,17,16,17,19,22,28,31,25,14,-18,-29,-31,-34,-36,-35,-32,-27,-21,-17,
-13,-9,-5,-2,-1,1,3,7,11,12,15,20,21,23,16,14,13,11,8,7,7,7,6,8,11,15,18,15,9,7,
6,9,9,9,12,14,15,15,14,14,16,20,26,30,25,14,-17,-29,-30,-34,-35,-35,-32,-26,-21,-16,-12,-9,-5,-2,
-1,1,3,7,11,13,18,20,20,24,18,15,12,10,7,6,7,8,6,9,11,13,15,14,8,6,6,8,8,9,
10,13,13,13,11,12,15,18,24,30,26,13,-17,-29,-30,-34,-35,-35,-32,-26,-21,-16,-12,-9,-5,-2,0,1,3,7,
11,13,18,20,21,25,18,14,12,10,7,6,7,8,6,9,10,12,15,14,8,6,6,8,8,9,10,13,13,12,
11,12,14,18,24,30,26,13,-18,-29,-31,-34,-35,-34,-31,-25,-20,-15,-12,-9,-5,-1,0,1,3,8,11,12,16,21,
23,25,18,14,13,11,8,7,7,7,7,8,10,14,17,15,9,7,7,9,9,9,11,14,15,14,13,14,15,19,
26,30,25,14,-18,-29,-31,-34,-36,-34,-31,-26,-20,-15,-11,-8,-4,-1,0,1,3,8,10,10,14,18,18,18,12,10,
12,11,9,9,9,7,6,7,10,15,18,16,10,7,9,11,10,12,14,16,16,17,16,17,18,21,27,31,25,13,
-18,-29,-30,-34,-36,-35,-31,-26,-20,-15,-11,-7,-4,-1,0,1,4,7,7,3,7,10,6,6,5,3,7,11,12,12,
11,9,8,9,12,17,20,19,14,8,12,12,13,15,17,18,18,19,19,20,21,24,29,32,26,13,-18,-29,-30,-34,
-36,-35,-32,-27,-21,-15,-10,-7,-4,-2,0,1,4,6,3,-4,-1,1,-4,-2,-1,-4,-1,7,12,14,14,12,10,12,
15,20,22,22,19,12,14,15,15,18,20,20,21,21,21,22,25,27,31,33,26,13,-18,-28,-30,-34,-36,-35,-33,-29,
-22,-16,-11,-7,-4,-2,0,2,5,6,1,-9,-6,-2,-9,-6,-1,-5,-3,3,8,11,13,13,12,14,16,21,23,23,
22,18,18,18,18,20,22,23,23,22,23,24,27,29,32,32,25,13,-18,-28,-29,-34,-36,-36,-34,-30,-24,-17,-11,-7,
-4,-2,0,2,5,5,-1,-11,-8,-4,-12,-12,-6,-6,-2,2,5,8,12,13,14,15,17,21,23,23,23,21,21,20,
19,20,22,24,23,23,25,26,28,30,32,31,23,13,-18,-28,-29,-32,-35,-36,-35,-32,-26,-19,-12,-7,-4,-1,1,3,
5,5,-2,-12,-9,-3,-12,-15,-11,-6,0,4,5,7,11,12,14,17,20,22,23,24,25,24,22,22,22,22,24,25,
25,25,26,27,30,30,30,28,22,12,-18,-27,-28,-31,-34,-35,-36,-34,-29,-22,-14,-8,-4,-1,1,3,5,6,-2,-11,
-6,1,-6,-8,-2,0,4,6,6,7,10,12,13,18,20,22,22,23,24,25,25,25,25,25,26,27,27,27,27,28,
30,30,28,26,20,12,-18,-27,-27,-30,-33,-34,-35,-35,-31,-26,-19,-11,-5,-1,2,3,5,6,-1,-9,-3,5,3,2,
7,8,9,9,8,9,11,11,13,16,19,21,23,24,24,24,25,26,26,26,27,28,28,28,28,28,28,27,25,22,
16,10,-20,-29,-28,-29,-31,-33,-35,-34,-33,-28,-22,-16,-10,-5,0,3,5,6,2,-5,0,10,9,3,5,10,13,12,
10,10,11,11,12,15,18,20,22,23,24,24,24,25,26,27,27,27,27,28,27,26,24,23,21,19,14,8,-21,-31,
-29,-29,-30,-31,-33,-34,-34,-30,-26,-21,-16,-10,-3,1,4,6,5,-1,1,12,16,9,6,11,15,14,13,13,13,13,
13,16,18,21,22,22,23,25,26,27,27,26,25,25,24,24,22,20,20,20,18,17,13,7,-19,-33,-31,-30,-30,-30,
-30,-30,-32,-30,-28,-25,-20,-14,-8,-4,1,4,5,1,1,10,17,17,14,14,15,15,15,15,16,15,15,18,20,21,
22,22,24,25,27,27,26,23,21,20,19,18,17,15,15,17,16,14,12,7,-13,-28,-31,-33,-32,-29,-29,-28,-29,-29,
-28,-26,-23,-19,-13,-9,-5,-3,0,-1,-1,3,9,14,14,14,15,15,14,16,16,16,16,19,21,22,22,22,24,25,
23,21,18,12,8,8,10,12,12,12,12,13,13,12,10,5,-10,-22,-26,-32,-33,-30,-30,-28,-27,-27,-26,-25,-23,-20,
-16,-12,-9,-7,-4,-4,-3,-3,1,6,8,11,14,13,12,13,15,15,16,18,18,18,17,14,14,14,12,8,4,1,
-2,-2,1,6,10,12,11,11,13,12,10,7,-9,-17,-20,-25,-29,-29,-30,-27,-27,-25,-24,-23,-21,-20,-17,-15,-12,-9,
-7,-6,-4,-4,-2,2,2,3,6,7,6,7,9,9,10,11,11,9,5,1,-1,-1,-1,-3,-3,-3,-2,0,1,2,
6,11,10,8,9,5,4,3,-8,-17,-19,-21,-24,-25,-28,-30,-29,-26,-24,-22,-20,-19,-17,-15,-13,-11,-9,-8,-6,-7,
-6,-4,-2,-5,-4,-1,0,1,2,3,6,5,2,-1,-3,-7,-10,-10,-9,-8,-6,-3,-1,1,2,1,-1,4,6,7,
7,3,0,0,-6,-13,-17,-20,-22,-22,-25,-25,-29,-28,-26,-23,-20,-18,-17,-16,-14,-13,-12,-11,-11,-13,-15,-12,-9,-8,
-5,-1,0,0,2,4,4,3,-1,-4,-6,-8,-11,-12,-10,-8,-4,-1,0,-1,0,1,0,2,1,3,4,1,-2,-1,
-4,-9,-14,-19,-23,-24,-25,-25,-27,-27,-27,-25,-23,-21,-20,-20,-22,-22,-24,-24,-23,-22,-21,-17,-13,-11,-8,-5,-3,-3,
-2,-2,-1,-3,-4,-5,-7,-10,-12,-12,-11,-9,-7,-5,-4,-3,-1,1,1,1,1,2,3,2,-2,-3,-1,-4,-8,-12,
-17,-19,-20,-22,-21,-24,-27,-28,-28,-27,-27,-28,-30,-30,-31,-31,-28,-24,-18,-13,-9,-7,-6,-6,-6,-7,-7,-7,-6,-6,
-6,-7,-9,-11,-10,-9,-9,-8,-6,-4,-2,1,1,1,1,1,1,0,1,2,1,0,3,0,-3,-5,-8,-11,-14,-16,
-19,-20,-22,-23,-24,-25,-25,-25,-25,-26,-28,-28,-25,-21,-17,-13,-7,-5,-5,-6,-7,-7,-7,-7,-7,-7,-7,-8,-9,-9,
-9,-8,-7,-6,-4,-1,0,1,2,2,1,0,-1,-1,0,2,3,3,4,5,2,0,-1,-3,-5,-7,-12,-14,-16,-17,
-17,-17,-17,-16,-16,-16,-18,-19,-18,-17,-16,-16,-14,-11,-9,-9,-8,-8,-9,-10,-10,-10,-9,-9,-9,-9,-8,-8,-6,-5,
-3,-2,-2,-1,0,0,1,0,-1,-1,0,3,5,4,6,7,5,3,3,2,0,-2,-2,-4,-5,-5,-5,-5,-5,-5,
-6,-7,-8,-8,-8,-8,-8,-8,-9,-8,-7,-7,-5,-5,-5,-4,-5,-5,-4,-3,-2,-2,-2,-1,-1,-1,-1,0,1,1,
1,1,1,0,-1,-1,0,2,3,3,-13,-19,-15,-15,-15,-16,-14,-13,-12,-12,-13,-11,-10,-10,-7,-3,0,5,7,9,
10,10,11,10,9,4,-2,-6,-7,-6,-7,-8,-8,-8,-9,-14,-18,-19,-20,-20,-21,-22,-22,-23,-24,-23,-23,-22,-20,-13,
-4,1,15,22,30,16,-19,-29,-27,-26,-25,-24,-22,-21,-20,-18,-15,-12,-8,-3,3,7,15,19,21,22,23,22,19,15,
5,-1,-8,-12,-14,-14,-14,-15,-15,-15,-14,-15,-18,-19,-22,-23,-26,-30,-33,-35,-36,-37,-37,-35,-29,-20,-4,11,29,38,
48,36,-20,-29,-26,-26,-25,-23,-19,-16,-11,-6,0,6,14,21,26,29,29,29,27,25,22,18,12,8,8,1,-5,-8,
-8,-9,-11,-13,-15,-17,-16,-15,-13,-12,-10,-10,-12,-16,-22,-30,-34,-36,-36,-33,-25,-20,-1,19,37,45,55,39,-20,-29,
-27,-27,-26,-22,-14,-6,2,10,20,30,37,41,41,39,32,30,27,23,18,13,12,15,15,8,1,-2,-3,-5,-9,-9,
-9,-10,-11,-14,-17,-17,-15,-13,-11,-12,-13,-17,-23,-30,-31,-24,-18,-9,12,31,44,55,63,40,-17,-28,-27,-25,-21,-15,
-5,4,18,27,38,45,46,42,36,31,27,26,23,21,17,13,13,16,20,17,12,8,6,3,0,1,0,-1,-1,-3,
-7,-13,-16,-18,-17,-15,-13,-11,-12,-17,-23,-23,-15,1,24,37,49,60,66,42,-20,-27,-21,-14,-7,-1,10,21,36,40,
44,41,36,32,27,24,21,21,20,18,15,12,12,14,16,17,16,12,8,5,5,6,7,7,8,7,1,-7,-10,-9,
-15,-18,-22,-21,-15,-11,-10,-9,-7,11,33,45,57,62,64,39,-18,-21,-10,0,8,19,29,36,39,37,33,27,22,18,
16,13,11,11,10,7,3,2,6,9,7,8,8,7,6,4,2,2,4,5,9,14,11,3,1,3,-1,-4,-10,-14,
-15,-14,-7,-1,10,30,44,53,61,61,59,36,-14,-15,0,14,24,34,38,36,30,24,18,14,12,9,7,6,5,5,
3,-2,-7,-7,1,3,0,0,0,1,2,2,2,2,2,1,5,12,13,8,9,13,13,9,3,-3,-8,-9,-3,6,
23,41,52,56,59,58,54,30,-9,0,11,26,38,40,31,23,18,15,11,7,4,2,0,-1,-2,-4,-5,-8,-10,-7,
0,3,-7,-9,-9,-6,-4,-4,-2,-2,-1,-1,0,3,4,5,7,10,13,17,18,15,10,5,8,20,35,46,54,58,
60,55,49,28,-1,14,27,37,37,29,20,15,12,9,5,1,-3,-5,-6,-7,-7,-8,-10,-12,-10,-7,-4,-2,-6,-9,
-12,-12,-12,-9,-6,-4,-3,-2,0,2,3,4,4,5,7,11,15,19,24,24,26,32,38,45,49,51,50,45,40,22,
9,28,37,37,28,18,13,11,7,3,-3,-7,-10,-12,-14,-15,-17,-17,-17,-16,-11,-11,-12,-8,-5,-7,-9,-12,-15,-14,
-10,-6,-5,-4,-3,-2,-1,0,2,3,5,6,8,14,23,31,35,39,37,39,38,39,40,38,35,20,19,37,36,26,
17,13,10,7,2,-3,-9,-13,-16,-20,-23,-23,-23,-23,-19,-15,-12,-14,-14,-5,2,-3,-8,-10,-12,-14,-14,-9,-7,-6,
-5,-4,-4,-3,-2,-2,0,4,6,8,14,22,28,30,30,30,29,29,29,28,27,15,23,38,29,16,11,10,7,2,
-4,-9,-14,-18,-23,-26,-28,-26,-24,-22,-14,-9,-12,-16,-12,0,5,0,-7,-9,-10,-14,-18,-15,-10,-8,-7,-6,-6,-5,
-5,-5,-5,0,3,6,11,17,22,26,27,27,25,23,22,20,21,12,24,31,19,11,9,8,5,0,-9,-14,-19,-24,
-27,-29,-29,-27,-25,-21,-10,-6,-12,-17,-8,3,4,-1,-7,-11,-11,-13,-17,-18,-12,-10,-9,-9,-8,-6,-5,-3,-3,-2,
-1,2,7,10,16,22,25,25,24,22,20,18,18,10,22,20,11,8,7,6,2,-5,-13,-19,-26,-29,-31,-31,-30,-28,
-27,-20,-7,-2,-11,-16,-2,9,9,1,-7,-11,-12,-12,-16,-21,-16,-13,-10,-8,-6,-5,-3,-2,1,0,-1,0,2,5,
11,16,22,25,24,23,23,20,19,9,16,15,9,8,8,6,-1,-9,-17,-23,-30,-34,-35,-33,-31,-30,-27,-21,-7,0,
-10,-14,3,13,10,3,-5,-10,-13,-12,-17,-23,-16,-12,-9,-6,-5,-4,-2,3,4,-1,-4,-3,-1,1,5,9,18,23,
23,23,23,20,21,12,11,10,7,7,7,4,-5,-13,-20,-26,-32,-35,-35,-33,-31,-30,-28,-23,-11,0,-7,-10,6,10,
5,1,-1,-8,-13,-14,-19,-21,-14,-12,-8,-5,-3,-2,-2,2,7,-3,-6,-3,-2,-1,1,4,11,19,24,26,24,22,
22,13,8,8,7,7,5,1,-7,-14,-21,-27,-31,-33,-34,-32,-31,-30,-29,-25,-14,-2,-6,-10,2,6,3,-1,-2,-8,
-13,-16,-20,-17,-11,-8,-5,-3,-1,-1,-1,3,10,-1,-6,-4,-2,-1,0,2,6,15,22,26,26,24,23,14,6,6,
7,7,4,-2,-10,-17,-23,-29,-32,-32,-33,-33,-32,-31,-31,-27,-19,-9,-9,-12,-3,2,3,0,-2,-8,-12,-14,-15,-10,
-5,-2,0,2,2,-1,0,8,14,1,-7,-6,-2,0,0,0,3,10,18,25,27,27,26,15,5,6,7,7,3,-4,
-13,-20,-26,-32,-34,-34,-34,-34,-33,-33,-32,-28,-22,-16,-13,-14,-8,-2,-2,-4,-6,-8,-9,-8,-5,-1,-2,2,5,6,
5,1,3,12,16,3,-7,-5,0,2,1,1,2,7,16,24,27,27,27,17,5,6,6,6,1,-6,-15,-22,-28,-33,
-36,-35,-35,-35,-34,-34,-33,-30,-27,-22,-17,-15,-13,-8,-10,-10,-9,-9,-8,-5,-3,-2,1,7,7,7,7,5,6,10,
12,3,-5,-2,4,4,2,0,2,6,14,23,27,27,27,17,5,6,5,4,-1,-8,-16,-21,-28,-33,-36,-36,-36,-35,
-34,-33,-32,-32,-32,-29,-22,-19,-19,-18,-14,-11,-7,-6,-6,-6,-6,-6,-2,5,4,5,8,8,6,5,7,3,-3,2,
8,7,3,1,2,5,13,23,27,27,27,17,4,6,5,2,-2,-8,-14,-20,-27,-32,-35,-36,-36,-36,-35,-33,-33,-33,
-32,-31,-26,-21,-25,-26,-18,-13,-8,-6,-6,-6,-7,-9,-7,0,4,6,10,9,6,4,5,3,-1,5,12,8,4,2,
2,3,11,22,27,28,27,17,4,6,5,3,-2,-7,-14,-19,-27,-32,-35,-35,-36,-36,-35,-33,-33,-33,-32,-32,-27,-22,
-26,-27,-19,-13,-8,-6,-6,-7,-8,-9,-8,0,4,6,10,10,6,4,5,4,0,5,12,9,5,2,1,3,11,22,
26,28,27,16,5,5,5,4,-1,-7,-15,-21,-27,-32,-35,-35,-36,-35,-34,-33,-32,-32,-33,-29,-23,-21,-21,-20,-16,-12,
-8,-6,-6,-7,-7,-6,-2,6,5,6,9,8,6,5,7,3,-2,2,9,8,4,1,2,5,12,23,27,27,26,17,
5,5,6,6,1,-6,-15,-21,-27,-32,-35,-35,-35,-34,-34,-33,-33,-31,-29,-24,-18,-17,-14,-10,-11,-11,-10,-9,-7,-5,
-3,-2,1,8,7,8,9,5,6,10,12,4,-5,-2,4,5,3,1,3,6,14,24,27,27,27,17,5,5,6,7,
3,-4,-13,-19,-25,-30,-33,-33,-33,-33,-33,-33,-32,-29,-24,-17,-14,-14,-8,-2,-2,-5,-7,-9,-9,-7,-4,0,-1,3,
5,8,7,2,4,12,15,3,-7,-5,0,2,2,1,2,7,15,24,27,27,27,17,6,6,7,7,4,-2,-10,-17,
-23,-28,-31,-31,-32,-32,-31,-31,-31,-28,-20,-10,-9,-11,-3,2,3,0,-3,-9,-12,-14,-14,-8,-4,-2,1,3,3,0,
1,8,14,2,-7,-5,-1,1,1,1,3,10,18,26,27,26,25,15,8,8,7,8,6,1,-7,-14,-21,-27,-31,-32,
-33,-31,-30,-30,-30,-26,-15,-3,-6,-9,1,5,2,-2,-2,-9,-14,-16,-19,-16,-9,-7,-4,-2,0,-1,-1,3,10,-1,
-6,-4,-1,-1,0,2,6,14,22,26,26,24,23,14,11,10,8,8,8,4,-4,-13,-20,-26,-32,-34,-35,-33,-31,-30,
-28,-24,-12,-1,-7,-9,5,8,4,-1,-1,-8,-13,-14,-19,-20,-13,-11,-7,-4,-1,-1,-2,3,7,-3,-6,-3,-2,-1,
1,4,11,19,24,26,25,22,22,13,17,16,10,9,8,6,-1,-9,-17,-23,-30,-33,-34,-33,-31,-30,-28,-22,-8,-1,
-9,-12,2,11,8,1,-5,-10,-13,-13,-18,-23,-15,-11,-8,-5,-3,-3,-1,4,4,-1,-4,-2,-1,1,5,9,17,23,
24,24,23,21,20,12,23,22,13,9,8,7,2,-5,-13,-20,-26,-29,-31,-31,-30,-29,-28,-22,-8,-2,-11,-15,-3,8,
8,0,-8,-11,-11,-12,-17,-20,-16,-13,-9,-8,-5,-3,-3,-1,1,0,-1,0,2,6,11,15,22,25,25,24,23,20,
18,9,25,34,21,12,10,8,6,0,-9,-14,-20,-24,-27,-29,-29,-28,-27,-21,-11,-7,-12,-15,-8,3,3,-1,-7,-11,
-11,-12,-17,-17,-12,-11,-10,-9,-8,-6,-4,-3,-3,-2,-1,3,8,11,15,21,25,26,24,22,20,17,18,9,24,40,
32,19,12,10,7,1,-4,-9,-14,-19,-23,-26,-28,-26,-26,-23,-15,-10,-12,-15,-11,0,5,0,-7,-10,-10,-14,-17,-14,
-10,-8,-7,-6,-6,-5,-5,-5,-4,0,4,7,11,17,22,26,28,28,25,23,20,18,19,12,20,38,38,29,19,14,
11,7,2,-3,-9,-13,-16,-20,-23,-23,-24,-23,-19,-15,-13,-14,-13,-4,3,-2,-8,-11,-13,-15,-14,-9,-7,-6,-5,-4,
-3,-3,-2,-1,1,4,7,9,14,22,28,31,30,31,30,28,28,26,25,14,10,29,38,39,31,20,14,11,6,3,
-3,-7,-10,-13,-15,-16,-17,-18,-18,-16,-11,-11,-10,-6,-4,-6,-9,-12,-15,-15,-11,-7,-5,-5,-3,-2,0,1,3,4,
7,8,9,15,25,32,36,40,38,39,38,38,39,36,33,18,-1,16,29,38,39,30,20,14,12,9,4,0,-4,-6,
-8,-8,-8,-9,-11,-12,-10,-8,-4,-2,-7,-9,-12,-13,-13,-10,-7,-5,-4,-3,0,2,3,5,6,6,7,11,15,19,
25,26,29,34,39,47,50,51,50,44,39,21,-6,2,13,27,38,41,33,24,19,15,10,6,3,0,-2,-3,-4,-5,
-6,-8,-10,-8,0,2,-7,-9,-9,-7,-6,-5,-4,-3,-2,-2,0,3,4,4,6,9,12,16,17,15,11,7,12,25,
38,51,58,61,61,56,50,29,-11,-10,3,14,24,34,38,36,32,25,18,13,10,8,6,5,3,3,1,-2,-7,-7,
2,5,0,0,1,2,2,2,2,2,2,2,6,13,13,8,8,13,13,8,3,-4,-9,-11,-4,6,25,45,57,60,
62,61,57,33,-16,-17,-5,3,7,18,27,35,38,37,33,27,21,17,15,13,11,11,9,7,3,1,6,9,7,8,
8,7,6,4,3,3,5,6,10,15,12,4,1,3,-2,-6,-12,-16,-19,-18,-10,-3,10,32,49,58,65,66,63,39,
-19,-24,-17,-10,-4,0,8,18,34,39,43,41,36,32,28,24,21,21,20,18,14,10,11,14,15,15,15,12,8,5,
6,9,9,8,9,9,2,-6,-10,-10,-14,-19,-23,-23,-17,-13,-11,-9,-7,10,36,51,61,66,68,43,-16,-27,-25,-23,
-19,-13,-5,4,17,27,39,46,47,44,39,35,29,27,24,21,17,13,14,17,21,18,14,10,8,5,4,5,4,3,
2,0,-6,-12,-14,-16,-15,-14,-12,-11,-12,-17,-22,-23,-15,0,24,41,54,64,69,44,-20,-28,-26,-26,-24,-21,-14,-7,
0,9,21,31,38,42,42,40,34,32,28,25,21,16,15,18,20,13,6,3,2,-1,-3,-4,-5,-7,-9,-12,-14,-15,
-13,-11,-10,-11,-13,-17,-23,-29,-30,-25,-18,-9,11,33,50,60,67,43,-19,-28,-25,-26,-25,-23,-20,-16,-12,-7,-1,6,
14,22,28,31,32,33,32,31,29,25,20,16,15,7,0,-3,-4,-6,-9,-12,-14,-16,-15,-13,-12,-11,-10,-9,-12,-16,
-23,-29,-33,-34,-34,-31,-25,-20,-3,20,42,52,61,41,-19,-29,-27,-26,-25,-24,-22,-21,-20,-18,-15,-13,-8,-2,6,11,
20,25,27,29,30,29,25,21,11,4,-5,-10,-12,-12,-13,-13,-14,-14,-13,-14,-16,-19,-22,-23,-26,-30,-32,-34,-35,-35,
-35,-34,-28,-20,-6,10,31,43,53,38,-13,-19,-15,-15,-15,-15,-13,-12,-12,-12,-13,-11,-10,-10,-6,-2,3,8,11,12,
13,13,14,14,11,6,-1,-5,-6,-5,-6,-7,-7,-6,-8,-13,-17,-19,-20,-20,-21,-22,-22,-23,-23,-22,-22,-22,-20,-14,
-6,-1,14,23,32,17,5,7,4,6,3,0,1,1,-2,-1,-4,-9,-14,-16,-13,-13,-11,-10,-13,-15,-16,-18,-17,-16,
-20,-21,-21,-20,-17,-14,-11,-8,-6,-5,-2,3,7,11,13,11,17,17,16,17,17,18,19,19,18,26,33,40,49,50,
49,29,7,4,2,3,2,1,0,-1,1,-4,-12,-20,-26,-28,-28,-27,-23,-20,-25,-33,-36,-35,-31,-31,-28,-32,-34,-32,
-29,-28,-26,-24,-19,-19,-19,-15,-12,-7,1,7,14,20,24,25,25,27,26,24,34,42,53,65,74,74,73,44,0,1,
0,0,-2,-4,-6,-7,-6,-13,-22,-28,-31,-30,-25,-19,-14,-16,-23,-31,-34,-32,-27,-26,-40,-46,-46,-40,-37,-34,-33,-32,
-37,-34,-30,-28,-31,-32,-27,-21,-12,-5,4,10,15,19,22,25,36,47,61,77,78,73,67,38,2,1,-2,-2,-8,-14,
-22,-21,-20,-27,-35,-37,-34,-30,-25,-23,-25,-26,-25,-23,-25,-30,-29,-28,-37,-45,-49,-47,-45,-46,-47,-48,-49,-46,-44,-41,
-43,-43,-38,-33,-25,-18,-9,-1,8,15,19,25,37,52,71,79,73,65,55,29,3,-2,-7,-11,-21,-34,-41,-37,-34,-35,
-36,-34,-31,-30,-29,-28,-33,-32,-30,-28,-30,-34,-33,-30,-35,-38,-37,-33,-33,-39,-46,-50,-51,-53,-52,-49,-48,-45,-39,-34,
-25,-20,-15,-9,-2,4,15,29,40,54,70,68,63,53,46,27,-4,-6,-10,-18,-29,-42,-53,-51,-39,-43,-44,-38,-30,-24,
-22,-22,-19,-19,-18,-17,-18,-22,-23,-21,-29,-32,-27,-21,-22,-23,-24,-29,-38,-46,-54,-59,-57,-51,-45,-45,-37,-27,-15,-4,
0,-1,10,22,39,57,62,51,45,35,33,19,-3,-8,-18,-24,-31,-41,-48,-46,-37,-35,-30,-25,-21,-15,-7,-1,-2,4,
10,10,7,4,5,4,2,-3,-7,-11,-13,-12,-11,-15,-20,-30,-39,-50,-55,-52,-45,-42,-41,-38,-28,-12,-4,0,13,25,
43,54,48,36,28,23,19,11,-6,-17,-29,-33,-37,-41,-40,-36,-24,-17,-8,-3,1,5,7,7,6,8,11,9,9,9,
8,3,12,3,-5,-10,-10,-5,-2,-4,-3,-7,-11,-24,-36,-44,-48,-47,-42,-40,-32,-23,-14,-2,14,31,51,49,37,22,
11,7,7,0,-13,-31,-39,-39,-36,-34,-23,-11,-5,2,8,10,11,9,7,7,8,1,5,2,0,0,-3,-13,-1,0,
-1,-6,-6,-5,-4,-4,-2,1,5,2,-6,-11,-19,-30,-41,-47,-50,-41,-21,2,19,36,50,47,35,17,2,-3,-5,-1,
-17,-29,-33,-30,-25,-17,-9,-3,2,9,13,15,15,12,8,6,4,2,5,0,1,3,1,-8,-7,-7,-3,-3,-3,-3,
-2,-4,-3,-3,-1,0,0,2,-1,-7,-13,-22,-32,-37,-29,-10,10,28,40,33,18,3,-5,-7,-5,-1,-25,-31,-25,-20,
-13,-7,-2,3,6,12,15,17,19,17,11,8,5,5,7,3,6,7,4,-7,-13,-16,-10,-4,-1,0,0,-3,-1,-2,
-3,-2,-2,-1,-3,-6,-6,-7,-8,-13,-17,-11,3,16,15,9,1,1,3,4,8,9,-21,-27,-20,-15,-8,-4,0,7,
9,14,18,22,23,19,12,9,11,10,9,6,7,7,5,-8,-12,-17,-15,-10,-8,-5,-2,-4,-4,-3,-2,-3,-4,-6,
-8,-8,-7,-7,-9,-10,-8,-4,-2,-3,-1,-3,-3,4,6,10,19,18,-15,-23,-15,-8,-6,-2,3,10,14,19,24,26,
25,19,13,11,12,13,10,4,2,-1,-3,-14,-16,-18,-16,-13,-9,-6,-2,-4,-6,-4,-3,-4,-6,-7,-8,-9,-8,-6,
-7,-9,-10,-11,-13,-12,-12,-12,-8,-1,1,5,16,16,-15,-20,-8,-4,-7,-1,7,12,19,24,28,28,25,20,16,15,
16,18,12,3,-2,-8,-15,-25,-31,-24,-19,-15,-10,-8,-7,-7,-8,-8,-9,-8,-8,-8,-10,-13,-9,-8,-5,-3,-7,-12,
-16,-16,-18,-18,-13,-3,4,8,13,10,-18,-14,-7,-6,-4,2,13,20,26,28,29,28,28,25,21,21,21,20,15,-2,
-3,-12,-21,-27,-37,-31,-15,-12,-14,-12,-13,-12,-12,-11,-6,-3,-2,-5,-10,-14,-13,-9,-5,-3,-4,-9,-12,-12,-13,-12,
-13,-5,1,8,12,9,-17,-12,-9,-7,0,4,13,23,28,30,29,30,31,30,26,25,25,24,15,-5,-7,-14,-22,-29,
-36,-31,-16,-11,-15,-17,-17,-16,-15,-10,-2,0,-3,-7,-11,-13,-6,-9,-10,-8,-6,-6,-7,-8,-9,-7,-9,-4,1,9,
12,8,-14,-14,-12,-8,0,8,17,25,29,30,31,33,33,31,27,26,25,25,18,-1,-7,-17,-23,-21,-26,-24,-15,-12,
-19,-21,-19,-12,-12,-9,-1,0,2,-3,-9,-5,-3,-10,-16,-11,-10,-11,-11,-9,-6,-3,-5,-4,0,6,7,6,-11,-14,
-13,-8,0,9,19,26,32,34,35,35,32,30,28,27,25,27,20,0,-4,-11,-20,-19,-22,-19,-13,-14,-21,-21,-16,-9,
-8,-11,-6,-1,3,-4,-9,-4,-2,-13,-19,-12,-12,-14,-14,-12,-8,-3,-3,-2,1,6,7,6,-9,-14,-13,-7,1,12,
22,29,34,37,38,36,32,29,28,29,28,28,21,2,1,-2,-12,-15,-11,-13,-14,-15,-15,-12,-11,-9,-7,-11,-9,-3,
-1,-6,-4,3,2,-12,-20,-14,-14,-15,-14,-14,-10,-4,-2,-1,1,6,7,5,-9,-14,-13,-6,3,14,26,33,36,38,
38,35,31,28,28,28,29,25,19,4,2,1,-4,-8,-4,-7,-8,-8,-5,-2,-4,-4,-4,-9,-12,-11,-7,-7,0,9,
5,-8,-17,-15,-17,-17,-16,-16,-12,-5,-1,0,1,6,7,5,-9,-13,-10,-3,6,17,29,36,38,40,39,34,29,27,
26,27,27,23,18,3,-4,-3,6,8,3,2,3,2,-1,-3,-5,-4,-1,-8,-16,-18,-12,-8,-2,7,7,-3,-12,-15,
-20,-19,-19,-18,-14,-6,0,0,0,5,7,6,-9,-12,-8,-1,8,20,31,37,41,42,40,34,28,25,23,25,27,25,
18,2,-8,-3,20,27,22,12,4,-5,-12,-14,-13,-11,-4,-8,-19,-21,-15,-10,-3,7,5,0,-8,-14,-21,-22,-23,-22,
-16,-7,0,0,-2,3,5,6,-9,-12,-8,0,10,23,34,37,41,42,40,34,29,26,24,23,27,27,19,6,-4,-3,
25,22,10,1,-7,-11,-17,-20,-16,-14,-5,-6,-17,-22,-18,-13,-7,5,6,-1,-9,-11,-21,-27,-30,-26,-17,-10,1,0,
-2,1,5,4,-9,-12,-9,-1,10,23,34,37,41,42,40,34,29,26,24,23,27,28,19,5,-5,-6,22,19,6,-1,
-9,-13,-18,-21,-17,-16,-6,-8,-18,-23,-19,-14,-8,3,4,-3,-10,-12,-22,-28,-31,-27,-18,-10,0,-1,-3,0,4,3,
-9,-13,-9,-1,8,20,31,36,41,42,39,33,28,24,22,24,27,26,17,3,-9,-7,13,21,16,6,-2,-11,-18,-18,
-18,-15,-8,-12,-24,-26,-19,-15,-7,5,1,-5,-12,-17,-25,-28,-27,-25,-18,-9,-2,-1,-4,0,1,4,-9,-14,-11,-4,
6,18,29,35,38,39,37,32,28,25,24,25,26,24,18,5,-4,-8,-2,1,-3,-6,-5,-6,-10,-12,-15,-12,-10,-16,
-25,-26,-21,-17,-8,3,1,-9,-19,-22,-27,-27,-25,-23,-18,-9,-3,-2,-4,1,2,3,-8,-15,-13,-7,3,15,26,32,
35,36,35,31,28,26,25,26,26,24,19,6,2,-4,-9,-11,-8,-13,-16,-17,-15,-13,-15,-14,-15,-20,-22,-21,-18,-17,
-8,2,-2,-16,-26,-24,-26,-25,-23,-22,-18,-10,-5,-3,-4,1,1,1,-8,-14,-14,-8,1,12,22,29,33,35,34,31,
27,25,24,24,24,23,18,2,-1,-6,-12,-13,-11,-15,-18,-23,-25,-22,-20,-18,-16,-20,-19,-15,-12,-16,-13,-6,-6,-21,
-29,-23,-23,-24,-22,-21,-16,-9,-6,-5,-4,1,2,1,-11,-14,-14,-8,0,10,19,26,31,32,32,29,27,25,23,23,
20,21,17,-1,-6,-14,-18,-17,-24,-22,-18,-20,-29,-29,-22,-16,-14,-18,-15,-12,-9,-14,-17,-13,-10,-22,-29,-22,-22,-23,
-22,-20,-15,-8,-7,-6,-5,1,2,3,-14,-15,-13,-8,0,8,16,24,28,29,29,28,27,25,21,20,19,18,14,-4,
-9,-19,-21,-20,-26,-28,-21,-19,-26,-27,-23,-17,-17,-14,-9,-10,-9,-13,-18,-14,-12,-19,-26,-21,-20,-20,-19,-16,-12,-7,
-8,-7,-5,1,2,3,-16,-12,-9,-8,-1,4,13,22,28,28,27,26,26,23,20,19,18,16,11,-7,-10,-18,-22,-26,
-30,-33,-23,-19,-22,-22,-22,-21,-20,-16,-10,-10,-13,-17,-21,-21,-16,-18,-19,-17,-15,-14,-14,-13,-12,-9,-11,-7,-5,2,
4,3,-14,-11,-6,-7,-4,2,13,20,27,27,26,25,23,20,15,15,14,12,10,-6,-7,-18,-24,-25,-36,-35,-22,-19,
-21,-17,-19,-18,-19,-19,-15,-13,-12,-15,-21,-24,-23,-18,-14,-12,-12,-15,-16,-15,-14,-13,-15,-9,-6,0,3,3,-11,-15,
-5,-3,-6,-1,6,12,20,25,27,26,21,15,9,8,9,11,7,-2,-8,-16,-22,-27,-36,-30,-28,-24,-17,-15,-13,-14,
-15,-16,-18,-18,-18,-18,-21,-23,-20,-19,-16,-12,-13,-16,-17,-15,-18,-21,-17,-10,-4,-1,3,2,-12,-18,-11,-7,-6,-1,
4,10,15,20,25,26,23,16,8,4,4,5,1,-3,-6,-11,-13,-20,-21,-25,-25,-21,-17,-14,-10,-12,-14,-13,-13,-15,
-16,-18,-19,-20,-19,-17,-16,-15,-13,-12,-12,-11,-13,-16,-14,-9,-8,-5,5,8,-16,-20,-16,-11,-6,-2,1,6,9,14,
19,23,24,18,9,4,3,2,0,-3,-2,-4,-7,-17,-21,-27,-24,-18,-16,-14,-11,-13,-13,-13,-13,-14,-15,-17,-18,-19,
-18,-15,-15,-13,-9,-3,-1,-1,-1,-7,-10,-4,-1,3,11,12,-16,-20,-18,-14,-8,-4,1,5,7,11,13,16,19,16,
9,4,-1,-2,-3,-6,-4,-4,-9,-18,-23,-26,-20,-12,-9,-10,-10,-13,-10,-12,-13,-13,-12,-11,-13,-15,-14,-12,-10,-9,
-9,-3,9,19,16,7,-4,-4,-2,1,5,7,-7,-13,-20,-21,-16,-10,-2,2,5,9,12,13,13,10,4,2,-1,-4,
-4,-9,-8,-9,-13,-20,-16,-17,-12,-10,-12,-12,-11,-12,-11,-12,-10,-10,-9,-6,-7,-11,-12,-18,-24,-26,-14,9,27,38,
47,37,19,4,-5,-5,-3,1,0,-7,-17,-24,-24,-22,-13,-3,0,4,7,8,8,6,3,3,3,-4,-3,-8,-9,-12,
-18,-26,-10,-10,-11,-13,-12,-11,-11,-11,-10,-7,-2,-4,-9,-11,-15,-22,-30,-34,-35,-26,-6,19,36,49,58,52,39,22,
7,1,0,1,3,4,-3,-11,-18,-25,-25,-21,-14,-9,-3,1,4,6,6,6,5,5,5,0,-1,-4,-7,-11,-2,-8,
-14,-17,-15,-10,-9,-9,-7,-9,-10,-20,-28,-32,-31,-29,-24,-25,-19,-12,-5,7,25,44,58,54,41,26,17,13,11,4,
3,7,4,0,-6,-17,-26,-27,-21,-21,-18,-14,-11,-6,0,4,1,7,12,8,4,0,1,0,-3,-7,-12,-16,-17,-14,
-12,-12,-15,-24,-31,-40,-42,-36,-28,-26,-30,-29,-21,-6,1,5,18,30,50,56,48,35,29,27,23,15,-1,4,5,3,
-5,-13,-23,-21,-16,-20,-22,-20,-15,-10,-9,-9,-6,-5,-5,-4,-5,-9,-10,-9,-18,-22,-17,-12,-15,-14,-12,-14,-21,-29,
-38,-42,-39,-33,-32,-35,-30,-23,-12,-2,3,2,11,26,44,61,63,50,43,36,37,22,6,3,1,0,-4,-9,-10,-5,
-1,-2,-5,-4,-3,-4,-5,-6,-11,-9,-6,-3,-4,-10,-10,-9,-16,-19,-17,-12,-12,-18,-24,-28,-32,-34,-33,-30,-30,-30,
-29,-28,-20,-18,-13,-8,0,5,16,32,44,59,72,68,60,51,49,29,2,4,3,4,0,-2,-2,6,11,8,3,2,
4,6,8,8,6,3,2,4,4,1,-1,-2,-12,-21,-25,-23,-22,-25,-29,-32,-32,-31,-28,-26,-30,-32,-29,-25,-19,-14,
-6,1,10,18,21,28,42,58,75,79,73,65,57,33,1,3,2,5,3,2,3,8,16,13,9,6,6,8,12,16,
19,15,6,-2,-5,-4,-1,-1,-16,-25,-25,-21,-20,-20,-20,-22,-29,-27,-22,-19,-22,-23,-18,-13,-5,2,10,15,19,24,
26,29,41,54,69,81,80,74,68,41,7,5,3,5,6,6,5,5,10,8,3,-3,-6,-4,-2,0,4,6,0,-7,
-11,-12,-11,-14,-13,-19,-23,-23,-22,-23,-23,-22,-17,-17,-15,-9,-4,1,8,14,18,23,26,27,27,30,30,28,39,49,
64,75,79,77,76,48,5,8,5,7,4,2,3,3,1,2,-1,-4,-8,-9,-4,-3,1,3,-1,-4,-5,-8,-9,-10,
-15,-16,-19,-18,-15,-13,-10,-7,-5,-3,1,6,10,14,16,13,18,18,18,19,19,20,21,21,21,30,40,48,55,52,
52,29,5,12,11,13,14,13,13,15,12,11,9,9,9,8,6,1,1,-2,-7,-10,-13,-16,-20,-24,-27,-26,-23,-19,
-16,-13,-11,-11,-11,-7,-2,6,14,17,19,21,21,21,21,22,21,23,23,23,22,20,21,18,23,25,31,14,9,15,
17,22,23,23,23,22,17,17,16,13,8,2,-7,-13,-18,-19,-24,-33,-42,-47,-48,-50,-46,-48,-48,-45,-39,-34,-29,-28,
-25,-20,-14,-6,3,11,16,17,22,27,32,35,37,39,39,36,40,38,32,32,38,43,51,40,9,15,19,24,22,21,
22,21,18,18,13,4,-7,-13,-20,-24,-30,-33,-39,-47,-55,-57,-55,-54,-52,-54,-54,-50,-44,-40,-39,-38,-34,-31,-27,-23,
-18,-12,-8,-7,-3,3,12,22,29,33,33,34,41,40,33,34,40,48,61,43,9,16,20,22,21,23,27,27,26,13,
-2,-11,-12,-12,-16,-19,-22,-23,-22,-24,-32,-39,-41,-43,-43,-46,-49,-50,-49,-49,-45,-41,-38,-33,-26,-22,-20,-18,-13,-8,
-11,-10,-7,-2,10,22,27,30,35,35,34,34,44,60,72,45,9,17,20,25,29,31,27,19,11,3,-4,-4,1,2,
0,-3,-8,-8,-7,-7,-11,-16,-22,-27,-33,-36,-42,-46,-48,-48,-44,-37,-34,-34,-31,-25,-21,-22,-14,-2,-2,-5,-9,-11,
-7,2,16,29,32,28,28,31,53,70,77,46,12,21,28,33,31,24,13,7,7,5,8,13,17,16,10,7,2,-1,
-6,-8,-8,-8,-11,-14,-15,-20,-26,-31,-34,-37,-37,-34,-32,-33,-34,-33,-28,-26,-25,-20,-10,-5,2,0,-5,-9,-1,11,
21,22,28,42,68,74,73,47,11,24,32,32,23,8,0,2,7,11,17,20,19,13,3,-6,-12,-12,-14,-17,-19,-19,
-20,-22,-24,-25,-25,-22,-20,-20,-23,-25,-24,-26,-29,-29,-26,-23,-21,-21,-18,-18,-14,-9,-6,-4,2,6,13,25,41,58,
75,72,68,44,12,26,25,15,6,3,4,8,11,11,11,7,0,-10,-18,-22,-23,-26,-27,-28,-33,-37,-40,-43,-40,-34,
-29,-26,-23,-19,-16,-15,-18,-19,-22,-26,-26,-22,-19,-18,-18,-17,-15,-15,-13,-6,0,4,22,36,49,60,70,64,62,36,
13,15,5,0,1,0,5,8,10,7,0,-10,-21,-29,-32,-32,-35,-39,-39,-37,-41,-44,-44,-50,-44,-33,-27,-24,-20,-17,
-16,-16,-17,-17,-13,-11,-14,-14,-10,-6,-12,-13,-12,-12,-13,-11,-3,11,26,41,52,57,56,50,48,29,10,7,-4,-6,
-3,0,6,6,5,-1,-9,-19,-27,-33,-36,-35,-34,-32,-33,-35,-33,-28,-30,-42,-34,-27,-24,-21,-17,-16,-17,-17,-17,-18,
-16,-15,-14,-9,2,10,9,5,2,1,1,5,13,21,28,34,36,38,40,39,39,22,2,-1,-7,-4,0,2,8,7,
1,-7,-16,-22,-25,-27,-27,-26,-23,-16,-19,-24,-15,-8,-16,-30,-32,-29,-28,-23,-16,-13,-15,-16,-16,-17,-17,-16,-17,-13,
-5,2,11,12,12,12,14,19,23,24,22,22,23,27,29,29,29,18,-1,-1,-4,3,7,6,8,6,-2,-8,-12,-13,
-13,-13,-12,-12,-8,-5,-12,-15,-1,-1,-16,-27,-28,-25,-26,-24,-18,-13,-13,-15,-14,-15,-15,-15,-15,-15,-13,-10,-6,2,
8,10,16,23,25,23,25,24,22,23,23,20,18,9,1,0,2,8,9,9,10,7,1,-2,-2,0,-1,-1,-1,-1,
-1,-4,-13,-7,10,0,-19,-25,-24,-21,-19,-19,-17,-11,-9,-11,-13,-13,-13,-13,-13,-13,-12,-10,-11,-4,1,6,13,22,
26,29,31,32,31,29,29,26,20,8,0,-1,5,8,8,12,14,10,7,6,9,11,10,9,7,5,3,-6,-17,-4,
17,4,-17,-22,-28,-23,-20,-19,-18,-11,-7,-8,-11,-11,-12,-13,-13,-10,-6,-1,-1,0,-2,-1,6,13,19,25,30,33,
31,29,29,26,22,10,0,3,8,9,10,14,15,15,17,19,22,21,18,15,12,10,5,-5,-19,-4,24,12,-12,-26,
-37,-28,-20,-19,-17,-10,-5,-4,-10,-11,-11,-11,-11,-6,-2,0,3,4,1,-1,2,6,10,15,18,23,26,27,26,21,
18,7,-1,3,9,10,12,17,20,21,25,26,27,26,23,19,16,14,10,-2,-18,-6,25,15,-10,-24,-28,-22,-18,-18,
-14,-6,-3,-4,-10,-9,-9,-8,-4,0,0,0,0,1,-1,-4,-4,-1,3,7,12,16,21,24,21,15,14,6,3,8,
9,11,14,20,26,28,32,34,34,32,29,24,20,17,12,4,-16,-5,29,18,-5,-17,-19,-15,-13,-12,-8,-4,-4,-6,
-14,-8,-6,-5,-1,0,-6,-8,0,-1,-5,-8,-8,-7,-4,1,8,13,18,23,25,19,14,7,3,9,11,14,16,23,
30,33,38,40,39,36,32,27,22,19,14,7,-11,-4,26,19,-1,-10,-17,-9,-2,-2,-5,-4,-5,-9,-14,-10,-6,-3,
0,-4,-12,-12,-2,-6,-10,-11,-10,-9,-7,-5,2,8,15,22,26,21,16,7,5,10,12,15,18,25,34,38,42,46,
44,40,36,30,25,21,18,13,-1,-2,20,18,3,-4,-4,1,4,-2,-7,-6,-8,-13,-14,-11,-7,-1,1,-6,-15,-14,
-1,-6,-12,-14,-12,-11,-10,-9,-4,2,11,20,26,24,19,9,7,11,12,15,19,28,37,43,48,51,49,44,39,33,
28,24,19,18,10,3,14,13,2,-5,-2,-1,-4,-10,-10,-9,-12,-16,-14,-11,-7,-2,2,-3,-15,-17,0,-3,-11,-16,
-14,-10,-8,-7,-7,-2,7,17,26,25,21,10,8,11,13,16,22,32,42,48,53,56,54,48,42,36,31,28,21,20,
18,10,9,4,-3,-6,-10,-9,-10,-12,-9,-10,-14,-16,-12,-9,-8,-5,2,0,-13,-17,2,1,-7,-14,-11,-4,-2,-3,
-9,-5,3,14,23,24,21,10,7,12,14,18,25,38,47,54,59,61,59,53,46,39,34,31,26,21,21,13,4,-2,
-1,2,-2,-2,-4,-6,-7,-10,-13,-14,-11,-9,-9,-8,0,2,-10,-15,8,8,-1,-9,-4,4,3,-1,-9,-6,1,12,
21,24,21,11,8,13,14,20,28,41,52,58,63,65,62,56,48,40,35,32,28,21,23,17,6,1,4,7,6,0,
-1,0,-3,-6,-7,-8,-7,-5,-7,-8,0,2,-9,-13,11,11,2,-4,3,10,6,1,-8,-7,-1,10,20,25,22,11,
8,13,14,19,28,41,52,59,63,65,62,56,48,40,35,32,28,22,24,17,6,1,4,6,5,-1,-1,-1,-5,-8,
-8,-9,-8,-6,-7,-8,0,2,-8,-12,11,11,2,-2,4,11,7,1,-8,-8,-1,11,21,25,22,11,6,11,14,17,
25,38,48,55,60,61,59,54,47,39,34,31,26,23,21,11,2,-3,-1,0,-5,-3,-4,-6,-9,-13,-15,-15,-11,-9,
-7,-4,3,4,-8,-13,9,9,1,-6,-1,8,6,0,-8,-6,2,13,23,25,22,11,7,10,12,16,22,33,43,49,
55,57,55,49,43,37,32,29,23,21,17,8,6,3,-3,-8,-12,-9,-10,-10,-7,-9,-13,-15,-9,-5,-1,2,7,4,
-10,-15,5,4,-4,-11,-8,0,1,-1,-8,-5,4,15,25,26,23,11,7,9,11,15,19,28,38,43,49,52,50,44,
38,34,29,26,21,17,8,0,11,11,0,-8,-3,-2,-4,-8,-6,-5,-9,-13,-10,-4,1,6,9,1,-12,-13,5,2,
-7,-12,-10,-5,-4,-4,-6,-2,7,18,28,28,23,11,5,10,12,15,18,25,34,38,42,45,44,39,35,30,26,23,
19,13,-3,-6,17,17,1,-8,-6,0,3,0,-3,-3,-5,-9,-10,-5,0,5,8,0,-11,-10,5,0,-7,-10,-9,-7,
-6,-6,-3,2,11,21,29,27,21,10,4,9,11,13,16,22,30,33,37,40,40,36,32,27,23,22,16,8,-11,-7,
24,21,-1,-12,-20,-11,-2,0,-1,-1,-3,-7,-10,-4,-1,2,6,2,-8,-7,4,0,-6,-8,-7,-6,-6,-5,3,8,
16,24,29,24,19,8,2,8,9,11,14,19,24,26,30,33,34,33,29,24,21,20,14,6,-15,-7,28,22,-3,-19,
-22,-17,-12,-9,-5,-1,-2,-5,-11,-4,-3,-1,4,5,-2,-3,5,3,-2,-5,-5,-5,-3,1,8,13,20,25,28,21,
16,8,-2,4,9,10,12,15,17,18,21,24,27,27,23,20,18,17,13,2,-16,-6,27,20,-6,-24,-28,-21,-16,-15,
-11,-3,0,-1,-7,-5,-5,-4,-1,4,5,4,5,6,1,-2,-1,1,3,8,13,17,22,25,24,17,15,7,-3,2,
8,9,10,12,13,11,12,16,20,21,19,16,14,12,8,-2,-16,-3,28,18,-7,-24,-36,-25,-17,-16,-14,-7,-3,-2,
-7,-8,-8,-8,-8,-2,4,5,8,9,3,0,4,6,8,14,18,22,25,26,26,20,17,7,-2,-3,5,8,8,11,
11,5,1,1,4,9,10,10,9,8,7,-4,-14,-1,20,10,-10,-17,-23,-18,-15,-15,-16,-9,-4,-5,-8,-8,-8,-9,
-9,-6,-1,4,5,5,2,1,6,12,16,21,26,28,27,26,26,23,20,9,0,-2,1,8,9,8,7,2,-5,-8,
-8,-5,-3,-3,-1,0,2,-1,-9,-4,13,6,-11,-18,-20,-16,-14,-15,-14,-8,-5,-8,-9,-9,-9,-9,-10,-10,-8,-6,
-6,0,3,6,12,17,21,23,23,25,24,24,25,21,17,7,-4,-5,-6,1,5,5,5,3,-6,-13,-18,-18,-17,-16,
-14,-12,-7,-3,-8,-11,2,4,-10,-19,-23,-21,-21,-20,-15,-9,-10,-12,-10,-11,-11,-11,-12,-11,-9,-7,-3,3,7,7,
11,16,16,12,16,15,14,16,18,15,15,8,-1,-5,-12,-8,-3,0,5,4,-2,-11,-21,-27,-30,-31,-29,-27,-22,-14,
-15,-20,-12,-5,-11,-22,-25,-24,-24,-20,-13,-10,-13,-13,-13,-14,-14,-14,-13,-10,-3,2,11,10,9,8,8,9,9,9,
9,12,14,19,22,21,23,14,9,3,-10,-12,-9,-4,3,2,0,-5,-13,-22,-30,-37,-39,-37,-35,-32,-31,-32,-29,-26,
-28,-35,-27,-23,-21,-17,-14,-14,-16,-15,-14,-15,-14,-12,-11,-7,2,7,5,1,-3,-7,-10,-6,2,11,17,24,27,29,
31,28,30,18,11,12,0,-8,-9,-9,-2,3,4,1,-5,-14,-23,-31,-34,-34,-36,-38,-37,-34,-37,-41,-41,-43,-39,-31,
-25,-22,-19,-16,-15,-15,-15,-14,-10,-9,-12,-15,-13,-12,-21,-22,-19,-18,-18,-12,-3,9,24,39,48,50,49,41,40,25,
11,22,20,8,-2,-8,-6,-1,1,2,2,-1,-6,-15,-22,-26,-26,-28,-27,-27,-30,-33,-35,-36,-36,-31,-27,-24,-23,-20,
-17,-15,-18,-19,-22,-26,-30,-29,-28,-28,-27,-25,-20,-17,-13,-4,4,8,26,39,51,59,65,56,53,32,12,23,28,25,
15,-1,-10,-9,-5,-1,3,6,7,2,-7,-15,-20,-19,-19,-21,-22,-21,-21,-23,-27,-29,-28,-24,-21,-23,-26,-28,-27,-30,
-35,-36,-36,-34,-30,-29,-24,-22,-16,-8,-2,1,6,10,18,30,47,61,74,68,63,42,14,23,28,28,23,15,4,-4,
-8,-9,-7,-4,-1,-2,-6,-8,-11,-15,-19,-20,-20,-20,-23,-26,-28,-34,-40,-43,-45,-48,-46,-43,-40,-41,-41,-39,-36,-35,
-32,-27,-18,-10,-1,1,-1,-6,1,13,25,28,34,49,71,72,71,46,12,21,23,24,24,22,17,8,-1,-10,-18,-20,
-17,-17,-21,-24,-28,-29,-28,-27,-30,-36,-41,-44,-49,-52,-58,-61,-63,-62,-56,-47,-43,-44,-40,-33,-30,-29,-20,-10,-9,-10,
-13,-13,-6,3,17,31,36,34,35,39,59,70,74,45,12,20,23,24,20,19,20,17,16,4,-10,-19,-23,-27,-33,-37,
-44,-45,-44,-44,-50,-56,-58,-57,-56,-58,-61,-62,-62,-60,-55,-50,-46,-41,-33,-28,-25,-21,-16,-11,-13,-10,-6,0,12,23,
29,33,40,40,40,41,51,64,71,43,10,18,22,27,25,23,21,16,12,11,7,-4,-15,-22,-31,-35,-41,-45,-51,-59,
-66,-69,-66,-63,-61,-63,-63,-58,-53,-48,-46,-45,-40,-35,-29,-24,-19,-12,-7,-5,0,7,18,27,32,36,37,37,45,45,
41,43,49,57,63,41,10,18,20,25,26,25,25,23,16,14,11,7,4,-1,-10,-15,-19,-20,-26,-36,-45,-51,-52,-54,
-50,-52,-52,-48,-42,-36,-32,-30,-27,-22,-15,-6,4,15,21,22,28,32,37,39,41,44,43,41,45,46,44,46,51,53,
56,40,6,14,12,14,15,15,15,16,13,11,8,8,9,9,7,3,3,1,-5,-9,-12,-16,-20,-24,-26,-25,-24,-20,
-16,-13,-11,-11,-11,-7,-2,6,15,19,22,23,24,24,24,25,24,25,26,26,25,26,27,27,32,31,34,16,10,16,
12,7,0,1,1,1,-1,-2,-2,5,10,11,13,15,18,22,18,14,10,2,-3,-8,-8,-12,-19,-23,-22,-21,-19,-17,
-14,-11,-3,0,0,4,5,5,2,2,3,3,4,7,7,10,11,24,30,40,40,40,15,6,12,9,3,-1,-5,-8,
-11,-12,-12,-6,1,8,13,20,29,37,51,59,60,57,48,32,18,6,-2,-11,-24,-34,-40,-44,-44,-43,-39,-34,-23,-13,
-4,2,0,-4,-6,-8,-7,-4,-2,0,1,3,18,30,47,61,55,45,20,6,-2,-1,-5,-9,-16,-21,-24,-23,-17,-12,
-7,1,15,34,55,71,84,93,94,92,93,92,80,61,30,8,-14,-29,-41,-48,-52,-57,-58,-55,-42,-26,-14,-8,-8,-11,
-16,-21,-24,-24,-21,-16,-12,-5,14,28,47,59,45,28,2,-11,-5,-8,-13,-14,-18,-20,-21,-14,-3,7,19,31,41,52,
66,79,84,90,94,97,100,100,97,92,69,44,24,6,-13,-22,-31,-42,-56,-68,-65,-48,-29,-20,-18,-17,-22,-27,-32,-35,
-30,-26,-21,-7,11,28,48,52,37,20,-7,-11,-11,-11,-11,-10,-11,-10,-4,11,27,29,29,31,36,42,50,58,65,69,
72,74,74,72,77,85,84,60,44,31,18,16,11,-4,-29,-46,-56,-51,-37,-26,-21,-21,-25,-29,-34,-36,-32,-32,-26,-11,
2,28,45,42,25,6,-15,-11,-6,-3,1,7,12,14,13,15,16,13,8,7,14,22,26,30,37,39,44,52,55,54,
64,79,69,50,41,34,29,37,38,24,2,-21,-39,-36,-25,-16,-15,-19,-20,-25,-31,-34,-30,-31,-22,-8,6,28,34,27,
9,-10,-23,-16,0,10,14,26,28,21,6,-4,-7,-10,-11,-5,4,9,12,16,19,24,32,37,38,36,42,49,45,30,
25,26,25,27,26,19,12,-1,-17,-23,-17,-7,-6,-11,-15,-21,-30,-36,-37,-31,-16,-6,9,19,18,12,-1,-9,-15,-11,
7,16,22,35,29,10,-10,-20,-23,-24,-21,-8,7,14,18,23,25,26,35,40,38,36,38,37,31,27,28,27,22,20,
21,21,15,12,2,-6,-5,1,-2,-11,-20,-25,-31,-36,-40,-30,-14,-2,8,13,18,13,7,5,-8,-11,6,21,28,27,
6,-12,-30,-38,-42,-30,-15,3,20,27,30,32,30,34,42,43,39,33,34,30,28,30,27,24,20,18,19,19,17,14,
10,7,6,4,0,-6,-21,-28,-33,-34,-31,-26,-21,-15,-7,3,22,25,20,12,-3,-11,16,35,26,4,-23,-39,-52,-51,
-39,-21,0,18,32,38,37,36,37,42,45,46,41,23,18,15,16,21,19,17,16,15,17,19,17,14,11,9,6,4,
0,-3,-9,-25,-36,-38,-34,-34,-32,-24,-18,3,28,30,22,10,-5,-9,20,36,10,-23,-48,-57,-59,-50,-30,-7,15,28,
36,40,38,36,39,41,42,45,36,12,8,7,10,12,10,9,9,8,11,15,14,13,11,10,8,7,4,2,-2,-10,
-21,-31,-39,-42,-32,-15,-7,10,22,23,20,11,-3,-9,24,22,-14,-40,-59,-65,-59,-40,-20,4,25,33,36,37,35,35,
35,36,39,40,21,2,10,13,12,9,4,2,-1,-2,2,7,8,9,10,9,7,5,1,-1,-3,-3,-6,-13,-19,-27,
-30,-28,-9,7,18,23,24,19,9,3,20,0,-36,-51,-65,-66,-55,-34,-11,11,31,38,40,38,34,33,32,31,36,33,
10,4,21,14,8,5,1,0,-2,-4,-2,1,-1,2,4,4,4,0,-5,-5,-7,-5,-5,-8,-13,-23,-33,-39,-24,-7,
10,23,25,21,14,6,4,-19,-48,-60,-72,-64,-49,-32,-4,18,37,45,46,42,34,31,30,29,34,31,8,8,22,3,
-5,-4,-4,-4,-4,-3,-5,-7,-9,-6,-2,0,-2,-9,-16,-14,-9,-8,-8,-10,-15,-24,-32,-36,-35,-25,-10,5,13,14,
10,3,-9,-37,-55,-66,-73,-64,-50,-27,4,24,40,46,46,40,33,30,27,27,31,28,7,3,11,-15,-18,-13,-4,0,
-3,-4,-9,-15,-13,-13,-6,-3,-7,-21,-29,-19,-12,-5,-4,-8,-13,-20,-28,-40,-41,-37,-28,-14,2,9,5,-1,-18,-49,
-64,-70,-73,-64,-53,-25,5,26,41,44,44,39,30,27,26,24,27,28,6,-4,-2,-25,-28,-22,-5,2,-6,-7,-9,-15,
-14,-15,-9,-3,-8,-24,-31,-19,-10,1,5,0,-6,-15,-26,-40,-43,-40,-37,-29,-11,0,0,-2,-27,-56,-68,-76,-75,-70,
-52,-26,4,23,36,41,40,35,28,23,20,18,19,22,8,-6,-2,-16,-23,-16,3,5,-6,-8,-11,-12,-14,-11,-6,-2,
-4,-22,-32,-17,-5,17,20,9,0,-10,-23,-35,-42,-44,-43,-34,-18,-4,-3,-3,-32,-60,-69,-76,-77,-71,-54,-29,2,21,
34,36,34,30,25,21,15,14,13,18,14,-3,-6,-7,-19,-11,7,8,-4,-10,-14,-12,-14,-8,-2,-1,-7,-26,-35,-19,
-5,24,29,10,0,-6,-19,-31,-43,-45,-44,-37,-23,-10,-6,-5,-33,-60,-68,-76,-77,-72,-56,-32,-3,18,29,28,26,24,
21,18,15,13,10,13,19,4,-9,-1,-2,-1,6,4,-5,-7,-11,-8,-10,-8,-5,-8,-15,-33,-40,-25,-12,21,28,9,
-2,-6,-16,-28,-43,-45,-43,-38,-27,-16,-11,-6,-34,-60,-67,-75,-75,-71,-57,-35,-8,11,21,20,18,18,17,15,12,10,
7,8,18,10,-6,4,14,3,-1,-3,-4,-2,-4,-2,-2,-13,-15,-14,-19,-33,-39,-27,-13,17,27,10,-3,-8,-17,-29,
-43,-44,-42,-38,-30,-20,-14,-7,-33,-59,-66,-73,-73,-68,-56,-34,-11,7,16,15,14,13,13,12,9,6,4,2,10,11,
1,13,13,2,-2,2,5,7,4,4,1,-16,-19,-15,-21,-35,-41,-31,-9,13,25,12,-6,-16,-22,-32,-43,-44,-40,-36,
-31,-23,-17,-9,-34,-59,-65,-73,-74,-68,-55,-35,-11,6,15,15,13,11,11,11,10,5,2,1,4,10,9,23,23,13,
10,13,10,7,4,4,-5,-19,-19,-15,-25,-40,-43,-34,-5,9,20,10,-11,-24,-28,-35,-43,-44,-39,-34,-31,-26,-19,-11,
-32,-56,-64,-75,-74,-67,-55,-37,-11,3,12,14,13,10,10,11,7,8,3,7,11,10,13,19,20,13,12,10,2,0,
-1,-4,-17,-23,-23,-18,-28,-44,-45,-31,-1,9,15,7,-12,-27,-32,-35,-43,-45,-39,-31,-31,-29,-21,-13,-31,-56,-64,-75,
-75,-68,-55,-38,-12,3,12,14,13,10,10,12,8,9,3,7,12,10,13,19,20,15,14,12,4,1,1,-3,-15,-20,
-21,-16,-26,-44,-45,-31,-1,9,15,6,-12,-26,-31,-34,-43,-44,-38,-30,-31,-28,-21,-13,-33,-58,-65,-73,-75,-70,-58,-38,
-13,5,15,16,14,12,11,12,11,5,1,0,3,11,8,21,21,13,13,17,15,11,7,8,-1,-12,-11,-9,-22,-38,
-41,-31,-3,10,21,11,-8,-21,-25,-33,-42,-42,-37,-33,-30,-23,-16,-9,-33,-58,-65,-73,-75,-70,-59,-38,-14,5,16,15,
15,14,13,13,10,5,1,0,7,9,-3,9,12,1,-1,3,7,9,9,10,6,-9,-11,-8,-17,-33,-38,-27,-5,16,
27,14,-2,-12,-18,-30,-41,-42,-39,-35,-29,-20,-14,-7,-32,-59,-66,-74,-76,-73,-61,-39,-12,8,19,19,18,19,17,15,
13,10,4,5,13,5,-13,-4,7,-1,-4,-3,-3,0,-1,2,3,-6,-7,-6,-14,-30,-35,-23,-8,21,31,13,2,-2,
-13,-27,-42,-44,-42,-37,-27,-16,-11,-6,-31,-59,-67,-75,-78,-73,-59,-37,-7,14,25,25,25,24,22,19,15,13,7,10,
14,-2,-16,-9,-10,-7,2,2,-5,-7,-10,-6,-4,-3,1,-1,-10,-29,-35,-20,-7,25,32,12,3,0,-12,-26,-42,-46,
-44,-37,-24,-11,-7,-5,-29,-58,-69,-77,-78,-72,-56,-32,-3,17,29,31,31,29,25,21,15,14,11,16,13,-6,-10,-13,
-25,-15,3,7,-3,-10,-14,-10,-10,-3,5,6,-2,-22,-30,-13,0,29,33,14,5,-1,-14,-27,-41,-46,-45,-35,-19,-6,
-3,-3,-23,-53,-68,-77,-77,-71,-54,-30,-1,18,31,35,36,32,27,24,20,19,17,21,10,-6,-4,-20,-29,-21,-1,4,
-4,-7,-10,-9,-9,-5,2,6,1,-17,-26,-11,2,23,26,14,6,-4,-18,-31,-41,-45,-43,-32,-14,-1,0,-1,-12,-44,
-62,-72,-74,-67,-55,-29,0,21,35,39,40,36,29,27,26,24,25,27,10,-2,0,-25,-30,-23,-7,1,-4,-6,-8,-12,
-9,-8,-1,4,-2,-18,-25,-13,-2,8,12,6,0,-11,-23,-38,-42,-40,-36,-26,-7,4,3,0,-1,-30,-53,-67,-73,-66,
-53,-31,-1,19,35,41,42,37,31,30,27,27,30,30,14,7,16,-12,-17,-12,-3,0,-2,-2,-7,-12,-8,-7,0,4,
0,-15,-22,-11,-5,1,2,-3,-8,-17,-26,-39,-41,-36,-27,-13,5,12,7,1,12,-8,-44,-60,-72,-65,-52,-39,-10,12,
32,40,42,38,32,30,29,28,34,35,15,13,26,10,-2,2,2,-1,-3,-1,-3,-5,-4,0,4,6,5,-1,-8,-7,
-1,-3,-4,-8,-14,-23,-33,-37,-36,-24,-10,7,14,16,11,4,26,10,-30,-48,-65,-68,-58,-40,-19,5,26,33,35,33,
31,31,31,31,36,37,17,9,25,21,13,13,10,5,1,0,1,4,4,8,11,11,11,8,3,2,0,-1,-4,-9,
-16,-25,-37,-45,-28,-9,8,22,25,20,12,6,30,31,-6,-35,-58,-67,-63,-47,-29,-4,19,28,32,32,30,30,34,36,
41,45,28,9,17,21,20,18,12,7,3,2,6,11,12,14,16,15,14,11,6,4,1,-2,-7,-15,-24,-32,-37,-36,
-17,1,14,20,22,16,7,2,27,44,17,-17,-44,-56,-62,-56,-39,-17,6,21,31,34,32,31,36,40,43,50,43,18,
13,16,18,20,15,13,13,12,14,18,18,18,16,14,12,10,7,4,-3,-12,-25,-35,-42,-45,-39,-24,-15,3,17,19,
17,8,-5,-8,23,44,33,11,-17,-36,-53,-54,-47,-31,-12,7,23,30,29,29,32,39,44,49,48,29,21,22,24,26,
22,19,18,17,19,20,19,17,14,11,7,4,-2,-7,-13,-29,-40,-42,-37,-36,-36,-32,-28,-6,23,28,21,10,-4,-8,
13,32,37,35,13,-7,-28,-39,-46,-38,-27,-12,4,13,17,21,20,26,36,41,44,38,38,38,35,33,29,24,20,17,
19,18,15,13,9,7,5,2,-5,-14,-29,-36,-38,-37,-33,-25,-18,-15,-12,-2,20,28,24,15,0,-9,9,23,30,40,
32,17,-3,-17,-25,-29,-29,-21,-9,-2,3,8,10,14,23,29,32,31,35,39,30,25,25,24,19,18,19,17,11,7,
-4,-12,-12,-7,-11,-21,-30,-35,-38,-40,-42,-31,-13,-1,5,8,17,19,16,11,-1,-5,0,14,19,30,29,22,10,1,
-3,-10,-17,-16,-11,-7,-4,1,3,9,18,24,27,25,32,43,41,27,20,19,17,19,18,10,3,-9,-24,-32,-28,-18,
-16,-20,-24,-29,-37,-40,-39,-32,-15,-4,11,17,17,19,11,-1,-10,-8,-10,-5,2,11,13,15,14,16,18,15,8,3,
5,9,12,14,20,22,27,36,40,40,53,70,64,47,35,23,16,27,30,17,-5,-28,-47,-48,-37,-27,-26,-30,-30,-33,
-37,-36,-30,-31,-22,-6,9,28,34,31,19,1,-16,-12,-13,-15,-16,-13,-11,-7,-2,10,22,24,25,29,32,35,40,47,
53,57,59,63,66,65,71,79,78,54,38,24,11,10,5,-9,-31,-49,-59,-55,-42,-32,-28,-29,-32,-34,-37,-36,-31,-31,
-25,-10,6,31,44,41,30,15,-7,-6,-7,-11,-18,-19,-23,-23,-22,-14,-5,4,13,24,35,46,61,73,79,85,89,94,
100,101,97,89,65,39,17,-1,-19,-27,-35,-46,-59,-69,-64,-49,-32,-25,-24,-23,-27,-30,-34,-34,-29,-23,-19,-6,11,32,
51,51,35,22,-2,-7,0,0,-4,-10,-19,-24,-28,-26,-18,-13,-8,-1,13,33,54,69,81,90,94,94,95,95,83,62,
32,6,-18,-34,-45,-49,-51,-56,-58,-54,-41,-27,-18,-13,-13,-14,-17,-21,-23,-22,-19,-12,-9,-2,16,31,51,59,40,24,
0,-11,15,13,7,2,-4,-9,-14,-15,-14,-7,0,7,13,22,32,40,54,63,67,64,54,37,21,9,-1,-13,-28,-38,
-43,-45,-44,-43,-38,-32,-23,-14,-6,-1,-2,-4,-5,-6,-4,-1,1,5,6,8,22,35,52,65,52,38,12,3,10,17,
14,9,2,2,2,2,-2,-2,-2,4,9,11,15,17,24,27,24,19,13,5,0,-5,-5,-12,-19,-22,-22,-20,-18,-16,
-13,-9,-3,-1,0,4,5,5,4,4,5,5,6,10,10,12,13,27,36,46,41,36,9,4,-12,-19,-12,-6,-9,-11,
-7,-12,-12,-11,-13,-19,-23,-27,-37,-46,-54,-55,-54,-51,-45,-37,-27,-18,-10,-2,4,7,11,16,20,22,23,26,29,31,
32,34,37,42,41,41,39,39,39,38,36,33,32,34,29,26,19,16,21,13,-17,-21,-16,-15,-18,-19,-16,-17,-26,-33,
-41,-48,-60,-76,-94,-103,-108,-108,-102,-92,-78,-59,-40,-24,-8,-2,1,0,-1,4,10,13,18,19,22,27,35,44,52,60,
63,64,63,61,61,58,52,47,42,37,28,22,18,17,17,3,-19,-23,-16,-17,-18,-22,-21,-25,-38,-48,-60,-74,-91,-108,
-118,-121,-113,-115,-115,-107,-89,-67,-37,-6,10,10,11,8,5,3,1,-2,-4,-6,-14,-15,-6,8,22,31,42,46,47,43,
39,36,32,29,27,18,6,-1,3,7,5,-3,-16,-21,-18,-15,-14,-19,-24,-32,-45,-52,-60,-69,-79,-87,-88,-89,-99,-102,
-105,-98,-76,-50,-22,6,11,12,20,32,38,35,24,12,1,-7,-23,-33,-33,-23,-8,4,17,25,34,39,37,32,29,26,
21,14,-3,-13,-14,-11,-11,-12,-16,-18,-11,-5,0,5,12,8,1,-9,-20,-28,-32,-32,-28,-25,-36,-42,-48,-49,-45,-37,
-14,16,13,8,12,27,41,47,41,32,16,5,-12,-27,-36,-31,-15,1,10,19,30,41,43,41,33,20,13,2,-14,-26,
-39,-44,-36,-20,-7,4,19,31,41,52,66,61,39,23,9,7,9,7,3,-1,5,3,7,11,11,9,19,33,31,21,
15,23,39,48,47,44,34,17,-1,-18,-31,-33,-22,-7,2,10,22,32,35,37,32,23,12,-7,-22,-41,-59,-68,-54,-25,
17,38,57,68,75,85,84,71,44,39,31,25,21,20,21,21,16,16,17,22,24,24,25,27,31,26,19,19,22,27,
31,33,25,17,5,-16,-27,-25,-20,-13,-2,8,20,26,28,27,21,17,-2,-22,-48,-68,-78,-76,-67,-32,30,63,85,93,
102,100,79,53,47,35,24,20,23,24,20,15,14,18,19,19,20,23,19,9,10,11,14,17,15,15,16,16,19,16,
14,5,3,8,8,5,1,2,5,11,16,12,3,-5,-25,-45,-65,-72,-71,-58,-46,-14,49,89,110,120,99,78,60,42,
20,12,9,16,23,22,20,21,20,32,32,28,22,35,36,14,12,21,21,14,9,4,2,2,-1,4,10,15,19,26,
36,41,31,26,17,6,-1,-3,-7,-20,-41,-51,-57,-43,-29,-16,5,4,68,116,123,104,76,58,34,15,2,6,13,21,
24,22,21,24,35,35,39,39,29,38,35,14,0,3,3,5,8,4,1,0,-4,-5,-2,2,3,8,19,25,34,40,
41,33,23,21,15,2,-11,-19,-18,-6,1,9,27,26,85,127,118,80,53,31,1,-7,-2,6,14,18,19,20,22,25,
28,26,38,36,18,21,12,-6,-17,-15,-14,-5,6,6,0,-5,-7,-11,-11,-7,-6,-3,3,6,11,21,32,38,39,42,
41,36,36,24,17,17,13,14,26,21,88,127,96,58,31,6,-13,-11,-8,1,7,8,8,9,12,15,15,23,42,27,
1,8,2,-9,-14,-14,-15,-12,-7,-5,-4,-8,-11,-18,-18,-13,-12,-12,-9,-8,2,6,12,19,25,32,40,45,44,39,
34,33,32,32,32,16,81,107,71,37,5,-11,-12,-12,-16,-9,-5,-7,-6,-5,1,7,12,30,49,20,-10,0,-4,-10,
-16,-16,-15,-10,-8,-8,-6,-9,-14,-21,-23,-19,-19,-20,-19,-18,-11,-7,-1,2,3,10,23,33,40,39,33,31,33,32,
30,15,72,86,48,19,-11,-21,-17,-23,-22,-18,-17,-17,-13,-10,-4,2,17,36,50,15,-14,-3,-12,-17,-14,-12,-12,-5,
-2,-6,-8,-9,-15,-25,-27,-25,-26,-27,-24,-21,-16,-12,-7,-6,-8,-6,3,13,20,29,32,33,34,29,29,17,56,62,
27,4,-15,-24,-25,-32,-34,-28,-23,-20,-14,-9,-2,5,17,36,50,7,-21,-6,-20,-14,1,2,-2,0,4,-2,-5,-2,
-16,-30,-32,-27,-28,-28,-27,-26,-20,-13,-16,-15,-13,-13,-10,-6,7,17,24,29,31,26,28,16,38,46,16,-2,-16,-26,
-35,-45,-40,-32,-24,-19,-11,-5,0,6,18,31,50,10,-22,-9,-24,-19,11,20,14,6,5,-3,-6,-5,-18,-33,-32,-26,
-26,-29,-28,-25,-16,-9,-17,-22,-21,-21,-16,-10,-6,4,12,20,27,25,28,13,28,30,9,-5,-18,-33,-43,-50,-44,-34,
-25,-18,-10,-5,-1,4,17,17,51,28,-24,-11,-27,-20,5,31,29,14,5,-2,-4,-8,-21,-33,-29,-29,-30,-33,-38,-32,
-13,4,-15,-23,-21,-23,-19,-21,-18,-10,5,16,25,28,28,15,24,26,9,-5,-22,-37,-45,-51,-49,-38,-28,-20,-10,-5,
-2,2,14,15,45,34,-14,-11,-25,-16,5,28,32,23,14,7,5,-1,-23,-30,-22,-25,-31,-38,-44,-37,4,13,-14,-21,
-17,-22,-21,-25,-26,-18,-3,10,22,26,28,16,22,26,11,-7,-27,-42,-51,-55,-52,-38,-26,-17,-7,-2,1,4,12,16,
37,39,6,3,-10,-8,3,22,31,28,20,11,3,-6,-16,-23,-17,-18,-24,-34,-45,-40,17,21,-9,-17,-13,-21,-24,-28,
-32,-25,-10,5,18,24,26,16,21,24,10,-9,-30,-47,-58,-59,-49,-32,-17,-8,-1,3,6,9,11,15,25,35,20,18,
12,7,12,26,34,31,22,9,-1,-4,-8,-11,-8,-12,-19,-35,-45,-40,17,25,-3,-16,-15,-22,-25,-28,-35,-28,-14,1,
17,24,24,13,20,22,8,-13,-34,-52,-63,-61,-46,-26,-9,-2,3,5,7,9,9,11,11,17,9,9,23,29,44,46,
38,22,12,7,2,1,-18,-8,-1,-8,-19,-35,-36,-27,5,25,2,-16,-16,-21,-27,-31,-38,-31,-16,-1,17,24,23,11,
19,21,5,-17,-39,-56,-64,-60,-45,-24,-7,-1,3,5,6,6,6,10,10,7,-9,-17,9,23,27,17,10,4,1,-2,
-9,-13,-33,-19,-7,-10,-21,-34,-31,-28,-9,21,4,-16,-16,-18,-27,-34,-42,-33,-17,-1,17,25,23,12,15,16,0,-19,
-42,-58,-63,-59,-44,-23,-6,-1,4,8,7,4,8,10,17,7,-15,-28,-2,-7,-15,-23,-21,-15,-16,-15,-19,-31,-40,-36,
-14,-6,-17,-28,-22,-32,-14,14,-2,-14,-13,-16,-27,-37,-45,-36,-17,-2,16,26,23,11,15,15,0,-20,-42,-58,-62,-58,
-43,-22,-6,-1,4,8,7,5,8,10,18,8,-12,-25,-1,-8,-15,-23,-20,-14,-15,-15,-19,-31,-40,-36,-11,-3,-16,-27,
-21,-30,-13,14,-2,-14,-12,-15,-26,-37,-46,-37,-18,-2,16,26,23,11,20,21,4,-19,-40,-56,-65,-58,-43,-22,-6,0,
4,7,8,8,8,12,12,9,-5,-15,7,21,24,17,11,4,1,-3,-11,-15,-33,-18,-4,-6,-18,-32,-30,-29,-10,21,
6,-15,-14,-16,-26,-33,-42,-33,-17,-1,18,25,24,12,22,22,6,-15,-35,-52,-63,-60,-43,-24,-7,-1,4,7,9,12,
11,14,14,21,15,9,19,26,43,45,37,21,13,7,1,-1,-16,-7,0,-6,-17,-33,-35,-30,3,26,5,-14,-13,-18,
-26,-31,-38,-31,-16,0,18,25,23,11,23,25,9,-10,-31,-47,-57,-57,-45,-28,-14,-6,0,4,7,11,12,16,27,37,
23,15,9,6,14,27,33,29,22,11,1,-2,-5,-6,-5,-10,-18,-32,-44,-41,16,27,0,-14,-13,-20,-24,-28,-33,-28,
-14,2,18,24,25,13,24,27,11,-7,-27,-42,-49,-51,-47,-33,-22,-14,-6,-2,1,5,13,17,38,39,5,-3,-12,-8,
3,21,31,28,20,12,5,-4,-13,-18,-13,-16,-22,-33,-44,-41,17,23,-6,-16,-12,-20,-23,-27,-30,-24,-10,5,19,24,
26,15,28,28,9,-5,-21,-36,-43,-47,-43,-33,-24,-17,-9,-5,-1,4,15,17,47,34,-15,-16,-25,-18,3,27,32,23,
15,9,8,0,-21,-27,-20,-22,-29,-36,-43,-38,4,15,-12,-21,-17,-20,-20,-24,-25,-17,-2,11,22,25,27,15,34,33,
8,-4,-16,-32,-40,-46,-39,-30,-23,-17,-10,-5,-1,5,18,19,51,26,-24,-14,-25,-21,3,28,27,13,7,1,-1,-6,
-21,-32,-27,-26,-28,-32,-36,-32,-11,6,-14,-23,-21,-22,-18,-20,-18,-9,6,17,24,26,27,14,47,54,19,-1,-14,-26,
-33,-41,-35,-28,-23,-19,-12,-6,0,7,17,31,49,9,-21,-8,-20,-16,11,19,12,6,7,1,-4,-5,-18,-33,-30,-24,
-25,-26,-25,-24,-16,-6,-15,-20,-20,-20,-15,-11,-6,4,13,20,25,23,25,12,65,75,34,5,-13,-23,-23,-29,-30,-24,
-21,-20,-14,-9,-3,5,17,38,51,6,-17,-1,-15,-6,4,3,-1,0,5,1,-4,-3,-17,-32,-32,-28,-28,-25,-24,-25,
-21,-12,-14,-12,-11,-12,-9,-6,8,16,22,25,26,21,24,13,79,103,62,23,-10,-20,-15,-21,-18,-14,-15,-17,-13,-10,
-5,1,16,37,50,15,-8,2,-5,-11,-9,-9,-9,-4,-1,-3,-4,-9,-15,-25,-28,-26,-27,-26,-23,-20,-16,-12,-7,-5,
-8,-6,2,11,17,25,27,26,25,22,22,13,84,120,88,48,8,-11,-10,-9,-14,-6,-4,-7,-8,-7,-2,6,9,30,
49,20,-4,6,3,-6,-12,-12,-12,-8,-5,-4,-4,-11,-14,-21,-22,-18,-18,-19,-18,-18,-12,-9,-3,1,3,9,19,29,
34,30,23,20,20,21,21,10,87,127,108,73,42,9,-13,-10,-5,4,8,7,5,6,8,11,12,22,40,26,4,10,
7,-5,-12,-12,-14,-10,-4,-1,-3,-9,-11,-18,-18,-13,-11,-11,-9,-8,1,3,9,15,21,27,35,41,41,31,22,20,
19,22,23,12,82,127,125,94,70,43,5,-6,1,9,15,17,17,18,20,23,25,22,34,32,16,18,12,-3,-13,-13,
-13,-4,8,7,-1,-6,-6,-11,-11,-7,-6,-4,1,3,8,17,27,32,33,38,41,38,37,21,8,7,3,5,17,16,
63,113,124,112,90,75,47,22,3,7,15,22,24,21,21,24,33,32,36,36,25,31,29,13,5,6,5,7,10,5,
1,1,-4,-5,-3,1,2,7,16,23,30,36,39,32,22,19,13,2,-7,-16,-19,-10,-5,2,19,21,41,80,105,122,
108,95,78,56,28,17,12,18,25,24,22,23,23,32,32,27,21,32,31,12,13,19,20,16,12,8,5,4,0,4,
10,14,20,27,35,42,35,32,23,11,2,-3,-10,-20,-37,-46,-55,-45,-30,-19,0,3,21,50,74,93,105,107,93,71,
60,44,28,23,26,26,22,18,15,19,20,20,21,24,16,5,9,9,12,16,15,16,17,16,19,17,13,5,7,10,
11,12,10,11,11,14,18,11,-2,-12,-27,-42,-61,-70,-69,-58,-43,-13,10,24,43,63,75,89,93,85,64,55,43,31,
23,20,20,20,16,15,16,21,24,23,21,25,28,20,13,14,19,26,32,33,25,16,-1,-19,-25,-24,-19,-8,5,14,
24,25,24,22,15,10,-7,-22,-45,-66,-75,-73,-59,-24,-7,-2,7,20,34,47,65,67,51,40,27,21,17,9,1,-6,
-1,-2,1,6,6,5,17,32,25,12,9,20,36,46,45,40,29,9,-9,-21,-31,-34,-19,2,10,16,24,31,32,35,
30,20,7,-10,-22,-40,-57,-63,-43,-15,-15,-16,-12,-8,-5,-2,6,4,-1,-7,-15,-22,-27,-29,-31,-33,-48,-55,-60,-59,
-51,-38,-14,12,7,1,7,25,39,46,39,29,11,1,-15,-28,-33,-26,-7,10,18,24,34,43,45,43,35,20,9,-3,
-16,-25,-38,-39,-24,-9,-15,-19,-16,-15,-15,-20,-25,-33,-47,-53,-60,-66,-73,-80,-83,-87,-98,-105,-112,-104,-77,-46,-17,5,
10,8,14,25,31,28,17,8,-3,-8,-22,-30,-26,-10,6,16,26,33,41,45,40,35,32,27,21,10,-7,-13,-11,-2,
2,-2,-17,-20,-15,-16,-18,-20,-20,-23,-37,-47,-58,-69,-82,-95,-103,-106,-102,-108,-111,-105,-88,-62,-31,-3,9,5,2,-2,
-3,-4,-4,-3,-1,-2,-10,-8,6,24,38,46,54,59,59,56,51,45,40,36,33,21,5,2,14,22,20,7,-15,-20,
-14,-13,-17,-17,-13,-13,-22,-29,-36,-42,-52,-66,-80,-87,-92,-94,-93,-89,-77,-57,-37,-24,-7,-1,2,0,-1,5,13,19,
23,26,32,41,54,65,71,76,78,79,78,77,77,72,64,58,52,46,34,31,33,35,33,15,-12,-19,-10,-5,-7,-8,
-4,-8,-9,-8,-9,-14,-17,-21,-30,-37,-45,-47,-47,-45,-41,-33,-22,-13,-7,3,10,11,15,20,25,28,29,33,38,41,
43,45,47,51,50,51,49,49,50,48,45,40,38,39,32,30,25,25,29,20,-31,-41,-39,-44,-38,-35,-33,-33,-27,-26,
-28,-32,-35,-35,-25,-16,0,7,12,15,19,23,25,24,23,26,31,36,33,26,19,10,6,4,-8,-17,-31,-43,-44,-44,
-35,-34,-37,-35,-31,-32,-31,-31,-32,-23,-14,11,14,34,27,7,-26,-41,-37,-36,-35,-32,-29,-33,-36,-45,-61,-74,-72,-56,
-33,-20,-9,-7,-9,-10,-5,11,32,42,50,44,50,66,74,73,70,64,58,52,30,5,-31,-54,-52,-45,-41,-35,-37,-40,
-38,-35,-35,-32,-30,-19,8,38,48,62,47,6,-16,-27,-20,-18,-18,-21,-28,-46,-57,-70,-84,-80,-66,-49,-26,-11,3,-2,
-6,-7,-13,-12,4,22,22,25,42,59,67,73,76,74,79,86,75,45,-2,-28,-32,-31,-18,-6,1,-5,-12,-17,-24,-25,
-22,-13,12,44,50,51,13,-22,-17,-18,-13,-16,-19,-36,-60,-75,-79,-71,-52,-30,-9,7,21,26,23,16,4,-5,-14,-20,
-23,-23,-30,-17,4,28,43,47,54,61,69,88,92,79,44,19,-5,-26,-21,-11,-1,-1,-12,-23,-25,-18,-12,0,23,56,
50,23,-28,-44,-13,-18,-9,-18,-35,-62,-68,-51,-29,-16,7,31,46,50,51,48,43,39,25,11,2,-3,-21,-36,-35,-13,
7,20,29,31,37,48,72,85,81,64,44,32,6,-25,-29,-16,-1,10,3,-11,-20,-21,-14,9,40,55,21,-33,-70,-59,
-19,-15,-1,-16,-32,-34,-24,-8,21,30,41,47,47,43,36,27,25,24,16,6,2,0,-25,-46,-37,-20,-6,7,10,1,
2,18,67,82,77,51,35,32,15,-11,-17,-18,-17,-2,-3,-8,-14,-13,-4,33,61,42,-18,-74,-95,-59,-9,2,-3,-15,
-4,8,15,19,45,50,48,38,29,21,11,5,-6,-17,-35,-49,-53,-57,-82,-92,-68,-63,-53,-42,-28,-24,-25,-16,16,25,
33,31,26,14,9,-4,0,-6,-3,7,11,5,3,9,37,67,65,6,-51,-83,-89,-60,-8,-5,-12,-11,9,20,31,42,
49,42,23,4,-6,-15,-26,-31,-41,-62,-83,-93,-90,-85,-98,-97,-83,-67,-43,-27,-19,-20,-18,-6,-8,-5,-2,-9,-13,-20,
-16,-20,-14,-7,4,13,25,33,41,59,78,75,45,-22,-71,-82,-67,-31,-9,-18,-25,-14,18,36,42,46,29,9,-19,-40,
-53,-60,-63,-63,-71,-82,-95,-85,-61,-62,-83,-98,-77,-52,-27,-10,0,-4,-9,-1,-8,-12,-14,-11,-10,-17,-24,-30,-24,-27,
-27,-18,11,40,55,66,59,33,-19,-69,-77,-64,-40,-17,-18,-25,-19,6,32,44,44,26,-2,-27,-55,-69,-71,-73,-74,-72,
-66,-73,-68,-43,-22,-26,-45,-66,-47,-29,-16,-4,6,5,-3,-4,0,-8,-13,-10,-11,-18,-25,-29,-31,-28,-25,-30,-26,-6,
9,19,10,-30,-75,-92,-76,-50,-22,-7,-27,-25,-7,25,41,39,28,-5,-32,-54,-73,-77,-72,-68,-64,-58,-48,-47,-31,-3,
4,-10,-18,-31,-21,-13,-6,7,20,23,17,10,7,-5,-14,-15,-15,-21,-28,-33,-47,-41,-25,-20,-24,-22,-17,-13,-15,-53,
-81,-81,-61,-31,1,10,-14,-1,15,30,35,26,7,-28,-47,-59,-68,-67,-60,-52,-42,-34,-36,-17,11,26,12,-14,-13,-10,
-12,-10,-2,19,35,39,35,29,19,5,-6,-9,-11,-17,-24,-31,-40,-41,-29,-17,-11,-5,2,5,-4,-38,-59,-65,-55,-28,
2,11,6,24,38,38,33,12,-14,-36,-51,-56,-56,-48,-39,-30,-22,-18,-18,9,41,42,9,-19,-10,-2,1,-2,7,29,
41,44,46,44,25,11,1,-2,-3,-7,-16,-26,-37,-41,-33,-26,-20,-7,6,12,-1,-25,-42,-61,-61,-42,-18,-4,21,32,
39,35,29,2,-29,-45,-50,-51,-41,-25,-12,-6,-6,-10,-5,21,60,52,6,-18,-4,1,15,10,22,43,48,51,57,53,
26,10,2,4,8,8,0,-13,-31,-39,-31,-23,-24,-17,-3,4,0,-18,-27,-44,-41,-32,-20,-3,30,46,50,39,19,-15,
-41,-49,-48,-37,-20,-5,5,9,5,1,9,30,80,61,0,-19,6,17,14,10,19,39,41,50,63,55,30,17,12,11,
14,20,19,16,-8,-19,-19,-18,-26,-26,-12,3,7,-6,-9,-21,-30,-32,-23,-7,36,53,55,41,14,-25,-44,-45,-37,-25,
-10,5,14,16,12,8,16,39,91,62,-11,-26,4,13,5,1,9,27,28,44,68,66,45,34,26,20,20,29,34,37,
22,3,-7,-11,-22,-24,-14,-2,9,-1,-1,-15,-29,-27,-17,-5,39,63,59,37,1,-31,-43,-33,-22,-10,5,19,26,22,
16,13,18,47,98,65,-15,-31,12,7,17,6,9,15,21,52,72,64,41,49,33,18,21,32,39,54,40,6,-13,-15,
-22,-24,-18,-5,2,-3,-2,-8,-17,-19,-19,-7,40,64,58,33,-3,-32,-39,-24,-13,-2,10,22,27,24,19,17,20,43,
89,63,-12,-20,22,15,31,9,-4,4,32,71,77,57,51,51,34,19,22,32,35,46,39,1,-15,-11,-18,-23,-20,-13,
-6,-10,-6,-10,-16,-14,-13,-5,42,67,57,31,-3,-30,-34,-17,-7,3,11,20,25,24,22,22,23,36,74,58,-3,-10,
24,26,28,3,-11,6,39,67,62,44,38,43,37,22,24,30,29,37,42,1,-11,-2,-10,-18,-18,-16,-9,-12,-7,-12,
-16,-10,-7,-2,46,69,58,31,-1,-27,-33,-17,-4,4,9,14,21,24,25,26,25,30,54,48,7,0,14,12,6,-6,
-5,19,42,47,31,16,4,31,40,28,26,27,26,38,44,9,-1,5,-5,-10,-12,-13,-5,-9,-7,-14,-18,-7,-1,2,
49,71,58,30,-2,-28,-36,-22,-7,0,3,7,16,22,25,26,21,18,28,28,13,20,13,-5,-6,-5,4,23,28,16,
-1,-9,-1,37,45,34,38,40,36,49,43,26,18,10,-4,-5,-9,-10,1,-6,-9,-19,-22,-6,3,7,49,70,55,26,
-5,-31,-40,-27,-12,-5,-2,2,12,20,25,27,25,15,10,8,13,31,14,-8,-6,-8,-9,0,4,-1,-10,-15,1,41,
47,44,59,65,51,53,46,45,39,19,-1,0,-5,-6,4,-5,-11,-23,-25,-7,5,10,50,72,52,21,-8,-32,-45,-31,
-11,-4,-4,0,11,23,29,31,31,20,10,6,15,9,-25,-10,9,-8,-11,-4,-3,-5,-14,-27,-15,31,58,59,64,71,
57,49,44,45,42,32,10,2,0,1,3,-5,-15,-27,-27,-7,6,11,50,72,52,20,-8,-32,-45,-31,-11,-4,-4,0,
12,24,31,32,34,21,10,6,14,5,-30,-12,6,-9,-12,-4,-3,-4,-10,-22,-12,34,62,63,65,71,59,50,44,45,
42,33,12,4,2,3,3,-5,-15,-27,-27,-7,6,11,48,68,54,27,-6,-32,-40,-26,-13,-6,-2,3,13,21,27,31,
29,16,7,4,10,28,11,-13,-10,-7,-11,-2,4,-1,-9,-10,10,52,60,55,67,73,58,58,47,47,43,21,3,6,
1,-2,3,-7,-11,-22,-25,-8,5,9,47,68,56,29,-3,-30,-36,-21,-7,-1,2,7,15,22,26,29,25,18,23,22,
10,16,6,-14,-14,-7,2,22,30,17,-1,-7,8,52,63,49,49,49,44,58,49,31,25,18,4,3,-3,-7,-1,-10,
-11,-19,-21,-6,3,7,44,66,56,30,-3,-30,-34,-18,-6,1,6,12,19,23,25,26,25,26,46,40,2,-5,3,-5,
-6,-10,-5,25,50,51,32,20,16,51,63,48,46,41,36,49,53,16,7,16,6,-2,-6,-11,-7,-14,-11,-15,-17,-7,
-1,2,41,65,55,30,-4,-32,-37,-21,-12,-3,7,16,22,22,21,21,23,33,66,50,-10,-15,13,6,14,-2,-11,14,
52,76,68,52,51,64,61,46,49,48,40,49,52,9,-5,9,1,-10,-13,-16,-14,-19,-13,-14,-16,-9,-7,-3,39,63,
57,32,-4,-36,-45,-31,-22,-9,5,18,23,20,16,15,19,40,84,56,-20,-27,10,-5,15,3,-4,11,43,79,82,63,
61,68,54,39,42,48,46,60,53,13,-8,-3,-9,-17,-19,-18,-15,-19,-13,-14,-16,-13,-13,-6,37,61,58,37,0,-36,
-52,-45,-33,-18,-1,14,21,18,12,9,13,42,94,63,-20,-35,2,-14,-1,0,10,21,31,60,76,68,49,61,50,36,
38,48,52,67,57,22,-4,-10,-17,-21,-21,-14,-9,-15,-10,-12,-16,-18,-18,-8,34,51,54,41,12,-30,-55,-59,-52,-37,
-17,-1,8,9,6,2,8,33,88,63,-12,-27,2,2,-6,-2,11,31,35,51,71,69,50,45,41,35,36,45,47,52,
42,20,1,-9,-21,-24,-19,-11,-2,-12,-9,-18,-26,-26,-20,-7,28,44,48,40,17,-21,-55,-67,-67,-52,-31,-13,-3,1,
-2,-6,0,23,79,63,2,-16,12,20,14,14,25,43,47,57,66,57,34,24,22,22,25,32,32,30,12,-1,-10,-16,
-27,-28,-20,-6,-1,-14,-15,-22,-29,-33,-27,-9,23,30,34,33,26,-4,-42,-66,-70,-70,-57,-38,-22,-15,-16,-21,-18,13,
57,57,14,-10,9,12,22,19,31,47,52,56,58,56,28,14,8,12,15,14,7,-4,-17,-28,-27,-25,-29,-24,-11,-2,
-9,-25,-30,-46,-41,-36,-27,-4,8,23,32,34,29,5,-28,-57,-75,-80,-76,-65,-52,-42,-35,-32,-30,-1,38,48,20,-9,
4,14,9,6,14,33,42,46,48,47,27,15,6,4,1,-4,-11,-18,-30,-37,-36,-32,-25,-12,3,13,1,-28,-44,-62,
-61,-45,-20,-4,-4,6,8,20,29,17,-6,-49,-74,-86,-93,-87,-76,-68,-59,-51,-51,-28,7,34,24,-3,2,10,4,0,
6,23,36,40,37,31,18,7,-1,-3,-7,-15,-22,-28,-35,-39,-33,-25,-18,-8,5,15,7,-34,-61,-66,-56,-28,8,18,
-6,-6,-9,11,29,27,14,-23,-56,-81,-101,-101,-93,-89,-85,-78,-68,-61,-36,1,14,3,-2,-11,0,0,1,10,20,23,
15,6,4,-6,-13,-11,-13,-21,-29,-34,-47,-44,-32,-27,-28,-21,-11,-7,-7,-48,-82,-81,-59,-24,15,22,3,2,-8,-4,
14,26,29,9,-24,-54,-86,-99,-100,-102,-104,-102,-92,-94,-79,-45,-17,-16,-28,-44,-25,-17,-11,-6,-1,-3,-11,-14,-7,-12,
-14,-11,-13,-22,-28,-31,-34,-35,-37,-42,-31,-2,14,21,9,-36,-88,-102,-83,-49,-7,8,4,12,3,-5,7,13,20,24,
8,-13,-45,-71,-86,-93,-97,-99,-106,-113,-117,-97,-68,-62,-75,-83,-67,-48,-28,-15,-10,-16,-22,-15,-19,-20,-21,-18,-19,-27,
-33,-37,-30,-30,-33,-27,1,30,47,61,52,17,-38,-82,-87,-68,-30,-5,-3,15,18,18,20,8,7,17,27,21,1,-22,
-36,-48,-59,-66,-79,-98,-116,-120,-109,-100,-110,-106,-94,-82,-60,-44,-39,-40,-37,-25,-25,-17,-11,-15,-16,-18,-10,-14,-6,3,
9,9,15,21,35,59,76,63,23,-43,-89,-96,-67,-26,-8,10,16,14,22,19,9,0,18,25,24,14,3,-8,-21,-29,
-44,-55,-71,-82,-82,-82,-103,-113,-90,-91,-84,-72,-57,-48,-43,-32,8,20,31,35,38,36,33,17,15,4,-1,1,1,-3,
-1,9,36,59,48,-17,-74,-106,-101,-62,-13,-9,8,1,-9,-12,-11,-4,10,10,15,21,22,15,6,-6,-10,-13,-21,-30,
-29,-27,-47,-69,-56,-38,-20,-4,-1,-8,-1,16,70,86,83,60,54,60,40,5,-2,-8,-12,-5,-6,-10,-14,-14,-3,27,
44,20,-43,-100,-119,-69,-4,-11,-4,-12,-23,-41,-47,-37,-21,-16,-1,18,28,27,25,21,10,4,-10,-22,-25,-21,-30,-42,
-40,-14,9,25,35,41,51,62,81,90,88,75,61,50,23,-8,-14,-7,2,7,-1,-12,-20,-20,-12,10,36,44,0,-57,
-95,-72,-9,-8,-3,-10,-14,-24,-40,-49,-54,-48,-35,-18,-2,11,21,22,15,5,-8,-18,-22,-20,-17,-16,-21,-4,18,41,
56,65,75,78,79,90,94,87,57,31,4,-15,-13,-6,1,-1,-12,-22,-23,-16,-10,3,24,52,37,6,-50,-57,-7,-15,
-7,-9,-11,-12,-16,-28,-33,-42,-53,-47,-32,-16,3,14,25,16,10,8,4,7,24,40,43,46,61,77,85,91,91,81,
81,85,76,50,8,-18,-24,-25,-15,-8,-5,-9,-13,-17,-23,-25,-21,-11,12,43,44,38,-4,-33,-21,-32,-26,-27,-27,-25,
-21,-22,-21,-25,-35,-43,-38,-19,5,17,27,29,28,27,32,46,61,66,66,58,61,76,81,78,72,62,57,52,32,10,
-21,-42,-42,-38,-35,-31,-32,-33,-29,-26,-26,-25,-23,-15,11,38,40,49,28,-11,-26,-33,-30,-36,-32,-29,-26,-26,-20,-18,
-17,-17,-20,-20,-8,1,17,24,31,34,36,39,39,36,32,31,32,36,35,26,18,11,5,3,-8,-17,-29,-39,-39,-40,
-34,-32,-34,-32,-28,-29,-28,-27,-31,-22,-11,15,10,28,15,-4,3,7,3,-2,1,-8,-12,-18,-20,-19,-22,-21,-15,-6,
4,8,21,26,31,38,37,31,28,34,31,27,23,22,23,23,21,18,18,13,-2,-20,-31,-38,-42,-43,-42,-45,-46,-48,
-50,-48,-50,-50,-48,-16,-2,22,50,68,56,30,2,-5,-10,-18,-21,-35,-47,-60,-65,-57,-48,-39,-22,1,18,29,55,64,
59,44,28,22,18,20,21,23,28,40,52,54,49,40,40,37,26,11,-7,-24,-33,-36,-39,-48,-60,-70,-77,-74,-70,-64,
-40,-11,18,59,108,114,88,38,-16,-38,-41,-41,-40,-53,-57,-61,-46,-40,-36,-32,-13,15,36,48,51,56,45,25,11,14,
17,14,1,4,10,23,38,47,49,42,40,46,49,40,21,7,4,5,1,2,-9,-31,-45,-47,-48,-39,-20,9,47,105,
127,127,71,11,-32,-57,-60,-55,-42,-43,-35,-21,6,8,7,7,13,17,15,12,5,-2,-11,-17,-20,-9,7,15,10,9,
-5,-8,2,15,28,29,25,31,42,43,23,3,-13,-23,-16,-4,2,-11,-30,-49,-56,-33,-6,30,83,127,127,97,28,-9,
-39,-59,-51,-43,-22,-11,8,33,54,50,41,33,26,15,4,-1,-6,-17,-25,-28,-27,-16,-7,-4,0,0,-20,-29,-24,-19,
-10,-3,2,0,-2,-6,-12,-17,-33,-55,-56,-36,-16,-5,-4,-19,-27,-13,17,67,125,127,116,56,2,-8,-35,-44,-22,-3,
29,41,51,61,81,74,64,47,24,-1,-18,-21,-36,-37,-27,-12,-1,3,-2,-3,16,6,-20,-26,-18,-22,-25,-26,-20,-18,
-28,-49,-52,-31,-26,-42,-48,-51,-48,-31,-2,11,26,36,50,102,127,114,78,29,-6,-4,-20,-13,16,56,76,79,67,61,
72,61,44,27,11,-7,-23,-29,-43,-40,-29,-26,-25,-27,-39,-29,-20,-28,-48,-53,-48,-45,-35,-34,-49,-60,-67,-80,-91,-75,
-51,-51,-39,-40,-33,-18,-7,10,45,67,105,127,127,90,51,14,-10,0,-2,19,50,80,88,74,55,52,43,33,19,5,
-8,-25,-40,-44,-42,-43,-29,-26,-27,-24,-32,-25,-14,-16,-24,-25,-30,-35,-31,-33,-50,-70,-83,-93,-104,-104,-94,-93,-87,-78,
-51,-24,-5,19,47,72,107,92,79,40,11,-1,-10,11,21,44,59,76,69,51,38,19,8,6,-4,-17,-25,-36,-43,-41,
-33,-34,-15,-13,-23,-37,-40,-49,-30,-22,-13,-12,-16,-14,-18,-31,-39,-46,-54,-62,-68,-76,-80,-79,-90,-89,-80,-58,-19,22,
50,70,61,30,-1,-17,-22,-1,13,14,45,77,73,56,41,23,13,-3,-8,-10,-16,-25,-30,-34,-35,-33,-36,-30,-2,-3,
-24,-40,-32,-35,-34,-16,4,8,4,6,-1,-17,-26,-30,-34,-39,-44,-49,-50,-45,-49,-62,-70,-67,-43,-11,12,20,9,-12,
-26,-23,-19,7,25,26,54,84,55,25,17,9,-1,-19,-23,-28,-31,-31,-32,-31,-27,-25,-26,-16,18,15,-18,-40,-21,-16,
-18,0,16,18,13,17,12,-1,-17,-21,-26,-30,-34,-35,-32,-29,-27,-38,-52,-68,-74,-58,-21,6,12,3,-4,-5,-12,1,
9,4,59,69,35,11,3,-3,-10,-27,-34,-38,-36,-31,-27,-23,-19,-20,-17,-1,40,32,-14,-43,-16,-16,-20,-5,8,17,
25,33,30,18,-2,-12,-23,-29,-30,-27,-19,-15,-14,-20,-37,-57,-69,-69,-56,-43,-18,-14,-9,-1,-4,3,2,-9,55,53,
23,4,-7,-16,-22,-34,-45,-40,-30,-21,-16,-11,-6,-5,-10,7,54,38,-23,-48,-10,-22,-25,-7,3,16,30,42,43,30,
9,-6,-20,-23,-22,-21,-14,-10,6,-4,-26,-45,-54,-67,-75,-73,-62,-44,-25,-10,-7,1,2,-2,35,33,4,-12,-16,-24,
-35,-42,-43,-32,-16,-2,4,4,4,6,2,19,64,36,-40,-63,-15,-38,-31,-7,-1,8,22,42,57,45,17,1,-14,-14,
-16,-20,-17,-12,5,-2,-17,-30,-34,-48,-64,-68,-72,-53,-31,-13,-5,0,0,1,28,17,-5,-16,-25,-34,-40,-42,-35,-16,
8,20,23,17,9,5,7,28,71,36,-52,-91,-43,-50,-41,-22,-15,-2,14,44,63,42,19,5,-10,-10,-12,-26,-21,-9,
10,13,8,-3,-8,-24,-48,-61,-68,-56,-39,-19,-11,-4,-3,-3,25,13,-7,-18,-30,-39,-40,-31,-19,-3,19,34,39,31,
18,9,10,30,70,34,-55,-101,-62,-75,-67,-50,-36,-10,11,38,59,41,12,2,-6,-5,-7,-20,-17,-9,13,26,31,20,
9,-7,-30,-48,-60,-55,-45,-28,-18,-8,-5,-5,18,3,-13,-27,-35,-44,-36,-25,-10,6,30,49,51,35,20,18,18,33,
65,28,-49,-104,-71,-74,-67,-57,-32,-15,5,43,56,34,10,5,4,-1,1,-10,-17,-11,10,27,37,34,22,12,-6,-33,
-46,-47,-38,-26,-19,-4,-4,-3,10,-3,-17,-31,-40,-49,-37,-19,0,17,37,49,48,32,19,17,16,26,57,29,-42,-99,
-75,-62,-60,-56,-32,-8,18,49,51,25,4,-4,0,6,14,1,-13,-8,19,21,26,34,29,24,13,-14,-33,-36,-27,-17,
-13,0,0,1,2,-8,-18,-32,-43,-51,-35,-12,10,27,43,47,44,32,22,22,22,26,50,32,-18,-77,-78,-56,-57,-56,
-34,-2,23,40,35,13,-8,-14,-4,10,27,14,-6,3,30,13,13,35,38,38,34,9,-18,-23,-15,-7,-8,3,5,6,
-1,-8,-17,-31,-43,-51,-32,-4,16,31,43,43,39,31,26,27,25,26,47,41,16,-32,-63,-64,-60,-57,-33,0,14,17,
17,10,-3,1,11,18,29,19,9,28,41,12,10,37,40,42,45,25,-2,-11,-5,2,-3,7,10,10,-1,-10,-20,-35,
-46,-51,-28,5,21,33,43,43,38,30,26,28,23,22,45,48,38,15,-23,-53,-67,-48,-15,15,24,17,14,11,13,18,
20,14,20,20,21,44,61,26,21,45,41,40,46,34,13,2,6,9,-1,8,13,12,0,-12,-24,-40,-50,-52,-24,11,
27,36,48,50,44,31,25,29,27,23,40,48,45,42,26,7,-5,9,26,40,44,35,31,28,25,17,15,11,21,32,
37,55,85,45,34,52,41,37,42,40,26,15,17,17,1,9,15,13,-2,-12,-24,-44,-52,-55,-25,7,31,34,46,53,
49,35,29,31,23,22,41,58,63,42,18,44,49,55,55,59,59,51,50,49,40,19,16,16,17,36,44,56,93,49,
32,51,43,39,41,47,29,23,25,21,5,11,18,15,-3,-13,-24,-44,-52,-56,-26,5,30,33,46,54,50,36,30,33,
24,23,42,59,65,44,21,51,51,57,58,62,61,54,53,50,39,16,15,15,12,32,42,56,93,49,32,51,43,38,
40,47,28,23,26,22,6,12,19,16,-2,-14,-26,-40,-51,-54,-29,7,23,36,51,56,49,34,28,34,27,28,45,56,
55,50,44,24,6,19,34,45,45,37,33,30,25,10,10,5,12,25,35,58,86,43,34,50,39,31,37,39,26,15,
19,19,2,9,15,15,-2,-12,-21,-36,-48,-53,-33,0,18,34,48,50,45,34,29,32,25,27,50,59,50,28,0,-25,
-50,-37,-8,20,25,18,16,13,10,7,9,0,4,9,17,48,62,23,20,43,36,32,38,32,14,4,9,12,-1,8,
14,15,-1,-10,-18,-32,-44,-52,-36,-6,14,32,48,49,45,36,30,30,26,28,54,56,30,-17,-42,-40,-44,-47,-27,3,
13,14,13,5,-9,-13,-7,-5,7,3,1,28,41,6,7,33,32,32,37,22,0,-6,0,5,-4,6,12,14,1,-9,
-19,-31,-43,-51,-37,-12,10,30,47,50,46,36,27,25,24,29,58,48,-6,-63,-60,-34,-38,-45,-28,-2,19,36,31,6,
-18,-30,-24,-13,4,-3,-14,2,26,4,8,30,29,29,29,9,-13,-15,-7,-3,-9,2,7,9,8,-6,-19,-31,-41,-48,
-37,-17,6,24,43,50,47,34,23,20,19,29,64,40,-36,-91,-63,-41,-44,-45,-25,-5,18,47,46,15,-9,-22,-20,-15,
-7,-14,-21,-13,10,9,21,31,23,19,13,-9,-25,-25,-17,-13,-15,-2,2,3,16,1,-14,-27,-36,-43,-34,-22,0,18,
40,51,50,36,23,20,20,35,71,37,-47,-99,-62,-58,-48,-44,-23,-7,9,43,52,27,0,-10,-12,-16,-16,-25,-29,-25,
-2,15,33,32,18,10,-3,-24,-34,-34,-28,-22,-21,-6,-3,-3,23,11,-8,-18,-29,-36,-35,-26,-10,10,31,41,42,33,
22,14,14,33,74,39,-54,-99,-58,-63,-47,-38,-26,-5,14,42,58,39,4,-10,-19,-18,-19,-33,-31,-26,-2,14,27,19,
8,-5,-23,-37,-47,-43,-36,-27,-23,-12,-7,-6,26,15,-5,-15,-24,-31,-34,-34,-25,-3,21,31,30,24,16,12,12,31,
74,37,-55,-97,-47,-47,-34,-20,-13,-3,14,46,62,39,13,-6,-24,-24,-23,-39,-35,-22,-6,3,6,-2,-7,-18,-39,-49,
-55,-47,-36,-22,-20,-11,-8,-5,30,31,4,-12,-14,-21,-29,-32,-27,-16,-1,12,18,16,14,13,7,25,67,35,-48,-72,
-23,-45,-36,-13,-7,4,23,42,55,45,13,-8,-26,-27,-28,-32,-30,-26,-12,-13,-18,-25,-31,-43,-56,-58,-64,-48,-33,-22,
-18,-11,-7,-1,49,47,24,7,-5,-14,-16,-20,-26,-21,-13,-3,4,5,5,4,-2,14,54,35,-33,-62,-22,-32,-34,-16,
-6,9,28,41,44,32,7,-12,-30,-34,-33,-31,-26,-22,-7,-15,-30,-44,-53,-64,-71,-70,-61,-49,-36,-23,-22,-12,-7,-6,
53,61,33,13,7,2,-4,-15,-14,-16,-15,-10,-4,-3,-4,-7,-5,8,41,29,-22,-53,-28,-30,-32,-16,-2,12,25,35,
34,20,-4,-15,-29,-37,-37,-32,-25,-22,-25,-29,-40,-56,-67,-70,-58,-46,-26,-28,-28,-22,-26,-12,-6,-11,46,71,49,22,
20,17,8,-6,-3,-5,-8,-9,-8,-9,-8,-7,-10,-3,21,12,-22,-42,-28,-36,-33,-11,8,14,15,22,17,2,-18,-22,
-30,-34,-37,-38,-38,-37,-37,-45,-53,-63,-69,-58,-30,-9,-6,-18,-29,-29,-33,-13,0,-1,32,58,61,49,39,30,23,13,
9,12,9,1,-5,-11,-14,-12,-14,-13,6,-4,-27,-37,-30,-43,-43,-17,6,13,12,13,6,-10,-21,-28,-34,-39,-44,-50,
-53,-50,-57,-67,-74,-71,-47,-15,-4,-6,-15,-36,-51,-46,-38,-11,7,17,5,21,42,64,64,53,45,33,27,29,22,11,
3,-10,-18,-17,-8,-13,-1,-8,-24,-31,-31,-42,-27,-13,0,4,2,0,-6,-18,-30,-38,-47,-56,-64,-73,-81,-84,-92,-91,
-81,-63,-28,14,41,55,37,3,-33,-47,-47,-28,-15,0,-20,-11,22,60,75,73,60,58,58,52,42,30,19,3,-10,-12,
-12,-15,-7,-13,-20,-16,-21,-15,0,4,-2,-1,-5,-13,-11,-15,-33,-55,-73,-87,-94,-86,-76,-78,-75,-68,-46,-25,-11,10,
40,66,91,70,45,5,-22,-35,-44,-11,-41,-44,-13,30,50,66,70,70,78,72,61,46,33,18,4,0,-11,-6,3,-2,
-6,-9,-21,-15,-4,-7,-24,-28,-24,-23,-16,-19,-34,-46,-55,-66,-69,-45,-22,-24,-16,-23,-22,-14,-9,4,41,66,100,117,
102,61,19,-24,-51,-26,-56,-74,-51,-34,-1,14,35,51,78,75,71,58,38,13,-5,-7,-18,-18,-10,0,10,17,10,-1,
17,12,-11,-16,-8,-13,-15,-14,-1,5,-7,-28,-21,3,2,-18,-25,-30,-33,-25,1,10,22,36,50,91,115,89,48,-5,
-49,-31,-54,-86,-79,-73,-50,-39,-17,7,26,28,27,26,23,12,2,-2,-9,-19,-28,-36,-34,-18,-7,-8,-10,-5,-23,-30,
-20,-14,-4,6,13,14,14,14,13,8,-10,-29,-32,-17,-5,-1,0,-16,-27,-15,15,61,110,119,85,24,-33,-32,-50,-82,
-83,-81,-69,-74,-62,-47,-20,-17,-16,-11,2,9,8,6,0,-11,-22,-31,-35,-24,-10,-6,-9,-6,-17,-18,-6,5,17,21,
29,37,53,58,40,16,-1,-8,-4,1,0,-16,-34,-50,-57,-38,-10,26,72,112,108,67,-3,-29,-32,-63,-67,-68,-63,-79,
-83,-86,-68,-61,-57,-52,-29,2,22,33,35,36,25,10,-3,-1,1,-1,-12,-8,-1,16,34,42,44,37,34,43,52,46,
28,12,8,8,-1,-7,-21,-41,-53,-52,-52,-44,-22,7,40,91,119,100,41,-6,-8,-25,-33,-43,-44,-60,-72,-87,-93,-83,
-74,-64,-45,-18,4,17,49,57,55,43,29,21,16,16,12,14,19,35,48,50,43,34,31,31,22,8,-11,-28,-39,-45,
-51,-59,-69,-78,-85,-80,-77,-73,-50,-22,8,47,86,88,58,17,-3,-4,-6,-12,-9,-23,-26,-32,-33,-32,-36,-33,-26,-16,
-4,1,20,27,32,38,37,32,27,28,27,21,15,17,21,21,19,16,14,10,-4,-21,-33,-41,-46,-48,-46,-49,-49,-51,
-55,-52,-52,-53,-53,-23,-6,19,40,58,41,21,25,45,57,60,57,56,57,45,45,43,44,47,50,48,42,41,35,27,
28,29,24,24,27,29,33,23,14,11,10,7,6,8,8,13,24,35,43,49,49,48,45,46,48,47,45,45,42,39,
33,27,27,39,48,37,23,6,41,61,72,76,72,63,61,53,40,33,29,30,37,40,35,33,28,35,51,67,76,73,
62,51,22,17,3,-6,-10,-9,-8,-6,-2,4,14,29,52,70,73,69,69,71,74,75,76,76,72,66,59,54,55,65,
69,55,39,20,20,41,50,52,49,34,22,10,-8,-16,-24,-25,-22,-21,-22,-18,-3,8,30,50,59,58,43,27,11,0,
-26,-49,-52,-48,-45,-45,-45,-42,-32,-14,11,33,41,41,40,39,45,55,60,62,61,57,53,49,51,58,64,51,38,14,
14,29,29,20,10,-11,-31,-47,-50,-53,-56,-50,-38,-25,-22,-19,-17,-18,-19,-20,-17,-11,-6,-4,-9,-12,-21,-32,-39,-50,
-65,-76,-84,-80,-65,-46,-22,-2,15,27,22,18,15,18,26,37,42,36,38,36,42,46,51,39,31,12,7,1,-13,-27,
-44,-73,-93,-95,-82,-59,-35,-21,-12,-9,-13,-16,-22,-27,-32,-31,-28,-26,-21,-12,-7,-3,-8,-15,-20,-29,-43,-55,-78,-72,
-61,-50,-37,-22,-2,17,20,10,-1,-8,-4,7,17,20,19,18,21,37,39,32,20,3,-8,-36,-68,-93,-117,-125,-97,-61,
-32,-5,14,13,2,-8,-21,-29,-36,-35,-27,-13,-6,-11,-12,-7,-2,6,-4,-19,-24,-29,-35,-41,-49,-39,-35,-37,-32,-25,
-18,-6,0,1,1,-5,-8,-9,-8,-6,-1,-3,8,34,29,20,6,-7,-41,-101,-124,-128,-128,-86,-22,17,45,49,40,18,
0,-8,-12,-14,-7,-12,-6,13,18,11,7,8,1,7,-4,-11,-16,-25,-28,-29,-31,-25,-21,-25,-25,-27,-30,-21,-19,-18,
-20,-21,-20,-20,-22,-20,-21,-7,16,32,11,5,2,0,-73,-128,-128,-123,-69,5,50,58,45,44,32,12,4,6,5,1,
-11,-6,1,11,13,10,10,13,14,12,2,0,-4,-19,-26,-29,-29,-31,-34,-35,-30,-30,-48,-51,-46,-43,-45,-50,-49,-45,
-41,-38,-18,5,15,4,-9,-3,-9,-1,-86,-128,-102,-40,21,66,62,57,47,43,33,21,14,11,2,-8,-8,-1,-4,3,
8,-1,-4,17,18,11,4,8,14,15,12,6,3,-6,-17,-25,-30,-38,-55,-68,-68,-74,-74,-69,-74,-82,-67,-46,-22,-22,
-19,-16,-19,-25,-22,-11,-85,-105,-39,38,75,78,56,42,36,32,24,13,5,4,1,-6,-12,-10,-6,12,9,-10,-7,26,
35,31,24,22,27,34,40,42,35,28,19,11,4,-9,-34,-56,-75,-84,-88,-82,-79,-86,-79,-64,-65,-45,-25,-17,-21,-30,
-29,-20,-68,-52,30,86,82,56,37,38,33,26,18,8,-1,-2,-3,-9,-12,-14,6,27,7,-13,2,35,26,33,36,35,
34,36,44,51,47,43,39,32,24,11,-8,-27,-47,-66,-92,-105,-105,-111,-112,-107,-89,-57,-28,-11,-8,-14,-11,-8,-43,2,
65,70,47,38,36,39,26,17,7,-1,-9,-8,-7,-9,-9,-8,27,40,2,-1,23,30,16,30,37,43,47,41,38,45,
49,46,43,39,31,23,13,4,-10,-22,-49,-78,-93,-101,-101,-98,-83,-56,-38,-24,-20,-22,-7,0,-13,39,67,42,31,40,
41,32,15,6,-2,-10,-17,-17,-15,-14,-12,4,48,42,-13,2,32,21,43,48,46,46,49,40,32,36,43,42,42,38,
29,17,9,7,11,3,-14,-37,-60,-82,-86,-81,-64,-45,-31,-19,-19,-26,-12,-2,17,51,51,30,31,36,35,22,6,-3,
-13,-20,-23,-21,-19,-20,-13,14,60,34,-33,-7,31,28,57,54,51,49,48,39,32,29,34,38,43,43,31,10,-2,-2,
1,-2,-8,-18,-36,-59,-66,-64,-39,-24,-10,3,4,-5,2,9,32,48,35,30,30,29,34,18,0,-17,-29,-28,-21,-17,
-19,-24,-9,20,65,34,-46,-19,11,18,36,39,42,43,40,33,28,14,23,38,47,47,31,-2,-13,-3,5,8,8,4,
-7,-25,-39,-51,-41,-20,2,17,23,16,20,18,30,43,30,31,36,35,34,11,-10,-27,-35,-29,-21,-18,-20,-23,-6,25,
70,34,-53,-31,1,16,28,28,30,36,38,29,18,3,28,43,51,50,30,-5,-12,4,14,25,33,33,22,1,-15,-30,
-28,-7,13,28,39,35,32,22,26,32,28,30,37,40,30,6,-22,-34,-40,-33,-23,-18,-18,-17,-5,24,64,39,-40,-36,
8,30,45,21,17,30,38,29,14,6,30,40,56,59,31,1,-4,17,25,30,46,46,40,30,9,-12,-24,-19,5,29,
44,41,41,27,23,31,28,32,38,39,28,1,-28,-41,-46,-39,-29,-24,-21,-19,-10,21,60,42,-30,-27,13,26,22,7,
8,23,33,21,8,13,26,36,49,51,30,5,1,19,20,28,44,41,36,33,18,0,-16,-19,-2,24,43,42,41,25,
22,31,29,31,35,36,23,-7,-37,-51,-55,-46,-38,-33,-27,-23,-17,11,49,45,-13,-12,20,20,8,11,19,21,20,4,
-3,10,27,36,37,28,12,-6,-9,6,9,19,31,27,25,28,23,9,-9,-19,-9,17,43,45,43,26,23,31,28,27,
32,34,18,-15,-46,-60,-63,-52,-44,-39,-32,-26,-22,-2,31,42,6,5,33,34,25,28,28,17,11,7,10,21,36,43,
31,13,-1,-17,-17,-3,1,10,16,13,15,22,24,12,-6,-20,-16,10,41,48,47,30,25,32,28,27,31,34,17,-17,
-51,-70,-73,-59,-48,-41,-34,-28,-26,-10,16,41,31,30,46,48,49,39,28,15,12,16,22,29,52,55,35,12,-4,-22,
-20,-4,-4,5,5,-1,1,12,21,10,-11,-26,-25,0,36,47,49,33,24,31,28,28,33,35,17,-16,-55,-78,-86,-69,
-51,-44,-37,-32,-29,-14,8,38,47,45,48,43,38,35,34,29,24,16,16,26,58,68,45,13,-7,-24,-23,-14,-14,1,
1,-11,-12,-1,15,6,-20,-35,-37,-13,27,44,50,34,21,28,25,28,35,35,19,-13,-53,-83,-96,-78,-54,-41,-35,-29,
-22,-11,0,27,37,39,38,29,34,38,35,29,25,14,10,24,62,84,70,23,-3,-14,-18,-11,-10,7,5,-13,-20,-10,
11,2,-21,-39,-45,-23,23,46,52,35,21,28,25,28,35,35,18,-12,-53,-83,-96,-78,-53,-41,-35,-29,-24,-13,-1,26,
36,37,36,27,34,37,35,28,25,13,9,24,62,83,69,22,-3,-14,-18,-11,-10,7,4,-13,-19,-9,11,3,-20,-39,
-46,-25,22,47,53,36,25,30,28,28,32,34,16,-17,-57,-79,-86,-68,-51,-45,-40,-35,-30,-17,6,33,43,40,43,40,
37,33,32,29,24,15,15,27,58,69,42,10,-7,-23,-23,-18,-18,2,2,-11,-11,2,16,7,-19,-35,-40,-15,27,46,
52,36,26,32,27,26,31,32,14,-20,-54,-71,-74,-60,-48,-43,-37,-31,-26,-11,13,32,22,21,39,42,46,37,25,11,
10,16,21,27,51,57,34,12,-4,-23,-22,-11,-8,6,7,-1,3,15,22,11,-11,-26,-29,-5,34,48,50,33,25,33,
28,28,32,32,15,-20,-49,-62,-64,-52,-44,-40,-34,-28,-23,-1,30,35,-2,-4,25,28,20,26,26,15,11,9,12,23,
37,45,32,15,1,-18,-16,-4,0,14,19,13,17,26,26,14,-6,-21,-21,5,39,48,47,29,24,33,30,32,36,35,
19,-12,-40,-53,-56,-46,-38,-33,-28,-24,-18,12,50,43,-18,-21,11,15,7,12,21,24,22,5,-3,12,30,41,39,30,
13,-7,-7,5,9,24,35,27,28,33,26,11,-9,-22,-15,12,41,43,41,25,24,33,30,34,39,37,25,-2,-31,-44,
-49,-40,-30,-26,-22,-19,-10,21,60,42,-33,-33,6,22,24,8,9,24,35,22,8,13,28,40,49,51,30,6,4,17,
19,31,46,41,38,36,22,3,-17,-23,-8,20,41,39,39,24,26,33,30,33,38,37,27,3,-24,-37,-43,-37,-27,-22,
-20,-17,-5,23,65,43,-41,-39,1,25,43,21,17,28,36,29,15,7,31,42,54,58,33,3,-1,15,23,32,48,47,
40,31,11,-10,-27,-24,-2,24,40,38,39,26,27,42,33,33,36,33,29,7,-12,-28,-38,-33,-26,-23,-23,-24,-7,24,
72,40,-51,-35,-4,11,22,24,29,34,35,28,18,2,30,44,50,49,31,-3,-10,4,15,27,35,33,23,6,-12,-29,
-33,-15,7,24,36,33,32,21,27,45,38,32,30,28,28,13,0,-16,-30,-31,-26,-22,-23,-26,-10,20,68,39,-47,-23,
8,15,31,38,44,44,40,33,27,13,22,39,46,47,32,-1,-10,0,9,14,13,8,-2,-18,-33,-50,-44,-21,2,17,
25,21,24,17,8,43,52,31,32,34,30,16,3,-2,-10,-20,-28,-27,-23,-23,-14,16,65,37,-34,-11,31,28,58,54,
51,50,49,39,32,30,36,38,43,43,32,13,0,0,5,1,-5,-13,-30,-51,-60,-61,-37,-18,-3,8,11,5,9,13,
-18,30,64,45,32,36,37,24,12,6,1,-8,-16,-19,-18,-19,-14,3,52,47,-10,1,31,20,45,49,47,48,50,41,
35,40,46,43,42,38,30,19,9,7,11,3,-11,-31,-54,-75,-81,-78,-60,-37,-22,-10,-9,-13,-4,2,-47,-6,60,72,
52,37,34,33,23,16,11,4,-3,-4,-7,-12,-13,-11,27,44,6,-1,22,30,16,28,39,46,48,43,41,47,51,47,
44,39,33,25,13,4,-8,-20,-43,-69,-86,-95,-97,-95,-80,-49,-26,-11,-6,-9,0,4,-70,-54,25,84,87,59,39,35,
28,24,19,12,5,2,-1,-9,-12,-16,4,27,9,-13,3,36,28,34,38,38,36,38,46,51,48,44,39,32,24,13,
-6,-24,-39,-58,-84,-98,-102,-109,-110,-104,-85,-50,-14,4,5,-4,-7,-8,-86,-104,-38,35,75,82,61,42,32,28,21,12,
6,4,2,-3,-11,-10,-6,12,10,-9,-5,26,37,33,25,23,29,36,41,43,35,27,19,10,5,-6,-28,-49,-70,-83,
-94,-92,-92,-98,-86,-64,-66,-47,-21,-9,-12,-21,-23,-20,-95,-128,-100,-41,19,67,72,65,51,44,32,21,16,13,5,-5,
-4,3,2,9,13,5,2,17,20,14,6,8,13,12,10,5,1,-8,-18,-27,-33,-42,-59,-72,-79,-89,-89,-81,-86,-95,
-79,-54,-36,-37,-24,-11,-10,-13,-15,-13,-84,-128,-128,-121,-68,2,50,65,59,55,38,18,9,11,10,7,-5,-1,6,16,
20,18,19,19,19,16,4,1,-5,-21,-29,-32,-33,-37,-42,-47,-47,-51,-66,-67,-57,-52,-51,-52,-51,-47,-43,-41,-21,-9,
2,6,2,10,5,6,-50,-120,-128,-128,-128,-87,-28,13,50,60,56,34,12,1,-5,-7,-3,-10,-6,13,18,12,9,8,
1,8,-4,-13,-20,-33,-36,-34,-40,-34,-29,-32,-35,-39,-40,-30,-27,-24,-23,-20,-16,-16,-20,-21,-22,-13,8,32,22,21,
20,12,-15,-50,-86,-110,-128,-128,-103,-69,-34,-1,24,26,19,10,-8,-20,-30,-30,-26,-17,-13,-18,-22,-19,-13,-2,-7,-23,
-31,-37,-46,-52,-58,-42,-33,-36,-35,-30,-25,-16,-11,-6,-2,-1,-3,-5,-6,-8,-4,-3,7,37,44,41,27,8,-1,-8,
-24,-40,-61,-89,-103,-101,-85,-64,-41,-27,-16,-10,-14,-16,-21,-28,-36,-39,-36,-33,-27,-18,-11,-8,-14,-24,-31,-40,-53,-63,
-77,-65,-53,-48,-39,-26,-9,7,11,4,-3,-6,-1,9,19,21,18,18,24,42,53,54,46,20,9,21,19,10,-2,-24,
-42,-57,-56,-59,-62,-58,-49,-37,-31,-23,-15,-12,-9,-9,-9,-6,-2,-1,-2,-7,-19,-33,-40,-49,-61,-69,-72,-66,-54,-43,
-24,-5,12,23,20,19,19,23,31,40,44,39,39,36,44,53,60,57,60,30,17,34,41,43,39,23,12,1,-16,-25,
-31,-29,-25,-24,-24,-16,-5,9,33,54,65,64,50,34,18,10,-16,-39,-43,-40,-37,-34,-32,-31,-25,-13,9,30,39,41,
44,47,55,63,67,69,67,62,58,51,55,68,76,67,65,34,41,61,71,72,65,56,53,44,33,27,25,27,34,36,
31,30,26,32,50,67,75,75,68,59,33,29,14,1,-3,-3,-1,1,6,10,18,32,54,71,76,75,77,79,82,84,
85,85,81,74,66,61,63,78,86,70,60,36,27,47,59,59,56,54,55,45,45,44,46,49,50,48,41,42,35,27,
27,29,25,23,28,31,36,28,20,16,14,12,10,11,13,18,28,39,47,53,53,52,51,52,54,53,50,50,47,44,
38,32,33,46,58,45,34,14,-37,-49,-50,-46,-36,-39,-38,-36,-32,-26,-26,-29,-31,-29,-23,-15,-13,-12,-22,-25,-16,-1,
16,19,23,9,-11,-29,-41,-44,-41,-38,-47,-46,-42,-24,-10,-1,5,2,11,11,11,14,13,16,22,25,22,27,18,7,
-29,-45,-101,-63,-53,-83,-82,-74,-65,-62,-54,-48,-48,-56,-67,-74,-73,-70,-70,-64,-48,-35,-22,1,34,60,71,68,38,19,
-5,-27,-46,-63,-78,-89,-89,-90,-88,-80,-74,-62,-43,-32,-8,7,26,40,45,57,68,74,83,80,48,17,-36,-71,-128,-115,
-50,-81,-74,-58,-44,-38,-33,-39,-53,-69,-82,-90,-91,-79,-53,-23,-2,19,39,63,91,107,110,107,97,68,40,22,4,-16,
-43,-67,-84,-90,-94,-93,-92,-86,-70,-53,-38,-23,7,44,69,86,103,118,127,127,116,69,-2,-59,-128,-106,-45,-70,-56,-39,
-21,-11,-18,-29,-41,-51,-51,-33,-18,-11,-3,9,11,25,35,36,46,70,104,127,110,89,68,54,40,27,8,-12,-42,-64,
-88,-98,-90,-71,-45,-17,-2,4,14,37,78,120,127,127,127,127,127,85,14,-55,-128,-102,-43,-52,-27,-7,9,10,8,4,
-1,6,15,22,19,17,19,18,27,23,17,12,19,38,68,92,90,75,57,41,27,20,11,-3,-12,-35,-73,-99,-100,-79,
-36,14,39,41,39,37,49,80,127,127,127,127,116,51,-9,-67,-128,-102,-21,-18,20,37,46,40,30,26,38,39,36,26,
14,12,10,4,-4,-3,1,5,8,18,41,62,52,44,30,10,-4,-4,-2,-8,-19,-39,-69,-91,-99,-102,-78,-34,7,41,
75,83,67,53,82,120,127,126,65,-10,-65,-101,-128,-98,-4,26,50,63,51,27,19,35,49,38,23,19,17,8,0,-2,
-14,-17,-19,-18,-19,-15,-9,-3,-1,2,-7,-21,-30,-33,-30,-27,-34,-39,-54,-67,-68,-78,-77,-48,-24,-7,20,49,63,68,
74,75,72,46,0,-62,-104,-115,-122,-81,17,41,46,34,15,17,31,43,26,23,20,16,10,-5,-17,-21,-30,-33,-39,-39,
-37,-25,-5,3,2,-6,-18,-25,-33,-43,-45,-45,-43,-41,-50,-58,-52,-60,-69,-59,-41,-21,7,24,39,65,73,64,31,-9,
-49,-82,-98,-91,-86,-49,24,19,23,8,-3,20,22,7,5,15,20,12,-1,-11,-19,-24,-27,-28,-28,-33,-35,-10,8,14,
1,-10,-17,-22,-24,-19,-24,-26,-34,-36,-39,-41,-42,-52,-60,-56,-55,-41,-25,-12,5,24,18,-4,-33,-51,-74,-82,-65,-51,
-43,-23,20,11,-2,-15,-3,13,6,5,12,16,15,6,-3,-8,-16,-22,-22,-25,-27,-28,-24,-5,-2,-4,-12,-21,-26,-35,
-37,-28,-28,-25,-22,-22,-21,-18,-18,-30,-43,-43,-45,-46,-41,-34,-25,-12,-13,-23,-31,-35,-39,-44,-40,-31,-17,4,9,-4,
-15,-16,0,8,2,12,15,16,16,10,4,-2,-10,-14,-19,-24,-28,-23,-12,-10,-23,-14,-10,-19,-19,-28,-39,-38,-38,-29,
-20,-17,-13,-8,-3,-7,-12,-10,-15,-20,-25,-31,-32,-17,-1,5,3,-12,-28,-41,-48,-40,-23,-5,1,-13,-14,-14,-4,5,
3,13,14,14,17,17,15,12,3,-4,-18,-25,-30,-16,0,-19,-32,3,23,11,7,-3,-20,-31,-38,-26,-17,-9,-2,0,
0,-4,-5,0,4,4,7,6,1,4,16,27,21,8,-4,-15,-23,-18,-7,0,-6,-13,-13,-15,-6,7,4,10,17,20,
26,28,24,14,0,-10,-16,-28,-32,-3,13,-23,-30,22,44,33,28,12,-8,-22,-33,-25,-5,4,9,8,7,4,3,5,
9,7,8,12,15,21,28,33,36,32,28,19,7,3,0,-1,-4,-19,-18,-12,-5,3,7,21,26,29,34,29,15,0,
-12,-18,-25,-43,-44,2,21,-20,-24,22,41,39,39,17,-8,-14,-22,-25,2,6,6,5,7,11,15,15,8,2,-2,-1,
4,17,28,30,32,33,38,37,29,20,10,7,-4,-25,-17,-9,-8,1,18,38,34,33,34,23,4,-10,-18,-24,-32,-47,
-57,-6,22,-14,-13,15,28,37,42,16,-12,-10,-13,-19,14,17,12,5,-1,3,15,17,13,2,-4,-5,-1,11,19,18,
26,31,39,40,34,30,25,13,-7,-24,-18,-14,-12,2,22,46,35,32,30,16,-4,-17,-25,-33,-47,-54,-64,-14,24,-1,
-6,7,20,35,47,15,-17,-7,0,-6,22,22,14,1,-13,-8,13,24,20,8,-4,-6,1,11,19,22,18,26,36,35,
30,28,24,13,-17,-22,-16,-20,-21,6,32,46,36,25,18,4,-16,-25,-30,-36,-47,-58,-62,-17,12,7,11,26,43,50,
48,10,-7,4,3,-2,30,26,17,-1,-22,-11,13,30,22,5,0,7,9,20,28,28,22,18,30,39,31,23,22,17,
-19,-23,-18,-19,-14,14,36,47,34,20,7,-7,-23,-28,-31,-36,-46,-50,-57,-21,11,8,15,44,51,46,35,7,-1,2,
-4,4,35,26,17,5,-14,-9,13,33,17,0,-4,7,14,28,36,33,27,22,29,37,35,30,26,17,-20,-23,-20,-17,
-6,23,43,48,33,14,-3,-19,-31,-32,-33,-37,-49,-47,-52,-21,12,9,9,30,39,31,20,2,-2,-11,-15,6,30,36,
34,18,-6,-8,11,28,7,-7,-9,9,24,39,44,37,31,28,32,35,40,39,32,20,-16,-18,-16,-12,2,35,52,51,
31,10,-9,-26,-37,-36,-37,-40,-49,-45,-45,-18,12,5,-8,-3,14,9,1,-10,-10,-14,-9,13,18,37,34,15,-5,1,
18,24,-2,-14,-18,9,37,52,53,43,35,36,38,38,42,45,38,22,-14,-12,-8,-4,12,46,60,51,27,7,-12,-28,
-39,-39,-39,-42,-50,-45,-42,-17,11,0,-20,-19,-8,-9,-17,-24,-15,-6,1,12,24,36,23,13,11,19,24,7,-8,-19,
-30,4,46,63,58,47,35,41,45,43,44,45,41,27,-15,-10,-4,1,18,51,63,47,21,2,-14,-28,-41,-41,-42,-45,
-52,-50,-45,-26,-4,-16,-39,-46,-36,-23,-20,-19,-6,2,7,14,31,39,25,26,33,34,22,-14,-13,-20,-36,-2,47,64,
57,46,32,40,47,46,44,45,44,33,-13,-8,-3,1,14,47,56,40,15,-1,-11,-25,-42,-46,-49,-52,-57,-48,-43,-35,
-20,-23,-39,-59,-35,-19,-10,-5,2,1,5,13,52,63,46,36,46,45,21,-7,-12,-15,-41,-8,43,62,61,47,32,39,
47,45,42,42,45,32,-12,-7,-4,-1,12,45,56,39,14,-2,-12,-25,-43,-47,-50,-53,-59,-49,-44,-38,-21,-23,-39,-61,
-40,-23,-12,-7,-1,-3,1,10,49,59,44,35,46,44,21,-7,-12,-14,-40,-8,43,63,61,47,32,38,47,45,41,41,
44,32,-16,-10,-5,-1,16,52,65,48,22,1,-16,-30,-42,-43,-44,-48,-54,-54,-48,-32,-6,-17,-45,-56,-45,-29,-24,-24,
-9,1,2,7,24,31,20,25,29,31,22,-14,-16,-21,-35,-1,48,64,55,44,30,38,46,45,41,41,41,32,-16,-12,
-7,-5,12,49,65,55,30,8,-12,-28,-40,-41,-42,-46,-51,-51,-46,-25,5,-4,-28,-31,-15,-12,-17,-25,-14,-4,-1,5,
21,36,25,16,11,17,24,7,-13,-20,-27,5,46,62,56,45,32,38,43,41,40,41,37,26,-19,-19,-15,-12,4,40,
59,57,36,13,-8,-26,-37,-38,-40,-44,-51,-50,-47,-22,8,1,-15,-11,5,4,0,-12,-11,-11,-8,13,17,39,37,19,
-1,2,19,25,-6,-13,-15,11,37,51,50,40,30,32,35,35,38,40,34,20,-22,-25,-20,-17,-4,29,50,56,39,18,
-2,-19,-31,-33,-34,-39,-50,-48,-49,-23,6,2,2,21,32,25,18,0,-5,-10,-14,8,28,38,36,22,0,-5,12,30,
6,-4,-5,10,24,38,41,33,25,23,26,31,35,34,28,17,-23,-26,-19,-20,-12,20,43,54,42,24,8,-8,-24,-28,
-32,-37,-47,-47,-53,-26,1,1,11,36,48,42,35,7,-2,4,-3,4,35,30,23,14,-5,-5,14,33,18,5,1,8,
14,27,34,28,21,16,22,31,30,25,22,15,-22,-27,-18,-21,-19,11,39,53,43,30,18,3,-17,-26,-32,-38,-48,-54,
-59,-23,4,2,8,19,40,46,47,10,-7,6,4,-1,30,28,22,8,-11,-5,16,33,24,11,5,7,9,19,26,23,
17,12,22,32,26,19,19,14,-12,-30,-20,-15,-13,5,28,51,41,36,31,16,-5,-18,-27,-34,-47,-53,-61,-17,16,-5,
-7,3,18,31,44,14,-14,-4,-1,-7,23,25,20,9,-5,-1,17,27,23,12,1,-2,2,11,16,17,13,18,27,30,
26,24,22,12,-4,-30,-20,-8,-9,2,23,45,40,37,37,26,6,-9,-18,-24,-31,-47,-56,-9,14,-19,-14,9,22,30,
39,17,-7,-8,-14,-21,12,19,16,11,5,8,18,22,17,6,0,-2,-1,8,13,13,19,23,32,35,29,27,24,12,
1,-21,-25,-15,-7,5,11,29,33,35,37,30,17,2,-11,-17,-25,-45,-43,1,17,-20,-23,18,34,33,36,17,-7,-14,
-22,-26,-1,5,7,7,10,14,16,17,10,4,0,-1,1,12,21,23,24,27,32,34,26,19,7,5,-2,-11,-18,-23,
-11,8,8,16,26,27,28,27,24,14,0,-10,-14,-28,-32,-4,10,-25,-28,21,39,29,24,9,-8,-21,-34,-29,-6,4,
9,8,7,4,3,6,9,5,5,9,12,17,23,28,33,31,27,19,6,2,-3,-3,4,-10,-18,-19,-11,1,4,18,
24,24,23,18,13,7,-1,-6,-16,-24,-30,-15,-2,-25,-32,5,21,9,5,-6,-20,-31,-40,-31,-20,-11,-3,-1,-1,-3,
-5,-1,2,2,5,5,0,3,19,33,29,16,-1,-15,-26,-20,-12,-2,15,0,-17,-18,-7,-1,-2,15,22,25,24,14,
5,-3,-11,-15,-19,-21,-27,-21,-12,-17,-26,-14,-11,-20,-22,-30,-40,-41,-43,-34,-24,-20,-15,-9,-3,-5,-11,-10,-16,-19,
-21,-25,-24,-7,11,18,15,-3,-27,-44,-53,-44,-26,-7,30,24,3,-14,-8,2,-6,-3,13,21,22,12,1,-5,-13,-21,
-20,-20,-23,-22,-19,-7,-3,-6,-19,-29,-35,-41,-41,-35,-35,-29,-24,-23,-21,-17,-16,-26,-37,-37,-39,-42,-33,-21,-8,6,
3,-8,-13,-20,-30,-41,-41,-31,-18,2,30,37,38,18,-2,9,3,-11,-3,14,25,17,4,-7,-15,-22,-24,-23,-24,-27,
-28,-8,10,12,-2,-16,-28,-34,-35,-32,-34,-31,-36,-35,-37,-37,-36,-45,-52,-46,-44,-26,-4,11,27,46,41,18,-7,-29,
-57,-70,-58,-44,-40,-25,12,43,58,51,28,19,19,18,9,13,17,17,10,-4,-14,-18,-29,-31,-34,-32,-28,-17,-1,5,
5,-4,-17,-27,-37,-46,-48,-46,-40,-40,-49,-55,-49,-52,-53,-37,-16,3,27,45,64,94,106,96,62,22,-24,-61,-78,-74,
-77,-49,-12,18,47,73,69,41,20,22,28,16,6,9,12,5,-3,-5,-12,-16,-16,-12,-10,-7,-2,5,5,9,-1,-16,
-27,-30,-28,-25,-31,-39,-55,-66,-66,-73,-65,-35,-9,6,34,68,89,99,105,101,102,76,25,-40,-79,-93,-112,-85,-28,-33,
9,32,51,53,45,33,24,16,7,1,-5,0,2,-4,-12,-10,-6,0,7,20,46,71,57,47,34,15,0,0,0,-8,
-17,-42,-73,-89,-94,-95,-70,-29,10,42,77,91,84,70,97,127,127,127,92,11,-43,-83,-128,-101,-51,-67,-39,-17,6,13,
19,13,1,-7,-15,-15,-17,-12,-1,2,13,11,7,5,16,40,70,92,85,72,60,47,35,29,18,3,-10,-35,-70,-90,
-88,-70,-33,9,33,37,38,39,54,84,127,127,127,127,127,63,-1,-64,-128,-108,-49,-80,-65,-50,-30,-17,-17,-24,-33,-46,
-55,-49,-47,-44,-33,-18,-8,15,32,38,50,78,110,127,108,89,71,59,46,32,11,-10,-40,-58,-79,-86,-78,-62,-38,-13,
-1,5,16,41,83,125,127,127,127,127,127,92,10,-62,-128,-111,-55,-88,-81,-68,-52,-47,-42,-47,-56,-70,-78,-87,-93,-89,
-73,-49,-28,-2,30,65,100,120,120,112,98,66,36,17,0,-18,-43,-63,-76,-80,-83,-82,-83,-80,-67,-53,-36,-20,9,41,
64,84,102,117,127,127,127,79,-9,-69,-128,-110,-57,-88,-88,-82,-72,-71,-64,-60,-61,-67,-75,-79,-77,-76,-80,-77,-65,-51,
-36,-10,26,58,71,67,36,15,-10,-33,-52,-66,-77,-85,-83,-84,-85,-81,-76,-66,-48,-37,-16,-5,9,20,24,40,56,67,
75,78,57,22,-50,-91,-128,-123,-37,-52,-51,-48,-40,-45,-44,-42,-39,-34,-34,-35,-35,-32,-28,-23,-20,-20,-32,-36,-27,-10,
11,19,20,6,-14,-32,-45,-49,-47,-45,-53,-51,-49,-36,-21,-11,-5,-7,-1,-4,-5,-3,-4,1,10,16,15,20,16,6,
-37,-62,-110,-67,-19,-31,-24,-22,-18,-12,-10,-2,11,18,27,27,25,31,28,18,-2,-13,-31,-41,-47,-54,-64,-71,-74,-57,
-39,-30,-27,-24,-21,-20,-26,-28,-25,-11,0,3,8,11,7,9,8,7,3,-4,-7,-6,-7,-15,-25,-18,-18,-33,-54,-40,
-33,-36,-25,-17,-9,0,11,27,53,65,81,85,81,71,47,20,-16,-29,-47,-64,-84,-100,-107,-102,-62,-45,-23,-14,-17,-21,
-25,-26,-27,-34,-42,-39,-31,-21,-10,-6,2,6,10,11,10,3,0,0,-11,-14,-30,-25,-30,-45,-66,-42,-18,-15,4,13,
33,58,74,91,106,112,118,112,91,63,33,7,-22,-32,-38,-36,-38,-41,-34,-16,19,32,48,51,43,33,21,14,7,-5,
-28,-44,-48,-46,-37,-31,-25,-17,-3,11,18,14,14,14,9,12,3,0,-10,-31,-42,-25,-11,-3,19,39,59,83,95,100,
87,79,71,61,52,48,43,38,26,21,23,37,49,47,47,60,85,76,68,63,60,51,39,34,34,35,15,-10,-30,-43,
-39,-30,-32,-29,-27,-20,-7,8,18,14,18,17,5,9,6,8,11,-1,-7,6,28,53,71,74,59,36,22,16,17,20,
35,58,77,93,101,109,116,111,100,89,88,97,107,100,89,82,79,74,62,58,61,54,33,16,-4,-26,-33,-24,-20,-25,
-27,-27,-27,-12,9,20,14,10,4,14,12,34,40,12,0,23,44,55,46,28,1,-25,-45,-31,-10,13,43,67,74,77,
85,84,84,77,72,70,66,59,65,71,74,76,80,76,67,65,74,68,58,46,28,1,-27,-36,-45,-29,-10,-4,-16,-21,
-22,-17,-1,-2,-6,3,1,40,51,34,7,28,38,21,-21,-54,-58,-58,-55,-26,5,24,35,36,34,34,31,15,6,-2,
-9,-13,-19,-29,-24,-16,-12,-5,10,14,12,17,37,38,42,43,48,37,3,-22,-43,-41,-31,-26,-23,-22,-31,-37,-43,-14,
-9,4,12,35,51,39,4,0,-20,-53,-86,-82,-48,-31,-12,7,17,14,10,1,-14,-25,-35,-40,-42,-50,-52,-54,-67,-84,
-69,-60,-56,-45,-27,-25,-32,-29,-22,-21,-10,-1,11,18,18,25,12,-1,-15,-28,-36,-42,-44,-44,-50,-13,-17,-7,13,33,
50,34,-8,-43,-73,-106,-87,-55,-16,22,23,13,-5,-23,-36,-41,-54,-67,-76,-62,-56,-56,-53,-50,-55,-80,-52,-50,-46,-39,
-31,-33,-35,-33,-38,-36,-25,-15,-15,-14,1,21,44,42,34,14,-18,-51,-68,-75,-67,-64,-71,-30,14,36,51,26,-34,-95,
-109,-93,-58,-20,12,25,6,-11,-32,-48,-60,-62,-64,-65,-68,-54,-40,-30,-8,13,0,-37,-25,-20,-9,-1,-3,-24,-35,-36,
-34,-32,-24,-20,-24,-25,-15,-3,6,22,38,36,18,-5,-30,-50,-66,-62,-57,-25,-5,3,25,21,-65,-127,-108,-62,-23,5,
17,3,-11,-28,-49,-61,-69,-61,-51,-42,-28,-16,0,24,57,69,37,-3,-10,-8,-1,11,18,0,-22,-35,-43,-47,-46,-42,
-42,-42,-37,-29,-18,-9,4,11,14,15,8,-6,-22,-30,-38,-31,-28,-21,4,13,-83,-116,-80,-34,-3,9,5,-17,-26,-44,
-56,-57,-59,-51,-32,-9,10,25,46,77,99,76,26,3,5,6,9,11,12,10,-1,-24,-28,-44,-57,-58,-55,-51,-45,-38,
-33,-29,-19,-11,-12,-7,7,17,12,3,-13,-23,-26,-18,-4,-1,-77,-95,-45,-10,0,-5,-11,-22,-33,-49,-57,-50,-40,-26,
-11,5,24,42,70,106,114,74,26,20,1,6,20,21,17,22,23,3,-21,-39,-58,-65,-68,-64,-51,-40,-38,-40,-39,-36,
-38,-35,-17,-1,21,24,9,-15,-23,-12,2,3,-67,-68,-13,1,-8,-15,-21,-26,-40,-46,-49,-40,-23,2,15,22,33,50,
82,121,120,81,43,38,-22,-6,16,25,22,21,26,22,-22,-40,-57,-65,-72,-70,-49,-25,-23,-37,-52,-56,-48,-40,-32,-31,
-13,7,13,0,-9,-3,11,14,-53,-30,10,5,-13,-24,-27,-32,-45,-56,-58,-41,-14,17,32,35,42,63,85,127,122,81,
53,58,18,12,29,35,27,17,23,37,-12,-35,-53,-62,-71,-67,-40,-12,2,-24,-40,-53,-57,-47,-35,-26,-23,3,22,29,
22,19,17,11,-33,-5,17,1,-16,-24,-23,-29,-45,-54,-55,-38,-10,24,41,42,46,72,98,127,120,70,42,44,25,19,
30,38,35,21,21,35,1,-26,-48,-55,-60,-51,-22,7,7,-14,-30,-50,-63,-56,-39,-32,-21,1,24,42,41,38,30,15,
-7,11,16,-2,-18,-21,-24,-28,-44,-46,-40,-28,-5,35,52,44,49,79,117,127,127,70,25,22,-8,16,22,31,29,17,
27,30,10,-13,-40,-48,-49,-41,-30,-14,4,-7,-39,-56,-65,-62,-45,-44,-38,-20,10,30,45,45,37,18,8,18,14,-6,
-20,-23,-25,-28,-39,-39,-28,-13,4,40,57,51,56,89,126,127,127,72,20,-7,-18,16,34,40,33,30,41,26,1,-10,
-27,-39,-36,-27,-30,-24,9,1,-34,-54,-59,-56,-46,-50,-48,-30,4,25,41,45,39,21,18,21,10,-9,-21,-24,-27,-31,
-36,-34,-19,0,17,48,63,58,57,88,121,127,117,72,33,0,9,29,40,44,42,45,48,23,-4,-4,-9,-14,-2,1,
-24,-29,20,15,-21,-43,-48,-45,-40,-49,-58,-42,-6,17,36,45,39,21,19,19,8,-10,-21,-24,-29,-36,-38,-37,-22,1,
24,57,69,63,61,82,102,115,98,72,63,44,58,58,51,49,47,40,25,3,1,7,18,23,35,20,-28,-31,30,20,
-12,-37,-42,-36,-37,-49,-70,-55,-17,7,31,48,42,19,14,16,8,-7,-19,-23,-31,-40,-45,-43,-32,-10,22,62,75,69,
65,75,81,82,62,47,60,55,64,52,36,26,20,7,-4,-6,5,16,35,48,53,22,-27,-10,37,15,-14,-35,-33,-20,
-27,-46,-74,-61,-22,2,30,55,50,22,9,13,9,-6,-17,-22,-31,-41,-50,-48,-41,-22,13,61,79,74,68,74,72,59,
33,20,37,31,13,0,-11,-16,-17,-23,-24,-14,-4,4,26,51,55,17,-18,16,53,17,-13,-31,-20,0,-16,-43,-71,-62,
-24,-1,29,60,58,28,8,12,9,-4,-14,-23,-34,-45,-51,-51,-43,-28,2,58,84,78,71,81,75,62,32,25,40,29,
2,-21,-37,-39,-34,-32,-27,-16,-14,-7,8,48,67,24,-15,16,51,18,-2,-22,-10,15,-11,-36,-62,-66,-30,-6,33,63,
62,30,9,12,9,-5,-15,-23,-34,-45,-51,-51,-43,-28,1,58,85,78,73,84,78,63,32,25,39,26,-3,-26,-41,-41,
-34,-32,-28,-17,-19,-11,7,50,69,24,-16,15,50,18,0,-20,-9,14,-12,-36,-62,-67,-32,-8,33,63,62,29,9,13,
7,-8,-21,-24,-30,-39,-49,-47,-41,-22,14,60,78,74,70,79,77,62,33,20,33,25,5,-6,-16,-21,-23,-30,-31,-19,
-13,-8,19,47,48,10,-22,14,53,16,-12,-28,-17,-1,-20,-45,-76,-66,-30,-5,26,60,56,26,14,15,6,-9,-22,-23,
-29,-39,-44,-41,-30,-8,24,61,74,69,66,79,88,88,65,48,59,52,53,42,28,21,16,0,-13,-15,-1,7,26,40,
44,12,-31,-12,34,10,-15,-34,-33,-24,-33,-52,-77,-65,-27,-2,26,53,46,19,18,18,7,-12,-23,-24,-28,-36,-38,-36,
-20,3,27,54,65,62,59,83,107,122,100,71,63,45,55,53,44,44,44,34,17,-6,-4,2,10,14,27,10,-35,-38,
23,11,-16,-39,-45,-42,-44,-55,-72,-57,-21,5,27,44,36,15,16,20,7,-12,-24,-25,-27,-32,-40,-37,-20,1,19,43,
55,52,54,88,123,127,117,69,33,1,11,30,39,42,39,42,46,18,-11,-9,-15,-20,-8,-7,-32,-39,13,6,-24,-46,
-52,-51,-47,-54,-60,-44,-9,16,31,39,33,18,7,18,11,-10,-24,-25,-27,-32,-47,-44,-31,-14,5,35,49,44,51,90,
127,127,127,71,24,-2,-19,16,32,37,27,25,39,24,-5,-15,-33,-43,-40,-33,-37,-32,4,-6,-36,-56,-61,-59,-51,-53,
-50,-32,2,25,36,39,34,19,-9,10,14,-5,-21,-23,-27,-34,-53,-53,-45,-30,-6,30,45,39,45,81,121,127,127,71,
32,32,0,18,19,27,23,11,22,25,3,-22,-47,-50,-51,-44,-35,-21,0,-14,-41,-58,-65,-61,-48,-45,-38,-17,12,32,
40,39,32,15,-36,-8,15,2,-17,-24,-26,-36,-54,-61,-59,-41,-13,19,34,36,44,72,99,127,117,69,46,55,37,22,
23,32,30,16,17,30,-7,-36,-55,-56,-58,-51,-27,-1,0,-23,-35,-52,-62,-53,-38,-29,-18,5,26,40,37,33,26,12,
-58,-33,9,8,-14,-24,-29,-38,-54,-63,-63,-45,-19,9,24,28,38,61,83,127,118,77,54,66,26,12,22,29,22,13,
19,31,-19,-44,-61,-67,-73,-67,-42,-16,-5,-33,-43,-53,-55,-43,-31,-20,-14,11,25,29,21,19,17,11,-70,-75,-17,0,
-7,-13,-21,-29,-46,-55,-56,-45,-27,-6,7,16,30,45,79,116,114,77,37,32,-29,-9,10,19,16,16,23,16,-28,-49,
-65,-72,-76,-71,-52,-31,-30,-42,-54,-53,-43,-33,-22,-18,-3,18,21,5,-5,0,14,13,-79,-102,-51,-15,-1,-3,-12,-23,
-37,-54,-63,-56,-46,-32,-17,-1,19,36,64,96,104,67,20,16,-1,5,13,15,11,16,19,-3,-29,-48,-66,-71,-71,-65,
-54,-46,-45,-45,-40,-32,-28,-20,1,19,39,43,25,-3,-14,-7,7,6,-86,-121,-84,-41,-9,8,5,-16,-25,-43,-56,-60,
-62,-55,-38,-18,2,16,36,63,89,69,18,-4,-2,0,2,5,5,2,-7,-30,-34,-51,-62,-62,-57,-54,-49,-43,-38,-32,
-17,-1,7,17,32,42,37,26,8,-6,-13,-10,2,2,-67,-127,-108,-66,-29,0,16,5,-6,-21,-41,-57,-68,-65,-58,-50,
-35,-28,-13,7,44,61,28,-11,-21,-15,-7,4,9,-8,-28,-39,-48,-53,-50,-44,-44,-44,-39,-30,-19,-4,18,32,36,36,
32,23,8,-3,-13,-8,-8,-8,11,13,-34,-92,-108,-94,-61,-25,12,29,14,1,-19,-37,-53,-59,-64,-66,-70,-62,-49,-44,
-21,4,-10,-44,-28,-21,-11,-4,-10,-32,-41,-40,-38,-33,-24,-20,-22,-21,-12,0,17,35,50,44,19,-4,-18,-25,-34,-28,
-28,-2,17,22,37,22,-10,-42,-70,-102,-87,-59,-15,25,28,24,11,-5,-20,-28,-43,-55,-68,-58,-54,-61,-58,-55,-64,-83,
-48,-44,-40,-34,-26,-31,-35,-32,-35,-32,-22,-13,-10,-7,10,32,55,51,38,15,-18,-47,-60,-60,-42,-30,-40,-7,41,66,
76,39,-3,-5,-16,-46,-76,-79,-50,-27,-14,8,25,27,25,16,3,-7,-17,-23,-27,-36,-37,-42,-58,-73,-56,-48,-47,-39,
-19,-19,-27,-21,-15,-12,-1,10,23,28,27,34,21,8,-6,-20,-27,-30,-31,-30,-31,9,4,12,38,64,82,54,-8,10,
30,22,-9,-44,-58,-63,-58,-28,4,26,39,45,48,52,50,33,25,19,13,7,-1,-11,-8,-1,1,8,22,21,16,22,
45,49,51,51,57,48,14,-13,-35,-32,-20,-17,-13,-7,-16,-28,-32,5,13,23,33,57,76,55,-17,-5,23,44,39,27,
5,-22,-48,-32,-11,8,37,64,78,87,99,98,98,89,79,76,71,63,66,72,75,79,85,82,75,75,81,73,64,54,
37,10,-17,-27,-37,-24,-4,5,-7,-14,-17,-17,0,9,14,24,22,60,70,47,-27,-25,-1,30,50,54,46,27,21,16,
17,20,33,53,66,79,90,97,106,100,86,76,80,90,98,92,82,75,78,78,70,65,74,64,42,23,2,-19,-26,-20,
-17,-22,-23,-23,-25,-12,9,20,13,15,15,29,32,57,61,26,-21,-26,-9,10,32,55,68,75,65,62,61,54,47,40,
31,23,3,-8,-7,11,27,32,38,54,81,81,78,74,72,67,58,54,46,41,18,-6,-24,-34,-31,-24,-27,-25,-22,-14,
-3,10,19,15,16,15,9,19,27,36,39,14,-26,-28,-13,-9,8,31,45,59,73,82,92,89,71,47,23,1,-24,-32,
-37,-37,-39,-35,-22,-2,29,45,60,61,52,42,30,21,11,-3,-24,-38,-40,-38,-31,-26,-19,-10,3,16,20,14,12,11,
6,7,3,6,5,-6,-10,-8,-40,-46,-37,-31,-26,-21,-12,0,25,38,56,62,60,52,34,11,-15,-23,-36,-52,-73,-90,
-96,-92,-56,-38,-18,-12,-16,-21,-26,-27,-27,-34,-41,-37,-27,-15,-6,-3,4,9,12,12,10,1,-1,-2,-15,-18,-28,-22,
-24,-31,-36,-22,-23,-36,-30,-30,-26,-22,-20,-14,0,7,18,18,16,20,18,12,-8,-19,-33,-41,-46,-53,-64,-72,-72,-56,
-39,-29,-27,-26,-25,-25,-31,-31,-27,-14,-3,2,6,8,4,5,3,2,-2,-10,-12,-11,-11,-21,-27,-22,-20,-31,-38,-28,
-19,-25,-18,-12,-10,-5,-8,-19,-16,-24,-26,-26,-28,-29,-26,-14,-11,-8,-7,-5,-9,-14,-5,7,4,6,11,14,14,22,
33,36,37,31,27,19,17,12,0,-3,-14,-11,-4,-7,-12,-13,-17,-15,-12,-22,-39,-46,-66,-94,-102,-53,1,-8,5,19,
21,23,19,0,-23,-30,-38,-50,-51,-38,-22,-9,-13,-12,-3,13,17,2,-10,-10,-25,-24,-22,-22,-18,1,25,42,54,65,
71,68,75,74,54,38,25,15,8,3,0,-3,-2,1,-9,-10,-35,-64,-108,-128,-128,-60,3,20,36,48,48,31,3,-26,
-36,-46,-56,-63,-58,-49,-53,-60,-43,-20,-3,8,21,21,2,-20,-39,-45,-59,-77,-82,-68,-42,-21,-8,7,27,45,77,92,
83,71,59,40,24,22,22,23,28,29,19,23,0,-32,-78,-84,-74,-27,18,36,51,51,33,-11,-51,-80,-87,-85,-73,-58,
-50,-51,-59,-63,-57,-49,-42,-41,-32,-19,-17,-23,-40,-35,-30,-42,-61,-72,-83,-89,-89,-68,-36,-2,44,75,84,86,75,60,
41,33,33,33,34,34,40,31,4,-24,-42,-32,-23,5,29,47,44,21,-14,-53,-70,-73,-54,-26,7,26,26,18,10,5,
-1,-13,-32,-53,-58,-45,-43,-57,-71,-60,-38,-24,-21,-26,-46,-73,-100,-98,-80,-46,5,51,76,84,89,78,56,35,28,27,
30,33,39,16,-16,-17,2,28,28,31,40,63,41,1,-17,-25,-17,3,27,55,77,76,63,58,56,51,43,27,7,-16,
-33,-35,-50,-80,-59,-54,-40,-30,-26,-27,-40,-52,-61,-84,-101,-85,-45,6,47,68,84,79,58,33,32,39,41,40,33,-2,
-27,2,43,69,68,48,61,64,37,2,-5,-2,13,28,53,42,31,27,31,33,22,10,11,-10,-17,-18,-18,-11,-15,-43,
-54,-53,-49,-48,-44,-40,-44,-52,-64,-73,-101,-115,-110,-77,-29,21,49,71,70,51,42,42,37,33,11,-6,18,77,104,107,
101,53,61,57,34,13,4,3,18,32,13,6,4,5,5,4,0,-3,-7,-20,-20,-21,-27,-27,-33,-55,-70,-57,-42,-33,
-28,-23,-25,-29,-45,-49,-66,-72,-90,-108,-106,-82,-42,2,35,39,30,18,11,2,0,35,88,127,126,127,125,63,52,49,
33,15,6,25,22,5,-21,-22,-24,-23,-16,-5,0,-3,4,5,15,1,5,26,18,-10,-22,-10,-9,-10,-13,-16,-20,-22,
-38,-43,-48,-55,-66,-80,-94,-100,-99,-69,-26,8,12,-4,-7,4,42,82,127,127,127,127,127,75,43,41,19,12,13,15,
-1,-21,-46,-43,-38,-25,-5,13,20,20,21,27,34,33,49,46,22,14,10,14,7,-4,-14,-21,-24,-25,-35,-44,-47,-48,
-53,-65,-77,-83,-74,-72,-57,-26,-10,-16,-16,-4,30,70,127,127,127,127,112,50,36,38,14,14,14,3,-21,-47,-57,-44,
-24,0,21,30,29,28,26,32,40,53,66,36,12,28,49,41,18,0,-13,-23,-27,-28,-37,-50,-56,-56,-59,-63,-65,-62,
-68,-63,-47,-16,2,-5,-16,-15,-11,26,61,60,67,77,65,30,30,42,22,17,0,-23,-38,-55,-48,-29,-5,18,30,28,
22,22,25,31,46,67,62,21,23,60,76,62,34,15,1,-13,-22,-26,-26,-41,-49,-52,-55,-55,-54,-50,-47,-42,-32,-18,
-9,-4,-13,-25,-18,7,19,16,25,31,34,17,30,52,27,9,-22,-54,-58,-59,-37,-17,8,26,31,23,13,9,24,29,
49,79,65,25,46,85,72,63,45,34,21,5,-7,-13,-15,-28,-39,-49,-49,-40,-33,-30,-30,-36,-31,-23,-20,-12,-8,-6,
-7,2,-5,-10,-1,8,20,15,38,57,24,4,-32,-72,-69,-54,-30,-7,16,27,27,20,13,9,6,19,46,89,82,41,
67,103,78,76,68,61,46,27,17,10,-3,-12,-24,-39,-43,-30,-21,-20,-17,-19,-18,-23,-30,-23,-11,0,-1,4,-10,-22,
-19,-12,0,-1,45,48,32,1,-43,-72,-67,-43,-24,-5,15,22,20,10,2,-1,-1,8,28,91,101,59,82,110,98,99,
101,95,65,41,34,24,12,-3,-16,-27,-30,-18,-3,-1,-8,-18,-17,-26,-40,-37,-25,-12,9,10,3,-17,-26,-13,-1,-2,
42,51,38,-2,-49,-70,-60,-32,-15,5,19,18,9,0,-5,-4,-4,5,16,80,109,78,93,109,116,127,127,109,66,45,
41,30,19,3,-10,-23,-33,-28,-8,4,10,3,-2,-20,-46,-52,-45,-34,-6,11,20,2,-11,-6,-1,-7,37,56,37,-5,
-46,-63,-46,-19,-3,13,19,13,8,4,0,3,-1,-8,-3,66,115,106,91,94,82,127,127,95,53,34,30,20,20,8,
-9,-28,-39,-31,-7,-3,19,38,24,-18,-43,-60,-61,-54,-34,-13,13,12,6,4,8,0,41,55,26,-18,-53,-66,-46,-16,
-3,10,16,13,12,8,5,7,5,-5,-17,30,89,98,85,90,76,104,103,74,42,26,26,21,16,-6,-20,-35,-41,-31,
-15,-22,18,59,52,2,-26,-51,-64,-60,-55,-36,-4,7,14,19,20,6,38,49,15,-29,-58,-66,-44,-14,-3,7,13,12,
12,10,8,10,11,2,-23,-8,53,78,67,73,61,70,65,51,31,19,22,20,15,-9,-11,-13,-9,-2,-12,-34,15,75,
80,27,-6,-37,-61,-62,-65,-54,-21,-1,17,32,35,15,29,44,13,-30,-56,-60,-39,-13,0,7,12,13,11,8,9,13,
15,10,-13,-31,5,36,24,25,41,53,56,48,29,17,22,19,10,-9,11,29,34,26,-3,-26,16,77,98,48,11,-17,
-44,-55,-61,-61,-34,-11,14,37,44,23,22,39,12,-28,-53,-57,-37,-13,4,9,12,12,10,7,9,14,19,16,5,-40,
-43,-20,-35,-41,-3,17,26,25,23,29,37,30,-12,-25,13,51,62,39,4,-12,17,66,103,68,29,7,-19,-41,-59,-65,
-42,-19,11,40,49,31,21,35,8,-29,-56,-61,-40,-15,3,6,8,8,8,7,8,11,23,20,21,-36,-74,-64,-88,-98,
-60,-35,-18,-2,19,37,44,37,-17,-38,-2,50,72,50,14,-3,18,56,102,79,42,25,2,-27,-61,-68,-47,-23,12,44,
53,37,20,32,7,-33,-67,-76,-51,-16,7,9,11,11,10,6,7,14,23,17,21,-35,-70,-54,-92,-109,-78,-61,-52,-27,
14,41,45,37,-12,-48,-26,37,72,53,21,-5,21,51,106,82,50,39,12,-27,-65,-71,-48,-29,8,47,56,37,21,33,
8,-33,-69,-78,-53,-16,6,9,11,11,10,6,7,13,21,15,18,-37,-68,-48,-87,-106,-78,-62,-53,-28,13,40,44,34,
-16,-53,-27,40,76,56,22,-5,22,52,106,82,50,40,13,-27,-64,-70,-47,-29,8,46,56,37,21,35,9,-29,-57,-63,
-41,-17,-2,3,5,4,6,7,6,6,17,14,17,-38,-75,-64,-86,-97,-59,-34,-16,-1,20,40,46,34,-21,-44,-2,56,
78,54,16,-2,22,60,103,80,42,22,0,-27,-59,-66,-46,-21,13,42,53,39,22,39,12,-29,-55,-59,-38,-17,-2,4,
8,8,7,6,6,9,15,10,0,-43,-48,-26,-40,-44,-3,17,28,29,30,37,42,34,-13,-26,15,56,67,45,10,-9,
22,71,103,67,28,3,-21,-41,-59,-64,-42,-18,11,39,49,33,28,44,12,-32,-58,-62,-41,-17,-6,2,8,9,8,6,
5,8,12,4,-18,-36,-1,28,18,25,43,51,55,49,33,22,27,26,12,-6,13,31,37,31,2,-22,22,82,98,47,
10,-20,-45,-54,-61,-59,-31,-9,14,36,45,26,37,49,13,-32,-60,-69,-47,-18,-9,2,9,10,10,8,6,8,9,-3,
-26,-14,47,74,64,73,64,69,63,50,31,20,24,25,19,-7,-12,-15,-9,-1,-11,-31,19,77,79,27,-6,-36,-59,-60,
-62,-49,-16,2,17,31,35,17,39,54,24,-22,-57,-70,-49,-19,-8,6,13,12,11,7,4,6,3,-9,-19,22,86,99,
82,85,74,102,102,72,40,24,24,21,18,-7,-23,-37,-40,-30,-16,-20,18,58,49,1,-26,-49,-62,-58,-51,-31,0,9,
13,18,20,7,33,54,35,-8,-51,-67,-47,-21,-7,9,16,13,8,2,-2,1,-2,-12,-5,58,111,108,87,88,77,124,
127,93,51,31,27,20,20,4,-14,-31,-40,-32,-9,-2,16,33,21,-20,-44,-58,-59,-52,-28,-8,15,13,5,3,8,0,
38,46,35,-4,-50,-71,-57,-31,-15,3,15,15,7,-3,-8,-5,-6,-2,12,75,107,83,89,106,107,123,127,105,65,42,
38,28,18,-2,-16,-28,-35,-28,-9,0,6,0,-3,-23,-47,-52,-44,-31,0,14,21,4,-10,-7,0,-5,45,40,25,-1,
-45,-72,-63,-40,-22,-5,11,17,13,3,-4,-5,-7,-1,23,86,99,62,78,112,99,96,98,95,66,40,33,23,12,-5,
-20,-31,-32,-19,-6,-8,-11,-20,-16,-25,-40,-36,-23,-6,15,14,8,-12,-24,-14,0,-2,43,55,10,-2,-33,-73,-65,-49,
-25,-5,13,19,16,10,6,5,-1,10,41,82,76,39,60,101,75,73,67,61,47,30,18,9,-5,-16,-28,-42,-46,-32,
-23,-23,-21,-20,-17,-20,-27,-20,-7,6,7,17,4,-11,-10,-9,6,4,41,57,17,-1,-26,-56,-59,-57,-35,-17,4,19,
21,13,5,3,17,20,42,71,57,18,36,81,68,59,43,31,19,5,-5,-13,-18,-33,-43,-51,-50,-39,-33,-31,-35,-39,
-32,-22,-16,-5,0,1,5,22,19,12,17,20,34,24,38,54,22,9,-6,-28,-40,-53,-45,-29,-8,12,21,19,15,17,
20,23,38,60,53,12,14,56,73,60,32,11,-5,-16,-22,-28,-30,-46,-52,-51,-52,-54,-55,-54,-50,-46,-34,-17,-2,6,
-5,-20,-6,29,47,43,48,49,50,27,39,51,21,11,8,-1,-20,-43,-51,-40,-24,-3,13,21,22,22,21,26,33,46,
58,27,1,19,43,34,14,-5,-19,-28,-29,-31,-42,-55,-59,-57,-60,-65,-68,-66,-68,-62,-43,-12,8,4,-7,-6,0,42,
82,79,83,87,74,37,42,47,25,17,13,11,-2,-15,-36,-36,-35,-26,-10,7,15,14,16,24,30,27,44,41,15,6,
4,7,1,-9,-20,-27,-30,-32,-40,-46,-47,-48,-53,-64,-77,-83,-72,-66,-45,-12,1,-9,-11,-4,21,62,127,127,127,127,
109,48,46,45,32,21,9,21,18,6,-11,-13,-14,-16,-13,-5,-3,-7,0,2,12,-4,1,22,13,-13,-21,-13,-12,-14,
-17,-19,-22,-25,-39,-41,-43,-52,-64,-78,-92,-98,-94,-64,-18,16,14,-6,-12,-5,18,49,122,127,127,127,124,66,60,55,
34,15,3,4,15,23,15,10,10,10,8,6,2,0,-4,-18,-18,-25,-32,-29,-33,-56,-66,-54,-40,-31,-25,-19,-19,-22,
-35,-37,-53,-67,-89,-110,-112,-92,-59,-13,23,30,21,9,0,-12,-17,4,57,99,94,96,100,51,73,72,43,12,-2,-2,
6,18,45,35,27,25,30,33,26,18,20,-2,-7,-9,-13,-10,-15,-39,-56,-51,-44,-42,-39,-36,-39,-43,-52,-60,-90,-113,
-119,-99,-57,-8,21,46,48,36,30,30,21,15,-12,-31,-4,60,82,77,73,32,59,86,61,18,-4,-15,-14,-5,19,47,
69,70,59,58,64,62,58,43,26,6,-12,-18,-34,-61,-46,-36,-15,-3,-5,-13,-29,-42,-57,-84,-106,-100,-67,-21,19,40,
56,55,41,23,22,26,23,18,8,-22,-43,-5,34,52,44,25,44,74,74,51,15,-25,-52,-62,-53,-33,-5,13,15,13,
17,22,23,17,2,-19,-25,-11,-7,-21,-41,-33,-13,-2,-6,-19,-44,-68,-96,-98,-90,-66,-21,24,49,59,64,58,42,25,
16,14,16,19,18,-5,-34,-29,-6,15,9,17,29,55,72,76,60,20,-24,-57,-72,-81,-79,-67,-61,-61,-61,-56,-34,-15,
2,5,9,19,19,7,-11,-12,-13,-29,-52,-66,-77,-82,-85,-66,-42,-16,23,51,61,63,55,43,28,22,22,23,25,24,
27,15,-11,-39,-59,-53,-47,-8,8,32,50,65,65,53,31,4,-11,-27,-44,-55,-56,-53,-60,-68,-48,-19,5,15,26,34,
19,-6,-20,-26,-44,-64,-69,-57,-39,-22,-7,6,21,32,55,65,55,45,39,23,9,8,10,13,17,17,7,11,-11,-48,
-99,-111,-104,-45,-5,-7,5,21,24,32,34,19,-4,-16,-32,-49,-57,-54,-46,-39,-51,-50,-35,-14,-7,-18,-22,-17,-22,-20,
-22,-27,-23,-6,16,31,43,53,56,49,45,36,18,5,-4,-11,-15,-18,-17,-17,-12,-10,-23,-24,-49,-81,-127,-128,-128,-86,
-20,-28,-25,-15,-12,-4,-4,-15,-12,-21,-24,-27,-33,-39,-41,-32,-32,-32,-29,-24,-29,-32,-19,-5,-2,1,9,10,7,12,
22,26,26,20,14,4,-3,-9,-18,-21,-29,-27,-21,-22,-25,-26,-26,-24,-23,-32,-51,-60,-78,-103,-116,-67,-22,-14,-4,11,
11,11,20,30,33,31,30,30,24,21,24,25,35,38,33,28,19,13,20,16,6,-5,-13,-14,-13,-7,0,3,6,0,
-10,-11,-14,-23,-14,-12,-8,-8,-10,-6,-3,-1,6,13,22,36,24,15,13,27,36,28,-26,-20,3,27,29,36,52,68,
71,65,54,50,42,32,25,21,34,24,-3,-28,-37,-33,-23,-29,-51,-58,-55,-39,-23,-10,-2,-1,0,-2,-15,-31,-55,-74,
-55,-28,-14,-9,-8,-5,0,9,18,29,49,53,39,28,29,50,59,40,-12,1,27,46,42,59,83,91,81,65,49,42,
39,37,22,6,-26,-46,-72,-87,-96,-106,-115,-126,-128,-128,-117,-84,-45,-23,-17,-15,-19,-13,-18,-37,-69,-86,-79,-62,-35,-19,
-11,-10,1,14,23,38,51,60,50,48,54,58,41,28,0,28,54,71,78,95,99,85,70,44,18,8,10,13,-2,-22,
-37,-44,-67,-98,-115,-119,-126,-128,-128,-128,-122,-74,-26,-15,-25,-20,-25,-21,-26,-45,-84,-94,-91,-81,-58,-33,-10,3,16,24,
28,44,57,63,54,60,64,52,17,8,16,53,79,98,113,109,91,64,24,13,-1,-7,-4,6,7,-3,3,-8,-25,-37,
-42,-52,-68,-81,-112,-100,-86,-52,-8,1,-11,-7,14,18,13,-20,-68,-88,-89,-85,-73,-47,-12,15,25,24,37,61,68,66,
45,46,40,26,5,-1,46,80,100,116,109,75,36,18,5,1,7,15,19,27,38,46,56,56,55,58,54,35,25,27,
14,7,-5,1,25,34,30,36,47,55,38,-4,-52,-75,-79,-73,-74,-56,-18,22,34,32,48,62,68,55,18,9,2,3,
-1,-13,61,109,117,93,51,-4,-7,2,12,20,26,37,47,52,56,60,72,84,90,87,88,101,116,116,103,99,92,89,
97,95,79,70,67,65,57,36,-9,-73,-92,-81,-70,-68,-33,14,34,43,57,51,40,23,8,-9,1,1,-1,-20,69,93,
70,12,-37,-47,-6,13,13,21,31,41,50,56,64,70,76,91,102,95,81,89,114,118,108,96,95,102,110,113,105,92,
82,67,48,30,-1,-64,-100,-106,-114,-115,-82,-32,9,38,50,52,74,49,24,-1,8,4,1,-4,60,44,-27,-74,-46,-14,
12,5,24,39,48,48,50,50,54,62,62,56,61,51,32,32,53,92,83,68,63,77,84,87,89,85,75,57,45,40,
21,-17,-59,-86,-93,-113,-125,-110,-58,16,76,107,115,89,29,7,17,14,18,17,23,-31,-74,-56,-11,6,29,32,42,42,
38,36,37,36,38,43,46,49,46,25,6,12,31,50,49,48,49,58,54,44,48,54,47,35,28,26,19,-1,-25,-44,
-69,-83,-93,-88,-51,18,82,116,116,88,38,32,33,23,30,19,-34,-93,-78,-17,10,12,39,44,37,25,15,14,18,22,
31,38,45,51,33,11,7,20,27,27,19,35,41,44,35,15,14,27,32,24,18,13,7,0,-9,-20,-39,-49,-53,-41,
-8,32,58,62,75,40,3,13,24,33,50,31,-75,-90,-44,-7,8,25,42,27,17,10,3,5,15,29,39,42,44,35,
4,7,24,29,23,28,26,43,44,45,41,18,7,16,27,21,13,4,-3,-5,-5,-9,-5,-20,-31,-26,-9,7,24,35,
19,-5,-26,-17,-6,12,40,33,-71,-50,-12,-3,17,32,33,16,5,4,1,6,20,33,40,40,36,9,-20,15,36,25,
27,52,80,76,56,47,44,28,12,12,26,18,6,-3,-10,-10,-10,-10,-4,-10,-12,-10,-8,-6,6,17,-2,-25,-46,-44,
-30,-16,-2,-3,-44,-30,-5,7,29,28,21,7,1,0,1,8,18,19,18,18,16,-16,-32,26,38,21,40,76,83,67,
47,45,49,38,17,1,13,8,-3,-10,-12,-17,-19,-18,-23,-26,-16,-6,-2,1,4,-1,-7,-25,-41,-47,-43,-43,-31,-17,
-27,-17,-2,11,25,16,-2,-12,-16,-10,0,10,13,8,3,1,-13,-33,-51,10,22,19,55,78,49,46,33,39,53,46,
24,-2,3,-6,-13,-14,-14,-23,-33,-29,-36,-34,-15,0,0,-1,1,3,-11,-21,-35,-48,-59,-68,-56,-30,-16,-6,6,8,
11,5,-9,-26,-29,-26,-13,1,4,-5,-11,-11,-29,-45,-64,-1,20,29,70,94,74,64,48,46,53,51,28,-2,-14,-17,
-18,-16,-13,-28,-40,-32,-22,-11,7,13,8,8,11,15,8,-13,-32,-51,-65,-70,-58,-33,-9,4,10,-1,-2,-3,-27,-49,
-49,-36,-24,-15,-12,-19,-23,-25,-39,-64,-63,-9,10,17,61,84,71,56,48,48,59,59,25,-6,-12,-13,-6,-1,-1,-24,
-35,-5,8,-10,15,29,16,12,5,13,15,3,-22,-46,-57,-72,-70,-35,-2,9,12,2,-2,-11,-42,-68,-64,-50,-38,-31,
-28,-32,-33,-33,-39,-57,-49,-5,3,2,37,53,48,46,50,51,60,53,18,-9,-1,8,15,19,14,-15,-15,38,22,-19,
-2,21,9,6,1,5,13,3,-21,-43,-51,-67,-72,-43,2,10,13,5,-3,-21,-58,-87,-79,-62,-52,-48,-43,-43,-40,-37,
-38,-50,-42,-15,-19,-18,15,18,38,51,62,64,65,54,33,21,31,43,34,24,11,-13,5,73,34,-35,-34,-2,-2,1,
-1,-6,0,-5,-26,-44,-45,-58,-68,-47,6,12,12,4,-8,-32,-70,-100,-91,-71,-59,-57,-55,-54,-47,-40,-34,-40,-36,-29,
-41,-30,8,12,28,49,62,61,57,49,44,45,54,58,33,14,3,-10,12,73,38,-44,-67,-38,-25,-11,-12,-23,-17,-17,
-35,-50,-46,-53,-60,-42,8,15,12,1,-13,-38,-79,-112,-104,-80,-61,-56,-58,-61,-53,-45,-43,-38,-36,-41,-52,-37,-3,5,
14,34,47,51,53,46,37,33,43,41,15,-4,-5,-5,16,63,47,-29,-75,-66,-46,-24,-23,-27,-25,-23,-44,-60,-58,-60,
-58,-41,13,19,14,1,-11,-37,-83,-122,-113,-85,-59,-50,-53,-60,-55,-47,-48,-40,-41,-49,-58,-44,-34,-38,2,27,38,41,
46,30,7,-3,24,32,13,-14,-14,-1,27,68,70,4,-56,-69,-58,-38,-34,-29,-24,-22,-45,-68,-70,-71,-65,-45,15,23,
17,7,-3,-27,-87,-128,-124,-86,-55,-46,-53,-63,-58,-52,-43,-49,-48,-47,-62,-37,-48,-80,-41,-2,9,8,20,10,-12,-16,
-1,25,15,-2,-5,9,30,63,67,8,-45,-55,-59,-50,-37,-30,-22,-11,-39,-71,-73,-73,-72,-49,14,22,17,8,-2,-26,
-87,-128,-124,-86,-55,-46,-54,-63,-58,-52,-42,-51,-49,-47,-62,-37,-50,-81,-40,1,12,10,21,12,-10,-12,2,28,17,-2,
-6,9,30,65,66,9,-43,-53,-58,-50,-37,-31,-21,-10,-38,-69,-71,-71,-71,-48,10,17,13,0,-11,-37,-80,-120,-111,-86,
-60,-49,-52,-59,-55,-45,-45,-40,-41,-47,-53,-42,-35,-36,3,28,40,43,48,35,14,6,34,42,22,-14,-16,-2,27,68,
71,8,-53,-71,-58,-37,-33,-26,-23,-22,-43,-62,-66,-69,-61,-44,4,10,9,-1,-13,-37,-73,-106,-100,-78,-60,-54,-56,-59,
-53,-44,-40,-38,-36,-39,-46,-33,-8,0,12,32,45,49,53,49,42,39,47,41,13,-10,-9,-7,13,59,49,-26,-73,-67,
-48,-26,-25,-26,-22,-19,-38,-54,-54,-58,-54,-39,0,4,8,1,-8,-30,-62,-91,-84,-66,-55,-53,-53,-51,-45,-39,-31,-38,
-31,-24,-35,-25,5,9,24,44,59,58,55,49,46,48,53,47,20,2,-4,-13,8,66,37,-44,-68,-40,-26,-11,-12,-19,
-11,-8,-26,-42,-42,-50,-54,-39,-5,2,7,1,-3,-18,-50,-77,-70,-54,-45,-43,-40,-39,-36,-33,-35,-47,-34,-9,-16,-17,
10,17,36,45,59,59,58,47,28,22,28,29,18,9,0,-18,1,64,29,-37,-34,-3,-3,1,1,0,10,9,-13,-33,
-38,-54,-61,-43,-14,-1,6,-3,-1,-6,-33,-58,-54,-40,-30,-25,-25,-28,-28,-29,-37,-55,-42,-1,2,1,33,53,50,42,
46,46,51,44,11,-11,-5,-4,1,3,1,-22,-19,27,14,-20,0,21,8,6,6,12,25,18,-6,-30,-42,-59,-62,-38,
-25,-10,2,-5,-1,2,-18,-36,-37,-24,-12,-6,-7,-14,-19,-21,-36,-62,-58,-5,9,17,59,83,70,53,44,41,48,49,
19,-9,-15,-22,-16,-13,-12,-31,-38,-14,-1,-10,19,30,14,12,11,22,27,17,-8,-32,-46,-61,-58,-28,-36,-25,-4,2,
10,10,-1,-14,-18,-12,0,10,11,3,-3,-6,-24,-47,-60,1,21,30,70,93,73,63,46,40,44,40,20,-7,-16,-24,
-23,-22,-19,-34,-44,-39,-29,-15,9,17,10,12,18,25,19,3,-16,-36,-52,-59,-47,-24,-48,-39,-13,5,22,20,5,-1,
-6,2,12,21,23,18,12,8,-9,-34,-49,10,23,21,55,74,48,46,30,33,46,37,17,-6,1,-12,-16,-18,-20,-27,
-39,-39,-45,-39,-15,3,4,6,10,17,4,-5,-20,-36,-49,-57,-44,-21,-62,-57,-22,-1,25,29,29,17,11,13,13,21,
31,31,27,26,22,-19,-33,25,38,21,35,73,80,63,43,41,42,31,11,-4,10,4,-5,-12,-15,-20,-24,-27,-34,-31,
-14,-1,5,11,14,9,6,-13,-29,-37,-37,-37,-19,-6,-84,-74,-33,-17,13,32,36,25,14,15,14,19,33,45,50,50,
43,10,-21,10,31,22,22,49,75,72,50,39,37,23,10,12,25,16,3,-6,-13,-13,-14,-17,-11,-14,-10,-4,0,1,
17,35,18,-17,-47,-45,-31,-14,7,3,-84,-109,-62,-24,-1,23,44,36,24,20,14,15,26,37,48,52,53,41,5,2,
20,25,18,24,23,39,36,34,31,12,4,15,26,19,10,1,-6,-7,-8,-14,-10,-20,-27,-21,-5,14,40,61,43,4,
-33,-25,-9,17,54,43,-40,-108,-93,-34,-6,1,35,48,42,32,23,22,26,29,36,45,54,59,36,13,7,15,19,19,
15,30,34,34,27,10,12,27,32,22,15,10,4,-4,-14,-25,-42,-51,-52,-37,-4,42,74,81,92,53,4,11,20,33,
60,42,17,-43,-90,-77,-32,-13,14,21,43,44,42,41,42,41,42,46,48,52,47,28,5,5,23,40,40,40,40,48,
48,40,46,54,47,34,26,25,18,-1,-25,-43,-65,-83,-95,-93,-54,22,91,127,127,100,38,30,31,21,33,24,57,37,
-37,-89,-71,-45,-15,-17,13,33,46,47,49,52,56,64,63,58,59,49,29,25,49,83,74,63,59,71,79,83,86,82,
74,55,45,43,25,-15,-59,-88,-94,-111,-119,-100,-43,30,85,114,121,91,21,-1,13,9,16,19,67,85,60,4,-49,-70,
-33,-15,-10,7,23,34,43,49,58,66,72,86,94,88,75,83,106,110,99,92,91,98,107,111,102,90,78,63,49,37,
6,-50,-80,-85,-91,-91,-62,-17,20,43,51,51,71,45,12,-12,2,-1,-2,-2,55,100,105,83,45,-6,-17,-24,-21,-8,
5,22,36,40,44,49,61,75,80,72,73,90,102,96,81,84,81,82,95,94,76,68,61,59,62,53,9,-50,-62,-48,
-42,-43,-18,18,35,43,56,48,32,10,-6,-26,-11,-5,-7,-21,42,73,89,104,98,73,35,10,-19,-33,-31,-18,-7,8,
22,32,38,38,36,35,24,5,-5,-3,-14,-13,-17,-9,15,27,27,33,40,52,44,7,-37,-57,-55,-45,-47,-35,-13,15,
29,27,41,58,65,47,6,0,-5,-4,-14,-21,17,49,70,90,103,103,87,59,15,-7,-32,-43,-40,-23,-18,-28,-22,-35,
-58,-74,-81,-88,-98,-109,-128,-123,-104,-67,-20,-5,-13,-12,5,10,8,-18,-53,-64,-62,-59,-50,-30,-7,10,19,19,31,55,
64,61,38,43,36,17,-10,-15,4,30,51,68,75,90,96,89,78,51,22,3,-2,2,-12,-31,-43,-48,-71,-101,-120,-124,
-128,-128,-128,-128,-128,-81,-31,-19,-28,-25,-30,-27,-30,-42,-65,-67,-63,-56,-41,-27,-15,-7,9,20,24,38,51,59,51,60,
63,39,0,-6,-13,6,31,46,42,59,82,93,90,80,70,62,56,53,38,24,-6,-30,-58,-70,-81,-99,-113,-128,-128,-128,
-117,-77,-40,-23,-19,-15,-19,-16,-20,-31,-50,-62,-59,-50,-33,-25,-24,-22,-9,5,15,30,40,53,44,45,51,44,29,21,
-24,-20,2,28,29,35,50,66,72,71,70,71,65,54,44,39,51,40,10,-17,-28,-26,-24,-38,-59,-64,-55,-37,-25,-16,
-10,-8,-6,-8,-18,-31,-51,-68,-55,-35,-26,-24,-24,-21,-16,-6,5,18,36,40,27,20,25,45,58,39,-21,-16,-7,8,
7,10,19,29,33,33,33,35,34,34,33,31,42,43,35,27,18,12,15,8,-4,-12,-18,-21,-20,-15,-8,-3,2,-4,
-14,-18,-22,-29,-22,-19,-16,-17,-17,-15,-13,-8,-2,6,15,26,13,4,11,27,39,28,-27,-43,-56,-71,-70,-71,-58,-52,
-51,-38,-30,-14,-2,3,5,2,0,5,10,14,3,-16,-21,-36,-51,-74,-84,-83,-81,-66,-54,-60,-55,-64,-54,-44,-39,-31,
-36,-39,-39,-49,-50,-50,-47,-34,-32,-29,-29,-24,-34,-48,-26,-26,-28,-9,-20,-43,-59,-76,-67,-78,-81,-80,-55,-39,-16,10,
27,31,27,28,53,67,67,46,11,-35,-67,-101,-126,-128,-128,-128,-128,-128,-113,-99,-103,-98,-75,-46,-15,1,-18,-38,-48,-57,
-57,-54,-55,-46,-49,-55,-53,-60,-81,-85,-66,-66,-37,-4,-16,-35,-46,-63,-59,-61,-45,-19,6,11,15,15,18,17,9,13,
11,22,19,-4,-29,-45,-60,-93,-113,-128,-128,-128,-128,-120,-96,-82,-96,-84,-52,-12,32,47,29,2,-26,-48,-55,-50,-44,-32,
-31,-35,-29,-42,-62,-57,-55,-55,-10,14,-28,-37,-45,-61,-52,-32,-3,23,46,33,2,-22,-30,-32,-26,-14,-11,7,21,17,
-2,-20,-26,-39,-101,-128,-128,-128,-119,-110,-107,-105,-90,-68,-21,26,78,107,103,84,51,25,5,2,18,32,26,16,4,0,
-8,-27,-49,-45,3,28,-16,-38,-50,-58,-26,1,0,6,36,22,-9,-32,-37,-33,-21,-4,24,36,43,42,36,27,22,12,
-34,-67,-86,-82,-66,-58,-68,-76,-72,-50,-3,49,105,127,127,127,127,117,72,41,45,52,55,59,45,34,6,-24,-39,-30,
13,38,-41,-63,-66,-51,-16,-4,-3,20,29,13,-12,-27,-28,-27,-25,-13,-4,8,18,21,19,20,36,48,16,-5,-12,-5,
5,4,-16,-32,-21,-4,5,22,71,127,127,127,127,127,104,67,63,52,51,53,58,40,2,-6,-13,-12,23,31,-59,-81,
-67,-28,16,40,37,36,28,9,-17,-30,-35,-37,-27,-13,-10,-14,-10,-16,-22,6,35,33,8,5,14,19,25,27,18,16,
27,33,10,-14,7,74,127,127,127,127,113,98,91,76,60,47,50,20,17,34,6,29,61,64,-69,-74,-40,11,59,77,
59,31,16,-15,-46,-49,-41,-44,-44,-35,-27,-27,-14,-14,-15,13,24,1,-14,-22,-20,-19,-5,21,30,31,31,30,6,-16,
-20,-2,26,71,104,116,125,122,110,99,85,70,56,32,58,63,31,46,44,45,-58,-41,11,70,80,62,46,15,-27,-44,
-56,-56,-55,-60,-56,-47,-50,-41,-45,-49,-44,-9,4,-51,-68,-71,-50,-40,-31,-12,2,14,16,33,41,31,15,2,-5,-3,
10,31,65,79,68,55,56,76,56,35,46,52,33,26,21,4,-15,34,63,65,64,48,17,-16,-48,-52,-57,-61,-67,-71,
-69,-66,-60,-50,-51,-48,-37,-20,-12,-32,-40,-40,-22,-18,-22,-13,-1,12,20,33,43,46,46,37,24,18,16,13,26,31,
20,-17,-28,-8,-20,-4,16,-2,-19,-19,-21,-25,13,74,81,53,48,30,-10,-38,-58,-60,-68,-77,-81,-75,-63,-56,-54,-38,
-20,-13,-17,-22,-21,-17,-26,-25,-14,-11,-14,-10,2,16,29,33,34,32,31,26,21,17,17,18,13,-5,-22,-46,-59,-50,
-49,-21,-9,-21,-13,-6,-14,-19,36,74,68,47,36,4,-36,-58,-63,-60,-62,-63,-63,-54,-37,-26,-8,-7,12,12,-5,-1,
9,11,-19,-9,-6,-13,-16,-16,0,26,38,42,41,36,32,32,32,26,13,18,17,9,10,-1,-28,-51,-54,-33,-33,-42,
-32,-23,-18,-10,49,65,45,34,22,-16,-47,-67,-57,-51,-47,-42,-34,-25,-9,6,14,2,22,17,-12,4,20,12,-2,21,
22,7,-1,-12,2,38,58,57,50,39,36,42,45,32,26,25,27,27,27,19,2,-19,-40,-46,-57,-61,-60,-48,-26,-6,
34,58,38,20,8,-23,-46,-62,-49,-42,-38,-24,-6,4,8,15,28,11,30,17,-17,4,21,17,26,59,58,35,15,-9,
-1,37,79,71,53,36,34,46,46,25,7,-1,9,21,21,17,20,15,-12,-40,-70,-85,-96,-80,-48,-22,34,44,20,6,
1,-31,-56,-52,-44,-35,-22,-2,16,19,20,28,31,21,29,13,-15,-7,12,23,16,63,74,44,17,1,9,41,79,67,
43,24,16,26,34,7,-20,-40,-12,7,9,19,28,27,6,-33,-80,-111,-121,-112,-88,-44,32,26,3,0,-2,-35,-58,-42,
-35,-28,-15,6,22,23,28,41,40,36,38,8,-13,3,8,17,25,74,80,44,14,2,9,35,65,49,21,-2,-8,10,
32,14,-28,-50,-25,1,6,10,21,30,20,-11,-62,-109,-128,-127,-103,-49,22,13,1,-5,-13,-33,-49,-44,-44,-28,-6,13,
26,30,34,47,49,44,24,14,1,8,9,5,11,78,86,37,6,3,6,20,54,23,-13,-29,-21,5,38,36,-13,-50,
-37,-12,1,10,22,23,32,8,-26,-91,-128,-128,-122,-60,14,8,7,4,-10,-34,-55,-54,-40,-22,1,16,24,27,34,49,
49,47,25,12,15,29,23,36,20,72,80,38,2,-11,-5,20,35,9,-23,-35,-33,-11,35,54,-6,-40,-27,-2,15,19,
28,32,37,26,-1,-69,-128,-128,-128,-71,7,7,14,11,-7,-38,-64,-65,-41,-21,3,17,22,23,32,49,57,53,27,5,
17,43,21,27,16,46,55,36,19,12,13,25,3,5,-14,-27,-40,-20,42,68,-6,-37,-17,12,28,26,33,41,45,44,
26,-43,-124,-128,-128,-83,6,7,14,13,-4,-36,-66,-67,-46,-27,-2,13,20,24,34,52,57,50,29,-4,5,41,18,14,
23,39,48,44,39,36,30,36,23,39,24,-7,-36,-20,48,72,-25,-63,-22,19,29,24,30,38,46,50,40,-25,-113,-128,
-128,-89,10,10,15,14,5,-24,-58,-60,-44,-26,-3,12,22,29,38,53,45,44,34,-1,-8,27,29,45,66,62,58,55,
50,41,25,25,61,67,48,17,-19,-12,45,68,-42,-95,-28,29,29,20,25,30,42,50,49,-12,-106,-128,-128,-94,14,17,
21,20,17,-7,-43,-48,-31,-14,6,20,30,35,41,53,52,46,37,4,-21,-10,6,31,64,42,34,47,50,29,15,28,
80,80,70,57,24,22,64,82,-48,-112,-27,39,32,19,22,28,43,54,60,1,-103,-128,-128,-101,19,19,21,22,30,12,
-28,-40,-33,-14,11,25,34,38,40,50,59,50,40,24,-5,-22,4,-6,20,16,4,11,17,9,19,37,77,89,87,89,
62,69,94,84,-48,-109,-2,45,34,19,9,22,54,64,78,16,-100,-128,-128,-103,20,19,20,21,30,14,-25,-37,-30,-12,
13,27,36,40,41,50,59,50,41,26,-2,-20,5,-6,20,20,9,14,19,13,23,39,82,94,92,92,64,71,95,82,
-49,-107,1,45,34,18,6,21,53,64,79,17,-99,-128,-128,-103,15,17,20,17,13,-8,-39,-39,-16,0,16,28,37,40,
43,54,53,47,40,13,-11,-9,-6,19,58,42,41,55,58,39,22,37,89,91,77,57,25,21,66,85,-47,-107,-26,41,
31,13,15,23,40,53,61,1,-104,-128,-128,-104,10,8,13,11,1,-25,-53,-47,-25,-8,10,23,34,38,44,56,49,45,
37,11,2,22,15,32,56,53,55,58,57,47,30,34,65,70,47,11,-21,-11,48,73,-42,-90,-25,32,28,14,17,25,
40,51,51,-10,-107,-128,-128,-98,5,3,10,8,-11,-40,-62,-53,-23,-6,13,26,35,38,44,58,61,50,32,6,8,27,
3,6,20,30,35,32,34,37,30,37,23,35,17,-16,-39,-20,46,72,-25,-60,-19,22,27,18,22,33,44,53,45,-21,
-112,-128,-128,-93,6,3,11,7,-13,-41,-58,-48,-15,3,21,32,37,38,44,57,61,50,29,13,20,34,15,24,14,42,
44,18,5,7,8,16,-6,-6,-22,-32,-39,-20,39,66,-7,-38,-18,13,26,20,25,35,43,49,34,-36,-120,-128,-128,-86,
14,6,4,2,-11,-32,-45,-34,-12,5,22,32,38,40,46,58,53,44,25,17,17,24,20,30,12,66,71,25,-12,-18,
-10,8,21,-3,-32,-42,-36,-14,33,53,-8,-42,-29,-1,14,15,20,26,38,35,10,-60,-128,-128,-128,-75,26,13,-2,-6,
-9,-27,-37,-23,-14,2,19,30,39,42,46,56,52,41,22,14,-1,2,6,0,3,67,75,27,-6,-7,0,14,45,18,
-16,-34,-27,1,36,34,-16,-54,-38,-11,3,10,17,20,37,19,-15,-82,-128,-128,-127,-65,36,32,5,-2,-2,-29,-45,-23,
-10,-1,12,26,37,36,38,47,41,31,29,7,-15,-7,7,12,23,67,70,34,5,-2,8,32,55,43,17,-8,-13,7,
31,10,-30,-55,-27,1,8,13,22,33,31,1,-49,-99,-127,-126,-110,-53,40,55,26,4,-1,-27,-46,-33,-21,-11,3,20,
32,31,28,32,31,18,22,12,-17,-17,11,22,14,58,66,36,11,-2,5,33,66,58,39,19,10,21,30,1,-28,-49,
-14,10,13,24,33,39,19,-20,-69,-104,-119,-112,-96,-46,36,71,53,24,4,-23,-38,-47,-27,-19,-15,-2,14,17,15,17,
26,8,28,13,-25,-3,19,15,21,52,49,29,12,-11,-5,30,68,63,47,29,26,40,39,17,-5,-8,5,24,27,23,
26,21,-8,-31,-60,-78,-98,-86,-59,-30,47,70,59,44,22,-18,-42,-56,-37,-29,-26,-20,-12,-8,0,9,13,-2,21,15,
-18,-1,21,12,-8,14,12,2,-3,-15,-5,28,48,48,41,29,26,34,37,25,18,18,24,27,28,19,1,-22,-39,-35,
-45,-56,-67,-62,-46,-18,34,71,76,62,45,5,-35,-53,-49,-42,-42,-43,-41,-35,-27,-23,-10,-12,11,14,-7,-3,11,11,
-19,-11,-12,-17,-17,-22,-9,17,29,35,36,31,27,26,26,21,10,15,15,10,12,-1,-33,-61,-59,-27,-24,-42,-47,-46,
-43,-24,16,69,83,66,65,39,-10,-38,-51,-47,-52,-61,-64,-60,-53,-51,-54,-40,-20,-12,-19,-27,-26,-20,-25,-23,-15,-13,
-17,-18,-6,12,25,31,34,31,27,19,14,13,15,16,15,5,-5,-29,-50,-46,-46,-17,-4,-25,-30,-29,-41,-36,-11,33,
65,72,79,60,20,-16,-50,-48,-48,-49,-55,-63,-66,-64,-60,-52,-52,-49,-38,-26,-27,-42,-43,-40,-24,-21,-26,-19,-4,13,
23,35,44,45,42,29,16,14,11,13,34,48,42,12,0,12,-6,6,29,8,-17,-23,-37,-37,-59,-41,15,69,86,75,
56,21,-27,-46,-58,-55,-52,-57,-56,-48,-53,-49,-52,-55,-44,-11,-8,-56,-73,-70,-47,-40,-32,-11,6,19,19,34,39,26,
7,-10,-14,-5,5,22,65,92,90,87,91,101,63,36,53,66,46,33,17,3,-74,-83,-46,5,55,80,72,45,22,-13,
-47,-52,-44,-45,-46,-40,-34,-39,-32,-33,-31,1,10,-13,-20,-24,-15,-12,-1,23,33,35,32,27,-1,-29,-37,-18,18,66,
93,102,120,127,127,123,115,99,70,31,49,68,46,62,62,57,-65,-92,-78,-40,8,40,48,52,41,18,-12,-31,-37,-36,
-28,-21,-20,-26,-26,-34,-40,-9,24,24,4,3,17,24,27,29,18,14,20,22,-2,-28,-12,50,111,127,127,124,110,110,
113,98,85,72,69,24,14,43,26,57,91,84,-50,-77,-78,-64,-31,-15,-1,29,37,29,6,-21,-31,-32,-35,-23,-17,-3,
6,9,7,6,24,44,17,-5,-9,-7,-4,-3,-19,-39,-25,-11,-5,6,47,102,127,127,127,126,100,78,83,69,69,76,
82,55,7,4,16,25,68,60,-24,-54,-63,-71,-43,-18,-12,-3,33,26,-3,-33,-44,-41,-35,-23,3,14,19,22,25,23,
23,19,-24,-60,-81,-82,-74,-68,-75,-79,-66,-46,-9,32,79,115,127,127,127,99,67,49,63,70,74,80,73,57,14,-20,
-18,6,60,63,-35,-51,-56,-70,-61,-41,-12,13,33,26,-3,-30,-40,-42,-37,-23,-19,3,19,18,8,-1,-4,-15,-77,-113,
-128,-128,-123,-112,-100,-90,-80,-61,-23,17,62,89,86,68,43,26,15,16,34,51,47,41,30,27,4,-28,-44,-21,49,53,
-19,-48,-57,-72,-65,-64,-48,-23,3,9,13,9,9,8,1,10,18,31,34,19,-5,-23,-38,-68,-78,-107,-126,-127,-119,-104,
-89,-79,-91,-83,-57,-22,17,35,25,4,-14,-26,-29,-27,-21,-6,-6,-10,0,-9,-32,-41,-43,-33,28,39,-28,-56,-69,-87,
-77,-85,-89,-89,-64,-47,-25,-2,14,20,18,24,53,67,74,58,21,-26,-53,-80,-92,-109,-126,-128,-128,-125,-109,-95,-96,-94,
-74,-44,-13,3,-8,-23,-28,-35,-37,-38,-39,-24,-26,-31,-21,-22,-40,-51,-42,-45,-11,15,-29,-49,-59,-75,-74,-76,-65,-60,
-57,-42,-35,-21,-9,-2,4,2,5,11,15,18,3,-16,-20,-31,-48,-66,-77,-79,-80,-68,-56,-58,-53,-59,-50,-39,-32,-24,
-27,-30,-31,-41,-42,-43,-40,-23,-20,-16,-15,-6,-13,-30,-10,-18,-12,4,-31,-65,-50,-41,-33,-32,-21,-9,0,-2,3,14,
28,43,60,75,89,97,107,115,112,95,68,31,2,-6,-10,-3,3,9,13,11,17,18,12,-11,-23,-22,-26,-36,-46,-50,
-47,-54,-57,-56,-58,-55,-44,-19,-15,-15,-23,-14,-24,-20,-65,-100,-83,-72,-57,-44,-18,6,25,43,70,95,111,127,127,127,
127,127,127,112,95,72,56,39,35,26,13,2,-5,2,13,15,22,29,39,38,32,22,8,0,-18,-47,-68,-78,-86,-103,
-104,-91,-66,-49,-32,-32,-39,-34,-44,-38,-77,-104,-79,-65,-43,-16,26,59,86,98,108,117,115,101,67,23,-23,-41,-57,-53,
-35,-9,32,63,70,56,40,23,13,16,18,11,5,1,11,33,59,70,71,73,55,26,-16,-52,-73,-86,-81,-59,-33,-10,
16,19,12,1,-25,-27,-72,-90,-59,-45,-22,22,69,90,83,77,52,5,-48,-89,-113,-128,-128,-128,-128,-117,-92,-66,-21,20,
40,25,14,6,7,17,17,2,-19,-34,-40,-31,-9,19,47,68,91,89,71,37,-6,-46,-45,-9,12,31,35,45,41,19,
-20,-23,-60,-85,-51,-22,31,75,108,96,61,14,-43,-88,-118,-128,-128,-128,-128,-128,-128,-128,-127,-109,-65,-20,-6,-22,-29,-21,
-4,12,8,-10,-63,-91,-98,-74,-36,3,35,52,58,69,72,53,17,-18,-25,-4,34,52,41,58,35,4,-44,-37,-55,-70,
-18,37,85,94,75,33,-32,-72,-116,-127,-120,-111,-95,-90,-101,-102,-97,-85,-75,-69,-37,9,8,-2,-9,-5,9,18,6,-13,
-65,-116,-128,-128,-125,-60,7,46,50,32,6,-7,4,26,38,43,45,38,22,34,12,-8,-57,-53,-43,-25,46,87,74,42,
4,-35,-56,-74,-79,-65,-49,-37,-26,-21,-24,-15,-4,10,9,-9,-19,-1,12,20,17,20,24,16,2,-10,-39,-69,-120,-128,
-128,-128,-47,10,42,56,47,19,11,31,55,63,52,18,-4,-7,-24,-42,-77,-61,3,43,92,72,16,-32,-46,-39,-35,-24,
-7,2,0,-1,5,7,8,7,8,9,1,-19,-43,-46,-18,2,15,24,30,30,21,6,-1,-16,-40,-68,-110,-118,-85,-51,
-15,12,41,49,39,36,48,58,20,-14,-21,-32,-52,-65,-84,-55,40,98,76,12,-22,-41,-23,-7,6,17,30,32,28,26,
23,19,13,4,6,-4,-31,-41,-52,-83,-28,-5,24,30,29,29,19,-6,-12,-15,-15,-22,-36,-41,-38,-34,-27,-18,-5,18,
44,65,62,40,11,-7,-17,-32,-37,-46,-60,-43,52,76,25,-31,-26,-15,7,33,36,46,49,43,40,39,25,8,-6,-10,
7,-5,-42,-50,-55,-78,-27,-12,13,19,11,5,-3,-20,-18,-25,-29,-33,-36,-29,-19,-14,-5,-1,4,31,70,88,71,48,
38,27,22,1,-17,-28,-37,-23,51,22,-23,-43,-8,23,35,35,48,57,53,40,35,31,18,6,4,6,37,17,-27,-49,
-69,-86,-60,-47,-20,0,12,13,6,-11,-18,-20,-22,-29,-34,-29,-20,-15,-14,-8,0,22,51,64,57,45,40,47,56,43,
19,-4,-27,-31,9,-32,-39,-16,19,39,47,40,49,58,54,39,28,21,17,20,29,41,67,34,-21,-57,-76,-74,-56,-45,
-19,-2,2,4,3,-10,-15,-12,-11,-16,-22,-21,-9,3,15,3,-7,-6,-5,3,16,24,26,36,44,35,15,-9,-22,-25,
-33,-58,-31,7,30,36,45,49,44,53,52,41,33,26,27,36,39,54,82,36,-44,-97,-94,-69,-37,-43,-25,-5,0,2,
3,-15,-21,-17,-15,-18,-24,-26,-15,0,22,15,6,-10,-19,-18,-9,-1,0,6,8,4,-11,-34,-32,-16,-46,-40,3,24,
35,43,40,31,33,44,46,40,38,36,35,41,52,67,98,38,-74,-128,-95,-49,-37,-59,-54,-23,-4,-1,-1,-24,-26,-23,
-20,-18,-23,-29,-23,-9,-3,11,19,10,3,-1,-8,-10,-3,10,10,2,-17,-48,-48,-26,-40,-14,21,28,44,45,23,12,
9,22,34,38,40,40,40,43,59,73,104,44,-96,-128,-90,-60,-51,-50,-49,-39,-12,-2,-1,-7,-21,-22,-19,-14,-20,-27,
-26,-19,-23,1,1,6,21,22,19,28,21,27,30,24,13,-18,-33,-15,-33,-3,28,27,41,35,3,-7,-4,12,27,31,
34,38,42,50,53,83,118,42,-103,-128,-100,-60,-22,-21,-30,-28,-7,-2,-6,-17,-18,-13,-10,-10,-24,-38,-40,-39,-24,-2,
-4,0,21,33,30,33,42,45,52,58,60,27,-7,-8,-16,21,40,43,39,22,-10,-31,-20,7,21,21,28,37,39,46,
61,79,127,50,-102,-128,-101,-34,10,10,0,-10,-2,3,-4,-10,-6,5,6,-12,-36,-38,-38,-45,-31,0,-9,-5,13,23,
40,31,43,51,60,66,76,48,23,1,2,36,52,46,34,10,-22,-38,-28,-3,14,16,25,35,40,49,60,85,127,65,
-67,-108,-74,2,40,32,14,3,-1,-11,-11,-5,2,12,1,-18,-40,-39,-26,-25,-36,-12,-22,-16,6,18,37,36,43,54,
66,72,83,59,36,15,13,43,55,44,22,-7,-37,-51,-39,-17,2,10,22,36,46,57,57,79,123,84,-20,-69,-67,-16,
10,6,-1,-2,-2,-14,-7,11,7,2,-27,-41,-52,-51,-29,-8,-29,-21,-40,-34,-7,11,31,35,43,55,70,79,90,65,
45,27,14,42,49,34,7,-23,-51,-67,-58,-37,-15,-1,15,33,47,60,65,71,101,86,17,-34,-51,-29,2,-2,-12,-16,
-14,-23,-11,15,13,-1,-42,-61,-60,-66,-55,-11,-17,-31,-55,-51,-18,8,30,33,42,57,78,89,97,69,48,28,15,41,
42,23,-5,-34,-60,-78,-76,-57,-33,-14,7,27,42,56,60,66,82,74,29,-13,-17,2,31,31,16,-8,-18,-17,0,22,
26,14,-36,-76,-70,-72,-65,9,15,-30,-62,-57,-25,6,29,31,39,58,86,101,108,75,50,27,16,40,37,17,-9,-38,
-62,-79,-82,-66,-45,-23,1,21,35,48,46,57,66,53,23,-12,6,28,37,32,19,-1,-6,4,22,36,42,30,-23,-83,
-83,-81,-63,37,58,-24,-69,-64,-33,-1,24,26,33,55,89,109,116,80,51,27,19,45,45,26,-4,-33,-61,-77,-85,-66,
-48,-29,0,21,30,45,39,52,64,58,28,-31,13,14,6,13,22,18,7,8,21,31,44,23,-27,-77,-88,-91,-63,37,
84,-21,-66,-67,-36,-12,2,8,22,52,87,105,117,79,53,22,18,45,47,28,-1,-31,-59,-75,-82,-63,-46,-27,1,21,
30,45,40,51,62,56,26,-34,14,17,9,18,28,23,13,14,26,35,45,24,-25,-74,-88,-92,-60,39,83,-21,-64,-66,
-37,-14,0,7,20,50,86,103,116,78,51,21,13,39,38,19,-4,-33,-56,-73,-74,-60,-41,-22,1,20,34,46,45,55,
63,50,21,-13,0,25,38,35,22,0,-1,13,29,40,48,37,-14,-74,-80,-85,-64,37,55,-26,-72,-66,-39,-7,21,24,
29,49,83,105,112,78,46,24,12,38,41,24,-1,-29,-53,-72,-66,-51,-30,-14,5,25,39,52,59,64,82,73,26,-22,
-31,-11,25,26,11,-13,-18,-15,3,26,27,15,-29,-66,-65,-75,-67,9,17,-32,-68,-64,-35,-2,23,25,30,48,75,93,
102,71,43,23,11,38,47,34,10,-19,-46,-61,-49,-31,-12,-1,13,30,44,56,62,67,100,84,10,-49,-69,-45,-12,-11,
-19,-24,-20,-25,-12,14,12,1,-35,-51,-56,-68,-57,-10,-15,-34,-62,-59,-27,2,22,24,30,43,64,78,90,65,41,24,
11,40,54,45,26,-2,-33,-46,-34,-15,3,10,19,32,42,53,54,74,118,78,-31,-85,-83,-34,-6,1,-3,-6,-5,-14,
-9,1,4,6,-16,-31,-47,-52,-32,-12,-32,-25,-47,-41,-12,9,24,24,30,42,55,68,84,62,38,21,1,36,55,49,
38,14,-20,-35,-27,-4,13,16,21,30,36,45,56,78,123,55,-82,-123,-87,-16,19,22,11,0,-1,-4,-6,-9,-2,15,
9,-9,-33,-37,-25,-30,-43,-16,-26,-22,2,15,27,24,31,41,52,62,79,57,31,11,-19,22,44,44,41,24,-9,-28,
-20,4,20,21,25,32,36,43,57,72,119,45,-111,-128,-111,-52,-17,-10,-13,-19,-5,8,3,-8,-9,10,15,0,-25,-32,
-35,-52,-39,-2,-11,-11,7,17,29,21,30,38,46,56,71,47,20,0,-35,-2,31,31,41,34,5,-6,-3,12,26,30,
33,36,40,47,49,70,110,42,-112,-128,-109,-75,-42,-36,-38,-36,-10,3,-3,-16,-18,-7,1,1,-14,-28,-34,-42,-29,0,
-5,-6,14,24,22,23,29,33,40,49,57,29,-3,-7,-39,-14,22,33,45,43,24,16,13,24,34,38,38,38,38,41,
56,63,101,49,-103,-128,-91,-65,-57,-53,-50,-46,-16,3,1,-10,-20,-16,-9,-3,-10,-17,-19,-16,-25,5,-2,0,16,18,
14,20,18,23,26,26,23,-5,-21,-11,-43,-41,1,26,36,40,37,33,39,49,49,40,38,36,35,40,50,60,97,41,
-75,-128,-88,-39,-32,-56,-52,-25,-9,2,2,-26,-29,-21,-12,-10,-16,-23,-17,-4,-2,13,21,9,1,-1,-6,-5,3,17,
15,16,5,-23,-28,-18,-26,-57,-38,-1,27,29,34,46,45,56,56,46,39,34,34,42,40,47,78,38,-43,-91,-79,-53,
-27,-34,-18,-2,0,4,1,-23,-26,-19,-11,-12,-19,-23,-14,-1,23,19,8,-9,-17,-11,2,9,7,18,22,27,19,-5,
-10,-5,16,-29,-42,-26,5,27,34,29,45,58,58,44,36,33,31,32,37,42,67,39,-16,-52,-60,-55,-43,-34,-12,4,
5,3,-3,-19,-21,-16,-10,-12,-21,-21,-10,2,16,9,-3,-4,0,14,26,29,38,54,63,59,42,15,-3,-15,53,25,
-17,-44,-25,3,16,17,37,51,52,41,38,39,28,12,11,15,44,29,-16,-44,-53,-57,-38,-34,-15,4,11,4,-8,-22,
-26,-26,-23,-29,-36,-32,-21,-13,-8,-2,3,24,56,71,65,53,43,55,66,59,39,13,-11,-24,41,71,30,-27,-32,-34,
-20,12,15,31,41,38,37,39,26,6,-7,-7,14,9,-26,-41,-41,-51,1,2,16,17,2,-10,-18,-31,-27,-32,-34,-38,
-41,-32,-19,-10,2,8,11,37,76,90,69,46,42,35,33,18,1,-9,-18,-12,18,74,66,15,-16,-44,-47,-36,-29,-11,
10,19,17,17,17,14,7,-2,5,4,-17,-28,-40,-65,-13,3,28,32,23,17,7,-15,-25,-27,-27,-33,-45,-46,-36,-24,
-15,-11,-10,4,27,47,44,27,9,3,6,0,-10,-23,-36,-32,-10,18,60,58,17,-24,-47,-58,-66,-58,-37,-20,-17,-18,
-15,-13,-13,-13,-7,5,2,-14,-37,-39,-17,2,17,28,31,27,18,3,-10,-25,-50,-79,-114,-119,-87,-52,-24,-3,15,12,
0,-2,15,32,7,-7,3,3,-15,-25,-45,-41,-46,-40,16,62,63,47,17,-22,-58,-89,-104,-90,-70,-58,-51,-52,-57,-45,
-31,-9,-4,-18,-19,8,16,17,15,20,19,7,-6,-16,-47,-77,-128,-128,-128,-128,-77,-24,11,24,10,-22,-31,-11,15,27,
26,11,9,20,10,1,-28,-38,-50,-69,-28,13,61,80,78,50,-5,-54,-115,-128,-128,-128,-122,-119,-128,-128,-125,-104,-86,-75,
-31,31,24,6,0,5,12,17,2,-23,-66,-115,-128,-128,-125,-72,-15,20,24,2,-26,-36,-27,-4,6,10,14,20,28,52,
37,33,-6,-22,-54,-77,-44,-26,16,54,90,90,73,34,-20,-72,-113,-128,-128,-128,-128,-128,-128,-128,-128,-99,-48,3,16,-7,
-15,-9,2,16,10,-11,-59,-83,-95,-79,-46,-7,27,44,44,53,54,33,-10,-47,-57,-42,0,23,34,68,60,45,3,-10,
-65,-81,-51,-39,-18,15,58,83,82,83,65,24,-23,-61,-90,-119,-128,-128,-128,-115,-83,-51,0,45,73,51,35,23,19,24,
17,-2,-21,-32,-39,-33,-13,17,43,58,76,69,48,12,-34,-75,-77,-50,-28,-6,14,45,53,39,8,-8,-75,-97,-70,-59,
-36,-16,18,49,79,96,109,120,119,107,81,40,1,-18,-36,-36,-25,-4,35,66,83,67,48,29,14,12,8,-1,-2,-7,
-1,18,40,49,49,48,26,-7,-50,-79,-96,-109,-103,-84,-70,-47,-14,8,17,12,-1,-11,-61,-94,-77,-68,-50,-42,-23,-3,
16,34,60,83,97,111,127,127,127,127,119,109,91,62,42,27,33,26,16,3,-9,-5,4,5,9,13,21,16,1,-17,
-34,-42,-58,-81,-97,-104,-110,-126,-125,-113,-97,-83,-68,-54,-41,-29,-26,-24,-30,-62,-47,-42,-33,-32,-22,-13,-5,-8,-3,6,
19,33,45,56,67,78,92,103,99,82,54,17,-10,-14,-13,-7,-4,1,5,2,10,8,-3,-29,-47,-49,-52,-57,-62,-65,
-62,-66,-68,-72,-76,-74,-63,-48,-48,-42,-36,-22,-22,-21,-64,-121,-96,-74,-73,-78,-48,-46,-35,-22,-13,-2,9,12,-1,-23,
-29,-30,-30,-25,-35,-47,-29,9,11,18,18,18,17,8,-3,-14,-28,-26,-21,-2,21,30,29,26,31,31,30,32,37,35,
30,33,38,39,27,15,17,-2,24,11,-128,-128,-128,-128,-106,-96,-60,-33,-17,2,25,47,40,5,-25,-39,-43,-54,-71,-73,
-75,-76,-56,-20,18,33,50,64,64,40,2,-29,-40,-45,-57,-56,-35,-4,19,22,29,33,39,47,60,62,55,56,85,81,
46,28,31,26,59,27,-120,-128,-128,-115,-77,-54,-5,42,87,105,117,106,80,51,45,50,48,29,6,-7,-29,-59,-58,-31,
13,34,64,94,108,97,74,54,60,40,-6,-52,-66,-49,-27,-21,-10,5,19,34,50,56,55,63,96,97,56,22,20,38,
92,59,-118,-128,-128,-89,-38,16,95,127,127,127,125,77,47,32,25,17,9,0,-15,-36,-58,-66,-64,-61,-5,22,56,85,
106,115,116,114,124,113,72,22,-21,-48,-44,-33,-42,-23,-12,-10,-3,6,16,37,73,70,35,1,15,70,127,85,-116,-128,
-93,-33,28,97,127,127,127,106,34,0,-5,-18,-44,-69,-78,-84,-88,-96,-107,-101,-100,-105,-36,-12,14,27,33,39,53,68,
75,71,55,42,22,-15,-37,-27,-35,-27,-24,-28,-34,-34,-7,36,63,44,16,0,20,82,127,78,-87,-122,-62,12,84,119,
127,110,59,8,-39,-41,-51,-88,-112,-112,-119,-113,-120,-128,-128,-128,-128,-128,-91,-38,19,46,43,31,31,39,34,8,-10,2,
14,-12,-39,-37,-29,-27,-23,-22,-25,-31,-16,12,22,3,-25,-34,-1,71,127,95,-75,-87,-26,46,108,108,88,42,1,-38,
-77,-88,-93,-104,-106,-101,-95,-77,-90,-122,-128,-114,-104,-102,-46,-14,11,28,36,36,39,39,24,8,5,13,23,3,-34,-51,
-55,-50,-39,-27,-15,0,15,18,16,0,-8,2,46,85,99,69,-73,-72,-2,42,74,51,19,-19,-44,-49,-61,-65,-63,-61,
-55,-49,-60,-52,-58,-70,-64,-56,-57,-42,2,8,2,5,6,1,6,11,16,19,22,12,10,-5,-42,-66,-81,-62,-40,-25,
-6,22,28,15,-3,-25,-46,-29,26,53,63,37,-61,-34,14,43,33,-5,-13,-32,-21,-16,-6,0,-4,-7,-12,-18,-26,-24,
-32,-52,-54,-55,-52,-23,15,-8,-20,-7,-4,-7,-3,-17,-4,0,5,2,-5,-18,-50,-78,-66,-67,-51,-39,-21,3,-4,-29,
-69,-82,-81,-57,-21,18,28,27,-59,-37,5,7,3,-13,-11,-12,14,24,33,31,23,18,12,5,-5,3,-8,-45,-66,-66,
-54,-20,-5,-11,-14,-5,0,5,7,-14,-28,-26,-23,-28,-28,-26,-41,-59,-58,-72,-68,-56,-38,-18,-12,-19,-51,-66,-61,-36,
-7,17,22,26,-39,-27,-2,-30,-40,-40,-19,19,43,46,42,34,29,29,22,10,-2,5,-6,-48,-74,-64,-36,7,27,24,
21,20,9,5,9,-8,-26,-33,-42,-51,-50,-41,-45,-53,-61,-63,-54,-45,-36,-15,5,17,14,2,8,9,2,4,3,10,
-30,-44,-25,-50,-57,-43,-7,47,61,55,41,30,24,19,9,1,-6,-7,-5,-25,-44,-35,-12,31,79,54,39,43,33,20,
19,8,-30,-37,-43,-48,-46,-41,-46,-50,-59,-67,-56,-38,-27,-14,5,21,36,28,34,24,22,32,28,19,-41,-69,-61,-74,
-54,-13,29,63,73,63,44,28,20,14,6,3,3,-6,8,-2,-24,-11,26,83,105,66,38,42,36,19,18,7,-19,-28,
-35,-41,-46,-48,-48,-44,-40,-42,-37,-39,-43,-27,-1,9,21,20,34,32,46,74,70,36,-51,-73,-82,-88,-37,17,57,77,
61,54,34,18,15,15,9,5,11,4,35,28,-8,10,63,127,121,83,49,42,30,20,27,16,-7,-22,-34,-41,-45,-45,
-39,-29,-35,-16,5,-8,-39,-35,-8,2,0,-5,6,11,34,81,91,52,-47,-78,-99,-86,-18,43,73,66,37,15,-5,-10,
2,16,17,10,7,10,63,55,-5,16,101,127,122,88,47,30,26,36,47,25,1,-16,-31,-35,-33,-27,-16,-18,-30,1,
20,10,-13,-18,-3,-9,-8,-31,-34,-38,-9,64,79,50,-47,-91,-113,-89,-18,43,68,48,7,-14,-32,-29,-6,19,22,14,
5,6,70,76,10,28,112,127,110,66,28,30,37,43,50,28,3,-18,-30,-26,-14,-2,0,-19,-44,-15,17,18,-7,-10,
18,23,-4,-37,-50,-61,-36,48,80,60,-53,-107,-106,-89,-26,43,54,33,-8,-28,-40,-30,-10,8,12,11,10,-4,64,91,
27,40,127,127,100,46,10,19,41,54,48,30,2,-32,-29,-2,13,32,32,-4,-36,-30,39,36,-7,-3,20,29,19,-28,
-62,-87,-58,17,71,52,-65,-112,-95,-73,-17,46,46,11,-25,-41,-47,-36,-19,-2,4,5,0,-13,53,93,52,56,115,100,
63,39,22,33,51,55,49,39,27,-8,-5,18,31,62,76,48,-20,-25,43,34,-24,-20,13,25,23,-20,-58,-93,-74,1,
61,45,-68,-109,-83,-59,-8,46,33,-11,-38,-51,-52,-42,-29,-15,-7,-3,-2,-15,29,64,37,25,65,73,58,52,45,55,
62,50,42,44,55,15,8,27,41,81,108,86,-21,-21,47,31,-41,-39,2,15,17,-17,-55,-101,-94,-20,50,41,-62,-106,
-83,-56,-6,39,19,-26,-43,-53,-54,-45,-37,-25,-15,-6,4,-3,17,35,9,-18,9,45,43,40,36,53,67,60,64,77,
64,24,5,21,49,93,105,59,-38,-14,55,36,-36,-43,-3,15,14,-12,-48,-105,-113,-42,39,38,-59,-103,-83,-57,-9,31,
11,-34,-52,-60,-61,-55,-46,-32,-16,-2,1,3,5,6,-15,-44,-41,-24,-30,-4,19,51,77,77,81,91,61,40,23,36,
74,115,94,10,-49,-8,53,38,-20,-36,-3,22,22,-1,-34,-97,-123,-58,28,32,-56,-97,-76,-49,0,40,20,-26,-62,-67,
-69,-65,-54,-35,-15,2,5,7,-15,-44,-68,-92,-103,-105,-75,-7,36,48,62,70,76,77,59,43,25,32,74,113,82,-14,
-55,-11,37,33,-10,-30,0,29,29,6,-21,-86,-122,-65,20,24,-56,-93,-67,-41,20,60,41,-5,-64,-67,-72,-73,-59,-31,
-13,-6,1,2,-25,-74,-122,-128,-128,-128,-85,-15,35,50,54,45,42,51,59,22,-3,12,54,91,68,-11,-42,-21,16,23,
-12,-23,15,36,37,7,-11,-85,-128,-68,19,16,-55,-93,-66,-39,24,64,46,1,-60,-63,-69,-71,-58,-30,-13,-6,-1,-1,
-26,-74,-124,-128,-128,-128,-83,-14,38,55,58,45,40,52,57,20,-3,14,57,94,71,-9,-38,-20,15,23,-11,-21,17,36,
37,6,-12,-86,-128,-70,16,13,-52,-95,-75,-43,4,49,32,-13,-50,-59,-62,-58,-50,-35,-15,4,4,5,-22,-52,-76,-98,
-109,-108,-76,-4,42,54,66,72,76,76,58,41,29,38,80,119,85,-14,-47,-4,39,33,-6,-25,3,29,27,3,-25,-85,
-123,-71,14,17,-55,-104,-85,-53,-4,42,27,-13,-35,-47,-52,-48,-42,-30,-15,0,3,2,-5,-11,-28,-51,-50,-35,-36,-2,
25,56,79,80,86,96,66,45,36,51,87,121,95,9,-39,1,55,38,-15,-28,5,27,21,-4,-39,-99,-128,-66,19,23,
-60,-109,-87,-55,-6,48,39,0,-19,-35,-42,-37,-31,-21,-12,-4,7,-2,7,16,0,-21,-2,27,30,36,41,63,76,68,
72,86,75,37,27,44,67,104,111,62,-22,2,62,41,-27,-33,5,19,12,-17,-55,-109,-122,-53,29,29,-66,-113,-86,-58,
-10,54,53,16,-12,-30,-38,-32,-22,-9,-2,1,-2,-16,16,43,31,26,56,66,57,55,53,69,74,58,50,57,74,34,
31,46,58,94,117,88,-2,0,60,40,-30,-31,7,15,13,-23,-64,-108,-103,-31,40,32,-62,-116,-98,-72,-19,52,61,33,
-3,-22,-32,-27,-13,3,9,11,0,-15,38,71,49,58,107,98,65,39,27,46,65,65,61,59,49,14,16,35,47,76,
88,53,-1,-4,55,42,-17,-16,18,25,20,-25,-69,-103,-83,-10,49,38,-46,-108,-111,-88,-25,48,65,53,12,-10,-25,-20,
-6,10,15,15,8,-6,52,73,30,47,127,127,96,41,12,28,49,59,56,45,20,-13,-12,10,26,42,44,7,-19,-10,
47,40,-3,0,26,31,14,-35,-74,-98,-67,6,57,45,-37,-87,-114,-92,-20,46,74,67,30,8,-12,-15,0,21,23,15,
2,2,62,64,11,29,107,127,103,60,31,37,42,49,53,33,16,-6,-18,-15,-4,4,9,-6,-29,0,27,21,-3,-4,
22,21,-9,-44,-64,-73,-43,34,64,50,-38,-69,-99,-92,-21,44,76,80,64,41,18,7,12,23,21,12,3,8,62,52,
-4,16,98,127,111,81,50,35,31,43,52,27,6,-10,-23,-25,-23,-22,-9,-8,-18,13,25,11,-8,-11,2,-12,-14,-38,
-44,-46,-13,51,63,40,-52,-67,-79,-93,-42,14,58,90,83,77,55,34,27,23,12,4,7,0,36,28,-8,8,56,126,
122,81,51,47,33,22,27,18,-7,-23,-33,-35,-34,-36,-31,-18,-25,-6,14,-2,-32,-26,-7,-8,-7,-14,-8,-3,21,55,
71,39,-47,-72,-60,-74,-59,-16,30,67,90,83,64,44,33,23,11,4,-2,-9,6,-5,-24,-12,21,86,111,68,44,48,
37,20,20,12,-21,-32,-37,-36,-36,-39,-43,-40,-29,-31,-25,-29,-36,-28,-9,-2,10,5,13,11,24,43,47,21,-37,-58,
-32,-49,-58,-45,-9,49,68,67,56,43,36,27,10,-7,-17,-14,-11,-29,-43,-35,-17,34,84,55,45,50,34,22,23,11,
-31,-40,-45,-45,-40,-38,-44,-49,-53,-57,-45,-31,-28,-24,-9,8,16,5,9,0,0,5,8,3,-44,-47,-20,-35,-39,-38,
-24,15,38,46,46,38,34,33,19,0,-13,-8,-13,-53,-78,-67,-37,9,35,28,27,25,10,8,13,-9,-29,-35,-41,-48,
-47,-39,-40,-45,-56,-56,-50,-49,-47,-33,-15,-5,-9,-22,-19,-17,-18,-15,-9,-4,-48,-47,-14,-5,-1,-10,-15,-23,8,22,
35,34,25,17,7,-3,-13,-10,-17,-52,-75,-67,-46,-15,9,1,-6,-2,1,8,9,-15,-32,-28,-22,-26,-30,-28,-41,-57,
-53,-69,-71,-67,-54,-41,-46,-61,-82,-91,-84,-56,-26,2,18,23,-34,-22,2,21,22,-3,-10,-33,-25,-20,-9,-1,-7,-16,
-25,-30,-41,-43,-50,-69,-70,-58,-40,-17,23,2,-14,-8,-9,-15,-12,-22,-11,-8,-2,-3,-12,-26,-57,-85,-78,-82,-75,-70,
-52,-27,-38,-69,-105,-111,-106,-78,-37,9,33,32,-45,-39,3,27,56,46,29,-5,-30,-41,-55,-59,-63,-69,-71,-71,-79,-71,
-79,-94,-89,-70,-52,-41,-7,-3,-10,-8,-10,-17,-10,-2,3,6,14,10,5,-16,-58,-88,-112,-92,-69,-52,-27,9,17,-1,
-30,-51,-69,-54,-1,47,72,48,-56,-51,-5,50,103,107,101,66,23,-14,-52,-68,-80,-97,-109,-115,-112,-91,-102,-128,-128,-113,
-87,-86,-40,-7,11,21,22,18,27,34,22,9,7,12,11,-13,-52,-74,-79,-66,-49,-37,-24,-5,14,16,6,-11,-15,-11,
30,91,120,88,-72,-100,-40,33,101,127,127,127,89,42,0,-4,-18,-58,-90,-96,-115,-111,-113,-128,-128,-128,-117,-115,-60,-11,
36,57,48,27,29,46,47,18,-5,1,10,-15,-45,-50,-44,-37,-26,-20,-21,-30,-20,9,15,5,-17,-29,-7,78,127,118,
-108,-128,-83,-23,37,105,127,127,127,127,82,49,46,37,10,-20,-36,-52,-59,-65,-74,-72,-77,-86,-21,6,30,43,49,51,
62,76,77,63,41,29,12,-21,-44,-38,-41,-33,-28,-30,-33,-34,-12,27,57,40,16,-6,4,82,127,106,-115,-128,-124,-83,
-41,9,91,127,127,127,127,108,76,60,50,38,18,1,-20,-46,-71,-78,-71,-63,-3,31,65,91,110,114,108,100,104,89,
52,9,-27,-52,-49,-39,-45,-26,-13,-9,1,12,22,41,74,68,34,-7,1,75,127,108,-115,-128,-128,-106,-78,-63,-17,27,
76,100,120,110,79,45,31,32,23,-5,-31,-43,-66,-95,-90,-55,1,33,66,91,100,89,67,47,44,28,-12,-52,-63,-45,
-24,-17,-4,13,30,45,63,68,63,66,97,97,58,22,15,51,118,83,-125,-128,-128,-124,-109,-105,-70,-45,-28,-10,15,38,
33,-2,-34,-46,-56,-73,-95,-104,-109,-108,-89,-57,-24,2,28,47,51,31,-3,-31,-41,-45,-55,-51,-24,13,36,39,47,53,
59,67,80,83,73,70,94,93,63,46,36,32,69,41,-66,-117,-91,-73,-75,-81,-52,-50,-43,-30,-20,-9,6,13,0,-23,
-28,-35,-36,-33,-44,-59,-45,-9,-6,2,4,9,15,9,-2,-14,-28,-26,-20,1,28,42,44,40,49,51,50,51,56,54,
48,50,57,58,47,35,23,1,28,18,-14,-18,0,2,-2,-6,9,20,18,20,22,25,19,1,-9,-16,-32,-29,-37,-52,
-56,-58,-62,-58,-44,-30,-21,-17,-20,-30,-37,-39,-34,-42,-32,-17,-6,12,29,22,32,26,25,29,33,39,42,34,22,0,
3,24,24,3,-17,-7,-5,-19,-6,5,16,12,34,59,88,77,63,67,65,43,11,-11,0,0,-14,-30,-25,-12,-14,-12,
-19,-4,4,12,19,13,-13,-37,-49,-53,-56,-40,-14,5,19,24,26,33,42,48,50,52,50,36,40,24,31,43,30,-15,
-45,-60,-18,-16,-4,-1,17,35,59,74,52,25,4,14,23,16,18,21,62,59,51,55,78,97,95,89,28,19,-10,-30,
-36,-46,-66,-86,-72,-63,-54,-37,-23,-27,-21,-9,0,7,19,35,42,37,31,17,3,-11,-15,-28,-54,-116,-124,-104,1,-15,
-7,-7,7,18,16,4,-12,-10,-1,16,28,34,45,51,40,48,44,52,88,124,119,99,68,48,0,-28,-28,-28,-26,-19,
-48,-58,-68,-56,-40,-33,-26,-16,-33,-37,-46,-43,-24,-4,-4,-24,-47,-44,-48,-85,-128,-128,-128,-126,-12,-33,-28,-28,-21,-18,
-4,20,67,52,43,47,45,32,25,20,36,34,29,35,53,66,51,33,56,51,17,2,13,16,18,29,10,10,-3,-34,
-60,-49,-21,-11,-14,-34,-64,-91,-90,-63,-40,-34,-29,-33,-49,-85,-128,-128,-128,-97,-38,-52,-51,-53,-19,13,44,70,74,39,
10,11,13,-8,-33,-53,-59,-59,-52,-32,-25,-28,-40,-40,7,26,10,-9,-4,-4,-10,-11,18,30,35,10,-23,-29,-40,-57,
-31,-25,-30,-53,-75,-76,-62,-48,-35,-14,-24,-72,-128,-128,-128,-85,-27,-63,-62,-48,-6,39,65,56,15,1,-17,-33,-49,-66,
-90,-112,-103,-114,-120,-114,-117,-114,-114,-96,-73,-48,-31,-31,-41,-44,-25,-3,-1,25,53,58,46,32,-3,-29,-42,-39,-45,-45,
-41,-41,-39,-39,-17,15,-4,-42,-87,-123,-111,-56,-53,-89,-79,-40,23,66,65,30,7,-35,-76,-95,-108,-120,-121,-116,-109,-128,
-128,-128,-123,-91,-71,-47,-22,-2,14,21,17,2,-5,-2,8,10,29,51,75,80,54,34,0,2,1,6,11,15,28,33,
30,54,23,-30,-51,-61,-54,-22,-82,-103,-68,-1,47,54,31,1,-51,-76,-110,-128,-128,-128,-114,-104,-97,-90,-70,-48,-16,16,
5,-12,6,50,75,75,59,44,33,14,3,0,1,12,30,55,76,77,37,30,22,45,82,102,110,106,127,103,54,24,
38,24,11,-13,-73,-72,-22,26,24,11,0,-34,-77,-96,-114,-118,-126,-121,-97,-71,-49,-24,1,22,31,16,-7,-7,8,45,
63,64,50,37,31,10,9,6,9,12,4,7,19,23,42,21,-8,0,30,56,67,75,106,118,127,127,127,127,78,20,
-55,-14,27,30,-1,-23,-30,-63,-82,-96,-111,-110,-105,-84,-47,-17,8,25,39,46,-3,-61,-46,-2,49,64,58,54,51,44,
39,16,5,-5,-1,-2,-25,-42,-35,-26,-20,-13,-24,-28,-21,-2,37,81,113,127,127,127,127,127,105,36,-3,42,47,24,
-1,-22,-34,-59,-68,-73,-77,-63,-59,-49,-24,1,26,32,50,42,-48,-87,-19,32,24,38,34,47,57,54,47,15,-1,-15,
-13,-10,-26,-39,-42,-48,-47,-35,-36,-28,-22,-3,46,98,126,127,127,127,127,127,107,49,42,67,49,21,12,-3,-16,-32,
-31,-34,-37,-23,-14,-6,5,12,26,33,63,25,-79,-63,19,12,-43,-2,14,35,40,37,40,9,-14,-20,-16,-12,-18,-16,
-17,-30,-41,-35,-54,-71,-75,-50,4,53,100,127,127,127,127,127,102,50,43,54,37,16,18,11,5,5,-2,-4,-13,-6,
10,31,39,32,27,40,68,-1,-107,-54,5,-71,-68,-1,16,26,29,29,45,31,-13,-12,2,6,-5,-10,-8,-17,-24,-33,
-58,-70,-80,-85,-66,-37,28,80,125,127,127,116,84,38,53,60,30,22,25,23,26,24,20,4,-17,-13,10,40,52,47,
41,50,61,-24,-128,-86,-46,-86,-51,9,20,26,18,24,58,37,-6,3,21,22,-4,-29,-18,-15,-16,-12,-46,-61,-71,-90,
-97,-93,-37,10,67,90,95,78,74,27,55,59,32,22,29,30,35,41,25,5,-23,-27,-4,35,51,42,45,51,51,-36,
-128,-128,-90,-107,-92,-14,18,35,23,13,38,22,-6,-7,17,30,-1,-36,-31,-27,8,23,-6,-23,-39,-70,-92,-98,-89,-39,
17,39,45,44,60,27,52,67,52,35,30,52,60,49,33,17,-19,-38,-17,24,39,35,41,52,36,-35,-128,-128,-116,-117,
-118,-39,12,19,8,9,26,6,-36,-32,7,34,10,-11,-25,-49,-5,75,48,13,-6,-28,-70,-95,-95,-53,-11,7,34,34,
54,36,47,63,61,53,50,73,73,55,34,15,-13,-28,-16,17,36,34,36,33,10,-44,-128,-128,-105,-88,-93,-35,-7,-6,
-2,16,23,-12,-42,-40,12,45,25,7,-21,-61,-5,104,84,29,5,-13,-55,-89,-104,-67,-29,-12,20,24,48,34,43,59,
67,65,63,84,77,54,23,-4,-22,-23,-15,5,23,22,27,21,-3,-44,-118,-128,-109,-84,-79,-31,-4,2,10,18,14,-19,
-45,-44,12,55,46,26,-15,-80,-23,113,105,38,8,-5,-45,-84,-106,-80,-50,-33,-1,8,38,30,46,62,72,71,67,79,
62,37,-1,-35,-50,-36,-24,-8,7,9,27,24,-3,-44,-87,-95,-94,-81,-77,-27,12,35,37,16,2,-11,-45,-56,-16,34,
41,22,-18,-93,-45,96,99,30,-3,-8,-36,-73,-96,-85,-61,-51,-23,-9,30,29,48,70,78,77,70,73,44,13,-26,-64,
-83,-66,-42,-22,-3,7,19,8,-17,-60,-70,-36,-40,-41,-28,30,68,74,59,27,11,7,-18,-39,-26,19,30,13,-20,-102,
-81,64,85,18,-17,-11,-23,-62,-94,-97,-76,-70,-48,-27,21,22,53,81,89,83,80,83,46,6,-43,-80,-107,-96,-67,-36,
-9,8,19,-3,-23,-63,-57,4,11,27,23,82,111,93,64,43,35,24,-22,-43,-41,0,14,11,-13,-110,-111,41,75,5,
-34,-16,-14,-54,-107,-122,-98,-86,-67,-41,12,14,59,84,89,87,89,95,52,0,-57,-87,-116,-116,-88,-49,-16,10,16,-3,
5,-32,-20,24,0,77,82,92,108,92,57,26,16,12,-39,-76,-65,-27,-14,8,-9,-104,-123,27,70,-9,-40,-14,-9,-46,
-106,-128,-101,-87,-81,-53,-2,4,59,83,87,84,88,95,53,2,-55,-85,-113,-114,-85,-45,-13,12,18,0,11,-26,-17,26,
2,83,92,93,103,87,52,21,12,7,-42,-82,-69,-29,-19,4,-10,-102,-122,26,67,-13,-43,-16,-9,-46,-106,-128,-101,-87,
-83,-56,-5,2,51,78,84,75,74,83,49,12,-35,-71,-99,-86,-55,-26,-1,12,22,1,-14,-46,-45,16,40,55,39,93,
114,89,54,36,30,13,-31,-56,-55,-14,-4,-3,-16,-109,-111,38,65,-6,-46,-25,-19,-59,-113,-126,-103,-89,-68,-47,7,10,
48,66,72,69,66,75,50,21,-16,-52,-72,-53,-29,-12,4,13,24,12,-5,-32,-46,-16,-10,-9,-2,46,76,78,59,27,
13,6,-31,-56,-44,0,9,-3,-23,-103,-84,57,71,0,-37,-28,-35,-73,-104,-105,-83,-74,-52,-36,14,16,42,53,63,63,
62,80,67,46,10,-20,-34,-19,-6,5,16,18,33,26,7,-17,-62,-73,-67,-54,-49,-7,29,50,46,19,4,-9,-56,-71,
-30,18,25,12,-18,-91,-51,88,85,12,-24,-27,-49,-86,-109,-95,-69,-59,-33,-21,20,23,35,47,57,59,60,86,82,65,
39,17,0,2,8,22,35,32,32,24,7,-21,-97,-119,-83,-56,-52,-10,16,26,27,27,19,-16,-49,-54,1,40,28,12,
-20,-85,-30,104,92,22,-11,-23,-55,-93,-117,-87,-56,-43,-13,-4,30,26,37,50,51,47,49,77,80,70,57,43,19,6,
14,37,50,44,38,33,17,-28,-128,-128,-83,-63,-76,-22,10,19,19,30,32,-9,-42,-48,3,31,7,-8,-24,-63,-16,93,
72,14,-13,-29,-64,-97,-110,-71,-32,-20,9,17,46,34,43,54,39,29,33,57,69,70,66,54,23,6,19,47,56,47,
44,53,42,-23,-128,-128,-102,-104,-107,-33,21,37,22,17,32,7,-35,-44,-7,18,-10,-29,-32,-52,-16,62,38,2,-20,-43,
-80,-104,-98,-55,-13,1,26,31,55,37,44,50,21,16,29,38,51,66,66,50,25,21,35,62,69,56,48,56,58,-23,
-128,-120,-82,-103,-84,-11,29,51,32,19,42,22,-8,-19,2,14,-17,-51,-42,-42,-16,9,-14,-31,-50,-82,-103,-108,-88,-42,
12,30,39,38,56,25,39,52,19,13,26,32,45,55,63,49,32,34,52,71,76,63,46,59,69,-13,-119,-76,-41,-79,
-47,7,23,33,20,25,58,32,-11,-7,9,9,-15,-43,-32,-34,-47,-33,-56,-68,-84,-106,-112,-103,-44,-1,54,72,78,61,
60,19,21,36,26,6,14,19,24,38,40,36,27,37,54,69,70,55,35,50,76,7,-102,-55,6,-77,-78,-7,17,30,
32,30,40,25,-21,-25,-11,-3,-12,-19,-25,-39,-48,-56,-71,-80,-94,-103,-87,-59,6,58,98,101,108,87,56,23,22,42,
34,13,7,2,1,-5,8,7,4,16,27,36,42,41,41,42,68,34,-75,-70,15,7,-54,-8,12,34,40,37,38,7,
-22,-31,-25,-19,-23,-19,-21,-38,-61,-53,-63,-79,-90,-73,-22,29,72,127,127,127,124,95,69,33,-15,16,21,8,-9,-23,
-23,-39,-36,-37,-41,-30,-21,-6,15,29,44,39,52,50,-42,-91,-24,25,12,27,26,43,56,52,43,11,-10,-23,-18,-12,
-26,-39,-48,-59,-59,-50,-46,-36,-35,-22,26,79,104,127,127,127,127,115,78,30,-54,-30,-4,0,-20,-32,-29,-54,-65,-74,
-86,-85,-75,-47,-10,16,30,36,43,52,6,-56,-50,-18,35,51,51,55,54,44,35,12,2,-8,-4,-2,-24,-41,-39,-37,
-30,-27,-35,-34,-24,-2,41,85,110,127,127,127,127,127,96,26,-63,-79,-48,-10,-11,-14,-12,-37,-74,-85,-96,-97,-100,-94,
-71,-48,-28,-11,9,27,40,31,5,-6,8,45,71,77,60,40,32,10,13,8,11,13,6,10,21,20,35,14,-6,13,
51,84,99,102,127,127,127,127,127,127,106,37,-71,-101,-82,-33,2,9,2,-14,-51,-73,-102,-118,-125,-116,-101,-88,-87,-83,
-62,-48,-18,24,21,7,19,57,84,87,69,51,37,18,6,2,2,12,27,53,78,80,44,45,48,75,109,127,127,127,
127,110,80,69,88,76,57,19,-46,-75,-71,-52,-12,16,16,-9,-16,-47,-79,-96,-106,-114,-115,-111,-104,-123,-127,-128,-127,-93,
-66,-42,-19,4,22,28,19,4,-3,-4,-1,7,28,47,63,71,60,44,18,23,18,13,12,20,39,43,25,29,10,-10,
-10,-16,0,16,-9,-40,-42,-36,-16,3,11,-6,-33,-32,-37,-52,-67,-80,-101,-120,-108,-115,-113,-110,-120,-124,-121,-101,-80,-50,
-26,-26,-45,-53,-35,-19,-13,22,55,57,42,28,-3,-32,-46,-41,-48,-48,-45,-45,-46,-52,-28,-19,-46,-65,-88,-112,-77,-31,
-24,-20,-12,-16,-3,6,8,13,11,-17,-34,-21,-13,-35,-59,-72,-81,-83,-71,-44,-36,-38,-43,-40,9,40,25,-3,-8,-12,
-21,-27,5,21,27,6,-18,-20,-38,-64,-47,-42,-41,-55,-76,-81,-72,-60,-44,-33,-60,-113,-128,-128,-127,-67,-6,-12,3,15,
18,8,-4,-5,24,4,-7,2,14,14,11,8,33,28,25,36,59,74,62,40,63,63,26,-1,5,10,16,29,16,13,
-3,-33,-61,-59,-43,-40,-45,-63,-86,-103,-100,-75,-53,-45,-37,-37,-65,-114,-128,-128,-128,-80,9,-4,7,22,40,50,40,19,
-8,-9,-9,-3,11,29,50,61,52,63,64,70,101,127,122,90,67,52,4,-27,-27,-27,-27,-20,-41,-53,-64,-60,-56,-56,
-54,-43,-54,-52,-51,-43,-28,-12,-13,-29,-47,-41,-51,-99,-128,-128,-128,-122,-16,-13,4,17,39,58,80,91,75,53,34,40,
46,42,49,54,83,78,67,64,76,86,81,74,25,21,-7,-29,-36,-49,-70,-89,-75,-66,-56,-42,-34,-40,-33,-20,-8,6,
23,35,38,32,26,11,-2,-12,-12,-31,-63,-120,-128,-102,-15,-25,-11,11,31,31,50,73,105,98,87,92,91,71,41,17,
24,23,7,-14,-19,-16,-22,-24,-38,-24,-18,-6,9,7,-17,-40,-52,-56,-61,-44,-15,10,27,35,40,45,51,51,49,49,
45,30,42,29,45,49,23,-31,-66,-69,-17,-24,-11,2,3,3,18,31,26,28,29,30,24,10,1,-9,-16,-16,-23,-35,
-43,-51,-57,-56,-49,-39,-33,-28,-26,-31,-35,-38,-33,-39,-29,-12,4,23,36,32,41,35,32,34,35,40,43,36,25,8,
20,34,28,-8,-32,-16,18,38,62,72,62,65,65,53,57,52,52,41,19,-9,-21,-9,-13,-28,-27,-23,-32,-45,-52,-70,
-75,-72,-62,-59,-47,-27,-14,2,-6,-16,-22,-3,8,2,3,22,29,28,24,25,31,23,19,25,14,5,27,87,73,70,
58,7,63,91,109,110,96,91,88,71,55,35,7,-20,-46,-66,-64,-64,-80,-95,-92,-71,-76,-113,-128,-128,-128,-128,-128,-128,
-128,-106,-93,-85,-79,-88,-91,-82,-63,-44,-36,-24,-2,10,26,41,55,48,41,42,34,23,52,111,71,79,70,15,64,100,
108,107,101,96,72,41,-1,-30,-57,-58,-76,-98,-84,-71,-55,-46,-32,-19,-17,-38,-64,-78,-81,-80,-83,-101,-108,-86,-77,-81,
-83,-88,-99,-94,-72,-57,-65,-72,-62,-44,-12,21,47,47,42,42,41,47,101,127,77,76,69,18,54,105,106,107,110,87,
40,8,-68,-77,-65,-36,-30,-24,-8,-9,7,20,24,25,47,70,64,36,37,58,91,77,38,34,24,-16,-37,-61,-105,-128,
-120,-90,-58,-27,-35,-30,-17,2,26,45,51,48,24,59,121,127,115,88,62,21,76,102,108,118,91,11,-57,-75,-91,-78,
-32,12,5,-22,-30,-46,-62,-65,-60,-38,7,59,87,92,57,78,127,127,127,127,127,112,51,24,-20,-58,-90,-103,-72,-19,
13,22,24,20,3,10,45,74,55,95,127,127,127,81,13,-6,74,87,85,56,-37,-109,-91,-51,-26,-15,-15,-29,-63,-79,
-64,-68,-79,-82,-61,-32,-12,8,27,50,-2,-18,4,51,89,115,118,105,86,68,61,51,10,-48,-65,-58,-24,14,47,62,
33,12,5,15,14,98,127,127,127,74,-22,-23,34,54,45,-18,-80,-42,21,43,-9,-33,-58,-69,-72,-60,-37,-22,6,12,
14,13,-9,-44,-85,-96,-120,-101,-89,-59,-20,1,27,53,62,55,51,75,109,95,61,36,29,7,-4,15,29,13,-7,-13,
-8,122,127,127,115,45,-40,-36,35,52,7,-50,-43,39,44,-13,-38,-66,-79,-61,-37,-18,4,19,41,33,-10,-49,-70,-91,
-116,-103,-105,-64,-39,-24,-15,-17,1,34,37,70,80,78,97,125,127,127,127,127,111,28,-19,-26,-6,13,19,127,127,99,
47,-32,-96,-66,31,13,-10,-20,24,36,-12,-31,-60,-63,-64,-54,-42,-24,-1,7,1,15,-32,-45,-58,-69,-50,4,9,10,
8,10,9,12,27,45,60,62,49,39,49,72,112,127,127,127,127,127,80,-11,-29,-19,22,91,60,1,-52,-110,-128,-73,
-13,-9,4,17,14,-6,-22,-17,-14,-37,-59,-68,-67,-55,-35,-29,-24,-19,-22,-16,-28,-10,7,20,20,20,18,23,22,21,
25,28,36,39,30,18,16,24,50,78,109,127,127,127,127,74,28,13,38,63,4,-55,-84,-108,-126,-94,-13,18,45,48,
14,-3,13,20,19,-13,-51,-70,-71,-59,-37,-26,-13,-4,30,29,-16,3,17,14,28,25,25,22,11,17,31,28,31,35,
28,18,10,8,18,29,43,62,78,94,97,55,22,14,-12,6,-25,-50,-64,-69,-75,-48,31,82,61,18,14,26,34,28,
13,-4,-38,-61,-60,-44,-23,-12,-9,31,83,46,-35,-22,9,22,21,28,41,39,15,14,27,21,13,23,19,7,-4,-14,
-23,-32,-31,-10,7,18,28,11,-7,-17,-27,-29,-49,-50,-43,-23,-21,-7,53,87,47,9,34,52,36,22,11,11,-11,-35,
-40,-34,-19,-8,20,81,116,36,-60,-26,28,46,18,30,44,46,20,4,1,-12,-7,11,12,-3,-14,-28,-60,-92,-116,-88,
-59,-37,-6,10,7,-5,0,3,-5,-5,-20,-18,-16,-13,54,54,36,26,35,53,43,17,33,28,2,-21,-31,-32,-16,2,
44,103,112,-6,-99,-26,43,35,39,39,44,50,34,9,-11,-30,-31,-11,-14,-25,-18,-16,-46,-83,-108,-101,-91,-77,-39,-12,
-1,5,-10,6,5,17,0,-15,-27,-31,40,37,30,35,42,44,54,31,34,19,-5,-18,-28,-40,-23,6,67,127,107,-30,
-128,-34,75,58,60,41,35,52,46,5,-25,-40,-19,-3,-2,-9,13,10,-22,-52,-71,-79,-65,-55,-41,-14,8,25,-20,-14,
-26,-9,-6,-17,-37,-30,29,32,27,40,60,43,38,37,24,9,-6,-10,-23,-42,-25,8,75,127,127,-38,-128,-58,71,80,
84,66,45,48,43,-2,-38,-50,6,18,12,7,20,32,28,27,-17,-37,-23,-21,-31,-23,-4,18,10,-4,-50,-31,-5,-12,
-35,-24,16,30,35,50,61,51,40,37,11,1,-10,-22,-36,-45,-28,3,75,127,127,-57,-128,-57,38,60,99,115,69,46,
39,-26,-49,-12,50,60,36,20,11,27,58,51,-24,-57,-34,-28,-30,-13,0,19,16,-11,-44,-50,-24,-25,-20,-19,17,32,
40,52,64,54,34,23,-4,-17,-26,-30,-35,-44,-30,-3,67,127,127,-49,-128,-98,1,35,77,87,64,50,25,-33,-23,39,
87,93,55,27,14,38,68,23,-76,-86,-36,-21,-33,-14,8,30,32,5,-42,-59,-37,-35,-22,-19,13,26,32,45,62,56,
32,13,-14,-30,-40,-39,-36,-42,-34,-11,28,127,127,-26,-128,-109,-11,14,66,60,51,41,15,-9,26,76,64,99,76,43,
17,31,59,-26,-106,-102,-44,-19,-37,-26,5,39,57,33,-29,-64,-46,-41,-23,-19,3,14,20,38,62,64,42,13,-12,-33,
-46,-46,-42,-48,-42,-25,0,80,103,-6,-128,-111,-28,-6,34,27,33,33,21,18,34,42,2,67,75,59,34,37,53,-62,
-115,-101,-54,-23,-40,-46,-11,43,69,49,-23,-69,-51,-43,-22,-20,-3,4,10,37,71,81,58,20,-8,-36,-55,-56,-52,-55,
-52,-43,-24,29,39,-18,-112,-119,-59,-8,28,12,24,34,30,17,3,-5,31,74,62,53,31,30,32,-88,-128,-93,-53,-30,
-51,-64,-29,40,65,45,-36,-83,-59,-46,-22,-20,-2,4,10,43,86,101,73,24,-11,-45,-68,-67,-57,-56,-58,-58,-47,-4,
1,-30,-84,-127,-93,-42,-8,-29,-10,14,16,-2,-17,-4,43,63,31,30,10,7,3,-106,-128,-94,-44,-33,-61,-71,-31,40,
58,37,-47,-93,-68,-54,-24,-18,-1,8,15,47,99,121,81,28,-19,-52,-69,-69,-60,-55,-55,-62,-42,-2,17,-33,-95,-128,
-78,-54,-57,-57,-45,-36,-34,-25,-10,5,6,6,-14,-26,-37,-15,-9,-99,-128,-93,-26,-11,-66,-68,-37,18,40,32,-45,-87,
-68,-63,-27,-6,0,9,16,48,99,122,81,27,-23,-56,-73,-72,-61,-56,-56,-64,-49,-4,22,-28,-89,-128,-68,-43,-45,-43,
-30,-23,-21,-10,2,13,14,14,-10,-28,-38,-12,-8,-101,-128,-92,-25,-10,-67,-70,-39,15,39,32,-43,-85,-67,-63,-26,-4,
-2,5,11,46,86,95,68,18,-21,-56,-79,-76,-60,-57,-62,-64,-54,-5,7,-19,-57,-90,-62,-2,30,3,23,43,44,26,
10,28,57,79,31,25,8,12,11,-102,-128,-86,-42,-38,-65,-77,-34,39,59,40,-45,-92,-67,-51,-18,-13,-6,5,13,41,
72,74,47,9,-21,-47,-64,-62,-54,-56,-56,-49,-31,27,47,5,-68,-68,-12,47,81,53,56,52,46,43,32,27,49,79,
49,35,19,28,36,-83,-122,-84,-49,-34,-55,-67,-27,43,67,49,-31,-81,-57,-41,-12,-11,-3,13,22,39,59,51,23,-5,
-26,-41,-49,-46,-42,-49,-45,-28,-7,73,108,20,-106,-67,10,42,86,70,68,51,37,44,56,59,22,61,55,36,19,33,
56,-56,-98,-92,-51,-29,-48,-50,-9,47,76,57,-16,-66,-48,-35,-9,-10,7,25,32,42,54,40,9,-11,-27,-36,-38,-34,
-33,-43,-35,-10,28,127,127,5,-128,-82,8,36,85,79,71,49,19,1,33,80,61,75,51,22,2,27,61,-18,-93,-98,
-42,-23,-46,-31,6,44,70,45,-20,-58,-41,-31,-10,-8,12,30,38,48,55,37,10,-3,-17,-23,-25,-25,-30,-40,-26,3,
71,127,127,-18,-128,-85,12,48,86,93,72,49,17,-40,-29,39,76,72,38,15,-1,28,59,22,-73,-91,-36,-19,-37,-17,
13,39,47,15,-34,-52,-30,-24,-8,-7,12,27,32,44,52,35,17,12,-2,-6,-12,-20,-30,-38,-20,12,79,127,127,-35,
-128,-68,35,67,103,113,71,45,30,-37,-60,-20,39,48,31,19,7,24,47,43,-33,-69,-34,-20,-28,-10,10,36,28,-4,
-37,-40,-14,-12,-3,-4,32,34,24,34,50,29,18,15,9,1,-9,-11,-19,-33,-16,18,75,127,127,-29,-128,-78,50,70,
75,58,40,44,40,-9,-47,-57,-1,14,13,14,26,34,24,20,-30,-51,-24,-14,-23,-13,7,31,16,-3,-38,-22,3,2,
-10,-6,56,47,27,28,37,32,32,11,16,9,-8,-17,-23,-32,-14,17,71,124,104,-26,-128,-65,52,50,61,32,26,49,
48,6,-24,-41,-19,-4,2,2,33,26,-15,-52,-77,-78,-49,-35,-25,-3,13,27,-14,-14,-21,-7,2,0,-9,-9,79,75,
41,18,24,44,24,-1,10,11,-7,-26,-33,-28,-7,13,53,100,109,-18,-120,-52,17,15,45,37,36,44,35,14,-5,-25,
-27,-10,-12,-17,-3,0,-32,-73,-93,-83,-70,-57,-21,-4,0,5,-13,2,0,14,12,2,-1,-14,84,124,65,5,20,42,
24,9,-10,-11,-29,-49,-50,-39,-17,-3,29,80,110,18,-77,-41,9,22,7,17,32,43,27,10,4,-7,5,21,22,10,
0,-15,-45,-76,-105,-72,-39,-20,3,5,-7,-23,-17,-13,-21,-12,-13,-10,-2,-5,74,127,90,22,0,10,22,13,-8,-27,
-60,-81,-79,-57,-27,-11,-1,40,80,28,-49,-33,-6,-1,3,12,28,37,24,22,34,33,26,37,35,23,8,-2,-11,-19,
-12,7,20,22,20,-5,-27,-43,-48,-50,-71,-66,-49,-27,-10,4,43,97,97,72,15,-17,-5,6,-3,-35,-71,-91,-92,-74,
-45,-29,-12,5,29,12,-30,-11,-2,-12,2,5,11,20,22,29,45,45,50,53,46,33,23,21,31,41,55,74,83,81,
64,13,-16,-25,-52,-40,-74,-89,-91,-84,-69,-39,34,82,90,69,36,-7,-40,-33,-29,-50,-69,-79,-80,-67,-43,-33,-27,-18,
-25,-34,-48,-31,-18,-16,-13,-2,3,17,28,37,48,54,62,62,49,34,28,34,59,87,112,125,122,120,97,33,-3,-9,
11,33,-23,-70,-94,-114,-116,-84,43,84,92,66,69,55,-15,-45,-69,-70,-64,-49,-39,-23,-1,9,2,12,-35,-65,-92,-101,
-83,-43,-35,-12,-1,8,15,27,52,70,77,74,55,42,51,73,112,127,127,127,127,127,68,-24,-34,-7,38,99,64,8,
-51,-118,-128,-77,25,67,78,53,45,84,53,-7,-43,-67,-72,-48,-24,-9,10,23,42,34,-7,-51,-87,-113,-128,-128,-128,-84,
-46,-26,-13,-7,17,41,37,59,60,61,81,103,127,127,127,127,124,32,-26,-37,-10,19,29,127,127,86,25,-60,-117,-78,
17,29,51,39,4,23,43,46,7,-28,-57,-58,-51,-37,-19,-6,21,30,30,24,-9,-47,-90,-108,-128,-102,-82,-52,-21,-3,
20,36,27,19,11,31,61,48,24,17,22,2,-4,15,26,6,-25,-42,-23,121,127,115,85,10,-71,-60,52,54,49,38,
-16,-68,-55,-17,12,20,10,-7,-40,-55,-40,-51,-59,-62,-44,-17,-2,6,16,39,-19,-44,-20,31,64,85,84,64,41,21,
20,12,-33,-88,-93,-77,-49,-6,31,44,12,-8,-23,-24,-33,75,127,127,127,37,-65,-54,56,74,76,80,58,-6,-51,-50,
-32,-15,23,54,42,12,-1,-27,-57,-61,-54,-32,5,44,60,65,37,44,113,127,127,127,127,107,33,2,-49,-99,-128,-128,
-97,-46,-19,-4,-1,-5,-24,-16,13,37,8,56,127,127,120,48,-31,-36,40,75,77,77,74,47,8,-11,-60,-43,-15,10,
12,16,26,13,18,20,16,11,27,50,56,43,45,49,83,76,32,18,2,-40,-68,-101,-128,-128,-128,-113,-77,-51,-59,-51,
-40,-20,5,18,21,16,-17,5,79,110,91,53,15,-10,51,73,76,74,66,55,26,-4,-50,-67,-77,-57,-62,-78,-60,-44,
-26,-22,-9,-2,-5,-22,-45,-61,-82,-91,-99,-123,-128,-128,-126,-128,-128,-128,-128,-128,-101,-75,-82,-92,-86,-64,-35,-5,17,9,
-2,-6,-14,-19,41,87,44,33,16,-17,49,68,76,70,53,46,38,17,-7,-25,-47,-62,-73,-83,-77,-77,-85,-94,-78,-50,
-53,-92,-128,-128,-128,-128,-128,-128,-128,-128,-128,-128,-123,-126,-126,-118,-96,-75,-68,-55,-38,-28,-19,-9,5,-10,-20,-19,-33,-52,
-14,60,38,31,13,-24,6,19,36,41,29,30,25,10,20,11,15,10,-7,-34,-45,-27,-31,-42,-37,-37,-49,-62,-78,-107,
-110,-101,-87,-85,-76,-58,-44,-27,-29,-37,-45,-31,-18,-17,-12,5,7,7,2,4,12,-1,-8,-2,-13,-30,-7,59,57,46,
24,-17,-10,4,-15,-13,-4,4,10,26,19,24,42,69,83,79,84,94,77,75,94,114,117,105,92,85,58,31,8,3,
-7,-22,-22,-18,-26,-25,-20,-43,-62,-51,-53,-64,-67,-65,-68,-75,-71,-81,-91,-93,-84,-72,-51,-35,11,-12,-50,-69,-25,-18,
-25,-2,25,52,60,61,74,72,71,79,88,100,118,118,109,99,119,127,127,127,127,127,80,66,51,38,9,-24,-50,-67,
-78,-84,-81,-83,-73,-55,-58,-64,-72,-82,-92,-96,-97,-118,-122,-115,-126,-118,-61,-30,29,-2,-59,-74,9,32,32,58,88,100,
74,41,14,4,-13,-9,-9,-29,-54,-93,-107,-109,-76,-22,20,46,94,127,127,127,126,105,72,42,9,-21,-67,-86,-102,-103,
-76,-44,-23,-11,7,-15,-46,-74,-96,-114,-111,-111,-119,-124,-57,-26,22,-17,-77,-92,48,61,58,72,84,62,5,-47,-98,-94,
-97,-110,-127,-128,-128,-128,-128,-128,-128,-109,-50,7,62,107,127,127,127,127,127,127,104,71,-5,-28,-41,-44,-38,-12,14,25,
44,44,39,20,-35,-89,-104,-115,-115,-122,-69,-34,7,-28,-65,-69,62,72,64,77,59,10,-56,-94,-88,-97,-87,-64,-43,-38,
-48,-72,-81,-90,-101,-104,-82,-48,-18,-2,8,40,107,127,127,127,127,118,45,9,7,16,2,2,29,39,35,43,48,35,
7,-18,-64,-117,-93,-96,-47,-32,-28,-48,-44,-28,60,75,62,35,-21,-54,-73,-70,-41,-32,-16,4,17,22,22,2,-27,-45,
-62,-71,-58,-33,-18,-24,-55,-36,12,34,16,21,48,62,56,3,-21,-26,-46,-31,19,44,73,38,-7,-39,-34,-9,-43,-83,
-108,-116,-55,-59,-81,-72,-35,-14,57,52,23,-52,-100,-76,-54,-22,6,29,63,88,87,71,52,32,10,-4,-23,-40,-38,-38,
-66,-82,-128,-123,-88,-61,-61,-62,-47,-36,-32,-55,-59,-66,-101,-83,-26,11,63,71,46,-11,-36,-40,-63,-56,-59,-39,18,-14,
-64,-59,-11,21,45,26,-30,-78,-75,-42,-30,19,48,73,101,109,87,60,45,35,0,-12,-37,-64,-67,-65,-74,-71,-77,-81,
-72,-54,-45,-40,-32,-29,-34,-47,-31,-21,-64,-75,-46,-18,24,69,93,77,47,6,-14,-10,11,39,77,26,-27,-25,11,39,
23,-21,-71,-102,-71,-32,0,37,82,112,127,117,83,53,24,3,-12,-24,-45,-72,-68,-32,-34,-36,-65,-74,-76,-64,-53,-50,
-55,-58,-33,-21,-8,-4,-11,-30,-31,-11,2,15,42,78,92,69,57,71,90,110,95,-4,-39,-22,4,28,-3,-48,-80,-79,
-63,-34,35,81,113,119,123,103,71,40,11,-9,-22,-42,-60,-66,-52,-25,-10,8,8,-13,-26,-39,-57,-59,-60,-70,-58,-44,
-20,1,6,-12,-29,-23,9,32,48,61,57,42,43,70,79,108,119,53,29,33,32,26,-34,-80,-85,-54,-39,-7,71,94,
101,88,84,71,44,14,-12,-24,-38,-53,-57,-41,-33,-24,-2,25,33,1,-4,-16,-47,-48,-47,-65,-68,-51,-24,2,12,-6,
-28,-32,-53,-23,20,58,70,54,27,22,68,110,127,127,127,127,101,51,-42,-74,-72,-51,-26,20,76,73,64,54,55,40,
9,-20,-35,-36,-29,-33,-24,-8,-22,-19,21,58,40,-10,-4,-4,-46,-58,-56,-68,-73,-51,-17,9,18,4,-26,-46,-69,-68,
-32,14,43,58,47,33,39,66,109,127,127,127,112,54,-36,-58,-57,-52,-15,37,62,44,23,22,30,15,-15,-29,-27,-18,
-25,-14,21,24,-16,-14,41,89,65,-15,-6,12,-34,-56,-58,-70,-68,-47,-11,10,20,20,-5,-37,-77,-86,-59,-29,-10,29,
44,32,29,43,69,79,78,87,86,41,-43,-77,-68,-53,-7,36,27,-7,-10,-5,11,4,-14,-23,-27,-22,-24,4,54,40,
-11,-2,53,108,85,-8,5,34,-8,-29,-41,-61,-72,-45,-1,24,34,44,24,-17,-85,-88,-58,-33,-41,-31,1,24,45,50,
58,46,36,46,42,7,-62,-108,-92,-52,5,19,-10,-24,-12,1,10,0,-16,-28,-29,-28,-16,23,67,24,-18,13,52,101,
53,11,48,63,20,3,-20,-37,-38,-6,27,37,36,37,23,-3,-50,-61,-53,-53,-63,-63,-45,-19,-6,7,21,0,-15,-3,
12,-2,-78,-125,-108,-59,2,6,-21,-12,-3,2,3,-3,-14,-27,-31,-26,-12,37,85,31,-16,27,66,108,89,60,85,82,
33,2,-21,-12,21,43,65,56,31,34,36,16,-7,-18,-18,-36,-58,-69,-70,-61,-30,-26,-11,-31,-52,-43,-21,-13,-92,-128,
-112,-62,-9,2,-15,-14,0,9,15,10,-8,-17,-14,-16,-4,31,85,37,-12,38,118,127,127,119,101,83,47,6,-5,15,
66,82,84,64,21,43,71,67,47,17,-8,-24,-44,-62,-74,-68,-49,-41,-28,-41,-58,-50,-25,-7,-100,-128,-117,-66,-18,-5,
-8,1,16,25,27,19,2,-7,-6,-12,3,33,81,46,-7,35,119,127,127,125,90,54,20,4,16,42,90,114,96,57,
15,29,54,49,44,22,7,-13,-32,-41,-50,-53,-52,-51,-39,-48,-63,-51,-25,-9,-100,-128,-114,-68,-25,-9,0,20,36,46,
45,34,16,6,5,-1,-2,29,77,54,-3,23,87,115,94,81,59,30,0,-12,-3,9,63,109,88,55,32,36,40,21,
32,24,17,2,-9,-13,-24,-33,-38,-47,-39,-52,-69,-53,-23,-8,-93,-128,-112,-72,-34,-14,6,35,52,62,62,47,27,14,
12,6,-9,15,50,28,-30,-16,31,36,34,18,-11,-30,-38,-35,-28,-27,23,81,70,57,53,48,30,-13,22,26,30,16,
10,2,-12,-18,-18,-34,-25,-43,-70,-50,-14,-1,-96,-128,-123,-92,-53,-23,10,47,71,80,76,58,33,18,15,8,-9,-6,
8,-5,-42,-42,-15,-21,-4,-17,-45,-54,-49,-42,-24,-12,32,76,75,64,48,42,19,-31,-5,20,39,24,10,-3,-9,-2,
-13,-29,-13,-31,-65,-46,-7,5,-103,-128,-128,-106,-63,-21,22,59,94,97,88,65,37,23,17,7,-13,-28,-20,-12,-21,-38,
-38,-61,-45,-40,-47,-32,-14,-10,-4,2,47,81,101,94,53,38,14,-30,-50,-2,41,26,3,-10,-2,15,-16,-35,-9,-21,
-59,-44,-3,7,-102,-128,-128,-103,-56,-6,48,61,102,96,84,68,44,28,19,7,-17,-24,-39,-26,-13,-38,-41,-68,-76,-45,
-25,-11,-3,-4,-4,-10,7,62,116,127,76,42,21,-7,-47,-21,31,33,14,-2,3,23,-4,-49,-17,-13,-55,-35,-8,8,
-102,-128,-128,-100,-52,-2,51,61,101,94,84,68,45,29,20,7,-20,-25,-40,-28,-14,-41,-44,-67,-83,-51,-30,-16,-7,-5,
-5,-11,5,62,118,127,79,45,22,-5,-44,-20,32,35,17,2,6,24,1,-47,-16,-11,-53,-33,-6,10,-104,-128,-128,-100,
-56,-13,21,60,94,98,87,64,37,24,18,3,-15,-34,-20,-14,-24,-47,-50,-63,-54,-46,-52,-33,-14,-15,-13,-5,39,76,
105,102,64,48,12,-36,-53,1,47,30,5,-3,9,19,-10,-27,-3,-15,-53,-41,5,12,-95,-128,-122,-86,-46,-15,11,48,
76,82,76,57,32,19,15,4,-10,-11,8,-7,-46,-55,-27,-21,-2,-16,-45,-56,-51,-44,-30,-18,26,72,81,70,54,46,
17,-36,-7,24,47,30,15,5,1,3,-5,-21,-6,-23,-55,-40,3,10,-93,-128,-115,-71,-31,-9,8,37,58,65,63,48,
29,17,15,6,-8,15,54,28,-40,-36,16,35,40,21,-9,-33,-46,-43,-36,-32,19,79,79,60,53,48,29,-14,22,30,
38,23,18,10,-4,-10,-9,-25,-18,-34,-59,-42,-3,5,-102,-128,-119,-71,-26,-6,4,24,39,47,46,38,22,13,12,4,
0,35,88,60,-13,8,78,113,95,79,58,26,-6,-20,-16,-2,56,105,94,58,31,34,41,19,32,26,24,8,-2,-6,
-16,-22,-30,-38,-30,-42,-59,-47,-11,-2,-104,-128,-123,-71,-20,-2,-5,4,17,25,28,25,12,3,3,-4,11,45,96,56,
-13,26,116,127,127,127,94,56,18,-2,2,31,86,111,96,56,13,29,57,51,45,22,13,-9,-26,-33,-41,-44,-46,-44,
-30,-38,-54,-45,-13,-1,-95,-128,-117,-66,-8,6,-14,-14,0,8,16,16,3,-8,-6,-8,14,52,105,53,-9,40,125,127,
127,127,110,82,44,3,-14,8,64,81,82,60,17,39,70,68,50,16,-3,-21,-39,-53,-65,-62,-44,-33,-17,-31,-49,-44,
-13,0,-79,-123,-107,-60,5,15,-16,-12,-4,1,5,5,-5,-19,-20,-13,10,61,109,48,-6,40,89,127,108,77,91,81,
37,9,-19,-14,20,43,60,49,25,27,32,20,2,-17,-18,-34,-51,-62,-64,-56,-21,-13,-1,-25,-47,-41,-11,-6,-62,-103,
-88,-52,10,30,-2,-15,-12,0,8,4,-10,-21,-18,-13,7,56,98,37,-11,28,72,115,65,29,57,60,22,11,-14,-36,
-36,-4,25,33,36,32,15,-3,-43,-57,-50,-52,-59,-62,-47,-20,4,19,25,-6,-23,-12,14,2,-36,-69,-62,-53,-2,49,
37,3,-5,-7,8,7,-9,-17,-17,-5,0,40,90,55,-8,4,60,106,83,-3,7,34,-1,-17,-31,-53,-65,-43,-1,24,
34,43,22,-16,-77,-86,-65,-42,-47,-40,-11,18,49,50,44,23,10,27,35,7,-19,-45,-51,-48,-6,51,75,61,33,25,
30,13,-16,-28,-19,0,5,25,57,38,-16,-16,38,81,56,-15,-7,10,-27,-41,-47,-66,-60,-45,-13,7,18,20,-5,-35,
-76,-92,-74,-48,-31,4,19,13,5,20,39,41,40,60,70,32,-21,-54,-62,-44,-16,35,90,90,73,58,53,35,5,-18,
-24,-15,1,4,13,12,-19,-25,17,53,36,-8,-5,-7,-38,-46,-48,-64,-71,-52,-21,3,14,2,-33,-59,-80,-89,-61,-18,
12,30,16,-2,5,34,74,86,91,98,87,38,-22,-57,-65,-40,-28,7,84,110,115,97,86,70,47,25,8,4,-5,-16,
-24,-19,-26,-28,-11,8,20,-6,-9,-15,-37,-39,-42,-59,-66,-54,-32,-9,2,-13,-42,-56,-85,-65,-23,19,31,18,-6,-10,
34,69,111,101,92,84,62,28,-16,-44,-63,-61,-52,-24,45,97,127,127,127,115,87,64,41,25,17,-6,-29,-42,-44,-28,
-19,-10,-15,-28,-33,-37,-49,-55,-58,-68,-59,-49,-30,-11,-9,-31,-57,-63,-40,-14,8,30,36,29,41,72,60,59,61,1,
-18,-5,2,8,-14,-49,-73,-82,-54,-24,5,50,101,127,127,127,109,85,62,44,29,10,-17,-46,-55,-34,-45,-57,-85,-88,
-85,-68,-56,-52,-55,-59,-31,-26,-17,-18,-36,-63,-66,-52,-37,-11,29,79,109,92,81,99,103,93,78,-11,-52,-36,-12,10,
10,-19,-57,-77,-62,-31,-27,20,55,85,116,127,111,91,79,70,36,19,-11,-44,-54,-54,-77,-90,-93,-91,-78,-56,-42,-34,
-25,-24,-35,-57,-55,-54,-95,-103,-67,-36,15,74,105,84,55,22,4,13,39,52,95,58,1,-9,12,23,35,10,-14,-74,
-108,-78,-60,-27,-2,29,70,98,99,86,73,61,42,32,9,-20,-30,-37,-83,-114,-128,-128,-98,-59,-48,-47,-39,-37,-44,-76,
-86,-91,-121,-102,-38,3,71,84,62,1,-31,-36,-55,-38,-39,-22,41,36,-10,-23,8,25,48,51,27,10,-38,-73,-93,-91,
-52,-46,-34,-12,5,14,19,0,-22,-39,-57,-69,-63,-46,-38,-51,-88,-59,3,32,16,18,38,41,36,-19,-44,-45,-63,-46,
12,46,81,53,16,-15,-25,-1,-26,-65,-89,-104,-30,-6,-22,-30,-14,-11,58,62,48,60,43,-3,-71,-109,-98,-107,-95,-77,
-62,-61,-68,-91,-93,-103,-118,-124,-104,-68,-40,-32,-12,25,91,123,120,121,115,98,21,-9,-7,5,-7,2,42,60,60,65,
67,55,21,-4,-50,-106,-91,-99,-47,-5,11,-10,-19,-15,46,57,48,65,83,69,16,-35,-87,-82,-78,-84,-94,-99,-101,-122,
-128,-128,-120,-92,-43,9,57,90,110,127,127,127,127,120,93,60,-9,-30,-39,-35,-28,-1,28,39,57,58,51,28,-33,-89,
-103,-113,-118,-128,-82,-26,29,8,-33,-50,21,50,47,68,96,114,92,64,31,21,7,23,34,23,10,-24,-42,-45,-22,11,
37,56,95,127,127,127,125,101,69,42,12,-13,-45,-63,-72,-69,-47,-21,-4,5,19,-3,-33,-60,-84,-110,-110,-110,-117,-128,
-79,-34,34,11,-50,-84,-13,7,4,24,50,75,84,91,101,98,98,109,119,127,127,127,127,127,127,127,127,127,127,127,
96,81,64,49,23,-7,-27,-37,-48,-51,-43,-40,-37,-32,-40,-48,-55,-64,-74,-77,-79,-107,-111,-105,-120,-121,-80,-44,32,23,
-31,-61,-8,11,-6,-2,6,17,25,41,33,37,55,78,91,89,96,104,86,84,104,126,127,122,105,94,64,38,18,14,
4,-9,-9,-4,-9,-7,-1,-21,-42,-39,-42,-48,-53,-49,-53,-59,-55,-73,-83,-86,-79,-73,-60,-44,6,5,-33,-58,-10,-4,
19,44,45,41,73,83,64,49,50,62,63,62,74,82,84,60,67,67,42,20,-5,-16,-48,-67,-70,-40,-15,-2,4,-6,
-9,-7,-5,1,8,14,17,20,31,33,32,33,34,33,46,61,60,22,62,51,-6,-66,-58,-11,-40,-22,17,43,41,48,
75,78,78,49,30,57,105,127,127,122,88,71,85,87,55,2,-72,-123,-128,-128,-128,-128,-121,-61,-14,-1,1,-16,-26,-19,
-9,-2,-8,-19,-15,6,25,36,45,56,71,80,70,70,98,87,-7,-79,-53,6,-33,-31,-2,20,24,26,45,46,12,17,
57,121,127,127,90,27,-32,-26,-4,-4,-26,-50,-95,-128,-128,-128,-128,-128,-128,-128,-82,-57,-47,-47,-31,2,14,7,5,-5,
-33,-21,5,31,45,49,57,55,53,76,83,49,-52,-110,-56,30,-45,-22,8,17,5,-7,25,27,55,80,97,67,5,-57,
-86,-80,-74,-71,-56,-47,-15,53,109,127,91,50,-20,-69,-103,-125,-128,-128,-128,-128,-104,-39,10,21,18,5,-2,-30,-44,-23,
9,43,57,42,34,45,45,-6,-72,-98,-50,17,-14,3,10,-4,-5,7,17,2,38,34,20,-26,-67,-87,-93,-71,-38,-34,
-26,-26,-6,47,102,123,127,127,94,76,53,24,3,-26,-110,-128,-128,-127,-29,33,60,53,35,0,-31,-27,-5,25,40,30,
7,2,-5,-79,-86,-41,26,39,20,26,0,-28,-10,10,49,60,-4,-3,-13,-48,-55,-43,-48,-40,-7,10,47,54,43,32,
34,33,66,83,103,120,113,108,103,73,37,7,-77,-128,-64,73,127,116,52,51,38,13,-27,-46,-45,-38,-33,-23,-31,-112,
-80,4,106,84,24,-17,-31,-33,11,59,54,55,30,1,-22,-29,-25,-6,19,26,18,40,59,50,35,-10,-32,-20,10,15,
42,88,119,127,127,98,56,73,9,-108,-128,-17,126,127,78,45,18,-3,-32,-59,-63,-59,-52,-81,-128,-128,-64,61,127,127,
-8,-29,-8,4,36,58,35,26,32,23,26,38,43,44,32,11,10,25,31,15,16,-15,-61,-95,-75,-41,11,51,67,90,
105,90,79,75,49,-6,-85,-100,-31,43,98,81,31,-20,-43,-33,-15,-27,-119,-128,-128,-112,17,127,127,127,-34,-19,14,26,
8,10,31,42,39,47,66,76,70,59,35,9,-6,-20,0,-17,-44,-66,-107,-115,-89,-58,-1,52,65,60,65,61,62,59,
66,48,8,-13,-9,2,59,116,127,108,27,-28,-93,-128,-128,-128,-128,-49,79,127,127,127,-17,-8,-1,-14,-12,14,36,44,
46,49,61,63,50,33,7,-19,-23,-31,-39,-75,-76,-57,-76,-95,-58,-44,0,41,44,38,43,42,33,21,25,27,16,9,
19,40,85,123,127,127,127,40,-74,-128,-128,-128,-128,-41,9,34,76,42,6,-7,-29,-58,-32,18,33,17,44,48,60,54,
30,10,-6,-20,-36,-37,-62,-82,-52,-23,-30,-34,-42,-30,0,29,43,45,31,16,3,-12,-16,-7,-9,-19,-20,-7,-7,41,
102,127,127,90,63,77,66,62,90,109,89,61,79,47,-3,-41,-61,-44,-7,8,15,18,61,53,49,32,10,5,4,-1,
-13,-36,-73,-48,9,0,-37,-22,-28,0,19,31,53,59,26,-5,-12,-26,-29,-17,-16,-37,-61,-68,-26,-16,-3,27,65,69,
48,36,83,112,127,127,105,72,68,25,-40,-83,-72,-15,14,3,23,50,62,37,18,-3,-17,-13,-1,-1,-15,-50,-79,-29,
14,-40,-87,-39,-12,2,7,14,33,37,13,-11,-20,-22,-13,1,-4,-28,-56,-73,-70,-58,-48,-32,-4,27,36,30,33,77,
121,127,123,97,90,53,-49,-56,-33,-8,-9,2,46,61,49,18,-3,-22,-39,-39,-26,-18,-25,-46,-66,-31,-9,-65,-110,-51,
-35,-43,-28,5,11,2,1,-2,-37,-18,9,25,10,-20,-44,-66,-84,-72,-55,-39,-25,-9,4,11,32,59,103,127,126,100,
95,66,-24,12,26,-1,-15,23,44,37,20,1,-5,-16,-39,-45,-37,-34,-44,-18,-21,-40,-28,-75,-128,-94,-46,-89,-81,-28,
-18,-26,2,20,-17,-3,28,38,36,21,-8,-32,-52,-62,-62,-46,-35,-5,-7,-9,2,19,50,83,125,97,99,51,12,29,
34,11,-3,20,29,31,-10,-20,-8,-2,-21,-36,-34,-33,-30,19,26,-27,-41,-69,-122,-93,-67,-98,-91,-44,-30,-27,1,15,
-4,0,33,64,66,45,16,3,-9,-33,-44,-37,-40,-21,-14,-1,-29,-5,9,28,84,78,95,57,33,64,46,5,-4,23,
15,-6,-23,-22,-10,0,-13,-27,-29,-32,-8,27,58,-11,-52,-85,-127,-82,-56,-87,-83,-55,-24,21,51,30,-9,0,42,81,
79,58,61,79,51,-14,-40,-31,-29,-20,-16,-7,-26,-29,-8,-3,37,38,91,61,31,65,52,9,-7,9,-11,-32,-40,-34,
-20,-8,-22,-42,-48,-51,-15,14,63,0,-65,-98,-126,-85,-34,-58,-66,-50,-4,46,56,10,7,43,77,89,70,51,85,127,
37,-48,-62,-26,-20,-29,-39,-34,-38,-41,-24,-28,5,9,76,59,29,64,50,8,-13,-7,-27,-36,-35,-29,-20,-12,-27,-50,
-61,-62,-34,-1,58,18,-53,-95,-110,-58,-1,-11,-24,-13,31,61,52,9,14,72,81,45,26,34,95,127,39,-85,-103,-39,
-23,-43,-67,-66,-57,-52,-35,-44,-16,-15,62,60,34,62,37,-5,-22,-13,-19,-10,-13,-9,-10,-11,-27,-50,-60,-56,-33,-9,
35,15,-30,-54,-46,6,31,35,30,41,70,64,35,0,17,75,39,-41,-41,10,103,127,34,-128,-128,-64,-34,-49,-71,-68,
-71,-59,-42,-51,-27,-36,42,50,35,55,20,-20,-28,-11,1,21,8,9,0,-8,-27,-51,-58,-48,-27,-14,-3,-19,-25,0,
31,42,55,64,56,52,58,42,13,-22,32,80,23,-68,-67,-1,90,127,28,-128,-128,-83,-63,-73,-85,-82,-76,-66,-50,-58,
-38,-58,18,31,32,47,10,-23,-25,1,18,35,17,14,2,-8,-29,-53,-57,-47,-25,1,-4,-35,-26,26,73,52,14,31,
37,29,27,23,3,-41,-21,32,10,-45,-41,12,81,95,14,-128,-128,-104,-102,-100,-99,-91,-69,-62,-48,-55,-41,-68,8,25,
42,38,0,-23,-9,23,30,39,22,7,-6,-4,-23,-51,-57,-53,-35,31,19,-22,-23,-8,33,5,-51,-37,-11,-8,-14,-8,
-14,-56,-52,-5,39,-4,-13,18,65,85,17,-128,-128,-128,-128,-128,-109,-85,-60,-38,-28,-43,-33,-63,10,28,41,36,-2,-23,
-7,25,30,36,20,4,-10,-7,-24,-51,-57,-53,-36,31,18,-26,-29,-17,27,1,-51,-39,-10,-2,-9,-5,-14,-57,-46,-3,
44,1,-14,16,65,85,15,-128,-128,-128,-128,-127,-105,-77,-55,-33,-24,-38,-31,-62,12,29,25,44,7,-25,-25,1,17,29,
10,5,-9,-20,-36,-55,-58,-48,-27,-1,-4,-42,-37,17,69,56,18,29,29,20,19,17,2,-42,-18,30,9,-38,-40,13,
86,95,8,-128,-128,-101,-103,-91,-90,-79,-49,-50,-35,-43,-34,-62,16,30,30,52,16,-24,-28,-7,2,17,2,-4,-15,-24,
-37,-55,-59,-50,-25,-13,-2,-29,-37,-12,22,37,41,49,41,33,36,25,5,-29,17,65,17,-63,-68,-5,87,122,18,-128,
-128,-77,-60,-60,-71,-63,-51,-47,-29,-41,-28,-49,27,37,31,59,31,-13,-24,-10,-16,-12,-17,-20,-25,-26,-36,-53,-60,-55,
-31,-9,36,4,-41,-64,-52,6,25,27,24,33,52,44,21,-14,-7,52,24,-45,-40,14,103,127,18,-128,-128,-52,-23,-31,
-55,-47,-48,-40,-21,-33,-15,-25,53,55,27,59,43,0,-18,-6,-26,-38,-36,-34,-27,-20,-32,-50,-58,-56,-33,3,66,12,
-65,-111,-116,-46,4,-12,-27,-13,28,50,37,-6,-3,51,54,22,19,36,93,127,21,-99,-102,-24,-8,-22,-51,-47,-41,-37,
-17,-27,0,1,75,64,34,63,50,6,-12,5,-12,-35,-43,-38,-23,-11,-22,-38,-42,-42,-11,21,76,2,-74,-118,-128,-72,
-25,-54,-65,-47,1,48,55,10,2,31,55,66,57,43,72,127,27,-59,-60,-9,-7,-12,-27,-21,-28,-28,-9,-14,23,26,
87,63,38,64,49,9,-8,17,11,-9,-31,-29,-14,-1,-10,-20,-20,-23,0,34,66,-4,-49,-94,-128,-75,-49,-74,-71,-48,
-18,24,52,35,-6,-1,34,69,67,45,44,83,46,-22,-37,-19,-22,-7,-3,6,-19,-18,5,11,57,55,99,63,9,30,
36,12,-7,14,24,24,-15,-26,-15,-6,-17,-24,-22,-23,-20,24,28,-22,-28,-66,-118,-79,-50,-77,-71,-35,-27,-26,0,12,
-2,-1,32,59,59,38,7,8,1,-30,-36,-25,-31,-6,0,11,-19,5,27,46,103,92,104,58,-38,3,20,-1,-16,14,
34,28,8,-12,-18,-22,-35,-34,-26,-26,-42,-12,-21,-41,-16,-65,-121,-70,-19,-62,-61,-17,-11,-22,3,21,-18,-6,26,29,
29,19,-14,-33,-40,-49,-44,-26,-20,10,2,-3,7,31,69,97,127,110,107,53,-66,-77,-48,-11,-12,-13,34,51,38,4,
-20,-32,-37,-31,-19,-12,-25,-39,-64,-30,0,-52,-89,-27,-19,-26,-13,16,20,9,5,-1,-42,-23,5,20,4,-24,-47,-65,
-71,-56,-38,-25,-12,1,10,15,39,74,120,127,127,110,91,64,-68,-113,-92,-24,8,-6,11,31,55,26,2,-20,-28,-17,
-4,-5,-15,-45,-77,-29,21,-30,-79,-34,12,17,20,25,38,37,15,-9,-17,-23,-15,-6,-11,-30,-52,-68,-72,-55,-40,-18,
12,37,39,32,36,84,126,127,127,97,76,45,-38,-82,-85,-59,-23,-2,9,4,50,41,33,12,-9,-12,-9,-10,-19,-40,
-73,-42,22,14,-28,-13,-10,7,28,40,56,59,27,-5,-11,-25,-30,-23,-22,-40,-65,-74,-24,-14,1,36,75,72,37,16,
61,88,106,103,76,36,39,21,-16,-45,-54,-73,-53,1,25,7,25,27,38,33,8,-15,-31,-42,-50,-53,-74,-84,-43,-8,
-11,-11,-14,-14,9,29,37,39,24,7,-4,-18,-22,-14,-12,-20,-23,-12,-10,37,98,127,122,66,28,29,-8,-23,4,35,
18,-6,27,18,-32,-35,-21,-21,-23,-5,19,30,30,26,33,35,24,6,-22,-50,-52,-59,-65,-89,-85,-55,-55,-70,-28,-24,
11,39,35,27,30,32,32,20,23,27,21,12,17,38,76,119,127,127,127,46,-101,-128,-128,-128,-128,-128,-76,-41,8,-8,
-67,-49,-3,19,9,5,16,23,26,27,39,44,41,35,12,-17,-44,-58,-42,-49,-67,-76,-95,-105,-79,-54,2,52,64,51,
51,54,61,59,65,47,8,-14,-10,8,69,125,127,121,42,-13,-88,-128,-128,-128,-128,-128,8,102,127,103,-50,-69,-36,-15,
20,52,30,10,12,6,10,21,24,28,18,-2,-2,0,-5,-17,-16,-43,-77,-103,-86,-56,0,52,74,82,86,81,72,69,
44,-14,-76,-66,4,71,105,88,44,0,-24,-10,8,-10,-127,-128,-128,-128,-26,111,127,127,-1,-66,-80,-67,-18,36,37,43,
15,-15,-35,-36,-29,-8,17,26,25,43,48,36,24,-19,-35,-19,17,20,46,93,123,127,126,106,74,82,17,-96,-118,11,
127,127,92,46,24,17,-4,-28,-33,-29,-26,-77,-128,-128,-82,54,127,111,9,0,-41,-69,-59,-45,9,36,-17,-7,-12,-54,
-56,-35,-37,-19,13,32,64,73,69,71,75,67,110,127,127,127,127,127,122,105,70,33,-56,-109,-41,82,127,113,52,54,
44,23,-11,-22,-18,-12,-9,-10,-49,-128,-121,-19,87,66,-13,-1,-6,-23,-37,-46,-38,-42,11,17,4,-54,-97,-109,-109,-73,
-13,0,9,10,42,111,127,127,127,127,127,124,98,67,42,18,-53,-98,-125,-89,-14,32,43,32,24,-1,-23,-18,4,34,
51,46,20,16,-15,-117,-128,-94,-3,26,-52,-20,6,14,3,-17,7,11,35,61,74,26,-45,-106,-128,-118,-87,-69,-54,-55,
-20,62,122,127,108,87,33,-19,-56,-72,-77,-87,-99,-92,-68,-25,4,3,-2,-9,-7,-27,-35,-13,17,47,60,47,38,55,
51,-32,-128,-128,-88,11,-38,-25,1,19,28,30,53,57,30,30,58,101,127,110,51,3,-41,-27,-8,-13,-27,-31,-54,-84,
-49,-42,-82,-119,-110,-73,-39,-31,-33,-32,-20,-1,-1,-10,-8,-9,-29,-15,9,28,37,40,50,50,46,71,83,24,-123,-128,
-126,6,-37,-23,13,46,47,53,86,97,98,73,58,78,114,127,127,122,93,81,102,115,92,40,-25,-61,-109,-95,-105,-100,
-63,-22,0,-3,-4,-19,-28,-23,-16,-9,-6,-9,-8,7,20,26,31,37,52,61,54,54,82,50,-82,-128,-128,-51,-6,2,
22,48,49,49,83,93,80,68,70,80,79,78,88,95,92,70,78,84,61,35,14,9,-18,-40,-50,-29,-6,4,3,-8,
-9,-6,-3,2,9,16,19,21,30,30,25,24,25,25,37,49,50,18,58,37,-41,-116,-112,-38,-49,-55,-10,23,6,28,
52,54,65,79,82,84,93,102,106,96,94,79,61,59,54,34,8,-16,-15,2,16,14,2,-12,-20,-18,-44,-46,-28,-11,
9,26,29,10,18,8,15,22,26,31,25,31,18,43,21,-3,1,38,60,37,-58,-67,-8,26,17,39,54,52,66,92,
102,85,86,108,118,120,127,121,94,82,83,78,85,99,114,127,127,108,74,28,-14,-40,-62,-71,-72,-59,-26,-8,3,4,
-9,-13,0,24,39,46,41,43,77,95,40,-2,10,40,73,27,-57,-40,0,22,21,33,18,10,24,26,-3,-65,-97,-83,
-65,-52,-18,-3,-13,-6,69,127,127,127,127,127,127,127,107,72,37,18,-32,-38,-48,-56,-54,-68,-73,-54,-70,-71,-59,-29,
3,13,2,2,66,58,-22,-69,-66,-32,20,-15,-41,-28,1,21,19,13,-26,-25,0,-28,-76,-119,-128,-128,-126,-122,-127,-107,
-91,-57,12,92,127,127,127,127,127,127,117,91,65,63,50,30,20,7,-1,-34,-56,-60,-80,-89,-111,-115,-66,-21,-12,9,
55,60,1,-70,-105,-103,-52,-31,-21,10,19,25,-8,-39,-67,-50,-28,-63,-107,-125,-114,-90,-61,-42,-22,-10,-13,-28,-32,-11,
27,58,94,102,92,90,101,79,43,31,68,62,67,55,24,-14,-38,-45,-32,-44,-81,-116,-98,-77,-44,22,39,41,-30,-92,
-128,-128,-101,-61,25,65,49,40,7,-38,-92,-94,-67,-74,-79,-74,-57,-33,-2,22,52,46,34,27,16,1,-7,-6,11,25,
40,53,57,45,49,68,93,65,26,-9,-45,-61,-66,-54,-17,3,-3,-54,-87,-120,-89,-22,9,38,-17,-49,-90,-124,-83,-47,
55,75,36,37,-12,-68,-109,-115,-75,-41,-22,-28,-17,13,37,53,47,38,26,8,16,35,23,-11,-33,-63,-84,-87,-63,-30,
3,42,67,20,-56,-124,-128,-128,-128,-103,-67,-36,-19,-27,-54,-70,-42,-27,11,16,-4,-15,-55,-75,-60,-29,54,49,-13,-15,
-54,-77,-79,-51,-6,19,24,8,11,29,41,49,38,11,-13,-33,-23,0,-17,-68,-29,-60,-68,-52,-34,-31,-24,4,20,10,
-43,-118,-128,-128,-128,-128,-128,-101,-63,-50,-53,-30,-1,1,61,79,82,16,-12,7,-4,9,28,-13,-46,-40,-49,-56,-37,33,
33,30,5,-5,9,20,17,15,12,-19,-47,-75,-26,6,-2,-86,-26,-25,-14,-2,-5,-27,-29,-4,-7,1,4,-12,-41,-57,
-70,-88,-100,-107,-111,-101,-51,0,39,75,100,111,119,83,89,100,93,54,6,-27,-49,-35,-33,7,37,61,31,14,-10,-7,
7,9,4,1,-17,-31,-82,-94,3,45,20,-74,-79,-43,5,38,45,16,7,20,4,13,25,28,23,15,5,-10,-2,-11,
-21,-35,-36,-33,-1,44,72,127,127,127,127,127,121,68,-49,-47,-44,-20,4,58,67,32,28,7,-7,1,8,4,-5,-9,
-29,-44,-104,-71,60,90,60,-19,-49,-18,6,20,29,17,13,25,17,25,39,50,52,48,41,35,14,41,63,58,35,1,
2,29,77,127,127,127,127,127,111,44,-49,-44,-37,23,53,66,45,-5,14,6,0,2,-5,-16,-19,-15,-28,-45,-70,2,
82,62,50,2,-19,9,23,16,5,-4,7,18,20,32,50,57,51,47,46,42,35,73,98,101,110,95,64,33,29,72,
121,127,127,127,113,65,-21,-26,-11,62,72,46,20,-15,2,10,3,-10,-25,-36,-35,-26,-22,-41,-32,49,60,18,25,-20,
-73,-12,38,27,-7,-16,18,50,21,32,43,35,17,14,14,2,25,58,81,92,103,88,61,34,0,28,54,74,88,89,
83,61,-31,3,44,92,71,34,8,-15,-11,3,-1,-17,-31,-37,-35,-26,-9,-35,-15,59,51,20,7,-82,-128,-52,43,31,
-22,-28,21,68,20,23,28,11,-16,-23,-34,-59,-32,12,51,66,80,79,74,62,10,0,-21,-13,8,28,41,30,-17,46,
102,95,68,32,-18,-31,-34,-29,-26,-14,-11,-25,-29,-18,-7,-35,-7,65,66,21,4,-102,-128,-75,35,23,-28,-13,32,78,
27,16,7,-21,-53,-59,-86,-108,-83,-46,13,49,48,49,65,82,56,14,-52,-77,-49,-29,3,23,7,69,110,95,66,24,
-31,-52,-56,-54,-45,-18,0,-3,-6,1,-10,-35,-30,41,69,31,-16,-128,-128,-117,-6,6,-23,18,67,91,20,-2,-22,-59,
-96,-96,-103,-120,-85,-44,24,54,37,37,68,85,82,45,-33,-81,-79,-72,-36,-7,37,87,103,98,68,-2,-64,-70,-75,-75,
-51,-15,0,-2,-1,6,-1,-44,-67,31,101,62,-16,-128,-128,-128,-36,-3,-26,29,93,85,3,-9,-35,-73,-105,-110,-94,-100,
-74,-46,34,48,25,14,32,70,97,83,-7,-96,-120,-107,-65,-22,53,90,89,84,58,-10,-75,-86,-79,-69,-45,-17,-9,-10,
-5,7,-1,-32,-70,9,121,105,1,-128,-128,-121,-15,4,-17,39,69,15,-41,-39,-42,-65,-108,-127,-80,-48,-66,-57,10,29,
11,3,23,62,98,104,25,-80,-128,-128,-85,-34,59,88,82,78,57,-10,-78,-99,-84,-67,-43,-21,-12,-9,1,16,12,-4,
-60,-23,108,127,26,-47,-102,-55,-24,-32,-22,42,45,-26,-62,-40,-16,-36,-108,-128,-46,34,-28,-57,-15,4,-10,-17,1,37,
89,118,61,-51,-128,-128,-99,-44,55,84,89,95,75,8,-64,-93,-89,-71,-50,-29,-11,-1,12,28,22,8,-57,-64,55,113,
43,6,-24,-22,-30,-33,-9,24,1,-43,-34,-8,52,38,-70,-105,-11,84,19,-52,-26,-16,-42,-48,-26,12,82,127,97,-16,
-119,-128,-100,-43,44,79,99,115,97,31,-42,-79,-84,-65,-49,-31,-13,0,12,27,31,9,-58,-105,-35,49,15,-17,-51,-47,
-30,-15,-14,-29,-67,-84,-58,-26,91,111,-19,-78,13,106,60,-40,-9,-9,-65,-76,-46,1,83,127,123,11,-108,-128,-96,-36,
38,77,103,122,107,46,-31,-74,-71,-55,-37,-23,-12,-4,6,20,39,14,-50,-113,-93,-14,-8,-26,-49,-50,-22,-11,-27,-43,
-65,-67,-106,-63,91,127,8,-46,60,127,100,-19,24,13,-71,-87,-56,-4,86,127,127,25,-105,-128,-94,-26,47,84,98,107,
105,59,-26,-85,-64,-56,-39,-19,-7,5,17,24,40,14,-54,-94,-72,-34,-24,1,-28,-46,-20,-5,-20,-34,-52,-70,-128,-76,
86,127,33,-20,91,127,127,-14,64,28,-75,-81,-65,-20,90,127,127,36,-90,-128,-99,-26,48,84,97,103,102,58,-27,-88,
-67,-60,-42,-19,-6,6,19,25,43,15,-57,-91,-66,-32,-19,12,-23,-44,-19,-5,-18,-32,-51,-70,-128,-81,79,127,31,-19,
92,127,127,-15,64,26,-78,-81,-66,-21,90,127,127,37,-87,-128,-99,-26,39,79,104,119,101,41,-35,-81,-82,-62,-40,-20,
-8,-3,6,21,38,11,-52,-102,-79,-4,5,-12,-32,-35,-11,-3,-22,-40,-65,-63,-104,-66,79,113,-2,-41,64,127,101,-15,
16,3,-79,-91,-57,-8,83,127,127,26,-103,-128,-91,-22,51,89,105,115,93,28,-49,-92,-99,-75,-51,-26,-6,3,14,29,
36,11,-58,-93,-20,52,14,-22,-52,-39,-18,-3,-4,-24,-63,-68,-49,-28,76,91,-27,-71,15,108,63,-33,-14,-21,-77,-82,
-49,-3,77,127,117,11,-105,-128,-93,-32,62,96,97,97,73,4,-74,-111,-106,-82,-54,-26,-6,3,14,30,26,8,-63,-60,
68,116,39,-7,-43,-27,-28,-27,0,28,2,-30,-23,-11,39,29,-70,-94,-5,82,16,-46,-29,-28,-56,-54,-26,13,74,119,
90,-18,-116,-128,-98,-40,63,97,87,79,55,-15,-90,-115,-102,-79,-50,-25,-11,-5,4,17,13,-6,-68,-22,120,127,23,-57,
-117,-63,-30,-35,-19,45,45,-17,-59,-49,-27,-38,-104,-116,-38,30,-38,-56,-20,-8,-23,-21,3,41,82,109,56,-51,-128,-128,
-98,-43,56,100,96,85,56,-16,-86,-99,-92,-77,-51,-25,-12,-7,0,10,-1,-31,-78,7,127,102,2,-126,-128,-128,-23,-1,
-19,40,68,18,-47,-50,-53,-68,-106,-119,-75,-49,-79,-61,1,17,-2,-3,22,62,93,99,25,-78,-128,-128,-87,-36,39,98,
115,103,66,-6,-70,-78,-82,-76,-52,-21,-4,0,5,11,-3,-44,-74,30,114,61,-7,-128,-128,-128,-39,-4,-33,22,83,79,
-1,-15,-39,-77,-111,-116,-99,-99,-85,-51,25,39,16,10,30,65,92,77,-7,-94,-120,-111,-70,-27,11,81,125,108,68,19,
-39,-60,-62,-56,-45,-20,-2,-1,-2,4,-7,-40,-42,43,80,25,-6,-126,-128,-111,-4,5,-32,9,60,88,20,2,-20,-65,
-108,-114,-121,-126,-88,-47,20,50,33,33,58,79,74,38,-38,-86,-84,-77,-43,-11,-12,59,120,111,71,30,-22,-42,-41,-35,
-29,-14,-10,-22,-26,-18,-9,-42,-17,69,75,10,8,-94,-128,-70,39,21,-34,-16,25,69,23,14,5,-30,-65,-76,-107,-119,
-88,-51,8,45,44,45,61,84,49,7,-60,-84,-56,-37,-6,19,-23,21,61,117,85,40,10,-23,-14,-1,-2,-15,-29,-35,
-35,-29,-19,-38,-21,64,56,14,8,-74,-128,-44,48,27,-31,-31,20,59,19,26,29,8,-25,-36,-46,-68,-39,7,45,55,
67,72,75,66,6,-6,-26,-11,8,36,50,33,-3,-1,9,84,89,61,27,-15,-1,6,6,-1,-17,-32,-38,-34,-34,-49,
-36,56,65,12,17,-22,-74,-7,43,26,-13,-15,22,47,22,37,46,33,10,6,8,-2,25,52,71,81,98,92,67,33,
-4,25,56,85,100,115,106,68,-21,-7,-9,44,66,82,55,-3,8,4,7,18,14,-7,-24,-28,-41,-58,-76,9,91,66,
46,1,-14,17,33,23,8,1,14,23,23,42,60,61,50,44,43,40,37,75,100,110,124,106,67,26,21,65,125,127,
127,127,127,70,-11,1,-10,3,12,67,77,34,22,6,-1,14,26,15,-8,-22,-46,-63,-114,-70,63,99,62,-19,-47,-15,
15,30,36,24,20,30,30,40,49,53,50,46,44,41,24,56,83,80,50,-2,-17,4,58,122,127,127,127,127,120,50,
45,28,-11,-12,-23,14,49,71,34,17,-5,0,16,17,6,-2,-24,-39,-85,-92,3,52,25,-64,-63,-26,24,54,54,24,
13,22,10,17,25,27,25,24,22,10,22,7,-12,-38,-54,-60,-31,7,39,108,127,127,127,127,107,55,61,53,6,-11,
-38,-48,-27,43,41,39,16,4,14,22,21,21,12,-15,-37,-61,-19,10,2,-68,-16,-15,-2,8,4,-17,-24,-6,-9,-2,
3,-5,-25,-38,-50,-72,-90,-117,-128,-128,-88,-35,6,25,25,33,50,26,31,50,52,32,66,98,47,26,-28,-59,-71,-41,
-5,25,36,24,27,42,50,56,49,22,7,-8,2,18,2,-39,-17,-47,-57,-50,-35,-27,-23,1,19,-3,-56,-118,-128,-128,
-128,-128,-128,-128,-95,-74,-66,-34,4,1,22,17,3,-46,-72,-58,-46,-17,55,99,85,94,41,-26,-82,-99,-74,-32,-4,-5,
8,38,58,69,57,47,44,33,47,63,48,18,-3,-35,-59,-74,-58,-27,-3,31,52,2,-68,-125,-128,-128,-126,-120,-100,-66,
-35,-19,-30,-45,-14,-2,21,1,-43,-53,-88,-113,-90,-50,10,52,65,79,58,19,-37,-52,-51,-55,-56,-49,-36,-17,14,36,
64,56,38,28,19,2,-7,-2,25,41,56,65,55,32,35,56,81,65,33,-8,-54,-78,-89,-87,-56,-29,-15,-42,-59,-97,
-73,5,36,54,-26,-75,-102,-128,-93,-56,-25,-8,3,18,2,-6,-19,-7,0,-40,-86,-100,-91,-83,-69,-62,-41,-27,-30,-41,
-34,-5,37,72,98,111,103,98,99,66,24,9,41,38,46,36,-2,-51,-84,-97,-72,-75,-95,-113,-82,-59,-26,46,68,74,
-11,-92,-121,-128,-89,-54,-48,-40,-18,-4,-9,-4,-21,-4,16,-17,-72,-116,-128,-128,-128,-128,-128,-128,-117,-66,18,95,127,127,
127,127,127,115,100,73,38,24,23,12,9,-5,-31,-78,-106,-113,-124,-123,-126,-114,-52,-4,4,32,87,103,38,-50,-86,-83,
-29,-22,-57,-42,-10,-2,-15,-6,-6,0,27,31,2,-63,-92,-83,-76,-76,-49,-36,-40,-23,55,127,127,127,127,127,127,114,
89,63,31,10,-38,-39,-45,-65,-85,-105,-108,-94,-94,-81,-58,-26,9,23,11,16,86,94,25,-28,-31,-6,36,-8,-49,-62,
-8,22,2,12,28,33,60,90,99,78,81,107,112,105,111,105,84,77,75,64,69,87,109,127,125,100,72,33,-6,-29,
-53,-65,-71,-65,-41,-21,-4,0,-7,-6,7,28,45,56,53,60,106,127,90,49,54,63,80,27,-41,-49,-4,23,6,21,
46,54,61,81,84,80,82,92,100,89,97,85,64,58,52,35,10,-14,-9,5,14,11,3,-7,-16,-18,-46,-48,-34,-17,
6,24,23,7,16,8,12,19,26,36,32,41,27,66,51,31,30,43,57,34,-64,-104,-93,-74,-63,-35,-7,16,20,10,
-2,0,7,2,-19,-15,-43,-46,-59,-61,-50,-49,-62,-76,-33,-16,17,31,22,6,-17,-28,-21,-22,-10,-14,-33,-34,-39,-62,
-37,-44,-51,-47,-51,-37,-28,-41,-44,-5,-21,-3,22,0,18,54,-106,-124,-103,-77,-41,14,48,68,65,15,-30,-39,-27,-20,
-28,5,17,6,-19,-27,-21,-36,-42,-41,-43,-19,8,16,13,22,16,7,-1,4,4,-1,-8,-31,-40,-43,-55,-53,-62,-76,
-89,-74,-72,-86,-103,-69,-61,-32,-7,1,29,16,-74,-52,-8,25,76,127,127,101,22,-36,-76,-64,-19,18,42,92,127,127,
109,110,127,127,93,28,-72,-56,-53,-58,-33,-10,-22,-36,-15,14,22,35,54,54,45,48,19,28,26,3,-28,-35,-40,-44,
-62,-74,-74,-33,5,33,49,22,-9,47,125,127,127,127,87,21,-28,-60,-83,-57,-6,39,74,109,127,127,116,95,105,113,
58,-36,-128,-100,-66,-49,-26,-14,-21,-28,-73,-60,-46,-7,49,84,66,23,24,28,36,40,30,16,14,12,-23,-63,-42,11,
52,64,33,6,53,127,127,127,127,42,-40,-30,-81,-63,-39,10,55,67,49,33,28,24,9,4,13,27,-18,-98,-122,-93,
-69,-54,-37,-53,-88,-106,-91,-58,-29,-49,-72,-18,44,38,20,24,28,42,73,80,61,23,-6,-26,-19,16,14,27,17,16,
95,124,72,-30,-107,-114,-74,-18,-50,-20,28,85,118,112,82,68,59,43,21,-4,-28,-41,-84,-122,-97,-63,-47,-46,-49,-88,
-128,-128,-128,-114,-60,-67,-123,-96,-19,5,-5,3,9,15,40,47,46,22,-50,-71,-96,-87,-89,-33,2,-2,76,34,-72,-128,
-128,-71,20,44,15,71,113,109,89,82,90,100,105,112,108,100,64,-1,-72,-61,-8,19,43,35,19,-5,-47,-67,-107,-126,
-128,-128,-128,-128,-106,-91,-76,-30,17,56,58,34,22,21,-29,-34,-93,-122,-128,-94,-76,-36,29,-71,-128,-128,-58,7,54,77,
92,96,90,80,82,96,102,91,90,80,71,67,39,-49,-128,-79,6,8,24,26,24,21,-6,-33,-54,-62,-77,-128,-128,-128,
-128,-128,-128,-95,-31,46,110,127,105,61,-15,-73,-120,-98,-128,-128,-128,-70,-37,-128,-128,-103,-8,37,77,116,119,81,61,68,
78,87,72,42,32,30,42,27,0,-71,-128,-75,-19,-35,14,20,-1,-2,-31,-29,-34,-20,1,-8,-25,-16,-29,-70,-128,-122,
-76,30,120,127,127,127,127,72,-27,-106,-114,-128,-126,-49,-95,-128,-128,-47,26,76,104,100,67,57,56,56,49,51,45,28,
21,29,51,46,-4,-103,-128,-105,-53,-53,4,10,5,15,-12,-5,-2,-3,1,2,6,22,27,14,-7,-22,-19,31,79,127,
127,127,127,127,43,-32,-17,4,3,28,-117,-128,-75,0,57,84,91,79,44,43,36,21,14,28,29,15,31,45,74,65,
-34,-128,-128,-123,-84,-80,-12,5,10,35,20,25,11,-1,-14,-14,-12,-14,-12,-4,4,19,40,75,113,127,127,127,127,127,
127,119,114,107,75,39,-115,-125,-35,20,65,77,72,48,42,27,6,-6,-7,11,19,16,25,51,91,67,-63,-128,-128,-81,
-105,-108,-23,11,11,40,38,47,15,11,0,2,7,-1,5,18,16,6,-3,27,78,115,127,127,127,127,127,113,85,74,
72,52,-84,-79,-7,19,52,61,55,16,17,-4,-19,-22,-17,6,19,17,19,56,99,45,-93,-114,-78,-47,-72,-83,-1,38,
30,45,51,74,61,55,34,30,45,54,59,58,67,9,-39,-16,24,54,100,127,120,108,103,95,77,51,35,24,-56,-48,
-4,0,36,41,31,0,-33,-39,-37,-36,-29,2,21,12,21,75,122,32,-100,-88,-71,-55,-30,-40,24,54,43,44,48,97,
101,75,35,34,64,79,72,49,68,12,-27,-22,-27,-31,1,37,55,59,78,85,78,36,-1,-8,-51,-39,-36,-17,29,31,
4,-29,-69,-52,-41,-41,-33,0,29,43,44,91,124,10,-97,-74,-107,-61,-24,-7,43,41,33,24,26,95,102,84,32,20,
51,59,50,46,51,-20,-55,-29,-23,-35,-37,-34,-13,-14,14,31,31,1,-14,-17,-35,-45,-42,-8,35,24,-11,-45,-70,-46,
-37,-47,-40,2,34,42,67,105,120,-1,-84,-60,-117,-48,-7,13,42,27,18,10,19,100,98,64,8,-3,16,9,11,35,
49,-18,-56,-26,-3,-23,-43,-45,-49,-51,-14,10,14,-25,-48,-49,-26,-44,-40,-14,32,27,-13,-73,-68,-54,-42,-50,-45,2,
36,49,57,98,117,0,-72,-59,-128,2,15,32,30,16,4,-5,32,88,114,82,13,-26,-2,3,-28,22,72,-20,-50,-9,
7,8,-12,-24,-49,-57,-19,8,2,-20,-81,-48,-32,-49,-30,1,35,22,-19,-76,-80,-64,-42,-40,-37,1,32,47,70,78,
97,3,-83,-63,-127,-49,-33,17,54,34,-3,-12,24,63,78,66,10,-25,6,-3,-45,5,66,-11,-16,37,45,34,2,-17,
-68,-78,-39,-9,-12,-36,-96,-57,-32,-46,-18,15,38,17,-25,-75,-86,-70,-44,-34,-26,7,34,49,73,69,88,13,-88,-70,
-108,-81,-62,-19,21,6,-23,-29,-13,9,88,67,2,-21,24,12,-40,-7,64,-8,2,69,81,63,20,-12,-75,-94,-57,-28,
-33,-59,-119,-72,-26,-49,-18,17,38,9,-39,-79,-86,-66,-42,-30,-16,20,42,51,45,54,63,-4,-95,-71,-84,-87,-65,-29,
7,4,-4,-22,-25,8,50,-1,-51,-51,8,13,-35,-19,53,-21,-20,52,76,79,37,-6,-66,-96,-65,-40,-42,-70,-128,-78,
-25,-56,-23,18,42,5,-49,-84,-79,-50,-27,-26,-13,23,37,41,27,39,26,-40,-100,-83,-85,-98,-39,-22,-13,-18,-2,-14,
-16,37,19,-62,-99,-95,-40,1,-20,-5,47,-11,-31,14,42,73,50,6,-53,-95,-74,-49,-46,-74,-128,-77,-29,-62,-24,20,
43,1,-57,-87,-66,-29,-7,-18,-16,16,29,31,14,39,36,-13,-43,-57,-61,-43,-14,0,-8,-34,-23,-22,-17,44,58,-51,
-102,-114,-59,17,15,23,24,1,-23,-2,16,59,54,15,-46,-103,-91,-63,-48,-78,-128,-80,-37,-67,-22,16,40,-8,-55,-81,
-53,-23,-1,-16,-24,7,30,43,15,24,31,3,15,-11,-24,42,67,39,-10,-48,-31,-25,-29,26,78,-36,-128,-128,-66,0,
18,43,20,-2,-45,-4,8,44,39,26,-37,-119,-107,-74,-44,-66,-128,-103,-34,-65,-22,14,38,-9,-56,-80,-51,-24,-4,-18,
-25,10,34,46,18,26,35,6,23,0,-15,46,69,40,-11,-48,-28,-21,-25,29,80,-27,-125,-128,-61,-2,18,47,26,1,
-44,-3,9,42,38,26,-36,-120,-110,-76,-44,-65,-128,-106,-19,-54,-22,21,39,-3,-63,-89,-67,-32,-17,-30,-21,20,35,31,
10,47,52,-6,-35,-40,-36,-25,-1,16,8,-20,-5,-5,-2,53,65,-40,-84,-100,-50,24,16,22,26,8,-15,-4,12,53,
55,12,-48,-105,-101,-70,-51,-81,-128,-81,-12,-45,-19,21,40,-1,-60,-92,-89,-63,-46,-47,-26,19,39,40,28,50,43,-35,
-88,-61,-54,-68,-23,-6,0,-9,11,4,4,57,27,-61,-92,-85,-31,10,-17,-9,51,1,-19,15,37,64,48,-1,-60,-105,
-89,-60,-51,-76,-128,-82,-11,-33,-8,28,40,3,-53,-94,-106,-90,-71,-56,-33,10,38,49,52,66,74,-8,-85,-55,-70,-81,
-65,-26,9,2,1,-5,-5,27,56,-7,-47,-40,16,25,-25,-18,58,-6,-8,53,72,71,36,-14,-75,-109,-82,-50,-47,-71,
-128,-84,-16,-27,-3,31,45,12,-42,-100,-115,-101,-78,-62,-44,-8,22,41,74,77,94,12,-72,-58,-107,-86,-81,-24,28,9,
-19,-18,-1,15,82,52,1,-15,27,24,-25,-4,65,6,15,74,83,62,24,-17,-81,-104,-69,-34,-35,-59,-123,-78,-14,-28,
-15,20,45,19,-39,-108,-116,-101,-79,-70,-56,-17,15,34,64,79,98,4,-70,-63,-128,-51,-49,13,61,35,-4,-5,30,59,
61,49,6,-20,10,9,-21,25,73,11,9,54,57,41,13,-14,-67,-83,-45,-11,-13,-40,-104,-64,-6,-21,-27,3,43,24,
-34,-108,-109,-95,-83,-83,-68,-19,16,32,51,92,110,-5,-74,-76,-128,-5,6,31,43,26,6,0,33,79,93,70,17,-11,
10,12,-7,49,86,8,-17,18,27,21,3,-13,-45,-58,-23,8,-4,-30,-94,-59,-20,-16,-23,3,43,26,-27,-82,-110,-94,
-90,-93,-76,-31,4,20,54,93,109,-7,-91,-88,-128,-61,-14,5,42,34,22,15,25,91,88,66,21,13,29,20,25,61,
70,8,-25,2,19,-1,-21,-29,-44,-52,-17,4,-3,-38,-71,-64,-46,-8,-9,-5,36,35,-9,-62,-112,-108,-103,-98,-81,-46,
-12,13,25,70,102,-3,-102,-95,-128,-85,-36,-18,38,41,32,25,30,88,88,84,45,33,60,65,62,69,69,3,-24,1,
6,-9,-19,-27,-21,-28,-1,13,0,-23,-46,-41,-65,-39,25,23,45,35,17,-23,-73,-98,-102,-94,-84,-51,-23,-23,0,55,
100,16,-103,-102,-93,-77,-38,-52,13,50,38,39,51,99,92,67,38,44,70,81,79,60,75,30,-7,-4,-3,-8,6,21,
29,30,45,49,35,3,-41,-28,-95,-84,12,52,71,55,41,-11,-23,-56,-74,-78,-78,-54,-26,-17,-9,37,84,33,-93,-117,
-86,-53,-65,-73,6,43,31,41,48,72,59,52,39,42,54,61,65,62,70,17,-23,2,42,61,93,127,95,74,62,51,
25,5,-16,-4,-128,-128,-34,44,90,79,60,19,9,-18,-43,-61,-70,-51,-31,-29,-12,24,73,58,-55,-128,-125,-78,-88,-88,
-7,19,13,37,35,44,15,16,16,24,29,18,19,27,30,23,22,50,87,108,127,127,127,127,109,72,28,20,16,18,
-128,-128,-83,12,81,93,86,53,17,6,-5,-25,-38,-23,-18,-31,-11,4,40,50,-22,-125,-128,-119,-71,-65,0,10,11,35,
22,22,14,11,8,12,12,6,7,14,24,40,62,89,116,127,127,127,127,127,127,81,57,58,30,19,-111,-128,-128,-48,
37,86,114,90,44,28,21,17,9,13,11,-6,-23,-16,10,28,6,-75,-128,-88,-47,-41,12,16,15,26,-2,2,10,13,
22,25,29,44,47,38,23,12,22,70,115,127,127,127,127,127,22,-57,-52,-19,-28,8,-57,-128,-128,-128,-23,33,91,127,
113,65,33,34,47,59,46,17,10,6,15,15,5,-44,-99,-40,-1,-8,34,35,17,13,-18,-15,-17,-6,17,18,10,19,
6,-29,-90,-77,-24,81,127,127,127,127,127,68,-18,-84,-106,-123,-128,-63,22,-84,-128,-128,-93,-27,34,82,99,91,70,51,
53,70,78,70,74,69,61,64,42,-25,-86,-34,39,31,38,32,24,20,-3,-18,-28,-31,-35,-83,-120,-112,-114,-128,-113,-53,
6,74,127,127,118,62,-8,-68,-104,-76,-100,-92,-124,-67,93,36,-75,-128,-128,-112,-27,3,3,71,119,103,70,63,79,95,
92,101,96,103,76,17,-35,-14,28,40,57,47,32,14,-19,-26,-76,-87,-90,-128,-128,-128,-97,-85,-65,-7,43,90,87,56,
54,65,9,-10,-84,-113,-95,-44,-44,-15,115,127,80,-34,-114,-128,-110,-63,-82,-43,17,81,110,104,75,62,61,53,37,21,
9,4,-29,-66,-33,-22,-17,-8,-4,-44,-97,-114,-128,-107,-60,-70,-123,-97,-15,28,29,42,49,46,73,85,95,75,-14,-57,
-85,-90,-95,-15,38,18,58,127,127,127,127,49,-41,-42,-83,-66,-37,23,75,91,76,61,61,62,54,53,64,75,31,-47,
-95,-85,-63,-39,-25,-43,-79,-105,-108,-79,-56,-71,-79,-18,52,67,50,49,53,69,112,125,104,60,22,-15,-14,12,-3,37,
58,37,-11,50,127,127,127,127,94,26,-22,-59,-79,-40,26,83,126,127,127,127,127,127,127,123,56,-44,-128,-128,-99,-78,
-56,-45,-51,-60,-95,-76,-55,-17,49,94,86,56,52,56,67,68,59,49,45,39,0,-56,-43,10,34,55,54,33,-88,-65,
-30,2,56,122,120,88,14,-45,-78,-62,-14,28,56,121,127,127,103,84,92,75,21,-50,-128,-122,-113,-112,-85,-61,-63,-67,
-27,0,9,22,53,66,63,66,44,52,49,22,-9,-7,-11,-15,-28,-62,-78,-23,18,23,34,32,-128,-128,-128,-114,-74,-22,
11,25,9,-41,-84,-101,-100,-95,-101,-52,-24,-31,-55,-77,-91,-112,-126,-128,-124,-89,-46,-30,-28,-12,-3,0,-11,-4,4,5,
5,-10,-19,-23,-27,-29,-38,-52,-66,-45,-45,-59,-69,-46,-54,-24,6,-7,-12,-6,-72,-116,-116,-97,-88,-60,-37,-17,-16,-29,
-46,-50,-44,-49,-69,-51,-72,-76,-88,-92,-87,-88,-95,-106,-72,-46,-5,14,12,3,-15,-27,-15,-17,-7,-6,-20,-24,-27,-42,
-26,-33,-39,-39,-45,-25,-17,-28,-27,9,-15,-1,23,0,-12,30,-25,4,25,1,19,11,28,44,62,61,59,60,63,63,
55,38,28,5,-7,-16,-12,-3,-10,-1,-1,20,19,-2,-17,-16,-8,-9,-28,-28,-11,13,23,26,30,36,29,33,38,37,
29,28,29,19,14,-11,-13,-34,-48,-31,-6,-4,6,-4,21,16,26,12,27,47,73,64,43,17,15,32,39,27,0,-3,
14,26,38,29,17,30,83,84,69,61,61,57,44,24,13,6,8,33,53,56,42,22,20,33,52,61,53,42,40,35,
17,-2,-35,-72,-83,-49,-1,42,-38,-12,14,-11,-6,-5,5,32,26,16,3,-17,-22,-14,-4,-6,20,32,39,25,5,-34,
-67,-65,-32,-4,19,30,31,43,71,72,62,50,53,82,94,69,34,9,-11,-16,2,37,53,51,61,60,15,15,-17,-50,
-74,-48,12,62,-53,-36,-21,-34,-39,-39,-19,-8,-22,-15,-4,-8,-12,-6,11,29,54,63,56,33,-1,-72,-128,-128,-128,-97,
-67,-56,-64,-27,39,58,79,48,45,94,119,94,69,56,17,-13,-39,-35,-18,11,35,23,18,30,3,-20,-40,-32,12,40,
-40,-67,-79,-71,-70,-50,9,19,44,24,19,28,40,49,53,60,60,80,102,119,118,74,31,8,-24,-5,-2,-25,-56,-39,
6,2,-16,-21,-9,44,89,78,65,69,43,14,-26,-61,-79,-42,22,51,84,41,-30,-51,-27,-13,-7,14,-76,-100,-107,-68,
-39,-11,35,21,27,29,47,57,62,71,80,84,91,109,127,127,127,126,118,111,72,63,37,1,-39,-45,-35,-55,-96,-89,
-68,1,65,42,8,2,30,32,22,-8,-51,-60,-48,-31,13,-61,-123,-97,-35,-9,-8,17,-97,-125,-105,-45,9,43,32,39,
62,73,82,86,92,96,97,103,103,117,127,127,127,93,85,92,61,42,32,30,-11,-49,-47,-54,-70,-34,-3,58,114,75,
-12,-55,-5,10,6,-19,-20,-5,-16,-22,-47,-121,-115,-30,9,-2,20,19,-92,-115,-76,-6,27,48,45,64,65,64,63,73,
89,94,93,99,106,127,127,127,64,-15,-28,6,-1,-21,-11,-1,-38,-78,-93,-118,-128,-81,-44,10,69,74,27,-9,-41,-24,
-13,-5,8,13,8,-6,-16,-73,-40,41,47,-20,-20,-26,-49,-60,-13,43,24,42,10,-8,1,43,64,61,66,74,72,76,
74,95,120,81,-16,-94,-90,-44,-67,-69,-26,3,-28,-46,-77,-128,-128,-128,-128,-126,-61,-12,0,-10,-43,-23,6,5,-31,-61,
-68,-56,-22,-54,-62,-5,1,-11,-11,-8,-28,-18,-8,12,0,-7,-39,-23,17,38,54,64,70,64,61,71,62,77,113,67,
-60,-128,-128,-114,-128,-115,-33,3,-13,-13,-36,-89,-121,-128,-128,-128,-110,-82,-59,-56,-46,-41,-18,-12,-75,-128,-128,-127,-98,-80,
-44,22,47,55,30,3,-2,16,-8,-2,-15,-36,-58,-8,32,47,60,66,60,44,39,50,50,64,98,45,-98,-128,-128,-128,
-128,-96,-18,3,-19,-19,-37,-77,-113,-113,-110,-104,-94,-69,-33,-14,-24,-39,-33,-10,-15,-58,-101,-111,-102,-61,-17,33,61,70,
19,-18,34,34,-4,-12,-37,-44,-48,4,32,58,71,59,34,13,7,18,16,62,125,73,-91,-128,-128,-128,-110,-52,-5,16,
5,-8,-36,-82,-118,-111,-99,-80,-63,-43,-15,5,-10,-21,-14,12,37,48,39,25,10,36,43,48,49,44,4,-1,40,39,
-13,-36,-64,-55,-39,4,33,56,52,26,-1,-16,-21,-11,24,89,127,105,-112,-128,-128,-106,-88,-35,-1,28,26,6,-27,-82,
-113,-107,-92,-62,-38,-31,-27,-19,-15,-24,-13,16,39,62,66,56,71,86,81,83,69,38,-16,-15,42,22,-45,-53,-78,-68,
-34,15,39,43,16,-16,-30,-34,-31,-16,34,90,127,113,-128,-128,-125,-119,-108,-47,-13,32,46,33,4,-62,-84,-82,-71,-37,
-3,-2,-8,-5,-19,-30,-17,14,34,46,54,51,63,59,51,67,52,8,-46,-42,33,-13,-55,-70,-81,-63,-27,25,37,16,
-24,-46,-47,-47,-36,-16,22,88,127,127,-128,-128,-79,-104,-87,-20,-19,39,88,68,34,-39,-70,-56,-30,18,69,71,49,48,
16,-8,-2,9,19,38,41,37,39,39,45,48,45,-1,-67,-52,29,-27,-64,-70,-69,-45,-20,28,16,0,-35,-57,-57,-53,
-44,-29,18,86,127,127,-103,-128,-16,-60,6,39,-3,45,102,87,47,-29,-32,-13,11,56,106,106,79,70,35,-5,-3,3,
7,27,40,45,17,15,25,30,29,-11,-65,-46,23,-21,-50,-71,-62,-45,-7,19,3,-2,-32,-60,-65,-53,-35,-25,13,84,
127,127,-51,-123,5,-29,29,25,0,39,85,68,19,-38,-11,10,35,84,127,115,67,67,-3,-31,-14,-16,-6,35,50,49,
36,17,17,38,44,-12,-50,-36,16,-22,-47,-60,-45,-32,-6,7,-6,-10,-27,-43,-49,-41,-21,-6,27,96,127,127,5,-104,
-13,-22,26,49,43,54,54,18,-7,-22,-34,-31,-18,53,125,113,63,64,-55,-79,-32,-12,-9,25,50,68,55,30,20,39,
51,3,-35,-31,2,-28,-46,-54,-37,-28,-13,-15,-26,-29,-34,-34,-34,-28,-7,9,47,109,127,127,36,-93,-26,26,71,78,
52,35,12,-23,-30,-29,-63,-57,-56,6,97,121,78,52,-128,-128,-63,-20,-25,7,55,88,88,55,31,40,53,15,-18,-26,
-11,-35,-46,-52,-37,-32,-29,-39,-56,-58,-53,-37,-28,-17,0,13,57,118,127,127,46,-96,-65,25,60,46,2,-18,-35,-43,
-31,-36,-62,-67,-94,-47,63,127,98,18,-128,-128,-92,-18,-34,-2,68,106,111,76,39,36,49,20,-7,-19,-22,-41,-42,-46,
-30,-33,-43,-61,-74,-77,-66,-41,-23,-11,4,12,54,120,127,127,56,-92,-119,-53,-42,-17,-11,-3,-18,-32,-21,-29,-35,-93,
-128,-86,46,127,110,-4,-128,-128,-110,4,-23,0,80,120,123,89,45,33,44,17,-3,-14,-21,-34,-29,-34,-20,-28,-48,-69,
-82,-80,-68,-42,-23,-14,0,8,38,102,127,123,60,-61,-91,-47,-28,23,51,70,56,39,46,30,-3,-104,-128,-83,48,127,
108,-9,-128,-128,-117,37,5,11,92,127,127,105,59,42,47,17,-3,-12,-21,-26,-23,-44,-34,-37,-45,-64,-85,-81,-65,-40,
-26,-18,-6,5,52,110,127,127,55,-51,-17,39,72,117,127,127,109,92,90,72,12,-75,-128,-61,60,127,100,-22,-128,-128,
-86,61,25,11,87,127,127,99,68,54,43,19,6,0,-21,-26,-25,-49,-41,-43,-49,-67,-86,-79,-63,-38,-24,-17,-5,6,
50,109,127,127,58,-48,-8,50,81,120,127,127,105,90,90,71,14,-73,-128,-56,63,127,100,-22,-128,-128,-84,62,26,11,
86,127,127,99,70,58,47,22,9,4,-21,-33,-32,-42,-33,-41,-62,-81,-87,-80,-65,-40,-20,-12,0,8,38,103,127,127,
69,-48,-79,-37,-12,29,51,76,60,38,48,30,1,-108,-128,-73,54,127,110,-7,-128,-128,-113,44,9,14,88,127,127,114,
67,53,61,24,2,-6,-21,-37,-40,-51,-42,-47,-57,-71,-81,-76,-63,-39,-21,-10,6,15,58,122,127,127,59,-82,-103,-36,
-41,-20,-13,5,-8,-24,-7,-13,-21,-91,-128,-81,48,127,120,0,-128,-128,-103,16,-16,4,81,126,127,103,61,50,60,28,
7,-4,-10,-29,-41,-53,-44,-44,-44,-50,-64,-58,-47,-30,-22,-13,5,21,61,123,127,127,54,-83,-47,44,69,41,-11,-27,
-38,-42,-22,-17,-42,-62,-96,-52,55,127,109,20,-128,-128,-89,-8,-36,-6,66,114,127,98,65,60,69,36,9,-7,2,-22,
-40,-52,-40,-38,-28,-27,-32,-29,-27,-23,-24,-23,-2,16,51,118,127,127,49,-80,-7,52,102,81,29,7,-6,-31,-31,-21,
-55,-61,-70,-11,78,113,88,56,-128,-128,-71,-18,-39,-11,44,92,110,85,64,69,76,36,2,-13,10,-20,-43,-58,-47,-41,
-20,-1,-10,-11,-23,-32,-36,-32,-15,-1,32,106,127,127,17,-100,-9,-8,50,56,32,36,35,0,-21,-25,-29,-37,-37,28,
102,104,72,68,-72,-116,-53,-20,-30,1,39,74,80,62,57,71,78,30,-13,-18,14,-22,-45,-67,-64,-52,-16,20,3,-3,
-29,-50,-52,-42,-27,-20,18,89,127,127,-37,-121,1,-26,31,29,6,40,78,52,3,-46,-4,11,22,62,109,107,74,69,
-19,-66,-37,-25,-25,16,48,65,65,52,58,74,77,19,-26,-23,17,-30,-55,-68,-71,-52,-23,32,21,3,-31,-51,-50,-44,
-36,-26,20,85,127,127,-89,-128,-22,-58,-1,27,-7,40,96,77,30,-43,-33,-11,10,44,90,101,83,72,16,-32,-23,-12,
-8,24,51,66,55,52,65,69,65,15,-43,-33,16,-26,-52,-71,-80,-64,-29,30,41,18,-23,-45,-45,-43,-32,-18,18,81,
127,127,-127,-128,-82,-106,-94,-29,-26,33,83,61,20,-50,-70,-52,-29,12,61,73,56,51,5,-27,-16,-4,8,41,58,62,
72,69,78,80,71,17,-49,-41,39,13,-51,-54,-81,-70,-39,15,43,47,17,-21,-35,-35,-31,-22,27,78,127,116,-128,-128,
-121,-120,-107,-56,-20,21,37,28,-8,-73,-84,-80,-71,-44,-13,-5,-9,-11,-40,-48,-29,10,35,57,76,76,87,82,79,95,
65,16,-29,-29,41,31,-18,-42,-75,-63,-44,6,38,63,56,20,-9,-22,-25,-18,9,73,127,111,-105,-128,-128,-108,-88,-45,
-13,14,19,3,-30,-78,-114,-103,-87,-61,-41,-35,-33,-31,-33,-38,-18,22,53,80,84,69,80,100,102,98,71,38,-4,2,
47,30,-12,-18,-48,-57,-58,7,39,71,82,64,35,10,2,10,2,45,113,73,-85,-128,-128,-128,-121,-66,-18,3,-4,-14,
-38,-76,-115,-107,-94,-77,-64,-47,-22,-3,-21,-29,-15,22,54,60,40,19,3,38,60,62,54,41,5,9,29,25,-23,-17,
-28,-55,-75,-15,37,57,75,82,75,54,42,49,45,53,80,37,-97,-128,-128,-128,-128,-122,-36,-13,-31,-27,-39,-72,-109,-110,
-109,-103,-94,-73,-41,-21,-35,-44,-29,1,-2,-52,-106,-125,-116,-76,-19,35,65,69,16,-12,15,22,-15,-12,-23,-35,-60,-41,
15,41,64,81,90,81,74,82,72,82,108,67,-51,-128,-126,-125,-128,-128,-53,-16,-25,-20,-37,-86,-116,-128,-128,-128,-108,-81,
-60,-59,-47,-38,-6,4,-67,-128,-128,-128,-111,-94,-46,23,51,56,29,2,0,12,10,28,-6,-1,-20,-30,-5,39,69,76,
84,90,88,92,90,113,127,89,-1,-72,-69,-34,-82,-81,-45,-19,-45,-61,-84,-128,-128,-128,-128,-124,-55,-2,10,-2,-38,-16,
8,1,-34,-60,-74,-71,-44,-73,-63,1,6,-13,-13,-16,-43,-30,-12,17,16,21,12,28,40,53,64,76,90,99,103,113,
117,127,127,127,78,7,-12,13,-9,-36,-37,-27,-61,-96,-104,-128,-128,-78,-40,11,67,71,22,-19,-50,-31,-12,2,25,40,
33,21,2,-57,-34,41,33,-38,-33,-30,-61,-49,-28,11,41,54,15,15,36,55,73,82,90,94,96,101,100,117,127,127,
127,107,92,89,50,19,0,6,-23,-54,-48,-56,-82,-41,-14,33,83,57,-11,-47,0,25,30,1,1,23,12,7,-15,-88,
-92,-14,2,-34,-11,-3,-58,-54,-43,5,35,47,73,34,13,6,28,53,68,77,81,78,86,105,125,127,127,119,108,98,
44,39,15,-18,-47,-47,-45,-76,-116,-110,-90,-26,48,52,25,8,33,35,33,13,-35,-51,-36,-12,47,-23,-84,-64,-19,-31,
-51,-9,-29,-42,-41,-20,-11,13,76,73,78,37,18,27,41,50,55,64,58,75,92,107,101,50,-2,-30,-46,-23,-22,-52,
-91,-79,-35,-29,-42,-39,-19,31,77,77,64,61,33,4,-30,-58,-76,-45,17,55,97,57,-12,-40,-20,-28,-45,-14,-48,-20,
-3,-9,-4,2,32,44,25,15,13,-1,-21,-28,-13,7,39,48,46,28,-13,-94,-128,-128,-128,-107,-84,-80,-90,-55,10,38,
62,48,56,101,117,87,57,41,12,-13,-32,-25,-13,5,27,22,23,34,9,-18,-33,-33,-15,14,-40,-3,19,-3,15,16,
33,66,66,54,36,8,-13,-20,-20,-31,-9,5,19,16,1,-38,-71,-72,-43,-18,-1,6,9,24,54,60,56,51,56,76,
76,48,16,-3,-16,-12,11,37,43,34,44,50,21,21,-1,-29,-54,-37,2,41,7,2,29,27,43,25,44,73,108,103,
83,55,50,65,69,47,9,-5,3,20,38,36,36,58,93,83,55,43,51,54,46,27,15,8,7,27,48,55,50,38,
40,50,65,67,53,34,33,34,22,5,-19,-48,-59,-35,5,36,-18,4,26,7,27,11,32,52,73,78,83,83,84,86,
81,57,45,21,8,0,2,9,7,20,17,29,21,1,-11,-7,2,-2,-25,-21,-5,18,29,33,38,43,34,35,39,38,
31,23,24,19,19,-5,-9,-26,-31,-16,9,2,-7,-31,-35,-23,-21,-26,-30,-35,-32,-34,-25,-29,-34,-35,-59,-65,-62,-68,
-87,-102,-127,-128,-128,-128,-128,-128,-78,-37,-42,-45,-26,-38,-45,-35,-29,-30,-40,-52,-61,-67,-77,-74,-62,-64,-67,-52,-54,-71,
-72,-21,-2,-23,-29,-27,-3,-2,-5,27,25,27,27,25,7,-14,-6,7,23,9,-11,-20,-41,-40,-27,-59,-102,-107,-118,-128,
-128,-128,-128,-128,-102,-55,-45,-42,-31,-50,-44,-29,-19,-29,-41,-60,-80,-83,-72,-73,-63,-53,-53,-49,-50,-51,25,68,46,-3,
-17,-2,20,29,27,52,41,31,32,24,10,0,31,44,55,43,44,60,47,36,24,13,11,43,64,25,-41,-88,-128,-128,
-128,-102,-89,-79,-57,-65,-51,-47,-65,-93,-85,-58,-43,-31,-23,-17,-1,21,28,17,10,37,94,79,6,-77,-69,-43,-6,13,
29,61,54,52,58,34,38,54,58,49,41,36,27,21,16,26,63,108,127,127,127,120,88,50,-7,-15,-22,-19,-27,-30,
-16,-26,-72,-48,-63,-110,-108,-82,-83,-82,-77,-71,-52,-23,13,30,53,125,127,127,50,-58,-76,-71,-25,-3,24,75,78,83,
90,53,27,20,-48,-50,-48,-37,-16,10,29,48,66,108,127,127,127,127,127,117,108,110,91,88,91,79,63,43,33,44,
17,-46,-76,-81,-93,-90,-89,-66,-27,16,53,80,127,127,127,127,55,-16,-54,-63,-25,-2,38,54,32,23,-32,-125,-125,-98,
-128,-117,-61,20,73,88,71,62,75,96,127,127,127,127,107,84,100,101,57,44,76,75,59,60,95,103,83,37,-4,-23,
-41,-48,-48,-7,49,83,101,127,127,127,127,127,123,56,-35,-83,-37,1,27,33,-16,-60,-128,-128,-116,-79,-73,5,86,118,
127,124,109,104,123,127,127,127,120,57,-6,7,63,52,39,30,37,58,71,73,49,62,46,23,8,-5,5,30,49,73,
85,94,96,127,127,127,127,127,127,43,-44,-85,-76,-36,22,12,-59,-83,-114,-104,-34,-29,39,94,127,127,127,127,123,117,
127,127,127,92,46,4,-67,-60,-73,-81,-78,-71,-57,-24,-6,-10,2,8,-12,-36,-39,-34,-19,5,99,107,118,110,109,127,
127,127,127,127,97,-3,-93,-128,-128,-121,-6,-39,-46,-53,-82,-43,25,65,104,112,113,101,77,57,62,86,97,98,69,21,
-43,-75,-128,-91,-102,-104,-63,-34,-25,-11,-1,-6,-17,-22,-33,-42,-47,-64,-90,-92,-38,45,121,127,127,127,127,105,66,77,
8,-123,-128,-128,-128,-128,-13,-61,-46,-29,-44,17,73,75,67,69,61,39,14,-4,0,19,15,15,25,2,-62,-65,-113,-121,
-106,-106,-49,5,24,25,14,0,-15,-12,-1,11,16,0,-32,-46,-59,-47,-34,4,62,86,50,2,-10,-6,-58,-121,-128,-128,
-128,-128,-13,-55,-36,-14,-17,37,65,46,34,27,8,-15,-36,-51,-49,-37,-17,-9,16,-14,-78,-58,-79,-103,-45,-47,-7,28,
39,31,8,-26,-26,-22,1,21,33,29,16,4,-15,-6,-8,-9,-9,-14,-33,-51,-49,-59,-90,-91,-86,-87,-128,-118,-44,-59,
-27,2,6,30,33,23,2,-14,-32,-43,-51,-57,-48,-35,-12,5,8,-38,-74,-52,-65,-61,-20,-25,3,18,15,21,8,-40,
-32,-33,-16,5,15,26,26,11,-2,21,33,28,2,-23,-44,-60,-25,-37,-65,-68,-72,-69,-98,-77,-41,-49,-5,37,31,15,
-3,0,-27,-44,-54,-49,-50,-53,-39,-26,-5,22,-2,-62,-61,-67,-112,-66,-44,-46,-9,15,-2,-6,-3,-41,-35,-41,-23,5,
18,40,49,31,2,26,56,56,37,24,0,-13,-20,-27,-50,-54,-58,-38,-59,-46,-8,-21,21,59,36,-17,-51,-28,-41,-60,
-68,-60,-55,-44,-18,-5,5,38,2,-59,-36,-82,-128,-95,-64,-56,-7,37,11,-34,-31,-36,-66,-65,-22,26,41,60,68,38,
11,47,90,80,57,48,17,9,11,17,9,-6,-24,4,-10,13,-12,11,36,64,32,-33,-37,-18,-36,-62,-71,-57,-39,-15,
-1,1,37,63,10,-49,14,-21,-122,-90,-59,-36,-2,29,1,-64,-53,-45,-68,-67,-9,45,54,61,65,25,28,64,79,80,
60,44,25,36,44,36,30,32,16,34,17,24,2,32,42,58,23,-31,-23,-9,-29,-45,-47,-39,-23,1,14,7,48,79,
22,-43,42,25,-85,-52,-77,-40,-9,14,-14,-76,-55,-27,-65,-72,-17,42,48,44,46,9,28,60,69,73,71,56,28,41,
38,37,44,47,25,50,37,36,8,17,31,58,7,-25,-4,7,-31,-44,-48,-31,-3,10,12,21,51,88,28,-68,10,46,
-38,-42,-70,-65,-54,-10,-32,-76,-35,-23,-85,-92,-16,30,34,46,16,-14,-15,92,75,80,84,66,45,21,28,30,48,41,
25,29,47,41,9,11,11,30,-11,-33,-10,0,-18,-33,-42,-26,0,13,15,19,44,91,52,-75,-52,36,14,-12,-48,-69,
-76,-42,-38,-41,-1,-14,-105,-103,-14,40,47,52,-1,-85,-36,108,102,95,98,80,49,10,15,24,51,45,23,24,40,33,
6,6,-1,13,-21,-35,-14,-3,0,-16,-28,-19,-1,11,14,16,40,87,65,-82,-128,-23,23,-4,-43,-49,-47,-35,-36,-29,
-3,-26,-92,-114,-23,61,74,60,-11,-128,-25,127,127,105,103,87,47,0,-4,13,47,45,19,11,24,20,5,6,0,15,
-14,-26,-10,1,9,-8,-20,-18,-5,4,8,10,34,73,56,-77,-128,-67,12,-10,-58,-32,-7,-6,-7,11,25,-8,-110,-128,
-74,73,115,73,-18,-128,20,127,127,104,118,108,51,-2,-10,8,48,46,15,0,16,18,1,0,0,21,-5,-21,-12,-3,
3,-12,-20,-17,-7,1,4,7,36,69,44,-75,-128,-94,-19,-40,-45,-21,10,5,-4,21,46,20,-128,-128,-128,61,127,88,
-10,-114,68,127,127,86,127,127,70,7,-11,4,46,47,13,4,22,29,-7,-12,-5,25,1,-19,-16,-11,-3,-16,-25,-18,
-4,4,5,8,36,73,36,-78,-128,-108,-33,-39,-50,-30,-3,-25,-48,0,53,29,-128,-128,-128,56,127,99,5,-86,99,127,
127,78,127,127,81,2,-15,-3,36,38,11,8,32,37,-13,-18,-2,28,0,-17,-28,-19,-7,-11,-24,-28,-12,-3,1,13,
42,72,15,-86,-128,-128,-69,-54,-102,-91,-66,-41,-33,10,37,-24,-128,-128,-128,39,127,97,21,-57,96,127,127,63,126,127,
92,2,-4,2,39,42,8,9,26,32,-13,-18,-1,31,3,-15,-27,-19,-4,-9,-24,-29,-14,-4,0,13,43,70,14,-83,
-128,-128,-72,-51,-90,-91,-70,-40,-32,7,31,-30,-128,-128,-128,33,127,93,22,-54,96,127,127,66,126,127,95,5,-1,5,
41,42,8,9,27,32,-7,-12,-4,31,10,-12,-9,-8,5,-13,-25,-18,-5,5,7,8,45,75,39,-83,-128,-118,-27,-19,
-32,-37,-7,-21,-46,-8,38,19,-128,-128,-128,64,127,105,13,-80,107,127,127,88,127,127,86,10,-8,3,39,35,11,9,
36,40,0,-1,1,29,6,-12,1,3,12,-6,-17,-15,-5,5,8,10,40,74,47,-89,-128,-111,-25,-46,-60,-42,2,1,
-9,12,31,8,-128,-128,-128,70,127,91,-8,-111,80,127,127,97,127,127,78,15,-2,12,51,45,13,5,25,30,2,4,
-1,20,-5,-15,7,13,19,2,-12,-12,-2,8,13,15,37,80,54,-99,-128,-79,-1,-40,-85,-56,-11,-6,-5,17,29,-3,
-107,-128,-73,91,127,81,-14,-128,32,127,127,116,127,119,61,7,-5,13,51,43,13,0,17,17,2,3,-5,12,-17,-25,
5,14,11,-5,-18,-12,3,14,18,19,35,83,52,-105,-128,-28,12,-38,-68,-70,-44,-24,-25,-11,15,-11,-81,-106,-11,86,
99,67,-7,-119,-17,127,127,113,115,98,50,2,-5,13,48,40,14,7,22,17,10,11,6,23,-14,-28,10,23,-4,-20,
-29,-15,6,16,18,20,36,78,32,-95,-66,33,13,-26,-61,-85,-73,-30,-30,-27,16,0,-96,-90,-1,58,65,55,-1,-84,
-34,105,96,91,97,79,42,3,11,20,48,39,18,19,35,28,15,21,28,50,3,-22,17,35,-11,-29,-35,-18,6,14,
14,18,47,78,15,-76,-2,41,-31,-41,-80,-72,-44,0,-27,-62,-17,-10,-79,-81,-9,37,43,46,17,-15,-14,83,62,65,
71,55,31,9,19,19,38,34,22,25,41,34,6,33,42,59,19,-26,1,24,-5,-27,-35,-25,-9,7,13,7,41,69,
10,-41,39,25,-64,-40,-77,-30,12,27,-15,-76,-50,-27,-56,-63,-7,44,47,41,41,10,23,56,51,54,51,38,15,27,
26,21,33,41,30,44,32,29,-12,15,40,66,28,-30,-15,10,-4,-35,-50,-39,-22,-5,1,1,23,49,-3,-40,20,-22,
-103,-76,-48,-20,13,36,4,-58,-46,-38,-68,-68,-7,41,48,54,60,24,25,58,58,58,38,23,11,26,39,28,29,40,
35,39,18,19,-8,-25,18,56,31,-15,-40,-2,-11,-25,-36,-35,-37,-36,-17,-9,-10,20,-10,-43,-21,-80,-128,-73,-46,-34,
8,46,15,-36,-32,-28,-65,-67,-25,21,31,46,54,28,10,40,75,63,41,34,6,4,13,29,37,19,0,15,-3,17,
-37,-48,-9,35,30,19,9,28,6,-6,-18,-19,-27,-38,-35,-34,-17,7,-11,-40,-40,-62,-92,-37,-32,-25,12,30,3,-9,
-6,-34,-23,-38,-23,1,8,28,39,23,-4,16,43,46,26,19,5,-2,8,11,-3,-18,-30,-25,-51,-41,-43,-52,-29,-4,
4,34,45,51,40,27,7,-9,-21,-30,-28,-26,-26,-15,-5,-19,-53,-49,-44,-26,-4,-7,20,30,17,17,7,-32,-30,-35,
-17,3,6,12,12,-4,-13,7,17,15,-8,-25,-32,-41,11,7,-22,-44,-61,-70,-92,-69,-21,-52,-37,-19,-18,43,76,70,
71,67,49,22,-5,-22,-23,-19,-24,-27,6,4,-57,-52,-58,-66,-15,-29,4,38,41,28,2,-28,-32,-27,-2,19,23,16,
4,-10,-34,-20,-22,-23,-23,-24,-37,-51,-55,-58,-92,-98,-90,-99,-128,-122,-22,-66,-53,-27,-36,26,81,93,96,105,97,70,
40,19,20,33,18,7,21,11,-49,-52,-87,-85,-74,-93,-47,8,21,12,-6,-16,-24,-24,-13,1,4,-14,-48,-69,-83,-76,
-67,-32,23,46,13,-29,-46,-39,-96,-128,-128,-128,-128,-128,-18,-57,-69,-58,-69,-28,34,81,121,127,127,127,106,81,75,88,
103,101,77,31,-30,-53,-107,-72,-102,-113,-75,-40,-33,-29,-26,-26,-27,-36,-48,-54,-61,-87,-128,-128,-91,-14,66,104,105,100,
82,47,13,24,-43,-128,-128,-128,-128,-128,14,-9,-89,-103,-114,-94,-32,-13,57,118,127,127,127,127,125,116,127,127,127,102,
51,12,-59,-56,-81,-96,-94,-85,-71,-43,-23,-21,-24,-16,-32,-58,-68,-73,-66,-46,37,51,67,75,77,126,127,127,115,111,
51,-39,-114,-128,-128,-117,28,22,-51,-103,-128,-128,-120,-85,-52,35,116,127,127,127,125,113,120,127,127,127,101,41,-25,-25,
36,22,13,9,12,34,54,58,42,78,82,56,19,-16,-23,-8,23,50,54,65,69,126,127,127,127,127,91,10,-57,-76,
-63,-24,35,52,16,-15,-70,-128,-128,-114,-128,-90,-28,48,95,106,83,67,82,96,121,124,127,127,111,74,91,97,53,47,
91,95,77,76,110,127,116,51,-18,-48,-62,-68,-65,-25,25,58,81,103,127,127,127,127,85,27,-50,-78,-11,17,29,75,
65,60,65,31,5,-3,-46,-38,-31,-10,13,33,45,59,68,110,127,127,127,127,127,126,116,120,102,98,103,92,73,48,
38,44,5,-74,-115,-117,-117,-109,-98,-72,-35,5,41,66,125,127,127,113,28,-37,-63,-50,9,18,48,73,57,53,65,45,
40,44,44,43,42,47,46,43,35,42,61,97,127,127,127,96,55,28,-19,-9,-1,3,-6,-12,-7,-22,-67,-57,-83,-128,
-128,-98,-93,-90,-80,-73,-52,-24,11,30,51,106,127,92,6,-85,-94,-66,-4,15,44,76,73,66,69,61,43,27,47,54,
61,48,49,67,56,56,53,41,39,56,53,-3,-72,-112,-128,-128,-125,-98,-86,-76,-58,-62,-43,-47,-77,-109,-96,-63,-47,-36,
-23,-16,0,19,24,17,7,23,74,54,-17,-85,-74,-39,5,28,11,51,57,65,70,74,56,38,28,37,45,22,-1,-9,
-32,-28,6,-21,-59,-78,-106,-128,-128,-128,-128,-128,-91,-44,-35,-29,-17,-34,-33,-18,-10,-19,-26,-40,-60,-65,-58,-60,-51,-40,
-37,-29,-32,-38,25,61,35,1,-6,10,31,40,-3,-15,-16,-6,-3,4,0,-4,1,0,4,-8,-19,-25,-50,-45,-45,-54,
-75,-96,-126,-128,-128,-128,-128,-128,-70,-27,-29,-34,-21,-32,-38,-28,-23,-22,-27,-40,-52,-59,-67,-64,-51,-49,-49,-31,-33,-49,
-56,-12,1,-12,-15,-14,6,1,65,77,48,54,82,83,92,84,83,78,70,58,65,87,96,115,113,123,127,127,127,127,
127,127,117,105,88,67,51,62,83,78,65,46,10,16,25,23,31,27,30,40,44,50,60,63,66,80,106,127,127,84,
89,25,-21,2,57,98,70,70,84,84,73,57,20,-12,-32,-19,-3,3,1,25,48,35,28,71,117,127,127,127,100,77,
59,53,33,34,42,40,50,49,-1,-48,-59,-58,-39,-27,-17,-1,8,12,23,35,54,77,127,127,127,127,96,8,-47,-17,
62,49,5,3,10,-23,-52,-47,-90,-103,-82,-30,-9,-37,-87,-95,-106,-127,-128,-120,-38,41,79,105,98,91,78,41,-9,-37,
-48,-52,-25,-23,-86,-127,-118,-114,-118,-113,-109,-96,-77,-56,-26,-1,19,44,123,127,127,66,40,-18,-75,-44,14,16,-31,-75,
-104,-128,-125,-98,-80,-68,-13,43,43,-2,-55,-72,-128,-128,-128,-128,-118,-51,-20,-23,-13,8,55,95,98,75,27,-17,-69,-110,
-128,-128,-128,-128,-128,-128,-122,-97,-72,-51,-27,-12,11,49,116,98,101,69,92,46,-47,-23,9,-37,-128,-128,-128,-128,-44,61,
90,127,127,127,89,30,-16,-54,-55,-66,-65,-65,-41,16,54,42,88,64,35,20,41,80,88,74,-18,-72,-128,-128,-128,-100,
-83,-98,-83,-62,-49,-45,-43,-53,-35,13,41,19,31,39,73,53,-33,0,-49,-126,-128,-128,-67,29,127,127,127,127,127,127,
84,64,42,8,3,-8,10,24,37,71,99,100,127,127,127,73,36,23,21,35,-2,-29,-41,-40,-45,-51,-57,-66,-93,-74,
-64,-43,-34,-41,-16,18,-25,-10,35,32,22,30,-19,10,-100,-128,-125,-25,62,116,127,127,127,127,127,127,117,105,69,9,
-11,-20,-16,5,35,52,58,90,105,97,80,47,6,-19,-28,-43,-56,-32,-17,-3,16,-15,-76,-100,-110,-67,-46,-40,-43,-26,
19,34,29,45,17,-26,-39,-11,21,5,-128,-128,-23,51,80,127,127,127,127,105,97,96,71,33,-27,-95,-121,-128,-128,-115,
-83,-52,18,105,36,19,23,22,-3,-12,-12,-36,-41,-25,-19,4,64,104,105,113,65,83,72,15,-13,11,45,50,20,-16,
-101,-115,-85,-19,54,36,-128,-115,-9,68,118,127,127,104,67,42,24,7,-36,-74,-124,-128,-128,-128,-128,-128,-126,-85,52,115,
23,39,36,29,24,5,-13,-19,-10,-17,-22,-21,5,57,126,127,127,127,127,110,33,14,50,31,-40,-58,-54,0,16,84,
108,71,-115,-52,17,41,70,89,83,81,20,-12,-43,-62,-109,-128,-128,-128,-128,-128,-128,-96,-82,-28,74,89,-24,29,37,11,
3,2,-7,-10,-7,-12,-12,-13,-1,35,87,127,127,127,127,127,127,83,37,-15,-115,-122,-90,-29,-1,101,127,127,-37,17,
40,24,45,81,73,48,6,-19,-61,-101,-128,-128,-128,-128,-114,-116,-100,-91,-70,-6,46,44,-33,30,27,-25,-40,-24,1,30,
2,-18,-18,-21,-32,-26,3,33,122,127,127,127,127,127,92,10,-15,-34,-19,2,-33,-1,1,22,-12,21,19,3,30,77,
63,11,3,-7,-31,-54,-89,-108,-98,-71,-84,-70,-59,-91,-72,-35,-24,-4,-59,9,28,-3,-13,-11,13,65,31,3,-7,-16,
-32,-41,-41,-46,29,79,112,127,127,123,107,83,-9,-52,-56,-58,-102,-92,-105,-40,-8,8,-4,-1,15,31,19,-14,11,11,
2,-2,-14,-33,-57,-72,-61,-49,-63,-99,-47,-20,-58,-55,-88,-22,21,23,32,25,30,87,48,27,20,4,-18,-27,-51,-93,
-85,-24,30,62,90,112,121,108,16,-66,-116,-128,-128,-119,-128,-83,-10,2,-8,2,8,13,19,5,28,29,18,12,19,35,
9,-35,-49,-41,-64,-96,-30,2,-43,-67,-106,-51,-9,13,52,51,48,107,84,51,37,25,14,21,1,-57,-85,-19,27,25,
40,59,50,27,-4,-67,-107,-128,-128,-128,-128,-125,1,-26,-41,-24,3,10,7,17,49,26,-2,7,29,46,36,14,-28,-30,
-58,-100,-25,22,-62,-97,-44,-22,-16,12,55,51,64,103,81,45,39,39,37,55,15,-55,-76,-16,15,12,33,46,26,11,
-1,-35,-67,-108,-128,-128,-128,-122,-6,-54,-56,-37,-13,8,3,5,45,21,-14,-13,11,44,41,12,-21,-18,-26,-81,-48,-13,
-80,-93,1,2,-6,10,52,58,74,113,66,34,26,23,14,27,-10,-72,-97,-26,6,-5,20,28,7,7,-3,-28,-53,-94,
-128,-128,-128,-95,-43,-79,-70,-60,-28,-8,8,8,44,52,11,-22,1,44,37,8,-16,-7,3,-43,-42,5,-69,-123,-38,-4,
-17,-21,28,76,86,67,42,8,-8,8,31,40,-24,-79,-65,17,46,26,15,14,11,22,-2,-7,-47,-69,-128,-128,-127,-74,
-55,-98,-86,-62,-17,10,27,24,72,82,48,13,14,48,49,26,1,-14,15,2,-37,-5,-15,-15,21,24,17,44,87,88,
56,15,15,7,-15,1,32,24,-50,-90,-50,19,54,37,10,-3,-16,-5,-2,-5,-47,-66,-124,-127,-118,-54,-62,-111,-99,-64,
-7,27,45,40,84,89,68,40,28,49,50,32,38,16,53,72,-4,-20,5,43,39,26,11,44,69,57,29,-14,-26,13,
1,12,40,20,-33,-53,-60,-4,36,29,-9,-31,-42,-26,4,5,-31,-53,-115,-127,-122,-56,-62,-109,-105,-68,-5,37,53,36,
64,62,45,35,36,53,45,21,38,45,94,127,56,4,18,52,44,32,20,42,44,21,6,-26,-36,36,29,10,4,-31,
-53,-39,-47,-7,32,25,-30,-50,-47,-16,-1,8,-15,-39,-110,-128,-128,-74,-74,-111,-107,-72,-2,39,43,11,19,11,-10,-3,
26,58,47,19,16,52,90,127,117,92,103,117,99,66,11,2,5,-6,-32,-90,-19,55,34,-8,-37,-72,-41,24,-6,23,
64,52,-23,-45,-47,-21,-13,3,-10,-34,-112,-128,-128,-88,-87,-117,-112,-73,3,37,29,-14,-21,-34,-65,-53,2,49,45,25,
16,52,80,127,127,127,114,107,50,14,-18,13,42,24,-16,-70,-3,84,48,-26,-61,-61,8,103,44,59,86,70,-14,-41,
-55,-47,-9,9,-3,-35,-118,-127,-128,-95,-79,-127,-116,-75,7,31,11,-29,-39,-47,-79,-75,-24,27,19,17,31,50,77,109,
127,127,98,85,82,100,73,63,48,14,-24,-65,-52,76,59,-14,-34,-50,21,106,70,92,88,90,-26,-56,-54,-49,13,30,
11,-40,-128,-127,-128,-85,-77,-127,-120,-79,5,29,9,-29,-30,-39,-74,-71,-22,29,21,17,26,46,78,111,127,126,89,73,
45,71,49,38,24,-6,-40,-77,-67,67,52,-18,-31,-45,22,105,69,94,93,97,-20,-52,-49,-43,16,34,15,-39,-128,-126,
-128,-81,-90,-117,-120,-81,-4,34,30,-9,-8,-25,-60,-53,1,51,50,21,16,47,70,124,127,99,62,54,-4,-37,-60,-27,
4,-16,-54,-103,-36,70,38,-38,-65,-53,4,93,50,60,98,78,1,-28,-46,-37,0,17,7,-30,-118,-126,-128,-89,-79,-112,
-115,-79,-8,37,48,20,21,16,-11,-11,14,47,42,12,13,39,67,115,85,39,42,62,48,19,-22,-21,-19,-45,-71,-118,
-53,45,33,-14,-40,-69,-44,26,6,26,70,54,-15,-38,-36,-3,5,18,3,-28,-110,-123,-125,-81,-70,-111,-109,-73,-9,36,
54,42,58,63,44,27,22,36,32,11,25,27,66,98,14,-52,-33,16,9,-5,-9,25,25,-12,-28,-56,-62,28,30,10,
6,-32,-61,-34,-41,-8,36,31,-20,-44,-33,6,23,28,-1,-34,-105,-120,-120,-65,-71,-113,-102,-67,-10,24,38,35,73,84,
63,35,18,31,33,17,24,5,34,44,-38,-68,-36,26,30,6,-10,31,57,35,4,-42,-38,12,-1,3,36,20,-43,-57,
-56,-8,38,40,6,-21,-24,-4,31,24,-19,-48,-106,-112,-106,-44,-62,-98,-90,-67,-19,9,16,12,58,71,41,10,8,30,
29,8,-14,-26,-6,-21,-58,-36,-41,-14,25,21,0,19,67,69,35,-15,10,4,-31,-32,3,9,-64,-97,-43,16,53,45,
23,6,3,15,19,9,-37,-59,-108,-105,-97,-38,-47,-78,-74,-66,-29,-7,-2,-7,29,38,3,-21,-2,28,18,-10,-31,-20,
-14,-53,-39,5,-69,-106,-14,22,-10,-32,16,58,63,40,26,-7,-37,-37,-16,9,-44,-80,-54,16,43,29,20,17,28,41,
15,4,-35,-55,-110,-110,-102,-56,-25,-62,-62,-46,-17,4,-8,-14,22,7,-22,-18,7,28,21,-6,-39,-25,-32,-75,-25,19,
-60,-88,23,39,8,1,42,50,69,99,46,5,-15,-24,-26,4,-21,-60,-78,-13,17,8,25,29,26,31,16,-9,-35,-67,
-128,-119,-109,-80,-32,-51,-53,-32,-3,6,-4,-8,24,9,-14,-1,21,28,16,-3,-46,-32,-54,-88,-2,59,-26,-74,-17,11,
-4,8,50,47,68,101,68,13,-9,-13,-3,32,3,-47,-57,3,33,29,45,50,42,32,18,-14,-43,-78,-128,-128,-127,-109,
-53,-45,-31,-4,-5,4,13,-16,-1,3,1,2,14,33,13,-30,-49,-39,-55,-80,-17,28,1,-41,-79,-23,3,8,42,50,
54,114,73,19,-14,-31,-32,-11,-15,-53,-71,-11,32,33,46,62,65,52,24,-35,-66,-128,-128,-128,-128,-112,-37,-46,-44,-12,
7,18,8,-28,-17,-11,-10,-10,-20,-27,-36,-46,-47,-41,-49,-77,-30,-1,-35,-53,-81,-11,24,17,31,34,43,95,44,6,
-20,-44,-63,-61,-71,-96,-88,-30,27,65,99,127,127,127,95,3,-56,-115,-128,-125,-128,-80,-42,-32,-32,-23,19,69,54,-4,
-21,-27,-39,-56,-89,-97,-71,-38,-49,-48,-37,-69,-62,-33,-29,-19,-72,3,19,-13,-12,3,27,71,38,-10,-40,-59,-72,-73,
-62,-55,18,70,118,127,127,127,127,127,114,46,16,-20,-92,-93,-115,-51,-58,-22,-11,-16,23,67,60,27,-19,-45,-76,-104,
-128,-128,-117,-97,-69,-77,-62,-64,-69,-21,33,37,-36,25,14,-38,-40,-11,13,36,0,-32,-46,-55,-62,-49,-15,18,114,127,
127,127,127,127,127,127,88,40,17,3,-49,-15,-7,20,-116,-66,-20,0,38,62,63,62,-4,-39,-68,-81,-114,-128,-128,-128,
-128,-128,-98,-56,-67,-28,69,79,-20,30,30,6,9,8,-10,-20,-15,-26,-35,-36,-12,35,84,122,127,127,127,127,127,96,
46,11,-89,-110,-105,-63,-33,84,127,127,-128,-118,-35,31,85,112,103,85,50,21,1,-14,-48,-74,-110,-128,-128,-128,-128,-104,
-108,-74,45,83,38,51,40,32,34,9,-21,-31,-30,-41,-46,-35,5,59,117,127,127,127,127,105,20,-21,-2,-9,-61,-79,
-89,-32,10,91,119,79,-128,-128,-31,46,72,100,127,127,120,88,76,70,47,17,-30,-83,-102,-111,-116,-89,-72,-50,2,56,
28,14,12,14,0,-17,-23,-37,-41,-29,-17,6,44,50,33,41,7,53,63,11,-18,-4,21,13,-8,-24,-97,-103,-58,12,
68,46,-84,-128,-111,-8,72,112,127,127,127,127,121,113,101,89,58,8,-13,-20,-16,2,9,5,-9,12,35,27,25,25,
14,-1,-8,-16,-42,-24,-16,-15,-19,-73,-128,-128,-128,-85,-55,-36,-33,-18,17,16,8,56,32,-17,-24,0,11,-11,-23,-77,
-128,-128,-53,26,123,127,127,127,127,127,90,78,58,30,28,17,29,24,14,40,64,55,97,117,115,93,85,84,70,69,
34,-14,-44,-63,-85,-90,-80,-74,-91,-76,-61,-33,-20,-34,-24,-7,-61,-18,33,20,21,20,-54,-11,28,15,-67,-128,-128,-128,
-54,37,81,127,127,127,125,83,43,10,1,-15,-23,-37,-13,58,96,69,116,113,107,102,120,127,127,101,-12,-88,-128,-128,
-128,-115,-73,-71,-67,-58,-55,-55,-52,-58,-43,-7,-6,-6,26,37,63,21,-85,-40,25,44,6,-22,-59,-109,-127,-121,-118,-105,
-49,11,29,20,2,6,-58,-65,-88,-110,-76,2,37,21,31,49,79,102,94,53,-20,-80,-128,-128,-128,-128,-128,-109,-108,-116,
-104,-91,-76,-56,-22,4,25,51,97,81,92,71,90,42,-63,-39,65,65,25,36,42,-1,-47,-50,-115,-128,-125,-84,-62,-73,
-101,-88,-73,-93,-118,-108,-49,29,66,73,39,13,-18,-58,-99,-121,-128,-128,-85,-80,-118,-128,-106,-95,-104,-109,-110,-101,-86,-59,
-18,19,44,66,115,127,127,61,37,-1,-52,-34,75,125,104,102,116,110,89,72,27,-10,-34,-28,-16,-18,-27,-1,23,21,
25,59,90,108,77,51,-17,-39,-40,-30,-37,-20,9,18,31,33,-2,-45,-59,-61,-44,-34,-28,-14,-5,3,20,40,62,89,
127,127,127,127,87,40,19,31,75,96,77,86,110,110,111,103,104,93,77,65,78,94,86,101,92,99,108,116,127,127,
116,77,64,56,50,37,27,49,72,63,57,40,7,7,14,16,29,29,32,39,41,46,58,63,69,89,109,127,116,77,
89,57,43,36,16,34,23,-12,-22,5,-2,-3,-6,-2,-14,-49,-73,-75,-83,-88,-85,-110,-104,-89,-103,-115,-98,-77,-49,-43,
-15,0,5,26,47,60,55,74,80,76,41,20,19,25,43,44,43,54,62,56,58,63,69,76,69,73,78,127,123,35,
3,9,2,-16,-34,-21,-12,6,18,19,5,-22,-38,-42,-43,-35,-72,-81,-83,-91,-115,-128,-128,-128,-128,-128,-128,-128,-72,-12,
29,59,95,100,112,125,91,62,34,7,-3,13,19,19,11,7,14,18,16,47,65,85,113,127,120,94,-15,-8,-18,-26,
-11,37,48,19,6,25,21,-9,-24,-15,-7,1,-24,-9,5,3,-27,-68,-103,-87,-92,-99,-98,-98,-113,-103,-44,24,85,79,
95,117,105,68,26,-12,-53,-54,-43,-38,-38,-37,-32,-25,7,6,0,44,96,79,14,16,5,26,46,66,91,74,4,-48,
-69,-14,40,68,77,77,55,33,19,-17,-64,-90,-90,-73,-51,-1,0,35,87,107,81,24,9,37,36,46,65,87,102,102,
75,42,12,-3,-12,-24,-43,-55,-52,-39,-7,-38,-49,63,127,86,-15,-41,9,101,127,105,36,-63,-128,-128,-80,27,125,127,
127,127,127,127,127,127,71,13,-35,-75,-113,-128,-128,-110,-25,72,111,96,90,117,58,-17,-26,28,60,75,82,75,51,21,
-12,-38,-61,-75,-59,-46,-75,-117,-99,51,106,43,-37,-61,70,127,127,99,-33,-97,-125,-80,17,99,127,127,127,127,127,127,
111,93,80,92,62,11,-37,-76,-81,-74,-17,53,73,59,71,106,91,20,6,-5,-68,-64,3,55,71,14,-41,-67,-84,-99,
-109,-128,-128,-128,-128,-44,-22,-69,-100,-81,127,127,127,-8,-113,-122,-73,11,42,74,101,86,56,52,54,49,13,-30,-63,-19,
14,15,57,35,-58,-39,-8,-2,-18,-36,-35,-11,3,-4,22,6,-88,-128,-84,-35,-6,-12,-29,-36,-50,-71,-72,-80,-96,-97,
-66,-56,-49,-52,-82,-72,127,127,45,-72,-75,-50,-11,46,30,33,24,0,-12,-9,-16,-31,-68,-97,-116,-78,-61,-56,-9,-35,
-51,-13,17,17,20,10,-17,-14,-15,-37,-40,-32,-76,-128,-128,-109,-80,-20,25,26,30,44,35,-12,-31,-35,-47,-58,-8,24,
-5,-37,127,82,3,-68,-22,25,22,7,5,-12,-30,-51,-69,-65,-50,-46,-53,-79,-45,-45,-47,-5,21,-5,-36,38,66,78,
83,58,40,16,35,10,-26,-39,-22,-23,-50,-65,-93,-79,-56,-5,53,88,96,51,64,8,-65,-21,97,127,26,-6,75,27,
-17,-21,44,40,-3,-12,-41,-66,-94,-102,-88,-65,-45,-32,-18,-24,-12,5,46,57,14,-18,-59,24,82,112,107,76,57,18,
17,3,-20,-26,-4,8,-5,-13,11,-1,-9,30,108,127,127,65,52,40,19,33,68,22,-76,-64,15,-2,7,39,71,6,
-53,-53,-54,-70,-95,-87,-54,-21,-4,9,-4,7,-2,24,81,46,-27,-37,-32,36,87,127,127,102,87,48,17,12,14,25,
35,30,20,19,-13,-9,8,35,67,86,82,61,65,48,32,20,-7,-72,-101,-31,-5,19,48,29,4,-32,-38,-40,-14,-25,
-47,-43,-21,-9,-2,13,3,1,-9,28,59,0,-46,-27,56,91,87,113,127,113,101,82,3,6,25,50,56,39,14,11,
-6,0,21,28,29,41,42,33,-5,-28,-19,-2,-13,-58,-84,-44,13,56,53,-21,-57,-34,23,26,43,27,-9,-32,-34,-29,
-23,-12,1,-12,13,65,26,-71,-92,-70,16,70,51,70,122,112,94,72,-11,-20,-4,27,46,32,8,-2,-4,-3,31,38,
32,48,56,56,41,-15,-47,-56,-46,-59,-85,-69,32,47,3,-54,-47,-17,52,78,90,69,17,-31,-52,-44,-25,-13,-5,-21,
29,103,17,-102,-89,-74,-90,21,31,40,105,110,93,64,9,-23,-40,-26,-1,-1,-28,-45,-68,-41,33,60,46,38,27,30,
69,46,15,-35,-51,-74,-99,-74,21,23,-25,-85,-47,31,72,84,101,51,-6,-40,-51,-49,-42,-33,-22,-22,-1,100,0,-128,
-100,-57,-7,103,47,10,64,91,106,61,18,-18,-75,-94,-52,-40,-56,-97,-128,-76,43,73,54,63,46,44,44,54,42,8,
-33,-51,-91,-85,1,8,-34,-93,-55,29,78,86,88,38,-5,-26,-45,-59,-60,-47,-48,-34,-4,95,-25,-128,-128,-112,6,109,
46,5,63,94,108,65,-11,-58,-112,-123,-71,-40,-68,-128,-128,-73,70,102,71,73,51,53,42,40,17,-11,-50,-63,-92,-82,
-11,-15,-53,-105,-47,25,66,73,53,24,1,-17,-32,-29,-47,-66,-58,-79,-25,109,15,-128,-120,-65,35,93,73,46,67,98,
91,48,-10,-104,-128,-117,-108,-48,-9,-117,-128,-89,72,79,38,57,71,77,62,53,10,0,-13,-60,-91,-91,-6,-11,-57,-106,
-49,16,58,67,44,15,-3,-14,-33,-36,-49,-61,-56,-87,-46,98,77,-49,-68,-41,54,104,94,73,84,90,69,40,-10,-123,
-128,-128,-117,-7,62,-21,-128,-106,33,60,38,54,74,97,100,84,20,5,4,-41,-78,-84,2,-4,-51,-100,-53,8,56,59,
34,6,-11,-17,-40,-48,-56,-55,-65,-99,-94,50,119,36,6,38,101,127,127,118,101,73,50,53,17,-121,-128,-128,-60,64,
110,26,-118,-109,20,63,34,35,59,103,127,115,35,6,9,-30,-63,-68,9,-2,-48,-95,-56,3,58,59,35,4,-13,-20,
-40,-45,-48,-39,-52,-79,-100,17,118,63,39,81,127,127,121,99,60,25,39,88,27,-103,-128,-128,-60,90,127,77,-97,-110,
11,54,-1,-11,32,109,127,127,49,1,-1,-32,-47,-42,11,-4,-49,-94,-54,6,64,67,38,7,-14,-20,-37,-39,-38,-28,
-34,-52,-74,5,85,66,75,122,127,119,65,18,-24,-28,-7,14,-36,-120,-128,-128,-128,55,127,127,-109,-120,2,34,-40,-54,
10,114,127,127,74,6,-11,-32,-30,-21,1,-18,-63,-104,-60,-3,58,68,34,4,-17,-24,-39,-39,-39,-32,-31,-25,-36,25,
65,34,32,78,79,53,16,-23,-78,-101,-91,-87,-128,-128,-128,-128,-128,-20,127,127,-121,-116,4,23,-61,-71,9,127,127,127,
93,8,-23,-36,-26,-18,-11,-42,-83,-128,-83,-26,48,72,41,1,-8,-3,-33,-39,-41,-37,-31,-18,-27,27,99,65,14,47,
17,-3,-36,-93,-128,-128,-128,-128,-128,-128,-128,-128,-128,-40,127,127,-128,-102,38,24,-65,-66,11,127,127,127,97,5,-37,-58,
-30,-15,-14,-46,-89,-128,-90,-31,45,71,43,3,-6,-2,-32,-38,-39,-35,-28,-18,-34,23,107,80,29,59,19,-4,-34,-87,
-128,-128,-128,-128,-128,-128,-128,-128,-128,-36,127,127,-128,-98,39,22,-65,-64,11,127,127,127,94,0,-43,-62,-31,-15,-8,-24,
-76,-115,-73,-13,49,63,38,12,-13,-27,-36,-32,-31,-24,-23,-20,-39,28,69,45,46,98,101,69,27,-7,-58,-85,-78,-87,
-128,-128,-128,-128,-128,-20,127,127,-124,-118,-5,22,-55,-65,11,123,127,127,75,-13,-42,-43,-29,-22,2,-10,-64,-109,-74,-14,
46,59,42,16,-6,-18,-29,-29,-25,-14,-23,-44,-69,20,88,61,65,119,127,127,75,33,-4,-18,-12,-11,-40,-100,-128,-128,
-128,47,127,127,-117,-121,-3,40,-29,-46,11,104,127,127,42,-28,-39,-43,-36,-25,4,-6,-60,-111,-81,-24,32,47,36,12,
-6,-16,-30,-35,-33,-21,-41,-74,-89,37,110,39,11,58,127,127,122,116,89,47,48,80,14,-86,-128,-128,-62,77,127,86,
-88,-98,17,68,14,-2,30,91,124,109,3,-43,-33,-44,-57,-48,1,-6,-61,-115,-79,-23,24,40,35,15,0,-8,-27,-36,
-41,-37,-51,-97,-84,61,92,-2,-29,9,73,112,121,127,124,88,61,58,18,-99,-128,-128,-51,60,111,38,-84,-80,29,73,
40,34,49,80,93,68,-21,-42,-23,-41,-75,-79,-9,-14,-64,-121,-77,-18,22,44,47,29,16,5,-12,-17,-28,-37,-37,-80,
-31,105,48,-79,-96,-73,30,92,87,81,103,105,83,44,7,-95,-128,-128,-98,-1,74,3,-116,-72,37,59,34,45,54,64,
50,25,-40,-44,-24,-46,-86,-94,-20,-21,-57,-117,-78,-13,24,48,55,40,26,9,-3,0,-17,-36,-41,-70,-13,109,-10,-128,
-128,-95,14,86,69,57,88,111,105,58,12,-73,-109,-96,-94,-43,5,-86,-128,-49,74,74,32,45,45,36,-1,-13,-50,-45,
-35,-59,-94,-95,-11,-4,-32,-99,-83,-12,26,47,78,52,27,8,-6,-14,-19,-17,-28,-24,6,97,-38,-128,-128,-120,-8,92,
36,15,77,100,116,76,16,-28,-80,-95,-62,-44,-53,-113,-126,-38,76,89,52,50,17,2,-29,-26,-35,-38,-52,-60,-97,-87,
9,13,-13,-83,-74,-13,15,33,85,62,30,3,-5,-1,1,2,6,8,22,115,2,-108,-80,-52,-13,96,41,14,66,89,
109,68,34,13,-40,-66,-43,-51,-50,-81,-128,-57,40,55,28,29,-3,-22,-33,-13,-4,-9,-30,-51,-101,-92,25,32,2,-44,
-58,-64,-9,19,52,70,59,28,7,11,22,21,19,5,59,122,29,-64,-49,-71,-88,8,19,30,93,106,96,75,28,3,
-15,-8,0,-13,-31,-32,-44,-29,21,33,14,-5,-28,-36,0,-11,-20,-50,-47,-83,-110,-79,13,45,46,-17,-58,-58,-23,-33,
-7,15,22,24,27,32,27,18,25,16,42,91,43,-36,-48,-54,19,55,39,59,107,111,102,78,0,-11,-2,22,37,23,
13,17,17,5,18,8,-12,-10,-3,-1,-15,-54,-63,-57,-37,-63,-83,-66,-9,8,33,23,9,-38,-61,-78,-60,-44,-31,-2,
34,52,53,49,19,22,21,61,80,20,-17,-13,45,69,77,109,127,115,103,77,6,6,16,35,38,20,4,11,-1,-2,
1,-13,-25,-18,-9,-11,-35,-57,-42,-10,-1,-50,-65,-25,-5,-26,-15,24,70,10,-57,-71,-96,-100,-101,-69,-18,23,40,44,
17,20,17,49,102,63,-6,-23,-24,33,87,127,127,101,79,33,6,4,6,15,20,10,3,9,-15,-14,-11,-7,17,43,
59,52,64,32,5,1,-6,-81,-104,-33,51,-5,-42,-46,24,39,3,-18,-63,-84,-102,-95,-68,-38,-18,-7,-2,-13,6,29,
72,73,28,-8,-47,30,89,114,96,60,39,-1,-4,-14,-31,-33,-15,-5,-13,-13,0,-19,-36,-1,89,127,127,74,35,10,
-29,-25,26,-10,-89,-72,110,56,-17,-96,-55,9,19,3,4,-6,-18,-31,-42,-36,-25,-23,-35,-65,-34,-31,-24,5,20,-10,
-18,40,68,76,69,41,23,-4,12,-14,-45,-55,-47,-54,-81,-91,-104,-82,-47,3,50,70,70,21,38,-12,-73,-37,92,127,
60,19,127,127,42,-76,-90,-71,-32,25,28,38,41,29,24,30,25,12,-32,-72,-95,-70,-43,-44,-7,-33,-47,-27,-6,-3,
-8,-20,-40,-42,-65,-75,-64,-49,-82,-128,-128,-114,-95,-31,9,10,20,34,26,-21,-21,-21,-16,-12,43,81,50,6,127,127,
127,-1,-94,-125,-91,-5,24,60,97,101,94,98,96,85,54,14,-17,12,43,24,63,52,-63,-65,-49,-49,-77,-90,-74,-50,
-25,-20,14,7,-71,-117,-96,-68,-40,-32,-39,-34,-39,-59,-55,-52,-57,-48,7,32,22,-6,-54,-59,57,127,127,74,-22,-90,
-127,-94,9,89,127,127,127,127,127,127,127,127,123,112,72,0,-57,-76,-90,-92,-26,48,48,24,47,91,98,38,32,27,
-31,-40,8,52,69,19,-33,-58,-69,-78,-84,-98,-118,-117,-76,38,55,-26,-90,-92,5,82,96,76,40,-41,-128,-128,-81,16,
98,124,127,127,127,127,127,127,113,40,-9,-54,-95,-100,-128,-105,-4,108,127,114,115,127,90,23,11,53,78,88,86,73,
48,22,-10,-33,-50,-61,-47,-33,-51,-85,-66,94,127,82,-30,-67,12,32,39,39,67,57,5,-39,-48,-3,35,47,37,31,
23,14,25,12,-18,-30,-20,-7,-4,24,29,46,100,127,115,65,53,71,67,63,70,89,99,94,62,28,0,-11,-23,-39,
-59,-72,-69,-53,-16,-43,-49,76,127,112,-16,-50,-18,1,-6,-31,-21,19,26,-11,-18,2,2,-26,-48,-44,-36,-26,-38,-12,
16,26,4,-33,-63,-43,-36,-55,-61,-57,-70,-67,-22,29,86,75,85,101,87,46,5,-30,-66,-63,-56,-57,-61,-62,-56,-43,
-11,-9,-11,48,120,108,28,13,6,18,15,-5,-20,-11,-8,-5,-1,1,-12,-38,-59,-69,-72,-61,-87,-96,-98,-102,-126,-128,
-128,-124,-128,-128,-128,-100,-49,4,39,66,93,95,98,96,55,26,7,-12,-20,-8,-4,-8,-17,-24,-19,-7,-1,25,41,77,
127,127,127,101,24,38,28,-12,-19,7,5,2,0,0,-17,-55,-79,-80,-88,-91,-91,-120,-124,-112,-126,-128,-108,-70,-42,-30,
-5,5,8,25,50,69,58,68,65,57,30,14,17,23,29,28,27,40,51,46,48,58,67,69,62,72,93,127,127,42,
-46,-67,-67,-81,-83,-77,-57,-35,-14,-11,14,54,90,106,109,104,93,68,65,65,35,11,1,-15,-44,-63,-67,-73,-83,-74,
-49,-30,-34,-26,-8,32,73,80,85,84,50,40,50,38,34,41,45,66,80,79,66,127,106,87,23,-9,-54,-104,-118,-124,
-128,-127,-95,-53,-24,37,121,127,127,127,127,108,75,63,72,82,59,23,-11,-44,-100,-99,-80,-64,-71,-78,-61,-35,-35,-24,
0,45,105,127,127,127,93,48,31,36,40,17,12,38,97,125,127,127,111,107,31,-2,-32,-75,-108,-128,-128,-126,-70,23,
109,127,127,127,47,-27,-54,-85,-92,-87,-65,-52,-88,-125,-110,-79,-49,-13,25,46,39,16,11,38,35,38,43,42,63,53,
27,15,-13,-42,-62,-42,-13,-10,1,28,78,127,127,123,37,30,-48,-101,-54,-74,-101,-112,-120,-62,32,120,92,41,-39,-113,
-128,-128,-128,-128,-128,-128,-128,-128,-128,-128,-128,-101,-89,-88,-105,-121,-98,-58,0,60,82,120,127,102,70,40,14,13,-46,-63,
-121,-128,-128,-108,-59,-18,79,127,127,57,13,-16,-88,-104,-59,-91,-118,-75,-19,43,74,13,-68,-115,-119,-75,-62,-78,-82,-101,
-82,-83,-85,-90,-101,-98,-84,-93,-117,-94,-87,-91,-95,-100,-83,-30,114,127,127,127,127,84,24,32,12,-35,-93,-128,-128,-128,
-125,-29,17,66,48,2,-23,-65,-128,-103,-47,-56,-33,68,93,50,13,-37,-46,-50,-31,11,1,-23,11,39,43,54,79,99,
106,103,77,32,-8,-24,-52,-78,-102,-128,-128,-70,93,127,127,127,127,105,37,28,34,17,7,-48,-106,-128,-113,-44,-2,23,
9,17,-14,-87,-128,-113,-36,8,102,127,73,10,1,-1,16,18,28,39,50,73,104,125,127,127,117,97,77,51,6,-16,
-60,-66,-79,-111,-112,-100,-86,-36,64,109,118,102,95,100,75,89,64,24,-27,-78,-97,-86,-69,-53,-30,-4,40,58,-48,-128,
-128,-56,8,123,127,26,-6,39,45,22,28,36,51,64,76,98,123,127,127,127,81,18,-44,-96,-128,-128,-128,-128,-62,-20,
13,33,32,56,53,56,33,24,23,19,-12,0,99,96,68,-2,-76,-96,-54,-15,-17,70,115,57,-66,-101,-74,-30,92,123,
55,-11,10,28,-14,13,23,48,62,70,101,112,107,107,97,32,-24,-45,-91,-108,-87,-116,-128,-94,-20,33,54,43,42,94,
78,61,40,19,-3,-23,-35,-43,-30,10,79,114,86,32,-2,-18,7,93,127,48,-105,-128,-128,-58,53,55,12,2,21,18,
-12,-2,-18,17,47,67,87,71,30,0,-28,-62,-86,-65,-35,-9,-8,-66,-91,-41,16,46,49,32,42,98,84,55,29,23,
20,5,-17,-33,-25,-9,24,79,126,124,74,26,-12,29,42,-27,-109,-109,-128,-82,2,13,-1,25,18,-2,-16,-27,-28,22,
75,92,72,16,-43,-78,-92,-97,-103,-43,47,63,7,-64,-77,-40,-13,11,28,14,23,70,60,37,25,25,15,-5,-36,-58,
-81,-62,-31,9,38,41,14,-18,-45,11,50,53,43,53,12,45,5,30,11,12,-8,-25,-43,-69,-12,48,104,102,62,9,
-32,-60,-65,-67,-73,10,108,52,-24,-66,-1,-12,-40,-23,16,20,28,60,64,29,14,12,-1,-22,-52,-77,-75,-63,-46,-28,
-23,-16,-7,-11,18,37,41,62,86,100,46,42,35,37,-20,-32,-25,-36,-58,-64,25,79,115,90,36,-8,-31,-45,-56,-62,
-65,33,86,-38,-61,-15,17,-13,-59,-48,0,27,43,57,53,4,-14,-6,-5,-11,-36,-61,-72,-46,-39,-46,-42,-21,1,5,
10,36,39,44,52,73,41,23,44,8,-52,-34,-29,-71,-72,-8,65,92,100,57,2,-42,-60,-67,-51,-70,-75,22,21,-128,
-105,-23,-18,-32,-52,-42,-13,17,42,51,30,-18,-24,-1,17,25,3,-24,-25,20,12,-27,-39,-34,-32,-34,-54,-38,-36,-18,
13,55,29,1,33,-16,-52,-50,-57,-75,-47,10,68,82,67,26,-12,-58,-81,-72,-63,-68,-77,-17,-41,-128,-117,-54,-36,-38,
-62,-29,2,7,45,78,3,-16,6,58,63,54,31,9,22,38,30,2,-7,-13,-29,-45,-51,-89,-101,-70,-32,22,8,-26,
13,-22,-54,-61,-61,-57,-27,9,42,47,34,9,-20,-66,-84,-67,-51,-39,-81,-64,-61,-128,-74,-62,-39,-47,-70,-26,20,20,
50,91,13,0,31,63,47,30,22,27,52,63,33,-3,1,8,-1,-24,-89,-112,-108,-67,-29,12,0,-10,-6,-39,-48,-51,
-48,-41,-24,8,22,26,17,8,-10,-57,-83,-83,-46,-44,-98,-101,-46,-58,-38,3,22,-22,-58,-22,24,59,84,83,28,17,
32,47,61,39,8,26,76,124,77,17,-7,3,17,-16,-75,-128,-128,-74,-48,4,-5,-16,-15,-33,-27,-33,-42,-41,-24,10,
25,29,16,5,-14,-60,-84,-82,-55,-38,-91,-99,-33,-21,-7,46,75,20,-32,-5,48,86,95,81,6,-40,-28,22,80,83,
11,-39,28,127,125,52,17,11,17,-11,-61,-124,-128,-98,-58,8,1,-6,-15,-22,-8,-23,-41,-43,-23,16,45,48,26,6,
-16,-60,-82,-78,-81,-58,-107,-110,-31,1,1,73,53,25,14,56,93,94,82,58,-11,-57,-25,56,127,127,24,-99,-12,127,
127,102,58,36,29,9,-29,-104,-128,-128,-81,8,6,-2,-5,-9,1,-16,-34,-34,-6,39,76,76,44,11,-15,-57,-77,-73,
-70,-66,-119,-128,-54,-1,-19,32,50,68,93,123,115,97,73,35,-42,-83,-41,71,127,127,25,-128,-33,127,127,125,93,76,
57,30,6,-75,-128,-128,-113,-3,8,3,-3,-9,-7,-15,-15,-1,31,78,114,104,67,27,-8,-54,-73,-73,-69,-90,-128,-128,
-76,14,-6,-8,62,93,117,123,95,75,53,7,-89,-128,-103,56,127,127,29,-128,-83,127,127,107,115,127,105,56,24,-54,
-128,-128,-128,-12,13,12,-2,-14,-17,-14,13,40,76,117,127,121,78,34,-8,-56,-77,-79,-72,-108,-128,-128,-79,32,26,9,
51,97,114,105,83,70,41,-21,-99,-128,-108,57,127,127,24,-128,-128,104,127,76,127,127,127,76,18,-54,-128,-128,-128,-24,
11,14,2,-15,-26,-20,43,84,118,127,127,122,69,30,-7,-60,-81,-82,-75,-128,-128,-107,-44,29,4,35,77,110,105,82,
67,61,47,10,-70,-107,-94,31,127,127,42,-128,-128,113,127,34,125,127,127,87,14,-70,-128,-128,-128,-38,-5,9,3,-14,
-26,-21,44,86,120,127,127,119,65,26,-10,-64,-85,-84,-76,-128,-128,-110,-46,28,5,40,74,107,96,69,54,51,40,5,
-73,-110,-96,29,127,127,46,-128,-128,112,127,27,123,127,127,83,13,-71,-128,-128,-128,-39,-6,8,-2,-13,-18,-16,5,31,
68,110,126,109,66,20,-23,-70,-91,-88,-82,-117,-128,-128,-86,31,35,17,50,97,108,96,74,59,29,-28,-110,-128,-111,45,
127,127,16,-128,-128,94,127,66,124,127,127,70,13,-56,-128,-128,-128,-27,8,10,-3,-8,-8,-20,-27,-15,16,64,97,85,
48,7,-29,-73,-90,-85,-79,-108,-128,-128,-81,14,7,6,66,97,120,127,96,65,43,6,-94,-128,-98,40,127,127,19,-128,
-91,127,127,92,109,127,98,57,19,-56,-128,-128,-128,-18,8,6,-6,-5,2,-21,-51,-53,-30,18,55,52,21,-13,-40,-79,
-95,-87,-80,-86,-126,-119,-52,5,-5,42,56,64,88,127,115,81,58,33,-35,-68,-36,50,127,127,9,-128,-48,127,127,109,
86,67,50,32,8,-72,-128,-128,-114,-9,2,-1,-15,-14,-1,-23,-54,-62,-49,-8,25,26,5,-16,-40,-81,-99,-90,-89,-73,
-103,-93,-27,6,8,80,60,18,-1,47,84,84,75,60,-9,-53,-32,27,93,118,7,-108,-27,127,127,90,52,24,22,8,
-17,-90,-128,-120,-81,1,2,-2,-15,-24,-15,-28,-49,-56,-50,-18,2,8,-2,-15,-36,-80,-101,-93,-72,-57,-85,-76,-23,-14,
-6,51,85,25,-37,-16,34,73,86,75,2,-44,-39,-3,46,63,4,-43,19,127,118,44,10,-1,13,-7,-43,-104,-127,-86,
-61,-2,-3,-3,-6,-29,-35,-42,-51,-54,-50,-21,-8,3,-2,-13,-33,-78,-102,-97,-64,-64,-88,-71,-29,-45,-31,13,33,-5,
-47,-21,18,48,75,78,28,12,20,29,36,25,7,23,67,115,71,7,-14,-7,17,-2,-54,-105,-112,-65,-52,-5,-6,-11,
19,-14,-46,-54,-58,-67,-55,-22,10,22,14,-10,-39,-82,-102,-86,-68,-64,-73,-38,-48,-120,-69,-43,-24,-34,-63,-23,14,11,
42,81,8,-3,19,50,35,21,19,25,43,54,27,-11,-7,6,10,-4,-59,-89,-91,-52,-31,9,4,-6,47,-3,-49,-49,
-55,-80,-71,-22,39,56,44,6,-29,-72,-96,-88,-77,-86,-64,-2,-49,-128,-115,-50,-37,-41,-67,-29,-1,-4,35,72,-6,-22,
-11,43,49,40,20,-2,6,16,15,-9,-8,-1,-7,-22,-31,-72,-84,-51,-27,23,15,-18,66,29,-46,-28,-28,-77,-95,-39,
34,66,78,36,-20,-60,-75,-85,-65,-80,-61,28,-1,-128,-110,-34,-29,-47,-59,-48,-24,2,27,44,18,-36,-48,-22,0,11,
-9,-39,-50,-9,-13,-38,-33,-16,-8,-10,-32,-9,-11,7,32,67,39,15,64,63,-7,-27,-32,-38,-70,-102,-9,47,89,70,
14,-31,-51,-63,-73,-73,-52,41,61,-60,-75,-18,18,-22,-67,-59,-16,8,25,48,40,-17,-40,-27,-18,-19,-43,-71,-92,-74,
-60,-47,-31,-4,21,25,43,78,81,86,88,93,41,19,34,59,26,20,-10,-25,-54,-100,-49,12,75,81,40,-11,-46,-66,
-71,-75,-69,20,101,41,-41,-72,12,-10,-45,-36,0,6,16,51,58,19,-4,-7,-13,-24,-49,-74,-72,-68,-50,-23,-10,6,
23,17,55,88,97,108,109,99,24,26,35,55,19,29,18,2,-23,-38,-60,-17,35,57,47,8,-37,-65,-79,-97,-105,-36,
60,80,8,-78,-70,-35,-16,-2,15,9,20,65,51,33,21,20,15,5,-18,-38,-75,-57,-21,22,49,54,30,-7,-29,37,
82,74,54,57,3,40,73,93,43,18,21,16,-21,-3,-33,-16,2,23,52,55,33,9,-9,-48,-74,-47,-9,29,19,-54,
-83,-31,18,40,45,32,40,90,83,58,35,29,31,20,-3,-22,-19,-3,33,96,127,127,113,56,19,55,63,-15,-95,-79,
-104,-61,73,127,86,27,18,21,-23,15,24,33,32,32,60,81,89,95,93,40,-9,-25,-66,-69,-47,-76,-96,-59,5,50,
68,52,42,87,86,75,57,32,10,-5,-18,-29,-19,24,91,123,96,47,25,17,45,121,127,66,-84,-94,-96,-40,-12,94,
113,52,17,46,33,20,38,46,50,47,49,68,94,112,125,109,70,24,-32,-73,-108,-123,-128,-100,-21,25,55,63,50,74,
74,72,45,31,33,43,24,23,102,96,61,-13,-85,-90,-36,6,2,92,127,98,-30,-72,-63,-22,-44,-15,67,126,78,27,
-3,-14,11,27,41,45,49,65,90,107,127,118,97,86,76,61,24,7,-9,-16,-28,-69,-82,-80,-82,-41,66,103,116,108,
103,111,84,78,44,-5,-59,-98,-97,-69,-58,-64,-38,18,77,102,0,-91,-116,-44,-43,-55,-58,35,56,36,5,-38,-37,-39,
-28,16,13,-15,15,27,35,47,72,96,111,115,90,45,11,-9,-40,-74,-109,-128,-128,-82,73,127,127,127,127,111,42,22,
-6,-33,-36,-53,-97,-128,-128,-80,-31,36,45,53,32,-51,-128,-94,-44,-71,-112,-85,-72,-22,29,9,-45,-94,-114,-89,-79,-92,
-88,-111,-88,-90,-91,-90,-92,-86,-81,-96,-128,-110,-95,-88,-78,-72,-54,-6,127,127,127,127,127,75,10,5,-21,-63,-110,-128,
-128,-128,-128,-48,-12,53,69,28,9,-40,-116,-96,-34,-43,-77,-91,-128,-93,-17,76,72,45,-21,-98,-128,-128,-128,-128,-128,-128,
-128,-128,-128,-128,-125,-97,-102,-95,-102,-102,-58,-8,46,96,110,127,127,96,63,32,1,-7,-54,-71,-118,-128,-128,-95,-48,-14,
60,105,127,87,34,-1,-81,-104,-30,-56,-95,-118,-128,-128,-91,-3,66,121,127,127,51,-27,-60,-94,-100,-97,-75,-62,-101,-128,
-123,-86,-36,-1,36,62,63,41,29,48,42,43,40,34,48,38,11,1,-20,-37,-44,-21,0,-1,8,28,60,96,127,127,
47,31,-49,-112,-60,-101,-120,-113,-127,-118,-97,-57,-28,21,93,127,127,127,127,89,51,32,33,37,22,2,-15,-35,-89,-86,
-60,-38,-46,-54,-41,-20,-17,-15,-4,31,86,122,127,127,99,73,63,63,61,35,32,51,104,125,127,127,127,103,37,-7,
-37,-60,-68,-70,-72,-66,-53,-31,-12,-10,13,47,80,94,97,92,75,48,43,42,16,-3,-7,-17,-43,-62,-64,-66,-78,-70,
-45,-27,-27,-24,-11,20,57,71,81,85,58,51,56,46,42,40,45,64,72,76,64,127,122,81,27,-10,9,12,65,62,
44,68,68,75,95,100,99,92,93,111,118,86,89,86,77,70,76,71,71,64,62,24,-5,-6,5,5,5,18,15,23,
21,6,19,50,56,46,24,12,10,21,39,19,3,13,25,66,80,127,127,127,127,97,48,47,94,84,61,53,56,73,
90,80,63,67,85,105,101,47,41,49,47,32,48,91,112,70,9,-32,-65,-75,-63,-60,-60,-43,-39,-35,-35,-25,-17,-9,
1,-7,20,-13,-31,-18,-1,-22,-41,-36,-4,57,99,127,127,127,127,127,22,57,72,26,-1,20,10,19,43,25,-16,-76,
-125,-128,-105,-117,-50,-60,-46,-28,-20,3,29,-5,-49,-53,-60,-66,-61,-63,-81,-85,-100,-86,-70,-40,-36,-43,-29,-21,-18,-32,
-44,-38,-32,-56,-69,-62,-14,51,68,64,108,127,127,127,-12,13,-1,-32,-16,19,-3,-13,-7,-49,-114,-128,-128,-128,-116,-113,
-120,-128,-120,-76,-42,1,54,41,91,66,22,-21,-46,-74,-108,-113,-97,-85,-75,-18,25,17,0,-29,-5,-2,-18,-39,-62,-79,
-72,-42,-28,37,-4,-42,-25,26,120,73,15,-13,-36,-24,5,-24,-88,-90,-89,-104,-91,-78,-56,-45,-55,-62,-44,-37,-32,-4,
27,71,108,105,127,127,127,112,81,51,15,-5,-34,-60,-91,-47,28,49,-5,-69,-55,-24,-7,-4,-24,-52,-64,-44,-1,80,
43,8,-10,-3,115,100,8,3,9,-18,-43,-76,-115,-94,-52,-46,-4,36,65,72,66,66,43,68,44,2,-22,-18,-2,16,
104,127,127,127,91,79,77,63,4,-23,-46,-17,80,127,119,63,-12,22,31,34,19,7,-29,-48,45,108,10,-51,-54,-18,
70,62,25,-4,-39,-70,-50,-7,48,69,88,89,72,61,79,94,87,75,55,71,58,30,22,6,-10,5,14,38,37,19,
17,44,63,47,55,18,10,24,74,127,127,127,107,109,82,7,-37,-27,-16,-7,29,39,-79,-118,-41,-21,34,89,36,-41,
-59,-25,58,127,127,89,72,61,41,38,56,69,65,62,47,40,13,-14,-4,-29,-86,-92,-94,-103,-126,-120,-89,-45,2,17,
49,16,39,66,89,107,55,25,78,55,45,20,-15,-19,7,38,46,16,-60,-72,-23,-62,-22,33,-14,-57,-4,107,127,127,
97,19,4,24,31,31,42,44,23,12,14,-18,-59,-52,-22,-69,-128,-128,-52,-88,-88,-82,-73,-47,-25,0,23,41,60,75,
88,74,35,1,-23,-10,-22,-50,-45,-29,-18,3,39,-25,-80,-99,-112,-112,-79,-38,-29,-17,85,127,127,92,23,-19,37,62,
74,54,22,-8,-23,-20,-8,-15,-44,-48,-31,-64,-90,-46,45,18,3,-15,-20,0,16,42,66,82,87,89,96,92,79,74,
100,72,-7,-79,-86,-67,-82,-87,-123,-128,-128,-128,-128,-88,-64,-54,-51,36,127,127,76,-29,-29,18,71,67,53,24,-15,-38,
-48,-46,-36,-48,-73,-95,-91,-102,-66,17,111,117,98,59,40,21,1,5,35,47,48,47,51,44,44,57,76,101,112,68,
-3,-43,-46,-15,-114,-128,-127,-115,-95,-59,-49,-33,8,106,127,106,-22,-54,-8,33,32,7,-1,0,-9,-21,-34,-46,-56,-80,
-85,-99,-95,-86,-25,40,98,127,113,83,81,60,10,-14,-23,1,19,26,34,17,-9,-13,22,49,100,95,45,26,34,49,
27,-21,-58,-88,-110,-107,-93,-29,83,127,125,19,-50,-18,15,4,-14,-33,-27,-10,-12,-14,-21,-35,-63,-66,-36,-62,-71,-32,
59,115,121,127,123,103,85,72,12,-45,-45,-19,-8,-4,19,31,13,-11,-42,-33,18,40,36,55,65,69,60,45,6,-43,
-95,-128,-128,-68,95,105,28,-21,-19,-2,-1,0,-31,-28,-7,1,-17,-18,-21,-37,-59,-46,-7,-66,-75,3,119,127,127,102,
107,107,77,64,6,-84,-61,-36,-26,-15,13,40,24,-15,-88,-87,-55,-37,-15,31,60,99,127,127,77,-7,-84,-128,-128,-70,
81,47,-33,-17,-13,-19,-8,-21,-39,-29,-4,4,-6,0,-4,-21,-43,-60,8,-61,-41,59,126,127,94,14,28,66,44,35,
4,-69,-34,-30,-21,-10,10,61,70,36,-105,-100,-66,-52,-54,-59,-30,45,127,127,127,65,-57,-128,-128,-117,48,22,-50,-25,
-15,-22,-21,-37,-22,-20,-4,3,2,21,21,0,-42,-59,-1,-42,10,99,127,122,36,-37,-20,23,22,30,13,-26,22,6,
1,0,28,81,101,68,-25,-38,-13,-24,-68,-101,-94,-39,82,127,127,117,-10,-120,-128,-128,19,-18,-68,-50,-42,-52,-60,-45,
-15,-14,-3,15,22,37,35,23,-11,-28,-15,-47,10,99,127,105,12,-43,-51,-13,33,47,27,50,98,92,56,24,40,42,
93,127,54,3,7,6,-30,-102,-128,-128,-26,127,127,127,45,-96,-128,-128,-6,-37,-80,-62,-58,-67,-69,-40,-7,0,15,30,
34,51,54,43,-11,-42,-31,-24,31,85,127,85,41,-14,-41,-24,32,57,40,88,127,127,88,38,4,-21,37,127,55,13,
33,43,9,-66,-128,-128,-112,70,127,127,84,-55,-128,-128,-16,-41,-81,-70,-71,-82,-79,-34,0,15,32,38,38,60,66,55,
23,-45,-51,-26,5,10,76,91,86,6,-35,-20,23,32,28,96,122,92,86,58,-19,-65,-28,62,18,10,59,80,58,-19,
-128,-128,-128,-7,127,127,101,-33,-128,-112,-10,-33,-75,-71,-76,-90,-90,-37,15,34,45,41,40,68,76,61,33,-43,-48,-12,
-4,-53,-29,48,72,-34,-79,-51,-14,5,16,69,65,50,85,92,-6,-58,-50,-20,-70,-35,43,90,100,28,-104,-128,-128,-59,
105,127,100,-36,-128,-106,-7,-30,-71,-75,-80,-95,-94,-31,42,66,70,52,46,75,84,65,37,-24,-32,-1,10,-56,-116,-68,
-49,-110,-106,-52,-29,-24,5,68,24,9,54,77,-13,-60,-62,-101,-128,-91,7,78,120,57,-82,-128,-128,-93,79,127,116,-32,
-128,-96,-11,-39,-78,-78,-76,-83,-76,-5,77,102,102,70,52,77,85,66,34,-9,-37,-33,-2,-33,-126,-116,-105,-99,-84,-52,
-30,-32,-28,6,-27,-59,-40,-2,-65,-102,-106,-128,-128,-128,-28,63,123,68,-70,-128,-128,-123,57,127,123,-33,-128,-99,-27,-61,
-104,-81,-70,-53,-38,21,101,121,121,89,50,60,69,62,21,-16,-21,-20,7,-32,-125,-76,-60,-54,-56,-41,-28,-37,-45,-22,
-54,-88,-119,-16,-50,-99,-115,-128,-128,-128,-32,57,126,89,-59,-128,-128,-128,56,127,114,-48,-128,-98,-29,-64,-106,-77,-62,-43,
-29,27,107,125,124,91,50,60,68,62,19,-19,-25,-22,7,-31,-125,-76,-65,-58,-60,-49,-38,-47,-48,-18,-59,-96,-128,-21,
-46,-95,-116,-128,-128,-128,-31,54,120,87,-57,-128,-128,-128,54,127,105,-56,-128,-99,-11,-44,-79,-72,-58,-62,-59,7,89,111,
107,72,56,81,89,65,24,-9,-45,-40,-2,-17,-109,-121,-123,-114,-102,-66,-37,-43,-41,-2,-40,-91,-74,-37,-77,-109,-115,-128,
-128,-128,-35,50,101,50,-72,-128,-128,-128,37,127,97,-58,-128,-109,-5,-42,-83,-80,-68,-76,-75,-19,51,72,73,53,49,78,
85,61,28,-28,-54,-26,-4,-43,-93,-68,-66,-116,-115,-67,-39,-35,-11,50,10,-24,12,39,-31,-65,-67,-108,-128,-105,-2,66,
101,40,-88,-128,-128,-114,48,127,77,-65,-128,-108,-10,-52,-100,-89,-77,-80,-76,-32,16,32,40,36,39,67,71,53,22,-54,
-77,-38,-13,-34,-6,41,49,-37,-73,-51,-10,8,5,48,38,10,41,57,-23,-54,-47,-31,-80,-46,33,76,82,12,-113,-128,
-128,-86,65,126,52,-73,-128,-116,-23,-67,-114,-98,-82,-80,-70,-34,-3,9,22,27,31,54,57,42,7,-63,-81,-49,-4,16,
80,73,64,6,-29,-24,21,36,18,72,85,48,52,40,-21,-48,-15,50,10,-1,48,65,43,-29,-128,-128,-128,-37,100,127,
50,-67,-128,-120,-18,-64,-114,-95,-75,-69,-62,-40,-7,-1,8,17,24,41,42,27,-26,-63,-60,-49,8,67,127,69,28,-8,
-25,-19,27,48,29,78,127,98,77,38,14,3,58,127,52,9,34,38,3,-70,-128,-128,-128,34,127,119,35,-84,-128,-128,
9,-38,-98,-84,-63,-54,-49,-40,-12,-10,-5,4,10,22,20,4,-30,-50,-34,-67,-17,75,127,97,6,-36,-34,-2,33,43,
23,47,92,85,69,40,58,70,120,127,55,10,20,12,-30,-102,-128,-128,-52,101,127,92,-1,-119,-128,-128,39,2,-78,-66,
-43,-27,-11,-24,-17,-13,-2,-3,-9,3,1,-20,-54,-75,-16,-68,-28,74,127,114,33,-28,-12,29,29,27,1,-34,17,14,
26,28,55,102,121,92,-8,-19,0,-19,-64,-105,-109,-63,48,127,126,56,-48,-128,-128,-128,61,22,-65,-62,-43,-22,6,-2,
-28,-15,3,3,-12,-12,-19,-35,-52,-77,-11,-96,-83,33,109,110,79,14,23,62,47,26,-11,-66,-24,-12,3,14,29,77,
83,52,-78,-70,-45,-49,-61,-78,-55,13,90,127,96,7,-90,-128,-128,-119,64,72,-3,-66,-53,-18,4,25,-2,2,14,10,
-17,-27,-36,-57,-74,-54,-26,-95,-114,-31,103,127,124,101,94,89,68,42,-18,-83,-54,-20,-5,6,36,57,31,-9,-59,-58,
-37,-39,-33,7,35,69,99,83,14,-60,-110,-128,-128,-72,50,108,92,-13,-87,-45,18,25,24,7,4,8,-2,-12,-28,-51,
-75,-74,-46,-72,-91,-59,47,109,115,123,105,82,69,45,-12,-50,-40,-9,7,11,31,41,22,3,-27,-18,22,31,23,40,
46,45,13,-15,-58,-96,-124,-128,-128,-67,-10,59,118,77,-42,-76,-15,49,70,51,37,30,19,-1,-27,-48,-67,-91,-94,-99,
-97,-96,-28,44,104,123,95,65,66,43,-2,-21,-23,6,30,40,43,20,-4,-6,30,57,105,102,55,29,24,27,-9,-66,
-100,-117,-124,-109,-89,-13,-57,1,87,127,52,-46,-44,20,89,98,87,58,22,-6,-23,-23,-27,-41,-69,-88,-78,-91,-51,36,
115,122,94,54,38,18,2,0,40,54,61,61,58,47,53,67,82,111,127,100,34,-19,-43,-29,-128,-128,-128,-127,-94,-52,
-46,-22,-29,-33,32,111,111,63,8,-37,35,74,95,85,58,22,3,9,19,12,-20,-29,-6,-37,-52,5,62,39,16,-8,
-14,2,25,44,73,89,99,100,99,99,100,94,127,106,36,-35,-58,-57,-89,-111,-128,-128,-128,-128,-123,-74,-76,-64,8,-40,
-31,40,89,112,65,-11,-5,19,29,40,64,63,39,33,48,21,-11,-10,17,-30,-79,-59,-10,-45,-56,-54,-51,-28,5,27,
49,64,85,96,98,98,85,56,36,41,14,-46,-79,-76,-59,-38,14,-41,-90,-105,-110,-117,-97,-41,57,4,-42,-50,2,58,
81,38,44,41,16,11,40,61,61,67,60,67,63,37,31,-3,-40,-35,-49,-62,-83,-79,-60,-17,37,50,100,61,74,105,
127,127,127,95,118,61,19,-29,-74,-76,-38,10,24,3,-68,-75,-38,-83,-43,38,45,52,16,-37,-45,-29,8,8,29,60,
56,31,38,49,47,47,42,73,84,56,45,38,33,34,57,89,98,84,79,109,127,120,118,62,43,69,126,127,127,127,
99,82,45,-40,-86,-63,-40,-25,17,24,-94,-123,-62,-57,8,86,18,26,46,33,18,-3,-70,-88,-93,-79,-26,14,37,33,
18,18,14,53,53,24,-2,4,25,36,125,127,127,127,127,120,116,100,55,10,-23,10,109,127,118,31,-46,-23,-9,5,
-15,-25,-59,-79,28,100,3,-49,-69,-41,66,75,21,-2,-20,-10,37,54,7,-4,-53,-84,-87,-93,-79,-69,-87,-97,-62,-53,
-39,-6,26,70,107,101,123,127,127,91,58,29,8,6,-14,-43,-57,-8,51,53,-13,-90,-88,-56,-27,-18,-50,-77,-83,-62,
-12,83,49,29,-2,-5,121,122,-24,6,-4,-35,-20,42,52,64,68,11,-73,-128,-128,-128,-127,-128,-128,-128,-128,-113,-80,-30,
33,31,75,65,20,-21,-39,-57,-79,-78,-85,-82,-56,8,26,-5,-40,-76,-58,-52,-60,-72,-93,-108,-102,-80,-64,17,-11,-21,
7,63,127,98,24,52,60,8,-24,10,17,33,82,71,25,-43,-102,-116,-99,-126,-81,-99,-101,-87,-64,-22,18,0,-30,-32,
-36,-36,-31,-31,-46,-61,-91,-87,-67,-36,-42,-54,-45,-44,-44,-53,-60,-50,-49,-86,-110,-114,-70,3,37,78,127,127,127,127,
42,29,64,45,15,17,31,56,79,72,58,59,73,93,96,35,20,20,11,0,22,76,115,90,34,-21,-68,-82,-67,-66,
-70,-70,-63,-57,-51,-36,-28,-17,-13,-28,1,-19,-32,-20,-3,-30,-57,-67,-37,27,85,127,127,127,127,127,-7,-7,31,24,
4,25,26,37,58,61,61,60,62,82,100,67,78,82,82,83,83,71,74,74,74,20,-23,-29,-22,-20,-19,-12,-8,5,
8,-4,12,46,53,39,24,17,14,27,50,28,9,10,26,61,88,127,127,127,127,105,-45,5,-1,-3,18,-11,-24,-41,
-15,-30,-29,-14,-5,-6,-8,14,20,27,32,33,24,10,3,3,5,19,32,37,24,23,28,14,14,-14,-21,-35,-50,-60,
-65,-51,-55,-66,-74,-76,-68,-68,-80,-76,-49,-1,-7,-4,5,2,19,29,10,-3,-22,-20,-8,-62,-53,-50,-95,-104,-117,-125,
-120,-89,-62,-22,-27,-39,-54,-61,-64,-60,-34,-6,12,44,56,51,31,1,-11,-16,-20,-26,-18,-14,-11,-8,-10,-8,-11,-28,
-53,-71,-88,-102,-113,-96,-62,-12,-6,-11,-20,4,38,69,-20,-41,-74,-65,-57,-82,-94,-111,-118,-106,-83,-57,-16,6,-6,-4,
0,-9,-12,-5,21,45,30,-13,-18,-8,-30,-34,-27,-51,-70,-76,-91,-96,-109,-118,-90,-50,-39,-54,-40,-30,-35,-48,-61,-78,
-86,-62,-15,21,34,19,0,27,40,65,-14,-27,-51,-24,-7,-17,-24,-45,41,99,127,127,118,111,89,77,54,53,76,107,
121,107,72,-6,-62,-87,-118,-90,-43,-41,-74,-105,-92,-54,-58,-75,-90,-67,-23,5,-2,21,32,7,-31,-76,-85,-43,42,77,
83,12,-35,21,83,69,13,-6,-6,43,46,-2,49,108,92,119,110,57,12,-15,-56,-95,-67,-54,-15,15,12,29,68,50,
-51,-64,-95,-105,-96,-99,-125,-128,-101,2,41,15,-30,-41,-8,43,56,71,78,67,27,-20,-3,48,77,91,60,-42,-75,35,
95,27,29,16,20,70,85,64,92,111,81,82,52,-13,-57,-66,-96,-126,-128,-128,-128,-128,-128,-128,-67,-44,-67,-41,-65,-112,
-128,-128,-128,-128,-128,-60,13,66,64,6,24,95,96,44,-8,9,53,80,102,101,100,104,64,-15,0,85,82,25,16,59,
63,61,96,94,84,34,-14,0,19,11,-27,-75,-128,-128,-128,-128,-128,-128,-128,-128,-68,-70,-95,-38,-7,-21,-54,-66,-68,-85,
-128,-128,-128,-93,6,50,50,95,99,68,19,17,47,84,127,127,106,102,22,-51,6,35,32,9,49,59,59,51,33,-11,
24,47,39,19,-3,-38,-89,-128,-128,-128,-128,-125,-91,-81,-81,-39,31,39,32,60,79,74,41,-10,-65,-114,-106,-87,-128,-128,
-115,-8,21,41,36,50,53,73,83,75,71,70,82,116,79,23,52,73,56,54,65,57,16,-65,-41,-8,60,113,95,41,
-23,-62,-71,-70,-68,-66,-42,-16,18,19,29,109,127,102,102,114,116,102,70,33,-11,-60,-83,-58,-50,-89,-108,-62,-14,-5,
-7,17,25,23,22,-11,-4,41,111,115,41,14,24,11,37,54,21,-47,-90,-112,-34,38,107,125,67,20,-31,-53,-42,-17,
10,26,35,50,50,15,-8,40,50,39,69,71,68,72,55,19,-13,-36,-59,-37,-7,-4,-13,-10,-8,-12,-23,-5,-24,-74,
-107,-122,-86,-33,-19,-6,-9,8,26,30,52,42,-16,-128,-128,-89,2,73,119,90,50,26,-4,-19,-6,24,63,95,106,88,
35,-25,-39,33,57,24,41,30,18,30,33,5,-22,-54,-74,-57,-2,55,67,32,-14,-35,16,68,69,7,-41,-74,-88,-93,
-66,-70,-60,-48,-5,55,85,53,-54,-128,-121,-50,51,102,110,57,52,39,5,-20,-2,45,100,127,125,109,35,-50,-65,32,
68,3,-17,-2,10,25,6,-8,-21,-62,-80,-52,23,93,102,39,-36,-65,-12,59,116,127,127,92,30,-17,-47,-62,-52,-57,
-11,69,105,76,-76,-128,-78,-18,76,101,89,67,62,46,10,-5,24,71,118,127,127,115,16,-90,-97,0,-3,-80,-102,-53,
25,67,25,-7,-18,-73,-80,-38,57,127,127,106,14,-48,-41,0,45,87,127,127,88,27,-8,-39,-37,-44,8,89,114,88,
-77,-76,-11,10,75,87,72,68,70,50,25,32,70,97,121,127,127,106,3,-105,-103,-22,-27,-36,-45,-16,56,93,22,-39,
-44,-77,-101,-44,81,127,127,127,53,-52,-65,-32,1,15,51,91,105,85,32,-20,-53,-68,-5,91,127,118,-65,-39,24,28,
50,51,57,58,53,49,48,54,65,79,99,113,127,101,-9,-113,-100,-36,-67,-50,-47,-12,91,100,-2,-80,-76,-46,-76,8,
127,127,127,127,93,-35,-63,-48,-3,26,11,16,50,60,33,-37,-81,-102,-77,33,127,85,-36,-14,37,30,42,37,38,28,
48,58,74,84,79,69,66,63,109,64,-19,-86,-73,-53,-118,-91,-71,-32,83,117,13,-84,-73,-23,23,66,127,127,127,127,
127,60,-51,-58,-32,3,-4,-8,36,73,55,-7,-71,-123,-118,-3,103,47,-15,15,39,22,0,4,4,0,3,35,56,68,
66,42,29,47,76,37,-29,-77,-69,-72,-99,-54,-38,80,127,107,21,-48,1,64,95,103,127,127,127,127,127,120,45,-9,
-57,-46,-24,-25,5,36,75,39,-28,-128,-128,-34,86,48,3,20,29,10,-6,-11,-26,-40,-27,5,26,39,45,25,9,24,
57,47,7,-56,-84,-67,-37,25,32,124,127,111,32,4,66,105,105,117,127,127,88,116,127,37,5,22,-29,-81,-72,-55,
-22,14,65,46,-17,-128,-128,-58,74,45,26,30,27,11,-4,-18,-53,-91,-67,-27,-5,10,24,12,-1,9,36,54,47,-27,
-83,-25,41,51,65,127,127,95,41,56,109,108,65,64,110,119,14,40,82,-107,-112,13,-5,-115,-126,-91,-47,-5,35,31,
-24,-128,-128,-80,60,45,38,39,33,17,-2,-23,-74,-128,-112,-57,-24,-8,11,1,-15,-7,11,35,47,-28,-84,12,93,61,
66,122,127,76,30,45,48,12,-8,-55,5,45,-27,17,6,-128,-128,-21,22,-115,-128,-103,-50,-7,13,13,-33,-128,-128,-97,
48,44,39,43,36,14,-12,-39,-97,-128,-128,-85,-31,1,17,0,-19,-10,8,29,36,-24,-75,17,103,94,79,110,100,39,
16,26,17,-7,-99,-128,-41,21,-26,30,-25,-128,-128,-92,-1,-128,-128,-128,-63,-24,-1,-2,-46,-128,-128,-114,36,37,35,36,
29,5,-31,-65,-128,-128,-128,-107,-31,20,35,12,-7,6,22,23,24,-26,-81,-5,73,69,66,83,50,-19,-38,-29,-37,-64,
-128,-128,-43,24,-35,14,-40,-128,-128,-128,-75,-128,-128,-128,-70,-40,-9,-17,-62,-128,-128,-121,36,38,36,17,25,10,-37,-79,
-128,-128,-128,-128,-40,17,34,10,-1,27,31,23,14,-8,-68,-17,75,-26,-57,-67,-76,-95,-116,-109,-117,-128,-128,-128,-128,16,
-9,9,-51,-128,-128,-128,-128,-128,-128,-128,-65,-14,4,-3,-66,-128,-128,-115,42,46,38,18,27,13,-34,-78,-128,-128,-128,-128,
-44,13,29,4,-4,28,39,31,19,-10,-81,-33,54,-56,-75,-75,-71,-89,-122,-121,-124,-128,-128,-128,-128,12,-10,9,-49,-128,
-128,-128,-128,-128,-128,-128,-57,-4,6,-3,-69,-128,-128,-112,45,46,38,48,36,11,-23,-65,-128,-128,-128,-117,-37,13,24,0,
-13,5,31,26,25,-40,-111,-36,24,26,37,72,59,-5,-40,-53,-65,-87,-128,-128,-17,33,-35,18,-39,-128,-128,-128,-83,-128,
-128,-123,-52,-28,-4,-24,-72,-128,-128,-116,44,40,39,54,45,21,-9,-46,-108,-128,-128,-96,-40,-10,-2,-17,-26,-13,17,30,
33,-38,-110,-27,45,42,37,74,83,37,14,12,2,-21,-108,-128,-14,39,-13,36,-36,-128,-128,-97,-20,-128,-128,-100,-45,-13,
5,-9,-57,-128,-128,-106,49,46,39,50,42,23,-2,-35,-86,-128,-124,-72,-38,-27,-17,-24,-27,-12,15,33,37,-43,-121,-44,
32,19,44,97,117,62,27,45,43,-1,-20,-54,24,64,-9,26,-4,-128,-128,-29,5,-116,-128,-76,-35,1,8,-1,-49,-128,
-128,-88,62,53,30,40,34,17,-3,-30,-66,-102,-87,-52,-29,-18,-12,-19,-18,2,31,45,33,-38,-109,-71,-11,11,28,105,
127,81,37,60,107,95,60,69,127,127,29,45,71,-124,-120,7,-13,-112,-106,-64,-34,4,15,9,-41,-128,-128,-71,70,50,
8,25,29,15,-2,-22,-41,-57,-53,-29,-9,3,7,-8,-9,17,52,36,-10,-66,-97,-90,-71,-13,1,104,127,108,42,18,
79,117,120,127,127,127,98,111,127,22,-8,19,-33,-83,-60,-33,-13,12,37,23,-32,-128,-128,-50,83,49,-13,13,35,26,
7,-5,-16,-25,-21,-2,15,29,30,15,14,41,73,31,-40,-75,-62,-65,-105,-73,-43,68,127,111,34,-37,10,80,120,123,
127,127,127,127,127,117,34,-9,-57,-48,-17,-11,1,12,41,10,-45,-128,-128,-24,97,57,-32,-15,32,37,40,24,16,3,
18,19,28,40,44,45,56,65,101,58,-26,-73,-49,-26,-97,-90,-77,-24,91,117,22,-73,-62,-9,51,93,127,127,127,127,
127,65,-38,-55,-38,-2,-7,-12,13,30,13,-41,-84,-126,-112,12,118,62,-53,-37,22,39,49,39,37,35,24,14,7,15,
32,57,89,111,115,91,-10,-87,-67,-4,-45,-48,-59,-15,97,104,10,-63,-64,-39,-60,33,127,127,127,127,74,-29,-50,-49,
-9,20,-8,-13,17,23,-11,-71,-91,-97,-61,53,127,92,-62,-65,-3,22,82,85,60,51,50,22,-7,0,45,81,106,127,
127,85,-4,-77,-72,-3,-10,-22,-44,-13,61,103,30,-32,-32,-73,-91,-34,83,127,127,127,39,-39,-55,-24,5,11,33,55,
58,36,-21,-51,-56,-58,20,111,127,120,-55,-106,-66,-12,80,105,88,65,55,32,-9,-29,-1,48,96,127,127,98,8,-72,
-81,4,10,-59,-94,-43,37,78,25,-13,-18,-72,-74,-33,56,127,127,79,5,-38,-38,-1,35,67,116,112,49,-16,-39,-44,
-17,-18,35,103,116,93,-32,-125,-104,-45,52,108,119,66,63,47,8,-26,-18,23,78,122,117,105,28,-43,-55,35,77,16,
-22,0,22,39,10,-18,-29,-64,-76,-48,23,79,80,25,-41,-66,-9,44,84,97,106,69,18,-16,-50,-42,-12,-17,26,96,
120,86,5,-101,-107,-71,5,69,124,104,67,45,15,-8,-5,18,55,87,107,100,42,-21,-37,24,45,23,37,25,22,39,
31,-11,-37,-57,-78,-59,-8,38,52,26,-21,-49,-6,37,40,-2,-35,-62,-68,-60,-18,-18,-11,-17,14,70,93,51,47,-7,
-56,-91,-28,32,104,127,82,42,-4,-30,-27,-4,21,36,52,81,82,34,8,40,32,41,95,79,74,83,61,14,-23,-40,
-75,-53,-25,-30,-34,-25,-30,-36,-25,7,8,-32,-72,-103,-73,-17,6,28,33,32,28,19,39,32,95,96,46,-42,-29,-7,
58,109,101,63,12,-29,-44,-42,-42,-43,-20,20,59,49,58,126,127,121,127,127,127,114,82,38,-21,-73,-100,-72,-58,-86,
-86,-31,11,25,43,61,68,62,43,-9,-5,46,127,127,70,44,36,-1,13,34,82,106,88,62,40,-12,21,41,28,27,
22,-2,-43,-76,-98,-112,-117,-87,-44,-32,-29,20,72,73,72,91,95,79,50,5,-56,-109,-81,-62,-89,-128,-58,33,56,80,
63,63,50,59,66,55,55,61,79,127,80,39,68,60,38,39,32,98,94,69,90,78,59,-2,-38,-14,18,26,10,-18,
-61,-100,-108,-128,-128,-117,-128,-84,3,-23,-52,-2,20,-4,-32,-36,-37,-49,-128,-109,-79,-44,28,51,45,90,105,64,3,-6,
25,60,101,109,67,97,13,-50,0,9,6,-12,27,36,49,92,83,57,78,81,52,55,33,-17,-43,-32,-47,-67,-105,-96,
-95,-112,-125,-97,-38,-38,-65,-43,-73,-115,-118,-115,-128,-128,-124,-54,20,65,46,-14,12,89,102,44,-12,2,48,69,77,64,
60,87,55,-13,-13,52,41,4,9,-1,5,52,36,-13,35,79,59,83,82,46,8,-20,-63,-98,-69,-56,-25,0,-3,3,
20,-3,-106,-117,-128,-112,-80,-72,-98,-128,-78,1,34,9,-32,-40,-2,52,69,80,83,66,25,-25,-17,19,36,56,34,-42,
-80,6,65,14,-23,-33,-51,-20,-17,-43,-52,-71,10,47,74,75,74,86,73,64,24,9,14,39,56,47,22,-38,-95,-114,
-122,-70,-9,-3,-38,-62,-48,-36,-59,-82,-91,-66,-21,8,-1,19,22,-7,-43,-81,-92,-61,5,30,31,-5,-46,-4,69,58,
-34,-54,-92,-79,-78,-111,-125,-128,-128,-128,-128,-115,-84,-57,-49,-29,-26,-39,-47,-37,-7,22,13,-25,-19,3,-4,-4,1,-25,
-40,-34,-41,-68,-96,-104,-74,-41,-34,-45,-42,-39,-46,-51,-55,-69,-85,-70,-45,-15,-10,3,-2,15,39,59,14,6,-13,-8,
-9,-61,-48,-43,-100,-112,-124,-128,-128,-95,-70,-31,-24,-29,-31,-19,-12,-10,15,31,35,69,82,73,52,29,25,25,18,12,
15,11,6,-2,-11,-14,-20,-28,-44,-55,-61,-69,-83,-70,-62,-25,-28,-14,4,32,69,83,-25,21,17,24,36,0,-11,-25,
4,-7,-1,20,31,30,33,65,62,67,68,71,63,47,38,28,28,44,63,66,45,44,54,42,40,20,11,-10,-31,-43,
-47,-40,-42,-48,-52,-49,-40,-43,-55,-47,-31,-5,-25,-16,13,27,53,46,-90,-68,-89,-48,-20,6,9,27,28,28,30,35,
48,65,55,17,24,18,6,14,16,-2,-10,9,22,36,42,28,13,-21,-66,-74,-88,-122,-126,-100,-74,-61,-48,-58,-74,-70,
-73,-79,-90,-94,-105,-117,-128,-113,-87,-76,-44,-31,34,51,-98,-55,-56,-4,41,72,69,97,119,96,62,43,29,28,33,30,
32,16,-21,-51,-72,-86,-73,-31,34,78,98,86,77,64,21,-9,-78,-125,-128,-128,-128,-94,-71,-61,-54,-63,-68,-62,-58,-60,
-73,-79,-68,-66,-90,-100,-72,-33,68,27,12,52,51,89,118,127,108,127,47,9,-38,-60,-46,-37,-47,-47,-37,-67,-104,-98,
-73,-45,10,89,101,127,127,127,127,127,127,127,47,10,-46,-82,-81,-72,-62,-41,-50,-45,-28,11,27,13,10,22,58,71,
62,40,42,83,127,63,117,127,124,88,35,29,-11,-40,-81,-121,-128,-128,-95,-57,-45,-20,-35,-45,-80,-103,-123,-128,-93,21,
30,110,127,127,127,127,127,106,-6,-49,-61,-53,-59,-87,-94,-62,-54,-49,-43,-12,32,64,94,120,127,127,127,119,81,125,
127,97,102,100,20,-63,-116,-95,-122,-128,-74,-55,-41,-30,0,9,-2,16,1,1,-41,-102,-128,-128,-128,-128,-119,-3,103,127,
127,116,93,89,-11,-68,-88,-61,-37,-42,-65,-92,-92,-78,-71,-56,-8,46,105,127,127,127,127,49,49,113,127,76,45,19,
-62,-112,-100,-18,9,8,16,55,93,95,110,121,111,127,68,88,63,14,-48,-125,-128,-128,-114,-42,12,43,55,32,-2,-14,
-43,-30,-53,-82,-38,37,-2,-87,-110,-43,16,32,43,53,97,127,127,127,74,-12,24,107,127,113,12,-63,-73,-25,29,58,
22,-15,14,29,49,82,118,127,116,87,67,76,62,40,22,10,-11,-46,-58,-12,19,43,41,6,-5,-7,-56,-29,-10,-24,
-17,35,29,-33,-69,-50,-16,7,23,49,87,101,108,68,13,-11,54,117,127,67,-33,-69,-5,66,92,69,26,25,12,9,
29,63,68,46,18,4,-3,-7,15,32,32,44,12,-83,-76,-19,-13,2,55,76,73,63,43,29,41,64,76,103,97,69,
-54,-88,-78,-27,-1,-1,8,7,34,-21,9,41,112,127,127,127,-14,-47,18,91,100,78,34,-2,12,15,35,54,43,-4,
-47,-67,-52,-31,-31,-30,-10,-16,-47,-92,-32,-3,-29,-20,14,11,20,55,49,70,75,65,84,127,127,127,127,95,42,17,
25,19,-43,-80,-121,-128,-86,-8,103,127,127,101,6,6,73,100,84,44,1,-9,7,16,14,-1,-12,-24,-35,-40,-37,-30,
-59,-81,-57,-38,-41,-83,52,59,29,33,49,30,4,-11,-3,5,14,41,86,127,127,127,127,127,127,119,37,-55,-128,-128,
-128,-128,-128,-119,-66,-20,-1,19,5,37,89,77,30,-12,-23,9,32,20,-3,-18,-7,-4,-8,-4,-26,-29,-61,-76,-42,-7,
11,-23,44,64,69,67,54,36,-5,-54,-64,-57,-33,11,59,77,65,55,54,98,127,115,33,-54,-128,-128,-128,-128,-128,-128,
-126,-78,-52,-5,18,26,56,37,-14,-45,-34,14,83,40,-1,0,32,34,15,9,35,-5,-43,-36,15,33,31,-6,-16,42,
87,82,47,32,-7,-71,-101,-86,-58,-10,34,38,20,21,14,52,94,92,50,-8,-73,-118,-128,-128,-127,-125,-83,-67,-65,-22,
13,12,18,-19,-49,-41,-12,30,72,36,14,26,58,47,25,25,51,-16,-54,-33,36,30,-2,-23,44,88,125,94,32,12,
-32,-95,-125,-107,-82,-46,1,12,-11,-15,-42,-4,47,73,64,43,-7,-60,-89,-128,-128,-128,-72,-28,-24,3,-12,12,12,-58,
-73,-18,26,68,33,19,26,50,74,59,31,27,30,-35,-62,-41,50,31,-31,-18,30,48,96,79,7,-12,-51,-121,-128,-128,
-125,-103,-39,-1,-32,-63,-43,-36,-13,26,58,85,71,18,-51,-127,-128,-128,-69,14,34,40,9,19,10,-51,-73,-6,42,62,
30,17,16,40,67,55,28,12,5,-23,-13,-17,78,31,-127,-89,-99,-78,17,38,-44,-52,-63,-107,-124,-128,-128,-128,-106,-4,
-19,-71,-39,-5,17,19,47,92,106,72,-1,-113,-128,-128,-108,7,70,56,32,9,-6,-52,-65,1,44,55,31,4,-7,25,
69,59,27,9,2,-1,12,-2,95,18,-128,-128,-127,-103,-29,-45,-128,-94,-52,-70,-128,-128,-128,-128,-100,19,-17,-117,-80,-21,
21,35,62,104,127,127,44,-74,-128,-128,-122,5,73,65,38,29,-17,-54,-72,-23,19,64,39,29,25,46,85,67,19,12,
3,-31,8,48,99,-17,-128,-128,-128,-104,-64,-95,-128,-85,-28,-24,-87,-128,-128,-128,-55,55,65,-128,-90,-28,-2,28,62,86,
127,127,114,-46,-128,-128,-116,5,80,56,29,22,-27,-72,-91,-40,3,45,47,40,40,59,86,63,18,11,-2,-30,12,61,
98,-18,-126,-87,-105,-71,-42,-61,-84,-41,2,10,-31,-124,-128,-97,-8,72,98,-70,-78,-1,31,39,41,54,127,127,127,-4,
-128,-128,-115,9,82,56,27,24,-32,-83,-108,-57,-20,17,26,25,41,61,74,46,7,0,-9,-41,5,62,77,-55,-128,-121,
-50,-63,-61,-51,-31,15,42,51,-13,-75,-91,-43,-1,71,116,-62,-67,19,62,68,42,35,119,127,127,47,-115,-128,-112,13,
89,69,27,22,-37,-85,-113,-73,-44,-11,-13,-7,25,52,52,22,-12,-17,-6,-53,-22,35,42,-63,-128,-116,-58,-98,-95,-42,
23,82,106,116,30,6,-7,-3,2,93,127,-88,-77,17,85,98,60,28,105,127,127,79,-85,-128,-118,9,91,86,20,17,
-38,-78,-117,-90,-58,-24,-32,-39,-4,34,33,4,-19,-19,-3,-37,-27,-1,-13,-64,-74,-57,-83,-100,-63,25,81,93,98,123,
101,71,24,-1,-10,83,122,-118,-116,-7,88,109,57,14,96,127,127,86,-73,-128,-124,-1,85,85,16,12,-37,-69,-113,-98,
-58,-22,-32,-62,-38,9,20,-1,-20,-19,-18,-18,-17,-17,-59,-63,-35,-25,-84,-82,-33,43,50,9,21,93,127,99,25,-11,
-10,79,119,-98,-118,-15,84,92,11,-38,66,127,127,79,-72,-128,-120,-3,79,71,25,11,-40,-60,-109,-92,-56,-20,-46,-75,
-56,-11,27,19,-13,-20,-45,-4,5,2,-64,-30,-62,-83,-110,-73,-9,8,-16,-28,20,114,127,127,22,-47,-63,15,86,-92,
-91,-41,61,64,-17,-63,22,124,127,55,-81,-128,-111,11,84,70,26,10,-43,-61,-108,-90,-54,-17,-47,-75,-55,-8,32,23,
-12,-21,-49,-8,-2,-1,-59,-20,-52,-70,-82,-43,18,29,5,-5,41,127,127,127,22,-46,-62,8,76,-91,-90,-48,53,60,
-24,-72,16,119,127,49,-85,-128,-111,13,86,72,13,6,-43,-72,-110,-96,-54,-15,-32,-66,-42,12,24,-2,-24,-26,-28,-27,
-35,-23,-43,-42,7,24,-26,-25,10,85,90,42,50,116,127,120,31,-8,-8,68,96,-101,-122,-24,71,83,-13,-68,58,127,
127,67,-81,-128,-119,0,87,77,17,10,-45,-80,-111,-88,-54,-20,-34,-45,-12,26,24,-5,-29,-31,-19,-46,-39,1,5,-36,
-34,-22,-40,-47,-16,62,109,115,115,127,112,80,20,-7,-16,68,102,-122,-119,-14,75,95,29,-18,85,127,127,63,-91,-128,
-120,7,97,91,22,16,-42,-88,-110,-73,-47,-16,-18,-14,17,40,32,2,-27,-33,-21,-57,-22,48,61,-34,-108,-106,-54,-73,
-65,-14,46,99,114,117,29,5,-17,-12,-13,73,121,-93,-84,15,80,82,34,4,95,127,127,49,-106,-128,-112,20,107,93,
23,21,-33,-86,-110,-64,-31,-2,6,6,26,47,49,18,-13,-17,-17,-38,15,83,96,-30,-128,-128,-75,-70,-61,-49,-24,22,
41,45,-17,-70,-86,-39,-12,55,107,-63,-76,26,69,52,18,14,109,127,127,18,-128,-128,-104,26,107,78,32,25,-23,-72,
-98,-54,-18,12,14,7,18,43,59,31,-4,-2,-12,-23,24,74,105,-1,-115,-102,-128,-79,-43,-61,-80,-33,2,3,-37,-111,
-128,-73,-5,60,80,-80,-89,11,50,29,20,41,127,127,127,-29,-128,-128,-105,24,103,68,53,43,-5,-49,-78,-41,-6,25,
2,-9,-2,28,56,34,-2,1,-1,-17,17,40,77,-24,-128,-128,-128,-107,-68,-98,-128,-78,-25,-28,-83,-128,-128,-128,-41,49,
46,-128,-89,-6,29,28,49,78,127,127,91,-68,-128,-128,-104,22,103,70,52,39,15,-39,-67,-17,20,26,-5,-30,-31,4,
38,27,4,-1,4,6,16,-14,53,-17,-128,-128,-112,-102,-43,-57,-128,-89,-48,-64,-114,-128,-128,-128,-84,16,-19,-112,-65,4,
47,42,58,94,127,127,22,-96,-128,-128,-106,21,96,74,26,49,31,-38,-71,-16,27,41,2,-15,-14,10,32,20,1,-6,
5,-11,0,-26,38,-13,-128,-93,-102,-93,-2,25,-51,-57,-61,-89,-104,-128,-128,-128,-95,-8,-16,-52,-29,15,43,33,48,80,
83,42,-28,-128,-128,-128,-95,20,90,64,-6,38,38,-45,-66,-20,21,65,18,-4,0,20,40,26,3,10,23,-17,-47,-42,
23,-10,-52,-33,4,16,68,56,-3,-11,-46,-112,-114,-111,-112,-87,-25,3,-24,-43,-22,-21,-2,26,45,58,43,-6,-76,-128,
-128,-128,-52,37,52,49,1,21,42,-1,-42,-43,-15,34,82,26,-11,-2,27,15,-2,10,45,-1,-47,-41,17,6,-20,-47,
21,58,100,77,28,18,-26,-90,-115,-102,-85,-47,7,19,4,10,-22,11,49,56,37,17,-29,-85,-114,-128,-128,-128,-53,1,
-5,12,-11,9,69,55,-5,-46,-40,18,104,49,-3,-14,7,5,-11,-7,25,0,-47,-55,-3,24,32,-11,-41,14,65,68,
44,35,-10,-78,-104,-88,-61,-12,37,46,34,35,28,65,102,89,47,-6,-73,-128,-128,-128,-128,-109,-44,-29,-46,-14,-26,0,
83,92,46,-5,-27,11,44,44,23,-12,-20,-21,-28,-27,-35,-27,-63,-94,-57,-3,30,-8,28,46,54,59,52,36,-8,-63,
-79,-63,-33,11,56,79,75,68,82,127,127,127,70,-16,-100,-128,-128,-128,-128,-115,-57,-13,-10,14,-23,-44,46,101,102,63,
5,-7,12,43,55,29,1,-21,-43,-57,-39,-27,-54,-93,-74,-31,-15,-56,52,57,29,31,40,23,4,-16,-8,0,14,40,
80,127,127,127,127,127,127,127,82,-19,-106,-128,-128,-128,-128,-48,27,82,82,65,-53,-108,-28,66,100,101,54,8,22,40,
72,98,85,31,-24,-54,-56,-38,-33,-50,-38,-21,-33,-79,-34,-4,-18,-9,10,7,25,48,43,60,72,59,66,127,127,127,
127,127,78,54,64,57,-1,-37,-110,-128,-94,33,127,127,127,127,-65,-124,-64,4,43,61,42,37,20,21,50,97,117,97,
59,35,2,0,15,10,2,15,-8,-86,-77,-20,0,25,56,67,80,65,31,12,18,34,49,99,120,105,-15,-66,-65,-13,
24,23,31,39,39,-52,-27,33,127,127,127,127,2,-95,-125,-94,-45,-1,-12,-23,5,21,42,80,126,127,127,106,94,105,
86,50,26,6,-11,-38,-65,-24,10,45,37,1,0,-15,-83,-79,-60,-56,-33,29,38,-16,-62,-49,-20,5,27,57,106,127,
123,44,-33,-59,23,126,127,110,62,32,-69,-128,-128,-93,-67,-63,-46,3,54,51,62,82,82,110,59,90,79,34,-25,-91,
-114,-87,-77,-8,26,38,46,25,-12,-33,-74,-84,-117,-126,-57,19,-28,-116,-128,-76,-20,3,30,49,99,127,127,127,35,-62,
-26,89,127,127,126,127,51,-33,-109,-103,-128,-128,-128,-128,-116,-100,-63,-43,-54,-38,-24,-20,-59,-116,-128,-128,-128,-128,-91,10,
78,97,89,63,42,41,-59,-100,-104,-62,-28,-47,-86,-121,-128,-117,-110,-91,-34,28,94,127,127,127,127,17,-5,88,127,115,
127,127,127,127,77,80,39,4,-65,-120,-128,-128,-115,-68,-48,-19,-29,-34,-62,-78,-88,-105,-82,-10,9,74,101,120,127,127,
127,82,-9,-33,-31,-30,-53,-101,-120,-95,-94,-81,-64,-28,27,67,101,127,127,127,127,77,8,71,127,124,38,81,78,110,
127,127,127,127,117,71,14,-23,-15,3,8,21,22,-26,-75,-68,-44,-25,22,85,108,127,127,127,127,127,127,127,52,24,
-26,-71,-92,-97,-89,-75,-78,-64,-40,4,32,25,18,37,88,103,91,39,-3,35,127,83,-68,-21,-21,20,52,85,89,117,
127,127,111,91,72,65,67,66,66,44,3,-27,-55,-77,-60,-14,50,78,87,79,72,56,13,-21,-86,-128,-128,-128,-128,-108,
-83,-75,-63,-64,-63,-51,-37,-36,-55,-54,-48,-44,-51,-74,-85,-72,28,15,-86,-61,-83,-48,-30,-3,4,21,29,31,32,36,
48,64,60,28,33,22,8,15,11,-7,-8,10,21,31,37,31,16,-18,-60,-74,-92,-126,-128,-109,-76,-59,-50,-62,-65,-56,
-59,-67,-77,-84,-98,-99,-113,-93,-51,-46,-42,-61,1,33,20,61,57,31,29,-4,-37,-46,-48,-48,-35,-25,-12,6,30,-2,
10,1,4,22,22,15,52,92,106,57,4,-15,-14,-9,-9,-15,-6,-7,-15,-31,-65,-80,-90,-94,-87,-66,-61,-59,-52,-81,
-92,-91,-84,-60,-54,-69,-83,-47,-124,-77,94,124,89,73,81,35,-6,-25,-45,-12,9,17,47,76,105,54,50,32,22,43,
90,127,127,127,127,97,36,9,-4,-14,-19,-17,4,15,22,17,-19,-33,-35,-33,-58,-70,-79,-72,-61,-102,-111,-101,-68,-45,
-32,-46,-100,-128,-128,-128,98,104,102,113,93,57,65,75,127,127,106,54,56,73,67,12,7,-3,-3,12,20,7,34,93,
111,39,-14,-3,14,-10,-62,-99,-128,-86,-47,-42,-49,-36,-11,13,40,30,13,4,2,-36,-40,-13,25,85,97,53,-50,-128,
-128,-118,91,95,109,106,79,37,85,103,76,57,17,-55,-71,-82,-107,-109,-128,-128,-128,-128,-128,-128,-128,-64,-14,-107,-128,-128,
-50,-20,-51,-38,-91,-67,-64,-103,-128,-128,-110,-57,-10,-2,3,4,-24,-58,-36,53,127,127,127,126,29,-79,-122,-65,48,65,
65,24,19,-9,-16,-32,-10,2,11,-35,-36,-57,-116,-128,-128,-126,-126,-124,-128,-128,-128,-83,21,-32,-128,-128,-108,-90,-88,-38,
51,93,117,91,27,-60,-110,-120,-85,-33,11,16,-25,-36,19,127,127,127,120,96,27,-39,-92,-44,-3,30,41,-54,-68,-75,
-112,-128,-108,-19,60,37,19,-4,-42,-55,-35,-12,20,38,27,8,11,53,105,82,29,5,43,90,102,92,118,127,127,127,
127,94,19,-15,-126,-91,-47,-16,-21,12,62,127,127,127,84,54,-53,-69,-79,-39,-8,-22,-112,-128,-63,-102,-90,-85,69,105,
108,88,83,67,19,-12,-59,-31,18,57,85,116,127,127,127,127,127,111,99,109,115,118,127,127,127,127,127,91,74,47,
-45,-78,-65,-65,-45,19,99,107,103,100,21,-58,-105,-47,-33,-8,-30,-125,-128,-103,-59,-68,33,100,126,120,90,68,72,52,
-8,-51,-59,-26,51,120,127,127,127,127,127,127,127,104,75,78,88,76,76,118,127,101,42,36,96,124,17,-85,-121,-128,
-126,-69,-15,7,57,28,-94,-128,-128,-38,11,34,-78,-128,-128,-70,-21,79,127,88,59,54,27,11,0,-17,-63,-102,-81,-61,
55,53,34,16,0,-20,79,65,41,1,-18,-9,-3,27,-7,-9,7,10,8,66,127,127,127,49,-62,-122,-117,-91,-46,3,
45,-55,-128,-128,-46,66,127,86,-88,-128,-79,0,74,116,70,10,-27,-19,-18,-25,-54,-85,-99,-92,-54,-37,6,-26,-57,-83,
-64,-51,-5,-27,-49,-96,-109,-75,-64,-50,-57,-64,-61,-63,-62,-28,18,35,127,127,127,80,31,-14,-38,-19,-18,-52,-39,-9,
79,127,127,127,-94,-86,19,75,93,80,1,-53,-80,-61,-48,-46,-67,-76,-61,-41,-53,-38,-32,-41,-79,-122,-73,-62,-65,-67,
-55,-95,-128,-128,-113,-83,-70,-89,-101,-98,-99,-102,-97,-88,-64,46,127,127,127,97,57,61,55,56,86,84,106,114,113,81,
-59,-27,94,115,59,8,-55,-101,-83,-70,-55,-37,-37,-41,-46,-44,-41,-56,-69,-19,-50,-114,-71,-87,-89,-49,-4,-26,-95,-128,
-128,-79,-50,-62,-78,-78,-74,-89,-102,-100,-94,-70,0,75,102,86,64,27,65,76,99,61,66,63,37,12,-31,23,103,92,
17,-53,-95,-119,-93,-72,-47,-9,19,19,-24,-64,-34,-72,-95,-2,-29,-105,-76,-118,-80,5,33,8,-31,-96,-112,-57,-33,-27,
-36,-40,-36,-53,-72,-74,-40,-29,17,45,55,78,75,30,-31,-27,24,34,84,95,42,21,6,83,110,67,-9,-74,-85,-104,
-85,-37,8,52,87,83,26,-26,-62,-100,-128,-11,-23,-110,-96,-128,-105,12,20,-2,1,-38,-93,-99,-19,-1,5,15,20,-15,
-64,-86,-48,-37,4,27,34,35,37,34,-44,-91,-62,-33,57,105,67,41,88,127,123,58,-27,-78,-102,-112,-43,16,65,92,
105,103,57,-3,-81,-128,-128,4,7,-126,-97,-109,-101,-35,-27,-4,17,0,-35,-56,-11,14,42,70,61,-16,-92,-57,-19,3,
34,35,22,13,25,45,12,-79,-122,-73,16,86,63,25,107,117,107,49,-42,-90,-105,-89,-34,22,61,80,95,102,59,-5,
-73,-128,-128,31,55,-117,-110,-128,-66,-28,4,54,33,6,2,-32,35,56,87,116,98,-18,-116,-74,18,47,79,71,55,52,
36,-2,-16,-74,-101,-79,-31,44,50,32,98,112,94,45,-39,-79,-73,-57,-2,54,106,104,75,85,67,7,-66,-128,-128,39,
3,-128,-97,-55,-29,15,100,87,46,53,32,16,49,76,127,127,115,-37,-128,-78,121,98,92,70,52,67,32,-13,-25,-47,
-89,-62,-38,33,31,26,71,83,59,20,-49,-81,-56,-17,45,101,127,123,74,79,76,31,-47,-128,-128,4,-12,-128,-59,45,
63,66,108,83,54,55,7,-23,35,86,127,127,124,-73,-128,-96,88,72,89,69,40,70,46,-11,-37,-57,-86,-52,-45,14,
18,21,41,64,46,17,-41,-67,-34,21,78,124,127,127,78,82,85,49,-11,-94,-128,3,12,-86,-57,37,32,30,64,48,
35,51,13,-1,-7,37,127,127,88,-107,-128,-116,42,43,89,73,31,77,79,12,-54,-83,-103,-51,-47,-2,7,19,34,67,
54,36,-12,-44,-23,32,72,103,127,112,78,91,90,53,7,-47,-83,8,22,-20,-50,-23,9,5,34,25,22,20,-29,-40,
-52,-35,74,102,38,-93,-128,-107,-13,11,80,69,34,110,121,45,-73,-116,-128,-62,-54,-17,-10,1,34,71,64,53,10,-33,
-37,-4,27,58,72,62,58,86,92,62,29,-16,-22,18,22,15,-29,-71,-48,-27,4,8,17,-6,-96,-128,-84,-102,20,62,
10,-86,-128,-128,-62,-27,47,41,37,127,127,38,-82,-128,-128,-79,-73,-43,-41,-31,37,75,70,59,22,-26,-59,-45,-16,24,
37,22,24,68,87,74,48,6,25,53,51,32,-19,-92,-21,-21,-17,3,32,-6,-126,-128,-128,-128,-29,64,36,-71,-128,-128,
-113,-79,-6,6,47,127,127,40,-80,-128,-128,-88,-82,-60,-64,-53,36,74,68,54,20,-45,-91,-72,-24,19,38,11,3,54,
83,77,44,24,62,67,117,20,-9,-56,-46,-32,1,9,18,-15,-113,-128,-128,-105,36,127,103,-46,-128,-128,-99,-77,-34,12,
64,127,127,68,-72,-127,-128,-90,-99,-75,-66,-62,33,73,68,53,20,-44,-90,-71,-18,24,43,17,7,56,85,79,54,33,
59,57,120,29,6,-36,-30,-11,24,27,30,-3,-99,-128,-115,-77,53,127,112,-36,-128,-128,-97,-80,-39,10,67,127,127,79,
-69,-124,-128,-85,-92,-72,-65,-63,26,71,69,57,22,-19,-49,-39,-4,38,52,37,36,73,93,83,58,19,28,58,67,52,
-13,-95,-17,8,14,29,52,19,-92,-128,-92,-128,-2,92,70,-39,-128,-128,-110,-89,-13,-4,51,127,127,55,-73,-128,-128,-70,
-57,-44,-60,-54,21,67,63,51,8,-28,-28,4,44,78,94,85,78,96,101,77,49,3,-8,37,51,31,-23,-59,-16,4,
21,19,28,18,-59,-124,-67,-81,52,105,53,-54,-128,-128,-52,-26,50,38,45,127,127,52,-75,-128,-128,-56,-47,-28,-36,-29,
21,64,55,35,-13,-40,-15,43,88,120,127,127,107,112,105,69,27,-26,-53,33,49,-15,-48,-15,25,21,42,31,24,29,
-13,-35,-54,-35,88,127,76,-58,-128,-105,-3,23,93,73,45,127,127,58,-68,-114,-114,-36,-31,-6,-7,1,32,62,46,20,
-38,-61,-24,36,90,127,127,127,110,113,107,65,-1,-73,-114,19,26,-84,-49,41,25,27,58,51,43,55,15,-5,-11,28,
127,127,117,-73,-128,-119,37,54,102,79,45,99,95,29,-49,-77,-82,-24,-28,3,4,14,67,77,56,23,-45,-74,-44,-1,
59,115,127,127,101,108,98,45,-30,-127,-128,10,-4,-128,-51,39,58,62,99,86,65,66,16,-19,32,83,127,127,127,-45,
-128,-89,85,92,111,79,55,88,62,5,-27,-43,-58,-26,-32,10,7,9,94,104,90,50,-35,-74,-64,-45,11,72,124,121,
93,101,81,19,-46,-128,-128,24,1,-128,-92,-63,-31,3,84,90,59,68,49,31,55,86,127,127,127,-7,-128,-48,127,127,
124,86,66,78,44,5,-7,-27,-63,-42,-34,20,12,11,94,110,110,61,-34,-83,-96,-85,-32,31,82,101,104,106,67,5,
-59,-128,-128,15,46,-120,-109,-128,-71,-43,2,55,39,21,13,-15,46,68,104,127,114,9,-94,-43,53,85,106,84,66,61,
43,18,3,-53,-90,-76,-43,20,22,15,64,119,124,70,-22,-75,-101,-112,-53,12,75,108,111,104,62,2,-62,-128,-128,-7,
14,-120,-108,-128,-118,-60,-24,14,33,18,-23,-43,-2,24,63,91,77,3,-78,-36,1,25,53,49,39,29,32,52,20,-69,
-127,-92,-24,39,25,9,-28,57,112,78,-3,-72,-81,-102,-101,-60,-6,57,99,86,32,-8,-52,-93,-125,-12,-11,-97,-99,-128,
-112,5,33,13,12,-21,-78,-89,-9,7,17,29,30,1,-45,-77,-46,-30,16,35,37,34,34,33,-57,-104,-82,-80,0,47,
19,13,-76,-3,96,87,23,-42,-88,-119,-107,-94,-68,-20,17,15,-19,-42,-20,-67,-95,-1,-11,-77,-64,-125,-74,12,44,16,
-17,-77,-104,-55,-32,-22,-20,-18,-19,-39,-62,-71,-48,-32,22,52,53,66,69,38,-18,-31,-4,-21,25,42,7,2,-100,-60,
81,114,67,19,-41,-95,-85,-80,-74,-58,-53,-61,-63,-45,-29,-49,-66,-12,-32,-87,-54,-94,-95,-46,2,-15,-70,-120,-128,-73,
-39,-54,-66,-60,-54,-70,-85,-88,-100,-75,-11,63,91,82,72,35,59,57,71,30,44,45,25,5,-120,-128,-6,91,110,80,
6,-44,-69,-51,-45,-48,-76,-105,-104,-79,-70,-51,-47,-43,-71,-112,-71,-68,-78,-72,-52,-85,-120,-117,-114,-76,-66,-82,-90,-84,
-81,-82,-85,-87,-59,28,106,127,127,86,53,52,58,44,64,63,90,91,94,74,-94,-128,-117,-4,89,123,79,19,-11,5,
4,-12,-49,-100,-128,-128,-102,-83,-48,-65,-81,-112,-94,-73,-38,-54,-67,-102,-102,-73,-68,-47,-61,-52,-44,-50,-46,-12,16,14,
95,120,81,28,-4,-41,-57,-37,-10,-30,-13,7,85,127,127,114,-50,-128,-128,-112,-38,90,127,101,88,89,56,25,5,-26,
-90,-128,-128,-117,-26,-19,-28,-53,-57,-56,34,21,2,-27,-33,-22,-20,3,-31,-32,-24,-31,-30,33,120,127,125,8,-117,-128,
-128,-128,-69,-13,27,-40,-92,-91,7,89,109,53,-4,-76,-128,-125,-96,-62,65,112,127,127,125,93,91,68,-1,-56,-72,-59,
-2,49,68,65,83,96,127,127,97,53,24,18,15,0,24,46,57,47,8,15,80,114,17,-104,-128,-128,-128,-106,-52,-17,
37,7,-94,-128,-91,40,56,31,-3,25,-47,-82,-50,-101,-66,-49,74,127,127,127,127,114,64,27,-38,-23,18,45,61,78,
127,127,127,127,127,74,62,65,61,61,106,90,113,127,121,71,53,32,-71,-100,-81,-98,-89,-25,69,91,93,91,22,-40,
-43,29,28,4,-26,13,80,35,25,6,-45,-86,-89,-1,95,79,79,75,50,42,51,60,82,92,69,39,36,70,121,74,
9,-24,0,55,72,49,72,117,127,127,127,87,12,-18,-122,-96,-69,-54,-74,-32,19,108,127,127,105,82,-4,5,-15,-26,
11,8,34,36,74,75,68,54,28,27,45,-3,-3,-9,-47,-47,-30,-41,-58,-71,-103,-128,-122,-61,-12,-83,-128,-128,-128,-111,
-97,-60,46,86,115,120,81,-10,-74,-97,-62,-22,2,-16,-79,-86,-22,103,127,127,127,114,59,5,-54,-23,62,40,54,62,
54,46,117,127,127,82,27,-60,-92,-109,-128,-128,-128,-128,-128,-128,-128,-128,-128,-49,-30,-128,-128,-128,-72,-18,-20,-1,-57,-17,
6,-9,-52,-87,-69,-27,19,19,13,3,-44,-95,-76,15,124,127,127,127,47,-63,-107,-51,74,47,45,60,42,22,40,52,
127,127,118,44,18,16,13,-62,-84,-89,-73,-36,-9,-4,36,95,127,48,-8,5,29,20,-19,-58,-75,-23,29,35,3,-19,
-11,9,26,10,-10,-15,-22,-82,-97,-79,-18,75,88,47,-41,-128,-128,-107,64,81,45,17,16,-24,-63,-83,-89,-40,-9,-5,
13,30,63,-13,-28,-45,-43,4,75,127,127,127,127,127,75,45,36,23,15,16,29,36,40,27,-26,-62,-75,-74,-101,-114,
-121,-109,-95,-128,-128,-128,-126,-83,-62,-63,-105,-128,-128,-128,13,51,40,16,5,-31,-65,-68,-80,-74,-56,-46,-30,-6,23,-33,
-13,-16,-4,26,31,24,71,126,127,87,26,0,-3,1,2,-4,5,-2,-15,-42,-79,-96,-110,-117,-110,-89,-82,-81,-73,-111,
-123,-125,-122,-93,-77,-74,-83,-58,-128,-82,36,85,94,101,100,108,63,66,52,-11,-36,-44,-80,-115,-104,-96,-99,-102,-127,-124,
-116,-102,-74,-54,-63,-66,-61,-53,-50,-36,-17,-17,-11,-23,-23,-30,3,53,71,59,18,7,11,8,1,-21,-35,-35,-24,-19,
3,65,59,40,36,-3,70,97,103,117,107,116,50,-7,-69,-81,-100,-128,-128,-128,-128,-128,-128,-128,-128,-128,-128,-128,-79,-34,
9,-3,-11,-19,-27,-58,-84,-91,-112,-122,-128,-128,-97,-28,-1,2,-22,-53,-61,-54,-55,-94,-111,-109,-102,-101,-8,65,77,64,
29,-36,15,67,73,78,80,68,17,-9,-49,-55,-79,-128,-128,-128,-128,-128,-128,-128,-128,-128,-123,-98,1,109,127,127,127,97,
74,70,70,86,45,25,-26,-56,-26,-7,16,57,78,42,3,-13,-33,-76,-91,-97,-124,-111,3,53,56,36,-45,-109,48,115,
127,127,127,127,79,70,25,3,-31,-74,-73,-40,-7,6,-12,0,49,84,50,-29,-26,65,127,127,124,65,54,107,127,127,
127,104,83,95,91,58,82,127,127,127,127,97,57,17,-6,-11,-39,-36,5,44,79,29,-84,-98,110,127,127,127,127,127,
115,51,58,34,27,18,13,7,22,54,83,89,115,119,89,6,-32,16,28,11,-19,-71,-83,-13,92,127,127,51,25,71,
93,44,15,37,125,127,127,71,44,54,34,27,16,-8,15,71,122,42,-19,15,105,127,127,127,89,106,68,-1,29,22,
31,18,6,-1,-4,-5,5,14,14,-3,26,36,25,34,-29,-47,-29,-35,-100,-127,-85,-42,-6,-42,-51,-20,-1,-29,-63,-63,
50,105,68,-16,-28,17,11,13,-3,-43,2,83,127,127,94,69,127,127,127,73,52,15,-54,-79,-22,-21,6,40,67,68,
40,16,4,13,29,35,38,38,21,6,38,47,52,50,7,-57,-78,-80,-7,-7,-14,-34,-37,11,4,-24,-10,47,38,-32,
-50,-38,-52,-48,-58,-90,-54,77,127,127,127,47,127,127,58,8,10,-39,-86,-53,-9,8,39,57,60,50,31,23,57,64,
83,73,41,31,55,77,83,71,40,24,-1,-33,-26,-9,-12,-18,-10,-18,-24,29,24,-12,-16,-1,-10,-36,-62,-100,-126,-124,
-128,-128,-61,81,127,127,127,26,121,86,-25,-56,-19,-74,-68,-2,1,12,16,21,10,5,11,25,42,75,75,46,16,-16,
-36,-55,6,-5,-26,-31,-49,-46,-15,-12,-1,-1,14,1,-22,5,47,54,43,-4,-40,-51,-24,-69,-128,-128,-128,-128,-37,125,
127,127,127,8,106,78,-35,-89,-82,-85,-31,-15,18,21,0,-25,-48,-44,-17,8,24,25,52,46,-30,-86,-74,-77,-106,-72,
-40,-2,4,-20,-21,-24,-12,10,39,21,-11,6,53,84,86,61,7,-47,-63,-110,-128,-126,-128,-47,127,127,127,127,127,34,
46,45,-75,-128,-101,-72,12,1,36,19,-33,-79,-101,-77,-34,-5,-12,-9,54,45,-71,-85,-13,-18,-85,-50,-34,10,38,6,
-26,-43,-23,6,38,39,13,-7,10,42,98,98,77,21,-40,-119,-128,-124,-128,-49,121,127,127,127,115,9,32,13,-121,-128,
-45,-28,32,31,42,3,-56,-85,-97,-92,-64,-33,-47,1,77,12,-124,-52,74,51,15,13,-23,-7,31,29,7,-35,-13,-3,
20,41,51,33,17,29,54,48,48,19,-12,-56,-104,-128,-128,-107,-13,60,92,95,83,40,47,-13,-122,-115,-9,25,66,62,
43,-3,-68,-87,-83,-75,-62,-48,-22,42,90,-21,-128,-6,90,7,32,56,1,-21,7,31,31,-25,19,15,6,20,49,47,
25,28,15,8,9,-5,4,1,-37,-90,-128,-128,-78,7,36,49,72,35,28,-59,-79,-49,10,44,90,89,37,5,-61,-92,
-83,-51,-22,-16,6,50,64,-50,-128,6,29,-107,-33,52,11,-37,-22,18,51,16,30,30,19,30,49,27,-7,-13,-13,-4,
0,-18,-19,-23,-35,-51,-128,-128,-128,-74,-6,14,37,-12,-17,-54,-30,-13,14,69,98,80,54,5,-55,-84,-84,-43,-8,5,
1,39,27,-67,-128,-31,-35,-123,-123,27,28,-5,7,14,34,24,47,58,58,45,35,6,-52,-90,-124,-71,-24,-26,-24,-10,
-11,-48,-128,-128,-128,-128,-73,-57,-40,-35,-33,-22,-1,-2,37,89,96,54,34,-11,-60,-85,-84,-39,1,16,15,40,-20,-125,
-128,-91,-67,-90,-124,-12,-1,17,39,17,38,51,117,107,95,74,68,29,-48,-118,-128,-58,-6,-21,-15,39,58,2,-95,-128,
-128,-128,-76,-81,-70,-38,-10,-12,2,20,39,71,83,61,17,-32,-47,-61,-84,-50,2,19,7,9,-72,-122,-128,-128,-79,-29,
17,3,30,79,66,25,31,68,127,85,92,87,86,82,-22,-119,-128,-57,39,2,19,81,120,91,-43,-128,-128,-128,-94,-69,
-67,-49,1,-9,-12,3,31,69,79,60,14,-37,-47,-55,-83,-53,-2,15,4,7,-82,-89,-74,-125,-115,-33,-50,-31,26,57,
29,8,27,59,106,43,63,90,100,82,-27,-110,-128,1,77,-4,2,99,127,127,-3,-115,-128,-98,-77,-63,-62,-44,13,-9,
-22,-6,28,67,78,61,8,-49,-62,-66,-90,-56,-5,9,15,13,-56,-36,-7,-84,-121,-39,-59,-46,-1,11,-16,-23,-10,13,
29,-2,24,53,61,46,-51,-112,-96,58,119,5,-6,96,127,127,29,-93,-127,-68,-54,-55,-63,-47,9,-10,-13,4,34,65,
71,56,-5,-69,-93,-95,-99,-53,-4,7,27,33,-5,17,32,-50,-105,-36,-3,-34,-49,-57,-50,-40,-51,-44,48,-7,-21,-6,
-1,2,-64,-122,-47,102,127,39,6,86,127,127,38,-104,-128,-61,-36,-38,-57,-55,7,-2,5,23,43,62,57,43,-30,-86,
-117,-125,-116,-58,-11,0,4,42,36,47,57,11,-36,-2,-48,-53,-55,-48,-20,-8,-6,29,98,-8,-57,-31,-34,-41,-89,-128,
-17,127,127,92,44,92,127,127,53,-113,-128,-68,-28,-24,-45,-51,7,1,10,24,38,45,29,15,-49,-91,-119,-128,-128,-78,
-25,-5,-6,38,47,46,79,121,108,66,2,45,43,22,49,86,100,127,127,27,-32,-14,-40,-68,-104,-128,-51,124,127,127,
86,111,127,127,61,-117,-128,-75,-28,-22,-46,-55,-4,-7,8,15,23,28,13,-14,-56,-102,-128,-128,-128,-112,-42,-1,20,38,
39,102,127,127,127,127,97,127,127,127,127,127,127,127,127,94,-4,-7,-83,-78,-86,-128,-58,120,127,127,104,125,127,127,
65,-125,-128,-77,-21,-24,-43,-55,-3,-7,7,13,20,24,11,-15,-50,-98,-125,-128,-128,-113,-40,4,20,37,37,106,127,127,
127,127,81,127,127,127,127,127,127,127,127,88,-13,-20,-90,-77,-86,-128,-51,127,127,127,112,127,127,127,55,-128,-128,-74,
-15,-18,-40,-56,12,7,12,22,33,37,20,21,-31,-70,-98,-121,-123,-72,-18,6,2,45,57,41,70,120,71,19,-48,-2,
10,-8,15,53,70,113,120,21,-40,-44,-53,-73,-116,-128,-61,127,127,127,105,124,127,127,37,-128,-128,-65,-11,-6,-45,-60,
6,5,12,25,41,54,46,47,-10,-61,-89,-100,-98,-52,-6,11,8,50,44,39,45,1,-81,-57,-104,-98,-81,-74,-54,-34,
-27,6,68,-25,-65,-48,-44,-51,-107,-128,-22,127,127,106,69,107,127,127,30,-122,-128,-50,-7,-9,-45,-53,10,5,4,16,
41,63,64,64,16,-44,-64,-65,-73,-43,-4,12,21,36,-12,-3,7,-77,-128,-69,-40,-67,-70,-78,-76,-60,-69,-68,15,-38,
-29,0,-5,-20,-92,-128,-36,127,127,50,33,99,127,125,17,-108,-128,-41,-17,-27,-60,-57,19,11,3,14,41,70,74,75,
34,-22,-34,-38,-63,-44,-5,9,13,13,-76,-64,-45,-118,-128,-49,-74,-69,-29,-22,-42,-35,-23,-10,3,-36,14,67,63,23,
-80,-128,-80,103,127,17,20,107,127,117,8,-93,-118,-49,-38,-48,-70,-53,7,11,16,27,46,72,77,78,43,-7,-20,-34,
-64,-44,-3,14,1,-4,-112,-121,-119,-128,-128,-49,-53,-40,8,30,0,-13,11,38,82,10,43,90,102,66,-47,-128,-123,44,
106,14,27,112,127,111,-19,-107,-128,-79,-64,-58,-71,-54,-7,1,26,43,51,72,79,78,44,-2,-22,-48,-78,-51,-4,11,
-1,-10,-107,-128,-128,-128,-106,-50,-1,-7,22,63,45,11,22,52,127,64,76,82,87,68,-36,-128,-128,-23,68,27,44,94,
112,78,-49,-128,-128,-107,-81,-65,-78,-61,-21,-21,7,21,46,83,87,67,55,11,-37,-73,-89,-53,-14,-2,0,16,-54,-128,
-128,-122,-82,-91,-101,-12,-4,11,25,11,32,39,89,83,89,73,64,20,-58,-123,-128,-40,25,16,24,57,56,3,-81,-128,
-128,-128,-74,-78,-83,-54,-7,-58,-35,0,25,69,90,82,71,20,-37,-75,-92,-61,-29,-20,-27,14,-5,-100,-128,-53,-44,-115,
-89,40,36,2,11,17,23,-1,20,40,61,56,40,2,-65,-99,-123,-47,8,13,21,22,5,-33,-111,-128,-128,-128,-78,-69,
-67,-54,51,-50,-79,-38,23,43,79,84,48,14,-49,-81,-84,-69,-51,-50,-40,13,32,-81,-128,-5,36,-77,2,59,17,-20,
-8,25,49,4,12,14,15,37,57,25,-20,-21,-11,13,26,22,25,4,-18,-25,-128,-128,-128,-67,-26,-18,2,-34,73,16,
-105,-109,-4,28,67,69,57,9,-50,-64,-70,-84,-92,-91,-76,-12,52,-41,-128,-21,100,44,46,62,12,-4,16,31,30,-24,
11,3,-4,15,50,45,15,20,24,30,34,21,30,23,-13,-62,-128,-128,-68,6,12,21,42,19,52,44,-91,-122,-43,-29,
36,43,60,18,-35,-55,-74,-91,-85,-68,-101,-60,32,-3,-128,-65,79,71,19,18,-14,2,31,22,1,-34,-14,-10,9,32,
49,36,23,41,62,62,61,37,5,-44,-94,-128,-128,-118,-18,54,69,75,61,37,41,63,-41,-106,-101,-74,13,0,47,31,
-11,-49,-78,-74,-45,-23,-53,-59,11,34,-69,-85,-11,-17,-79,-51,-29,19,39,-4,-38,-51,-24,4,34,32,8,-5,16,54,
118,111,83,38,-22,-114,-128,-128,-128,-95,82,127,127,127,94,18,89,66,-23,-72,-79,-84,-34,-23,16,25,18,-1,-32,-42,
-28,-11,2,-8,18,41,-20,-71,-58,-56,-72,-59,-31,10,6,-31,-32,-27,-20,12,47,29,0,21,65,89,97,66,0,-54,
-70,-118,-128,-128,-128,-110,105,127,127,127,127,29,124,60,-34,-42,-15,-71,-74,-15,-10,4,21,32,12,-6,-8,0,28,55,
64,64,37,1,-16,-21,18,-8,-30,-26,-51,-62,-25,-6,4,5,19,6,-12,20,55,49,9,-47,-97,-103,-56,-74,-127,-128,
-128,-128,-34,126,127,127,118,-14,127,127,52,5,8,-39,-84,-55,-31,-19,17,44,44,29,12,4,31,47,74,87,61,49,
65,86,75,65,42,33,4,-29,-11,15,25,-1,-1,-4,-9,25,-2,-67,-48,-41,-45,-61,-70,-92,-108,-100,-128,-128,-61,96,
120,127,91,11,127,127,127,88,58,7,-69,-94,-45,-54,-29,9,35,39,18,-5,-25,-20,-3,24,29,32,10,-18,33,61,
78,82,46,-10,-26,-29,31,11,-1,-12,-11,33,19,-25,-21,23,25,-31,-45,-32,-39,-27,-57,-105,-65,101,127,127,101,44,
86,127,127,127,127,127,73,2,1,-22,-22,-40,-56,-59,-47,-48,-31,-26,-25,-37,-14,11,18,26,-9,-4,27,18,-55,-80,
-31,11,58,22,9,28,33,-2,-46,-55,46,89,57,-18,-43,8,15,24,7,-56,1,108,127,127,92,65,95,127,127,127,
127,127,127,72,57,10,-8,-20,-34,-48,-39,-17,24,33,68,82,55,-6,-22,25,55,67,50,-6,-23,40,127,127,127,83,
68,108,120,69,35,46,116,127,127,78,42,47,26,18,14,-16,5,76,127,127,29,26,29,85,125,127,127,127,96,88,
44,16,-9,-46,-63,-60,-42,-38,-53,-36,24,79,62,2,17,105,127,127,127,117,125,127,127,127,127,112,88,98,94,69,
84,127,127,127,127,100,50,-3,-33,-38,-69,-57,-21,17,90,106,-14,-80,-9,33,53,69,72,70,23,-5,-34,-40,-66,-108,
-128,-128,-128,-128,-128,-128,-128,-111,-73,-36,46,127,127,127,127,108,92,91,76,61,0,-10,-36,-49,-26,-7,12,40,60,36,
5,-14,-43,-101,-123,-128,-128,-128,-40,16,35,66,10,-77,50,72,85,111,103,106,35,-22,-76,-84,-103,-128,-128,-128,-128,-128,
-128,-128,-128,-128,-128,-118,-62,-20,17,-9,-28,-39,-45,-73,-102,-119,-128,-128,-128,-128,-82,-31,-14,-14,-32,-54,-62,-58,-65,-119,
-128,-128,-128,-128,-39,43,56,66,50,-15,29,65,77,96,94,101,59,61,48,-7,-34,-47,-80,-107,-86,-83,-88,-85,-105,-107,
-105,-93,-62,-36,-50,-67,-69,-63,-62,-44,-21,-17,-14,-17,-7,-2,22,52,63,58,23,15,19,21,21,-11,-35,-46,-30,-28,
1,62,53,37,39,2,2,39,54,76,64,46,34,54,54,59,45,7,-26,-23,-4,11,-12,-1,5,-5,-11,16,35,32,
62,47,21,10,9,17,38,29,55,88,88,48,20,18,18,8,27,33,27,35,36,32,26,25,16,-27,-7,53,70,73,
22,-2,44,89,113,127,115,96,85,91,90,74,41,6,-4,22,49,85,89,118,127,127,127,95,57,5,-23,-13,-2,10,
5,5,26,23,68,78,94,86,41,9,16,34,23,37,35,24,14,23,22,24,-23,-46,31,109,127,111,36,26,17,58,
111,127,122,120,93,48,23,1,-10,-3,24,62,100,127,127,127,127,127,127,80,17,-51,-82,-62,-16,46,80,97,91,62,
-8,-12,3,29,24,2,-1,14,33,47,42,9,-22,-16,-11,-13,-80,-71,73,127,127,106,6,-1,32,74,124,127,127,64,
-26,-80,-106,-128,-128,-122,-58,-10,15,40,101,125,127,127,64,-18,-36,-37,-29,-42,-49,-23,23,75,126,127,76,-1,-74,-101,
-88,-93,-111,-125,-53,-37,-22,-18,-24,-24,-34,-78,-121,-57,127,127,127,127,24,9,53,88,107,101,35,-90,-128,-128,-128,-128,
-128,-125,-128,-128,-128,-128,-122,-57,4,19,19,-21,-43,-44,-61,-68,-67,-20,46,99,127,127,64,-10,-119,-128,-128,-128,-128,-128,
-128,-128,-128,-122,-72,-41,-90,-128,-128,-62,102,127,127,126,16,-2,1,15,-9,-84,-128,-128,-128,-128,-127,-90,-93,-128,-128,-128,
-128,-128,-121,-90,-58,-50,-19,-40,-55,-31,-49,-73,-67,9,96,127,123,104,18,-40,-127,-128,-128,-128,-128,-128,-128,-128,-128,-128,
-62,-21,-69,-125,-122,-28,75,117,127,101,27,18,-45,-68,-111,-128,-128,-127,-69,-64,-37,-91,-128,-128,-128,-118,-84,-55,-14,35,
89,83,86,50,-17,-38,-48,-56,-46,15,55,68,87,69,-37,-13,-42,-80,-74,-71,-69,-63,-91,-88,-84,-64,-31,-72,-128,-128,
-128,-62,-4,22,73,24,-18,0,-40,-76,-103,-54,-6,11,-12,-80,-128,-128,-128,-128,-119,-54,16,68,115,127,127,127,108,83,
39,31,9,-18,-33,-12,-6,25,67,39,-8,-15,-65,-85,-32,22,59,91,71,34,-7,-15,-29,-128,-128,-128,-128,-128,-128,-116,
-64,-75,-75,-16,-33,-53,-2,50,57,28,-90,-128,-128,-128,-128,-109,-48,17,72,108,127,127,127,99,55,81,76,62,-11,-46,
-82,-79,-43,2,17,-4,-36,-36,-51,-70,-70,-51,-6,36,65,83,99,91,34,-90,-128,-128,-128,-128,-128,-128,-128,-128,-51,-22,
4,67,92,77,39,-47,-128,-128,-108,-97,-92,-59,-3,36,59,83,101,97,98,34,0,58,77,61,-67,-72,-88,-108,-91,-21,
18,-4,-8,-10,-22,-28,-26,-24,-5,15,-25,33,100,99,61,15,-42,-74,-69,-48,-27,-44,-47,-17,42,46,76,127,127,59,
-6,-90,-128,-112,-32,-29,-35,-26,-2,1,7,31,42,40,28,-35,-35,13,23,24,-19,-17,-24,-75,-115,-71,-26,-42,-27,-31,
-41,-43,-33,-27,-13,5,-21,-6,35,44,59,112,124,93,55,39,37,31,44,61,65,33,127,127,123,37,-26,-89,-95,-36,
-1,13,-1,-21,-33,-49,-43,-18,-16,1,-27,-87,-37,-5,0,59,82,37,0,-46,-106,-98,-57,-63,-75,-69,-77,-76,-57,-43,
-24,6,4,7,21,10,28,87,120,119,100,61,45,30,38,34,23,3,125,127,119,49,3,-45,-50,-16,5,23,11,-12,
-25,-37,-45,-35,-39,1,-15,-72,-11,-13,-7,85,67,-4,-33,-32,-80,-102,-84,-103,-98,-85,-90,-83,-57,-51,-46,-18,-30,-28,
-6,16,42,57,67,85,48,-2,-39,-53,-19,-7,-8,-11,103,127,101,66,34,-4,-24,-26,5,12,-4,-19,-10,-14,-24,-24,
-16,12,3,-62,-19,-26,-4,81,33,-46,-64,-23,-61,-98,-86,-125,-104,-91,-99,-89,-58,-54,-53,-25,0,12,38,54,44,36,
54,84,56,22,-34,-75,-34,-17,-6,8,101,126,116,94,48,1,-40,-26,-8,-5,-23,-21,6,10,0,-8,-7,16,12,-60,
-39,-30,44,98,33,-13,-60,-28,-34,-77,-73,-102,-61,-46,-67,-88,-41,-2,-4,24,85,117,107,59,34,49,65,82,72,33,
-61,-91,-31,-5,11,15,100,127,127,103,61,5,-62,-56,-22,-21,-38,-23,13,23,19,17,19,35,48,-36,-40,10,127,127,
101,13,-60,-24,-20,-64,-45,-57,-30,-24,-39,-34,31,55,22,18,67,107,121,70,21,35,61,82,62,27,-82,-125,-53,-18,
7,9,94,127,127,95,40,-9,-74,-36,-30,0,-18,-20,16,39,40,31,37,46,77,-10,-60,34,127,127,127,76,32,33,
-7,-27,-12,-20,-9,9,1,37,70,87,70,-45,4,106,119,42,-21,-22,36,83,63,31,-62,-126,-83,-25,-4,14,103,127,
127,78,33,-14,-73,-33,-7,24,10,7,40,62,65,50,57,86,125,21,-75,2,127,127,127,81,74,69,6,-21,-1,-6,
-24,39,27,19,41,93,90,-43,-22,75,105,33,-55,-66,-1,57,71,40,-54,-125,-86,-25,-5,13,102,127,119,68,23,-20,
-81,-51,-8,29,29,32,59,77,79,62,67,117,127,18,-102,-51,66,123,118,92,82,58,-4,-7,8,-31,-6,71,52,18,
45,111,107,-12,-4,71,103,44,-55,-87,-28,44,82,50,-51,-128,-98,-43,-19,5,96,127,126,74,19,-33,-99,-84,-29,13,
29,40,59,73,77,63,78,127,127,10,-109,-97,-22,4,22,5,-16,-45,-59,-3,24,-51,-31,43,30,15,78,127,127,18,
34,103,113,59,-26,-75,-33,53,99,65,-46,-128,-111,-64,-33,3,103,127,126,78,13,-58,-128,-116,-55,-11,6,20,42,62,
75,67,81,127,127,21,-83,-114,-89,-105,-126,-123,-114,-110,-94,-30,-29,-127,-98,0,14,10,101,127,127,13,42,127,127,62,
-4,-49,-24,68,127,92,-29,-125,-109,-69,-38,11,114,127,116,76,3,-85,-128,-128,-73,-29,-17,-8,21,55,78,73,86,127,
117,-7,-108,-128,-114,-128,-125,-109,-83,-65,-51,-23,-56,-128,-128,-31,8,9,110,127,127,-15,34,127,127,77,19,-15,0,87,
127,123,-4,-108,-95,-67,-43,11,117,127,127,75,-14,-103,-128,-128,-85,-24,-15,-15,10,40,65,76,104,127,127,-8,-128,-128,
-128,-128,-96,-75,-57,-16,-7,-9,-44,-128,-128,-107,-47,-5,108,127,127,-27,16,127,127,78,1,-4,32,113,127,127,15,-113,
-90,-61,-31,10,117,127,127,77,-12,-102,-128,-128,-82,-20,-12,-14,10,41,65,75,104,124,127,-12,-128,-128,-128,-128,-126,-100,
-75,-32,-29,-36,-64,-128,-128,-119,-63,-18,101,127,127,-25,18,127,127,78,2,-1,37,118,127,127,16,-113,-89,-61,-31,11,
113,127,111,81,14,-80,-128,-122,-59,-18,-9,-4,26,65,85,72,90,127,116,-13,-117,-128,-128,-128,-128,-128,-121,-93,-84,-64,
-95,-128,-128,-60,-24,-15,102,127,127,-6,45,127,127,82,41,8,20,102,127,124,-6,-98,-90,-70,-55,9,97,127,123,86,
26,-51,-123,-103,-39,7,24,31,47,69,80,64,76,127,127,10,-96,-128,-128,-128,-128,-128,-128,-128,-119,-53,-51,-128,-107,-11,
2,2,102,127,127,23,51,127,124,67,25,-13,3,88,127,93,-30,-114,-104,-74,-51,8,87,127,123,79,29,-30,-95,-69,
-14,35,53,56,67,78,77,55,66,125,127,8,-115,-127,-58,-9,18,-12,-40,-78,-84,-19,5,-66,-31,46,34,19,91,127,
127,30,40,90,95,64,3,-40,-11,66,102,69,-42,-123,-107,-70,-48,-3,97,127,113,66,23,-27,-84,-37,8,51,56,52,
71,86,81,54,57,103,127,21,-113,-84,39,117,120,89,71,31,-27,-19,2,-26,6,75,51,18,61,127,117,-6,4,63,
95,52,-32,-64,-18,49,86,59,-43,-116,-100,-55,-41,-9,96,127,120,68,20,-31,-83,-22,16,48,37,30,55,73,69,41,
39,67,125,29,-91,-28,112,127,114,67,69,65,7,-19,3,14,3,49,25,16,58,116,89,-53,-17,74,109,44,-42,-56,
-2,57,69,46,-48,-116,-92,-41,-31,-6,82,127,127,83,20,-31,-86,-29,-2,24,9,5,32,48,41,19,18,34,88,14,
-59,28,127,127,127,64,29,37,5,-24,-15,-9,14,19,3,33,87,112,67,-58,5,108,123,50,-15,-22,24,71,52,28,
-61,-120,-88,-41,-30,-4,86,121,122,91,34,-20,-76,-44,0,5,-8,4,31,35,22,8,2,28,62,-3,-23,28,127,127,
87,12,-47,-13,1,-44,-47,-57,-17,-16,-35,-32,39,72,28,2,56,119,123,67,23,28,44,63,49,20,-77,-114,-61,-34,
-26,-11,93,103,103,86,27,-22,-58,-22,13,21,9,13,34,31,13,-8,-22,10,22,-33,-25,-15,57,81,19,-11,-55,-26,
-8,-50,-70,-99,-47,-31,-60,-99,-52,3,7,28,75,127,108,55,38,45,50,61,60,26,-58,-82,-38,-25,-29,-13,99,127,
79,52,16,-25,-36,-29,17,30,24,17,24,11,-8,-21,-23,2,9,-41,-10,-10,20,89,42,-47,-71,-25,-47,-84,-87,-127,
-102,-90,-102,-98,-73,-64,-53,-24,1,22,47,66,52,29,44,71,44,16,-33,-76,-46,-36,-45,-11,126,127,101,34,-17,-63,
-54,-14,10,40,44,32,19,1,-17,-20,-39,-7,-20,-59,-7,-9,16,109,68,-10,-42,-35,-75,-105,-95,-109,-104,-87,-94,-98,
-81,-68,-51,-21,-22,-18,0,20,45,53,59,66,38,-8,-42,-55,-29,-30,-48,-25,127,127,112,23,-42,-96,-86,-33,-1,23,
25,16,5,-14,-12,6,-7,1,-38,-80,-33,-14,14,90,84,31,-8,-45,-105,-108,-68,-67,-91,-80,-88,-96,-82,-60,-27,8,
10,9,23,18,37,88,112,107,106,65,49,34,35,19,-11,-9,81,127,127,57,-14,-87,-127,-99,-27,-24,-20,0,26,25,
26,46,54,45,12,-36,-26,9,29,37,-7,-19,-34,-80,-120,-83,-36,-48,-38,-42,-57,-66,-58,-47,-26,-3,-20,-4,44,61,
80,127,127,99,55,28,20,8,23,40,30,14,-7,75,112,92,41,-50,-128,-128,-92,-88,-81,-39,22,58,74,91,98,90,
70,16,0,62,89,71,-46,-64,-97,-118,-102,-38,-2,-25,-20,-26,-40,-43,-35,-30,-11,13,-26,42,122,127,115,74,12,-25,
-33,-28,-17,-43,-44,-20,18,33,-49,-60,3,66,70,31,-90,-128,-128,-128,-126,-94,-32,32,77,106,127,127,127,88,63,110,
115,95,16,-26,-75,-76,-48,-15,-3,-29,-61,-52,-57,-60,-44,-25,12,53,80,106,127,127,109,-7,-96,-85,-109,-109,-119,-128,
-128,-128,-76,-31,-41,-83,-104,-45,-3,17,-11,-83,-128,-128,-128,-128,-114,-50,14,60,105,127,127,124,111,117,86,74,47,12,
-20,-7,-5,9,39,10,-17,-14,-51,-63,-3,45,72,104,100,55,4,4,14,-82,-128,-128,-128,-128,-125,-115,-70,-74,-72,-22,
-28,-66,-117,-128,-128,-128,-81,-74,-41,-98,-128,-128,-128,-121,-91,-63,-34,9,51,60,85,84,26,-2,-25,-33,-32,28,64,70,
89,73,-40,-10,-37,-72,-57,-54,-58,-45,-74,-75,-74,-46,-5,-45,-124,-128,-128,-39,9,21,67,35,2,2,18,29,-13,-97,
-128,-128,-128,-128,-128,-108,-104,-128,-128,-128,-128,-128,-128,-117,-92,-71,-20,-16,-22,-4,-40,-77,-81,-1,102,127,127,97,25,-40,
-119,-128,-128,-128,-128,-128,-128,-128,-128,-128,-63,-10,-32,-74,-85,-11,94,127,127,123,52,24,71,110,114,92,12,-118,-128,-128,
-128,-128,-128,-128,-128,-128,-128,-128,-128,-79,-32,-17,-2,-19,-32,-38,-49,-55,-58,-13,57,113,127,127,78,-1,-97,-127,-113,-102,
-115,-128,-128,-128,-123,-120,-59,-18,-54,-128,-98,-36,108,127,127,127,26,-1,46,96,127,127,123,33,-59,-102,-118,-128,-128,-127,
-60,-21,-8,10,68,97,127,110,34,-38,-46,-41,-16,-13,-9,17,56,91,124,127,71,-5,-64,-86,-77,-81,-91,-100,-39,-24,
-18,-25,-21,-10,-14,-39,-61,-3,127,127,127,121,9,-6,21,80,127,127,127,108,65,17,-10,-34,-46,-40,-14,23,54,113,
127,127,127,127,127,72,7,-63,-86,-60,-9,51,86,96,78,44,-1,-7,9,31,23,4,3,17,34,39,26,-5,-23,-3,
11,30,-17,-2,111,127,127,74,-22,-17,57,115,127,127,127,118,96,90,71,53,17,-24,-48,-33,-9,33,39,69,119,124,
87,57,37,-9,-21,-11,-1,11,12,16,33,30,54,66,85,76,23,-16,-10,5,-6,2,1,0,-3,14,23,48,15,-5,
66,103,104,82,11,14,12,53,73,94,81,68,62,77,79,77,51,10,-29,-37,-27,-16,-46,-36,-34,-44,-48,-7,35,36,
64,59,39,29,31,33,43,32,50,76,81,50,13,-1,-2,-9,8,10,4,14,18,20,17,27,38,-7,25,54,47,58,
10,-5,54,123,92,97,85,38,23,25,12,23,12,-3,-19,-17,-5,16,46,77,94,65,51,29,-4,-25,-42,-8,31,40,
7,-36,-59,-69,-56,-71,-71,-91,-115,-122,-128,-126,-118,-116,-120,-121,-128,-100,-88,-89,-106,-62,-104,-128,-128,-67,-128,-128,126,127,
127,127,105,89,92,88,33,18,-12,-50,-80,-48,16,112,127,127,79,8,-63,-128,-128,-126,-6,95,127,127,123,91,50,21,
2,20,34,30,36,36,10,-20,-40,-42,-49,-54,-55,-15,-16,-44,-110,-106,-128,-128,-48,-22,-128,-128,127,127,127,119,94,82,
42,21,-39,-48,-52,-40,-14,33,41,47,-1,-55,-128,-128,-128,-128,-128,-128,-14,127,127,92,-7,-79,-105,-98,-32,-18,-22,4,
97,127,127,127,127,101,72,44,8,13,3,-25,-50,-100,-128,-102,1,-10,-128,-128,127,127,127,30,-36,-77,-124,-104,-43,34,
123,127,127,64,30,3,-127,-128,-128,-128,-128,-128,-128,-128,-82,87,125,37,-70,-128,-128,-128,-102,-98,-128,-126,-46,42,105,110,
111,63,29,32,44,32,-2,-39,-85,-128,-128,-100,11,17,-128,-128,102,98,-8,-113,-128,-128,-128,-3,127,127,99,110,80,47,
51,20,-18,-69,-104,-75,-51,-55,-89,-109,-79,26,62,81,91,19,-51,-87,-90,-128,-128,-128,-92,-56,-37,-58,-28,-11,-22,-14,
79,123,79,-14,-112,-128,-123,-29,10,4,-120,-128,22,10,-85,-128,-128,-59,45,127,73,-17,-69,-26,-8,11,61,89,127,93,
77,90,52,-12,-63,-50,-16,5,-43,-14,52,13,-43,-49,10,-29,-93,-97,-96,-114,-109,-110,-79,-21,-26,-26,74,119,94,19,
-48,-38,8,83,80,23,-98,-106,-33,-43,-56,-14,44,127,121,47,-24,-31,-31,4,46,94,127,127,127,127,127,127,120,74,
5,34,127,117,20,-14,15,36,54,72,105,85,15,-58,-89,-64,-52,-73,-31,63,75,98,112,75,63,85,86,106,127,127,
127,0,-93,-82,-76,-43,-9,83,91,50,-4,6,33,14,3,39,90,124,127,127,127,127,127,127,127,127,4,-27,62,53,
35,66,115,117,115,127,64,127,102,-13,-53,23,61,31,118,127,105,126,127,111,78,61,90,90,127,127,98,15,-51,-45,
-70,-12,64,123,37,-45,-42,6,57,28,18,34,59,79,109,127,127,110,78,89,60,14,-25,-43,55,65,85,81,84,83,
65,75,60,59,46,19,8,24,29,16,25,114,127,127,127,127,65,42,59,111,118,56,37,-43,-63,-38,-44,60,52,-12,
-85,-73,-3,52,40,27,18,19,45,76,85,73,52,38,26,22,-35,-42,7,36,32,33,56,49,15,-12,-26,-2,22,24,
27,25,32,47,41,29,3,-46,-4,96,125,48,-12,-38,-42,-25,-17,-70,-59,-100,-94,-46,18,120,25,-90,-116,-65,-19,-16,
-19,-24,-24,-16,20,59,71,60,31,19,-6,-44,-76,-13,75,92,64,42,48,31,-6,-28,-47,-46,-5,-2,-5,-18,-11,8,
9,0,-6,-45,-78,-81,-64,-69,-83,-99,-98,-91,-59,-73,-26,-38,-33,-8,85,88,-34,-73,-64,-43,-30,-57,-44,-52,-46,-31,
2,35,47,39,66,53,-11,-100,-71,65,122,94,59,41,47,17,-15,-14,-36,-68,-5,-6,-17,-28,-28,-26,-34,-32,-39,-68,
-97,-78,-40,-47,-65,-79,-32,4,45,20,42,40,64,53,70,11,-56,-17,-24,-44,-31,-43,-78,-79,-43,-7,18,27,36,46,
45,36,-39,-128,-65,107,127,109,89,55,47,2,-28,6,3,-46,2,-16,-32,-37,-40,-62,-67,-33,-24,-85,-105,-57,-19,-33,
-44,-68,-60,31,96,106,127,113,111,37,-14,-30,-27,25,6,-8,-10,-44,-125,-109,-38,28,53,39,17,11,8,23,-20,-128,
-70,63,80,76,58,30,35,-3,-28,11,18,-23,-4,-36,-72,-79,-73,-89,-64,13,61,-39,-83,-48,-45,-50,-14,-28,-66,9,
36,60,108,100,127,57,-49,-15,10,27,6,17,-21,-82,-127,-93,-19,42,50,24,2,-25,-35,-23,-8,-117,-73,53,11,-19,
-21,-7,1,-52,-76,-5,34,-11,-40,-54,-91,-66,-48,-128,-105,40,60,-31,-103,-84,-59,-31,-20,-76,-98,-57,-32,18,68,95,
99,40,-20,1,20,31,6,1,-43,-78,-57,-36,3,32,39,27,2,-37,-28,-29,-32,-128,-60,88,8,-81,-92,-54,-6,-45,
-66,0,28,-19,-69,-64,-74,-36,-45,-128,-126,34,62,-30,-104,-76,-54,-67,-72,-96,-120,-107,-94,-37,25,61,79,43,-8,34,
26,33,-20,-56,-56,-27,-4,9,7,28,61,45,12,-12,-22,-27,-75,-128,-109,43,-4,-64,35,-51,-45,-62,-57,29,45,-6,
-69,-18,-3,-10,-41,-128,-128,-48,41,-3,-64,-51,0,-32,-69,-86,-116,-91,-122,-75,5,66,70,48,-2,34,23,23,-28,-54,
-52,-25,22,30,18,34,70,62,28,-2,-13,-46,-66,-128,-128,-23,19,50,10,-90,-112,-95,-14,83,52,-35,-40,52,107,103,
27,-113,-91,-54,18,-20,-76,-88,-28,-26,-54,-67,-84,-57,-115,-90,-9,70,84,63,16,41,19,15,-33,-57,-50,-21,45,49,
37,52,81,64,28,-6,-47,-86,-66,-105,-128,-91,-65,-12,-52,-59,-52,-40,19,20,-58,-106,-98,24,126,127,110,-42,11,32,
-51,-91,-125,-128,-80,-34,-52,-62,-63,-28,-101,-105,-30,66,94,74,28,45,13,5,-51,-82,-70,-34,48,49,47,70,88,62,
28,-2,-8,-76,-77,-62,-78,-77,-121,-128,-94,-18,2,-25,-29,-91,-128,-97,-112,17,127,127,127,13,101,116,-93,-128,-128,-128,
-99,-19,-23,-33,-37,7,-75,-106,-47,58,95,65,28,58,27,13,-52,-93,-79,-35,40,33,38,70,84,63,38,8,-22,-78,
-83,-40,-27,-8,-74,-128,-128,-65,-60,-84,-55,-52,-55,-6,-66,72,127,127,127,76,127,127,-70,-128,-128,-128,-76,5,3,3,
-2,39,-52,-100,-58,54,99,55,26,78,51,38,-31,-73,-56,-16,32,7,6,42,65,57,38,3,-80,-95,-61,-7,14,61,
53,-67,-75,-4,33,24,56,81,70,61,-54,81,127,127,127,106,127,127,-54,-128,-128,-128,-39,49,42,44,18,42,-61,-114,
-73,54,112,53,33,103,66,52,-18,-41,-27,7,23,6,-12,8,55,64,39,2,-91,-123,-79,20,52,82,127,96,127,127,
127,127,127,127,127,101,-13,48,127,127,127,117,127,127,9,-128,-128,-128,-20,87,60,65,32,15,-120,-128,-83,64,124,52,
35,104,65,51,-17,-36,-20,15,23,7,-11,10,60,69,41,1,-84,-124,-81,21,53,88,127,112,127,127,127,127,127,127,
115,95,-24,31,127,127,127,114,127,127,7,-128,-128,-128,-20,90,60,63,29,7,-128,-128,-85,66,126,51,33,75,49,36,
-23,-61,-35,8,39,6,7,49,69,58,35,-5,-83,-100,-59,-12,10,82,101,-25,-61,0,34,23,39,62,54,31,-83,55,
127,127,127,107,127,127,-62,-128,-128,-128,-35,55,39,33,13,29,-74,-128,-81,57,118,52,37,55,26,11,-47,-84,-58,-10,
53,33,36,71,81,59,33,-1,-27,-85,-83,-53,-30,22,-12,-128,-107,-46,-54,-77,-47,-46,-57,-24,-75,56,127,127,127,86,
127,127,-75,-128,-128,-128,-72,13,2,-4,0,26,-71,-120,-66,57,106,54,34,41,14,4,-50,-76,-51,-14,56,46,41,66,
77,53,22,-13,-21,-85,-76,-69,-69,-33,-65,-107,-87,-12,6,-7,4,-58,-121,-83,-104,17,127,127,127,32,107,113,-88,-128,
-128,-128,-94,-13,-26,-36,-44,-16,-105,-128,-57,60,100,64,17,38,24,16,-33,-53,-33,-6,42,38,27,44,65,49,17,-21,
-59,-91,-63,-108,-128,-65,-42,-7,-60,-54,-32,-6,59,62,-9,-45,-76,36,127,127,123,-25,19,27,-40,-64,-115,-128,-75,-25,
-52,-65,-86,-64,-128,-128,-36,71,103,76,3,36,33,28,-23,-48,-38,-16,7,9,1,22,51,42,11,-23,-17,-46,-61,-128,
-128,-27,23,55,16,-69,-74,-55,17,112,87,9,-23,61,127,127,54,-102,-83,-50,36,7,-71,-94,-33,-20,-59,-83,-114,-95,
-128,-103,-6,83,102,71,4,40,38,43,-7,-45,-41,-21,-21,-15,-12,15,41,23,-9,-33,-20,-24,-60,-128,-128,34,10,-54,
28,-30,-4,-19,-19,64,78,29,-55,-10,28,52,-4,-128,-128,-39,68,28,-54,-57,-12,-32,-79,-114,-128,-127,-128,-76,15,86,
94,60,-15,9,29,45,23,6,-23,-53,-57,-45,-11,25,28,4,-23,-51,-36,-29,-21,-128,-88,86,32,-77,-85,-29,34,-4,
-34,19,35,-10,-68,-57,-43,20,-4,-128,-128,35,85,5,-81,-71,-54,-67,-86,-127,-128,-128,-110,-35,35,81,97,51,-56,-17,
13,42,30,30,4,-49,-109,-87,-26,35,37,-3,-25,-39,-38,-20,2,-111,-108,43,24,-44,-44,-3,12,-41,-55,13,40,-9,
-52,-55,-73,-28,-14,-128,-105,51,84,-1,-85,-75,-63,-46,-48,-108,-128,-89,-51,16,69,101,105,43,-28,-55,-46,31,33,8,
16,-10,-97,-86,-31,20,39,23,-3,-2,4,22,-22,-128,-99,41,79,32,26,15,22,-9,-22,15,20,-11,-8,-38,-61,-65,
-66,-83,-59,14,65,-30,-72,-43,-53,-70,-46,-73,-109,-32,6,44,100,90,127,58,77,-13,-90,-31,-16,-34,-11,-28,-53,-59,
-35,-10,11,18,25,42,38,25,-54,-128,-93,78,127,100,76,52,40,-7,-35,-4,-5,-44,-3,-27,-38,-36,-37,-61,-72,-43,
-37,-87,-107,-77,-55,-65,-79,-119,-109,-12,79,105,127,127,123,40,115,74,-75,-104,-68,-31,-5,-43,-35,-44,-40,-28,3,34,
44,43,78,58,-23,-119,-96,44,123,108,76,59,50,8,-30,-35,-56,-85,-30,-37,-42,-40,-34,-36,-56,-61,-64,-93,-128,-119,
-75,-66,-80,-100,-75,-24,58,48,85,86,88,62,68,127,-17,-128,-128,-65,-2,0,-15,-22,-25,-17,20,62,74,66,50,38,
-7,-62,-83,-1,90,102,81,58,53,35,-7,-43,-72,-81,-44,-41,-33,-35,-26,-16,-29,-42,-47,-82,-104,-86,-43,-44,-81,-108,
-117,-105,-40,-48,13,6,-16,-9,19,112,41,-70,-128,-104,-10,66,51,37,21,14,36,74,89,80,62,52,32,14,-33,-12,
46,64,66,55,66,62,18,-28,-54,-38,-5,-4,4,6,9,16,2,-14,-39,-62,10,121,127,32,-57,-92,-77,-49,-16,-84,
-78,-94,-71,-24,-22,75,102,82,-19,-103,-84,-4,61,41,29,31,51,81,119,127,127,113,75,77,50,34,25,13,102,92,
104,107,95,65,34,41,24,28,26,-2,-17,0,-4,-25,-3,106,127,127,127,83,15,-11,33,117,127,95,49,-15,-17,-9,
-62,14,62,111,66,-19,-76,-39,10,9,12,42,82,116,127,127,127,127,127,127,127,127,42,27,85,65,53,89,127,116,
104,123,49,109,95,-8,-51,7,21,-24,45,60,52,104,127,109,66,46,91,127,127,127,127,31,-30,-30,-47,-48,-12,66,
93,125,68,0,-57,-46,-28,10,46,89,127,127,127,127,127,127,113,65,-4,17,127,65,-18,-31,0,24,43,62,86,88,
44,-38,-85,-71,-81,-123,-70,25,42,96,127,84,89,127,127,127,127,127,127,13,-94,-73,8,-15,-96,-98,-64,-8,59,127,
101,10,-34,21,28,37,80,100,127,107,83,80,42,-23,-92,-111,-96,-76,-101,-34,57,24,-25,-11,80,63,3,-31,-43,-63,
-72,-88,-76,-22,-34,-49,72,127,127,115,21,-9,32,113,127,46,-112,-108,81,73,-21,-103,-128,-128,-101,25,127,127,127,127,
109,67,60,15,-47,-98,-128,-108,-77,-66,-93,-118,-93,34,109,127,127,96,37,15,21,-42,-128,-128,-98,-73,-61,-75,-47,-25,
-24,-2,118,127,127,78,-32,-96,-108,-15,56,36,-118,-124,127,127,114,19,-41,-68,-94,-77,-25,44,117,127,127,70,30,-6,
-128,-128,-128,-128,-128,-128,-128,-113,-3,127,127,117,12,-78,-116,-123,-75,-95,-128,-128,-73,6,58,71,86,54,36,49,78,82,
54,27,-17,-109,-128,-101,41,76,-100,-128,127,127,127,86,70,57,22,0,-81,-96,-108,-96,-53,4,2,17,-23,-79,-128,-128,
-128,-128,-128,-128,-34,127,127,68,-28,-85,-102,-93,-30,-19,-29,-13,67,127,127,127,127,111,88,57,26,45,34,17,0,-54,
-127,-113,3,34,-126,-128,111,127,127,98,79,59,53,50,-1,-25,-60,-89,-105,-70,-24,87,127,113,73,13,-73,-128,-128,-128,
-87,19,65,58,64,52,26,2,-13,11,31,29,34,31,17,6,-3,-7,-18,-28,-34,16,14,-10,-70,-70,-121,-128,-67,-9,
-114,-128,57,120,81,77,65,20,1,0,-19,-2,-11,-18,-22,-21,-18,14,53,76,91,61,31,-1,-40,-70,-103,-57,-15,-1,
-21,-47,-59,-68,-47,-58,-55,-62,-79,-93,-100,-91,-88,-88,-94,-105,-119,-80,-68,-68,-81,-45,-99,-128,-128,-54,-102,-128,16,49,
-5,-46,-42,-29,-56,-44,-51,-28,-15,-29,-44,-46,-27,2,10,27,-5,-25,2,43,58,61,71,59,59,60,61,81,89,62,
61,20,8,38,71,82,97,90,113,108,108,104,94,93,87,83,90,127,104,72,93,20,-73,-42,53,8,-67,-68,-44,-51,
-86,-85,-70,-18,18,-3,-19,-5,17,35,44,70,69,83,96,80,39,32,6,47,81,92,106,127,127,107,79,27,-56,-103,
-98,-83,-40,-10,18,40,58,59,54,74,93,98,127,127,115,23,-16,-114,-128,-128,65,43,-4,-7,15,6,-21,14,69,88,
80,27,7,22,26,20,62,70,50,34,4,-52,-121,-128,-81,50,127,127,127,127,127,127,127,92,-24,-124,-128,-128,-128,-125,
-100,-58,-13,14,25,33,41,52,111,96,-32,-128,-128,-128,-128,-128,78,65,-1,-16,10,31,30,98,106,75,28,-9,0,36,
52,39,22,45,56,18,-70,-128,-128,-128,-128,-128,-20,56,127,127,127,127,127,127,106,35,-60,-128,-128,-128,-128,-128,-102,-73,
-8,54,84,122,119,28,-128,-128,-128,-128,-128,-78,92,44,-41,-38,24,16,-37,-21,-11,-9,5,26,41,47,49,32,33,44,
71,62,16,-35,-122,-128,-128,-128,-128,-128,-55,8,54,86,127,127,127,127,106,-54,-110,-90,-70,-62,-59,-48,-24,0,58,127,
93,-11,-128,-128,-128,-128,8,20,20,17,-3,1,-27,-95,-107,-27,-1,23,61,69,31,0,0,3,34,56,97,100,69,25,
-58,-128,-128,-128,-128,-128,-73,-61,-62,-39,48,97,127,127,78,-70,-128,-128,-110,-59,-9,10,-10,-33,30,106,99,3,-128,-128,
-97,56,127,102,13,17,-19,-19,-27,-50,-18,41,94,91,73,30,-15,-26,1,33,39,78,124,127,86,25,-17,15,5,-124,
-128,-128,-105,-57,-22,-47,-53,-37,28,104,61,-87,-128,-128,-128,-123,-82,-49,-53,-45,25,62,57,-20,-76,-58,24,126,127,113,
-5,-2,-78,-84,-28,33,73,87,63,25,-21,-49,-46,-28,-10,3,40,61,124,127,63,19,16,51,25,-60,-80,-74,-91,-42,
-17,-84,-79,-89,-70,-24,-13,-81,-128,-111,-51,-48,-67,-85,-67,-2,36,39,104,45,3,-20,46,90,107,67,13,-57,-75,4,
40,97,71,25,0,-49,-65,-29,-2,-2,5,18,56,78,126,78,16,25,41,90,39,-54,-97,-88,-117,-98,-42,-60,-77,-73,
-61,-52,-50,-77,-111,-111,-64,-26,-5,23,80,127,127,127,127,127,105,41,53,20,36,10,9,-22,13,111,118,99,20,-36,
-73,-83,-57,-1,35,37,36,42,39,56,121,89,45,61,81,127,87,-25,-64,-64,-73,-30,-9,-69,-35,-13,-15,-31,-23,-33,
-68,-76,-59,-59,-39,25,110,127,127,127,127,127,117,-16,-38,-42,6,-8,-10,32,112,127,108,54,-11,-31,-85,-69,-23,33,
67,70,56,48,51,70,127,120,71,60,79,127,127,21,-11,-48,-105,-68,-33,-64,-67,-21,-24,-45,-24,12,30,47,52,-10,
-65,-50,-4,32,81,115,101,48,11,-69,-55,-39,4,-28,20,114,127,127,20,10,-23,-51,-71,-43,-2,25,42,57,59,60,
81,71,127,82,43,34,79,127,105,-1,-10,-35,-93,-86,-59,-46,-78,-31,-33,-40,5,56,86,100,83,22,-62,-84,-52,-13,
11,24,12,-8,-10,-59,-36,-3,67,48,76,127,127,54,-26,-20,-54,-88,-66,-21,16,6,-2,11,22,29,91,109,127,39,
-24,3,93,127,60,-26,-22,-6,-43,-74,-85,-65,-60,-23,-16,18,89,127,116,87,72,23,-19,-7,26,32,33,58,-24,-44,
-37,-55,-27,-4,89,87,117,127,57,32,-3,-59,-101,-99,-64,-12,19,-11,-27,-10,2,6,70,107,112,-32,-61,32,127,122,
100,6,-28,-21,-48,-67,-73,-69,-17,13,32,98,127,127,127,88,62,10,-24,-9,33,59,51,60,14,-24,-38,-55,-30,-11,
80,66,116,100,14,23,-22,-83,-97,-87,-48,4,3,-26,-21,-17,-21,-9,11,84,85,-54,-72,22,127,40,82,-31,-54,-47,
-69,-68,-64,-96,-26,23,47,127,127,127,127,85,68,-7,-36,-32,-7,15,36,24,30,-18,-3,-48,-31,-1,103,79,98,64,
4,15,-27,-52,-74,-100,-23,17,3,-24,-19,-31,-46,-34,5,93,93,-36,-43,16,83,-62,-104,-128,-117,-113,-128,-128,-101,-116,
-37,22,51,115,127,127,127,116,105,-4,-49,-62,-57,-26,15,7,39,-3,20,-16,3,33,116,57,47,-6,-46,-29,2,-21,
-71,-61,-8,17,20,8,-4,-26,-36,-47,-8,72,118,6,-53,-17,-7,-128,-128,-128,-128,-127,-128,-123,-106,-88,15,39,54,93,
123,89,127,127,91,-91,-128,-118,-61,-44,-45,-50,-22,-9,27,-38,-11,24,126,62,18,-43,-74,-37,-1,-18,-61,-46,-6,29,
36,19,4,-18,-29,-36,-11,67,119,17,-57,-57,-48,-128,-124,-128,-128,-103,-114,-110,-75,-24,38,61,51,79,84,38,97,127,
68,-122,-128,-95,-33,-38,-60,-82,-53,-20,28,-41,-21,22,127,78,-11,-71,-93,-58,-26,-25,-44,-21,2,44,58,42,23,-11,
-29,-34,-2,70,108,15,-55,-74,-26,-27,-56,-128,-128,-101,-61,-30,-8,2,35,118,109,93,48,-3,59,99,6,-128,-128,-54,
13,-21,-66,-102,-87,-33,34,-39,-38,2,127,69,-35,-81,-98,-82,-52,-23,-15,10,26,65,78,64,40,-8,-36,-40,-17,63,
116,50,-19,-62,-4,27,-19,-128,-102,-9,6,5,2,-20,7,127,122,75,2,-40,30,42,-92,-128,-128,-23,43,-11,-59,-109,
-119,-57,31,-31,-45,-12,127,65,-44,-78,-86,-77,-45,11,45,69,69,97,94,70,41,-13,-40,-41,3,59,120,84,23,-24,
17,-30,-75,-116,-56,1,-12,-35,-66,-115,-31,76,17,-11,-41,-68,-21,-50,-128,-128,-128,-24,44,-25,-72,-128,-128,-86,12,-32,
-51,-20,127,75,-56,-85,-83,-64,-25,49,97,117,104,119,101,69,30,-19,-39,-38,10,64,127,107,37,-12,33,-68,-47,-84,
-80,-59,-49,-54,-64,-79,-12,50,-50,-43,-13,-54,-69,-128,-128,-128,-128,-48,23,-55,-96,-128,-128,-108,-14,-46,-66,-38,127,73,
-53,-92,-92,-69,-30,68,126,127,127,127,111,85,42,-14,-36,-46,-31,77,127,94,3,-40,20,-44,-42,-46,-81,-97,-60,-25,
-29,-24,-41,56,-42,-13,39,-20,-95,-128,-128,-128,-128,-74,30,-53,-105,-128,-128,-128,-16,-42,-80,-61,124,64,-53,-93,-94,-69,
-28,70,127,127,127,124,109,86,44,-12,-37,-50,-32,81,127,90,-2,-44,19,-44,-49,-55,-95,-110,-62,-18,-21,-20,-39,62,
-36,-9,45,-14,-98,-128,-128,-128,-128,-74,36,-47,-103,-128,-128,-128,-17,-42,-80,-61,124,64,-55,-89,-86,-59,-12,58,101,114,
89,111,98,67,32,-18,-44,-45,5,66,127,109,30,-32,12,-92,-63,-102,-103,-84,-64,-49,-43,-66,-13,52,-47,-48,-7,-38,
-64,-128,-128,-128,-128,-42,27,-52,-99,-128,-128,-119,-28,-54,-65,-36,121,70,-43,-81,-90,-74,-35,20,46,57,54,92,96,75,
46,-12,-44,-44,-1,67,127,83,12,-56,-22,-61,-103,-128,-74,-1,-6,-27,-50,-103,-22,88,21,-24,-47,-45,-6,-48,-128,-128,
-128,-18,49,-25,-73,-127,-128,-104,-8,-43,-52,-20,127,71,-31,-81,-100,-78,-44,-17,-19,-11,8,62,84,71,45,-7,-40,-42,
-18,74,127,53,-28,-95,-49,-6,-54,-128,-116,-2,14,5,5,-18,19,127,124,66,-8,-21,46,44,-85,-128,-128,-8,55,-9,
-59,-98,-119,-69,15,-42,-46,-10,125,63,-3,-68,-95,-56,-20,-25,-52,-46,-12,48,69,50,31,-8,-33,-36,2,88,127,19,
-75,-118,-70,-46,-70,-128,-128,-104,-57,-35,-9,6,21,95,101,100,47,9,73,111,26,-128,-104,-20,38,-12,-57,-84,-72,-37,
23,-48,-39,5,127,69,34,-36,-78,-39,1,-19,-68,-68,-15,37,49,28,13,-13,-32,-36,-3,86,127,16,-92,-116,-95,-128,
-117,-128,-128,-128,-128,-122,-85,-36,20,32,37,80,75,36,106,127,89,-82,-94,-46,1,-20,-41,-60,-36,-26,16,-51,-24,25,
127,75,69,10,-48,-36,0,-23,-76,-80,-17,27,31,15,4,-22,-40,-46,1,92,127,10,-82,-66,-46,-128,-128,-128,-128,-128,
-128,-128,-120,-108,-1,16,30,74,101,79,127,127,96,-65,-93,-72,-31,-25,-19,-26,-11,-23,11,-48,-14,23,112,52,108,79,
3,-1,-23,-50,-79,-105,-25,29,22,-5,-1,-19,-42,-31,20,116,123,-20,-57,-12,58,-95,-128,-128,-128,-128,-128,-128,-122,-128,
-64,-14,8,79,127,127,127,108,96,-6,-37,-43,-35,-10,32,19,32,-23,2,-36,-8,21,95,40,118,115,26,14,-17,-73,
-96,-91,-40,24,28,0,5,1,-13,-3,28,110,99,-53,-77,14,127,44,75,-48,-67,-71,-95,-85,-83,-114,-45,-10,0,107,
127,127,127,80,71,-1,-24,-20,4,25,52,35,24,-38,-18,-63,-37,-4,87,63,111,127,67,34,0,-54,-102,-116,-60,5,
50,20,-3,7,9,8,77,127,114,-42,-53,52,127,127,94,9,-26,-37,-66,-78,-82,-74,-29,-9,8,76,127,127,127,85,
68,26,-1,3,42,80,69,63,16,-28,-46,-56,-23,1,76,55,69,127,127,62,-27,-26,-54,-105,-82,-20,40,36,18,21,
21,29,93,121,127,29,-20,18,98,127,59,-8,-2,-10,-54,-79,-89,-68,-74,-41,-30,12,85,118,107,88,74,43,18,24,
47,48,40,52,-44,-48,-25,-40,-19,4,80,74,20,110,127,127,41,5,-32,-61,-88,-49,11,49,61,58,44,40,62,64,
115,74,44,47,91,127,91,5,2,-39,-101,-87,-62,-50,-85,-38,-37,-36,12,55,76,95,86,50,-9,-29,-8,14,20,23,
-1,-3,8,-44,-31,9,67,39,-18,29,97,127,127,62,-13,-31,-89,-76,-21,46,80,66,32,16,30,53,122,103,65,66,
102,127,127,27,-8,-64,-122,-72,-32,-55,-71,-26,-28,-40,-11,19,29,45,65,24,-21,-12,32,64,86,96,84,34,-2,-76,
-59,-24,19,-25,-8,-37,-13,94,127,117,39,-28,-65,-82,-59,-1,38,35,27,32,24,39,93,75,36,63,106,127,77,-32,
-75,-88,-94,-40,-16,-61,-31,-11,-18,-29,-13,-23,-59,-67,-49,-46,-21,40,122,127,127,127,127,127,97,-43,-70,-44,27,3,
-1,-73,-110,-28,30,104,101,52,23,-31,-57,-33,-7,-5,3,16,52,63,98,61,1,29,71,102,22,-67,-104,-97,-123,-102,
-50,-60,-77,-73,-61,-53,-61,-98,-126,-119,-57,-21,2,13,50,125,127,127,127,127,104,33,15,-3,48,23,-25,-43,-112,-112,
-50,27,88,113,103,57,-2,-44,-53,-41,-23,-7,28,53,108,117,56,36,46,69,17,-72,-100,-84,-101,-68,-37,-90,-95,-102,
-68,-14,-19,-91,-128,-107,-70,-62,-74,-98,-88,-19,30,37,83,29,0,-14,43,101,127,84,-23,-28,-61,-48,-44,-60,-21,47,
109,115,101,56,-2,-30,-12,16,30,74,106,111,84,46,14,42,27,-101,-128,-128,-104,-62,-20,-48,-45,-29,52,127,62,-105,
-128,-128,-128,-128,-95,-55,-50,-37,40,82,46,-30,-76,-63,21,127,127,127,-25,-40,-50,-41,-50,-99,-111,-44,-33,8,59,71,
30,-6,-7,-10,9,36,74,63,34,13,-56,-128,-111,-128,-128,-128,-60,-45,-37,-8,86,127,127,127,78,-83,-128,-128,-128,-79,
-15,19,12,-19,26,105,86,-8,-128,-128,-73,61,127,110,44,-24,-102,-93,-27,-28,-67,-36,-16,-31,-37,-20,5,18,23,5,
8,19,35,14,-29,-56,-103,-128,-128,-128,-128,-93,-26,21,63,95,127,127,127,127,67,-81,-128,-126,-114,-95,-75,-55,-28,-6,
51,127,97,-9,-128,-128,-128,-125,35,38,36,4,-64,-66,-30,-10,-6,71,103,75,24,-21,-24,0,14,0,7,43,68,42,
-36,-113,-128,-128,-128,-80,11,77,127,127,127,127,127,127,62,-14,-99,-128,-128,-128,-128,-128,-112,-76,-10,50,75,107,118,31,
-126,-128,-128,-128,-104,-64,54,20,-38,-50,-21,-19,-37,2,66,93,94,43,13,15,14,9,52,79,84,87,65,2,-78,-115,
-46,61,127,127,127,127,127,114,70,35,-60,-128,-128,-128,-128,-128,-123,-81,-34,-9,5,21,28,32,84,72,-35,-128,-128,-128,
-128,-128,42,1,-74,-74,-57,-67,-103,-98,-73,-14,22,3,-2,17,31,37,55,81,81,94,107,91,58,64,34,64,85,78,
73,77,65,40,16,-29,-99,-128,-128,-110,-67,-37,-18,1,17,14,9,32,47,46,87,122,65,-22,-51,-121,-128,-128,24,52,
-5,-35,-32,-22,-53,-43,-50,-29,-20,-35,-48,-46,-22,4,27,45,15,-4,19,47,60,69,86,60,52,53,55,65,60,31,
30,-2,-14,16,54,72,83,75,98,91,88,82,71,74,70,66,70,112,95,63,85,16,-40,-32,26,43,70,98,86,82,
74,51,54,29,-25,-82,-98,-78,-52,-12,25,-6,8,43,46,19,-39,-116,-80,-50,-1,17,19,24,19,31,44,55,12,-69,
-109,-73,-92,-66,-45,-50,-75,-82,-81,-60,-43,-49,-49,63,104,88,77,33,1,-52,98,127,127,127,127,119,96,59,-30,-128,
-128,-128,-128,-86,6,106,127,127,127,127,66,-41,-128,-128,-128,-128,-97,-44,15,38,22,17,70,56,5,-61,-76,-25,-12,5,
-33,-22,-41,-69,-108,-83,-74,-87,-13,79,127,127,127,60,12,-41,127,127,127,127,106,39,-26,-128,-128,-128,-128,-107,58,127,
127,127,127,127,117,22,-32,-79,-122,-95,-51,11,81,111,100,56,24,45,101,88,36,1,-3,33,88,127,127,127,101,31,
-41,-49,-56,-51,-2,15,87,101,45,-39,-53,-73,118,127,127,59,-64,-128,-128,-128,-128,-77,97,127,127,127,127,127,93,46,
-8,-86,-128,-128,-128,-81,-121,2,114,127,54,-7,26,96,127,127,92,38,67,57,72,127,127,127,120,100,44,-14,-34,27,
21,-28,-28,9,-64,-128,-128,-128,127,127,30,-119,-128,-128,-128,-128,84,127,127,127,127,127,99,86,90,51,34,8,-28,-62,
-109,-128,-128,-68,62,112,14,-86,-77,-21,93,66,-34,-63,52,67,30,25,71,124,114,95,102,51,10,10,31,2,30,68,
-123,-128,-128,-128,104,80,-38,-128,-128,-128,-53,88,121,115,81,38,29,42,24,27,32,10,22,40,0,-24,-23,-38,-108,-62,
45,93,32,-18,-27,-36,-8,17,-10,-63,-47,-51,-64,-43,1,42,-18,-34,39,83,122,126,67,39,39,-43,-128,-128,-128,-70,
47,20,-62,-115,-111,18,89,112,50,-24,-76,-58,-16,-9,-10,18,2,-26,-73,-86,-128,-128,-97,-128,-128,-128,-74,-30,-21,1,
35,72,88,80,73,-59,-126,-78,-58,-70,-49,3,-9,-30,-18,42,109,117,80,-9,-120,-128,-128,-128,-63,42,-1,-58,-109,-76,
-24,20,-3,-42,-96,-63,-16,28,58,43,21,31,-4,-30,-81,-75,-128,-128,-103,-128,-128,-80,-21,-14,4,29,22,15,41,18,
37,-40,-91,-52,-67,-99,-74,-82,-46,-14,-2,90,127,127,98,-121,-128,-128,-128,-7,107,127,-86,-124,-83,-22,-18,-45,-123,-128,
-106,-12,42,53,67,67,30,20,29,-48,-81,-76,-58,-60,-39,-128,-128,-67,-28,-16,-6,-14,-3,-24,7,-8,-20,-30,-26,-18,
-41,-81,-106,-83,-38,0,13,39,81,85,-52,-128,-128,-128,7,127,127,127,-50,-80,-64,-11,-32,-92,-128,-127,-71,-1,44,44,
24,6,6,36,14,-3,-24,-36,-59,-80,-22,-78,-81,-9,-8,17,41,12,4,-12,19,22,13,-5,11,49,48,18,-47,-96,
-93,-10,50,34,-8,-13,-92,-128,-53,43,106,127,127,127,36,-43,-53,-17,-68,-116,-114,-82,-19,27,49,30,-4,-7,12,46,
31,20,-31,-54,-69,-43,52,15,121,127,47,31,52,27,16,0,6,23,21,6,12,39,30,-3,-29,-69,-114,-94,-35,-10,
-8,5,10,11,127,127,127,127,127,127,44,-55,-94,-76,-104,-112,-88,-28,13,27,19,3,-14,-3,17,36,56,25,-46,-67,
-78,-16,57,18,89,127,74,51,80,60,28,-22,-7,3,2,-24,-22,15,37,37,-13,-9,-65,-111,-113,-78,-24,9,26,-19,
-9,23,99,127,127,127,-16,-91,-98,-71,-81,-82,-72,13,3,6,-6,-5,8,22,21,15,6,-20,-51,-39,-48,-14,-15,-42,
47,107,72,70,104,89,37,-47,-13,-6,-8,-35,-36,-8,1,0,10,10,-42,-69,-62,-71,-61,-40,-21,-43,-55,-78,-55,-9,
37,24,-61,-79,-57,-60,-71,-29,-20,16,7,23,28,32,40,41,27,14,-41,-50,-48,-20,-37,-27,-53,1,119,124,86,89,
99,84,52,-34,-32,-37,-32,-20,6,18,-3,-11,-19,20,0,-6,-7,-63,-84,-63,-64,-75,-64,-64,-32,6,33,26,-68,-53,
-27,-32,-46,-19,7,26,33,46,69,77,61,54,30,9,-9,-12,-34,-6,-27,-58,-46,60,127,127,95,120,127,88,45,-33,
-68,-97,-54,-23,34,56,-23,-57,2,35,42,47,47,26,-17,-37,-35,-52,-6,-9,-16,27,37,45,-3,9,1,-3,-8,1,
11,12,55,66,86,85,62,51,33,13,10,-41,-59,-4,-32,-73,-79,14,84,126,112,127,127,96,16,-80,-128,-128,-84,-21,
47,41,-60,-76,-4,74,98,72,44,34,45,64,60,5,29,16,8,41,31,35,16,37,33,18,18,24,21,22,83,87,
99,90,58,35,15,2,34,-47,-51,-14,-31,-35,-74,-21,7,47,64,103,122,59,-17,-79,-128,-128,-128,-19,73,47,-112,-122,
-14,-4,50,10,22,28,46,50,62,35,68,25,15,30,71,22,43,61,46,17,7,11,27,47,88,96,102,85,44,22,
4,-7,-4,-69,-83,-48,-30,-31,-67,-12,60,84,74,79,83,46,13,-31,-109,-128,-97,20,123,70,-114,-98,-31,-73,-45,-48,
-10,9,34,43,63,42,94,54,21,20,73,38,67,78,59,26,1,-2,29,72,113,116,109,85,46,16,-8,-17,-9,-71,
-112,-104,-80,-41,-48,-34,53,88,96,106,102,87,86,38,-63,-105,-53,20,111,66,-94,-19,5,-99,-102,-66,-6,14,45,51,
55,38,116,91,32,13,81,64,65,84,71,38,3,-8,25,80,127,127,103,67,39,11,-23,-35,-7,-55,-109,-101,-78,-34,
-4,-1,9,85,127,127,102,107,125,73,-39,-46,16,55,80,9,-81,70,43,-99,-107,-53,-22,-8,34,40,46,30,127,119,
49,11,81,71,60,82,75,39,-7,-25,18,80,127,127,95,40,19,4,-31,-38,-22,-45,-123,-106,-80,-71,-8,52,62,97,
124,110,92,102,92,30,-39,-16,77,110,76,-27,-75,127,62,-96,-82,-12,-35,-55,-1,26,38,25,127,127,68,22,80,60,
62,83,69,26,-31,-47,6,79,127,127,101,27,5,-2,-27,-32,-19,-23,-121,-117,-128,-128,-128,-113,-69,-37,20,35,29,23,
-4,-40,-88,-63,23,78,53,-45,-71,127,108,-65,-35,52,-13,-68,-19,40,33,24,127,127,89,43,89,59,48,82,72,13,
-54,-61,1,57,120,127,113,41,-6,-24,-39,-32,-18,-29,-128,-128,-128,-128,-128,-128,-128,-128,-101,-82,-71,-81,-113,-128,-128,-128,
-128,-7,21,-62,-77,124,84,-41,5,94,17,-60,-29,35,41,13,127,127,100,39,85,55,46,80,71,13,-54,-61,1,57,
118,127,111,42,-6,-24,-40,-35,-23,-30,-128,-128,-128,-128,-128,-128,-128,-128,-98,-86,-75,-82,-109,-128,-128,-128,-117,8,34,-56,
-78,125,77,-42,8,97,13,-72,-44,28,43,17,127,127,99,37,83,50,64,77,62,21,-36,-51,5,82,127,127,103,29,
9,1,-29,-42,-29,-32,-128,-117,-123,-128,-128,-112,-55,-29,29,41,29,22,-7,-33,-76,-28,53,81,55,-43,-64,127,113,-72,
-36,54,-28,-99,-52,34,33,45,127,127,93,53,89,55,64,77,64,24,-23,-37,13,78,127,127,99,48,27,2,-43,-56,
-43,-70,-128,-109,-66,-72,-34,8,20,75,125,115,91,100,86,26,-22,16,98,103,57,-40,-61,127,67,-105,-86,-16,-63,-91,
-36,19,46,55,127,127,81,39,80,56,69,80,64,23,-20,-25,17,76,127,124,102,75,51,10,-40,-58,-27,-88,-128,-104,
-62,-37,-21,-38,-28,61,127,127,107,106,121,80,-26,-23,39,62,56,-18,-72,84,40,-113,-114,-61,-58,-43,3,30,68,69,
127,127,72,31,78,63,64,72,54,12,-24,-21,22,71,112,114,108,89,59,22,-17,-35,-28,-107,-128,-94,-64,-57,-60,-62,
39,68,76,94,89,62,62,35,-63,-102,-47,28,95,40,-84,-4,-5,-118,-114,-77,-40,-10,26,48,89,80,127,124,58,31,
74,54,28,47,39,1,-23,-13,18,49,91,100,101,82,48,25,-1,-18,-24,-105,-108,-32,-7,-43,-63,-27,49,64,41,43,
55,23,-13,-46,-96,-128,-108,8,106,53,-106,-76,-51,-101,-70,-65,-38,-6,30,60,103,82,125,85,42,29,57,27,-6,16,
22,-3,-18,-3,11,27,86,94,101,84,52,30,8,-5,10,-80,-85,-8,-4,-51,-79,-40,-6,38,41,58,78,33,-39,-102,
-127,-128,-128,-38,56,33,-112,-114,-45,-39,16,-8,-1,21,51,81,103,71,95,51,28,28,44,8,-37,-26,-17,-25,-38,-23,
2,19,64,78,94,84,57,40,22,6,-8,-66,-95,-22,-27,-95,-83,0,61,94,78,88,103,70,-1,-92,-120,-128,-104,-49,
28,39,-62,-80,-34,26,67,57,37,42,56,87,84,32,52,30,11,27,11,17,-102,-95,-59,-54,-71,-43,-6,30,35,52,
75,76,55,42,17,1,-36,-40,-70,-26,-37,-96,-58,48,127,98,49,84,96,65,22,-56,-69,-112,-75,-57,7,54,-25,-67,
-35,-8,25,45,48,42,6,-4,-6,-32,9,-1,-15,10,14,29,-86,-124,-108,-99,-98,-52,-38,14,16,25,24,32,41,31,
16,10,-49,-78,-84,-44,-53,-53,-77,-21,85,87,71,78,78,63,28,-64,-49,-50,-45,-34,-6,10,-9,-21,-41,-7,-11,4,
11,-38,-58,-27,-37,-61,-61,-70,-32,-12,13,11,-29,-128,-128,-106,-107,-117,-101,6,12,12,-6,-4,16,31,25,9,-3,-38,
-83,-67,-61,-28,-39,-59,40,92,72,69,91,74,25,-56,-17,-9,-15,-40,-34,-3,9,11,29,25,-18,-35,-27,-19,-8,1,
-15,-51,-70,-107,-80,-44,4,-9,47,-70,-125,-103,-128,-128,-112,-53,12,27,15,-5,-12,6,24,34,35,3,-74,-91,-84,-11,
43,2,64,116,65,42,61,45,21,-18,0,7,3,-15,-7,32,62,71,27,32,-12,-52,-64,-36,4,22,6,-60,-38,1,
80,127,127,127,53,-40,-64,-31,-88,-128,-128,-109,-31,17,41,20,-17,-27,-5,32,14,-2,-59,-74,-72,-27,56,11,116,127,
47,25,44,28,27,14,22,35,36,28,37,66,66,45,32,-6,-56,-37,15,19,-8,-1,-15,-58,66,127,127,127,127,127,
-31,-45,-50,-18,-38,-105,-128,-128,-84,-18,31,33,6,-21,-24,5,-6,-24,-58,-61,-79,-87,-18,-63,-50,18,9,22,47,29,
25,14,48,45,37,26,50,103,116,93,16,-33,-40,22,46,-1,-50,-32,-91,-128,-64,54,112,127,127,77,-72,-70,-35,-10,
-4,-34,-123,-128,-111,-32,24,45,58,48,2,-17,-9,-67,-105,-94,-82,-95,-67,-128,-128,-51,-14,-10,4,13,38,28,48,30,
28,36,50,63,29,-27,-67,-57,-21,9,12,43,85,94,-22,-128,-128,-81,51,127,127,127,0,-51,-61,-24,11,42,5,-28,
-76,-57,-23,20,51,33,4,8,-34,-51,-96,-85,-121,-128,-128,-128,-128,-90,-20,-6,13,45,51,54,90,80,112,55,-8,-5,
-45,-97,-60,-76,-48,-3,11,90,127,127,101,-80,-128,-128,-128,7,127,127,11,-32,-55,-60,-57,56,114,127,68,-5,-54,-33,
0,-12,-21,11,-11,-34,-79,-91,-113,-117,-86,-128,-128,-128,-56,-1,29,59,88,124,118,109,104,-20,-99,-66,-50,-82,-43,-5,
-36,-62,-60,-7,65,77,25,-32,-81,-128,-128,-128,-3,58,88,30,-95,-128,-128,-128,-27,110,127,127,102,48,43,71,55,59,
55,40,51,60,23,1,5,8,-66,-35,57,102,42,-18,-43,-61,-32,-1,-33,-89,-81,-87,-92,-73,-16,10,-50,-83,-9,43,
91,96,18,-19,31,14,-128,-128,-128,-33,112,122,-7,-128,-128,-128,-128,-128,83,127,127,127,127,127,96,86,85,43,21,-10,
-46,-84,-128,-128,-128,-72,71,112,-1,-114,-122,-79,26,24,-49,-73,12,27,11,22,51,90,85,67,79,34,-6,-15,-14,-58,
-17,64,-75,-128,-128,-128,101,127,127,20,-105,-128,-128,-128,-128,-95,67,127,127,127,127,127,51,-22,-85,-128,-128,-128,-128,-128,
-128,-40,66,85,22,-35,-17,37,127,124,67,23,52,54,74,119,127,127,112,82,19,-37,-58,-11,-7,-75,-84,-28,-52,-68,
-55,-104,127,127,127,127,93,23,-42,-128,-128,-128,-128,-109,50,127,127,127,127,127,99,16,-42,-97,-128,-128,-88,-24,37,57,
47,8,-14,19,62,65,30,6,23,66,106,127,127,117,83,12,-56,-53,-60,-61,-16,-18,30,37,9,-1,87,45,109,127,
127,127,127,127,127,86,-25,-110,-128,-128,-128,-54,28,127,127,127,127,127,93,-33,-128,-128,-128,-128,-90,-46,8,30,22,26,
80,83,58,13,-1,22,20,34,-8,-12,-31,-57,-90,-52,-42,-56,7,75,127,127,112,47,69,48,18,41,70,100,89,89,
91,69,65,40,-8,-52,-65,-49,-29,13,66,41,60,85,71,30,-36,-108,-85,-41,20,35,31,42,43,52,78,85,59,-3,
-51,-49,-73,-46,-32,-45,-63,-68,-71,-39,-18,-23,-24,63,93,69,58,13,11,-16,-89,-103,-86,-96,-92,-86,-88,-119,-97,-116,
-128,-128,-128,-104,-58,-29,-60,-54,-56,-26,27,57,72,56,69,59,61,77,73,83,119,126,75,87,50,-10,-42,3,22,-1,
-7,2,5,7,12,-2,-5,13,17,1,61,44,40,30,17,-11,-128,-128,-128,-128,-128,-128,-128,-128,-113,-124,-123,-100,-50,19,
52,53,44,57,55,79,109,127,127,127,74,56,45,54,73,104,127,126,127,100,54,47,49,88,119,105,65,51,34,20,
1,-6,-4,26,57,7,57,93,127,127,127,75,-128,-128,-128,-104,-77,-65,-13,-1,-32,-50,-49,-29,2,48,74,90,81,60,
62,108,127,126,120,97,16,4,-17,-30,-34,-21,27,63,68,19,-14,34,78,92,125,127,74,42,18,-7,-17,-16,-17,-5,
-20,-32,15,74,127,127,127,95,-128,-128,-95,-7,37,75,99,51,47,1,-41,-63,-61,-44,-12,27,63,71,88,104,63,4,
9,6,-20,-35,-76,-78,-77,-91,-54,21,-7,-67,-128,-128,-112,-56,19,63,110,105,81,43,17,1,-22,-22,-34,-64,-56,15,
127,118,125,88,-106,-40,77,127,127,79,49,12,-79,-77,-76,-66,-33,13,75,127,127,127,127,127,104,95,102,70,0,-1,
-53,-75,-49,-45,-18,51,34,-63,-128,-128,-128,-113,-34,6,83,127,127,127,124,66,-1,-31,-93,-128,-115,-38,27,20,93,44,
-68,75,127,127,67,23,-50,-128,-128,-128,-108,-37,58,127,127,127,127,127,127,127,127,127,127,127,127,127,118,34,33,58,
65,75,32,-39,-95,-128,-128,-109,-24,44,113,127,127,123,107,66,17,-15,-6,-104,-128,-128,-119,-52,41,-9,29,127,127,26,
-81,-117,-112,-128,-60,2,53,68,78,73,58,57,63,70,52,76,111,106,118,127,75,82,83,66,60,53,49,68,76,88,
82,7,-44,-32,12,85,80,101,99,78,64,57,54,30,-91,-128,-128,-128,-128,-28,22,8,127,126,29,-51,-122,-128,-40,26,
21,29,13,-18,-41,-55,-60,-42,-25,-24,-58,-66,-37,-62,-112,-125,-128,-128,-128,-77,-31,-13,7,54,118,120,111,86,94,83,
13,12,-17,-14,11,-2,-61,-66,-39,-40,-128,-128,-128,-128,-87,6,37,3,80,36,-76,-111,-93,-8,31,23,7,-11,-57,-101,
-126,-128,-128,-124,-128,-114,-89,-59,7,-65,-128,-128,-128,-84,-3,54,87,84,92,111,116,98,73,74,93,80,42,10,-113,-128,
-128,-84,-55,-53,-86,-128,-128,-128,-128,-59,29,77,80,57,9,-45,-127,-96,-15,41,16,-1,-2,-58,-128,-128,-128,-128,-128,-128,
-122,-90,-36,39,111,-6,-87,-37,-42,-52,-25,6,26,52,84,109,127,103,70,57,53,42,42,52,-8,-123,-128,-128,-86,-35,
-75,-128,-128,-128,-56,92,127,127,127,127,-52,-89,-99,8,40,10,-35,-16,5,-94,-128,-128,-128,-128,-128,-96,-20,-18,52,127,
127,14,-71,1,-13,-59,-73,-42,2,16,40,51,65,40,33,35,40,44,64,89,56,-21,-57,-69,-96,-112,-120,-110,-116,-128,
-83,17,69,127,127,127,-66,-46,3,72,16,-23,-24,-16,-70,-128,-128,-128,-114,-72,-37,-1,24,4,88,127,127,-8,-54,30,
-26,-69,-89,-61,-26,-28,-1,34,-4,-3,17,35,39,33,12,4,27,31,52,51,-16,-81,-89,-65,-128,-128,-128,-128,-80,47,
108,92,-41,23,57,67,-17,-25,-6,-32,-128,-128,-128,-126,-52,-8,21,38,31,-12,43,127,127,-22,-61,8,-53,-66,-72,-67,
-61,-59,-30,20,-8,2,34,47,60,60,16,-22,7,24,56,102,112,61,5,-14,-107,-128,-128,-128,-97,-13,-5,-13,4,66,
56,21,-22,6,-11,-76,-125,-128,-117,-57,-8,10,22,21,20,-25,-15,127,127,-24,-75,-15,-63,-48,-35,-32,-17,-25,-25,-9,
-4,22,69,80,82,81,23,-38,-27,13,27,66,127,127,94,49,-34,-116,-128,-128,-105,-22,-17,-12,38,43,18,10,6,27,
-6,-61,-100,-76,-28,10,4,-15,-5,11,2,-14,-81,63,127,-54,-83,-101,-80,-61,-18,-7,-5,-14,-23,-24,-41,17,93,117,
109,108,45,-32,-52,-33,-40,9,57,111,127,127,51,-69,-128,-111,-52,51,62,22,16,18,10,11,13,51,19,-33,-83,-55,
-4,17,-15,-46,-25,9,-13,-17,-83,36,127,-91,-86,-69,-108,-93,-29,-1,-8,-25,-38,-44,-9,33,93,125,127,127,79,5,
-9,-17,-56,-49,-22,65,127,127,83,-30,-97,-91,-32,93,116,35,23,13,-6,5,47,63,33,-37,-81,-52,16,35,-8,-47,
-28,2,9,-55,-89,44,94,-128,-128,-64,-72,-69,-22,5,-26,-64,-42,5,-14,58,81,127,127,127,127,127,33,-11,-18,17,
-15,2,79,127,83,-33,-104,-100,-13,108,127,74,12,3,-4,16,55,59,36,-18,-60,-41,10,36,8,-25,-26,-11,13,-62,
-92,15,37,-128,-128,-39,11,0,6,-13,-35,-55,-52,-4,10,112,127,127,127,127,127,127,36,-10,-51,-27,-35,-28,14,85,
84,-41,-120,-107,-6,127,127,70,-13,-15,-3,30,58,58,51,8,-30,-23,14,36,27,-8,-28,-27,12,-41,-57,16,5,-128,
-128,-128,-128,-82,-32,-56,-48,-36,-45,-8,65,127,127,127,127,127,127,59,-1,-17,-89,-83,-71,-62,-47,22,59,-65,-128,-128,
-7,127,127,92,-27,-25,0,30,50,59,70,36,6,12,37,50,35,-6,-32,-28,-11,-29,-45,-33,-72,-128,-128,-128,-128,-116,
-49,-85,-84,-50,-36,14,86,99,127,127,127,127,118,-89,-57,-21,-94,-100,-77,-64,-57,3,37,-82,-128,-128,-29,127,127,126,
-24,-23,1,22,31,45,70,48,38,57,86,78,40,-9,-27,-19,24,18,-31,-100,-128,-128,-128,-128,-128,-89,-48,-84,-61,1,
39,77,91,85,127,127,90,127,69,-128,-116,-40,-106,-110,-85,-55,-49,-10,23,-81,-128,-128,-54,127,127,127,-14,-15,2,17,
15,18,40,34,51,90,127,113,56,7,-7,-2,29,17,-42,-126,-128,-128,-128,-120,-111,-54,-34,-35,14,59,86,94,43,90,
127,127,51,78,26,-113,-128,-59,-128,-128,-111,-67,-51,-29,-4,-88,-128,-128,-74,125,127,127,-12,-3,23,21,9,0,13,4,
47,99,127,127,69,17,5,0,28,-10,-62,-105,-128,-128,-128,-112,-75,-47,-26,-5,-2,-9,29,46,-15,76,127,127,44,33,
56,-80,-126,-10,-128,-124,-106,-111,-69,-55,6,-60,-128,-128,-78,127,127,127,-13,0,29,26,11,-1,10,0,44,97,127,127,
69,18,8,2,35,-4,-56,-92,-128,-128,-105,-82,-58,-38,-19,7,5,-8,33,48,-4,85,127,127,35,20,53,-84,-120,-8,
-128,-126,-108,-116,-72,-57,6,-56,-128,-128,-80,126,127,127,-13,-7,11,25,19,13,32,30,50,90,127,117,63,17,2,6,
24,15,-47,-108,-128,-128,-106,-80,-75,-19,-7,-17,17,59,92,101,66,127,127,127,52,54,11,-107,-123,-66,-128,-128,-127,-72,
-62,-39,-22,-94,-128,-128,-81,119,127,127,-19,-11,12,32,35,42,67,49,43,61,90,85,52,6,-15,-13,28,15,-40,-82,
-128,-128,-126,-126,-126,-53,-28,-72,-58,-9,33,88,103,114,127,127,77,125,51,-125,-84,-44,-105,-122,-104,-71,-71,-37,1,-86,
-128,-128,-62,127,127,127,-19,-6,18,47,61,61,73,44,14,17,40,55,45,10,-18,-20,-2,-27,-46,-8,-43,-128,-128,-128,
-128,-92,-40,-73,-68,-45,-40,20,104,116,123,112,93,127,94,-69,-32,-33,-100,-111,-100,-81,-79,-25,12,-89,-128,-128,-38,127,
127,127,-4,8,22,57,75,60,51,16,-23,-16,16,37,34,7,-13,-17,10,-45,-53,49,37,-120,-128,-98,-115,-78,-36,-45,
-31,-28,-45,-9,81,127,127,127,116,122,127,65,8,-39,-101,-93,-90,-75,-62,5,37,-75,-128,-128,-14,127,127,127,18,29,
26,44,70,54,27,-19,-53,-31,16,39,16,-9,-12,-4,14,-66,-90,44,65,-101,-81,-8,36,7,10,2,-23,-45,-37,0,
12,119,127,127,127,127,127,127,36,-36,-69,-41,-54,-41,-2,66,65,-50,-116,-107,-1,127,127,109,27,40,27,28,54,53,
18,-48,-74,-40,26,45,9,-26,-15,7,15,-56,-88,67,106,-91,-93,-39,-53,-61,-12,27,-12,-49,-21,11,-12,66,86,127,
127,127,127,127,30,-38,-47,-10,-39,-12,60,127,63,-44,-96,-88,9,127,127,111,18,42,44,35,27,44,4,-59,-89,-50,
10,38,9,-20,-9,16,-4,-21,-77,67,127,-76,-70,-69,-101,-86,-17,21,-6,-36,-41,-52,-10,37,85,118,127,127,79,4,
-17,-57,-86,-64,-46,34,111,122,55,-42,-82,-68,5,127,127,83,29,55,58,45,26,29,-17,-86,-117,-78,-14,31,29,12,
15,24,9,-5,-64,95,127,-53,-63,-91,-64,-56,-15,2,-11,-27,-29,-34,-48,13,83,111,102,103,42,-34,-70,-83,-85,-27,
12,66,98,82,31,-66,-104,-75,-7,99,126,68,-4,83,105,66,9,24,-15,-95,-128,-128,-107,-34,21,47,54,42,40,-15,
-4,127,127,-34,-70,0,-26,-21,-22,-28,-30,-35,-28,-20,-18,6,51,69,75,69,11,-41,-53,-31,-16,14,64,74,52,31,
-45,-94,-128,-125,-61,34,59,46,-41,32,94,114,27,5,3,-31,-128,-128,-128,-94,-15,35,62,70,52,5,52,127,127,-28,
-61,-1,-26,-41,-57,-70,-81,-75,-40,-4,-27,-14,22,38,48,42,-4,-40,-37,-29,1,36,46,24,-8,-23,-119,-128,-128,-128,
-71,22,62,41,-65,-39,30,115,67,21,0,-11,-72,-128,-128,-128,-78,-30,8,43,66,37,100,127,127,-6,-57,7,-14,-51,
-77,-68,-39,-34,-10,19,-26,-20,4,20,18,6,-27,-47,-36,-39,-11,2,-43,-92,-90,-67,-128,-128,-128,-128,-75,74,127,127,
-48,-85,-88,34,84,52,-6,-11,-3,-106,-128,-128,-128,-124,-95,-48,37,34,83,127,127,6,-86,-14,-21,-57,-66,-37,7,19,
30,41,52,25,15,12,12,13,18,27,-7,-80,-96,-71,-74,-94,-104,-86,-108,-128,-124,-33,29,127,127,127,6,-46,-128,-103,
-3,71,53,12,-6,-69,-128,-128,-128,-128,-128,-96,-89,-51,-3,61,121,4,-90,-27,-45,-53,-20,15,34,54,75,97,117,78,
46,33,28,18,13,18,-43,-128,-128,-93,-15,33,-13,-90,-128,-128,-100,7,45,127,127,121,64,22,-86,-122,-107,-6,58,40,
10,-19,-69,-110,-128,-128,-128,-112,-127,-89,-66,-44,21,-43,-127,-117,-114,-77,3,60,96,96,94,104,109,92,78,90,114,104,
68,39,-96,-128,-81,-26,-27,-46,-80,-128,-128,-128,-128,-113,-36,16,38,36,123,111,13,-48,-126,-128,-32,24,15,18,-3,-34,
-62,-77,-76,-54,-34,-25,-64,-79,-52,-80,-128,-128,-128,-128,-115,-44,13,34,45,81,127,127,127,127,127,121,67,68,17,0,
18,6,-65,-95,-82,-90,-128,-128,-128,-128,-85,7,30,-6,39,127,127,23,-68,-95,-90,-128,-62,-5,40,48,45,34,25,34,
34,41,8,26,62,49,60,76,32,46,74,93,106,103,100,120,120,120,94,18,-26,-21,12,77,71,65,65,56,47,39,
29,-5,-121,-128,-128,-128,-88,22,48,3,-58,84,127,126,74,41,-11,-85,-128,-128,-84,-16,59,106,112,119,105,127,127,93,
75,90,98,72,123,127,108,65,79,97,80,70,43,-22,-78,-122,-128,-127,-38,38,101,127,118,111,110,75,18,-31,-25,-108,
-128,-128,-55,17,94,3,-79,-20,74,127,127,100,91,56,-20,-22,-19,-7,9,30,75,127,127,127,127,127,123,104,96,65,
-13,0,-41,-71,-59,-67,-52,16,32,-53,-128,-128,-128,-124,-33,12,88,127,127,125,111,58,-6,-45,-109,-128,-121,-28,71,63,
110,47,-127,-128,-69,10,29,61,114,91,98,50,8,-12,-17,-8,14,45,79,99,117,127,102,43,30,19,4,-12,-77,-116,
-128,-128,-111,-21,-55,-101,-128,-128,-103,-36,37,76,109,105,79,40,24,18,-3,-13,-35,-55,-22,60,127,127,127,78,-113,-128,
-128,-56,-45,-46,-3,-1,-20,-25,-22,-11,4,37,54,57,46,28,16,49,87,95,94,81,27,0,-46,-79,-84,-73,-38,-9,
6,-23,-21,44,91,104,127,127,74,46,22,5,4,6,6,21,-10,-29,35,109,127,127,127,124,-114,-128,-128,-128,-128,-128,
-118,-128,-111,-116,-113,-98,-63,-13,1,-14,-24,-2,-3,15,43,67,110,127,63,49,23,5,14,42,76,83,101,84,58,51,
41,62,83,73,38,31,16,0,-17,-27,-25,6,26,-24,41,91,127,127,127,105,-80,-95,-72,-72,-69,-66,-65,-98,-81,-111,
-128,-128,-128,-105,-75,-58,-84,-65,-62,-33,12,35,54,51,70,70,72,75,65,75,108,119,67,82,50,-11,-48,-16,0,-19,
-20,-15,-17,-20,-18,-30,-34,-17,-17,-33,35,22,48,41,21,-19,29,122,127,104,106,52,62,35,31,17,12,13,30,39,
32,-2,8,18,17,57,90,78,42,13,6,8,-2,-5,-33,-67,-57,-38,-61,-37,3,44,78,103,127,127,119,121,113,92,
87,62,60,58,49,88,106,127,127,127,127,127,116,127,127,94,77,-15,-16,-24,-60,-78,-99,-82,-53,-30,18,24,37,42,
61,127,127,116,74,64,104,101,72,40,-25,-113,-128,-128,-128,-128,-128,-80,-18,26,67,80,107,114,127,127,127,81,63,35,
31,66,91,127,127,127,127,127,91,127,92,32,17,-76,-84,-106,-115,-119,-128,-112,-95,-91,-36,-14,64,31,60,127,127,81,
84,127,127,122,56,16,-37,-128,-128,-128,-128,-128,-128,-128,-104,-41,28,72,81,89,99,111,93,35,26,21,52,80,55,17,
-43,127,127,127,-7,9,-34,-98,-93,-108,-102,-128,-128,-128,-128,-76,1,47,79,88,69,63,93,100,61,16,-12,-34,-33,-61,
-92,-20,38,-3,-67,-93,-128,-128,-128,-128,-128,-128,-99,-55,57,87,90,53,-9,-40,-19,20,9,3,-74,-128,-128,12,127,127,
12,-23,-27,-44,-12,-72,-74,-88,-109,-46,60,111,111,84,67,72,95,75,112,112,61,-14,-97,-128,-128,-128,-128,-76,4,12,
-1,-26,-65,-73,-58,-58,-81,-47,-29,-40,3,51,73,44,-31,-47,-3,65,30,-46,-128,-128,-128,-63,55,13,8,-20,18,20,
44,24,46,46,114,122,127,127,127,94,66,45,0,5,46,43,20,-31,-117,-128,-128,-128,-118,-92,-94,-92,-83,-116,-128,-128,
-33,51,83,108,77,20,-34,37,78,57,-31,-43,-37,-25,-19,-103,-128,-128,-128,-91,1,4,52,44,84,68,73,81,52,16,
21,30,25,20,14,-7,-56,-109,-103,-80,-63,-45,-62,-128,-128,-128,-128,-128,-112,-76,-78,-82,-88,-128,-128,-128,-35,120,127,127,
127,127,40,41,58,27,-31,-36,-10,-30,-113,-128,-128,-128,-128,-74,-41,-57,57,68,127,111,105,61,0,6,-35,-68,-108,-110,
-81,-73,-87,-102,-126,-116,-78,-50,-78,-115,-103,-128,-128,-119,-58,-26,-39,-37,-27,-63,-43,-39,63,127,127,127,127,127,92,69,
47,-19,-77,-30,26,26,-116,-128,-128,-128,-38,-44,-24,-15,86,126,82,68,92,24,2,7,-61,-82,-86,-67,-30,-23,-38,-57,
-80,-39,9,-4,-66,-41,7,-87,-128,-30,31,12,-22,-31,-4,-21,5,12,90,127,127,127,127,127,113,45,-17,-13,43,98,
83,5,-48,-94,-110,-8,127,70,8,0,31,61,50,61,55,-6,-22,-45,-127,-102,-45,2,36,36,12,-9,-17,38,71,21,
-89,-113,-38,-47,-17,43,66,28,-8,-21,-23,-34,-11,-21,19,69,91,104,93,50,35,27,-13,11,99,127,127,127,127,114,
27,60,127,122,78,66,-18,14,13,19,-1,-53,-76,-125,-128,-100,-17,33,61,71,57,35,40,74,83,4,-128,-128,-29,66,
35,34,46,38,41,18,-24,-37,-28,-33,-27,1,35,70,70,33,-21,1,1,-2,10,35,89,127,107,71,9,-25,5,-48,
-23,47,-20,-8,-24,-25,-42,-77,-100,-128,-107,-33,52,74,91,111,95,55,56,76,94,-31,-128,-128,23,123,-67,-55,-1,21,
29,-2,-47,-24,-21,-11,-23,-18,20,58,67,37,-5,-38,-25,-15,-54,-63,-16,29,-29,-34,-54,-49,-8,-106,-123,-64,-32,-67,
-82,-61,-53,-80,-101,-96,-52,27,119,127,127,123,99,74,89,127,127,-27,-128,-128,64,13,-128,-113,-1,19,13,-31,-84,-46,
-36,-12,-46,-55,-16,19,31,9,-37,-76,-40,-31,-64,-46,-6,14,6,-11,-31,-5,42,-74,-115,-65,-75,-128,-126,-96,-71,-80,
-100,-73,-26,33,124,127,127,121,85,77,69,127,127,-24,-128,-19,127,-56,-128,-116,-10,-23,-40,-76,-121,-74,-12,17,-43,-74,
-43,-12,0,-16,-35,-72,-10,23,-10,-33,-37,3,23,16,-9,0,18,-86,-105,-56,-94,-128,-128,-76,-34,-58,-68,-50,6,59,
126,127,127,78,51,45,72,127,127,-22,-82,91,127,1,-35,-72,20,-3,-50,-96,-128,-113,-33,-2,-64,-74,-47,-59,-16,-5,
-11,-52,26,79,23,-16,-22,14,28,40,52,23,19,-60,-80,-59,-104,-128,-120,-50,-18,-28,-42,-52,55,94,127,126,100,61,
29,17,54,122,127,-30,-62,127,127,80,6,-65,18,8,-30,-70,-128,-98,-85,-53,-98,-87,-67,-101,-58,-25,-55,-72,33,110,
64,35,16,25,73,83,96,70,74,9,-7,11,-85,-84,-68,-19,20,-4,-12,-10,82,97,94,102,85,30,8,27,46,124,
87,-27,2,100,127,-31,-44,-35,49,37,-13,-42,-93,-122,-82,-104,-112,-95,-87,-107,-54,35,35,-1,74,127,122,52,28,48,
34,47,69,42,54,-33,6,12,-79,-55,-8,27,41,7,-12,-19,42,50,39,50,58,23,8,25,33,102,66,-37,7,65,
127,-24,3,-17,18,7,-4,-10,-68,-128,-128,-128,-128,-120,-67,-50,1,82,93,28,77,127,112,68,59,75,39,27,28,2,
22,-63,-16,2,-50,-6,47,67,62,17,-10,-25,12,22,8,18,31,4,-11,-1,1,53,17,-59,24,43,123,65,37,31,
43,-1,-29,-25,-65,-128,-121,-47,-60,-54,25,42,103,127,127,25,42,90,76,82,103,105,46,12,-10,-31,-11,-104,-45,-6,
-11,25,68,82,77,32,-4,-25,-2,12,16,29,25,-12,-33,-34,-18,10,-23,-88,9,9,85,127,105,126,127,64,13,5,
-34,-88,47,80,42,54,102,81,127,127,127,-2,-9,30,25,75,126,127,59,11,-30,-50,-36,-128,-73,-3,7,37,64,79,
92,59,17,-22,3,10,27,53,45,2,-26,-45,-49,-38,-61,-123,-38,-21,26,120,90,127,127,74,18,10,-33,-78,16,5,
11,110,127,89,127,127,127,-18,-47,-9,-10,66,127,127,74,28,-22,-54,-49,-128,-83,5,17,53,77,86,109,94,50,-6,
6,-6,10,52,59,25,-9,-46,-66,-65,-74,-128,-78,-47,-89,-52,-72,-41,7,-47,-67,-75,-128,-128,-128,-128,-69,127,127,127,
127,127,127,0,-61,-34,-31,51,125,127,94,49,-11,-54,-57,-128,-90,5,21,52,92,112,127,111,100,23,-7,-24,-21,30,
61,46,14,-47,-74,-76,-79,-128,-127,-4,-108,-105,-128,-128,-128,-128,-128,-128,-128,-128,-128,-128,-90,89,127,127,127,127,127,-20,
-89,-34,2,65,127,127,127,78,-1,-58,-75,-128,-87,-4,22,55,95,114,127,117,108,30,-11,-29,-26,28,62,48,14,-49,
-71,-74,-76,-128,-128,4,-90,-77,-100,-122,-128,-128,-128,-128,-128,-128,-128,-128,-103,67,127,127,127,127,127,-20,-88,-32,4,64,
127,127,127,83,0,-59,-73,-128,-84,-4,24,65,87,89,114,114,66,5,-2,-21,-4,44,57,23,-17,-54,-75,-68,-60,-112,
-67,-50,-86,-29,-43,-12,37,-34,-52,-49,-128,-128,-128,-128,-85,121,127,127,127,127,127,5,-53,-29,-28,57,124,127,108,58,
-10,-51,-46,-128,-85,3,21,53,77,89,105,87,38,-9,-5,-11,2,34,35,-2,-33,-56,-58,-29,-28,-96,-39,-34,6,120,
104,127,127,59,16,22,-18,-57,3,-16,-13,97,127,91,127,127,127,-13,-41,1,6,81,127,127,103,48,-12,-45,-35,-128,
-78,1,1,38,81,97,96,61,15,-19,-13,-15,-16,4,9,-17,-39,-44,-21,35,23,-72,-17,-14,55,127,98,102,113,43,
-1,-3,-37,-94,7,22,2,39,99,78,127,127,127,-12,-19,36,43,93,127,127,93,36,-13,-35,-16,-128,-64,-6,-46,2,
59,84,81,45,5,-28,-6,-8,-21,-6,13,-5,-17,-10,8,90,73,-50,-9,24,85,61,17,4,29,-6,-33,-23,-56,-128,
-128,-85,-83,-59,24,39,85,127,104,0,20,91,91,97,115,127,72,36,7,-14,14,-84,-31,-6,-75,-47,1,45,63,32,
-1,-27,14,10,1,19,34,8,-1,16,43,127,120,-28,-15,60,118,-22,-21,-40,16,9,-5,4,-39,-118,-128,-128,-124,-110,
-65,-54,-14,53,54,-3,58,127,127,92,76,98,53,47,47,22,53,-35,0,3,-72,-68,-55,0,43,18,-4,-16,47,51,
47,62,54,10,-5,19,56,127,127,-11,3,114,127,-5,-34,-41,53,42,-5,-16,-57,-90,-79,-81,-89,-84,-87,-114,-67,17,
0,-23,66,127,127,81,49,66,43,68,95,71,97,3,25,15,-83,-96,-93,-28,8,-7,-27,-35,44,65,90,89,70,32,
8,10,59,127,127,-10,-19,127,127,101,28,-48,39,27,-17,-48,-97,-76,-84,-40,-75,-75,-66,-104,-59,-20,-47,-58,43,127,
95,65,34,36,72,101,127,117,127,39,16,14,-86,-99,-113,-51,-9,-36,-45,-25,12,43,87,108,93,47,26,31,70,127,
127,3,-10,127,127,26,-8,-62,32,13,-36,-74,-128,-89,-40,8,-43,-64,-49,-70,-26,-15,10,-24,46,102,62,32,8,21,
39,69,110,96,98,-13,-46,-43,-79,-104,-69,-59,-53,-55,-75,-46,-7,37,102,125,115,89,61,62,61,127,127,-23,-89,45,
127,-54,-128,-105,-8,-17,-37,-70,-99,-68,-21,22,-31,-82,-71,-48,-36,-49,-45,-67,-9,33,24,2,-13,32,45,60,63,86,
95,-60,-93,-56,-40,-73,-44,-7,-17,-61,-90,-78,-21,48,117,113,97,92,72,57,84,127,99,-43,-128,-109,55,-6,-128,-92,
1,14,-2,-44,-75,-45,-40,-8,-37,-63,-56,-41,-32,-45,-67,-95,-68,-49,-54,-22,16,38,17,33,39,65,99,-53,-100,-73,
-37,-30,-12,22,9,-52,-97,-124,-84,-12,61,71,83,98,75,37,44,60,44,-64,-128,-128,29,111,-59,-49,-5,8,5,-26,
-58,-30,-20,-13,-28,-35,-24,-7,0,-27,-66,-92,-82,-46,-42,-32,17,53,1,23,19,6,37,-78,-94,-64,-39,-3,11,36,
42,-19,-60,-103,-128,-92,-18,31,66,80,60,33,29,52,37,-28,-128,-128,-11,59,25,28,39,20,11,-17,-55,-54,-44,-58,
-60,-33,-8,17,17,-27,-99,-77,-71,-41,-7,22,89,127,127,127,74,19,41,-18,20,60,7,33,35,55,67,16,1,-24,
-110,-92,-41,10,53,58,34,11,-4,24,27,-5,-91,-89,-15,-51,-25,31,57,14,-29,-54,-68,-63,-35,-45,-9,41,48,49,
36,-16,-29,-42,-88,-58,27,107,127,127,127,93,42,100,127,127,127,79,52,69,54,61,87,25,13,17,-33,-66,-81,-59,
-13,5,-6,-24,-70,-61,-44,-27,-63,-30,11,-92,-128,-48,4,-13,-35,-53,-49,-46,-18,-4,68,127,127,127,127,78,57,-27,
-121,-123,-48,30,36,-26,-72,-128,-128,-50,127,84,61,43,26,23,103,100,105,49,2,19,-13,-51,-94,-97,-66,-49,-60,-83,
-127,-128,-128,-78,-73,-99,-95,-128,-128,-88,-45,-26,-29,-42,-56,-71,-27,-22,68,127,127,127,127,127,44,24,-2,-73,-128,-71,
19,48,-83,-128,-128,-128,-67,-42,29,48,31,16,56,70,100,89,42,8,22,33,28,16,5,-8,-46,-97,-95,-78,-87,-48,
-37,-128,-128,-128,-128,-105,-71,-45,-40,-55,-76,-108,-122,-128,-32,127,127,127,127,127,24,8,20,-5,-53,-40,5,-2,-53,-127,
-128,-128,-128,-61,7,-13,-14,-47,3,25,79,41,34,17,81,88,99,88,71,36,17,1,-28,-44,-20,-7,-8,-45,-120,-128,
-128,-128,-77,-54,-57,-62,-68,-101,-128,-126,2,121,127,127,106,34,-34,22,63,53,-42,-40,-29,-14,-3,-65,-128,-128,-128,-76,
47,42,-18,-67,-59,-49,25,-24,-42,-74,-127,-73,28,70,72,49,26,20,60,25,42,46,6,-65,-128,-128,-128,-128,-128,-49,
21,21,5,-8,-40,-9,49,61,21,21,15,-3,29,66,83,57,-39,-54,-8,56,26,-35,-128,-128,-128,-56,127,95,-46,-62,
-99,-123,-70,-70,-57,-118,-128,-128,-93,-34,26,77,122,127,93,73,83,86,41,-19,-47,-45,-23,-56,-77,0,54,8,-57,-68,
-117,-123,-128,-128,-128,-115,-58,-13,92,115,114,73,-13,-65,-46,-16,-23,-28,-89,-128,-128,19,127,127,63,54,7,-24,-6,-84,
-86,-96,-85,-70,-68,-34,-22,-25,32,34,83,38,45,103,93,37,48,108,124,95,47,31,-2,-85,-128,-128,-128,-128,-128,-128,
-102,-31,51,99,108,119,127,124,74,-22,-37,-45,-10,21,9,-14,-72,96,127,127,106,127,122,45,27,-58,-58,-71,-101,-112,
-128,-109,-74,-52,-7,-31,-17,-10,6,78,105,75,36,28,69,75,62,34,-28,-109,-128,-128,-128,-128,-128,-97,-29,27,74,93,
111,116,118,112,82,0,-27,-60,-61,-24,10,79,75,127,127,127,23,114,116,90,89,31,28,-3,-16,-33,-38,-39,-18,-4,
-14,-59,-46,-35,-25,32,77,62,16,-21,-24,-2,9,6,-20,-53,-50,-33,-53,-33,-1,39,82,113,127,127,123,121,108,89,
82,30,17,11,7,50,73,127,127,103,127,127,-28,-47,41,42,5,-2,9,4,-6,-19,-52,-84,-67,-41,-22,-5,2,-15,
-49,-35,13,22,29,65,63,51,42,65,85,97,127,127,127,127,112,127,127,117,109,112,111,106,109,121,127,124,112,114,
109,111,87,104,68,9,-17,31,-42,-51,15,3,-58,-52,-62,-85,-74,-51,-25,-9,29,39,7,-43,-107,-96,-85,-60,-35,-1,
56,113,127,127,127,122,113,121,127,127,127,127,127,127,127,102,106,127,127,127,127,127,127,112,102,125,127,127,127,127,
101,26,-43,-16,-57,-94,-84,-126,-128,-126,-103,-51,25,40,56,59,60,50,44,44,-35,-34,-44,-55,-108,-128,-96,-37,109,127,
120,108,111,71,12,-19,0,51,88,84,44,12,24,42,36,41,51,61,58,23,3,5,50,123,48,11,-66,-67,-88,-4,
-93,-128,-128,-120,-93,-84,-64,-41,-19,-65,-88,-90,-50,8,71,127,127,127,127,127,109,35,-9,-21,72,88,35,5,43,83,
72,43,56,34,-8,-45,-84,-92,-64,-25,-14,-1,-11,-43,-69,-77,-66,-66,7,66,-26,-89,-128,-128,-128,-50,-91,-128,-128,-96,
-13,29,9,-26,-100,-79,-33,-22,12,65,101,127,118,127,109,94,102,126,87,41,-30,-71,-128,-128,-44,-4,-13,-10,-56,-91,
-108,-103,-110,-128,-117,-65,-13,-17,-31,-85,-128,-128,-128,-70,-25,14,-57,-107,-96,-65,-82,-11,-128,-128,-90,44,81,25,3,12,
51,79,93,41,39,76,59,46,57,74,44,38,101,127,127,70,37,-48,-128,-119,11,56,-12,-74,-128,-128,-128,-128,-121,-81,
-55,-1,-7,-29,-34,-44,-99,-128,-128,-128,-57,8,-39,-94,-81,-8,-2,12,-122,-108,66,127,66,-48,-51,8,9,35,48,28,
29,63,97,127,127,127,119,127,127,107,-1,-8,51,10,-16,31,78,58,-2,-59,-128,-128,-128,-128,-127,-118,-105,-41,-91,-123,
-109,-70,-51,-80,-103,-71,31,41,-41,-61,-32,7,-10,-28,-33,7,111,37,-58,-51,-3,-24,-17,-29,-40,-30,38,127,127,127,
127,126,106,104,67,44,-21,22,-35,6,23,19,13,2,-18,-33,-53,-102,-128,-101,-59,-46,-24,62,-41,-45,-30,-11,9,-1,
24,86,44,31,-55,-24,42,106,93,-16,71,64,-8,-47,-81,-24,-15,-55,-54,-54,-21,28,69,103,127,127,112,-10,-60,-103,
-128,-128,-64,-44,-101,-59,-21,19,36,12,-10,3,11,-6,-11,-13,-36,-45,-15,27,71,72,43,14,19,55,73,77,39,113,
65,89,105,127,73,-27,48,25,-50,-42,-25,-32,-67,-53,-17,14,28,10,-15,-27,-21,-17,-23,-118,-128,-128,-128,-86,38,-25,
-22,29,53,39,27,40,49,34,53,35,13,-6,-34,-56,-55,-35,13,54,89,87,41,2,18,54,107,127,79,90,78,127,
127,28,79,13,-68,-60,-59,-66,-84,-17,69,90,50,-32,-94,-125,-117,-101,-112,-128,-128,-128,-128,15,69,-50,-76,31,127,127,
72,45,61,48,60,59,47,15,-20,-47,-50,-35,11,4,26,71,47,-14,-26,-9,14,52,-3,14,-18,65,110,40,63,-12,
-42,-52,-112,-66,-24,32,102,69,-32,-123,-128,-119,-98,-101,-128,-119,-128,-128,-107,100,-4,-103,-85,16,127,127,127,34,50,71,
46,67,68,26,-32,-75,-69,-32,24,0,-1,22,-9,-91,-128,-128,-96,-64,-101,-48,-54,-1,23,-17,-1,-46,-23,-13,-80,-3,
52,78,63,-14,-117,-128,-128,-103,-83,-95,-107,-105,-128,-128,62,127,-49,-69,44,80,127,127,127,25,39,80,67,84,83,30,
-39,-94,-98,-64,-3,-9,-20,7,8,-40,-109,-128,-128,-74,-91,-53,-79,-60,-50,-47,-2,-31,-26,2,-16,55,84,113,43,-63,
-128,-128,-109,-77,-31,-16,-38,-96,-128,-128,101,127,-35,-21,20,40,84,127,127,88,96,107,102,94,80,32,-23,-69,-88,-66,
-25,-15,-40,-23,1,-14,-60,-114,-110,-13,-34,-32,-71,-47,-32,-25,15,-19,5,39,5,65,94,99,16,-74,-127,-102,-60,-28,
18,35,-8,-69,-128,-128,42,80,-24,-22,30,-4,16,127,127,100,117,115,84,106,102,75,48,-22,-74,-83,-57,-36,-103,-62,
-22,-40,-24,-7,-36,12,-31,7,-17,17,-54,-23,13,1,35,51,19,77,85,72,5,-79,-120,-73,-17,13,51,72,50,-1,
-128,-128,-22,39,3,50,122,48,-12,92,127,73,84,92,127,100,92,92,68,8,-49,-98,-117,-62,-121,-91,-49,-48,-24,-2,
33,63,-12,0,-26,23,-38,-21,5,-9,6,-2,-1,25,74,58,-29,-50,-79,-42,33,64,79,94,70,33,-128,-128,-55,39,
77,127,127,70,61,113,125,96,73,94,127,118,93,118,66,29,16,-98,-128,-118,-128,-109,-62,-86,-90,-63,15,95,27,-14,
-60,3,-50,-31,-15,-30,-29,-39,-23,3,49,43,-34,-52,-68,-20,63,106,119,123,115,53,-128,-128,-100,-18,49,102,127,107,
123,127,106,47,16,65,83,86,111,127,101,58,85,-10,-128,-128,-128,-128,-86,-111,-128,-128,-14,93,52,10,-52,-2,-64,-58,
-31,-43,-49,-64,-31,-3,25,16,-37,-54,-51,6,85,125,127,127,127,95,-79,-128,-115,-55,27,64,127,125,127,107,41,-19,
-40,40,-17,40,127,127,127,87,127,55,-107,-106,-128,-128,-94,-126,-128,-128,-77,66,68,43,-31,0,-76,-77,-45,-53,-54,-66,
-23,0,5,-21,-57,-69,-40,33,94,124,127,127,127,127,12,-128,-103,-70,-1,16,127,95,78,27,2,-5,-37,9,-33,-32,
62,127,127,109,127,68,-36,-65,-128,-119,-72,-116,-128,-128,-112,39,69,77,1,6,-85,-84,-46,-61,-40,-33,7,12,-12,-46,
-83,-89,-40,46,98,116,127,118,127,127,48,-86,-74,-63,-6,0,41,35,30,-21,-16,7,-52,-68,-47,-128,-73,112,121,127,
127,88,10,-49,-128,-99,-34,-78,-128,-128,-106,29,60,103,49,36,-74,-75,-62,-83,-35,-10,18,-4,-45,-73,-102,-105,-53,36,
93,111,117,101,127,127,50,-34,9,15,72,117,81,90,84,33,41,68,-1,-49,-81,-128,-90,108,116,127,127,109,70,-10,
-128,-82,-6,-52,-102,-128,-92,22,45,114,89,71,-58,-70,-68,-98,-48,-19,11,-13,-44,-76,-104,-89,-53,19,87,102,101,97,
127,127,112,46,38,82,127,127,127,127,127,127,127,127,82,54,41,-28,64,127,127,127,127,127,80,4,-128,-81,0,-23,
-64,-128,-94,38,63,123,88,80,-33,-86,-70,-101,-50,-21,9,-14,-45,-74,-100,-83,-50,19,90,104,105,105,127,127,112,41,
32,93,127,127,127,127,127,127,127,127,85,60,42,-19,70,127,127,127,127,121,74,7,-128,-79,-1,-20,-61,-128,-100,34,
61,120,87,82,-33,-88,-63,-85,-33,-3,19,-8,-48,-63,-88,-93,-49,38,99,120,127,115,127,127,54,-31,34,33,92,127,
106,111,103,48,47,71,2,-46,-70,-128,-53,123,119,127,127,104,69,10,-128,-78,-2,-54,-103,-128,-105,5,27,102,94,81,
-64,-70,-44,-59,-37,-27,8,11,-8,-28,-60,-71,-31,50,107,127,127,127,127,127,38,-81,-43,-31,40,64,100,77,49,-10,
-5,23,-38,-59,-36,-128,-33,126,124,127,127,91,15,-23,-128,-98,-30,-80,-128,-128,-119,13,42,89,52,48,-78,-80,-35,-46,
-50,-61,-21,3,14,3,-33,-48,-26,44,107,127,127,127,127,109,-12,-128,-82,-43,28,43,127,118,97,48,27,18,-24,10,
-37,-39,74,127,127,127,127,89,-28,-40,-128,-121,-63,-112,-128,-128,-128,18,48,58,-2,16,-88,-90,-21,-42,-53,-65,-35,-10,
27,37,-10,-31,-28,27,100,127,127,127,127,60,-105,-128,-93,-33,24,27,118,127,127,127,66,-3,-28,47,-31,2,116,127,
127,127,127,78,-91,-79,-128,-128,-84,-123,-128,-128,-89,44,46,27,-35,6,-82,-85,-2,-31,-35,-46,-39,-12,50,70,-9,-32,
-43,7,79,119,127,116,92,8,-128,-128,-80,0,34,48,100,96,127,127,126,61,36,83,91,60,100,127,114,92,124,6,
-128,-113,-128,-128,-85,-112,-128,-128,-25,66,30,1,-49,3,-75,-70,23,-5,9,-6,-22,10,81,90,-3,-36,-57,-14,50,77,
86,86,47,-18,-128,-128,-39,56,71,127,127,65,56,122,127,109,92,97,127,116,102,127,84,51,45,-76,-128,-107,-128,-125,
-68,-85,-90,-74,-7,57,4,-14,-46,14,-59,-41,29,3,44,51,6,60,95,96,23,-60,-98,-49,0,23,50,56,16,-56,
-128,-128,-9,52,-4,38,90,17,-29,87,127,77,84,77,127,123,120,120,89,18,-33,-84,-116,-57,-125,-94,-50,-49,-28,-19,
-5,25,-25,7,-8,38,-46,-28,20,-20,27,56,13,62,103,109,18,-75,-123,-90,-49,-24,13,20,-48,-124,-128,-128,64,102,
-28,-28,11,-24,6,127,127,90,107,109,76,127,127,99,75,-15,-69,-74,-60,-30,-101,-59,-24,-42,-26,-26,-58,-11,-32,23,
6,35,-61,-35,16,-23,-4,17,3,70,89,120,43,-61,-128,-128,-102,-75,-34,-28,-80,-128,-128,-128,109,127,-44,-26,-10,25,
68,127,127,89,82,99,97,92,82,46,-3,-63,-94,-75,-32,-19,-29,-15,1,-17,-69,-128,-128,-13,-9,-8,-46,-36,-24,-39,
13,-44,3,16,-56,14,64,88,65,-8,-111,-128,-123,-97,-89,-120,-128,-128,-128,-128,59,127,-46,-81,63,108,127,127,127,27,
32,81,59,76,75,32,-30,-90,-99,-62,4,-6,-23,-5,2,-31,-99,-128,-128,-72,-89,-44,-53,-55,-52,-59,60,-15,-10,-1,
-61,-32,4,55,107,77,-20,-109,-127,-112,-93,-108,-128,-128,-128,-128,-102,118,5,-126,-63,47,127,127,127,33,42,68,42,64,
64,20,-40,-83,-76,-39,28,8,2,18,-2,-66,-128,-128,-82,-57,-111,-58,-50,-18,4,-40,82,20,-32,-2,17,-7,-42,8,
77,99,67,-7,-78,-121,-117,-105,-128,-128,-128,-128,-128,36,79,-75,-87,30,127,127,88,51,54,35,50,54,49,13,-31,-60,
-63,-51,2,20,51,78,43,-16,-32,-28,-23,23,-46,-36,-66,20,95,35,58,37,-29,4,56,44,-5,-20,1,25,40,34,
7,-22,-30,-30,-49,-128,-128,-128,-128,-60,56,-33,-48,14,53,55,41,43,40,13,27,16,7,-11,-46,-66,-57,-32,33,79,
101,77,21,-30,-24,8,61,115,48,69,64,127,127,52,65,58,-6,-20,-4,64,76,13,-7,-21,-4,47,96,126,127,113,
82,-23,-77,-128,-128,-104,-23,-6,-87,-51,-12,27,25,-12,-28,-21,-7,-21,-14,-21,-57,-65,-21,37,85,79,23,-19,9,61,
83,94,85,127,95,127,127,127,104,1,-21,16,91,29,-22,17,83,58,56,28,-1,2,67,127,127,127,127,127,105,95,
61,55,20,66,16,29,34,33,5,-22,-28,-40,-63,-114,-128,-122,-104,-84,-28,75,-30,-21,-18,-32,-16,-7,40,119,95,76,
-19,22,122,127,127,16,-92,-70,67,106,31,-32,6,82,85,100,97,62,49,80,118,127,127,127,126,127,127,101,18,20,
75,22,-6,39,66,46,7,-51,-128,-128,-128,-128,-128,-128,-101,-25,-68,-101,-97,-70,-47,-71,-99,-70,58,80,-11,-39,36,100,
60,5,-112,-83,-48,42,20,-34,-25,11,62,90,101,26,11,48,33,26,48,60,26,14,85,127,127,79,39,-28,-117,-109,
1,46,-13,-72,-128,-128,-128,-128,-110,-73,-50,-2,-14,-40,-37,-24,-76,-128,-128,-128,-77,43,-1,-84,-80,34,52,12,-68,-94,
-104,-37,-20,-24,-53,-71,-125,-102,-50,-52,-34,14,56,123,103,114,83,45,40,72,57,27,-54,-87,-128,-128,-83,-28,-28,-23,
-71,-105,-118,-93,-86,-118,-118,-83,-28,-36,-48,-89,-128,-128,-128,-88,-46,23,-32,-107,-128,-75,-58,-9,-84,-103,-107,-52,-38,-52,
-60,-53,-35,-63,-57,-50,-20,17,73,127,127,127,127,127,87,4,-44,-49,29,23,-44,-70,-11,48,55,41,45,25,-7,-24,
-57,-82,-71,-42,-31,-23,-30,-51,-74,-89,-84,-86,-24,32,-30,-97,-128,-128,-128,-41,-63,-82,-77,-100,-113,-85,-64,-13,42,44,
57,65,68,57,53,52,6,21,16,-7,-58,-93,-72,-35,70,82,72,83,99,63,9,-20,4,59,103,105,57,7,6,23,
13,16,28,41,33,-10,-33,-39,6,62,14,-11,-113,-122,-123,-2,-59,-76,-23,-19,-74,-56,-53,-60,-46,-36,-29,-26,7,19,
11,-27,-83,-64,-48,-28,-3,33,90,127,127,127,127,127,127,127,127,127,127,127,127,127,127,74,66,89,117,104,101,102,
94,53,46,63,127,127,127,127,51,-35,-95,-22,-30,-63,8,26,-11,-10,-3,-10,-6,-23,-53,-83,-79,-70,-51,-28,-14,-20,
-39,-27,12,19,27,65,79,77,64,74,88,100,127,127,127,127,109,110,106,86,76,79,69,62,69,88,105,92,88,92,
83,92,69,99,53,-27,-74,4,3,-9,7,62,79,82,49,11,-16,-26,-35,-43,-64,-97,-106,-80,-48,-15,-8,-30,-56,-79,
-68,-49,-15,-9,0,-16,-43,-88,-120,-99,-101,-89,-56,-84,-100,-97,-57,-47,-81,-109,-122,-126,-128,-112,-105,-97,-82,-23,68,-9,
22,69,14,12,40,127,127,127,127,127,127,92,-7,-57,-128,-128,-128,-128,-107,-85,-50,-84,-128,-128,-128,-128,-128,-78,4,55,
114,111,52,-8,-47,-34,-44,-37,-15,-40,-68,-109,-82,-9,-41,-52,-64,-73,-64,-48,-47,-50,7,92,127,127,104,127,116,87,
127,127,127,127,127,127,63,-25,-128,-128,-128,-128,-128,-68,-75,-96,-105,-119,-128,-128,-128,-128,-128,-92,-42,-49,10,94,127,125,
84,66,21,7,5,-20,-37,-59,-63,-4,105,113,58,-11,-36,-29,-33,-24,23,108,127,127,93,72,71,66,127,127,127,127,
107,41,14,-36,-78,-88,-91,-112,-127,-128,-128,-110,-82,-61,-37,-2,35,53,57,109,7,-84,-57,103,127,127,127,127,106,106,
106,91,52,19,-3,20,58,93,81,3,-55,-87,-73,12,72,73,127,112,58,55,74,96,118,127,127,59,36,28,-14,-66,
-76,-101,-122,-128,-121,-76,-21,54,123,127,127,127,127,127,127,127,127,127,82,33,43,28,26,97,127,127,111,56,15,15,
-38,-77,-43,-9,29,8,-37,-84,-81,-13,86,66,94,-14,-21,104,127,127,61,98,77,65,56,-34,-83,-37,-90,-80,-59,-44,
2,47,46,68,73,20,-25,17,84,127,127,127,127,127,127,113,38,-35,-61,-7,127,127,127,86,79,121,76,0,-74,-128,
-128,-128,-128,-128,-106,-40,-18,-14,-54,-128,-65,127,127,127,45,56,34,51,7,-59,-51,-52,1,-13,-9,3,1,-6,-28,-56,
-98,-128,-128,-128,-73,21,59,117,8,34,75,47,-4,-40,-87,-93,-49,94,127,127,127,119,68,-27,-113,-128,-128,-128,-128,-128,
-96,-87,-88,-47,-80,-104,72,127,127,127,51,54,60,77,5,-12,45,19,1,22,34,-8,-67,-88,-101,-125,-128,-128,-128,-128,
-128,-62,-1,81,120,53,23,-22,-64,-62,-85,-103,-82,-60,-57,-38,-48,-77,-40,-23,-94,-128,-128,-59,-2,12,23,13,-50,-85,
-103,9,127,127,127,127,12,11,46,88,74,38,8,-7,6,-1,4,-2,-32,-49,-71,-104,-128,-128,-103,-52,-85,-63,-31,70,
109,38,-8,-79,-57,-30,-65,-68,-53,-48,-64,-72,-82,-115,-128,-128,-128,-118,-76,-30,30,97,98,51,-57,-88,-115,54,127,127,
17,-28,42,54,89,90,43,-14,-45,-17,-20,8,48,63,40,9,-24,-42,-18,-48,-52,-89,-128,-95,-106,-92,-27,-27,15,-15,
-42,-51,-63,-38,-63,-36,-24,-15,-7,-27,-66,-98,-128,-128,-128,-49,49,127,127,127,79,-5,-99,-65,-107,-128,-128,-128,49,93,
92,-2,-36,-4,8,17,33,69,105,108,88,62,55,72,47,3,-11,-99,-128,-94,-91,-128,-128,-88,8,21,-10,-54,-61,-33,
-30,-1,12,0,-19,-25,-20,-16,-38,-109,-128,-62,20,117,127,127,127,127,24,-51,-128,-128,-128,-128,-10,48,10,-67,-4,48,
25,3,53,75,89,88,88,84,80,98,55,9,30,-73,-128,-95,-54,-104,-116,-92,-10,37,41,-4,-43,-47,13,45,47,18,
-18,-29,-19,-4,-15,-41,-42,-9,-23,-38,6,54,127,127,97,53,-16,-117,-128,-128,-52,-25,-62,-53,45,34,-36,-75,-6,41,
65,57,69,81,50,25,22,23,78,-44,-128,-104,-74,-38,3,-60,-28,26,44,22,-1,-28,17,55,73,61,42,26,35,59,
10,-8,-8,19,-7,-67,-84,-79,-21,55,84,83,70,-16,-122,-81,-50,-90,-83,20,65,-25,-83,-114,-36,54,91,53,46,69,
47,10,33,85,105,-51,-91,-64,-61,70,25,-66,-17,45,41,30,36,20,42,86,106,107,92,62,72,114,72,20,-33,-30,
-18,-20,-62,-128,-126,-41,26,92,109,21,-74,-23,-60,-74,-21,58,22,-65,-114,-128,-15,74,108,71,53,53,38,27,32,100,
127,-26,-50,-62,-27,108,72,-45,17,72,45,21,30,63,67,111,104,108,127,65,43,118,98,42,8,-11,-15,-17,-45,-102,
-92,-19,13,82,85,56,-36,7,-22,11,52,79,21,-75,-124,-128,-8,68,102,82,63,41,14,14,12,87,127,-15,-70,-95,
-51,67,21,-56,22,57,35,37,50,75,88,127,124,97,89,23,29,127,122,62,-19,-61,-50,-27,-27,-61,-128,-58,-10,78,
84,45,-43,-3,11,62,115,77,32,-64,-128,-113,13,100,123,99,63,34,15,7,25,44,96,-55,-128,-67,-29,69,-18,-95,
5,74,27,83,126,49,112,127,127,88,48,-24,-11,127,118,8,-126,-128,-54,-26,-20,-52,-100,-88,-43,46,61,43,-48,-14,
32,86,127,80,23,-80,-128,-120,-14,76,102,86,54,19,-9,-23,-18,-10,24,-96,-128,0,52,111,84,-16,34,62,7,47,
61,4,102,127,127,78,29,-33,-1,127,88,-3,-128,-128,-52,-18,-31,-58,-88,-100,-76,17,47,29,-78,-38,40,91,127,82,
16,-98,-128,-118,-40,46,72,66,41,0,-45,-70,-61,-89,-74,-128,-128,6,25,-19,-2,-46,12,42,21,37,22,6,19,104,
127,68,0,-31,22,127,71,8,-128,-128,-21,13,-17,-28,-56,-95,-109,-24,35,32,-82,-42,33,82,127,87,27,-92,-128,-98,
-36,43,59,52,32,-14,-70,-99,-83,-128,-128,-128,-128,-34,-49,-119,-95,-35,68,88,62,35,-11,8,-44,110,127,25,-39,-6,
79,127,51,12,-115,-128,11,59,22,16,-25,-94,-128,-58,29,48,-66,-34,29,60,103,94,47,-82,-128,-67,-13,57,61,43,
25,-21,-73,-102,-128,-128,-128,-69,-50,23,4,-10,-5,33,83,68,22,-51,-128,-128,-21,127,127,32,-19,56,127,122,18,-27,
-128,-128,5,100,74,50,-30,-116,-128,-86,14,51,-66,-45,29,39,79,89,46,-87,-128,-44,-10,53,52,34,10,-29,-72,-94,
-128,-128,-128,-68,-1,62,53,27,-33,-34,8,36,48,1,-116,-128,18,127,127,127,97,127,127,127,-17,-79,-128,-128,-23,127,
119,55,-39,-126,-128,-82,17,58,-71,-59,23,49,94,59,22,-100,-128,-26,5,38,39,45,11,-30,-63,-102,-128,-128,-128,-105,
-20,50,115,44,50,76,127,117,79,49,-57,-105,76,127,127,127,127,125,127,127,-58,-87,-128,-128,-43,127,127,44,-74,-128,
-128,-55,36,29,-79,-45,21,49,93,55,16,-106,-128,-28,5,35,36,46,13,-28,-63,-105,-128,-128,-128,-101,-18,32,99,49,
48,87,127,122,74,57,-35,-86,88,127,127,127,127,111,127,127,-61,-88,-128,-128,-51,127,127,39,-85,-128,-128,-57,33,23,
-83,-47,22,33,66,84,34,-101,-128,-56,-22,45,51,35,13,-27,-75,-97,-128,-128,-128,-64,6,46,17,20,-13,-4,35,59,
71,45,-51,-105,49,127,127,127,76,117,127,127,-23,-95,-128,-128,-43,114,109,36,-51,-128,-128,-82,10,59,-77,-68,19,56,
93,87,34,-94,-128,-82,-28,48,65,53,33,-19,-75,-102,-128,-128,-128,-59,-21,20,-34,-44,-17,39,99,93,59,-2,-89,-76,
42,127,127,40,-31,35,127,127,14,-40,-128,-128,-13,78,53,20,-45,-122,-128,-81,11,48,-82,-59,25,79,120,83,21,-96,
-128,-114,-54,32,65,63,41,-16,-77,-101,-96,-128,-128,-126,-124,-43,-97,-128,-128,-56,46,63,52,32,-10,42,1,127,127,14,
-55,-24,88,127,51,2,-117,-128,-5,32,-6,-16,-51,-106,-128,-50,28,37,-93,-55,36,89,127,85,20,-96,-128,-128,-54,40,
80,78,50,-1,-51,-71,-55,-85,-74,-123,-128,-30,-32,-69,-43,-68,-3,10,-14,-3,-29,-24,11,91,109,55,-10,-42,29,127,
59,-11,-128,-128,-39,-16,-50,-60,-89,-109,-110,-11,38,17,-112,-59,28,85,127,92,31,-77,-128,-128,-20,79,114,99,65,21,
-13,-22,-12,-10,22,-75,-128,-34,22,76,39,-55,8,29,-24,18,9,-49,73,121,127,76,20,-43,-1,127,48,-42,-128,-128,
-79,-54,-73,-96,-117,-106,-72,31,45,7,-109,-49,3,58,120,94,40,-62,-128,-128,5,103,127,107,68,32,10,9,30,49,
94,-46,-128,-84,-33,61,-23,-116,-19,44,5,69,88,2,86,127,127,82,30,-44,-27,96,55,-46,-128,-128,-97,-74,-73,-99,
-127,-92,-44,50,46,10,-85,-29,-25,5,58,93,32,-70,-128,-128,-12,82,119,89,63,38,13,17,25,96,127,-23,-73,-104,
-72,49,13,-82,-4,41,24,44,47,53,70,127,127,84,64,1,0,77,59,-12,-74,-112,-102,-80,-79,-104,-128,-68,-22,65,
57,16,-70,-17,-48,-66,-12,72,30,-66,-122,-127,-12,91,127,83,58,51,37,33,41,113,127,-35,-41,-66,-50,100,61,-62,
0,63,44,30,26,59,65,127,124,109,127,69,29,73,41,-31,-52,-71,-79,-75,-92,-128,-115,-36,-4,71,65,39,-48,2,
-38,-72,-79,26,79,-32,-94,-114,-32,72,119,78,66,80,53,22,42,103,98,-75,-84,-56,-100,49,18,-55,-13,33,25,31,
41,17,52,122,127,127,112,85,83,90,43,-22,-79,-81,-72,-70,-99,-128,-126,-43,28,105,121,6,-84,-31,-68,-4,-45,-61,
37,18,-57,-92,-7,56,94,94,112,118,79,54,38,44,71,-67,-128,-91,-106,-83,0,-41,-12,15,15,4,-10,-41,24,84,
113,99,81,67,64,56,-3,-28,-39,-20,-44,-94,-90,-61,18,91,118,111,86,-14,-114,-73,-41,51,51,-47,-23,18,-1,-33,
29,66,102,124,127,127,123,127,80,36,37,-74,-128,-61,-49,-119,-94,-64,2,24,14,-19,-46,-42,27,72,78,54,23,8,
6,0,-19,-46,-58,-32,-37,-38,38,119,127,127,127,80,-6,-108,-128,-123,-10,53,127,66,-24,-31,-30,-38,-9,36,96,127,
127,116,102,115,93,47,24,-66,-121,-45,-70,-128,-106,-64,5,8,-21,-63,-64,-25,-14,22,35,29,15,5,3,-5,-42,-108,
-128,-88,15,127,127,127,127,127,66,-17,-128,-128,-128,-128,-18,-24,78,127,110,5,-71,-64,-62,-32,14,46,55,49,25,7,
41,16,15,-22,-58,-35,-82,-71,3,-18,-5,-44,-74,-72,-66,-34,-55,-22,-11,2,9,-19,-68,-110,-128,-128,-128,-104,23,127,
127,59,35,-15,-61,-10,-57,-128,-128,-128,9,-48,-13,97,127,109,40,-19,-41,-44,-41,-47,-57,-49,-57,-84,-98,-120,-34,25,
6,21,8,85,121,43,-16,-102,-91,-44,-63,-79,-62,-47,-68,-84,-107,-128,-128,-128,-128,-128,-115,-66,3,78,82,11,-81,-90,
-90,90,127,127,83,7,67,43,19,28,1,54,122,46,-11,-10,-17,-55,-98,-108,-114,-128,-128,-128,-128,-95,-66,-8,21,94,
127,73,43,-20,-62,-40,-71,-115,-123,-91,-88,-68,-67,-92,-66,-55,-111,-128,-128,-63,4,38,69,46,-45,-65,-80,17,127,127,
127,127,56,77,45,27,-30,-43,27,30,46,-12,-48,-42,-33,-32,-42,-57,-104,-128,-128,-128,-60,34,64,127,73,102,127,96,
17,-12,-63,-91,-71,63,115,120,92,54,6,-74,-123,-128,-128,-128,-128,-120,-28,-10,-18,6,-34,-88,59,127,127,127,69,114,
100,78,59,-28,-63,4,-33,-15,-4,-30,-14,19,16,53,67,15,-22,21,99,127,127,127,127,127,127,127,33,-23,-25,23,
127,127,109,26,7,11,-19,-36,-50,-107,-128,-128,-128,-112,-48,38,59,39,-3,-128,-68,127,127,127,127,127,127,66,38,22,
-24,-54,-48,-60,-82,-104,-83,-38,4,78,127,127,127,127,127,127,127,127,127,127,113,35,14,1,11,70,127,112,41,-15,
-34,-25,-45,-36,1,29,45,14,-15,-55,-55,14,107,86,99,-29,-44,64,127,127,127,127,127,127,127,53,15,-37,-66,-67,
-69,-93,-103,-112,-128,-110,-100,-86,-57,-22,7,11,17,79,9,-63,-22,122,127,127,127,127,91,76,52,36,34,30,23,52,
71,100,81,-1,-59,-92,-83,6,75,84,125,75,39,13,44,98,127,127,127,127,127,127,107,12,-106,-128,-128,-128,-128,-110,
-128,-128,-128,-128,-128,-128,-128,-128,-128,-104,-42,-26,48,123,127,101,47,29,-14,-5,-2,-21,-30,-51,-74,-40,48,54,9,-49,
-64,-50,-45,-13,37,113,127,127,90,62,50,73,51,127,127,127,127,127,127,127,47,-10,-105,-128,-128,-116,-87,-65,-47,-105,
-128,-128,-128,-128,-128,-48,22,68,111,95,28,-30,-54,-26,-21,-4,14,-16,-49,-94,-78,-21,-43,-46,-54,-60,-53,-38,-33,-14,
53,114,127,127,98,127,112,94,-10,-1,11,52,71,77,62,27,-2,-16,-33,-45,-66,-94,-94,-61,-29,-9,-12,-39,-69,-86,
-68,-41,0,5,12,-9,-43,-92,-116,-83,-87,-81,-56,-73,-92,-104,-78,-63,-95,-117,-128,-128,-127,-114,-115,-100,-66,-36,58,-24,
2,43,-2,-12,-4,-47,-96,-81,-81,-93,-103,-99,-106,-75,-52,-75,-100,-104,-94,-78,-107,-108,-46,48,115,122,102,118,87,44,
38,60,73,59,33,30,46,48,22,-40,-39,-14,-25,0,-13,-3,-4,-29,-38,-45,-43,-40,-24,62,83,25,27,-82,-99,-53,
-54,-103,-128,-128,-128,-117,-110,-100,-64,-67,-66,-72,-88,-94,-88,-92,-61,-14,95,127,127,127,54,-1,21,54,92,100,112,115,
99,93,51,43,16,-4,24,33,13,33,28,15,-3,-7,12,10,15,14,76,127,127,79,-15,-121,-128,-128,-86,-122,-128,-86,
-30,29,70,88,39,16,16,75,127,123,61,-23,-18,11,50,53,30,-72,-128,-128,-128,-128,-82,-19,26,72,84,82,122,101,
58,35,64,91,102,125,127,127,119,108,107,90,91,94,127,127,127,85,12,-79,-128,-128,-53,-44,3,116,127,127,127,84,
-65,-17,85,127,116,48,8,-15,42,67,94,75,52,30,-60,-128,-128,-128,-128,-128,-128,-109,-12,35,15,54,53,33,7,28,
68,113,127,127,127,127,112,69,79,127,127,127,31,-47,-19,-45,-128,-128,17,65,127,127,127,52,-42,-99,-128,-12,111,62,
-76,-128,-128,-128,-128,-128,-56,-3,50,124,121,55,-11,16,61,38,-1,24,27,-16,-12,8,19,1,-24,-26,-17,-27,49,62,
88,117,101,72,66,100,75,-36,-126,-126,-26,6,-34,-36,19,49,13,-41,-128,-128,-128,-8,76,78,30,-76,-128,-124,-120,-128,
-128,-120,-77,-63,-28,66,110,80,42,46,53,0,-40,0,21,1,-15,17,19,-34,-79,-50,-18,-18,16,-14,-36,-23,-44,-45,
-28,8,-81,-128,-128,-128,-20,92,127,127,-41,-128,-128,-128,-128,-64,127,127,127,127,102,49,26,4,-46,-103,-119,-86,-14,21,
33,75,96,85,3,-32,-11,17,16,18,4,-22,-65,-71,-63,-36,-19,-47,-109,-128,-86,-60,-69,-107,-125,-110,-76,-69,-128,-128,
-128,3,127,127,127,81,-128,-128,-128,-128,33,127,127,127,127,109,60,54,30,-26,-63,-67,-20,36,68,76,60,38,59,99,
32,-32,-76,-88,-72,-27,-2,1,-40,-62,-70,-60,-65,-104,-128,-128,-128,-128,-117,-110,-87,-28,8,-13,-108,-111,-34,104,127,106,
70,22,-128,-128,-103,127,127,127,127,112,43,32,12,-13,-44,-81,-87,-70,-45,-23,23,25,-3,-35,-38,59,-85,-105,-114,-106,
-80,-43,-18,16,-22,-32,-19,7,8,-21,-70,-121,-128,-128,-128,-103,-77,-44,-25,-95,-128,-103,-50,-77,-128,-128,-123,-125,-128,-104,
78,127,115,87,59,53,43,21,-14,-56,-101,-128,-128,-126,-88,-51,20,12,-53,-84,-65,31,-28,-45,-59,-53,-30,6,13,14,
13,-10,-9,12,42,81,127,127,92,29,-24,-4,4,-57,-128,-128,-128,-128,-124,-128,-128,-128,-128,-128,7,127,127,52,-6,18,
33,48,65,5,-67,-128,-128,-128,-128,-100,-28,-4,36,-26,-96,-46,-2,58,113,100,50,-19,-37,0,20,35,12,-19,-21,2,
24,74,127,127,127,127,127,127,127,127,41,-12,-40,-40,-3,29,50,62,93,1,127,127,38,-58,-24,56,78,83,35,-30,
-119,-128,-128,-128,-91,-23,59,55,31,-80,-65,90,99,69,68,88,75,6,-32,4,51,102,37,-12,-14,3,12,28,74,123,
127,127,127,127,127,127,127,127,79,30,62,124,127,127,127,62,127,97,-55,-41,26,80,76,70,10,-44,-120,-128,-122,-61,
14,77,64,66,-22,-119,12,127,113,24,-22,-7,27,4,-40,-15,34,109,71,-2,-29,-22,-22,-14,24,78,127,127,127,127,
127,127,127,108,70,23,38,97,117,122,122,35,101,1,-102,-33,39,85,62,38,5,-37,-90,-105,-55,0,55,103,70,62,
-87,-128,74,127,127,96,51,-11,-6,10,1,13,36,124,72,-16,-75,-98,-104,-81,-17,57,81,84,127,127,127,127,127,114,
99,18,-21,16,45,70,93,33,38,-81,-114,-24,14,56,57,46,37,-8,-39,-42,-25,23,66,77,66,45,-128,-128,108,127,
107,94,110,3,-47,-39,-25,-9,29,111,72,-88,-128,-128,-128,-128,-101,-16,49,40,6,31,80,84,98,95,49,18,-9,-4,
24,52,68,16,-33,-117,-100,9,22,47,56,56,65,5,-27,-22,-12,16,66,93,71,49,-96,-89,109,127,67,71,48,-31,
-74,-77,-55,-52,-46,47,-39,-128,-128,-128,-128,-128,-128,-115,-29,-7,-43,-30,20,26,17,5,-20,-18,-33,-37,-33,-28,13,21,
-55,-121,-77,-16,33,68,82,56,64,25,-16,-18,-13,7,45,73,62,88,-45,-85,99,127,55,4,-74,-92,-106,-64,-25,-61,
-65,-19,-74,-128,-128,-128,-128,-128,-128,-128,-21,19,-61,-61,-29,-19,-3,11,-37,-81,-60,-35,-44,-16,5,15,-61,-128,-92,-35,
13,55,76,50,36,6,-22,-19,-7,8,32,35,62,94,-3,-35,78,125,35,-59,-128,-128,-77,-34,-27,-59,-46,-13,-43,-126,
-128,-128,-128,-128,-128,-128,-31,60,14,-13,-1,14,19,9,-29,-79,-69,-43,-44,-14,3,11,-57,-128,-107,-56,-6,43,68,43,
8,-6,-15,-3,4,9,18,8,44,67,17,-31,2,114,127,27,-128,-71,-12,23,3,-15,39,57,-38,-117,-110,-73,-61,-128,
-128,-101,-2,127,108,31,9,48,50,7,-18,-83,-88,-60,-44,-13,-3,5,-55,-128,-128,-78,-24,40,64,38,-1,-8,0,15,
3,-8,-1,-1,4,23,4,-67,-100,21,127,95,-33,-19,-14,11,33,74,117,64,-36,-116,-34,70,41,-123,-123,24,42,127,
127,54,10,70,75,6,-17,-82,-95,-69,-51,-27,-28,-9,-68,-128,-128,-106,-37,42,72,44,-4,-19,-6,17,-5,-22,-2,7,
0,27,24,-36,-102,-98,-13,33,0,-43,-40,34,76,86,89,35,-94,-128,-5,127,104,-57,-28,127,122,127,122,51,5,66,
83,28,-6,-69,-86,-63,-51,-46,-60,-31,-87,-128,-128,-114,-40,51,81,51,-8,-41,-33,1,-19,-28,2,19,18,32,49,22,
-17,-103,-108,-31,37,40,91,127,122,76,28,-27,-128,-128,5,126,79,-17,106,127,127,85,63,48,20,63,76,44,4,-60,
-74,-45,-36,-51,-76,-42,-111,-128,-128,-86,11,63,86,40,-6,-40,-34,-8,-35,-46,-8,18,47,26,64,-18,-52,-111,-92,101,
127,122,111,61,-4,-7,15,19,-106,-128,-102,-2,13,-14,127,127,127,78,63,22,15,93,70,36,5,-77,-82,-49,-40,-38,
-93,-30,-111,-128,-128,-78,21,69,88,40,-8,-43,-38,-12,-41,-53,-14,13,30,23,74,-11,-52,-124,-111,94,127,127,115,60,
1,8,29,31,-100,-128,-90,10,22,-13,127,127,127,76,68,25,14,90,67,37,3,-82,-87,-50,-38,-34,-88,-26,-83,-128,
-128,-96,-27,66,85,56,-17,-57,-48,-11,-28,-38,-6,12,22,46,52,31,-4,-104,-112,-44,39,52,104,127,127,113,53,9,
-128,-128,57,127,73,-38,80,127,127,85,66,63,20,43,63,40,-6,-69,-83,-37,-16,-37,-54,-35,-70,-128,-128,-85,-23,55,
70,43,-13,-32,-15,11,-15,-31,-5,7,3,40,38,-16,-75,-87,-16,9,-16,-39,-34,35,90,110,113,63,-92,-128,27,127,
77,-93,-54,127,127,127,120,57,7,54,72,18,-22,-81,-88,-41,-17,-22,-34,-23,-59,-128,-124,-60,-9,51,57,28,-14,-18,
0,16,-6,-16,0,5,5,36,21,-47,-78,21,122,59,-49,-33,-37,-18,11,71,125,68,-33,-106,-12,75,8,-128,-128,18,
67,127,127,49,4,60,66,-2,-35,-90,-85,-34,-10,-1,-2,-3,-57,-128,-105,-44,7,53,57,25,-9,-15,-9,3,-2,4,
22,15,47,72,29,-17,11,97,104,-19,-128,-89,-33,-14,-45,-48,15,21,-55,-115,-96,-69,-89,-128,-128,-111,20,127,124,27,
1,38,38,-3,-38,-86,-72,-23,-6,10,22,14,-54,-118,-92,-27,24,58,56,24,12,-10,-19,-11,-7,8,36,38,67,87,
4,-19,76,96,0,-86,-128,-128,-84,-47,-57,-95,-83,-51,-76,-128,-128,-128,-128,-128,-128,-128,-22,88,45,-5,1,10,5,-5,
-47,-74,-51,-11,-8,10,33,28,-42,-106,-80,-10,37,61,51,21,35,3,-18,-10,-7,12,51,75,66,74,-39,-65,90,118,
10,-9,-100,-103,-109,-71,-31,-72,-89,-48,-95,-128,-128,-128,-128,-128,-128,-128,-29,37,-27,-41,-12,-11,-11,-6,-46,-66,-37,-5,
-9,14,43,37,-24,-103,-96,8,28,40,29,22,35,-12,-29,-14,-5,24,74,96,71,42,-82,-85,84,125,30,54,28,-40,
-87,-78,-39,-43,-40,40,-50,-128,-128,-128,-128,-128,-128,-128,-37,3,-26,-16,27,25,9,-5,-28,-17,-17,-7,0,13,55,42,
23,-81,-108,-17,19,47,36,22,8,-29,-47,-39,-21,28,73,79,63,38,-106,-128,76,127,68,62,109,2,-58,-35,-12,-6,
41,122,69,-104,-128,-128,-128,-128,-116,-38,17,30,8,33,73,65,72,65,22,8,-3,13,41,74,99,39,88,3,-98,-30,
43,80,42,19,-22,-59,-108,-113,-55,-3,48,101,66,55,-60,-128,49,127,101,64,36,-22,-17,21,21,22,49,127,76,-14,
-74,-100,-106,-77,-20,38,47,56,102,127,127,127,108,83,76,9,-19,41,66,75,99,35,127,93,-49,-25,39,80,61,67,
1,-55,-128,-128,-123,-64,3,64,62,68,7,-87,16,127,76,8,-46,-20,20,11,-25,-6,48,116,97,14,-24,-23,-23,-9,
26,66,127,127,127,127,127,127,109,76,44,1,26,110,127,127,127,31,127,127,49,-43,-13,63,70,75,27,-35,-124,-128,
-128,-128,-88,-21,61,64,58,-43,-31,101,87,55,57,87,68,5,-26,7,64,110,37,-11,-13,3,12,34,79,117,127,127,
127,127,127,127,127,122,56,10,53,126,127,127,127,71,22,127,127,48,-16,14,33,31,63,12,-55,-118,-128,-128,-126,-62,
13,37,78,25,-37,13,38,54,98,99,50,-12,-32,-9,15,30,0,-27,-30,-12,3,51,125,127,127,127,127,127,127,115,
33,-21,-86,-69,-5,32,41,59,117,36,-128,-74,84,127,93,53,48,35,37,27,6,-31,-77,-117,-113,-90,-40,7,75,69,
7,-8,22,71,-7,-9,-30,-31,-20,-6,-1,-10,-14,-37,-39,-23,-1,36,87,108,80,22,-19,8,13,-53,-115,-128,-124,-124,
-113,-128,-128,-128,-123,-128,-128,-128,-78,127,127,127,127,65,20,21,18,2,-26,-61,-71,-62,-23,26,72,77,47,26,47,109,
-51,-55,-74,-81,-65,-40,-21,-9,-48,-53,-35,-7,-8,-38,-78,-128,-128,-128,-106,-79,-58,-26,-11,-73,-120,-97,-31,-42,-116,-128,
-116,-114,-111,-128,-128,-128,63,127,127,127,121,73,34,29,8,-37,-68,-75,-17,51,93,96,74,65,94,107,44,10,-21,-36,
-32,-6,10,2,-36,-59,-70,-55,-67,-105,-128,-128,-128,-128,-65,-68,-62,-14,19,-3,-100,-117,-30,114,127,79,42,8,-49,-128,
-128,-128,-128,-15,127,127,127,127,55,10,-13,-37,-80,-121,-128,-92,-12,17,31,95,119,77,39,11,32,63,54,33,3,-31,
-102,-110,-94,-50,-30,-53,-103,-128,-58,-18,-26,-83,-115,-110,-81,-71,-128,-128,-128,2,127,127,127,89,-9,20,-4,-35,-128,-128,
-102,43,99,100,43,-70,-128,-128,-128,-128,-128,-128,-84,-74,-32,66,101,59,21,29,34,-8,-26,15,15,-25,-101,-39,7,-29,
-91,-67,-13,2,43,2,-36,-33,-65,-56,-39,-5,-103,-128,-128,-128,1,100,127,127,-12,18,103,127,127,78,-2,-50,-74,63,
127,104,-39,-121,-128,-128,-128,-128,-56,-2,51,103,71,-6,-60,-49,-12,-27,-45,10,33,-11,-16,14,27,-6,-47,-49,-23,-20,
41,48,67,93,72,50,41,61,22,-80,-128,-128,-20,14,-28,-29,-74,-85,-41,83,127,127,127,117,-16,29,116,127,108,42,
12,-2,37,50,65,40,8,-31,-108,-128,-128,-128,-128,-128,-128,-68,38,83,74,87,57,23,-7,13,46,79,125,127,127,127,
82,37,45,89,127,79,-24,-70,-32,-59,-128,-128,-109,-128,-128,-110,-54,16,73,102,51,33,21,53,91,80,35,-35,7,56,
105,95,39,-92,-128,-128,-128,-128,-19,34,67,115,127,123,127,127,69,35,57,86,97,117,127,127,106,97,92,64,61,57,
127,127,108,42,-3,-99,-128,-128,-59,-116,-128,-128,-128,-128,-128,-104,-65,-66,-62,-60,-64,-67,-65,-78,-31,30,127,127,127,127,
68,12,53,89,127,127,127,127,127,107,64,55,30,12,27,27,10,27,12,0,-14,-12,7,-6,-6,-13,39,127,111,24,
-46,-128,-128,-128,-2,-42,-95,-81,-87,-102,-114,-107,-109,-74,-41,-57,-69,-71,-73,-60,-83,-84,-32,56,127,127,124,127,92,52,
57,78,84,73,42,27,52,51,27,-22,-30,-19,-29,-9,-22,-12,-12,-31,-34,-45,-44,-48,-43,51,35,-23,-19,-104,-118,-69,
-40,-98,-98,-11,-3,26,117,68,90,81,59,43,8,-34,-62,-80,-102,-109,-114,-95,-64,-67,-112,-107,-106,-101,-127,-128,-101,-113,
-128,-128,-128,-128,-128,-128,-128,-126,-128,-128,-128,-128,-128,-125,-111,-98,-89,-88,-89,-89,17,16,5,85,-115,-128,-43,-53,-35,45,
115,127,127,127,118,90,29,-24,-66,-56,18,88,105,86,83,88,72,15,-94,-128,-128,-128,-128,-124,-44,-23,-58,-65,-74,-128,
-128,-128,-128,-128,-128,-101,-128,-127,-126,-120,-85,-32,1,-4,-8,23,127,127,127,114,-103,-86,-35,-22,16,117,127,127,127,93,
49,9,-87,-128,-128,-80,59,127,127,127,127,127,127,127,127,127,56,12,-69,-74,-2,41,57,85,49,38,36,-2,-50,-66,
-37,33,42,46,42,48,61,80,77,46,17,50,127,127,127,36,-128,-84,-21,-2,50,127,127,125,63,13,-67,-30,-20,7,
22,30,26,9,5,-12,12,18,13,22,24,75,37,13,-54,-120,-128,-128,-79,25,127,127,127,127,127,109,38,69,51,25,
27,70,107,108,86,54,27,37,120,127,127,-27,-98,-47,-43,-20,28,90,65,-16,-29,-41,77,111,122,126,67,-30,-110,-128,
-128,-95,-54,-89,-122,-128,-128,-128,-128,-128,-128,-128,-128,-128,-128,-128,12,127,127,127,127,127,-13,-46,4,-1,6,50,97,109,
40,-56,-111,-21,60,106,-21,-128,-77,14,-19,19,52,23,-55,-118,-62,-21,127,127,127,116,12,-68,-81,-83,-109,-55,-25,-72,
-128,-128,-128,-128,-128,-83,-4,40,26,40,74,51,14,73,127,127,127,60,-119,-128,-91,-70,-41,-39,-43,-79,-128,-128,-128,-26,
23,8,-128,-128,-107,-10,-13,-14,-44,-75,-61,-36,37,71,96,61,-6,-64,-91,-107,-104,-79,-28,-46,31,40,28,27,-14,-3,
42,39,28,47,83,118,127,115,83,83,127,127,127,44,-49,-50,26,30,6,-54,-128,-128,-128,-128,-128,9,60,13,-128,-128,
-77,-42,-9,-38,-94,-91,-4,49,65,67,35,17,-41,-105,-128,-117,-47,36,70,61,122,127,127,120,119,127,52,66,73,84,
89,102,127,127,127,106,115,127,127,127,118,102,127,91,-10,-64,-90,-113,-127,-128,21,127,127,-31,-128,-128,6,24,-23,-117,
-94,-19,75,60,50,73,34,-45,-128,-128,-128,-90,-3,58,99,120,127,127,127,101,4,64,54,118,104,108,127,121,127,127,
114,84,74,87,108,115,127,127,127,127,98,20,-67,-128,-118,-23,127,127,127,-38,-128,-4,82,26,-15,-77,-28,41,68,59,
72,48,-10,-76,-128,-128,-65,-15,9,25,3,32,56,105,75,-60,-128,-70,14,32,19,54,85,71,90,106,78,37,16,25,
32,17,19,69,127,127,127,127,127,67,39,49,63,85,-2,-111,-128,53,109,41,-76,-103,-2,43,28,64,94,-25,-57,-66,
-73,-21,40,22,-26,-49,-60,-40,3,80,50,-98,-128,-36,66,49,3,20,62,42,40,59,82,31,-7,-32,-61,-106,-108,-56,
65,127,127,127,118,23,-62,-105,-128,-128,-116,-108,-128,-18,49,34,-95,-90,-31,-10,17,41,47,-49,-14,26,55,82,88,18,
-53,-87,-109,-83,-21,93,66,-106,-128,-3,95,107,42,25,77,67,25,18,57,6,-38,-66,-108,-128,-118,-47,-5,31,72,110,
94,35,-35,-88,-128,-123,-128,-128,-128,-81,2,12,-10,-4,-38,-39,34,14,18,27,78,117,127,121,87,21,-30,-58,-97,-100,
-24,115,55,-128,-128,-10,42,127,118,86,121,116,60,26,62,11,-35,-85,-128,-128,-118,-36,12,-9,-30,3,44,68,71,34,
11,-8,-119,-128,-128,-128,-14,28,40,48,-4,-13,23,-14,24,47,127,127,120,90,48,3,-18,-41,-66,-104,-13,127,17,-128,
-99,30,-45,90,126,88,95,108,106,94,58,5,-49,-108,-128,-128,-128,-110,-24,-61,-122,-110,-49,21,73,52,58,43,-77,-84,
-128,-107,-54,-22,10,-7,27,-28,-17,8,40,57,101,126,118,63,21,-3,-27,-46,-51,-113,-21,118,-4,-128,-106,-57,-67,89,
127,93,78,92,110,98,92,8,-39,-97,-128,-124,-91,-101,-107,-128,-128,-128,-128,-44,25,51,87,127,16,-44,-128,-124,-41,-21,
-12,-31,3,-49,-55,-23,34,55,93,127,120,50,-1,-15,-10,-8,-62,-124,-58,65,-18,-128,-128,-128,-128,46,127,100,96,118,
127,127,117,17,-57,-128,-128,-67,1,-37,-119,-128,-128,-128,-128,-96,-27,27,29,127,97,85,-37,-87,-57,-48,-42,-24,-42,-101,
-104,-69,11,50,84,121,94,30,-21,-34,-22,-9,-41,-104,-87,41,34,-128,-51,-128,-128,-39,96,59,89,127,127,127,127,29,
-58,-128,-128,58,127,-25,-72,-50,-128,-128,-128,-114,-80,-1,40,127,127,127,58,-3,-25,-47,-16,-9,-48,-119,-122,-90,-15,12,
74,105,86,36,-11,-26,-20,-9,-49,-84,-90,-7,-9,-128,-88,-128,-128,-64,46,44,103,122,126,127,127,25,-88,-128,-128,25,
127,-37,6,61,-128,-128,-128,-108,-92,-22,8,107,127,127,127,59,8,-34,5,-1,-57,-127,-128,-103,-34,-15,58,72,54,27,
-5,-17,-11,2,-24,-48,-55,-18,-35,-128,-63,-92,-128,-60,2,20,82,87,95,127,100,19,-90,-128,-128,-21,88,-37,28,126,
-109,-128,-128,-101,-115,-72,-36,57,118,127,127,127,59,-5,-4,-10,-56,-117,-125,-110,-42,-16,61,53,23,6,-11,-9,5,16,
-21,-33,-14,-9,-68,-128,-107,-99,-128,-103,-39,5,65,80,98,115,72,3,-94,-128,-128,-12,24,-74,-4,123,-92,-128,-128,-92,
-128,-128,-79,5,73,127,127,127,112,36,-12,-7,-43,-99,-108,-97,-33,3,82,64,22,-11,-26,-18,4,14,-8,-4,18,-21,
-112,-128,-128,-128,-117,-52,18,39,64,72,84,81,66,26,-53,-80,-65,-3,-51,-128,-42,98,-92,-128,-128,-76,-125,-128,-113,-37,
28,127,127,127,127,66,2,8,-25,-80,-77,-65,-5,30,108,101,44,-8,-34,-24,-5,10,-12,-8,26,-43,-128,-128,-77,-92,
-14,41,64,43,75,114,127,113,113,110,70,18,-11,7,-72,-128,-47,91,-101,-128,-128,-51,-97,-128,-128,-62,0,127,127,127,
127,79,35,7,-41,-64,-24,-18,-5,43,100,127,65,-4,-32,-23,-7,19,20,-9,25,-30,-128,-119,-7,25,127,127,85,74,
115,127,127,127,94,105,103,68,-15,9,-56,-111,-83,127,-100,-128,-128,-25,-75,-128,-128,-57,9,127,127,127,127,63,39,7,
-43,-64,-16,-10,0,45,102,127,69,-3,-30,-20,-4,24,16,-11,29,-24,-128,-128,-44,0,123,99,44,47,100,124,127,114,
76,90,98,61,-35,-9,-68,-117,-82,127,-91,-128,-128,-20,-71,-128,-128,-51,17,127,127,127,127,60,1,12,-20,-76,-69,-52,
13,42,117,110,52,-3,-26,-15,4,21,-11,-4,32,-57,-128,-128,-104,-128,-77,-25,3,-10,44,91,99,77,59,72,73,20,
-29,-26,-92,-128,-28,99,-83,-128,-128,-37,-82,-128,-128,-54,13,127,127,127,127,76,-18,-4,-35,-92,-99,-90,-19,16,78,60,
20,-10,-19,-8,12,24,0,12,31,-37,-128,-128,-128,-128,-128,-82,-8,19,46,48,61,62,46,21,-18,-42,-54,-28,-77,-128,
-33,99,-80,-128,-128,-54,-104,-128,-112,-30,39,127,127,127,127,62,-10,-7,-46,-112,-122,-109,-33,-4,53,43,16,5,1,8,
20,31,-1,-6,-4,-31,-108,-128,-128,-119,-128,-118,-42,18,74,78,106,127,100,46,-33,-78,-111,-38,-9,-74,-6,119,-83,-128,
-128,-66,-111,-125,-82,3,74,127,127,127,117,40,1,2,-48,-125,-128,-98,-25,-5,59,66,50,27,10,9,15,26,-1,-35,
-53,-37,-70,-128,-96,-99,-128,-74,-6,31,100,104,127,127,127,81,-29,-128,-128,-48,54,-40,28,127,-94,-128,-128,-76,-96,-68,
-48,47,110,127,127,127,78,14,-31,-16,-43,-113,-112,-77,-4,22,85,105,83,38,4,1,11,19,-24,-84,-87,-9,-22,-128,
-108,-128,-128,-57,46,52,116,127,127,127,127,72,-40,-128,-128,11,112,-51,6,71,-126,-128,-128,-94,-86,-35,-10,94,127,127,
127,86,39,-9,-71,-49,-41,-87,-82,-47,26,61,99,124,95,35,-4,-4,10,18,-28,-117,-82,49,37,-115,-66,-128,-128,-38,
89,61,105,127,127,127,127,49,-28,-127,-128,39,127,-48,-83,-46,-128,-128,-128,-110,-82,-22,26,126,127,127,74,34,11,-24,
-30,-52,-10,-46,-39,-2,50,70,104,127,114,50,9,7,12,7,-54,-128,-53,80,13,-128,-108,-128,-128,29,127,100,113,127,
127,127,117,23,-30,-107,-128,-74,-20,-78,-128,-128,-128,-128,-128,-94,-36,12,28,123,96,95,-1,-28,-13,-25,29,-14,10,-35,
-12,25,55,65,110,127,114,60,24,11,-10,-36,-63,-128,-19,127,36,-128,-52,-53,-74,70,127,95,92,101,123,111,96,5,
-30,-84,-128,-123,-107,-128,-128,-128,-128,-128,-128,-43,16,46,73,121,27,-7,-74,-57,-2,-4,85,82,-16,-6,32,-21,34,51,
127,127,109,80,38,2,-5,-33,-79,-120,-11,127,47,-126,-45,39,-65,65,107,96,109,111,111,101,59,-5,-68,-126,-128,-128,
-128,-128,-65,-75,-107,-89,-34,27,76,56,50,42,-52,-23,-52,-42,-30,-8,48,59,-22,-27,52,14,22,34,65,108,127,127,
91,23,-23,-63,-111,-127,-20,127,72,-126,-114,0,26,115,120,108,127,115,60,24,65,1,-59,-113,-128,-128,-128,-71,-41,-28,
-14,30,68,88,92,53,41,52,-42,-92,-128,-88,7,56,-32,-9,16,9,28,53,61,-50,-13,32,69,104,104,36,-31,-76,
-117,-115,-28,121,89,-112,-128,5,82,99,48,35,74,54,6,-6,44,-14,-64,-103,-128,-128,-128,-89,-37,26,95,127,127,72,
2,-64,-112,-57,-61,-67,-125,-53,10,37,-41,-35,66,89,43,74,113,-17,-43,-52,-59,-3,55,43,1,-29,-64,-62,-11,107,
95,-90,-128,-17,66,47,3,13,48,24,7,26,57,10,-28,-65,-107,-128,-128,-90,58,127,127,127,121,27,-56,-106,-128,-100,
-59,-46,-88,0,27,19,-27,-48,33,114,111,70,78,56,-11,-73,-128,-122,-48,0,20,31,3,23,34,115,127,-28,-128,-36,
46,41,18,37,56,35,47,80,46,2,-22,-20,-15,-27,-18,42,127,127,127,127,98,61,47,43,23,42,-31,-127,-128,22,
67,13,-67,-123,-62,52,127,105,77,74,31,-35,-121,-128,-128,-73,5,64,110,119,111,127,127,127,9,57,72,105,82,79,
92,73,92,116,65,31,21,36,64,71,83,127,127,127,94,17,-67,-128,-128,-65,57,127,79,-111,-128,-50,44,-15,-29,-78,
-114,-68,46,110,124,91,58,39,-18,-80,-99,-87,-29,43,81,65,120,127,127,127,124,127,71,81,69,76,102,106,119,127,
127,92,93,127,127,98,58,57,127,112,24,-16,-38,-81,-116,-123,-3,127,127,-32,-128,-128,-30,-26,8,-10,-68,-114,-84,-36,
65,102,108,73,8,-43,-54,-61,-66,-50,-16,-58,20,16,21,70,31,41,118,117,82,79,124,127,127,119,95,84,127,127,
127,25,-61,-51,53,73,61,16,-62,-128,-128,-128,-94,39,61,52,-128,-127,-72,-51,-19,31,61,16,-74,-128,-72,-38,119,127,
127,93,-3,-65,-57,-51,-90,-52,-42,-92,-128,-128,-128,-128,-128,-60,14,45,40,69,110,102,50,80,115,127,127,77,-97,-128,
-79,-30,7,-4,-9,-29,-59,-115,-40,23,40,24,-98,-128,-88,-7,-52,-20,50,108,66,-11,-10,-31,52,94,107,108,46,-40,
-100,-128,-125,-88,-67,-110,-128,-128,-128,-128,-128,-128,-128,-128,-128,-128,-128,-128,-5,85,127,127,127,127,-37,-80,-19,-16,-2,52,
118,127,72,-17,-53,27,76,94,-18,-108,-41,37,-38,-28,42,127,127,127,100,64,-13,15,18,48,62,72,76,59,32,10,
13,3,-12,-10,-7,30,-13,-31,-79,-127,-128,-128,-94,-4,93,127,127,127,127,54,-4,32,13,-8,1,57,107,104,73,46,
39,73,127,127,100,-31,-56,-8,-60,-78,-43,75,127,127,127,127,106,79,-3,-66,-88,-18,99,127,127,127,127,127,127,127,
86,72,1,-37,-102,-93,-9,45,60,86,40,26,19,-12,-56,-77,-54,-1,-2,7,3,7,27,50,49,33,7,64,127,127,
127,28,-94,-61,-79,-101,-89,-24,48,92,127,97,103,88,44,2,-46,-45,9,61,67,34,27,49,43,-18,-109,-120,-119,-122,
-128,-115,-33,-4,-45,-57,-56,-107,-128,-128,-113,-94,-84,-68,-102,-98,-104,-103,-67,-18,5,3,7,34,127,127,127,104,-96,-82,
-52,-121,-115,-41,-30,-3,73,25,47,44,23,0,-42,-72,-82,-90,-105,-118,-123,-103,-70,-70,-108,-105,-99,-100,-123,-128,-108,-107,
-126,-106,-128,-128,-128,-124,-92,-94,-119,-128,-127,-127,-128,-117,-95,-70,-62,-63,-58,-72,29,22,16,79,-125,-128,26,23,86,103,
100,73,67,31,-18,-39,-55,-45,8,44,64,65,111,113,68,3,-58,-67,-40,-60,-23,-26,-8,23,34,31,45,74,86,64,
58,64,54,23,26,21,-16,-13,7,16,37,30,7,27,46,94,64,62,127,127,127,53,-55,13,80,99,82,38,20,-21,
-81,-61,-44,-40,0,51,105,127,127,73,-37,-89,-89,-65,-57,-118,-81,-71,-67,-68,-72,-46,-27,-21,-16,7,23,-2,-2,-8,
-34,-63,-81,-114,-127,-128,-128,-128,-128,-77,10,17,8,61,127,127,127,33,-4,45,104,88,54,2,-10,-61,-28,-33,-58,-114,
-128,-122,-61,-41,-39,-51,-97,-101,-45,5,-7,-88,-61,-53,-41,-28,-25,-27,-22,-23,-13,46,62,-13,-43,-16,-43,-71,-100,-128,
-128,-128,-128,-128,-128,-78,51,8,36,127,127,127,104,-29,36,72,76,0,-46,-48,21,38,-39,-111,-128,-128,-128,-128,-128,-71,
-25,65,115,104,55,30,30,14,-58,-112,-128,-128,-128,-128,-85,9,117,112,107,37,17,7,-39,-24,-33,-35,-52,-95,-96,-76,
-67,0,47,16,37,127,127,119,-50,-108,23,5,-3,-55,18,67,78,55,-79,-128,-128,-128,-128,-124,-48,11,76,118,127,127,
96,35,16,54,23,-40,-128,-127,-110,-128,-128,-123,56,127,127,127,127,88,38,112,80,81,99,73,27,-25,-24,79,23,30,
7,127,127,42,-128,-128,-44,-74,-16,11,44,-33,-95,-120,-69,-94,-117,-126,-93,-43,28,58,63,23,-12,-2,43,21,-30,-1,
61,75,-27,-128,-128,-128,-128,-128,-68,74,127,127,127,90,36,127,123,103,127,127,120,58,34,80,115,113,71,127,127,-128,
-128,-128,-55,-12,36,54,-32,-106,-69,-6,127,93,26,-9,-9,10,0,-23,-98,-85,-114,-107,-65,-61,-109,-55,7,0,-45,-89,
-128,-128,-128,-97,-86,-31,5,8,26,34,57,127,120,109,98,53,20,94,127,127,127,127,71,32,-72,-128,-128,-128,-28,70,
62,-6,-27,24,86,127,127,46,-23,-9,25,22,-8,-26,-12,-32,-33,-24,5,27,-62,-91,-35,-63,-74,-51,-62,-71,-63,-82,
-55,9,35,-12,-35,-1,17,4,60,43,82,70,-17,-5,84,127,127,101,-13,-128,-128,-128,-128,-128,78,56,33,48,-5,76,
114,127,97,34,-6,-8,3,8,3,-3,-1,12,27,102,127,127,101,55,50,-18,-4,83,84,37,23,-23,-64,-40,-23,-33,
-30,-2,25,33,-20,-78,-106,-50,8,6,15,45,-43,-90,-128,-128,-128,-128,-128,-95,71,127,95,37,-20,47,48,113,101,67,
24,-13,-46,-37,-14,-9,19,35,48,123,127,127,127,127,71,-9,-15,71,84,44,34,-10,-12,-33,-47,-56,-32,25,77,97,
82,21,-101,-128,-108,-69,-75,-103,-128,-128,-128,-128,-128,-128,-128,-30,85,127,87,-51,-75,25,54,114,85,62,13,-58,-94,-50,
12,37,23,45,88,127,127,127,127,127,71,14,-12,16,20,25,39,-5,-13,-44,-57,-57,-52,-18,40,78,121,127,67,-3,
-40,-61,-89,-128,-128,-87,-6,25,55,41,-14,-25,127,127,-10,-83,-82,2,58,105,33,-21,-73,-102,-96,-40,6,24,32,19,
78,127,127,89,127,127,72,91,63,19,6,32,53,0,-16,-57,-75,-82,-89,-57,9,53,69,120,127,127,64,6,3,-2,
28,54,99,127,127,127,111,12,127,87,-76,-48,-53,6,61,61,-17,-77,-118,-96,-61,-34,-32,-37,21,25,74,111,51,64,
127,127,-6,107,105,18,-25,-3,50,34,-15,-60,-100,-126,-126,-70,2,33,33,34,62,106,105,76,33,0,12,82,127,127,
127,127,127,65,80,37,-65,-32,-55,24,58,11,-62,-86,-102,-89,-60,-45,-46,-31,-16,4,46,72,6,48,127,-2,-50,95,
99,1,-73,-61,15,53,-34,-89,-128,-128,-126,-29,46,60,57,20,12,45,118,127,74,-14,-28,-9,9,110,127,127,127,127,
49,24,-30,-21,-52,-12,22,5,-62,-60,-65,-62,-56,-52,-50,-41,-15,-30,45,115,42,23,127,19,12,120,35,-75,-86,-67,
-7,18,-44,-128,-128,-128,-91,68,127,80,35,-34,-54,-14,54,105,79,50,8,-76,-79,-7,105,127,127,127,44,52,8,-18,
-65,-27,7,31,-28,-22,-52,-86,-90,-76,-70,-56,11,-17,32,113,42,-19,61,-75,-85,20,-26,-81,-55,-35,-18,-59,-86,-128,
-128,-128,-27,127,127,90,-47,-100,-89,-72,-61,10,36,20,40,-58,-112,-88,16,118,127,84,83,61,-5,-33,-33,-24,14,56,
35,-28,-60,-94,-128,-120,-80,-65,-72,2,11,106,83,6,-55,-94,-128,-49,-7,-9,-51,-61,-48,-104,-128,-128,-128,-128,40,127,
127,127,-57,-128,-93,-47,-95,-117,-66,-2,41,-29,-73,-117,-37,41,127,84,69,37,-31,-54,-34,-5,28,68,48,-13,-43,-79,
-128,-128,-84,-44,-30,28,12,109,125,59,-41,-65,-108,-25,4,-17,-69,-67,-51,-102,-120,-121,-128,-128,31,123,127,127,7,-128,
-105,-36,-111,-128,-92,-45,22,-9,-47,-121,-67,16,127,80,42,16,-42,-61,-33,7,42,82,66,-14,-53,-82,-128,-128,-96,-52,
-21,13,-27,73,127,92,-23,5,-23,52,23,-31,-54,-32,16,4,-37,-43,-106,-121,-3,123,127,127,127,-128,-100,-39,-128,-128,
-128,-104,-26,10,-8,-120,-113,-30,116,74,43,29,-13,-36,-25,10,59,101,69,-21,-79,-103,-123,-119,-94,-59,7,37,-7,68,
126,103,0,8,104,127,33,-33,15,72,100,69,70,106,42,-67,1,127,127,127,127,-38,-80,-49,-128,-128,-128,-128,-73,20,
22,-121,-128,-85,83,54,37,29,0,-23,-37,-3,62,109,54,-27,-90,-117,-121,-101,-81,-52,13,44,30,87,116,127,106,65,
54,84,-14,-37,48,122,127,101,127,127,116,-30,9,127,127,127,127,-8,-79,-54,-128,-128,-128,-128,-118,9,34,-120,-128,-128,
33,20,20,9,-9,-30,-57,-19,66,110,33,-25,-82,-116,-126,-105,-67,-21,10,50,57,125,127,127,127,127,66,127,97,92,
103,121,127,70,100,127,119,-4,4,54,127,127,127,-4,-77,-26,-117,-128,-128,-128,-128,-6,37,-109,-128,-128,-6,-2,1,4,
7,-58,-99,-42,52,102,69,5,-53,-109,-128,-106,-60,-9,70,75,61,127,127,95,127,126,29,56,85,122,117,107,97,54,
90,127,127,32,-26,-70,85,127,127,-31,-87,-37,-66,-128,-128,-128,-128,-31,42,-100,-128,-128,-22,-5,1,6,12,-55,-100,-43,
52,102,70,7,-50,-106,-128,-104,-56,-5,82,81,67,127,127,84,127,107,18,36,57,90,78,69,72,40,77,127,127,19,
-47,-92,72,127,127,-46,-99,-43,-63,-128,-128,-128,-128,-31,44,-96,-128,-128,-22,-4,18,12,-5,-15,-49,-15,72,112,31,-21,
-74,-104,-114,-97,-52,1,32,69,75,110,105,127,127,127,14,82,59,61,56,59,77,17,68,110,101,12,2,55,127,127,
127,-16,-91,-22,-115,-128,-128,-128,-128,8,47,-92,-128,-128,-3,1,38,39,10,-8,-26,9,74,108,61,-20,-82,-103,-104,-88,
-61,-21,40,63,39,57,76,109,76,44,20,50,-48,-63,16,77,94,41,67,125,97,-6,19,123,127,127,127,-17,-93,-53,
-128,-128,-128,-128,-101,30,55,-96,-128,-128,40,25,41,40,-4,-26,-14,30,73,96,73,-22,-84,-95,-102,-99,-70,-27,38,57,
-6,24,91,90,-4,12,115,127,19,-37,13,57,68,24,13,68,28,-48,27,127,127,127,127,-51,-92,-53,-128,-128,-128,-128,
-57,41,43,-102,-128,-73,94,56,42,26,-39,-59,-24,28,56,75,62,-23,-68,-81,-117,-119,-75,-27,17,40,-33,26,117,94,
-8,27,11,66,32,-5,-24,-16,7,-29,-74,-41,-94,-103,21,127,127,127,127,-128,-107,-41,-128,-128,-128,-91,-8,31,8,-108,
-103,-20,118,66,73,50,-30,-58,-34,8,40,62,36,-24,-57,-80,-127,-120,-69,-28,-7,45,-2,76,127,62,-25,-34,-87,-28,
13,22,-24,-22,-19,-101,-128,-96,-128,-115,35,117,127,127,-28,-128,-115,-41,-115,-128,-83,-41,43,14,-29,-106,-53,21,119,57,
90,76,-7,-41,-39,-19,25,54,20,-37,-66,-95,-128,-108,-66,-50,-59,5,-4,94,103,7,-34,-62,-98,-34,19,35,-8,-6,
4,-87,-128,-112,-128,-111,44,127,108,127,-85,-128,-106,-51,-91,-93,-47,5,57,-10,-56,-97,-20,38,112,56,56,63,-4,-26,
-56,-26,16,37,-24,-36,-67,-89,-89,-69,-56,-50,13,-13,22,123,83,-15,55,-55,-57,36,12,-31,-27,-2,23,-32,-70,-128,
-128,-128,-18,127,127,66,-61,-102,-86,-57,-42,20,40,36,45,-41,-87,-77,15,85,119,62,54,30,-43,-23,-34,-12,28,22,
-49,-71,-82,-71,-56,-44,-36,-36,1,-37,24,127,93,35,127,38,5,118,54,-37,-46,-20,39,53,-22,-117,-128,-128,-92,55,
121,56,18,-26,-38,3,64,102,74,61,21,-53,-58,-18,72,127,127,108,78,63,-64,-40,-49,34,59,14,-41,-91,-128,-118,
-73,-49,-47,-29,-20,-8,34,87,53,74,127,10,-49,99,127,39,-45,-23,58,89,-5,-60,-121,-128,-118,-43,19,40,50,46,
48,61,115,127,80,-7,-16,18,-5,69,127,127,127,124,127,116,-48,-37,-52,13,61,54,-1,-73,-128,-125,-84,-47,-43,-48,
18,4,51,122,91,90,127,127,2,120,127,54,6,31,77,54,13,-34,-73,-98,-108,-75,-22,9,29,41,72,113,104,76,
36,-1,14,87,112,127,127,127,127,47,127,127,34,-42,-78,-4,54,96,37,-11,-67,-112,-112,-60,-19,-7,13,-8,50,127,
127,98,127,127,102,119,94,49,37,66,81,30,5,-34,-42,-42,-56,-48,-3,39,65,120,127,127,53,-7,-9,-18,9,39,
71,82,116,127,67,1,92,127,98,-5,-52,25,50,114,74,63,25,-49,-97,-67,-15,3,0,19,57,127,127,127,127,127,
61,7,-9,28,47,52,59,29,9,-19,-25,-25,-30,-9,35,65,101,114,48,-21,-53,-81,-125,-128,-128,-113,-23,8,52,52,
-7,-30,70,105,49,44,11,61,45,116,94,58,16,-22,-62,-58,-34,-32,2,17,22,106,127,127,127,107,22,-51,-40,61,
92,57,41,18,12,-11,-26,-38,-8,58,102,100,75,0,-128,-128,-125,-85,-85,-99,-121,-122,-127,-128,-128,-125,-79,-10,69,38,
-30,-4,-12,94,119,127,99,29,-12,-15,-19,-21,-22,-27,-24,-2,16,101,127,127,98,29,9,-52,-31,58,73,33,15,-9,
-55,-27,1,-4,5,39,45,14,-82,-128,-128,-106,-18,17,46,70,-12,-32,-53,-128,-128,-128,-128,-87,-8,66,9,-63,-84,22,
104,127,127,36,-14,2,17,8,-12,-31,-12,-13,-15,11,24,34,-47,-98,-56,-83,-84,-58,-67,-75,-63,-65,-26,27,50,-4,
-45,-24,-19,-48,4,-6,36,42,-37,-11,108,127,127,118,56,-46,-120,-128,-128,-128,-41,21,35,30,-90,-128,-86,11,127,79,
11,-17,-18,8,16,-1,-67,-42,-72,-46,-8,-12,-69,-47,25,14,-20,-55,-104,-128,-121,-68,-67,-18,17,4,0,12,36,86,
73,74,53,10,-2,104,127,127,127,127,101,98,-8,-128,-128,-128,-31,-42,20,35,64,-29,-103,-124,-74,-96,-114,-125,-105,-58,
31,66,93,55,32,44,90,101,59,45,90,93,-12,-124,-128,-128,-128,-128,-71,71,127,127,127,74,26,83,75,50,86,117,
126,65,29,87,102,104,74,127,127,-81,-128,-128,41,31,25,-22,58,94,80,53,-71,-128,-128,-128,-128,-128,-51,11,109,127,
127,127,127,75,50,54,-31,-76,-128,-128,-126,-128,-128,-88,89,127,127,127,127,53,16,72,62,67,87,64,12,-41,-21,106,
44,44,39,127,127,82,-121,-128,41,77,79,15,-1,10,61,57,3,-76,-119,-126,-128,-128,-128,-91,-60,51,127,127,59,-7,
-25,-43,-101,-128,-128,-128,-128,-128,-107,-17,97,119,127,58,12,-18,-60,-47,-56,-68,-89,-123,-115,-86,-63,11,71,30,62,127,
127,127,-12,-73,19,71,122,103,81,55,56,0,8,-9,-41,-94,-117,-103,-68,-83,-93,-96,-118,-113,-74,-49,-78,-128,-128,-128,
-104,-69,-58,-55,-45,-37,-19,57,71,-15,-69,-68,-93,-108,-128,-128,-128,-128,-128,-128,-128,-104,35,-8,20,103,127,127,114,-2,
-10,64,119,120,109,86,87,52,7,11,3,-11,17,57,102,111,105,38,-73,-128,-116,-74,-58,-113,-120,-110,-89,-74,-78,-61,
-37,-23,-25,0,-1,-56,-94,-120,-128,-128,-128,-128,-128,-128,-128,-128,-128,-128,-63,-43,-51,-1,118,127,127,52,22,51,107,117,
115,102,110,84,39,15,0,4,41,60,76,67,118,127,85,19,-31,-34,-9,-29,13,-10,-6,18,24,22,42,71,77,53,
26,9,-4,-24,-22,-19,-55,-56,-38,-23,-6,-16,-31,-10,12,79,43,25,127,127,127,62,19,-10,-13,-43,-39,-14,-7,-11,
-8,15,1,-34,-61,-83,-71,-59,-20,-13,-30,-75,-94,-128,-87,-34,-66,-41,-5,-23,-15,11,16,62,127,127,102,36,16,16,
8,-16,-33,-11,-14,-37,-48,-11,13,-19,18,84,83,127,127,52,-95,-25,9,7,36,51,90,111,36,-7,2,48,23,-36,
-43,-18,14,35,99,60,-18,-98,-128,-128,-128,-119,-128,-128,-128,-128,-128,-75,-22,42,115,127,127,127,127,103,80,75,36,56,
44,7,-9,26,23,-53,3,71,91,127,90,-122,-128,-128,68,92,125,87,80,33,-74,-87,-49,-57,-97,-118,-21,97,127,127,
127,127,86,-4,-61,-104,-124,-126,-128,-117,-101,-128,-128,-73,-9,69,127,127,127,127,127,127,105,37,96,92,42,2,8,56,
64,16,11,84,127,127,49,-128,-128,10,9,51,75,35,-27,-68,-125,-98,-64,-59,-46,4,110,127,127,127,127,127,127,116,
66,24,-41,-77,-82,-68,-114,-128,-128,-128,-84,-38,27,71,103,105,90,89,84,46,97,98,92,75,51,35,13,7,-51,15,
56,-4,-128,-128,1,79,-22,45,84,53,-10,-65,-64,4,60,59,51,26,37,45,27,46,34,2,-42,-31,11,90,127,127,
85,-24,-128,-128,-128,-128,-128,-128,-128,-113,-46,33,64,73,86,62,83,63,72,116,121,69,9,-15,-56,24,25,-87,-128,-86,
73,86,-53,30,78,64,-5,-78,-75,-27,-32,-28,-44,-111,-123,-123,-128,-128,-128,-128,-128,-111,-1,105,127,127,120,-5,-118,-122,
-19,17,-89,-128,-128,-120,-95,-73,-26,45,71,43,-73,-78,-38,52,88,49,40,34,64,79,-81,-128,-128,-63,29,35,-40,2,
29,50,21,9,-19,-44,-50,-29,-32,-56,-63,-74,-115,-128,-128,-128,-128,-51,81,127,90,127,119,11,-90,-76,40,67,-11,-28,
10,61,46,-6,-18,28,115,127,-79,-110,-113,-82,-63,-19,61,49,8,5,-128,-128,-128,-35,-33,-24,-41,-38,-42,-21,-16,-38,
-70,-126,-83,-48,-33,-42,-44,-35,-43,-53,-72,-57,-78,61,127,127,127,127,127,77,-2,-36,-19,-21,-49,-22,-9,7,-6,-4,
10,54,127,127,56,-59,-128,-128,-128,-68,-12,-29,-37,-92,-128,-128,-128,-112,-63,-21,-58,-114,-97,-46,-26,-95,-97,-65,-22,-36,
-19,25,48,40,20,15,6,23,42,113,127,127,127,-48,-59,-89,-87,-74,-55,-68,-68,28,16,-55,-107,-63,13,41,56,91,
118,127,66,-23,-39,46,59,55,47,-113,-128,-128,-65,10,69,58,-18,-51,-56,-54,-35,-73,-54,-32,-25,7,39,67,73,71,
65,79,72,43,8,8,48,95,56,-128,-128,-128,-128,-128,-128,-128,-75,44,21,-43,-104,-92,-34,1,-8,-26,-10,51,127,127,
127,127,127,127,127,-39,-128,31,127,127,127,107,3,-43,-51,-64,-32,-25,17,32,14,71,95,76,56,55,47,53,57,30,
-8,-44,51,63,-89,-128,-128,-115,-128,-128,-128,-128,-97,-7,12,-45,-108,-128,-96,-36,-29,-58,-59,-73,12,127,127,127,127,127,
127,127,87,127,127,127,127,69,9,-56,-77,-86,-17,-1,30,38,55,68,52,17,-6,-12,-9,8,-5,9,23,-4,92,25,
-128,-128,-127,-68,-101,-128,-128,-128,-92,-22,19,-60,-128,-128,-128,-103,-51,-57,-85,-109,-29,106,127,127,127,127,127,127,127,122,
99,93,16,-37,-31,-77,-93,-90,-21,3,50,48,40,25,-1,-18,-32,-40,-50,-50,-54,1,87,84,127,0,-128,-84,10,-21,
-100,-128,-128,-113,-37,45,57,-46,-128,-128,-128,-128,-71,-36,-83,-102,-29,73,104,99,105,127,106,127,65,-9,-31,26,-3,-4,
-73,-114,-96,-73,-33,-10,77,65,-3,3,0,-16,-25,-15,-29,-52,-25,6,91,83,80,-69,-111,-4,47,-58,-125,-121,-111,-83,
-40,-1,23,-63,-128,-128,-128,-128,-90,-33,-92,-119,-52,15,4,-26,-61,-49,32,85,37,-52,-108,-45,-20,-8,-85,-128,-58,-24,
-24,-18,54,36,-11,-13,-7,1,9,27,5,-31,-25,-2,127,108,45,-91,-93,85,61,-65,-123,-91,-70,-34,-6,15,3,-17,
-128,-128,-128,-96,-118,-20,-72,-67,4,59,6,-66,-98,-79,-44,-4,68,-39,-108,-108,-65,-5,-70,-114,-58,-10,53,41,45,-16,
3,0,-13,-13,16,57,36,-4,-10,8,127,127,62,-128,-126,93,76,-37,-70,-68,-108,-71,-20,2,21,45,-84,-128,-73,-32,
-65,-4,-5,-7,72,127,44,-45,-92,-94,-53,-3,119,18,-128,-128,-99,-20,-63,-100,-62,-20,88,79,61,0,4,19,8,3,
29,69,45,-1,-26,-34,64,127,39,-123,-92,88,46,-61,-40,-36,-114,-53,0,-1,57,83,-53,-67,11,53,20,10,103,117,
127,127,93,-20,-82,-128,-128,-33,88,78,-4,-128,-128,-47,-69,-110,-83,-29,103,95,62,-5,13,43,53,44,35,64,58,25,
-40,-23,64,127,78,-128,-128,-39,-30,-80,-32,-1,-42,-10,-10,-33,71,117,-5,-11,94,127,127,127,127,127,122,127,76,-12,
-55,-113,-128,-71,39,62,-2,-128,-128,-74,-89,-127,-92,-27,112,103,63,-15,-12,19,51,48,20,32,43,32,-7,-28,15,127,
125,-36,-128,-108,-57,-42,7,43,27,32,-5,-11,127,127,125,69,127,127,127,127,127,98,61,101,100,32,-12,-39,-104,-101,
-18,28,-6,-128,-128,-105,-124,-128,-96,-31,104,98,56,-23,-47,-30,-1,11,-14,-2,17,20,17,-72,-98,70,127,103,-53,-107,
-59,-30,5,93,127,115,42,65,127,127,127,96,124,127,127,127,127,49,19,110,127,127,73,46,-53,-96,-29,29,-4,-121,
-128,-110,-128,-128,-91,-32,98,87,49,-21,-58,-66,-62,-53,-57,-30,1,14,-5,-108,-128,-19,114,127,-36,-128,-22,24,1,34,
72,21,-12,106,127,127,127,80,127,127,127,127,127,37,-10,105,127,127,127,119,-12,-82,-17,44,2,-112,-127,-100,-128,-128,
-90,-30,92,80,40,-21,-63,-85,-110,-114,-106,-60,-14,11,-26,-123,-128,-70,85,127,36,-77,-14,63,40,72,96,-22,-121,-29,
127,127,127,48,127,127,123,88,114,18,-58,37,127,127,127,127,8,-76,-13,46,-9,-116,-121,-102,-128,-128,-128,-52,84,64,
24,-55,-74,-76,-122,-128,-128,-87,-31,3,-8,-103,-128,-54,124,77,6,-38,40,24,-45,5,67,-38,-128,-128,127,127,127,57,
127,127,69,55,73,10,-62,22,127,127,127,127,1,-84,-47,39,-19,-118,-128,-113,-128,-128,-128,-50,87,65,24,-60,-73,-75,
-123,-128,-128,-89,-35,-3,-4,-99,-128,-64,113,52,-15,-43,45,28,-46,-12,36,-68,-128,-128,115,127,127,42,127,127,65,61,
74,17,-63,17,127,127,127,127,-8,-95,-57,32,-23,-120,-128,-113,-128,-128,-84,-15,109,94,39,-26,-65,-95,-119,-115,-103,-61,
-20,1,-26,-128,-128,-90,57,127,37,-87,-21,82,62,74,81,-44,-128,-95,127,127,127,34,127,127,117,98,122,33,-70,6,
127,127,127,127,-7,-102,-27,24,-21,-126,-118,-99,-128,-128,-91,-17,117,103,48,-33,-68,-81,-74,-56,-55,-31,-4,8,-10,-128,
-128,-49,86,127,-27,-128,-7,45,25,62,96,32,-33,53,127,127,127,96,127,127,127,127,127,60,-27,61,127,127,127,127,
-18,-111,-46,12,-16,-121,-121,-91,-128,-128,-97,-16,123,112,51,-43,-67,-54,-20,2,-13,-4,10,8,3,-104,-128,43,110,93,
-40,-73,-3,17,36,111,127,118,39,53,127,127,127,123,127,127,127,127,127,111,18,70,127,127,90,60,-61,-128,-71,-14,
-28,-128,-128,-93,-97,-128,-93,-15,122,105,46,-50,-46,-18,22,33,15,24,29,12,-31,-65,-26,127,80,-50,-125,-43,0,14,
56,81,52,50,2,-11,127,127,127,102,127,127,127,127,127,127,73,62,80,45,5,-21,-124,-128,-63,-16,-35,-128,-128,-86,
-72,-115,-76,-16,104,87,34,-56,-29,3,27,32,25,47,40,7,-63,-55,30,127,31,-128,-128,16,-12,-43,20,49,3,33,
18,-15,67,127,35,15,105,127,127,127,127,127,127,85,44,-15,-55,-109,-128,-128,-3,24,-29,-128,-128,-53,-64,-97,-40,0,
86,63,24,-61,-42,-22,-11,-5,12,43,27,-11,-48,-55,43,127,10,-115,-66,104,55,-37,-12,-10,-80,-10,31,16,50,83,
-25,-54,12,81,53,23,127,127,127,127,55,-38,-101,-128,-128,-108,46,39,-32,-128,-122,-21,-63,-105,-27,17,56,27,12,-67,
-53,-46,-34,-22,-4,28,15,-19,-23,-12,127,127,27,-128,-124,70,65,-45,-73,-73,-101,-35,6,9,30,55,-53,-128,-76,-22,
-46,18,70,76,90,97,12,-70,-122,-128,-122,-70,79,-7,-128,-128,-73,10,-73,-128,-32,8,-5,-23,16,-19,-57,-49,-26,-8,
-7,5,-10,-44,-41,-18,127,101,11,-114,-114,69,71,-63,-125,-99,-63,4,19,18,5,-5,-128,-128,-128,-92,-109,11,-3,-3,
6,19,-35,-103,-128,-112,-79,-39,63,-42,-104,-95,-35,34,-46,-72,-68,-53,-4,2,52,20,-34,-20,-21,-35,-38,-25,-40,-60,
-45,-2,108,102,56,-121,-128,-12,59,-59,-124,-128,-114,-59,-21,-4,10,-66,-128,-128,-128,-126,-72,-1,-29,-81,-58,-25,-48,-72,
-87,-60,9,77,37,-43,-112,-21,40,41,-4,-25,-48,-67,-2,13,40,24,16,13,-9,-23,-27,-32,-45,-51,-62,-12,100,108,
115,-37,-128,-104,19,-29,-109,-128,-128,-93,-23,38,57,-37,-128,-128,-128,-128,-74,-16,-49,-73,-28,40,53,53,80,127,77,127,
73,2,-23,72,74,50,36,-20,-24,-36,10,12,36,44,65,84,70,35,13,2,-4,1,6,4,45,29,81,-15,-128,-128,
-118,-80,-127,-128,-128,-128,-95,-33,10,-65,-128,-128,-128,-128,-71,-45,-60,-84,-19,104,127,127,127,127,127,127,127,127,127,127,
83,-4,23,-13,4,-1,2,-10,38,69,52,114,127,127,96,69,44,40,62,36,36,8,45,14,-128,-128,-128,-114,-128,-128,
-128,-128,-106,-21,8,-45,-90,-99,-80,-50,-34,-33,-7,-24,42,127,127,127,127,127,127,127,127,127,127,127,127,82,-9,-24,
-15,-11,3,-43,-28,10,12,54,99,127,127,108,87,94,86,73,66,55,36,39,-9,-128,-128,-128,-128,-128,-128,-128,-86,34,
22,-27,-65,-41,1,19,18,10,2,68,127,127,127,127,127,117,127,-31,-128,42,127,127,127,103,-56,-102,-78,-17,26,-24,
-48,-28,13,9,33,79,97,80,58,54,52,84,111,127,121,83,45,-123,-128,-128,-128,-114,-75,-74,-66,25,24,-24,-57,-16,
31,43,63,91,127,127,60,-47,-88,7,38,26,-10,-128,-128,-128,-79,18,70,39,-40,-48,-32,-17,18,41,10,-45,-20,3,
12,4,-1,-2,-9,-13,-12,24,33,126,127,127,82,114,95,17,-42,-46,-5,0,-34,-12,-5,25,31,32,13,32,117,127,
63,-56,-128,-128,-128,-108,-48,-66,-99,-128,-128,-128,-128,-91,-39,-28,1,22,42,14,2,62,41,15,8,24,19,-10,-28,-45,
-80,-116,-89,-87,-99,-26,90,118,35,127,71,-21,-100,-76,46,73,-12,-34,18,91,106,58,10,23,108,121,-90,-128,-126,-103,
-103,-71,20,12,-49,-35,-128,-128,-128,-25,-4,-13,-9,73,123,57,-28,-65,-45,27,-25,-35,-53,-128,-128,-118,-128,-128,-128,-128,
-128,-83,-11,62,127,127,43,-86,-128,-128,-54,29,-60,-128,-128,-92,-57,-35,6,55,50,2,-119,-128,-83,5,33,-14,-24,-6,
28,23,-128,-128,-128,-78,27,18,24,87,127,60,-29,-81,-73,17,47,19,-12,-62,-64,-60,-82,-59,-33,-35,-41,-28,-9,35,
81,127,60,-46,-128,-128,-128,-128,-128,-128,-128,-85,-13,68,102,97,81,30,26,-2,12,60,63,17,-24,-22,-60,-5,-39,-128,
-128,-108,56,55,39,86,104,32,-36,-95,-128,-110,-57,-51,-32,3,77,109,84,90,98,100,104,94,52,-8,-68,-73,-8,-23,
-62,-120,-128,-100,-69,-25,19,68,118,127,121,110,79,16,56,40,33,25,10,6,-6,-7,-37,38,47,-42,-128,-128,-2,44,
95,127,127,77,69,-4,-128,-128,-78,-66,-84,-101,-9,99,127,127,127,127,127,91,42,-35,-92,-93,-128,-123,-111,-128,-128,-94,
-48,20,81,127,127,127,127,113,58,-7,36,31,-3,-31,-19,41,65,31,34,127,127,127,29,-128,-107,4,6,17,40,19,
71,85,-12,-71,-47,16,15,-23,-7,34,77,100,127,112,44,-19,-41,-95,-115,-86,-128,-128,-128,-128,-128,-128,-93,-28,69,127,
127,127,91,49,27,26,-4,24,23,-6,-17,30,38,-27,57,127,127,127,115,-69,-128,-82,16,-3,-5,-69,-60,-33,-12,-13,
-22,5,-8,-36,-54,-69,-36,-12,55,65,37,-23,-47,-75,-49,-9,-45,-49,-42,-69,-60,-24,-1,54,126,126,99,37,10,6,
5,-5,-31,-4,3,-10,-15,24,45,13,68,127,127,127,127,111,9,48};

unsigned char FaceRecognitionExtractionTool::MeanfaceDataTable[2576] =
{75,122,112,111,108,105,104,101,100,98,97,95,93,92,91,89,89,88,87,86,87,87,88,88,88,88,88,89,
89,91,92,93,93,93,92,91,92,93,93,93,94,94,94,94,94,94,94,94,94,94,93,93,91,89,91,51,119,178,
173,167,163,159,156,153,149,145,140,137,134,133,130,127,125,124,123,123,125,126,128,130,129,
130,133,135,137,140,143,143,143,143,141,139,137,136,137,138,139,141,141,142,142,142,142,142,
143,143,141,139,136,135,131,84,113,172,166,159,156,151,147,142,138,134,128,122,116,111,107,
104,102,101,102,104,107,109,112,115,116,118,122,128,133,138,141,142,141,140,138,136,133,130,
128,129,129,130,131,132,133,133,135,137,137,139,136,132,132,130,124,76,109,166,158,152,148,
141,134,129,120,115,106,98,91,87,86,85,85,84,83,84,87,90,95,99,103,107,114,120,124,129,133,
136,135,133,131,130,129,128,127,127,128,128,127,128,130,131,133,133,136,138,133,129,128,123,
119,75,106,160,152,145,135,125,115,107,95,89,81,77,76,75,75,74,75,75,74,75,76,78,82,85,91,96,
105,114,119,122,124,126,127,126,127,128,127,129,131,131,131,130,129,128,128,130,133,134,137,
134,127,125,121,117,114,72,100,151,140,128,115,104,95,85,76,74,72,72,73,73,74,75,76,76,75,76,
77,78,81,83,86,92,102,110,115,118,119,122,122,123,125,124,124,127,129,128,130,131,132,131,129,
128,130,132,132,127,122,119,112,110,109,69,94,139,123,109,96,87,79,72,68,69,71,73,76,78,81,82,
83,84,84,85,85,85,87,90,94,102,111,117,121,122,122,123,123,123,125,127,127,128,128,128,128,
128,130,131,130,130,130,130,128,122,115,110,104,103,103,65,86,126,107,94,82,73,68,66,66,69,74,
79,84,88,91,93,97,99,100,100,100,101,103,105,109,117,125,130,132,132,131,130,129,125,126,128,
129,127,125,124,125,126,128,130,131,130,129,129,123,117,110,103,99,99,98,60,79,108,95,78,72,
66,64,64,68,74,81,88,95,101,105,110,113,116,116,115,111,110,112,116,120,127,133,139,142,142,
142,140,137,134,131,129,128,127,125,123,123,121,122,124,127,130,129,124,115,110,103,101,96,96,
93,58,70,95,82,69,66,61,63,66,73,81,90,98,105,111,116,121,124,126,124,119,111,110,114,118,125,
133,140,145,148,148,148,146,145,142,138,135,134,132,129,127,123,120,118,118,117,118,116,111,
106,103,98,97,92,92,91,56,60,82,71,62,61,60,65,71,79,89,100,108,115,121,127,132,135,136,130,
118,107,111,115,116,119,131,141,148,152,153,153,151,150,147,144,141,139,138,136,133,130,125,
120,115,111,107,103,100,100,99,97,98,95,95,94,59,53,73,65,59,60,62,70,76,86,96,108,116,122,
127,133,139,143,142,131,113,104,114,116,107,106,123,138,148,154,155,155,155,153,151,148,145,
143,142,139,137,133,129,126,121,115,108,102,100,99,99,99,101,99,100,99,62,47,66,61,56,60,64,
73,81,92,103,114,122,128,133,138,144,147,144,130,109,104,118,113,96,101,120,136,148,156,158,
158,157,156,155,152,148,146,144,141,139,134,133,131,127,121,115,109,104,102,101,100,103,101,
103,103,64,43,61,57,56,61,66,75,86,97,109,121,128,134,139,144,148,151,147,130,108,107,119,
106,90,105,123,137,147,155,159,159,157,159,157,154,150,147,144,140,139,136,135,134,131,125,
119,113,107,104,103,103,105,103,106,106,67,40,57,56,57,63,69,78,90,103,115,126,133,139,144,
147,152,156,151,132,108,108,117,100,85,101,120,136,147,155,159,159,158,159,157,153,149,146,
141,136,135,134,134,135,133,128,122,115,110,106,104,102,104,103,109,109,71,37,54,56,58,64,71,
81,94,108,120,131,137,143,146,150,154,159,154,133,108,107,115,97,83,96,117,135,147,155,158,
159,159,159,156,152,148,145,139,132,130,131,132,134,133,130,125,119,114,108,105,101,102,102,
108,109,70,36,54,56,58,66,73,85,99,113,126,137,143,147,150,154,158,162,158,139,109,105,112,
96,92,108,119,132,145,153,157,158,157,157,153,150,145,141,135,128,125,122,123,129,131,130,128,
123,117,112,108,102,102,101,106,110,71,36,54,56,58,66,74,87,101,116,129,140,146,150,153,157,
161,165,162,144,114,106,113,103,101,113,122,132,143,152,155,155,155,150,146,143,139,137,132,
125,120,115,116,125,130,131,130,126,122,116,112,105,103,101,106,110,71,35,53,56,58,66,75,89,
105,120,132,143,149,154,157,160,164,167,165,152,124,110,115,109,105,110,119,130,141,148,149,
148,146,141,136,132,129,129,128,122,116,108,109,120,129,131,131,129,126,121,116,108,105,102,
106,111,72,35,53,55,57,65,76,91,106,122,134,145,152,156,159,162,165,168,169,162,138,120,121,
116,109,112,121,131,140,144,144,142,139,136,126,121,120,123,123,118,113,106,106,117,128,130,
130,130,128,125,120,111,107,103,107,111,72,34,52,55,57,66,76,92,108,123,135,147,153,158,161,
163,167,171,172,169,152,135,130,125,119,120,125,131,137,140,142,143,142,135,121,115,117,121,
121,116,112,106,105,115,125,127,128,130,130,128,123,114,108,104,108,112,73,34,52,55,57,66,77,
93,109,124,137,147,154,159,162,165,168,171,172,171,162,147,141,136,131,133,134,137,141,145,149,
151,152,144,129,121,120,122,121,116,112,107,105,113,121,123,125,129,131,130,125,115,109,104,108,
113,73,33,51,55,57,66,77,93,109,125,138,148,154,159,163,165,168,171,171,169,163,153,148,145,142,
146,147,149,154,158,161,163,164,153,137,127,124,123,120,116,111,107,104,111,118,120,123,128,132,
131,125,116,110,104,109,114,74,33,51,55,57,66,77,93,110,126,138,148,154,159,163,165,168,170,171,
168,162,153,151,148,145,148,151,154,157,161,163,165,165,155,138,128,125,124,119,115,110,106,103,
110,117,119,122,128,132,131,125,116,109,104,108,114,74,33,50,54,56,65,76,93,111,127,139,149,154,
159,163,164,167,170,170,168,160,147,140,132,128,131,135,139,147,153,156,157,156,146,130,122,123,
123,121,116,110,106,105,111,119,121,124,128,131,129,124,113,108,103,107,113,74,33,51,54,55,65,
75,92,110,126,139,149,154,159,162,164,167,169,169,164,149,133,126,118,113,118,125,131,137,143,
146,147,146,138,124,118,120,123,122,116,109,104,104,112,122,125,127,129,130,127,122,111,106,102,
106,112,73,34,51,54,55,64,74,91,108,125,139,149,154,158,160,163,166,168,167,157,134,117,114,107,
101,108,118,127,135,141,143,143,141,136,126,122,124,126,126,119,110,103,104,115,125,128,130,130,
129,124,119,109,104,101,105,111,72,35,53,55,56,63,73,89,107,124,137,148,153,157,158,161,165,167,
164,148,121,107,109,102,97,107,114,124,136,146,148,147,145,142,136,133,133,132,129,122,114,105,
107,119,128,130,131,129,126,121,115,106,102,100,104,110,71,36,53,55,56,63,71,87,105,121,135,146,
151,155,156,159,163,166,161,140,111,102,107,99,94,111,117,125,138,149,152,150,150,149,145,142,
140,137,132,124,117,110,113,123,130,131,130,127,123,117,111,102,100,99,104,110,71,38,54,55,56,
62,69,83,100,118,131,142,147,152,154,157,161,164,157,134,105,100,106,95,86,102,116,127,140,152,
156,156,156,155,151,147,143,139,133,126,122,117,120,127,131,130,128,124,118,111,106,99,99,99,104,
109,71,42,57,56,56,61,65,78,93,111,124,135,141,146,149,153,157,160,154,130,104,103,110,94,81,91,
111,128,142,154,157,158,158,158,154,150,145,141,135,130,127,125,126,130,131,128,125,118,113,106,
102,98,100,101,105,109,70,46,61,58,55,60,63,73,88,104,117,128,135,141,145,148,153,156,150,127,
104,106,115,97,79,92,113,130,145,156,159,159,159,160,156,151,147,144,138,133,132,131,131,131,130,
126,121,114,108,102,101,99,102,103,107,110,70,50,70,61,57,58,60,68,80,95,106,118,126,134,139,144,
147,150,146,127,106,106,114,102,87,105,117,132,146,156,159,158,158,159,155,151,147,144,141,139,
137,135,133,130,127,122,116,109,105,102,101,100,102,102,106,107,68,53,76,66,59,58,60,66,74,87,98,
110,118,125,131,137,141,144,142,127,106,103,113,106,91,95,114,133,148,157,158,157,156,156,153,149,
145,143,142,140,138,134,131,129,125,118,111,106,105,103,101,99,101,100,102,102,65,56,81,71,63,60,
59,63,69,78,89,100,108,115,122,128,132,135,136,127,108,101,110,111,102,100,119,137,147,154,155,
154,153,152,149,144,141,139,138,137,135,132,129,125,120,113,107,104,103,101,99,96,98,96,98,98,63,
61,86,76,69,65,60,60,64,72,81,91,98,105,112,118,122,125,127,124,111,101,105,112,113,115,129,139,
145,150,151,151,151,147,144,141,138,136,135,133,131,128,123,118,112,106,104,103,101,99,97,93,94,
94,95,95,60,69,96,84,74,71,66,63,62,67,72,80,87,93,99,105,110,112,114,115,109,101,102,109,115,120,
129,136,140,145,147,147,147,143,141,138,136,134,131,128,126,120,115,110,108,107,108,106,103,102,
100,94,91,87,89,91,58,77,109,96,82,76,70,67,63,63,65,69,74,80,84,89,92,97,99,101,101,98,98,103,
109,115,123,131,135,138,140,141,140,139,135,131,128,125,121,118,116,113,114,115,117,118,119,115,
110,104,99,93,91,86,87,91,58,86,123,111,96,88,78,73,68,68,66,65,66,69,71,74,77,80,82,84,85,85,86,
90,94,98,107,116,122,126,128,128,128,125,122,120,119,117,115,116,116,119,122,125,126,127,125,123,
119,111,106,99,97,92,92,95,62,95,137,125,111,105,93,84,77,74,72,70,67,66,65,66,68,68,68,69,69,70,
72,75,78,81,89,98,104,109,113,115,116,118,118,120,121,120,120,122,122,124,126,127,128,128,128,126,
124,121,115,107,104,99,99,102,67,101,154,140,129,120,112,102,94,85,82,78,77,74,71,69,66,66,65,64,
64,63,64,68,71,76,82,91,100,107,111,115,119,123,122,123,125,125,125,126,127,125,126,127,127,125,
125,125,125,127,125,120,113,108,106,108,69,103,161,153,145,137,128,120,112,105,100,95,94,92,89,
84,80,77,76,75,75,73,73,76,80,84,90,98,107,114,120,124,126,125,127,128,129,129,129,130,129,127,
126,125,125,124,125,128,129,129,128,125,119,113,112,113,71,109,167,162,156,149,142,135,128,124,
119,114,111,109,106,103,101,97,93,90,90,89,89,91,94,99,102,107,113,120,125,128,130,130,132,132,
131,132,133,132,131,130,129,130,130,131,131,132,132,131,130,129,125,121,122,121,74,112,171,168,
163,158,153,148,143,137,134,130,127,124,121,119,116,114,111,107,105,106,107,109,110,114,117,121,
125,129,132,133,135,135,134,134,134,135,136,137,136,136,138,139,139,138,136,136,136,135,134,133,
132,129,131,127,79,123,180,176,172,169,165,161,157,151,148,145,143,141,139,136,134,132,130,127,
126,126,127,128,128,130,131,133,134,134,136,137,139,139,139,139,141,144,146,147,147,147,148,148,
147,146,144,144,143,143,143,142,142,138,137,133,87,72,122,115,114,111,109,107,104,104,102,101,99,
98,97,95,94,92,91,90,90,90,90,89,88,88,89,89,89,89,89,90,90,91,92,93,95,96,96,97,97,96,97,96,96,
96,95,95,95,94,95,93,95,92,89,89,50};

