/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.Config;
import bluej.editor.moe.MoeActions;
import bluej.editor.moe.MoeEditor;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.FixedMultiLineLabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Properties;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public final class FunctionDialog
extends JDialog
implements ActionListener,
ListSelectionListener,
ItemListener {
    static final String title = Config.getString((String)"editor.functions.title");
    static final String close = Config.getString((String)"close");
    static final String defaultsLabel = Config.getString((String)"editor.functions.defaults");
    static final String categoriesLabel = Config.getString((String)"editor.functions.categories");
    static final String keyLabel = Config.getString((String)"editor.functions.keys");
    static final String addKeyLabel = Config.getString((String)"editor.functions.addkey");
    static final String delKeyLabel = Config.getString((String)"editor.functions.delkey");
    private FocusManager focusMgr = FocusManager.getCurrentManager();
    private JButton defaultsButton;
    private JButton closeButton;
    private JButton addKeyButton;
    private JButton delKeyButton;
    private JComboBox categoryMenu;
    private JList functionList;
    private JList keyList;
    private FixedMultiLineLabel helpLabel;
    private MoeActions actions = MoeActions.getActions(null);
    private Action currentAction = null;
    private KeyStroke[] currentKeys = null;
    private Action[] functions;
    private int[] categoryIndex;
    private int firstDisplayedFunc;
    private Properties help;

    private void handleClose() {
        this.removeKeyListener();
        if (!this.actions.save()) {
            DialogManager.showError((Component)this, (String)"cannot-save-keys");
        }
        ((Component)this).setVisible(false);
    }

    private void handleDefaults() {
        int n = DialogManager.askQuestion((Component)this, (String)"default-keys");
        if (n == 0) {
            this.actions.setDefaultKeyBindings();
            this.handleFuncListSelect();
        }
    }

    private void handleFuncListSelect() {
        int n = this.functionList.getSelectedIndex();
        if (n == -1) {
            return;
        }
        this.currentAction = this.functions[this.firstDisplayedFunc + n];
        this.updateKeyList(this.currentAction);
        String string = this.getHelpText((String)this.currentAction.getValue("Name"));
        this.helpLabel.setText(string);
    }

    private void handleKeyListSelect() {
        this.delKeyButton.setEnabled(true);
    }

    private void handleAddKey() {
        this.helpLabel.setText(this.getHelpText("press-key"));
        this.addKeyListener();
    }

    private void handleDelKey() {
        if (this.currentKeys == null) {
            return;
        }
        int n = this.keyList.getSelectedIndex();
        if (n == -1) {
            return;
        }
        this.actions.removeKeyStrokeBinding(this.currentKeys[n]);
        this.updateKeyList(this.currentAction);
    }

    private void updateKeyList(Action action) {
        this.currentKeys = this.actions.getKeyStrokesForAction(action);
        if (this.currentKeys == null) {
            this.clearKeyList();
        } else {
            String[] stringArray = this.getKeyStrings(this.currentKeys);
            this.keyList.setListData(stringArray);
            this.delKeyButton.setEnabled(false);
        }
        this.addKeyButton.setEnabled(true);
    }

    private String[] getKeyStrings(KeyStroke[] keyStrokeArray) {
        String[] stringArray = new String[keyStrokeArray.length];
        int n = 0;
        while (n < keyStrokeArray.length) {
            int n2 = keyStrokeArray[n].getModifiers();
            stringArray[n] = KeyEvent.getKeyModifiersText(n2);
            if (stringArray[n].length() > 0) {
                int n3 = n;
                stringArray[n3] = stringArray[n3] + "+";
            }
            int n4 = n;
            stringArray[n4] = stringArray[n4] + KeyEvent.getKeyText(keyStrokeArray[n].getKeyCode());
            ++n;
        }
        return stringArray;
    }

    private void clearKeyList() {
        this.keyList.setListData(new String[0]);
    }

    private void clearHelpText() {
        this.helpLabel.setText(null);
    }

    private void openHelpFile() {
        this.help = Config.getMoeHelp();
    }

    private String getHelpText(String string) {
        if (this.help == null) {
            return null;
        }
        return this.help.getProperty(string);
    }

    private void addKeyListener() {
        FunctionDialog functionDialog = this;
        if (functionDialog == null) {
            throw null;
        }
        FocusManager.setCurrentManager(functionDialog.new KeyCatcher());
    }

    private void removeKeyListener() {
        FocusManager.setCurrentManager(this.focusMgr);
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.closeButton) {
            this.handleClose();
        } else if (object == this.defaultsButton) {
            this.handleDefaults();
        } else if (object == this.addKeyButton) {
            this.handleAddKey();
        } else if (object == this.delKeyButton) {
            this.handleDelKey();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        int n = this.categoryMenu.getSelectedIndex();
        this.firstDisplayedFunc = this.categoryIndex[n];
        int n2 = this.categoryIndex[n + 1];
        String[] stringArray = new String[n2 - this.firstDisplayedFunc];
        int n3 = this.firstDisplayedFunc;
        while (n3 < n2) {
            stringArray[n3 - this.firstDisplayedFunc] = (String)this.functions[n3].getValue("Name");
            ++n3;
        }
        this.functionList.setListData(stringArray);
        this.clearKeyList();
        this.clearHelpText();
        this.addKeyButton.setEnabled(false);
        this.delKeyButton.setEnabled(false);
        this.currentAction = null;
        this.currentKeys = null;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        Object object = listSelectionEvent.getSource();
        if (object == this.functionList) {
            this.handleFuncListSelect();
        } else if (object == this.keyList) {
            this.handleKeyListSelect();
        }
    }

    private void makeDialog(String[] stringArray) {
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel jPanel2 = new JPanel(new GridLayout());
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0), BorderFactory.createLineBorder(Color.black)));
        this.helpLabel = new FixedMultiLineLabel(4);
        this.helpLabel.setBackground(MoeEditor.infoColor);
        jPanel2.add((Component)this.helpLabel);
        jPanel.add((Component)jPanel2, "South");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(0, 1, 5, 5));
        this.closeButton = new JButton(close);
        this.closeButton.addActionListener(this);
        jPanel4.add(this.closeButton);
        this.defaultsButton = new JButton(defaultsLabel);
        this.defaultsButton.addActionListener(this);
        jPanel4.add(this.defaultsButton);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel4, "North");
        jPanel3.add((Component)jPanel5, "East");
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout());
        jPanel6.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), keyLabel));
        this.keyList = new JList();
        this.keyList.setSelectionMode(0);
        this.keyList.setPrototypeCellValue("shift-ctrl-delete");
        this.keyList.addListSelectionListener(this);
        this.keyList.setVisibleRowCount(4);
        JScrollPane jScrollPane = new JScrollPane(this.keyList);
        jPanel6.add((Component)jScrollPane, "Center");
        JPanel jPanel7 = new JPanel();
        this.addKeyButton = new JButton(addKeyLabel);
        this.addKeyButton.addActionListener(this);
        this.addKeyButton.setMargin(new Insets(2, 2, 2, 2));
        jPanel7.add(this.addKeyButton);
        this.delKeyButton = new JButton(delKeyLabel);
        this.delKeyButton.addActionListener(this);
        this.delKeyButton.setMargin(new Insets(2, 2, 2, 2));
        jPanel7.add(this.delKeyButton);
        jPanel6.add((Component)jPanel7, "South");
        jPanel3.add((Component)jPanel6, "South");
        jPanel.add((Component)jPanel3, "East");
        JPanel jPanel8 = new JPanel(new BorderLayout());
        jPanel8.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        this.functionList = new JList();
        this.functionList.setSelectionMode(0);
        this.functionList.addListSelectionListener(this);
        this.functionList.setVisibleRowCount(12);
        jScrollPane = new JScrollPane(this.functionList);
        jPanel8.add((Component)jScrollPane, "Center");
        JPanel jPanel9 = new JPanel();
        JLabel jLabel = new JLabel(categoriesLabel);
        jPanel9.add(jLabel);
        this.categoryMenu = new JComboBox();
        this.categoryMenu.addItemListener(this);
        int n = 0;
        while (n < stringArray.length) {
            this.categoryMenu.addItem(stringArray[n]);
            ++n;
        }
        jPanel9.add(this.categoryMenu);
        jPanel8.add((Component)jPanel9, "North");
        jPanel.add((Component)jPanel8, "Center");
        this.getRootPane().setDefaultButton(this.closeButton);
        FunctionDialog functionDialog = this;
        if (functionDialog == null) {
            throw null;
        }
        this.addWindowListener(new WindowAdapter(functionDialog){
            private final /* synthetic */ FunctionDialog this$0;

            public void windowClosing(WindowEvent windowEvent) {
                ((Component)this.this$0).setVisible(false);
            }
            {
                this.this$0 = functionDialog;
                this.constructor$0(functionDialog);
            }

            private final void constructor$0(FunctionDialog functionDialog) {
            }
        });
        this.pack();
        DialogManager.centreDialog((JDialog)this);
    }

    public FunctionDialog(JFrame jFrame, Action[] actionArray, String[] stringArray, int[] nArray) {
        super(jFrame, title, true);
        this.functions = actionArray;
        this.categoryIndex = nArray;
        this.makeDialog(stringArray);
        this.openHelpFile();
    }

    class KeyCatcher
    extends FocusManager {
        public void processKeyEvent(Component component, KeyEvent keyEvent) {
            if (keyEvent.getID() != 401) {
                return;
            }
            int n = keyEvent.getKeyCode();
            if (n == 20 || n == 16 || n == 17 || n == 157 || n == 18 || n == 65406 || n == 65312 || n == 144 || n == 145 || n == 0) {
                return;
            }
            if (FunctionDialog.this.currentAction == null) {
                Debug.message((String)"FunctionDialog: currentAction is null...");
            } else {
                KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
                if (this.isPrintable(keyStroke, keyEvent)) {
                    FunctionDialog.this.helpLabel.setText(FunctionDialog.this.getHelpText("cannot-redefine"));
                } else {
                    FunctionDialog.this.actions.addActionForKeyStroke(keyStroke, FunctionDialog.this.currentAction);
                    FunctionDialog.this.handleFuncListSelect();
                }
            }
            keyEvent.consume();
            FunctionDialog.this.removeKeyListener();
        }

        private boolean isPrintable(KeyStroke keyStroke, KeyEvent keyEvent) {
            int n = keyStroke.getModifiers();
            if (n != 0 && n != 1) {
                return false;
            }
            if (keyEvent.isActionKey()) {
                return false;
            }
            int n2 = keyEvent.getKeyCode();
            return n2 != 8 && n2 != 127 && n2 != 10 && n2 != 9 && n2 != 27;
        }

        public void focusNextComponent(Component component) {
        }

        public void focusPreviousComponent(Component component) {
        }

        KeyCatcher() {
        }
    }
}

