/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.Config;
import bluej.editor.moe.MoeEditor;
import bluej.editor.moe.MoeEditorManager;
import bluej.utility.BlueJFileReader;
import bluej.utility.DialogManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public final class Info
extends JPanel
implements ActionListener {
    static final ImageIcon helpImage = Config.getImageAsIcon((String)"image.help");
    public static Font infoFont = new Font("SansSerif", 1, 10);
    private JLabel line1;
    private JLabel line2;
    String originalMsg;
    boolean isClear;
    JButton helpButton;
    String helpGroup;

    public void message(String string) {
        this.originalMsg = string;
        int n = string.indexOf(10);
        if (n == -1) {
            if (string.length() <= 81) {
                this.message(string, "");
            } else {
                this.message(string.substring(0, 80), string.substring(80));
            }
        } else {
            this.message(string.substring(0, n), string.substring(n + 1));
        }
    }

    public void message(String string, String string2) {
        this.line1.setText(string);
        this.line2.setText(string2.replace('\n', ' '));
        this.isClear = false;
        this.hideHelp();
    }

    public void warning(String string) {
        this.message(string);
        MoeEditorManager.editorManager.beep();
    }

    public void warning(String string, String string2) {
        this.message(string, string2);
        MoeEditorManager.editorManager.beep();
    }

    public void clear() {
        if (!this.isClear) {
            this.message(" ", " ");
            this.isClear = true;
        }
    }

    public void setHelp(String string) {
        this.helpGroup = string;
        this.helpButton.setVisible(true);
    }

    public void hideHelp() {
        this.helpButton.setVisible(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.displayHelp(this.helpGroup);
    }

    private void displayHelp(String string) {
        File file = Config.getLanguageFile((String)(string + ".help"));
        String string2 = BlueJFileReader.readHelpText((File)file, (String)this.originalMsg.trim(), (boolean)false);
        if (string2 == null) {
            DialogManager.showMessageWithText(null, (String)"no-help", (String)("\n" + this.originalMsg));
        } else {
            DialogManager.showText(null, (String)(this.originalMsg + "\n\n" + string2));
        }
    }

    public Info() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.setFont(infoFont);
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        jPanel.setBackground(MoeEditor.infoColor);
        this.line1 = new JLabel();
        this.line2 = new JLabel();
        jPanel.add(this.line1);
        jPanel.add(this.line2);
        this.add((Component)jPanel, "Center");
        this.helpButton = new JButton(helpImage);
        this.helpButton.setMargin(new Insets(0, 0, 0, 0));
        this.helpButton.addActionListener(this);
        this.helpButton.setRequestFocusEnabled(false);
        this.add((Component)this.helpButton, "East");
        this.helpButton.setVisible(false);
        this.isClear = true;
        this.helpGroup = "";
    }
}

