/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.Config;
import bluej.editor.moe.FunctionDialog;
import bluej.editor.moe.MoeEditor;
import bluej.editor.moe.MoeSyntaxDocument;
import bluej.prefmgr.PrefMgrDialog;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.TextAction;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public final class MoeActions {
    private static String KEYS_FILE = "editor.keys";
    private static int CMD_MASK;
    private static int ALT_MASK;
    private static int SHIFT_CMD_MASK;
    private static int ALT_CMD_MASK;
    private static int SHIFT_ALT_MASK;
    private static int tabSize;
    private static String spaces;
    private static MoeActions moeActions;
    private Action[] actionTable;
    private Hashtable actions;
    private String[] categories;
    private int[] categoryIndex;
    private Keymap keymap;
    private FunctionDialog functionDlg;
    private KeyCatcher keyCatcher;
    private boolean lastActionWasCut;
    public UndoAction undoAction;
    public RedoAction redoAction;
    public UndoManager undoManager;
    public Action compileAction;
    private InputMap componentInputMap;

    public static MoeActions getActions(JTextComponent jTextComponent) {
        if (moeActions == null) {
            moeActions = new MoeActions(jTextComponent);
        }
        return moeActions;
    }

    public Action getActionByName(String string) {
        return (Action)this.actions.get(string);
    }

    public KeyStroke[] getKeyStrokesForAction(Action action) {
        KeyStroke[] keyStrokeArray = this.keymap.getKeyStrokesForAction(action);
        if ((keyStrokeArray = this.addComponentKeyStrokes(action, keyStrokeArray)) != null && keyStrokeArray.length > 0) {
            return keyStrokeArray;
        }
        return null;
    }

    public KeyStroke[] addComponentKeyStrokes(Action action, KeyStroke[] keyStrokeArray) {
        KeyStroke[] keyStrokeArray2;
        ArrayList<KeyStroke> arrayList = null;
        KeyStroke[] keyStrokeArray3 = this.componentInputMap.allKeys();
        int n = 0;
        while (n < keyStrokeArray3.length) {
            if (this.componentInputMap.get(keyStrokeArray3[n]).equals(action.getValue("Name"))) {
                if (arrayList == null) {
                    arrayList = new ArrayList<KeyStroke>();
                }
                arrayList.add(keyStrokeArray3[n]);
            }
            ++n;
        }
        if (arrayList != null) {
            Iterator iterator = ((AbstractList)arrayList).iterator();
            while (iterator.hasNext()) {
                if (this.keymap.getAction((KeyStroke)iterator.next()) == null) continue;
                iterator.remove();
            }
        }
        if (arrayList == null || arrayList.size() == 0) {
            return keyStrokeArray;
        }
        if (keyStrokeArray == null) {
            keyStrokeArray2 = new KeyStroke[arrayList.size()];
            arrayList.toArray(keyStrokeArray2);
        } else {
            keyStrokeArray2 = new KeyStroke[arrayList.size() + keyStrokeArray.length];
            arrayList.toArray(keyStrokeArray2);
            System.arraycopy(keyStrokeArray2, 0, keyStrokeArray2, keyStrokeArray.length, arrayList.size());
            System.arraycopy(keyStrokeArray, 0, keyStrokeArray2, 0, keyStrokeArray.length);
        }
        return keyStrokeArray2;
    }

    public void addActionForKeyStroke(KeyStroke keyStroke, Action action) {
        this.keymap.addActionForKeyStroke(keyStroke, action);
    }

    public void removeKeyStrokeBinding(KeyStroke keyStroke) {
        this.keymap.removeKeyStrokeBinding(keyStroke);
    }

    public boolean save() {
        try {
            File file = Config.getUserConfigFile((String)KEYS_FILE);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            KeyStroke[] keyStrokeArray = this.keymap.getBoundKeyStrokes();
            objectOutputStream.writeInt(keyStrokeArray.length);
            int n = 0;
            while (n < keyStrokeArray.length) {
                objectOutputStream.writeObject(keyStrokeArray[n]);
                objectOutputStream.writeObject(this.keymap.getAction(keyStrokeArray[n]).getValue("Name"));
                ++n;
            }
            objectOutputStream.flush();
            fileOutputStream.close();
            return true;
        }
        catch (Exception exception) {
            Debug.message((String)("Cannot save key bindings: " + exception));
            return false;
        }
    }

    public boolean load() {
        try {
            File file = Config.getUserConfigFile((String)KEYS_FILE);
            FileInputStream fileInputStream = new FileInputStream(file);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            KeyStroke[] keyStrokeArray = this.keymap.getBoundKeyStrokes();
            int n = objectInputStream.readInt();
            int n2 = 0;
            while (n2 < n) {
                KeyStroke keyStroke = (KeyStroke)objectInputStream.readObject();
                String string = (String)objectInputStream.readObject();
                Action action = (Action)this.actions.get(string);
                if (action != null) {
                    this.keymap.addActionForKeyStroke(keyStroke, action);
                }
                ++n2;
            }
            fileInputStream.close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void userAction() {
        this.lastActionWasCut = false;
    }

    private void printMap() {
    }

    private int convertTabsToSpaces(Document document) {
        int n = 0;
        int n2 = 0;
        Element element = document.getDefaultRootElement();
        Element element2 = element.getElement(n2);
        try {
            while (element2 != null) {
                int n3 = element2.getStartOffset();
                int n4 = element2.getEndOffset() - n3;
                String string = document.getText(n3, n4);
                int n5 = n;
                int n6 = string.indexOf(9);
                while (n6 != -1) {
                    string = this.expandTab(string, n6);
                    ++n;
                    n6 = string.indexOf(9);
                }
                if (n != n5) {
                    document.remove(n3, n4);
                    document.insertString(n3, string, null);
                }
                element2 = element.getElement(++n2);
            }
        }
        catch (BadLocationException badLocationException) {
            Debug.reportError((String)"stuffed up in 'convertTabsToSpaces'");
        }
        return n;
    }

    private String expandTab(String string, int n) {
        int n2 = tabSize - n % tabSize;
        return string.substring(0, n) + spaces.substring(0, n2) + string.substring(n + 1);
    }

    public void addSelectionToClipboard(JTextComponent jTextComponent) {
        Clipboard clipboard = jTextComponent.getToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(this);
        String string = "";
        if (transferable != null) {
            try {
                string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        StringSelection stringSelection = new StringSelection(string + jTextComponent.getSelectedText());
        clipboard.setContents(stringSelection, stringSelection);
    }

    private Element getCurrentLine(JTextComponent jTextComponent) {
        MoeSyntaxDocument moeSyntaxDocument = (MoeSyntaxDocument)jTextComponent.getDocument();
        return moeSyntaxDocument.getParagraphElement(jTextComponent.getCaretPosition());
    }

    private Element getLine(JTextComponent jTextComponent, int n) {
        return jTextComponent.getDocument().getDefaultRootElement().getElement(n);
    }

    private Element getLineAt(JTextComponent jTextComponent, int n) {
        MoeSyntaxDocument moeSyntaxDocument = (MoeSyntaxDocument)jTextComponent.getDocument();
        return moeSyntaxDocument.getParagraphElement(n);
    }

    private int getCurrentLineIndex(JTextComponent jTextComponent) {
        MoeSyntaxDocument moeSyntaxDocument = (MoeSyntaxDocument)jTextComponent.getDocument();
        return moeSyntaxDocument.getDefaultRootElement().getElementIndex(jTextComponent.getCaretPosition());
    }

    private void doIndent(JTextComponent jTextComponent) {
        int n = this.getCurrentLineIndex(jTextComponent);
        if (n == 0) {
            return;
        }
        try {
            MoeSyntaxDocument moeSyntaxDocument = (MoeSyntaxDocument)jTextComponent.getDocument();
            Element element = this.getLine(jTextComponent, n - 1);
            int n2 = element.getStartOffset();
            int n3 = element.getEndOffset();
            String string = moeSyntaxDocument.getText(n2, n3 - n2);
            int n4 = this.findFirstNonWhiteChar(string);
            String string2 = string.substring(0, n4);
            element = this.getLine(jTextComponent, n);
            n2 = element.getStartOffset();
            n3 = element.getEndOffset();
            string = moeSyntaxDocument.getText(n2, n3 - n2);
            n4 = this.findFirstNonWhiteChar(string);
            moeSyntaxDocument.remove(n2, n4);
            ((AbstractDocument)moeSyntaxDocument).insertString(n2, string2, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int findFirstNonWhiteChar(String string) {
        int n = 0;
        char c = string.charAt(0);
        while (c == ' ' || c == '\t') {
            c = string.charAt(++n);
        }
        return n;
    }

    private void createActionTable(JTextComponent jTextComponent) {
        Action action;
        MoeActions moeActions = this;
        if (moeActions == null) {
            throw null;
        }
        this.undoAction = moeActions.new UndoAction();
        MoeActions moeActions2 = this;
        if (moeActions2 == null) {
            throw null;
        }
        this.redoAction = moeActions2.new RedoAction();
        MoeActions moeActions3 = this;
        if (moeActions3 == null) {
            throw null;
        }
        this.compileAction = moeActions3.new CompileAction();
        Action[] actionArray = jTextComponent.getActions();
        Action[] actionArray2 = new Action[32];
        MoeActions moeActions4 = this;
        if (moeActions4 == null) {
            throw null;
        }
        actionArray2[0] = moeActions4.new SaveAction();
        MoeActions moeActions5 = this;
        if (moeActions5 == null) {
            throw null;
        }
        actionArray2[1] = moeActions5.new ReloadAction();
        MoeActions moeActions6 = this;
        if (moeActions6 == null) {
            throw null;
        }
        actionArray2[2] = moeActions6.new PageSetupAction();
        MoeActions moeActions7 = this;
        if (moeActions7 == null) {
            throw null;
        }
        actionArray2[3] = moeActions7.new PrintAction();
        MoeActions moeActions8 = this;
        if (moeActions8 == null) {
            throw null;
        }
        actionArray2[4] = moeActions8.new CloseAction();
        actionArray2[5] = this.undoAction;
        actionArray2[6] = this.redoAction;
        MoeActions moeActions9 = this;
        if (moeActions9 == null) {
            throw null;
        }
        actionArray2[7] = moeActions9.new InsertSpacedTabAction();
        MoeActions moeActions10 = this;
        if (moeActions10 == null) {
            throw null;
        }
        actionArray2[8] = moeActions10.new CommentAction();
        MoeActions moeActions11 = this;
        if (moeActions11 == null) {
            throw null;
        }
        actionArray2[9] = moeActions11.new UncommentAction();
        MoeActions moeActions12 = this;
        if (moeActions12 == null) {
            throw null;
        }
        actionArray2[10] = moeActions12.new InsertMethodAction();
        MoeActions moeActions13 = this;
        if (moeActions13 == null) {
            throw null;
        }
        actionArray2[11] = moeActions13.new IndentAction();
        MoeActions moeActions14 = this;
        if (moeActions14 == null) {
            throw null;
        }
        actionArray2[12] = moeActions14.new BreakAndIndentAction();
        MoeActions moeActions15 = this;
        if (moeActions15 == null) {
            throw null;
        }
        actionArray2[13] = moeActions15.new CopyLineAction();
        MoeActions moeActions16 = this;
        if (moeActions16 == null) {
            throw null;
        }
        actionArray2[14] = moeActions16.new CutLineAction();
        MoeActions moeActions17 = this;
        if (moeActions17 == null) {
            throw null;
        }
        actionArray2[15] = moeActions17.new CutEndOfLineAction();
        MoeActions moeActions18 = this;
        if (moeActions18 == null) {
            throw null;
        }
        actionArray2[16] = moeActions18.new CutWordAction();
        MoeActions moeActions19 = this;
        if (moeActions19 == null) {
            throw null;
        }
        actionArray2[17] = moeActions19.new CutEndOfWordAction();
        MoeActions moeActions20 = this;
        if (moeActions20 == null) {
            throw null;
        }
        actionArray2[18] = moeActions20.new FindAction();
        MoeActions moeActions21 = this;
        if (moeActions21 == null) {
            throw null;
        }
        actionArray2[19] = moeActions21.new FindBackwardAction();
        MoeActions moeActions22 = this;
        if (moeActions22 == null) {
            throw null;
        }
        actionArray2[20] = moeActions22.new FindNextAction();
        MoeActions moeActions23 = this;
        if (moeActions23 == null) {
            throw null;
        }
        actionArray2[21] = moeActions23.new FindNextReverseAction();
        MoeActions moeActions24 = this;
        if (moeActions24 == null) {
            throw null;
        }
        actionArray2[22] = moeActions24.new ReplaceAction();
        actionArray2[23] = this.compileAction;
        MoeActions moeActions25 = this;
        if (moeActions25 == null) {
            throw null;
        }
        actionArray2[24] = moeActions25.new ToggleInterfaceAction();
        MoeActions moeActions26 = this;
        if (moeActions26 == null) {
            throw null;
        }
        actionArray2[25] = moeActions26.new ToggleBreakPointAction();
        MoeActions moeActions27 = this;
        if (moeActions27 == null) {
            throw null;
        }
        actionArray2[26] = moeActions27.new KeyBindingsAction();
        MoeActions moeActions28 = this;
        if (moeActions28 == null) {
            throw null;
        }
        actionArray2[27] = moeActions28.new PreferencesAction();
        MoeActions moeActions29 = this;
        if (moeActions29 == null) {
            throw null;
        }
        actionArray2[28] = moeActions29.new AboutAction();
        MoeActions moeActions30 = this;
        if (moeActions30 == null) {
            throw null;
        }
        actionArray2[29] = moeActions30.new DescribeKeyAction();
        MoeActions moeActions31 = this;
        if (moeActions31 == null) {
            throw null;
        }
        actionArray2[30] = moeActions31.new HelpMouseAction();
        MoeActions moeActions32 = this;
        if (moeActions32 == null) {
            throw null;
        }
        actionArray2[31] = moeActions32.new ShowManualAction();
        Action[] actionArray3 = actionArray2;
        this.actions = new Hashtable();
        int n = 0;
        while (n < actionArray.length) {
            action = actionArray[n];
            this.actions.put(action.getValue("Name"), action);
            ++n;
        }
        n = 0;
        while (n < actionArray3.length) {
            action = actionArray3[n];
            this.actions.put(action.getValue("Name"), action);
            ++n;
        }
        this.actionTable = new Action[]{(Action)this.actions.get("delete-previous"), (Action)this.actions.get("delete-next"), (Action)this.actions.get("copy-to-clipboard"), (Action)this.actions.get("cut-to-clipboard"), (Action)this.actions.get("copy-line"), (Action)this.actions.get("cut-line"), (Action)this.actions.get("cut-end-of-line"), (Action)this.actions.get("cut-word"), (Action)this.actions.get("cut-end-of-word"), (Action)this.actions.get("paste-from-clipboard"), (Action)this.actions.get("insert-tab"), (Action)this.actions.get("insert-spaced-tab"), (Action)this.actions.get("insert-break"), (Action)this.actions.get("insert-break-and-indent"), (Action)this.actions.get("indent"), (Action)this.actions.get("insert-method"), (Action)this.actions.get("comment"), (Action)this.actions.get("uncomment"), (Action)this.actions.get("select-word"), (Action)this.actions.get("select-line"), (Action)this.actions.get("select-paragraph"), (Action)this.actions.get("select-all"), (Action)this.actions.get("selection-backward"), (Action)this.actions.get("selection-forward"), (Action)this.actions.get("selection-up"), (Action)this.actions.get("selection-down"), (Action)this.actions.get("selection-begin-word"), (Action)this.actions.get("selection-end-word"), (Action)this.actions.get("selection-previous-word"), (Action)this.actions.get("selection-next-word"), (Action)this.actions.get("selection-begin-line"), (Action)this.actions.get("selection-end-line"), (Action)this.actions.get("selection-begin-paragraph"), (Action)this.actions.get("selection-end-paragraph"), (Action)this.actions.get("selection-page-up"), (Action)this.actions.get("selection-page-down"), (Action)this.actions.get("selection-begin"), (Action)this.actions.get("selection-end"), (Action)this.actions.get("unselect"), (Action)this.actions.get("caret-backward"), (Action)this.actions.get("caret-forward"), (Action)this.actions.get("caret-up"), (Action)this.actions.get("caret-down"), (Action)this.actions.get("caret-begin-word"), (Action)this.actions.get("caret-end-word"), (Action)this.actions.get("caret-previous-word"), (Action)this.actions.get("caret-next-word"), (Action)this.actions.get("caret-begin-line"), (Action)this.actions.get("caret-end-line"), (Action)this.actions.get("caret-begin-paragraph"), (Action)this.actions.get("caret-end-paragraph"), (Action)this.actions.get("page-up"), (Action)this.actions.get("page-down"), (Action)this.actions.get("caret-begin"), (Action)this.actions.get("caret-end"), (Action)this.actions.get("save"), (Action)this.actions.get("reload"), (Action)this.actions.get("close"), (Action)this.actions.get("print"), (Action)this.actions.get("page-setup"), (Action)this.actions.get("key-bindings"), (Action)this.actions.get("preferences"), (Action)this.actions.get("describe-key"), (Action)this.actions.get("help-mouse"), (Action)this.actions.get("show-manual"), (Action)this.actions.get("about-editor"), this.undoAction, this.redoAction, (Action)this.actions.get("find"), (Action)this.actions.get("find-backward"), (Action)this.actions.get("find-next"), (Action)this.actions.get("find-next-reverse"), (Action)this.actions.get("replace"), (Action)this.actions.get("compile"), (Action)this.actions.get("toggle-interface-view"), (Action)this.actions.get("toggle-breakpoint")};
        this.categories = new String[]{Config.getString((String)"editor.functions.editFunctions"), Config.getString((String)"editor.functions.moveScroll"), Config.getString((String)"editor.functions.classFunctions"), Config.getString((String)"editor.functions.customisation"), Config.getString((String)"editor.functions.help"), Config.getString((String)"editor.functions.misc")};
        this.categoryIndex = new int[]{0, 39, 55, 60, 62, 66, 76};
    }

    public void setDefaultKeyBindings() {
        this.keymap.removeBindings();
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(83, CMD_MASK), (Action)this.actions.get("save"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(80, CMD_MASK), (Action)this.actions.get("print"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(87, CMD_MASK), (Action)this.actions.get("close"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(90, CMD_MASK), (Action)this.actions.get("undo"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(89, CMD_MASK), (Action)this.actions.get("redo"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(9, 0), (Action)this.actions.get("insert-spaced-tab"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(73, CMD_MASK), (Action)this.actions.get("comment"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(79, CMD_MASK), (Action)this.actions.get("uncomment"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(77, CMD_MASK), (Action)this.actions.get("insert-method"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(9, 1), (Action)this.actions.get("indent"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(10, 1), (Action)this.actions.get("insert-break-and-indent"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(70, CMD_MASK), (Action)this.actions.get("find"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(70, SHIFT_CMD_MASK), (Action)this.actions.get("find-backward"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(71, CMD_MASK), (Action)this.actions.get("find-next"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(71, SHIFT_CMD_MASK), (Action)this.actions.get("find-next-reverse"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(82, CMD_MASK), (Action)this.actions.get("replace"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(75, CMD_MASK), (Action)this.actions.get("compile"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(74, CMD_MASK), (Action)this.actions.get("toggle-interface-view"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(66, CMD_MASK), (Action)this.actions.get("toggle-breakpoint"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(68, CMD_MASK), (Action)this.actions.get("describe-key"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(67, CMD_MASK), (Action)this.actions.get("copy-to-clipboard"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(88, CMD_MASK), (Action)this.actions.get("cut-to-clipboard"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(86, CMD_MASK), (Action)this.actions.get("paste-from-clipboard"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(113, 0), (Action)this.actions.get("copy-line"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(114, 0), (Action)this.actions.get("paste-from-clipboard"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(115, 0), (Action)this.actions.get("cut-line"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(38, ALT_MASK), (Action)this.actions.get("paste-from-clipboard"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(37, ALT_MASK), (Action)this.actions.get("delete-previous"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(39, ALT_MASK), (Action)this.actions.get("delete-next"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(37, SHIFT_ALT_MASK), (Action)this.actions.get("cut-line"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(39, SHIFT_ALT_MASK), (Action)this.actions.get("cut-end-of-line"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(37, ALT_CMD_MASK), (Action)this.actions.get("cut-word"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(39, ALT_CMD_MASK), (Action)this.actions.get("cut-end-of-word"));
    }

    private MoeActions(JTextComponent jTextComponent) {
        CMD_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        ALT_MASK = CMD_MASK == 2 ? 4 : 2;
        SHIFT_CMD_MASK = CMD_MASK + 1;
        ALT_CMD_MASK = CMD_MASK + ALT_MASK;
        SHIFT_ALT_MASK = 1 + ALT_MASK;
        this.undoManager = new UndoManager();
        if (System.getProperty("java.version").startsWith("1.2")) {
            this.keymap = JTextComponent.addKeymap("BlueJ map", jTextComponent.getKeymap());
            jTextComponent.setKeymap(this.keymap);
        } else {
            this.keymap = jTextComponent.getKeymap();
        }
        this.createActionTable(jTextComponent);
        MoeActions moeActions = this;
        if (moeActions == null) {
            throw null;
        }
        this.keyCatcher = moeActions.new KeyCatcher();
        if (!this.load()) {
            this.setDefaultKeyBindings();
        }
        this.lastActionWasCut = false;
        this.componentInputMap = jTextComponent.getInputMap();
    }

    static {
        tabSize = Config.getPropInteger((String)"bluej.editor.tabsize", (int)4);
        spaces = "                        ";
    }

    abstract class MoeAbstractAction
    extends TextAction {
        protected final MoeEditor getEditor(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            MoeEditor moeEditor = (MoeEditor)jTextComponent.getTopLevelAncestor();
            moeEditor.clearMessage();
            return moeEditor;
        }

        public MoeAbstractAction(String string) {
            super(string);
        }
    }

    class SaveAction
    extends MoeAbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            this.getEditor(actionEvent).userSave();
        }

        public SaveAction() {
            super("save");
        }
    }

    class ReloadAction
    extends MoeAbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            this.getEditor(actionEvent).reload();
        }

        public ReloadAction() {
            super("reload");
        }
    }

    class PrintAction
    extends MoeAbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            this.getEditor(actionEvent).print();
        }

        public PrintAction() {
            super("print");
        }
    }

    class PageSetupAction
    extends MoeAbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            this.getEditor(actionEvent).pageSetup();
        }

        public PageSetupAction() {
            super("page-setup");
        }
    }

    class CloseAction
    extends MoeAbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            this.getEditor(actionEvent).close();
        }

        public CloseAction() {
            super("close");
        }
    }

    class UndoAction
    extends MoeAbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                MoeActions.this.undoManager.undo();
            }
            catch (CannotUndoException cannotUndoException) {
                Debug.message((String)"moe: cannot undo...");
            }
            this.update();
            MoeActions.this.redoAction.update();
        }

        public void update() {
            if (MoeActions.this.undoManager.canUndo()) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public UndoAction() {
            super("undo");
            this.setEnabled(false);
        }
    }

    class RedoAction
    extends MoeAbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                MoeActions.this.undoManager.redo();
            }
            catch (CannotRedoException cannotRedoException) {
                Debug.message((String)"moe: cannot redo...");
            }
            this.update();
            MoeActions.this.undoAction.update();
        }

        public void update() {
            if (MoeActions.this.undoManager.canRedo()) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public RedoAction() {
            super("redo");
            this.setEnabled(false);
        }
    }

    class InsertSpacedTabAction
    extends MoeAbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            Caret caret = jTextComponent.getCaret();
            int n = Math.min(caret.getMark(), caret.getDot());
            AbstractDocument abstractDocument = (AbstractDocument)jTextComponent.getDocument();
            MoeEditor moeEditor = this.getEditor(actionEvent);
            int n2 = 0;
            if (moeEditor.checkExpandTabs()) {
                n2 = MoeActions.this.convertTabsToSpaces(abstractDocument);
            }
            int n3 = abstractDocument.getParagraphElement(n).getStartOffset();
            int n4 = n - n3;
            int n5 = tabSize - n4 % tabSize;
            jTextComponent.replaceSelection(spaces.substring(0, n5));
            if (n2 > 0) {
                moeEditor.writeMessage(Config.getString((String)"editor.info.tabsExpanded"));
            }
        }

        public InsertSpacedTabAction() {
            super("insert-spaced-tab");
        }
    }

    class CommentAction
    extends MoeAbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            this.getEditor(actionEvent);
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            Caret caret = jTextComponent.getCaret();
            int n = caret.getMark();
            int n2 = caret.getDot();
            if (n > n2) {
                int n3 = n;
                n = n2;
                n2 = n3;
            }
            if (n != n2) {
                --n2;
            }
            MoeSyntaxDocument moeSyntaxDocument = (MoeSyntaxDocument)jTextComponent.getDocument();
            Element element = moeSyntaxDocument.getDefaultRootElement();
            int n4 = element.getElementIndex(n);
            int n5 = element.getElementIndex(n2);
            int n6 = n4;
            while (n6 <= n5) {
                Element element2 = element.getElement(n6);
                int n7 = element2.getStartOffset();
                try {
                    ((AbstractDocument)moeSyntaxDocument).insertString(n7, "// ", null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n6;
            }
            jTextComponent.setCaretPosition(element.getElement(n4).getStartOffset());
            jTextComponent.moveCaretPosition(element.getElement(n5).getEndOffset());
        }

        public CommentAction() {
            super("comment");
        }
    }

    class UncommentAction
    extends MoeAbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            this.getEditor(actionEvent);
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            Caret caret = jTextComponent.getCaret();
            int n = caret.getMark();
            int n2 = caret.getDot() - 1;
            if (n > n2) {
                int n3 = n;
                n = n2;
                n2 = n3;
            }
            MoeSyntaxDocument moeSyntaxDocument = (MoeSyntaxDocument)jTextComponent.getDocument();
            Element element = moeSyntaxDocument.getDefaultRootElement();
            int n4 = element.getElementIndex(n);
            int n5 = element.getElementIndex(n2);
            int n6 = n4;
            while (n6 <= n5) {
                Element element2 = element.getElement(n6);
                int n7 = element2.getStartOffset();
                int n8 = element2.getEndOffset();
                try {
                    String string = moeSyntaxDocument.getText(n7, n8 - n7);
                    if (string.trim().startsWith("//")) {
                        int n9 = 0;
                        while (string.charAt(n9) != '/') {
                            ++n9;
                        }
                        if (string.charAt(n9 + 2) == ' ') {
                            moeSyntaxDocument.remove(n7, n9 + 3);
                        } else {
                            moeSyntaxDocument.remove(n7, n9 + 2);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n6;
            }
            jTextComponent.setCaretPosition(element.getElement(n4).getStartOffset());
            jTextComponent.moveCaretPosition(element.getElement(n5).getEndOffset());
        }

        public UncommentAction() {
            super("uncomment");
        }
    }

    class InsertMethodAction
    extends MoeAbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            this.getEditor(actionEvent);
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            int n = jTextComponent.getCaretPosition();
            jTextComponent.replaceSelection("    /**\n     * An example of a method - replace this comment with your own\n     * \n     * @param  y   a sample parameter for a method \n     * @return     the sum of x and y \n     **/\n    public int sampleMethod(int y)\n    {\n        // put your code here\n        return y;\n    }");
            jTextComponent.setCaretPosition(n);
        }

        public InsertMethodAction() {
            super("insert-method");
        }
    }

    class IndentAction
    extends MoeAbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            MoeActions.this.doIndent(jTextComponent);
        }

        public IndentAction() {
            super("indent");
        }
    }

    class BreakAndIndentAction
    extends MoeAbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            Action action = (Action)MoeActions.this.actions.get("insert-break");
            action.actionPerformed(actionEvent);
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            MoeActions.this.doIndent(jTextComponent);
        }

        public BreakAndIndentAction() {
            super("insert-break-and-indent");
        }
    }

    class CopyLineAction
    extends MoeAbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = MoeActions.this.lastActionWasCut;
            MoeActions.this.getActionByName("caret-begin-line").actionPerformed(actionEvent);
            MoeActions.this.getActionByName("selection-down").actionPerformed(actionEvent);
            if (bl) {
                MoeActions.this.addSelectionToClipboard(this.getTextComponent(actionEvent));
            } else {
                MoeActions.this.getActionByName("copy-to-clipboard").actionPerformed(actionEvent);
            }
            MoeActions.this.lastActionWasCut = true;
        }

        public CopyLineAction() {
            super("copy-line");
        }
    }

    class CutLineAction
    extends MoeAbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = MoeActions.this.lastActionWasCut;
            MoeActions.this.getActionByName("caret-begin-line").actionPerformed(actionEvent);
            MoeActions.this.getActionByName("selection-down").actionPerformed(actionEvent);
            if (bl) {
                MoeActions.this.addSelectionToClipboard(this.getTextComponent(actionEvent));
                MoeActions.this.getActionByName("delete-previous").actionPerformed(actionEvent);
            } else {
                MoeActions.this.getActionByName("cut-to-clipboard").actionPerformed(actionEvent);
            }
            MoeActions.this.lastActionWasCut = true;
        }

        public CutLineAction() {
            super("cut-line");
        }
    }

    class CutEndOfLineAction
    extends MoeAbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = MoeActions.this.lastActionWasCut;
            MoeActions.this.getActionByName("selection-end-line").actionPerformed(actionEvent);
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            String string = jTextComponent.getSelectedText();
            if (string == null) {
                MoeActions.this.getActionByName("selection-forward").actionPerformed(actionEvent);
            }
            if (bl) {
                MoeActions.this.addSelectionToClipboard(jTextComponent);
                MoeActions.this.getActionByName("delete-previous").actionPerformed(actionEvent);
            } else {
                MoeActions.this.getActionByName("cut-to-clipboard").actionPerformed(actionEvent);
            }
            MoeActions.this.lastActionWasCut = true;
        }

        public CutEndOfLineAction() {
            super("cut-end-of-line");
        }
    }

    class CutWordAction
    extends MoeAbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = MoeActions.this.lastActionWasCut;
            MoeActions.this.getActionByName("caret-previous-word").actionPerformed(actionEvent);
            MoeActions.this.getActionByName("selection-next-word").actionPerformed(actionEvent);
            if (bl) {
                MoeActions.this.addSelectionToClipboard(this.getTextComponent(actionEvent));
                MoeActions.this.getActionByName("delete-previous").actionPerformed(actionEvent);
            } else {
                MoeActions.this.getActionByName("cut-to-clipboard").actionPerformed(actionEvent);
            }
            MoeActions.this.lastActionWasCut = true;
        }

        public CutWordAction() {
            super("cut-word");
        }
    }

    class CutEndOfWordAction
    extends MoeAbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = MoeActions.this.lastActionWasCut;
            MoeActions.this.getActionByName("selection-next-word").actionPerformed(actionEvent);
            if (bl) {
                MoeActions.this.addSelectionToClipboard(this.getTextComponent(actionEvent));
                MoeActions.this.getActionByName("delete-previous").actionPerformed(actionEvent);
            } else {
                MoeActions.this.getActionByName("cut-to-clipboard").actionPerformed(actionEvent);
            }
            MoeActions.this.lastActionWasCut = true;
        }

        public CutEndOfWordAction() {
            super("cut-end-of-word");
        }
    }

    class FindAction
    extends MoeAbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            this.getEditor(actionEvent).find();
        }

        public FindAction() {
            super("find");
        }
    }

    class FindBackwardAction
    extends MoeAbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            this.getEditor(actionEvent).findBackward();
        }

        public FindBackwardAction() {
            super("find-backward");
        }
    }

    class FindNextAction
    extends MoeAbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            this.getEditor(actionEvent).findNext();
        }

        public FindNextAction() {
            super("find-next");
        }
    }

    class FindNextReverseAction
    extends MoeAbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            this.getEditor(actionEvent).findNextReverse();
        }

        public FindNextReverseAction() {
            super("find-next-reverse");
        }
    }

    class ReplaceAction
    extends MoeAbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            DialogManager.NYI((Component)this.getEditor(actionEvent));
        }

        public ReplaceAction() {
            super("replace");
        }
    }

    class CompileAction
    extends MoeAbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            this.getEditor(actionEvent).compile();
        }

        public CompileAction() {
            super("compile");
        }
    }

    class ToggleInterfaceAction
    extends MoeAbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof JComboBox) {
                this.getEditor(actionEvent).toggleInterface();
            } else {
                this.getEditor(actionEvent).toggleInterfaceMenu();
            }
        }

        public ToggleInterfaceAction() {
            super("toggle-interface-view");
        }
    }

    class ToggleBreakPointAction
    extends MoeAbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            this.getEditor(actionEvent).toggleBreakpoint();
        }

        public ToggleBreakPointAction() {
            super("toggle-breakpoint");
        }
    }

    class KeyBindingsAction
    extends MoeAbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            FunctionDialog functionDialog = new FunctionDialog(this.getEditor(actionEvent), MoeActions.this.actionTable, MoeActions.this.categories, MoeActions.this.categoryIndex);
            ((Component)functionDialog).setVisible(true);
        }

        public KeyBindingsAction() {
            super("key-bindings");
        }
    }

    class PreferencesAction
    extends MoeAbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            PrefMgrDialog.showDialog((Component)this.getEditor(actionEvent));
        }

        public PreferencesAction() {
            super("preferences");
        }
    }

    class AboutAction
    extends MoeAbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JOptionPane.showMessageDialog(this.getEditor(actionEvent), new String[]{"Moe", "Version 1.1", " ", "Moe is the editor of the BlueJ programming environment.", "Written by Michael K\u00f6lling (mik@monash.edu.au)."}, "About Moe", 1);
        }

        public AboutAction() {
            super("about-editor");
        }
    }

    class DescribeKeyAction
    extends MoeAbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            jTextComponent.addKeyListener(MoeActions.this.keyCatcher);
            MoeEditor moeEditor = this.getEditor(actionEvent);
            MoeActions.this.keyCatcher.setEditor(moeEditor);
            moeEditor.writeMessage("Describe key: ");
        }

        public DescribeKeyAction() {
            super("describe-key");
        }
    }

    class HelpMouseAction
    extends MoeAbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JOptionPane.showMessageDialog(this.getEditor(actionEvent), new String[]{"Moe Mouse Buttons:", " ", "left button:", "   click: place cursor", "   double-click: select word", "   triple-click: select line", "   drag: make selection", " ", "right button:", "   (currently unused)"}, "Moe Mouse Buttons", 1);
        }

        public HelpMouseAction() {
            super("help-mouse");
        }
    }

    class ShowManualAction
    extends MoeAbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            DialogManager.NYI((Component)this.getEditor(actionEvent));
        }

        public ShowManualAction() {
            super("show-manual");
        }
    }

    class KeyCatcher
    extends KeyAdapter {
        MoeEditor editor;

        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (n == 20 || n == 16 || n == 17 || n == 157 || n == 18 || n == 65406 || n == 65312 || n == 144 || n == 145 || n == 0) {
                return;
            }
            KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
            String string = KeyEvent.getKeyModifiersText(keyStroke.getModifiers());
            String string2 = KeyEvent.getKeyText(n);
            if (string.length() > 0) {
                string2 = string + "+" + string2;
            }
            Keymap keymap = MoeActions.this.keymap;
            Action action = null;
            while (keymap != null && action == null) {
                action = keymap.getAction(keyStroke);
                keymap = keymap.getResolveParent();
            }
            if (action == null) {
                Object object = MoeActions.this.componentInputMap.get(keyStroke);
                if (object == null) {
                    this.editor.writeMessage(string2 + " is not bound to a function.");
                } else {
                    this.editor.writeMessage(string2 + " calls the function \"" + object + "\"");
                }
            } else {
                String string3 = (String)action.getValue("Name");
                this.editor.writeMessage(string2 + " calls the function \"" + string3 + "\"");
            }
            keyEvent.getComponent().removeKeyListener(MoeActions.this.keyCatcher);
            keyEvent.consume();
        }

        public void setEditor(MoeEditor moeEditor) {
            this.editor = moeEditor;
        }

        KeyCatcher() {
        }
    }
}

