/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.BlueJEvent;
import bluej.BlueJEventListener;
import bluej.Config;
import bluej.editor.Editor;
import bluej.editor.EditorWatcher;
import bluej.editor.moe.Finder;
import bluej.editor.moe.Info;
import bluej.editor.moe.LineNumberLabel;
import bluej.editor.moe.MoeActions;
import bluej.editor.moe.MoeCaret;
import bluej.editor.moe.MoeEditorManager;
import bluej.editor.moe.MoeEditorPane;
import bluej.editor.moe.MoePrinter;
import bluej.editor.moe.MoeSyntaxDocument;
import bluej.editor.moe.MoeSyntaxEditorKit;
import bluej.editor.moe.StatusLabel;
import bluej.pkgmgr.DocuGenerator;
import bluej.prefmgr.PrefMgr;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import org.gjt.sp.jedit.syntax.JavaTokenMarker;

public final class MoeEditor
extends JFrame
implements Editor,
BlueJEventListener,
HyperlinkListener,
DocumentListener {
    static final int version = 110;
    static final String versionString = "1.1";
    static final Color textColor = new Color(0, 0, 0);
    static final Color textBgColor = new Color(255, 255, 255);
    static final Color selectionColor = Color.pink;
    static final Color cursorColor = new Color(255, 0, 100);
    static final Color frameBgColor = new Color(196, 196, 196);
    static final Color infoColor = new Color(240, 240, 240);
    static final Color lightGrey = new Color(224, 224, 224);
    static final Color selectionColour = new Color(204, 204, 204);
    static final Color titleCol = Config.getItemColour((String)"colour.text.fg");
    static final Color envOpColour = Config.getItemColour((String)"colour.menu.environOp");
    static final Image iconImage = Config.getImageAsIcon((String)"image.icon.editor").getImage();
    public static Font printFont = new Font("Monospaced", 0, 10);
    static final String LabelSuffix = "Label";
    static final String ActionSuffix = "Action";
    static final String TooltipSuffix = "Tooltip";
    static final String AcceleratorSuffix = "Accelerator";
    static final short TAG_WIDTH = 14;
    static final String spaces = "    ";
    public static final String BREAKPOINT = "break";
    public static final String STEPMARK = "step";
    static final String COMPILED = "compiled";
    private static PageFormat pageFormat = new PageFormat();
    String implementationString = Config.getString((String)"editor.implementationLabel");
    String interfaceString = Config.getString((String)"editor.interfaceLabel");
    private EditorWatcher watcher;
    private Properties resources;
    private AbstractDocument document;
    private MoeSyntaxDocument sourceDocument;
    private HTMLDocument htmlDocument;
    private MoeActions actions;
    private JEditorPane currentTextPane;
    private JEditorPane sourcePane;
    private JEditorPane htmlPane;
    private Info info;
    private JPanel statusArea;
    private LineNumberLabel lineCounter;
    private StatusLabel saveState;
    private JComboBox interfaceToggle;
    private JScrollPane scrollPane;
    private JComponent toolbar;
    private String filename;
    private String windowTitle;
    private boolean firstSave;
    private boolean isCompiled;
    private String docpath;
    private String newline;
    private boolean sourceIsCode;
    private boolean viewingHTML;
    private int currentStepPos;
    private boolean mayHaveBreakpoints;
    private boolean ignoreChanges = false;
    private boolean tabsAreExpanded = false;
    private MoePrinter printer;

    public boolean showFile(String string, boolean bl, Vector vector) {
        this.filename = string;
        boolean bl2 = false;
        boolean bl3 = false;
        if (vector != null) {
            Debug.reportError((String)"breakpoints in showfile not supported.");
        }
        if (string != null) {
            try {
                FileReader fileReader = new FileReader(string);
                this.sourcePane.read(fileReader, null);
                fileReader.close();
                this.sourceDocument = (MoeSyntaxDocument)this.sourcePane.getDocument();
                this.checkSyntaxStatus();
                this.sourceDocument.addDocumentListener(this);
                MoeEditor moeEditor = this;
                if (moeEditor == null) {
                    throw null;
                }
                this.sourceDocument.addUndoableEditListener(moeEditor.new MoeUndoableEditListener());
                this.document = this.sourceDocument;
                bl2 = true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.clear();
            }
            catch (IOException iOException) {
                bl3 = true;
            }
        }
        if (!bl2) {
            return false;
        }
        if (bl2) {
            this.info.message(Config.getString((String)"editor.info.version") + versionString);
        } else if (bl3) {
            this.info.warning(Config.getString((String)"editor.info.readingProblem"), Config.getString((String)"editor.info.regularFile"));
        } else {
            this.info.message(Config.getString((String)"editor.info.version1.1"), Config.getString((String)"editor.info.newFile"));
        }
        this.setWindowTitle();
        this.sourcePane.setFont(PrefMgr.getStandardEditorFont());
        this.sourcePane.setSelectionColor(selectionColour);
        this.setCompileStatus(bl);
        return true;
    }

    public void reloadFile() {
        this.doReload();
    }

    public void clear() {
        this.ignoreChanges = true;
        this.sourcePane.setText("");
        this.ignoreChanges = false;
    }

    public void insertText(String string, boolean bl, boolean bl2) {
        this.sourcePane.replaceSelection(string);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.currentTextPane.setFont(PrefMgr.getStandardEditorFont());
            this.checkSyntaxStatus();
            this.setState(0);
            this.toFront();
        }
        super.setVisible(bl);
    }

    public void refresh() {
        this.currentTextPane.setFont(PrefMgr.getStandardEditorFont());
        this.checkSyntaxStatus();
        this.currentTextPane.repaint();
    }

    public boolean isShowing() {
        if (this.isVisible() != super.isShowing()) {
            Debug.message((String)"isVisible is not isShowing!");
        }
        return super.isShowing();
    }

    public void save() {
        if (this.saveState.isChanged()) {
            Debug.assert((this.filename != null ? 1 : 0) != 0);
            try {
                FileWriter fileWriter = new FileWriter(this.filename);
                this.sourcePane.write(fileWriter);
                fileWriter.close();
                this.setSaved();
            }
            catch (IOException iOException) {
                this.info.warning(Config.getString((String)"editor.info.errorSaving"));
            }
        }
    }

    public void close() {
        this.save();
        this.doClose();
    }

    public void displayMessage(String string, int n, int n2, boolean bl, boolean bl2, String string2) {
        this.switchToSourceView();
        Element element = this.getLine(n);
        int n3 = element.getStartOffset();
        if (bl2) {
            this.setStepMark(n3);
        }
        this.currentTextPane.setCaretPosition(n3);
        this.currentTextPane.moveCaretPosition(element.getEndOffset());
        if (bl) {
            this.info.warning(string);
        } else {
            this.info.message(string);
        }
        if (string2 != null) {
            this.info.setHelp(string2);
        }
    }

    public void setSelection(int n, int n2, int n3) {
        Element element = this.getLine(n);
        this.currentTextPane.select(element.getStartOffset() + n2 - 1, element.getStartOffset() + n2 + n3 - 1);
    }

    public void removeStepMark() {
        if (this.currentStepPos != -1) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            simpleAttributeSet.addAttribute(STEPMARK, Boolean.FALSE);
            this.sourceDocument.setParagraphAttributes(this.currentStepPos, 0, simpleAttributeSet, false);
            this.currentStepPos = -1;
            this.repaint();
        }
        this.sourcePane.setCaretPosition(this.sourcePane.getCaretPosition());
    }

    public void changeName(String string, String string2) {
        this.filename = string2;
        this.windowTitle = string;
        this.setWindowTitle();
    }

    public void setCompiled(boolean bl) {
        this.setCompileStatus(bl);
        if (bl) {
            this.info.message(Config.getString((String)"editor.info.compiled"));
        }
    }

    public void removeBreakpoints() {
        this.clearAllBreakpoints();
    }

    public boolean isModified() {
        return this.saveState.isChanged();
    }

    public void setReadOnly(boolean bl) {
        if (bl) {
            this.saveState.setState(0);
            this.actions.undoManager.discardAllEdits();
            this.actions.undoAction.update();
            this.actions.redoAction.update();
        }
        this.currentTextPane.setEditable(!bl);
    }

    public void blueJEvent(int n, Object object) {
        switch (n) {
            case 6: {
                BlueJEvent.removeListener((BlueJEventListener)this);
                this.displayInterface(true);
                break;
            }
            case 7: {
                BlueJEvent.removeListener((BlueJEventListener)this);
                this.info.warning(Config.getString((String)"editor.info.docAborted"));
                break;
            }
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (!this.saveState.isChanged()) {
            this.saveState.setState(2);
            this.setChanged();
        }
        this.actions.userAction();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        if (!this.saveState.isChanged()) {
            this.saveState.setState(2);
            this.setChanged();
        }
        this.actions.userAction();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void clearMessage() {
        this.info.clear();
    }

    public void writeMessage(String string) {
        this.info.message(string);
    }

    public void userSave() {
        if (this.saveState.isSaved()) {
            this.info.message(Config.getString((String)"editor.info.noChanges"));
        } else {
            this.save();
        }
    }

    public void reload() {
        if (this.filename == null) {
            this.info.warning(Config.getString((String)"editor.info.cannotReload"), Config.getString((String)"editor.info.reload"));
        } else if (this.saveState.isChanged()) {
            int n = DialogManager.askQuestion((Component)this, (String)"really-reload");
            if (n == 0) {
                this.doReload();
            }
        } else {
            this.doReload();
        }
    }

    public void print() {
        MoeEditor moeEditor = this;
        if (moeEditor == null) {
            throw null;
        }
        PrintThread printThread = moeEditor.new PrintThread();
        printThread.setPriority(Thread.currentThread().getPriority() - 1);
        printThread.start();
    }

    public void pageSetup() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        pageFormat = printerJob.pageDialog(pageFormat);
    }

    public void doClose() {
        this.setVisible(false);
        if (this.watcher != null) {
            this.watcher.closeEvent(this);
        }
    }

    public boolean checkExpandTabs() {
        if (this.tabsAreExpanded) {
            return false;
        }
        this.tabsAreExpanded = true;
        return true;
    }

    public void find() {
        Finder finder = MoeEditorManager.editorManager.getFinder();
        DialogManager.centreWindow((Window)finder, (Window)this);
        String string = finder.getNewSearchString(this, 0);
        if (string != null) {
            this.findString(finder, string, finder.getDirection() == 1);
        }
    }

    public void findBackward() {
        Finder finder = MoeEditorManager.editorManager.getFinder();
        String string = finder.getNewSearchString(this, 1);
        if (string != null) {
            this.findString(finder, string, finder.getDirection() == 1);
        }
    }

    public void findNext() {
        Finder finder = MoeEditorManager.editorManager.getFinder();
        String string = this.currentTextPane.getSelectedText();
        if (string == null && (string = finder.getLastSearchString()) == null) {
            this.info.warning(DialogManager.getMessage((String)"no-search-string"));
            return;
        }
        this.findString(finder, string, finder.getDirection() == 1);
    }

    public void findNextReverse() {
        Finder finder = MoeEditorManager.editorManager.getFinder();
        String string = this.currentTextPane.getSelectedText();
        if (string == null && (string = finder.getLastSearchString()) == null) {
            this.info.warning(DialogManager.getMessage((String)"no-search-string"));
            return;
        }
        this.findString(finder, string, finder.getDirection() == 0);
    }

    private void findString(Finder finder, String string, boolean bl) {
        if (string.length() == 0) {
            this.info.warning(Config.getString((String)"editor.info.emptySearchString"));
            return;
        }
        boolean bl2 = !finder.lastSearchFound();
        String string2 = "Find " + (bl ? "backward" : "forward") + (bl2 ? " (wrap around): " : ": ") + string;
        this.info.message(string2);
        boolean bl3 = bl ? this.doFindBackward(string, bl2) : this.doFind(string, bl2);
        finder.setSearchString(string);
        finder.setSearchFound(bl3);
        if (!bl3) {
            this.info.warning(string2, Config.getString((String)"editor.info.notFound"));
        }
    }

    private boolean doFind(String string, boolean bl) {
        int n = this.document.getLength();
        int n2 = this.currentTextPane.getCaretPosition();
        int n3 = n;
        boolean bl2 = false;
        boolean bl3 = false;
        int n4 = n2;
        Element element = this.getLineAt(n4);
        int n5 = Math.min(element.getEndOffset(), n3);
        try {
            while (!bl2 && !bl3) {
                int n6;
                String string2 = this.document.getText(n4, n5 - n4);
                if (string2 != null && string2.length() > 0 && (n6 = string2.indexOf(string)) != -1) {
                    this.currentTextPane.select(n4 + n6, n4 + n6 + string.length());
                    bl2 = true;
                }
                if (n5 >= n3) {
                    if (bl) {
                        n3 = n2;
                        element = this.document.getParagraphElement(0);
                        n4 = element.getStartOffset();
                        n5 = Math.min(element.getEndOffset(), n3);
                        bl = false;
                        continue;
                    }
                    bl3 = true;
                    continue;
                }
                element = this.document.getParagraphElement(n5 + 1);
                n4 = element.getStartOffset();
                n5 = Math.min(element.getEndOffset(), n3);
            }
        }
        catch (BadLocationException badLocationException) {
            Debug.message((String)"error in editor find operation");
        }
        return bl2;
    }

    private boolean doFindBackward(String string, boolean bl) {
        int n = this.document.getLength();
        int n2 = this.currentTextPane.getCaretPosition() - 1;
        if (n2 < 0) {
            n2 = n;
        }
        int n3 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        int n4 = n2;
        Element element = this.getLineAt(n4);
        int n5 = Math.max(element.getStartOffset(), n3);
        try {
            while (!bl2 && !bl3) {
                int n6;
                String string2 = this.document.getText(n5, n4 - n5);
                if (string2 != null && string2.length() > 0 && (n6 = string2.lastIndexOf(string)) != -1) {
                    this.currentTextPane.select(n5 + n6, n5 + n6 + string.length());
                    bl2 = true;
                }
                if (n5 <= n3) {
                    if (bl) {
                        n3 = n2;
                        element = this.document.getParagraphElement(n);
                        n4 = element.getEndOffset();
                        n5 = Math.max(element.getStartOffset(), n3);
                        bl = false;
                        continue;
                    }
                    bl3 = true;
                    continue;
                }
                element = this.document.getParagraphElement(n5 - 1);
                n4 = element.getEndOffset();
                n5 = Math.max(element.getStartOffset(), n3);
            }
        }
        catch (BadLocationException badLocationException) {
            Debug.message((String)"error in editor find operation");
        }
        return bl2;
    }

    public void setFontSize(int n) {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        int n2 = this.document.getStartPosition().getOffset();
        int n3 = this.document.getEndPosition().getOffset() - n2;
    }

    public void compile() {
        if (this.watcher == null) {
            return;
        }
        if (!this.viewingCode()) {
            this.info.warning(" ");
            return;
        }
        this.info.message(Config.getString((String)"editor.info.compiling"));
        this.watcher.compile(this);
    }

    public void toggleInterfaceMenu() {
        if (!this.sourceIsCode) {
            return;
        }
        if (this.interfaceToggle.getSelectedIndex() == 0) {
            this.interfaceToggle.setSelectedIndex(1);
        } else {
            this.interfaceToggle.setSelectedIndex(0);
        }
    }

    public void toggleInterface() {
        boolean bl;
        if (!this.sourceIsCode) {
            return;
        }
        boolean bl2 = bl = this.interfaceToggle.getSelectedItem() == this.interfaceString;
        if (bl && !this.viewingHTML) {
            this.switchToInterfaceView();
        } else if (!bl && this.viewingHTML) {
            this.switchToSourceView();
        }
    }

    private void switchToSourceView() {
        if (!this.viewingHTML) {
            return;
        }
        this.document = this.sourceDocument;
        this.currentTextPane = this.sourcePane;
        this.viewingHTML = false;
        this.scrollPane.setViewportView(this.currentTextPane);
        this.checkSyntaxStatus();
        this.currentTextPane.requestFocus();
    }

    private void switchToInterfaceView() {
        if (this.viewingHTML) {
            return;
        }
        this.save();
        if (this.docUpToDate()) {
            this.displayInterface(false);
        } else {
            this.info.message(Config.getString((String)"editor.info.generatingDoc"));
            BlueJEvent.addListener((BlueJEventListener)this);
            DocuGenerator.generateClassDocu((String)this.filename);
        }
    }

    private boolean docUpToDate() {
        try {
            File file = new File(this.filename);
            File file2 = new File(this.getDocPath());
            if (!file2.exists() || file.exists() && file.lastModified() > file2.lastModified()) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    private void displayInterface(boolean bl) {
        this.info.message(Config.getString((String)"editor.info.loadingDoc"));
        MoeEditor moeEditor = this;
        if (moeEditor == null) {
            throw null;
        }
        HTMLDisplayThread hTMLDisplayThread = moeEditor.new HTMLDisplayThread(bl);
        hTMLDisplayThread.start();
    }

    public void createHTMLPane() {
        this.htmlPane = new JEditorPane();
        this.htmlPane.setEditorKit(new HTMLEditorKit());
        this.htmlPane.setEditable(false);
        this.htmlPane.addHyperlinkListener(this);
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        this.info.clear();
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            JEditorPane jEditorPane = (JEditorPane)hyperlinkEvent.getSource();
            if (hyperlinkEvent instanceof HTMLFrameHyperlinkEvent) {
                HTMLFrameHyperlinkEvent hTMLFrameHyperlinkEvent = (HTMLFrameHyperlinkEvent)hyperlinkEvent;
                HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
                hTMLDocument.processHTMLFrameHyperlinkEvent(hTMLFrameHyperlinkEvent);
            } else {
                try {
                    jEditorPane.setPage(hyperlinkEvent.getURL());
                }
                catch (Throwable throwable) {
                    this.info.warning("cannot display hyperlink: " + hyperlinkEvent.getURL());
                    Debug.reportError((String)("hyperlink failed: " + throwable));
                }
            }
        }
    }

    public void toggleBreakpoint() {
        if (!this.viewingCode()) {
            this.info.warning(" ");
            return;
        }
        this.toggleBreakpoint(this.sourcePane.getCaretPosition());
    }

    public void toggleBreakpoint(int n) {
        if (this.positionHasBreakpoint(n)) {
            this.setUnsetBreakpoint(n, false);
        } else {
            this.setUnsetBreakpoint(n, true);
        }
    }

    private void clearAllBreakpoints() {
        if (this.mayHaveBreakpoints) {
            int n = 1;
            while (n <= this.numberOfLines()) {
                if (this.lineHasBreakpoint(n)) {
                    this.doRemoveBreakpoint(this.getPositionInLine(n));
                }
                ++n;
            }
            this.mayHaveBreakpoints = false;
        }
    }

    private boolean positionHasBreakpoint(int n) {
        Element element = this.getLineAt(n);
        boolean bl = Boolean.TRUE.equals(element.getAttributes().getAttribute(BREAKPOINT));
        return bl;
    }

    private boolean lineHasBreakpoint(int n) {
        Element element = this.getLine(n);
        return Boolean.TRUE.equals(element.getAttributes().getAttribute(BREAKPOINT));
    }

    private void setUnsetBreakpoint(int n, boolean bl) {
        if (this.watcher != null) {
            int n2 = this.getLineNumberAt(n);
            String string = this.watcher.breakpointToggleEvent(this, n2, bl);
            if (string == null) {
                SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                if (bl) {
                    simpleAttributeSet.addAttribute(BREAKPOINT, Boolean.TRUE);
                    this.mayHaveBreakpoints = true;
                } else {
                    simpleAttributeSet.addAttribute(BREAKPOINT, Boolean.FALSE);
                }
                this.sourceDocument.setParagraphAttributes(n, 0, simpleAttributeSet, false);
            } else {
                this.info.warning(string);
            }
            this.repaint();
        } else {
            this.info.warning(Config.getString((String)"editor.info.cannotSetBreak"));
        }
    }

    private void doRemoveBreakpoint(int n) {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        simpleAttributeSet.addAttribute(BREAKPOINT, Boolean.FALSE);
        this.sourceDocument.setParagraphAttributes(n, 0, simpleAttributeSet, false);
    }

    private void setStepMark(int n) {
        this.removeStepMark();
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        simpleAttributeSet.addAttribute(STEPMARK, Boolean.TRUE);
        this.sourceDocument.setParagraphAttributes(n, 0, simpleAttributeSet, false);
        this.currentStepPos = n;
        this.repaint();
    }

    private boolean viewingCode() {
        return this.sourceIsCode && !this.viewingHTML;
    }

    private int numberOfLines() {
        return this.document.getDefaultRootElement().getElementCount();
    }

    private Element getCurrentLine() {
        return this.document.getParagraphElement(this.currentTextPane.getCaretPosition());
    }

    private Element getLine(int n) {
        return this.document.getDefaultRootElement().getElement(n - 1);
    }

    private Element getLineAt(int n) {
        return this.document.getParagraphElement(n);
    }

    private int getPositionInLine(int n) {
        return this.getLine(n).getStartOffset();
    }

    private int getCurrentLineNo() {
        return this.document.getDefaultRootElement().getElementIndex(this.currentTextPane.getCaretPosition()) + 1;
    }

    private int getLineNumberAt(int n) {
        return this.document.getDefaultRootElement().getElementIndex(n) + 1;
    }

    public void doReload() {
        Debug.assert((this.filename != null ? 1 : 0) != 0);
        try {
            FileReader fileReader = new FileReader(this.filename);
            this.sourcePane.read(fileReader, null);
            fileReader.close();
            this.sourceDocument = (MoeSyntaxDocument)this.sourcePane.getDocument();
            this.checkSyntaxStatus();
            this.sourceDocument.addDocumentListener(this);
            MoeEditor moeEditor = this;
            if (moeEditor == null) {
                throw null;
            }
            this.sourceDocument.addUndoableEditListener(moeEditor.new MoeUndoableEditListener());
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.info.warning(Config.getString((String)"editor.info.fileDisappeared"));
        }
        catch (IOException iOException) {
            this.info.warning(Config.getString((String)"editor.info.fileReadError"));
        }
        this.setSaved();
    }

    private void checkSyntaxStatus() {
        if (this.sourceDocument != null) {
            if (this.viewingCode() && PrefMgr.useSyntaxHilighting()) {
                if (this.sourceDocument.getTokenMarker() == null) {
                    this.sourceDocument.setTokenMarker(new JavaTokenMarker());
                }
            } else {
                this.sourceDocument.setTokenMarker(null);
            }
        }
    }

    private void setCompileStatus(boolean bl) {
        this.actions.getActionByName("toggle-breakpoint").setEnabled(bl && this.viewingCode());
        this.isCompiled = bl;
        if (bl) {
            this.document.putProperty(COMPILED, Boolean.TRUE);
        } else {
            this.document.putProperty(COMPILED, Boolean.FALSE);
        }
        this.currentTextPane.repaint();
    }

    private void setSaved() {
        this.info.message(Config.getString((String)"editor.info.saved"));
        this.saveState.setState(1);
        if (this.watcher != null) {
            this.watcher.saveEvent(this);
        }
    }

    private void setChanged() {
        if (this.ignoreChanges) {
            return;
        }
        this.setCompileStatus(false);
        if (this.watcher != null) {
            this.watcher.modificationEvent(this);
        }
    }

    void caretMoved() {
        this.clearMessage();
        this.actions.userAction();
    }

    private void setWindowTitle() {
        String string = this.windowTitle;
        if (string == null) {
            string = this.filename == null ? "Moe:  <no name>" : "Moe:  " + this.filename;
        }
        this.setTitle(string);
    }

    private String getDocPath() {
        if (this.docpath == null) {
            this.docpath = DocuGenerator.getDocuPath((String)this.filename);
        }
        return this.docpath;
    }

    private void showLineCounter(boolean bl) {
        if (bl) {
            this.statusArea.add(this.lineCounter);
        } else {
            this.statusArea.remove(this.lineCounter);
        }
        this.validate();
    }

    private String getResource(String string) {
        return this.resources.getProperty(string);
    }

    private String[] tokenize(String string) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)vector.elementAt(n);
            ++n;
        }
        return stringArray;
    }

    private void initWindow(boolean bl, boolean bl2) {
        ((Frame)this).setIconImage(iconImage);
        ((Component)this).setBackground(frameBgColor);
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.setContentPane(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(5, 5));
        this.info = new Info();
        jPanel2.add((Component)this.info, "Center");
        this.statusArea = new JPanel();
        this.statusArea.setLayout(new GridLayout(0, 1));
        this.statusArea.setBackground(infoColor);
        this.statusArea.setBorder(BorderFactory.createLineBorder(Color.black));
        this.lineCounter = new LineNumberLabel(1);
        this.saveState = new StatusLabel(1);
        if (bl2) {
            this.statusArea.add(this.lineCounter);
        }
        this.statusArea.add(this.saveState);
        jPanel2.add((Component)this.statusArea, "East");
        jPanel.add((Component)jPanel2, "South");
        this.sourceDocument = new MoeSyntaxDocument();
        this.sourceDocument.addDocumentListener(this);
        MoeEditor moeEditor = this;
        if (moeEditor == null) {
            throw null;
        }
        this.sourceDocument.addUndoableEditListener(moeEditor.new MoeUndoableEditListener());
        MoeSyntaxEditorKit moeSyntaxEditorKit = new MoeSyntaxEditorKit();
        this.sourcePane = new MoeEditorPane();
        this.sourcePane.setDocument(this.sourceDocument);
        this.sourcePane.setCaretPosition(0);
        this.sourcePane.setMargin(new Insets(2, 2, 2, 2));
        this.sourcePane.setOpaque(true);
        this.sourcePane.setEditorKit(moeSyntaxEditorKit);
        this.sourcePane.setCaret(new MoeCaret(this));
        this.sourcePane.getCaret().setBlinkRate(0);
        this.sourcePane.setSelectionColor(selectionColor);
        this.sourcePane.setCaretColor(cursorColor);
        this.document = this.sourceDocument;
        this.currentTextPane = this.sourcePane;
        this.scrollPane = new JScrollPane(this.currentTextPane);
        this.scrollPane.setPreferredSize(new Dimension(598, 400));
        jPanel.add((Component)this.scrollPane, "Center");
        this.actions = MoeActions.getActions(this.sourcePane);
        this.actions.getActionByName("replace").setEnabled(false);
        this.actions.getActionByName("show-manual").setEnabled(false);
        JMenuBar jMenuBar = this.createMenuBar();
        this.setJMenuBar(jMenuBar);
        this.toolbar = this.createToolbar();
        jPanel.add((Component)this.toolbar, "North");
        MoeEditor moeEditor2 = this;
        if (moeEditor2 == null) {
            throw null;
        }
        this.addWindowListener(new WindowAdapter(moeEditor2){
            private final /* synthetic */ MoeEditor this$0;

            public void windowClosing(WindowEvent windowEvent) {
                this.this$0.close();
            }

            public void windowActivated(WindowEvent windowEvent) {
                MoeEditor.access$0(this.this$0).requestFocus();
            }
            {
                this.this$0 = moeEditor;
                this.constructor$0(moeEditor);
            }

            private final void constructor$0(MoeEditor moeEditor) {
            }
        });
        this.setWindowTitle();
        this.pack();
    }

    private JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = null;
        String[] stringArray = this.tokenize(this.getResource("menubar"));
        int n = 0;
        while (n < stringArray.length) {
            jMenu = this.createMenu(stringArray[n]);
            if (jMenu != null) {
                if (stringArray[n].equals("help")) {
                    jMenuBar.add(Box.createHorizontalGlue());
                }
                jMenuBar.add(jMenu);
            }
            ++n;
        }
        if (jMenu != null) {
            // empty if block
        }
        return jMenuBar;
    }

    private JMenu createMenu(String string) {
        JMenu jMenu = new JMenu(Config.getString((String)("editor." + string + LabelSuffix)));
        String string2 = this.getResource(string);
        if (string2 == null) {
            Debug.message((String)("Moe: cannot find menu definition for " + string));
            return null;
        }
        String[] stringArray = this.tokenize(string2);
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-")) {
                jMenu.addSeparator();
            } else {
                Action action = this.actions.getActionByName(stringArray[n]);
                if (action == null) {
                    Debug.message((String)("Moe: cannot find action " + stringArray[n]));
                } else {
                    KeyStroke[] keyStrokeArray;
                    JMenuItem jMenuItem = jMenu.add(action);
                    String string3 = Config.getString((String)("editor." + stringArray[n] + LabelSuffix));
                    if (string3 != null) {
                        jMenuItem.setText(string3);
                    }
                    if ((keyStrokeArray = this.actions.getKeyStrokesForAction(action)) != null) {
                        jMenuItem.setAccelerator(keyStrokeArray[0]);
                    }
                }
            }
            ++n;
        }
        return jMenu;
    }

    private JComponent createToolbar() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        String[] stringArray = this.tokenize(this.getResource("toolbar"));
        int n = 0;
        while (n < stringArray.length) {
            jPanel.add(this.createToolbarButton(stringArray[n], false));
            jPanel.add(Box.createHorizontalStrut(4));
            ++n;
        }
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.createInterfaceSelector());
        return jPanel;
    }

    private AbstractButton createToolbarButton(String string, boolean bl) {
        Action action;
        String string2 = Config.getString((String)("editor." + string + LabelSuffix));
        AbstractButton abstractButton = bl ? new JToggleButton(string2) : new JButton(string2);
        abstractButton.setRequestFocusEnabled(false);
        abstractButton.setMargin(new Insets(2, 2, 2, 2));
        String string3 = this.getResource(string + ActionSuffix);
        if (string3 == null) {
            string3 = string;
        }
        if ((action = this.actions.getActionByName(string3)) != null) {
            abstractButton.addActionListener(action);
            abstractButton.setActionCommand(string3);
        } else {
            abstractButton.setEnabled(false);
            Debug.message((String)("Moe: action not found for button " + string2));
        }
        return abstractButton;
    }

    private JComboBox createInterfaceSelector() {
        String[] stringArray = new String[]{this.implementationString, this.interfaceString};
        this.interfaceToggle = new JComboBox<String>(stringArray);
        this.interfaceToggle.setRequestFocusEnabled(false);
        this.interfaceToggle.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.interfaceToggle.setForeground(envOpColour);
        String string = "toggle-interface-view";
        Action action = this.actions.getActionByName(string);
        if (action != null) {
            MoeEditor moeEditor = this;
            if (moeEditor == null) {
                throw null;
            }
            this.interfaceToggle.addActionListener(new ActionListener(moeEditor){
                private final /* synthetic */ MoeEditor this$0;

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$0.toggleInterface();
                }
                {
                    this.this$0 = moeEditor;
                    this.constructor$0(moeEditor);
                }

                private final void constructor$0(MoeEditor moeEditor) {
                }
            });
        } else {
            this.interfaceToggle.setEnabled(false);
            Debug.message((String)("Moe: action not found: " + string));
        }
        if (!this.sourceIsCode) {
            this.interfaceToggle.setEnabled(false);
        }
        return this.interfaceToggle;
    }

    static /* synthetic */ AbstractDocument access$12(MoeEditor moeEditor) {
        return moeEditor.document;
    }

    static /* synthetic */ boolean access$15(MoeEditor moeEditor) {
        return moeEditor.viewingHTML;
    }

    public MoeEditor(String string, boolean bl, EditorWatcher editorWatcher, boolean bl2, boolean bl3, Properties properties) {
        super("Moe");
        this.watcher = editorWatcher;
        this.resources = properties;
        this.filename = null;
        this.windowTitle = string;
        this.firstSave = true;
        this.isCompiled = false;
        this.newline = System.getProperty("line.separator");
        this.sourceIsCode = bl;
        this.viewingHTML = false;
        this.currentStepPos = -1;
        this.mayHaveBreakpoints = false;
        this.initWindow(bl2, bl3);
    }

    private class MoeUndoableEditListener
    implements UndoableEditListener {
        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            ((MoeEditor)MoeEditor.this).actions.undoManager.addEdit(undoableEditEvent.getEdit());
            ((MoeEditor)MoeEditor.this).actions.undoAction.update();
            ((MoeEditor)MoeEditor.this).actions.redoAction.update();
        }

        MoeUndoableEditListener() {
        }
    }

    private class ActionChangeListener
    implements PropertyChangeListener {
        JButton button;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("enabled")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                this.button.setEnabled(bl);
            }
        }

        ActionChangeListener(JButton jButton) {
            this.button = jButton;
        }
    }

    class PrintThread
    extends Thread {
        public void run() {
            if (MoeEditor.this.printer == null) {
                MoeEditor.this.printer = new MoePrinter();
            }
            MoeEditor.this.info.message(Config.getString((String)"editor.info.printing"));
            if (MoeEditor.this.printer.printDocument(MoeEditor.this.sourceDocument, MoeEditor.this.windowTitle, printFont, pageFormat)) {
                MoeEditor.this.info.message(Config.getString((String)"editor.info.printed"));
            } else {
                MoeEditor.this.info.message(Config.getString((String)"editor.info.cancelled"));
            }
        }

        PrintThread() {
        }
    }

    class HTMLDisplayThread
    extends Thread {
        private boolean reload;

        public void run() {
            if (MoeEditor.this.htmlDocument == null) {
                MoeEditor.this.createHTMLPane();
                this.reload = true;
            }
            if (this.reload) {
                try {
                    try {
                        MoeEditor.this.htmlPane.setPage("file:/dummy");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    File file = new File(MoeEditor.this.getDocPath());
                    URL uRL = file.toURL();
                    MoeEditor.this.htmlPane.setPage(uRL);
                    MoeEditor.this.htmlDocument = (HTMLDocument)MoeEditor.this.htmlPane.getDocument();
                    MoeEditor.this.htmlDocument.setBase(uRL);
                    MoeEditor.this.info.message(Config.getString((String)"editor.info.docLoaded"));
                }
                catch (Exception exception) {
                    MoeEditor.this.info.warning(Config.getString((String)"editor.info.docDisappeared"), MoeEditor.this.getDocPath());
                    Debug.reportError((String)("loading class interface failed: " + exception));
                }
            }
            MoeEditor.this.document = MoeEditor.this.htmlDocument;
            MoeEditor.this.currentTextPane = MoeEditor.this.htmlPane;
            MoeEditor.this.viewingHTML = true;
            MoeEditor.this.scrollPane.setViewportView(MoeEditor.this.currentTextPane);
            MoeEditor.this.currentTextPane.requestFocus();
        }

        HTMLDisplayThread(boolean bl) {
            this.reload = bl;
        }
    }
}

