/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.Config;
import bluej.editor.Editor;
import bluej.editor.EditorManager;
import bluej.editor.EditorWatcher;
import bluej.editor.moe.Finder;
import bluej.editor.moe.MoeEditor;
import java.awt.Toolkit;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public final class MoeEditorManager
extends EditorManager {
    protected static MoeEditorManager editorManager;
    private Properties resources;
    private Vector editors = new Vector(4, 4);
    private Finder finder = new Finder();
    private boolean showLineNum = false;
    private boolean showToolBar = true;

    public Editor openClass(String string, String string2, EditorWatcher editorWatcher, boolean bl, Vector vector) {
        return this.openEditor(string, true, string2, editorWatcher, bl, vector);
    }

    public Editor openText(String string, String string2, EditorWatcher editorWatcher) {
        return this.openEditor(string, false, string2, editorWatcher, false, null);
    }

    public void refreshAll() {
        Iterator iterator = ((AbstractList)this.editors).iterator();
        while (iterator.hasNext()) {
            Editor editor = (Editor)iterator.next();
            if (!editor.isShowing()) continue;
            editor.refresh();
        }
    }

    public void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    public void discardEditor(Editor editor) {
        editor.close();
        this.editors.removeElement(editor);
    }

    Finder getFinder() {
        return this.finder;
    }

    private Editor openEditor(String string, boolean bl, String string2, EditorWatcher editorWatcher, boolean bl2, Vector vector) {
        MoeEditor moeEditor = new MoeEditor(string2, bl, editorWatcher, this.showToolBar, this.showLineNum, this.resources);
        this.editors.addElement(moeEditor);
        if (editorWatcher != null && string == null) {
            return moeEditor;
        }
        if (moeEditor.showFile(string, bl2, null)) {
            return moeEditor;
        }
        moeEditor.doClose();
        return null;
    }

    public void read_prefs() {
    }

    public void write_prefs() {
    }

    public MoeEditorManager() {
        this.resources = Config.moe_props;
        editorManager = this;
    }
}

