/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.Config;
import bluej.utility.Debug;
import bluej.utility.Utility;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;
import javax.swing.text.StyleContext;

public class MoePrinter {
    static final String CONTINUED_LABEL = Config.getString((String)"editor.printer.continued");
    private static Font titleFont = new Font("SansSerif", 1, 14);
    private static Font smallTitleFont = new Font("SansSerif", 1, 10);
    private static Font footerFont = new Font("SansSerif", 2, 9);
    private final int HEADER_SPACE;
    private final int FOOTER_SPACE;
    private final int PADDING;
    private final char TAB_CHAR = (char)9;
    private Book pages = new Book();
    private String className;
    private int tabSize = Config.getPropInteger((String)"bluej.editor.tabsize", (int)4);

    public boolean printDocument(PlainDocument plainDocument, String string, Font font, PageFormat pageFormat) {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.className = string;
        Integer n = (Integer)plainDocument.getProperty("tabSize");
        if (n != null) {
            this.tabSize = n;
        }
        try {
            plainDocument.readLock();
            Element element = plainDocument.getDefaultRootElement();
            int n2 = element.getElementCount();
            Segment segment = new Segment();
            int n3 = 0;
            while (n3 < n2) {
                Element element2 = element.getElement(n3);
                try {
                    plainDocument.getText(element2.getStartOffset(), element2.getEndOffset() - element2.getStartOffset(), segment);
                    arrayList.add(this.removeNewLines(segment.toString()));
                }
                catch (BadLocationException badLocationException) {
                    Debug.reportError((String)("Exception thrown accessing document text: " + badLocationException));
                }
                ++n3;
            }
        }
        finally {
            Object var8_13 = null;
            plainDocument.readUnlock();
        }
        return this.printText(arrayList, font, pageFormat);
    }

    private String removeNewLines(String string) {
        int n = string.length();
        int n2 = n > 0 ? (int)string.charAt(string.length() - 1) : 32;
        while (n2 == 10 || n2 == 13) {
            n = (string = string.substring(0, string.length() - 1)).length();
            int n3 = n2 = n > 0 ? (int)string.charAt(string.length() - 1) : 32;
        }
        return string;
    }

    private boolean printText(List list, Font font, PageFormat pageFormat) {
        try {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            pageFormat = printerJob.validatePage(pageFormat);
            this.pages = this.paginateText(list, pageFormat, font);
            printerJob.setPageable(this.pages);
            if (printerJob.printDialog()) {
                printerJob.print();
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            Debug.reportError((String)("Exception thrown during printing: " + exception));
            return false;
        }
    }

    private Book paginateText(List list, PageFormat pageFormat, Font font) {
        Book book = new Book();
        int n = 0;
        int n2 = 1;
        int n3 = (int)pageFormat.getImageableHeight() - 50;
        int n4 = n3 / (font.getSize() + 2);
        this.wrapLines(list, pageFormat, font);
        int n5 = list.size() / n4 + 1;
        ListIterator listIterator = list.listIterator();
        while (n2 <= n5) {
            ArrayList arrayList = new ArrayList();
            int n6 = 0;
            while (listIterator.hasNext() && n6 < n4) {
                arrayList.add(listIterator.next());
                ++n;
                ++n6;
            }
            MoePrinter moePrinter = this;
            if (moePrinter == null) {
                throw null;
            }
            book.append(moePrinter.new MoePage(arrayList, font), pageFormat);
            ++n2;
        }
        return book;
    }

    private void wrapLines(List list, PageFormat pageFormat, Font font) {
        StyleContext styleContext = new StyleContext();
        FontMetrics fontMetrics = styleContext.getFontMetrics(font);
        int n = (int)pageFormat.getImageableWidth() - 10;
        int n2 = fontMetrics.charWidth('m');
        int n3 = n / n2;
        ListIterator<String> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            String string = Utility.convertTabsToSpaces((String)((String)listIterator.next()), (int)this.tabSize);
            listIterator.set(string);
            int n4 = string.length();
            int n5 = fontMetrics.stringWidth(string);
            if (n5 <= n) continue;
            int n6 = listIterator.previousIndex();
            listIterator.remove();
            double d = n4 / n3 + 1;
            int n7 = 0;
            int n8 = 0;
            while (d > 0.0) {
                n8 = n7 + n3 < n4 ? n7 + n3 : n4;
                String string2 = string.substring(n7, n8);
                if (string2.length() != 0) {
                    listIterator.add(string2);
                }
                d -= 1.0;
                n7 += n3;
            }
        }
    }

    static /* synthetic */ int access$0(MoePrinter moePrinter) {
        return moePrinter.HEADER_SPACE;
    }

    static /* synthetic */ int access$1(MoePrinter moePrinter) {
        return moePrinter.PADDING;
    }

    static /* synthetic */ int access$2(MoePrinter moePrinter) {
        return moePrinter.FOOTER_SPACE;
    }

    public MoePrinter() {
        this.HEADER_SPACE = 30;
        this.FOOTER_SPACE = 20;
        this.PADDING = 5;
    }

    class MoePage
    implements Printable {
        private List text;
        private Font font;

        public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
            graphics.setFont(this.font);
            graphics.setColor(Color.black);
            int n2 = (int)pageFormat.getImageableX();
            int n3 = (int)pageFormat.getImageableY();
            int n4 = (int)pageFormat.getImageableWidth();
            int n5 = (int)pageFormat.getImageableHeight();
            this.printHeader(graphics, n, n2, n3, n4, 30);
            int n6 = n3 + 30;
            int n7 = n2 + 5;
            graphics.drawRect(n2, n6, n4, n5 - 50);
            ListIterator listIterator = this.text.listIterator();
            while (listIterator.hasNext()) {
                int n8 = n6 + (this.font.getSize() + 2) * (listIterator.nextIndex() + 1);
                graphics.drawString((String)listIterator.next(), n7, n8);
            }
            int n9 = n3 + n5 - 20;
            this.printFooter(graphics, n2, n9, n4, 20);
            return 0;
        }

        private void printHeader(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            graphics.setColor(Color.lightGray);
            graphics.fillRect(n2, n3, n4, n5);
            graphics.setColor(Color.black);
            graphics.drawRect(n2, n3, n4, n5);
            int n6 = n3 + 30 - this.font.getSize() + 2;
            Object var8_8 = null;
            String string = "Class " + MoePrinter.this.className;
            if (n == 0) {
                graphics.setFont(titleFont);
            } else {
                if (!"".equals(CONTINUED_LABEL) && !"editor.printer.continued".equals(CONTINUED_LABEL)) {
                    string = string + " (" + CONTINUED_LABEL + ")";
                }
                graphics.setFont(smallTitleFont);
            }
            graphics.drawString(string, n2 + 5, n6);
            graphics.setFont(smallTitleFont);
            FontMetrics fontMetrics = graphics.getFontMetrics(smallTitleFont);
            String string2 = n + 1 + "/" + MoePrinter.this.pages.getNumberOfPages();
            int n7 = n2 + n4 - 5 - fontMetrics.stringWidth(string2);
            graphics.drawString(string2, n7, n6);
            graphics.setFont(this.font);
        }

        private void printFooter(Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setFont(footerFont);
            FontMetrics fontMetrics = graphics.getFontMetrics(footerFont);
            int n5 = n2 + 20 - this.font.getSize() + 2;
            Date date = new Date();
            DateFormat dateFormat = DateFormat.getDateTimeInstance();
            String string = dateFormat.format(date);
            int n6 = n + n3 - 5 - fontMetrics.stringWidth(string);
            graphics.drawString(string, n6, n5);
            graphics.setFont(this.font);
        }

        MoePage(List list, Font font) {
            this.text = list;
            this.font = font;
        }
    }
}

