/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.Config;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainView;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import org.gjt.sp.jedit.syntax.SyntaxDocument;
import org.gjt.sp.jedit.syntax.Token;
import org.gjt.sp.jedit.syntax.TokenMarker;

public class MoeSyntaxView
extends PlainView {
    static final Image breakImage = Config.getImageAsIcon((String)"image.breakmark").getImage();
    static final Image stepImage = Config.getImageAsIcon((String)"image.stepmark").getImage();
    static final Image breakStepImage = Config.getImageAsIcon((String)"image.breakstepmark").getImage();
    static final int BREAKPOINT_OFFSET = 16;
    private Segment line = new Segment();

    public void drawLine(int n, Graphics graphics, int n2, int n3) {
        int n4 = n2 + 16;
        SyntaxDocument syntaxDocument = (SyntaxDocument)this.getDocument();
        TokenMarker tokenMarker = syntaxDocument.getTokenMarker();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Color color = this.getDefaultColor();
        try {
            Element element = this.getElement().getElement(n);
            int n5 = element.getStartOffset();
            int n6 = element.getEndOffset();
            syntaxDocument.getText(n5, n6 - (n5 + 1), this.line);
            if (Boolean.TRUE.equals(element.getAttributes().getAttribute("break"))) {
                if (Boolean.TRUE.equals(element.getAttributes().getAttribute("step"))) {
                    graphics.drawImage(breakStepImage, n2 - 1, n3 - breakStepImage.getHeight(null), null);
                } else {
                    graphics.drawImage(breakImage, n2 - 1, n3 - breakImage.getHeight(null), null);
                }
            } else if (Boolean.TRUE.equals(element.getAttributes().getAttribute("step"))) {
                graphics.drawImage(stepImage, n2 - 1, n3 - stepImage.getHeight(null), null);
            }
            if (tokenMarker == null) {
                graphics.setColor(color);
                Utilities.drawTabbedText(this.line, n4, n3, graphics, (TabExpander)this, 0);
            } else {
                this.paintSyntaxLine(this.line, n, n4, n3, graphics, syntaxDocument, tokenMarker, color);
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    protected Color getDefaultColor() {
        return this.getContainer().getForeground();
    }

    private void paintSyntaxLine(Segment segment, int n, int n2, int n3, Graphics graphics, SyntaxDocument syntaxDocument, TokenMarker tokenMarker, Color color) {
        byte by;
        Color[] colorArray = syntaxDocument.getColors();
        Token token = tokenMarker.markTokens(segment, n);
        int n4 = 0;
        while ((by = token.id) != 127) {
            int n5 = token.length;
            Color color2 = by == 0 ? color : colorArray[by];
            graphics.setColor(color2 == null ? color : color2);
            segment.count = n5;
            n2 = Utilities.drawTabbedText(segment, n2, n3, graphics, (TabExpander)this, n4);
            segment.offset += n5;
            n4 += n5;
            token = token.next;
        }
    }

    public void paint(Graphics graphics, Shape shape) {
        super.paint(graphics, shape);
        Rectangle rectangle = shape.getBounds();
        if (Boolean.FALSE.equals(this.getDocument().getProperty("compiled"))) {
            graphics.setColor(Color.lightGray);
            graphics.fillRect(0, 0, rectangle.x + 14, rectangle.y + rectangle.height);
        }
        graphics.setColor(Color.black);
        graphics.drawLine(rectangle.x + 14, 0, rectangle.x + 14, rectangle.y + rectangle.height);
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        Document document = this.getDocument();
        Element element = this.getElement();
        int n2 = element.getElementIndex(n);
        Rectangle rectangle = this.lineToRect(shape, n2);
        int n3 = rectangle.x + 14 + 2;
        Element element2 = element.getElement(n2);
        int n4 = element2.getStartOffset();
        Segment segment = this.getLineBuffer();
        document.getText(n4, n - n4, segment);
        int n5 = Utilities.getTabbedTextWidth(segment, this.metrics, n3, (TabExpander)this, n4);
        rectangle.x += n5 + 16;
        rectangle.width = 1;
        rectangle.height = this.metrics.getHeight();
        return rectangle;
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        biasArray[0] = Position.Bias.Forward;
        Rectangle rectangle = shape.getBounds();
        Document document = this.getDocument();
        int n = (int)f;
        int n2 = (int)f2;
        if (n2 < rectangle.y) {
            return this.getStartOffset();
        }
        if (n2 > rectangle.y + rectangle.height) {
            return this.getEndOffset() - 1;
        }
        Element element = document.getDefaultRootElement();
        int n3 = Math.abs((n2 - rectangle.y) / this.metrics.getHeight());
        if (n3 >= element.getElementCount()) {
            return this.getEndOffset() - 1;
        }
        Element element2 = element.getElement(n3);
        if (n < rectangle.x) {
            return element2.getStartOffset();
        }
        if (n > rectangle.x + rectangle.width) {
            return element2.getEndOffset() - 1;
        }
        try {
            Segment segment = this.getLineBuffer();
            int n4 = element2.getStartOffset();
            int n5 = element2.getEndOffset() - 1;
            document.getText(n4, n5 - n4, segment);
            int n6 = rectangle.x + 14 + 2;
            int n7 = n4 + Utilities.getTabbedTextOffset(segment, this.metrics, n6, n, this, n4);
            return n7;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    public float nextTabStop(float f, int n) {
        int n2 = this.getTabSize() * this.metrics.charWidth('m');
        if (n2 == 0) {
            return f;
        }
        int n3 = (int)((f - 16.0f) / (float)n2) + 1;
        return n3 * n2 + 16 + 2;
    }

    public Rectangle lineToRect(Shape shape, int n) {
        Rectangle rectangle = null;
        if (this.metrics != null) {
            Rectangle rectangle2 = shape.getBounds();
            rectangle = new Rectangle(rectangle2.x, rectangle2.y + n * this.metrics.getHeight(), rectangle2.width, this.metrics.getHeight());
        }
        return rectangle;
    }

    public MoeSyntaxView(Element element) {
        super(element);
    }
}

