/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.syntax;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.Segment;
import javax.swing.text.TextAction;
import org.gjt.sp.jedit.syntax.SyntaxDocument;
import org.gjt.sp.jedit.syntax.SyntaxEditorKit;
import org.gjt.sp.jedit.syntax.SyntaxUtilities;
import org.gjt.sp.jedit.syntax.TokenMarker;

public class SyntaxTextArea
extends JEditorPane {
    public static final EditorKit EDITOR_KIT = new SyntaxEditorKit();
    private static boolean keymapInitialized;
    private Color lineHighlightColor;
    private Object lineHighlightTag;
    private Color bracketHighlightColor;
    private Object bracketHighlightTag;
    private int electricLines;
    private boolean block;
    private boolean overwrite;
    private Segment lineSegment;
    private int lastLine = -1;
    private int lastBracket = -1;

    public EditorKit createDefaultEditorKit() {
        return EDITOR_KIT;
    }

    public void setHighlightedLine(int n, int n2) {
        if (this.lineHighlightTag == null) {
            return;
        }
        try {
            this.getHighlighter().changeHighlight(this.lineHighlightTag, n, n2);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public void setLineHighlightColor(Color color) {
        this.lineHighlightColor = color;
    }

    public Color getLineHighlightColor() {
        return this.lineHighlightColor;
    }

    public void setLineHighlight(boolean bl) {
        if (this.lineHighlightTag != null) {
            if (bl) {
                return;
            }
            this.getHighlighter().removeHighlight(this.lineHighlightTag);
            this.lineHighlightTag = null;
        } else if (bl) {
            try {
                SyntaxTextArea syntaxTextArea = this;
                if (syntaxTextArea == null) {
                    throw null;
                }
                this.lineHighlightTag = this.getHighlighter().addHighlight(0, 0, syntaxTextArea.new CurrentLineHighlighter());
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
    }

    public boolean getLineHighlight() {
        return this.lineHighlightTag != null;
    }

    public void setHighlightedBracket(int n) {
        if (this.bracketHighlightTag == null) {
            return;
        }
        if (n == this.lastBracket) {
            return;
        }
        this.lastBracket = n;
        try {
            if (n == -1) {
                this.getHighlighter().changeHighlight(this.bracketHighlightTag, 0, 0);
            } else {
                this.getHighlighter().changeHighlight(this.bracketHighlightTag, n, n + 1);
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public void setBracketHighlightColor(Color color) {
        this.bracketHighlightColor = color;
    }

    public Color getBracketHighlightColor() {
        return this.bracketHighlightColor;
    }

    public void setBracketHighlight(boolean bl) {
        if (this.bracketHighlightTag != null) {
            if (bl) {
                return;
            }
            this.getHighlighter().removeHighlight(this.bracketHighlightTag);
            this.bracketHighlightTag = null;
        } else if (bl) {
            try {
                SyntaxTextArea syntaxTextArea = this;
                if (syntaxTextArea == null) {
                    throw null;
                }
                this.bracketHighlightTag = this.getHighlighter().addHighlight(0, 0, syntaxTextArea.new BracketHighlighter());
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
    }

    public boolean getBracketHighlight() {
        return this.bracketHighlightTag != null;
    }

    public void setElectricBorders(int n) {
        this.electricLines = n;
    }

    public int getElectricBorders() {
        return this.electricLines;
    }

    public void setBlockCaret(boolean bl) {
        this.block = bl;
    }

    public boolean getBlockCaret() {
        return this.block;
    }

    public void setOverwrite(boolean bl) {
        this.overwrite = bl;
    }

    public boolean getOverwrite(boolean bl) {
        return bl;
    }

    public void toggleOverwrite() {
        this.overwrite = !this.overwrite;
    }

    public void updateHighlighters() {
        Document document = this.getDocument();
        int n = this.getCaretPosition();
        Element element = document.getDefaultRootElement();
        int n2 = element.getElementIndex(n);
        Element element2 = element.getElement(n2);
        int n3 = element2.getStartOffset();
        int n4 = element2.getEndOffset();
        if (this.getSelectionStart() == this.getSelectionEnd() && n2 != this.lastLine) {
            this.setHighlightedLine(n3, n4);
            this.lastLine = n2;
        }
        try {
            if (n != 0) {
                int n5;
                document.getText(--n, 1, this.lineSegment);
                char c = this.lineSegment.array[this.lineSegment.offset];
                switch (c) {
                    case '(': {
                        n5 = SyntaxUtilities.locateBracketForward(document, n, '(', ')');
                        break;
                    }
                    case ')': {
                        n5 = SyntaxUtilities.locateBracketBackward(document, n, '(', ')');
                        break;
                    }
                    case '[': {
                        n5 = SyntaxUtilities.locateBracketForward(document, n, '[', ']');
                        break;
                    }
                    case ']': {
                        n5 = SyntaxUtilities.locateBracketBackward(document, n, '[', ']');
                        break;
                    }
                    case '{': {
                        n5 = SyntaxUtilities.locateBracketForward(document, n, '{', '}');
                        break;
                    }
                    case '}': {
                        n5 = SyntaxUtilities.locateBracketBackward(document, n, '{', '}');
                        break;
                    }
                    default: {
                        n5 = -1;
                        break;
                    }
                }
                this.setHighlightedBracket(n5);
            } else {
                this.setHighlightedBracket(-1);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void setDocument(Document document) {
        if (!(document instanceof SyntaxDocument)) {
            throw new IllegalArgumentException("Document is not an instance of SyntaxDocument");
        }
        super.setDocument(document);
    }

    public void setText(String string) {
        Document document = this.getDocument();
        try {
            document.remove(0, document.getLength());
            document.insertString(0, string, null);
        }
        catch (BadLocationException badLocationException) {
            throw new InternalError("setText() fuckup");
        }
    }

    public SyntaxDocument getSyntaxDocument() {
        return (SyntaxDocument)this.getDocument();
    }

    public TokenMarker getTokenMarker() {
        return this.getSyntaxDocument().getTokenMarker();
    }

    public void setTokenMarker(TokenMarker tokenMarker) {
        this.getSyntaxDocument().setTokenMarker(tokenMarker);
    }

    public Color[] getColors() {
        return this.getSyntaxDocument().getColors();
    }

    public void setColors(Color[] colorArray) {
        this.getSyntaxDocument().setColors(colorArray);
    }

    public void tokenizeLines() {
        this.getSyntaxDocument().tokenizeLines();
    }

    public void tokenizeLines(int n, int n2) {
        this.getSyntaxDocument().tokenizeLines(n, n2);
    }

    public void doElectricScroll(Rectangle rectangle) {
        SyntaxTextArea syntaxTextArea = this;
        if (syntaxTextArea == null) {
            throw null;
        }
        SwingUtilities.invokeLater(syntaxTextArea.new SyntaxSafeScroller(rectangle));
    }

    private void _replaceSelection(String string) {
        if (!this.overwrite || this.getSelectionStart() != this.getSelectionEnd()) {
            this.replaceSelection(string);
            return;
        }
        int n = this.getCaretPosition();
        Document document = this.getDocument();
        Element element = document.getDefaultRootElement();
        Element element2 = element.getElement(element.getElementIndex(n));
        if (element2.getEndOffset() - n <= string.length()) {
            this.replaceSelection(string);
            return;
        }
        try {
            document.remove(n, string.length());
            document.insertString(n, string, null);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public SyntaxTextArea() {
        SyntaxTextArea syntaxTextArea = this;
        if (syntaxTextArea == null) {
            throw null;
        }
        this.setCaret(syntaxTextArea.new SyntaxCaret());
        this.setBorder(null);
        this.setCursor(Cursor.getPredefinedCursor(2));
        this.lineHighlightColor = new Color(0xE0E0E0);
        this.bracketHighlightColor = new Color(65280);
        this.lineSegment = new Segment();
        SyntaxTextArea syntaxTextArea2 = this;
        if (syntaxTextArea2 == null) {
            throw null;
        }
        this.addCaretListener(syntaxTextArea2.new CaretHandler());
        if (!keymapInitialized) {
            Keymap keymap = JTextComponent.getKeymap("default");
            keymap.setDefaultAction(new DefaultKeyTypedAction());
            keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(155, 0), new InsertKeyAction());
            keymapInitialized = true;
        }
    }

    static class DefaultKeyTypedAction
    extends TextAction {
        public void actionPerformed(ActionEvent actionEvent) {
            char c;
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            String string = actionEvent.getActionCommand();
            int n = actionEvent.getModifiers();
            if (string != null && string.length() != 0 && (n & 8) == 0 && (c = string.charAt(0)) >= ' ' && c != '\u007f') {
                if (jTextComponent instanceof SyntaxTextArea) {
                    ((SyntaxTextArea)jTextComponent)._replaceSelection(string);
                } else {
                    jTextComponent.replaceSelection(string);
                }
            }
        }

        public DefaultKeyTypedAction() {
            super("syntax-default-key-typed-action");
        }
    }

    static class InsertKeyAction
    extends TextAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent instanceof SyntaxTextArea) {
                ((SyntaxTextArea)jTextComponent).toggleOverwrite();
                jTextComponent.repaint();
            }
        }

        public InsertKeyAction() {
            super("insert-key");
        }
    }

    class SyntaxCaret
    extends DefaultCaret {
        public void focusGained(FocusEvent focusEvent) {
            this.setVisible(true);
        }

        public void adjustVisibility(Rectangle rectangle) {
            SyntaxTextArea.this.doElectricScroll(rectangle);
        }

        public void damage(Rectangle rectangle) {
            if (rectangle != null) {
                this.x = rectangle.x;
                this.y = rectangle.y;
                this.height = rectangle.height + 2;
                SyntaxCaret.super.repaint();
            }
        }

        public void paint(Graphics graphics) {
            if (this.getDot() != this.getMark() || !this.isVisible()) {
                return;
            }
            try {
                int n = this.getDot();
                Rectangle rectangle = SyntaxTextArea.this.modelToView(n);
                this.width = graphics.getFontMetrics().charWidth('m');
                rectangle.width = SyntaxTextArea.this.overwrite || SyntaxTextArea.this.block ? this.width - 1 : 0;
                this.width += 2;
                if (SyntaxTextArea.this.overwrite) {
                    rectangle.y += rectangle.height - 1;
                    rectangle.height = 1;
                }
                graphics.setColor(SyntaxTextArea.this.getCaretColor());
                graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height - 1);
            }
            catch (BadLocationException badLocationException) {
                System.out.println("Caret fuckup:");
                badLocationException.printStackTrace();
            }
        }

        SyntaxCaret() {
        }
    }

    class SyntaxSafeScroller
    implements Runnable {
        public Rectangle rect;

        public void run() {
            int n;
            int n2 = ((Component)SyntaxTextArea.this).getFontMetrics(SyntaxTextArea.this.getFont()).getHeight();
            int n3 = Math.max(0, this.rect.y - n2 * SyntaxTextArea.this.electricLines);
            if (n3 + (n = n2 * SyntaxTextArea.this.electricLines * 2) + this.rect.height <= SyntaxTextArea.this.getHeight()) {
                this.rect.y = n3;
                this.rect.height += n;
            }
            SyntaxTextArea.this.scrollRectToVisible(this.rect);
        }

        public SyntaxSafeScroller(Rectangle rectangle) {
            this.rect = rectangle;
        }
    }

    class CurrentLineHighlighter
    implements Highlighter.HighlightPainter {
        public void paint(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent) {
            if (SyntaxTextArea.this.lineHighlightTag == null || SyntaxTextArea.this.getSelectionStart() != SyntaxTextArea.this.getSelectionEnd()) {
                return;
            }
            FontMetrics fontMetrics = graphics.getFontMetrics();
            Document document = SyntaxTextArea.this.getDocument();
            int n3 = document.getDefaultRootElement().getElementIndex(n);
            Rectangle rectangle = (Rectangle)shape;
            int n4 = fontMetrics.getHeight();
            int n5 = rectangle.x;
            int n6 = rectangle.y + n4 * n3;
            graphics.setColor(SyntaxTextArea.this.lineHighlightColor);
            graphics.fillRect(n5, n6, rectangle.width, n4);
        }

        CurrentLineHighlighter() {
        }
    }

    class BracketHighlighter
    implements Highlighter.HighlightPainter {
        public void paint(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent) {
            Rectangle rectangle;
            if (SyntaxTextArea.this.getSelectionStart() != SyntaxTextArea.this.getSelectionEnd() || SyntaxTextArea.this.bracketHighlightTag == null) {
                return;
            }
            if (n == n2) {
                return;
            }
            Document document = SyntaxTextArea.this.getDocument();
            FontMetrics fontMetrics = graphics.getFontMetrics();
            try {
                rectangle = SyntaxTextArea.this.modelToView(n);
                document.getText(n, 1, SyntaxTextArea.this.lineSegment);
                rectangle.width += fontMetrics.charWidth(((SyntaxTextArea)SyntaxTextArea.this).lineSegment.array[((SyntaxTextArea)SyntaxTextArea.this).lineSegment.offset]);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
                return;
            }
            graphics.setColor(SyntaxTextArea.this.bracketHighlightColor);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }

        BracketHighlighter() {
        }
    }

    class CaretHandler
    implements CaretListener {
        public void caretUpdate(CaretEvent caretEvent) {
            SyntaxTextArea.this.updateHighlighters();
        }

        CaretHandler() {
        }
    }
}

