/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class JDBCAdapter
extends AbstractTableModel {
    Connection connection;
    Statement statement;
    ResultSet resultSet;
    String[] columnNames = new String[0];
    Vector rows = new Vector();
    ResultSetMetaData metaData;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$lang$Object;

    public JDBCAdapter(String string, String string2, String string3, String string4) {
        try {
            Class.forName(string2);
            System.out.println("Opening db connection");
            this.connection = DriverManager.getConnection(string, string3, string4);
            this.statement = this.connection.createStatement();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Cannot find the database driver classes.");
            System.err.println(classNotFoundException);
        }
        catch (SQLException sQLException) {
            System.err.println("Cannot connect to this database.");
            System.err.println(sQLException);
        }
    }

    public void executeQuery(String string) {
        if (this.connection == null || this.statement == null) {
            System.err.println("There is no database to execute the query.");
            return;
        }
        try {
            this.resultSet = this.statement.executeQuery(string);
            this.metaData = this.resultSet.getMetaData();
            int n = this.metaData.getColumnCount();
            this.columnNames = new String[n];
            int n2 = 0;
            while (n2 < n) {
                this.columnNames[n2] = this.metaData.getColumnLabel(n2 + 1);
                ++n2;
            }
            this.rows = new Vector();
            while (this.resultSet.next()) {
                Vector<Object> vector = new Vector<Object>();
                int n3 = 1;
                while (n3 <= this.getColumnCount()) {
                    vector.addElement(this.resultSet.getObject(n3));
                    ++n3;
                }
                this.rows.addElement(vector);
            }
            this.fireTableChanged(null);
        }
        catch (SQLException sQLException) {
            System.err.println(sQLException);
        }
    }

    public void close() throws SQLException {
        System.out.println("Closing db connection");
        this.resultSet.close();
        this.statement.close();
        this.connection.close();
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public String getColumnName(int n) {
        if (this.columnNames[n] != null) {
            return this.columnNames[n];
        }
        return "";
    }

    public Class getColumnClass(int n) {
        int n2;
        try {
            n2 = this.metaData.getColumnType(n + 1);
        }
        catch (SQLException sQLException) {
            return super.getColumnClass(n);
        }
        switch (n2) {
            case -1: 
            case 1: 
            case 12: {
                return class$java$lang$String == null ? (class$java$lang$String = JDBCAdapter.class$("java.lang.String")) : class$java$lang$String;
            }
            case -7: {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = JDBCAdapter.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
            case -6: 
            case 4: 
            case 5: {
                return class$java$lang$Integer == null ? (class$java$lang$Integer = JDBCAdapter.class$("java.lang.Integer")) : class$java$lang$Integer;
            }
            case -5: {
                return class$java$lang$Long == null ? (class$java$lang$Long = JDBCAdapter.class$("java.lang.Long")) : class$java$lang$Long;
            }
            case 6: 
            case 8: {
                return class$java$lang$Double == null ? (class$java$lang$Double = JDBCAdapter.class$("java.lang.Double")) : class$java$lang$Double;
            }
            case 91: {
                return class$java$sql$Date == null ? (class$java$sql$Date = JDBCAdapter.class$("java.sql.Date")) : class$java$sql$Date;
            }
        }
        return class$java$lang$Object == null ? (class$java$lang$Object = JDBCAdapter.class$("java.lang.Object")) : class$java$lang$Object;
    }

    public boolean isCellEditable(int n, int n2) {
        try {
            return this.metaData.isWritable(n2 + 1);
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public Object getValueAt(int n, int n2) {
        Vector vector = (Vector)this.rows.elementAt(n);
        return vector.elementAt(n2);
    }

    public String dbRepresentation(int n, Object object) {
        int n2;
        if (object == null) {
            return "null";
        }
        try {
            n2 = this.metaData.getColumnType(n + 1);
        }
        catch (SQLException sQLException) {
            return object.toString();
        }
        switch (n2) {
            case 4: 
            case 6: 
            case 8: {
                return object.toString();
            }
            case -7: {
                return (Boolean)object != false ? "1" : "0";
            }
            case 91: {
                return object.toString();
            }
        }
        return "\"" + object.toString() + "\"";
    }

    public void setValueAt(Object object, int n, int n2) {
        Object object2;
        try {
            object2 = this.metaData.getTableName(n2 + 1);
            if (object2 == null) {
                System.out.println("Table name returned null.");
            }
            String string = this.getColumnName(n2);
            String string2 = "update " + (String)object2 + " set " + string + " = " + this.dbRepresentation(n2, object) + " where ";
            int n3 = 0;
            while (n3 < this.getColumnCount()) {
                String string3 = this.getColumnName(n3);
                if (!string3.equals("")) {
                    if (n3 != 0) {
                        string2 = string2 + " and ";
                    }
                    string2 = string2 + string3 + " = " + this.dbRepresentation(n3, this.getValueAt(n, n3));
                }
                ++n3;
            }
            System.out.println(string2);
            System.out.println("Not sending update to database");
        }
        catch (SQLException sQLException) {
            System.err.println("Update failed");
        }
        object2 = (Vector)this.rows.elementAt(n);
        ((Vector)object2).setElementAt(object, n2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

