/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.standard;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.tools.doclets.DirectoryManager;
import com.sun.tools.doclets.DocletAbortException;
import com.sun.tools.doclets.SourcePath;
import com.sun.tools.doclets.Util;
import com.sun.tools.doclets.standard.AbstractPackageWriter;
import com.sun.tools.doclets.standard.ConfigurationStandard;
import com.sun.tools.doclets.standard.HtmlStandardWriter;
import com.sun.tools.doclets.standard.Standard;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;

public class PackageWriter
extends AbstractPackageWriter {
    protected PackageDoc prev;
    protected PackageDoc next;

    public PackageWriter(String string, String string2, PackageDoc packageDoc, PackageDoc packageDoc2, PackageDoc packageDoc3) throws IOException, DocletAbortException {
        super(string, string2, packageDoc);
        this.prev = packageDoc2;
        this.next = packageDoc3;
    }

    public static void generate(PackageDoc packageDoc, PackageDoc packageDoc2, PackageDoc packageDoc3) throws DocletAbortException {
        String string = DirectoryManager.getDirectoryPath(packageDoc);
        String string2 = "package-summary.html";
        try {
            PackageWriter packageWriter = new PackageWriter(string, string2, packageDoc, packageDoc2, packageDoc3);
            packageWriter.generatePackageFile();
            packageWriter.close();
            packageWriter.copyDocFiles(string);
        }
        catch (IOException iOException) {
            Standard.configuration();
            ConfigurationStandard.standardmessage.error("doclet.exception_encountered", iOException.toString(), string2);
            throw new DocletAbortException();
        }
    }

    protected void generateClassListing() {
        this.generateClassKindListing(this.packagedoc.interfaces(), this.getText("doclet.Interface_Summary"));
        this.generateClassKindListing(this.packagedoc.ordinaryClasses(), this.getText("doclet.Class_Summary"));
        this.generateClassKindListing(this.packagedoc.exceptions(), this.getText("doclet.Exception_Summary"));
        this.generateClassKindListing(this.packagedoc.errors(), this.getText("doclet.Error_Summary"));
    }

    protected void generateClassKindListing(ClassDoc[] classDocArray, String string) {
        if (classDocArray.length > 0) {
            Arrays.sort(classDocArray);
            this.tableIndexSummary();
            this.printFirstRow(string);
            int n = 0;
            while (n < classDocArray.length) {
                boolean bl;
                boolean bl2 = bl = classDocArray[n].tags("deprecated").length > 0;
                if (Util.isCoreClass(classDocArray[n]) && this.isGeneratedDoc(classDocArray[n])) {
                    this.trBgcolorStyle("white", "TableRowColor");
                    this.summaryRow(15);
                    this.bold();
                    this.printClassLinkForSameDir(classDocArray[n]);
                    this.boldEnd();
                    this.summaryRowEnd();
                    this.summaryRow(0);
                    if (bl) {
                        this.boldText("doclet.Deprecated");
                        this.space();
                        this.printSummaryDeprecatedComment(classDocArray[n].tags("deprecated")[0]);
                    } else {
                        this.printSummaryComment(classDocArray[n]);
                    }
                    this.summaryRowEnd();
                    this.trEnd();
                }
                ++n;
            }
            this.tableEnd();
            this.println("&nbsp;");
            this.p();
        }
    }

    protected void printFirstRow(String string) {
        this.tableHeaderStart("#CCCCFF");
        this.bold(string);
        this.tableHeaderEnd();
    }

    protected void printPackageComment() {
        if (this.packagedoc.inlineTags().length > 0) {
            this.anchor("package_description");
            this.h2(this.getText("doclet.Package_Description", this.packagedoc.name()));
            this.p();
            this.printInlineComment(this.packagedoc);
            this.p();
        }
    }

    protected void printPackageDescription() throws IOException {
        this.printPackageComment();
        this.generateTagInfo(this.packagedoc);
    }

    protected void printPackageHeader(String string) {
        this.navLinks(true);
        this.hr();
        this.h2(this.getText("doclet.Package") + " " + string);
        if (this.packagedoc.inlineTags().length > 0) {
            this.printSummaryComment(this.packagedoc);
            this.p();
            this.bold(this.getText("doclet.See"));
            this.br();
            this.printNbsps();
            this.printHyperLink("", "package_description", this.getText("doclet.Description"), true);
            this.p();
        }
    }

    protected void printPackageFooter() {
        this.hr();
        this.navLinks(false);
        this.printBottom();
    }

    protected void copyDocFiles(String string) throws DocletAbortException {
        SourcePath sourcePath = new SourcePath(Standard.configuration().sourcepath);
        String string2 = string + "/" + "doc-files";
        File file = sourcePath.getDirectory(string2);
        if (file == null) {
            return;
        }
        String string3 = HtmlStandardWriter.destdir;
        if (string3.length() > 0 && !string3.endsWith("/")) {
            string3 = string3 + "/";
        }
        String string4 = file.toString();
        String string5 = string3 + string + "/" + "doc-files";
        try {
            File file2 = new File(string4);
            File file3 = new File(string5);
            DirectoryManager.createDirectory(string5);
            String[] stringArray = file2.list();
            int n = 0;
            while (n < stringArray.length) {
                File file4 = new File(file2, stringArray[n]);
                File file5 = new File(file3, stringArray[n]);
                if (file4.isFile()) {
                    this.notice("doclet.Copying_File_0_To_Dir_1", file4.toString(), file3.toString());
                    Util.copyFile(file5, file4);
                }
                ++n;
            }
        }
        catch (SecurityException securityException) {
            throw new DocletAbortException();
        }
        catch (IOException iOException) {
            throw new DocletAbortException();
        }
    }

    protected void navLinkClassUse() {
        this.navCellStart();
        this.printHyperLink("package-use.html", "", this.getText("doclet.navClassUse"), true, "NavBarFont1");
        this.navCellEnd();
    }

    protected void navLinkPrevious() {
        if (this.prev == null) {
            this.printText("doclet.Prev_Package");
        } else {
            String string = DirectoryManager.getRelativePath(this.packagedoc.name(), this.prev.name());
            this.printHyperLink(string + "package-summary.html", "", this.getText("doclet.Prev_Package"), true);
        }
    }

    protected void navLinkNext() {
        if (this.next == null) {
            this.printText("doclet.Next_Package");
        } else {
            String string = DirectoryManager.getRelativePath(this.packagedoc.name(), this.next.name());
            this.printHyperLink(string + "package-summary.html", "", this.getText("doclet.Next_Package"), true);
        }
    }

    protected void navLinkTree() {
        this.navCellStart();
        this.printHyperLink("package-tree.html", "", this.getText("doclet.Tree"), true, "NavBarFont1");
        this.navCellEnd();
    }
}

