/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.tty;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.event.ModificationWatchpointEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.event.WatchpointEvent;
import com.sun.tools.example.debug.tty.Commands;
import com.sun.tools.example.debug.tty.Env;
import com.sun.tools.example.debug.tty.EventHandler;
import com.sun.tools.example.debug.tty.EventNotifier;
import com.sun.tools.example.debug.tty.ThreadInfo;
import com.sun.tools.example.debug.tty.VMNotConnectedException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class TTY
implements EventNotifier {
    PrintStream out;
    EventHandler handler = null;
    private List monitorCommands = new ArrayList();
    private int monitorCount = 0;
    private static final String progname = "jdb";
    private static final String version = "99/06/11";
    private String[] disconnectCmds = new String[]{"run", "catch", "ignore", "stop", "clear", "watch", "unwatch", "use", "sourcepath", "quit", "exit", "help", "?", "read", "version"};

    public void vmStartEvent(VMStartEvent vMStartEvent) {
        Thread.yield();
        this.out.print("\nVM Started: ");
    }

    public void vmDeathEvent(VMDeathEvent vMDeathEvent) {
    }

    public void vmDisconnectEvent(VMDisconnectEvent vMDisconnectEvent) {
    }

    public void threadStartEvent(ThreadStartEvent threadStartEvent) {
    }

    public void threadDeathEvent(ThreadDeathEvent threadDeathEvent) {
    }

    public void classPrepareEvent(ClassPrepareEvent classPrepareEvent) {
    }

    public void classUnloadEvent(ClassUnloadEvent classUnloadEvent) {
    }

    public void breakpointEvent(BreakpointEvent breakpointEvent) {
        Thread.yield();
        this.out.print("\nBreakpoint hit: ");
    }

    public void fieldWatchEvent(WatchpointEvent watchpointEvent) {
        Field field = watchpointEvent.field();
        ObjectReference objectReference = watchpointEvent.object();
        Thread.yield();
        this.out.print("\nField (" + field + ") ");
        if (watchpointEvent instanceof ModificationWatchpointEvent) {
            this.out.print("is ");
            this.out.print(watchpointEvent.valueCurrent());
            this.out.print(", will be ");
            this.out.print(((ModificationWatchpointEvent)watchpointEvent).valueToBe());
            this.out.print(": ");
        } else {
            this.out.print("access encountered: ");
        }
    }

    public void stepEvent(StepEvent stepEvent) {
        Thread.yield();
        this.out.print("\nStep completed: ");
    }

    public void exceptionEvent(ExceptionEvent exceptionEvent) {
        Thread.yield();
        this.out.print("\nException occurred: ");
        this.out.print(exceptionEvent.exception().referenceType().name());
        Location location = exceptionEvent.catchLocation();
        if (location == null) {
            this.out.print(" (uncaught) ");
        } else {
            this.out.print(" (to be caught at: ");
            this.out.print(Commands.locationString(location));
            this.out.print(") ");
        }
    }

    public void methodEntryEvent(MethodEntryEvent methodEntryEvent) {
        Thread.yield();
        StringBuffer stringBuffer = new StringBuffer("\nMethod Entered: ");
        stringBuffer.append(methodEntryEvent.method().declaringType().name());
        stringBuffer.append(".");
        stringBuffer.append(methodEntryEvent.method().name());
        stringBuffer.append(" ");
        this.out.print(stringBuffer.toString());
    }

    public void methodExitEvent(MethodExitEvent methodExitEvent) {
        Thread.yield();
        StringBuffer stringBuffer = new StringBuffer("\nMethod Exited: ");
        stringBuffer.append(methodExitEvent.method().declaringType().name());
        stringBuffer.append(".");
        stringBuffer.append(methodExitEvent.method().name());
        stringBuffer.append(" ");
        this.out.print(stringBuffer.toString());
    }

    public void vmInterrupted() {
        Thread.yield();
        this.printCurrentLocation();
        Iterator iterator = this.monitorCommands.iterator();
        while (iterator.hasNext()) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)iterator.next());
            stringTokenizer.nextToken();
            this.executeCommand(stringTokenizer);
        }
        this.printPrompt();
    }

    public void receivedEvent(Event event) {
    }

    private void printPrompt() {
        Env.printPrompt();
    }

    private void printCurrentLocation() {
        StackFrame stackFrame;
        ThreadInfo threadInfo = ThreadInfo.current;
        try {
            stackFrame = threadInfo.getCurrentFrame();
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            this.out.println("<location unavailable>");
            return;
        }
        if (stackFrame == null) {
            this.out.println("No frames on the current call stack");
        } else {
            Location location = stackFrame.location();
            this.out.print("thread=\"" + threadInfo.thread.name() + "\"");
            this.out.print(", ");
            this.out.println(Commands.locationString(location));
            if (location.lineNumber() != -1) {
                String string;
                try {
                    string = Env.sourceLine(location, location.lineNumber());
                }
                catch (IOException iOException) {
                    string = null;
                }
                if (string != null) {
                    this.out.println("  " + location.lineNumber() + " " + string);
                }
            }
        }
        this.out.println();
    }

    void help() {
        this.out.println("** command list **");
        this.out.println("run [class [args]]        -- start execution of application's main class");
        this.out.println();
        this.out.println("threads [threadgroup]     -- list threads");
        this.out.println("thread <thread id>        -- set default thread");
        this.out.println("suspend [thread id(s)]    -- suspend threads (default: all)");
        this.out.println("resume [thread id(s)]     -- resume threads (default: all)");
        this.out.println("where [thread id] | all   -- dump a thread's stack");
        this.out.println("wherei [thread id] | all  -- dump a thread's stack, with pc info");
        this.out.println("up [n frames]             -- move up a thread's stack");
        this.out.println("down [n frames]           -- move down a thread's stack");
        this.out.println("kill <thread> <expr>      -- kill a thread with the given exception object");
        this.out.println("interrupt <thread>        -- interrupt a thread");
        this.out.println();
        this.out.println("print <expr>              -- print value of expression");
        this.out.println("dump <expr>               -- print all object information");
        this.out.println("eval <expr>               -- evaluate expression (same as print)");
        this.out.println("set <lvalue> = <expr>     -- assign new value to field/variable/array element");
        this.out.println("locals                    -- print all local variables in current stack frame");
        this.out.println();
        this.out.println("classes                   -- list currently known classes");
        this.out.println("class <class id>          -- show details of named class");
        this.out.println("methods <class id>        -- list a class's methods");
        this.out.println("fields <class id>         -- list a class's fields");
        this.out.println();
        this.out.println("threadgroups              -- list threadgroups");
        this.out.println("threadgroup <name>        -- set current threadgroup");
        this.out.println();
        this.out.println("stop in <class id>.<method>[(argument_type,...)]");
        this.out.println("                          -- set a breakpoint in a method");
        this.out.println("stop at <class id>:<line> -- set a breakpoint at a line");
        this.out.println("clear <class id>.<method>[(argument_type,...)]");
        this.out.println("                          -- clear a breakpoint in a method");
        this.out.println("clear <class id>:<line>   -- clear a breakpoint at a line");
        this.out.println("clear                     -- list breakpoints");
        this.out.println("catch <class id>          -- break when specified exception thrown");
        this.out.println("ignore <class id>         -- cancel 'catch'  for the specified exception");
        this.out.println("watch [access|all] <class id>.<field name>");
        this.out.println("                          -- watch access/modifications to a field");
        this.out.println("unwatch [access|all] <class id>.<field name>");
        this.out.println("                          -- discontinue watching access/modifications to a field");
        this.out.println("trace methods [thread]    -- trace method entry and exit");
        this.out.println("untrace methods [thread]  -- stop tracing method entry and exit");
        this.out.println("step                      -- execute current line");
        this.out.println("step up                   -- execute until the current method returns to its caller");
        this.out.println("stepi                     -- execute current instruction");
        this.out.println("next                      -- step one line (step OVER calls)");
        this.out.println("cont                      -- continue execution from breakpoint");
        this.out.println();
        this.out.println("list [line number|method] -- print source code");
        this.out.println("use (or sourcepath) [source file path]");
        this.out.println("                          -- display or change the source path");
        this.out.println("exclude [class id ... | \"none\"]");
        this.out.println("                          -- do not report step or method events for specified classes");
        this.out.println("classpath                 -- print classpath info from target VM");
        this.out.println();
        this.out.println("monitor <command>         -- execute command each time the program stops");
        this.out.println("monitor                   -- list monitors");
        this.out.println("unmonitor <monitor#>      -- delete a monitor");
        this.out.println("read <filename>           -- read and execute a command file");
        this.out.println();
        this.out.println("lock <expr>               -- print lock info for an object");
        this.out.println("threadlocks [thread id]   -- print lock info for a thread");
        this.out.println();
        this.out.println("disablegc <expr>          -- prevent garbage collection of an object");
        this.out.println("enablegc <expr>           -- permit garbage collection of an object");
        this.out.println();
        this.out.println("!!                        -- repeat last command");
        this.out.println("<n> <command>             -- repeat command n times");
        this.out.println("help (or ?)               -- list commands");
        this.out.println("version                   -- print version information");
        this.out.println("exit (or quit)            -- exit debugger");
        this.out.println();
        this.out.println("<class id>: full class name with package qualifiers or a ");
        this.out.println("pattern with a leading or trailing wildcard ('*').");
        this.out.println("<thread id>: thread number as reported in the 'threads' command");
        this.out.println("<expr>: a Java(tm) Programming Language expression.");
        this.out.println("Most common syntax is supported.");
        this.out.println();
        this.out.println("Startup commands can be placed in either \"jdb.ini\" or \".jdbrc\"");
        this.out.println("in user.home or user.dir");
    }

    private boolean isDisconnectCmd(String string) {
        int n = 0;
        while (n < this.disconnectCmds.length) {
            if (this.disconnectCmds[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    void executeCommand(StringTokenizer stringTokenizer) {
        String string = stringTokenizer.nextToken().toLowerCase();
        Commands commands = new Commands(this.out);
        boolean bl = true;
        if (!Env.connection().isOpen() && !this.isDisconnectCmd(string)) {
            this.out.println("Command '" + string + "' is not valid until the VM is started with the 'run' command");
        } else {
            try {
                if (string.equals("print")) {
                    commands.commandPrint(stringTokenizer, false);
                    bl = false;
                } else if (string.equals("eval")) {
                    commands.commandPrint(stringTokenizer, false);
                    bl = false;
                } else if (string.equals("set")) {
                    commands.commandSet(stringTokenizer);
                    bl = false;
                } else if (string.equals("dump")) {
                    commands.commandPrint(stringTokenizer, true);
                    bl = false;
                } else if (string.equals("locals")) {
                    commands.commandLocals();
                } else if (string.equals("classes")) {
                    commands.commandClasses();
                } else if (string.equals("class")) {
                    commands.commandClass(stringTokenizer);
                } else if (string.equals("methods")) {
                    commands.commandMethods(stringTokenizer);
                } else if (string.equals("fields")) {
                    commands.commandFields(stringTokenizer);
                } else if (string.equals("threads")) {
                    commands.commandThreads(stringTokenizer);
                } else if (string.equals("thread")) {
                    commands.commandThread(stringTokenizer);
                } else if (string.equals("suspend")) {
                    commands.commandSuspend(stringTokenizer);
                } else if (string.equals("resume")) {
                    commands.commandResume(stringTokenizer);
                } else if (string.equals("cont")) {
                    commands.commandCont();
                } else if (string.equals("threadgroups")) {
                    commands.commandThreadGroups();
                } else if (string.equals("threadgroup")) {
                    commands.commandThreadGroup(stringTokenizer);
                } else if (string.equals("catch")) {
                    commands.commandCatchException(stringTokenizer);
                } else if (string.equals("ignore")) {
                    commands.commandIgnoreException(stringTokenizer);
                } else if (string.equals("step")) {
                    commands.commandStep(stringTokenizer);
                } else if (string.equals("stepi")) {
                    commands.commandStepi();
                } else if (string.equals("next")) {
                    commands.commandNext();
                } else if (string.equals("kill")) {
                    commands.commandKill(stringTokenizer);
                } else if (string.equals("interrupt")) {
                    commands.commandInterrupt(stringTokenizer);
                } else if (string.equals("trace")) {
                    commands.commandTrace(stringTokenizer);
                } else if (string.equals("untrace")) {
                    commands.commandUntrace(stringTokenizer);
                } else if (string.equals("where")) {
                    commands.commandWhere(stringTokenizer, false);
                } else if (string.equals("wherei")) {
                    commands.commandWhere(stringTokenizer, true);
                } else if (string.equals("up")) {
                    commands.commandUp(stringTokenizer);
                } else if (string.equals("down")) {
                    commands.commandDown(stringTokenizer);
                } else if (string.equals("load")) {
                    commands.commandLoad(stringTokenizer);
                } else if (string.equals("run")) {
                    commands.commandRun(stringTokenizer);
                    if (this.handler == null && Env.connection().isOpen()) {
                        this.handler = new EventHandler(this, false);
                    }
                } else if (string.equals("memory")) {
                    commands.commandMemory();
                } else if (string.equals("gc")) {
                    commands.commandGC();
                } else if (string.equals("stop")) {
                    commands.commandStop(stringTokenizer);
                } else if (string.equals("clear")) {
                    commands.commandClear(stringTokenizer);
                } else if (string.equals("watch")) {
                    commands.commandWatch(stringTokenizer);
                } else if (string.equals("unwatch")) {
                    commands.commandUnwatch(stringTokenizer);
                } else if (string.equals("list")) {
                    commands.commandList(stringTokenizer);
                } else if (string.equals("lines")) {
                    commands.commandLines(stringTokenizer);
                } else if (string.equals("classpath")) {
                    commands.commandClasspath(stringTokenizer);
                } else if (string.equals("use") || string.equals("sourcepath")) {
                    commands.commandUse(stringTokenizer);
                } else if (string.equals("monitor")) {
                    this.monitorCommand(stringTokenizer);
                } else if (string.equals("unmonitor")) {
                    this.unmonitorCommand(stringTokenizer);
                } else if (string.equals("lock")) {
                    commands.commandLock(stringTokenizer);
                    bl = false;
                } else if (string.equals("threadlocks")) {
                    commands.commandThreadlocks(stringTokenizer);
                } else if (string.equals("disablegc")) {
                    commands.commandDisableGC(stringTokenizer);
                    bl = false;
                } else if (string.equals("enablegc")) {
                    commands.commandEnableGC(stringTokenizer);
                    bl = false;
                } else if (string.equals("save")) {
                    commands.commandSave(stringTokenizer);
                    bl = false;
                } else if (string.equals("bytecodes")) {
                    commands.commandBytecodes(stringTokenizer);
                } else if (string.equals("exclude")) {
                    commands.commandExclude(stringTokenizer);
                } else if (string.equals("read")) {
                    this.readCommand(stringTokenizer);
                } else if (string.equals("help") || string.equals("?")) {
                    this.help();
                } else if (string.equals("version")) {
                    commands.commandVersion(progname, version, stringTokenizer);
                } else if (string.equals("quit") || string.equals("exit")) {
                    if (this.handler != null) {
                        this.handler.shutdown();
                    }
                    Env.shutdown();
                } else {
                    if (stringTokenizer.hasMoreTokens()) {
                        try {
                            int n = Integer.parseInt(string);
                            String string2 = stringTokenizer.nextToken("");
                            while (n-- > 0) {
                                this.executeCommand(new StringTokenizer(string2));
                            }
                            return;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    Env.errorln("Unrecognized command. Try help...");
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                this.out.println("Command '" + string + "' is not supported on the target VM");
            }
            catch (VMNotConnectedException vMNotConnectedException) {
                this.out.println("Command '" + string + "' is not valid until the VM is started with the 'run' command");
            }
            catch (Exception exception) {
                this.out.println("Internal exception:");
                this.out.flush();
                exception.printStackTrace();
            }
        }
        if (bl) {
            this.printPrompt();
        }
    }

    void monitorCommand(StringTokenizer stringTokenizer) {
        if (stringTokenizer.hasMoreTokens()) {
            ++this.monitorCount;
            this.monitorCommands.add(this.monitorCount + ": " + stringTokenizer.nextToken(""));
        } else {
            Iterator iterator = this.monitorCommands.iterator();
            while (iterator.hasNext()) {
                this.out.println((String)iterator.next());
            }
        }
    }

    void unmonitorCommand(StringTokenizer stringTokenizer) {
        if (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            try {
                int n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                Env.errorln("Not a monitor number: '" + string + "'");
                return;
            }
            String string2 = string + ":";
            Iterator iterator = this.monitorCommands.iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string3);
                if (!stringTokenizer2.nextToken().equals(string2)) continue;
                this.monitorCommands.remove(string3);
                this.out.println("Unmonitoring " + string3);
                return;
            }
            Env.errorln("No monitor numbered: " + string);
        } else {
            Env.errorln("usage: unmonitor <monitor#>");
        }
    }

    void readCommand(StringTokenizer stringTokenizer) {
        if (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (!this.readCommandFile(string)) {
                Env.errorln("Could not open: " + string);
            }
        } else {
            Env.errorln("usage: read <command-filename>");
        }
    }

    /*
     * Unable to fully structure code
     */
    boolean readCommandFile(String var1_1) {
        block13: {
            var2_2 = new File(var1_1);
            var3_3 = null;
            try {
                block12: {
                    if (!var2_2.canRead()) break block12;
                    Env.out.println("*** Reading commands from " + var2_2.getCanonicalPath());
                    var3_3 = new BufferedReader(new FileReader(var2_2));
                    while ((var4_4 = var3_3.readLine()) != null) {
                        var5_6 = new StringTokenizer(var4_4);
                        if (!var5_6.hasMoreTokens()) continue;
                        this.executeCommand(var5_6);
                    }
                }
                var7_7 = null;
                ** if (var3_3 == null) goto lbl-1000
            }
            catch (Throwable var6_13) {
                var7_9 = null;
                if (var3_3 != null) {
                    try {
                        var3_3.close();
                    }
                    catch (Exception var8_12) {
                        // empty catch block
                    }
                }
                throw var6_13;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var3_3.close();
                }
                catch (Exception var8_10) {}
            }
lbl-1000:
            // 2 sources

            {
                break block13;
                catch (IOException var4_5) {
                    var7_8 = null;
                    if (var3_3 != null) {
                        try {
                            var3_3.close();
                        }
                        catch (Exception var8_11) {}
                    }
                }
            }
        }
        return var3_3 != null;
    }

    public TTY(PrintStream printStream) throws Exception {
        System.out.println("Initializing jdb...");
        this.out = printStream;
        if (Env.connection().isOpen()) {
            this.handler = new EventHandler(this, true);
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            String string = null;
            Thread.currentThread().setPriority(5);
            if (!this.readCommandFile(System.getProperty("user.home") + File.separator + "jdb.ini")) {
                this.readCommandFile(System.getProperty("user.home") + File.separator + ".jdbrc");
            }
            if (!this.readCommandFile(System.getProperty("user.dir") + File.separator + "jdb.ini")) {
                this.readCommandFile(System.getProperty("user.dir") + File.separator + ".jdbrc");
            }
            this.printPrompt();
            while (true) {
                StringTokenizer stringTokenizer;
                String string2;
                if ((string2 = bufferedReader.readLine()) == null) {
                    printStream.println("Input stream closed.");
                    return;
                }
                if (string2.startsWith("!!") && string != null) {
                    string2 = string + string2.substring(2);
                    printStream.println(string2);
                }
                if ((stringTokenizer = new StringTokenizer(string2)).hasMoreTokens()) {
                    string = string2;
                    this.executeCommand(stringTokenizer);
                    continue;
                }
                this.printPrompt();
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            this.handler.handleDisconnectedException();
            return;
        }
    }

    private static void usage() {
        String string = File.pathSeparator;
        System.out.println("Usage: jdb <options> <class> <arguments>");
        System.out.println();
        System.out.println("where options include:");
        System.out.println("    -help             print out this message and exit");
        System.out.println("    -sourcepath <directories separated by \"" + string + "\">");
        System.out.println("                      directories in which to look for source files");
        System.out.println("    -attach <address>");
        System.out.println("                      attach to a running VM at the specified address using standard connector");
        System.out.println("    -listen <address>");
        System.out.println("                      wait for a running VM to connect at the specified address using standard connector");
        System.out.println("    -listenany");
        System.out.println("                      wait for a running VM to connect at any available address using standard connector");
        System.out.println("    -launch");
        System.out.println("                      launch VM immediately instead of waiting for 'run' command");
        System.out.println("    -connect <connector-name>:<name1>=<value1>,...");
        System.out.println("                      connect to target VM using named connector with listed argument values");
        System.out.println("    -dbgtrace [flags] print info for debugging jdb");
        System.out.println("    -thotspot         run the application in the Hotspot(tm) Performance Engine");
        System.out.println("    -tclassic         run the application in the Classic VM");
        System.out.println();
        System.out.println("options forwarded to debuggee process:");
        System.out.println("    -v -verbose[:class|gc|jni]");
        System.out.println("                      turn on verbose mode");
        System.out.println("    -D<name>=<value>  set a system property");
        System.out.println("    -classpath <directories separated by \"" + string + "\">");
        System.out.println("                      list directories in which to look for classes");
        System.out.println("    -X<option>        non-standard target VM option");
        System.out.println();
        System.out.println("<class> is the name of the class to begin debugging");
        System.out.println("<arguments> are the arguments passed to the main() method of <class>");
        System.out.println();
        System.out.println("For command help type 'help' at jdb prompt");
    }

    static void usageError(String string) {
        System.err.println(string);
        System.err.println();
        TTY.usage();
        System.exit(1);
    }

    private static Connector findConnector(String string, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Connector connector = (Connector)iterator.next();
            if (!connector.transport().name().equals(string)) continue;
            return connector;
        }
        throw new IllegalArgumentException("Invalid transport name: " + string);
    }

    private static boolean supportsSharedMemory() {
        List list = Bootstrap.virtualMachineManager().allConnectors();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Connector connector = (Connector)iterator.next();
            if (!connector.transport().name().equals("dt_shmem")) continue;
            return true;
        }
        return false;
    }

    private static String addressToSocketArgs(String string) {
        int n = string.indexOf(58);
        if (n != -1) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            return "hostname=" + string2 + ",port=" + string3;
        }
        return "port=" + string;
    }

    private static boolean hasWhitespace(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (Character.isWhitespace(string.charAt(n2))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static String addArgument(String string, String string2) {
        if (TTY.hasWhitespace(string2)) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append('\"');
            int n = 0;
            while (n < string2.length()) {
                char c = string2.charAt(n);
                if (c == '\"') {
                    stringBuffer.append('\\');
                }
                stringBuffer.append(c);
                ++n;
            }
            stringBuffer.append("\" ");
            return stringBuffer.toString();
        }
        return string + string2 + ' ';
    }

    public static void main(String[] stringArray) {
        String string = "";
        String string2 = "";
        int n = 0;
        boolean bl = false;
        String string3 = null;
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string4;
            String string5 = stringArray[n2];
            if (string5.equals("-dbgtrace")) {
                if (n2 == stringArray.length - 1 || !Character.isDigit(stringArray[n2 + 1].charAt(0))) {
                    n = 0xFFFFFF;
                } else {
                    string4 = stringArray[++n2];
                    n = Integer.decode(string4);
                }
            } else {
                String string6;
                if (string5.equals("-X")) {
                    TTY.usageError("Use 'java -X' to see the available non-standard options");
                    return;
                }
                if (string5.equals("-v") || string5.startsWith("-v:") || string5.startsWith("-verbose") || string5.startsWith("-D") || string5.startsWith("-X") || string5.equals("-noasyncgc") || string5.equals("-prof") || string5.equals("-verify") || string5.equals("-noverify") || string5.equals("-verifyremote") || string5.equals("-verbosegc") || string5.startsWith("-ms") || string5.startsWith("-mx") || string5.startsWith("-ss") || string5.startsWith("-oss")) {
                    string2 = TTY.addArgument(string2, string5);
                } else if (string5.equals("-tclassic")) {
                    string2 = "-classic " + string2;
                } else if (string5.equals("-thotspot")) {
                    string2 = "-hotspot " + string2;
                } else if (string5.equals("-sourcepath")) {
                    if (n2 == stringArray.length - 1) {
                        TTY.usageError("No sourcepath specified.");
                        return;
                    }
                    Env.setSourcePath(stringArray[++n2]);
                } else if (string5.equals("-classpath")) {
                    if (n2 == stringArray.length - 1) {
                        TTY.usageError("No classpath specified.");
                        return;
                    }
                    string2 = TTY.addArgument(string2, string5);
                    string2 = TTY.addArgument(string2, stringArray[++n2]);
                } else if (string5.equals("-attach")) {
                    if (string3 != null) {
                        TTY.usageError(string5 + " can't redefine existing connection");
                        return;
                    }
                    if (n2 == stringArray.length - 1) {
                        TTY.usageError("No attach address specified.");
                        return;
                    }
                    string4 = stringArray[++n2];
                    if (TTY.supportsSharedMemory()) {
                        string3 = "com.sun.jdi.SharedMemoryAttach:name=" + string4;
                    } else {
                        string6 = TTY.addressToSocketArgs(string4);
                        string3 = "com.sun.jdi.SocketAttach:" + string6;
                    }
                } else if (string5.equals("-listen") || string5.equals("-listenany")) {
                    if (string3 != null) {
                        TTY.usageError(string5 + " can't redefine existing connection");
                        return;
                    }
                    string4 = null;
                    if (string5.equals("-listen")) {
                        if (n2 == stringArray.length - 1) {
                            TTY.usageError("No attach address specified.");
                            return;
                        }
                        string4 = stringArray[++n2];
                    }
                    if (TTY.supportsSharedMemory()) {
                        string3 = "com.sun.jdi.SharedMemoryListen";
                        if (string4 != null) {
                            string3 = string3 + ":name=" + string4;
                        }
                    } else {
                        string6 = TTY.addressToSocketArgs(string4);
                        string3 = "com.sun.jdi.SocketListen";
                        if (string4 != null) {
                            string3 = string3 + ":port=" + string4;
                        }
                    }
                } else if (string5.equals("-launch")) {
                    bl = true;
                } else if (string5.equals("-connect")) {
                    if (string3 != null) {
                        TTY.usageError(string5 + " can't redefine existing connection");
                        return;
                    }
                    if (n2 == stringArray.length - 1) {
                        TTY.usageError("No connect specification.");
                        return;
                    }
                    string3 = stringArray[++n2];
                } else if (string5.equals("-help")) {
                    TTY.usage();
                    System.exit(0);
                } else {
                    if (!string5.equals("-version")) {
                        if (string5.startsWith("-")) {
                            TTY.usageError("invalid option: " + string5);
                            return;
                        }
                        string = TTY.addArgument("", string5);
                        ++n2;
                        while (n2 < stringArray.length) {
                            string = TTY.addArgument(string, stringArray[n2]);
                            ++n2;
                        }
                        break;
                    }
                    System.out.println("jdb version 99/06/11");
                    System.exit(0);
                }
            }
            ++n2;
        }
        if (string3 == null) {
            string3 = "com.sun.jdi.CommandLineLaunch:";
        }
        string = string.trim();
        string2 = string2.trim();
        if (string.length() > 0) {
            if (!string3.startsWith("com.sun.jdi.CommandLineLaunch:")) {
                TTY.usageError("Cannot specify command line with connector: " + string3);
                return;
            }
            string3 = string3 + "main=" + string + ",";
        }
        if (string2.length() > 0) {
            if (!string3.startsWith("com.sun.jdi.CommandLineLaunch:")) {
                TTY.usageError("Cannot specify target VM arguments with connector: " + string3);
                return;
            }
            string3 = string3 + "options=" + string2 + ",";
        }
        try {
            Env.out = System.out;
            Env.init(string3, bl, n);
            new TTY(Env.out);
        }
        catch (Exception exception) {
            System.out.print("Internal exception:  ");
            System.out.flush();
            exception.printStackTrace();
        }
    }
}

