/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javadoc;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Type;

class ArrayType
implements Type {
    private final int dimension;
    private final Type type;

    ArrayType(Type type, int n) {
        this.type = type;
        this.dimension = n;
    }

    public String dimension() {
        switch (this.dimension) {
            case 0: {
                return "";
            }
            case 1: {
                return "[]";
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.dimension) {
            stringBuffer.append("[]");
            ++n;
        }
        return stringBuffer.toString();
    }

    public String typeName() {
        return this.type.typeName();
    }

    public String qualifiedTypeName() {
        return this.type.qualifiedTypeName();
    }

    public ClassDoc asClassDoc() {
        return this.type.asClassDoc();
    }

    public int hashCode() {
        return this.type.hashCode() + this.dimension;
    }

    public boolean equals(Object object) {
        if (object instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)object;
            return this.dimension == arrayType.dimension && this.type.equals(arrayType.type);
        }
        return false;
    }

    public String toString() {
        return this.type.toString() + this.dimension();
    }
}

