/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.agent;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import sun.tools.agent.Agent;
import sun.tools.agent.CachedMethod;

class Breakpoint {
    CachedMethod method;
    int bci;
    int type;
    Thread thread;
    static final int DUMMY = 0;
    static final int NORMAL = 1;
    static final int ONESHOT = 2;
    static final int CONDITIONAL = 3;
    static final int SCATTERSHOT = 4;
    private static Hashtable the_bkptHash = new Hashtable();

    private Breakpoint(CachedMethod cachedMethod, int n, int n2) {
        this.method = cachedMethod;
        this.bci = n;
        this.type = n2;
        this.thread = null;
    }

    public int hashCode() {
        return (int)(this.method.methodID + (long)this.bci);
    }

    public boolean equals(Object object) {
        if (object instanceof Breakpoint) {
            Breakpoint breakpoint = (Breakpoint)object;
            return breakpoint.method == this.method && breakpoint.bci == this.bci;
        }
        return false;
    }

    void setThread(Thread thread) {
        this.thread = thread;
    }

    Class getRealClass() {
        return this.method.getRealClass();
    }

    CachedMethod getMethod() {
        return this.method;
    }

    public String toString() {
        String string = "bkpt(dummy)";
        switch (this.type) {
            case 1: {
                string = "bkpt";
                break;
            }
            case 2: {
                string = "bkpt(oneshot)";
            }
        }
        return string + ":" + this.method.getName() + "(" + this.bci + ")";
    }

    private static native void setBreakpoint(Class var0, long var1, int var3);

    private static native void clrBreakpoint(Class var0, long var1, int var3);

    static boolean exists(CachedMethod cachedMethod, int n) {
        Breakpoint breakpoint = new Breakpoint(cachedMethod, n, 0);
        return the_bkptHash.containsKey(breakpoint);
    }

    static Breakpoint get(CachedMethod cachedMethod, int n) {
        Breakpoint breakpoint = new Breakpoint(cachedMethod, n, 0);
        return (Breakpoint)the_bkptHash.get(breakpoint);
    }

    static Enumeration allBreakpoints() {
        return the_bkptHash.elements();
    }

    static void clearAllBreakpoints() {
        Enumeration enumeration = Breakpoint.allBreakpoints();
        while (enumeration.hasMoreElements()) {
            Breakpoint breakpoint = (Breakpoint)enumeration.nextElement();
            try {
                Breakpoint.deleteBreakpoint(breakpoint);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static synchronized void internalAddBreakpoint(Breakpoint breakpoint) throws IOException {
        if ((Breakpoint)the_bkptHash.get(breakpoint) == null) {
            Agent.message("Adding breakpoint " + breakpoint);
            try {
                Breakpoint.setBreakpoint(breakpoint.method.getRealClass(), breakpoint.method.methodID, breakpoint.bci);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IOException("Invalid breakpoint: " + breakpoint + " - " + illegalArgumentException.getMessage());
            }
            the_bkptHash.put(breakpoint, breakpoint);
        } else {
            Agent.message("Breakpoint already exists " + breakpoint);
        }
    }

    static Breakpoint addBreakpoint(CachedMethod cachedMethod, int n, int n2) throws IOException {
        Breakpoint breakpoint = new Breakpoint(cachedMethod, n, n2);
        Breakpoint.internalAddBreakpoint(breakpoint);
        return breakpoint;
    }

    static synchronized void deleteBreakpoint(Breakpoint breakpoint) throws IOException {
        the_bkptHash.remove(breakpoint);
        try {
            Breakpoint.clrBreakpoint(breakpoint.method.getRealClass(), breakpoint.method.methodID, breakpoint.bci);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException("Invalid breakpoint: " + breakpoint + " - " + illegalArgumentException.getMessage());
        }
    }

    static synchronized void deleteBreakpoint(CachedMethod cachedMethod, int n) throws IOException {
        Breakpoint breakpoint = new Breakpoint(cachedMethod, n, 0);
        if ((breakpoint = (Breakpoint)the_bkptHash.get(breakpoint)) == null) {
            return;
        }
        Breakpoint.deleteBreakpoint(breakpoint);
    }

    static synchronized Breakpoint[] listBreakpoints() {
        Breakpoint[] breakpointArray = new Breakpoint[the_bkptHash.size()];
        Enumeration enumeration = the_bkptHash.elements();
        int n = 0;
        while (n < breakpointArray.length) {
            try {
                breakpointArray[n] = (Breakpoint)enumeration.nextElement();
            }
            catch (NoSuchElementException noSuchElementException) {
                Agent.error("Internal error" + Agent.exceptionStackTrace(noSuchElementException));
                return null;
            }
            ++n;
        }
        return breakpointArray;
    }
}

