/*
 * Decompiled with CFR 0.152.
 */
package bluej;

import bluej.BluejTheme;
import bluej.Main;
import bluej.utility.Debug;
import bluej.utility.DefaultProperties;
import bluej.utility.Utility;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.border.Border;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class Config {
    public static final String nl = System.getProperty("line.separator");
    private static DefaultProperties bluej_props;
    private static DefaultProperties lang_props;
    public static DefaultProperties moe_props;
    private static String bluej_conf_dirname;
    private static File bluej_lib_dir;
    private static File user_conf_dir;
    public static String compilertype;
    public static String language;
    public static Rectangle screenBounds;
    public static Image frameImage;
    public static final int splitPaneDividerWidth = 3;
    public static final int generalSpacingWidth = 5;
    public static final Border generalBorder;
    public static final Border generalBorderWithStatusBar;
    public static final Border dialogBorder;
    public static final int commandButtonSpacing = 5;
    public static final int commandButtonPadding = 12;
    public static final int componentSpacingSmall = 5;
    public static final int componentSpacingLarge = 11;
    public static final int dialogCommandButtonsVertical = 17;
    private static boolean initialised;

    public static void initialise(File file) {
        boolean bl;
        if (initialised) {
            return;
        }
        initialised = true;
        screenBounds = Config.calculateScreenBounds();
        bluej_lib_dir = file;
        bluej_props = Config.loadDefs("bluej.defs", true);
        String string = bluej_props.getProperty("bluej.userHome", "");
        File file2 = string.length() == 0 ? FileSystemView.getFileSystemView().getHomeDirectory() : new File(string);
        user_conf_dir = new File(file2, bluej_conf_dirname);
        Config.checkUserDir(user_conf_dir);
        Config.loadProperties("bluej", bluej_props);
        language = bluej_props.getProperty("bluej.language", "english");
        lang_props = Config.loadDefs(language + File.separator + "labels", false);
        moe_props = Config.loadDefs("moe.defs", false);
        ImageIcon imageIcon = Config.getImageAsIcon("image.icon");
        if (imageIcon != null) {
            frameImage = imageIcon.getImage();
        }
        Config.checkDebug(user_conf_dir);
        compilertype = Config.getPropString("bluej.compiler.type");
        if (compilertype.equals("internal")) {
            compilertype = "javac";
        }
        if (bl = Boolean.valueOf(Config.getPropString("bluej.useTheme", "false")).booleanValue()) {
            MetalLookAndFeel.setCurrentTheme(new BluejTheme());
        }
    }

    private static Rectangle calculateScreenBounds() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        return new Rectangle(dimension);
    }

    private static void checkUserDir(File file) {
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    private static void checkDebug(File file) {
        if (!"on".equals(bluej_props.getProperty("debug"))) {
            File file2 = new File(file, bluej_props.getProperty("bluej.debugLog"));
            try {
                PrintStream printStream = new PrintStream(new FileOutputStream(file2));
                System.setOut(printStream);
                Debug.message("BlueJ version " + Main.BLUEJ_VERSION);
            }
            catch (IOException iOException) {
                Debug.reportError("Warning: Unable to create debug log file.");
            }
        }
    }

    public static void handleExit() {
        Config.saveProperties("bluej", bluej_props);
    }

    private static DefaultProperties loadDefs(String string, boolean bl) {
        File file = new File(bluej_lib_dir, string);
        DefaultProperties defaultProperties = new DefaultProperties();
        try {
            defaultProperties.load(new FileInputStream(file));
        }
        catch (Exception exception) {
            Debug.reportError("Unable to load definitions file: " + file);
        }
        if (bl) {
            return new DefaultProperties(defaultProperties);
        }
        return defaultProperties;
    }

    private static void loadProperties(String string, DefaultProperties defaultProperties) {
        File file = new File(user_conf_dir, string + ".properties");
        try {
            defaultProperties.load(new FileInputStream(file));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void saveProperties(String string, DefaultProperties defaultProperties) {
        File file = new File(user_conf_dir, string + ".properties");
        try {
            defaultProperties.store(new FileOutputStream(file), Config.getString("properties.heading"));
        }
        catch (Exception exception) {
            Debug.reportError("Warning: could not save properties file " + file);
        }
    }

    public static DefaultProperties getMoeHelp() {
        return Config.loadDefs(language + File.separator + "moe.help", false);
    }

    public static String getString(String string) {
        return Config.getString(string, string);
    }

    public static String getString(String string, String string2) {
        try {
            return lang_props.getProperty(string, string2);
        }
        catch (Exception exception) {
            Debug.reportError("Could not get string for " + string);
            exception.printStackTrace(System.err);
            return string;
        }
    }

    public static String getPropString(String string) {
        return Config.getPropString(string, string);
    }

    public static String getSystemPropString(String string) {
        String string2 = System.getProperty("os.name");
        String string3 = string2 != null && string2.startsWith("Windows 9") ? "win9x" : (string2 != null && string2.startsWith("Windows") ? "win" : (string2 != null && string2.startsWith("Linux") ? "linux" : (string2 != null && string2.startsWith("SunOS") ? "solaris" : (string2 != null && string2.startsWith("Mac") ? "macos" : ""))));
        String string4 = bluej_props.getProperty(string3 + string);
        if (string4 == null) {
            string4 = bluej_props.getProperty(string, "");
        }
        return string4;
    }

    public static String getPropString(String string, String string2) {
        return bluej_props.getProperty(string, string2);
    }

    public static String getDefaultPropString(String string, String string2) {
        try {
            return bluej_props.getDefaultProperty(string, string2);
        }
        catch (Exception exception) {
            Debug.reportError("Could not get string for " + string);
            return string2;
        }
    }

    public static int getPropInteger(String string, int n) {
        int n2;
        try {
            n2 = Integer.parseInt(bluej_props.getProperty(string, String.valueOf(n)));
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
        return n2;
    }

    public static int getDefaultPropInteger(String string, int n) {
        int n2;
        try {
            n2 = Integer.parseInt(bluej_props.getDefaultProperty(string, String.valueOf(n)));
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
        return n2;
    }

    public static String removeProperty(String string) {
        return (String)((Hashtable)bluej_props).remove(string);
    }

    private static File getImageFile(String string) {
        String string2 = bluej_props.getProperty(string);
        if (string2 != null) {
            return new File(bluej_lib_dir, "images" + File.separator + string2);
        }
        return null;
    }

    public static ImageIcon getImageAsIcon(String string) {
        try {
            URL uRL = Config.getImageFile(string).toURL();
            return new ImageIcon(uRL);
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    public static File getTemplateDir() {
        return Config.getLanguageFile("templates");
    }

    public static File getTemplateFile(String string) {
        return new File(Config.getTemplateDir(), string + ".tmpl");
    }

    public static File getClassTemplateDir() {
        String string = bluej_props.getProperty("bluej.templatePath", "");
        if (string.length() == 0) {
            return Config.getLanguageFile("templates/newclass");
        }
        return new File(string);
    }

    public static File getClassTemplateFile(String string) {
        return new File(Config.getClassTemplateDir(), string + ".tmpl");
    }

    public static File getLanguageFile(String string) {
        return new File(bluej_lib_dir, language + File.separator + string);
    }

    public static File getUserConfigFile(String string) {
        return new File(user_conf_dir, string);
    }

    public static Color getItemColour(String string) {
        try {
            String string2 = bluej_props.getProperty(string, "255,0,255");
            String[] stringArray = Utility.split(string2, ",");
            if (stringArray.length >= 3) {
                int n = Integer.parseInt(stringArray[0].trim());
                int n2 = Integer.parseInt(stringArray[1].trim());
                int n3 = Integer.parseInt(stringArray[2].trim());
                return new Color(n, n2, n3);
            }
            Debug.reportError("Error reading colour [" + string + "]");
        }
        catch (Exception exception) {
            Debug.reportError("Could not get colour for " + string);
        }
        return null;
    }

    public static void putLocation(String string, Point point) {
        Config.putPropInteger(string + ".x", point.x);
        Config.putPropInteger(string + ".y", point.y);
    }

    public static Point getLocation(String string) {
        try {
            int n = Config.getPropInteger(string + ".x", 16);
            int n2 = Config.getPropInteger(string + ".y", 16);
            if (n > Config.screenBounds.width - 16) {
                n = Config.screenBounds.width - 16;
            }
            if (n2 > Config.screenBounds.height - 16) {
                n2 = Config.screenBounds.height - 16;
            }
            return new Point(n, n2);
        }
        catch (Exception exception) {
            Debug.reportError("Could not get screen location for " + string);
            return new Point(16, 16);
        }
    }

    public static void putPropInteger(String string, int n) {
        bluej_props.setProperty(string, Integer.toString(n));
    }

    public static void putPropString(String string, String string2) {
        bluej_props.setProperty(string, string2);
    }

    public static File getSystemInspectorDir() {
        return new File(bluej_lib_dir, "inspector");
    }

    static {
        bluej_conf_dirname = File.separatorChar == '/' ? ".bluej" : "bluej";
        frameImage = null;
        generalBorder = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        generalBorderWithStatusBar = BorderFactory.createEmptyBorder(10, 10, 0, 10);
        dialogBorder = BorderFactory.createEmptyBorder(12, 12, 11, 11);
        initialised = false;
    }
}

