/*
 * Decompiled with CFR 0.152.
 */
package bluej;

import bluej.Config;
import bluej.SplashWindow;
import bluej.classmgr.ClassMgrPrefPanel;
import bluej.debugger.Debugger;
import bluej.debugger.MachineLoader;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.prefmgr.MiscPrefPanel;
import bluej.prefmgr.PrefMgr;
import bluej.utility.Debug;
import java.awt.Component;
import java.io.File;
import java.util.StringTokenizer;

public class Main {
    public static int BLUEJ_VERSION_MAJOR = 1;
    public static int BLUEJ_VERSION_MINOR = 1;
    public static int BLUEJ_VERSION_RELEASE = 5;
    public static String BLUEJ_VERSION_SUFFIX = "";
    public static int BLUEJ_VERSION_NUMBER = BLUEJ_VERSION_MAJOR * 1000 + BLUEJ_VERSION_MINOR * 100 + BLUEJ_VERSION_RELEASE;
    public static String BLUEJ_VERSION = "" + BLUEJ_VERSION_MAJOR + "." + BLUEJ_VERSION_MINOR + "." + BLUEJ_VERSION_RELEASE + BLUEJ_VERSION_SUFFIX;
    public static String BLUEJ_VERSION_TITLE = "BlueJ " + BLUEJ_VERSION;
    public static String BLUEJ_JAR = "bluej.jar";
    private static int FIRST_X_LOCATION = 20;
    private static int FIRST_Y_LOCATION = 20;

    public static void main(String[] stringArray) {
        File file;
        if (stringArray.length >= 1 && "-version".equals(stringArray[0])) {
            System.out.println("BlueJ version " + BLUEJ_VERSION + " (Java version " + System.getProperty("java.version") + ")");
            System.out.println("--");
            System.out.println("virtual machine: " + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version") + " (" + System.getProperty("java.vm.vendor") + ")");
            System.out.println("running on: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " (" + System.getProperty("os.arch") + ")");
            System.exit(-1);
        }
        if ((file = Main.findBlueJLib()) == null) {
            Debug.reportError("Cannot find lib directory");
            Debug.reportError("A file named " + BLUEJ_JAR + " should be in the classpath!");
            System.exit(-1);
        }
        SplashWindow splashWindow = new SplashWindow(file);
        Config.initialise(file);
        PrefMgr.initialise();
        MiscPrefPanel.register();
        ClassMgrPrefPanel.register();
        MachineLoader machineLoader = new MachineLoader();
        machineLoader.setPriority(Thread.currentThread().getPriority() - 1);
        machineLoader.start();
        Main.processArgs(stringArray);
        splashWindow.remove();
    }

    private static void processArgs(String[] stringArray) {
        boolean bl = false;
        if (stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                Project project = Project.openProject(stringArray[n]);
                if (project != null) {
                    bl = true;
                    Package package_ = project.getPackage(project.getInitialPackageName());
                    PkgMgrFrame pkgMgrFrame = PkgMgrFrame.createFrame(package_);
                    ((Component)pkgMgrFrame).setLocation(n * 30 + FIRST_X_LOCATION, n * 30 + FIRST_Y_LOCATION);
                    pkgMgrFrame.show();
                }
                ++n;
            }
        }
        if (stringArray.length == 0 || !bl) {
            PkgMgrFrame pkgMgrFrame = PkgMgrFrame.createFrame();
            ((Component)pkgMgrFrame).setLocation(FIRST_X_LOCATION, FIRST_Y_LOCATION);
            pkgMgrFrame.show();
        }
    }

    private static File findBlueJLib() {
        Object object;
        String string = null;
        String string2 = System.getProperty("java.class.path");
        StringTokenizer stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            if (!((String)object).endsWith(BLUEJ_JAR)) continue;
            string = ((String)object).substring(0, ((String)object).length() - BLUEJ_JAR.length());
            break;
        }
        if (string != null && ((File)(object = new File(string))).isDirectory()) {
            return object;
        }
        return null;
    }

    public static void exit() {
        if (PkgMgrFrame.frameCount() > 0) {
            Debug.reportError("Frame count was not zero when exiting. Work may not have been saved");
        }
        Config.handleExit();
        Debugger.handleExit();
        System.exit(0);
    }
}

