/*
 * Decompiled with CFR 0.152.
 */
package bluej.browser;

import bluej.Config;
import bluej.browser.AttributeChooser;
import bluej.browser.AttributeChooserRenderer;
import bluej.classmgr.ClassMgr;
import bluej.utility.Utility;
import bluej.views.ConstructorView;
import bluej.views.FieldView;
import bluej.views.MemberView;
import bluej.views.MethodView;
import bluej.views.View;
import java.util.Enumeration;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

class AttributeThread
extends Thread {
    AttributeChooser parent;
    String className;

    public void run() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        JTree jTree = new JTree(defaultMutableTreeNode);
        jTree.getSelectionModel().setSelectionMode(1);
        jTree.setCellRenderer(new AttributeChooserRenderer());
        try {
            Class clazz = ClassMgr.loadBlueJClass(this.className);
            if (clazz == null) {
                defaultMutableTreeNode.setUserObject(this.getCantLoadMessage(this.className));
            } else {
                View view = View.getView(clazz);
                defaultMutableTreeNode.setUserObject((view.isInterface() ? "Interface " : "Class ") + this.className);
                this.addAttributes(defaultMutableTreeNode, view);
                Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
                while (enumeration.hasMoreElements()) {
                    jTree.expandPath(new TreePath(((DefaultMutableTreeNode)enumeration.nextElement()).getPath()));
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            defaultMutableTreeNode.setUserObject(this.getCantLoadMessage(this.className));
        }
        catch (ClassFormatError classFormatError) {
            defaultMutableTreeNode.setUserObject(this.getCantLoadMessage(this.className));
        }
        this.parent.addAttributeWindow(new JScrollPane(jTree));
    }

    private String getCantLoadMessage(String string) {
        return Utility.mergeStrings(Config.getString("browser.missingclass.text"), string);
    }

    private boolean isMemberDeclaredInThisClass(MemberView memberView) {
        return memberView.getDeclaringView().getQualifiedName().equals(this.className);
    }

    public void addAttributes(DefaultMutableTreeNode defaultMutableTreeNode, View view) {
        Object var3_3 = null;
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Constructors");
        Object object = view.getConstructors();
        if (((ConstructorView[])object).length > 0) {
            int n = 0;
            while (n < ((ConstructorView[])object).length) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(object[n]));
                ++n;
            }
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        object = new DefaultMutableTreeNode("Fields");
        Object object2 = view.getAllFields();
        int n = 0;
        while (n < ((FieldView[])object2).length) {
            if (this.isMemberDeclaredInThisClass(object2[n])) {
                ((DefaultMutableTreeNode)object).add(new DefaultMutableTreeNode(object2[n]));
            }
            ++n;
        }
        if (((DefaultMutableTreeNode)object).getChildCount() > 0) {
            defaultMutableTreeNode.add((MutableTreeNode)object);
        }
        object2 = new DefaultMutableTreeNode("Methods");
        MethodView[] methodViewArray = view.getAllMethods();
        int n2 = 0;
        while (n2 < methodViewArray.length) {
            if (this.isMemberDeclaredInThisClass(methodViewArray[n2])) {
                ((DefaultMutableTreeNode)object2).add(new DefaultMutableTreeNode(methodViewArray[n2]));
            }
            ++n2;
        }
        if (((DefaultMutableTreeNode)object2).getChildCount() > 0) {
            defaultMutableTreeNode.add((MutableTreeNode)object2);
        }
    }

    public AttributeThread(AttributeChooser attributeChooser, String string) {
        this.parent = attributeChooser;
        this.className = string;
    }
}

