/*
 * Decompiled with CFR 0.152.
 */
package bluej.browser;

import bluej.Config;
import bluej.browser.AttributeChooser;
import bluej.browser.ClassChooser;
import bluej.browser.CodeViewer;
import bluej.browser.LibraryChooser;
import bluej.browser.LibraryChooserEvent;
import bluej.browser.LibraryChooserListener;
import bluej.browser.LibraryChooserNode;
import bluej.pkgmgr.Package;
import bluej.utility.DialogManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;

public class LibraryBrowser
extends JFrame
implements ActionListener {
    private static final Dimension CHOOSERPANELSIZE = new Dimension(200, 250);
    private static final Dimension classPanelSize = new Dimension(700, 450);
    private static LibraryBrowser frame = null;
    private static final char INNERCLASSINDICATOR = '$';
    private static final String JAVASOURCEEXTENSION = ".java";
    private static final int INNERCLASSDIALOG = 0;
    private static final int NOSOURCEFORCLASSDIALOG = 1;
    private LibraryChooser libraryChooser = null;
    private ClassChooser classChooser = null;
    private AttributeChooser attributeChooser = null;
    private CodeViewer codeViewer = null;
    private JMenuItem closeMI = null;
    private JMenuItem refreshMI = null;
    private JMenuItem addLibMI = null;
    private JMenuItem findMI = null;
    private JMenuItem aboutMI = null;
    private JMenuItem topicsMI = null;
    private JMenuItem contentsMI = null;
    private JMenuItem indexMI = null;
    private JMenuItem propMI = null;
    private JMenuItem editPackageMI = null;
    private JMenuBar menuBar = null;
    private String currentPackageName = null;
    private String currentPackageDir = null;
    private Package currentPackage = null;
    private boolean[] showDialog = new boolean[]{true, true};

    private void setWaitCursor(boolean bl) {
        this.getGlassPane().setVisible(bl);
    }

    private void libraryChooserNodeClicked(LibraryChooserNode libraryChooserNode) {
        String string = this.libraryChooser.pathToPackageName(new TreePath(libraryChooserNode.getPath()));
        String[] stringArray = this.libraryChooser.findClassesOfPackage(libraryChooserNode);
        String[] stringArray2 = this.libraryChooser.findNestedPackagesOfPackage(libraryChooserNode);
        this.classChooser.openPackage(string, stringArray, stringArray2);
    }

    public void close() {
        if (this.libraryChooser != null && frame != null) {
            ((Component)this).setVisible(false);
            frame = null;
        }
        this.dispose();
    }

    private void setupUI() {
        this.setupMenus();
        JPanel jPanel = new JPanel();
        JSplitPane jSplitPane = new JSplitPane(1);
        jSplitPane.setLeftComponent(this.libraryChooser);
        jSplitPane.setDividerSize(3);
        jSplitPane.setRightComponent(this.classChooser);
        jSplitPane.setOneTouchExpandable(false);
        jSplitPane.setDividerLocation(this.getWidth() / 3);
        jPanel.setBorder(Config.generalBorder);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jSplitPane, "Center");
        this.getContentPane().add(jPanel);
    }

    protected void setupMenus() {
        this.menuBar = new JMenuBar();
        JMenu jMenu = new JMenu(Config.getString("browser.menu.library"));
        this.refreshMI = new JMenuItem(Config.getString("browser.menu.library.refresh"));
        this.closeMI = new JMenuItem(Config.getString("browser.menu.library.close"));
        this.closeMI.addActionListener(this);
        jMenu.add(this.closeMI);
        this.closeMI.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        jMenu.setEnabled(false);
        this.menuBar.add(jMenu);
        this.setJMenuBar(this.menuBar);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.closeMI) {
            this.close();
        } else if (object != this.findMI && object == this.refreshMI) {
            this.libraryChooser.loadLibraries();
        }
    }

    public void usePackage(Package package_, String string, boolean bl) {
    }

    public void openPackage(String[] stringArray) {
    }

    public void openPackage(String string) {
    }

    public void openClass(String string) {
        this.attributeChooser.openClass(string);
    }

    static /* synthetic */ void access$0(LibraryBrowser libraryBrowser, boolean bl) {
        libraryBrowser.setWaitCursor(bl);
    }

    static /* synthetic */ void access$1(LibraryBrowser libraryBrowser, LibraryChooserNode libraryChooserNode) {
        libraryBrowser.libraryChooserNodeClicked(libraryChooserNode);
    }

    public LibraryBrowser() {
        if (frame != null) {
            DialogManager.showMessage(this, "one-browser-only");
            return;
        }
        ((Frame)this).setIconImage(Config.frameImage);
        ((Component)this).setSize(new Dimension(780, 580));
        this.setWaitCursor(true);
        this.classChooser = new ClassChooser();
        this.libraryChooser = new LibraryChooser();
        LibraryBrowser libraryBrowser = this;
        if (libraryBrowser == null) {
            throw null;
        }
        this.libraryChooser.addLibraryChooserListener(new LibraryChooserListener(libraryBrowser){
            private final /* synthetic */ LibraryBrowser this$0;

            public void nodeEvent(LibraryChooserEvent libraryChooserEvent) {
                switch (libraryChooserEvent.getID()) {
                    case 1: {
                        LibraryBrowser.access$0(this.this$0, false);
                        break;
                    }
                    case 2: {
                        LibraryBrowser.access$1(this.this$0, libraryChooserEvent.getNode());
                        break;
                    }
                }
            }
            {
                this.this$0 = libraryBrowser;
                this.constructor$0(libraryBrowser);
            }

            private final void constructor$0(LibraryBrowser libraryBrowser) {
            }
        });
        this.attributeChooser = new AttributeChooser();
        this.codeViewer = new CodeViewer();
        frame = this;
        this.setTitle(Config.getString("browser.title"));
        this.setupUI();
        this.show();
        LibraryBrowser libraryBrowser2 = this;
        if (libraryBrowser2 == null) {
            throw null;
        }
        this.addWindowListener(new WindowAdapter(libraryBrowser2){
            private final /* synthetic */ LibraryBrowser this$0;

            public void windowClosing(WindowEvent windowEvent) {
                this.this$0.close();
            }
            {
                this.this$0 = libraryBrowser;
                this.constructor$0(libraryBrowser);
            }

            private final void constructor$0(LibraryBrowser libraryBrowser) {
            }
        });
    }
}

