/*
 * Decompiled with CFR 0.152.
 */
package bluej.browser;

import bluej.Config;
import bluej.browser.ClassPathEntryNode;
import bluej.browser.LibraryChooserEvent;
import bluej.browser.LibraryChooserListener;
import bluej.browser.LibraryChooserNode;
import bluej.browser.PackageNode;
import bluej.classmgr.ClassMgr;
import bluej.classmgr.ClassPathEntry;
import bluej.utility.DialogManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class LibraryChooser
extends JPanel
implements Runnable {
    private LibraryChooserNode root = null;
    private JTree tree = null;
    private DefaultTreeModel treeModel = null;
    private static /* synthetic */ Class class$Lbluej$browser$LibraryChooserListener;

    public void addLibraryChooserListener(LibraryChooserListener libraryChooserListener) {
        this.listenerList.add(class$Lbluej$browser$LibraryChooserListener != null ? class$Lbluej$browser$LibraryChooserListener : (class$Lbluej$browser$LibraryChooserListener = LibraryChooser.class$("bluej.browser.LibraryChooserListener")), libraryChooserListener);
    }

    public void removeLibraryChooserListener(LibraryChooserListener libraryChooserListener) {
        this.listenerList.remove(class$Lbluej$browser$LibraryChooserListener != null ? class$Lbluej$browser$LibraryChooserListener : (class$Lbluej$browser$LibraryChooserListener = LibraryChooser.class$("bluej.browser.LibraryChooserListener")), libraryChooserListener);
    }

    protected void fireNodeEvent(LibraryChooserNode libraryChooserNode) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$Lbluej$browser$LibraryChooserListener != null ? class$Lbluej$browser$LibraryChooserListener : LibraryChooser.class$("bluej.browser.LibraryChooserListener"))) {
                ((LibraryChooserListener)objectArray[n + 1]).nodeEvent(new LibraryChooserEvent(this, 2, libraryChooserNode));
            }
            n -= 2;
        }
    }

    protected void fireFinishedEvent() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$Lbluej$browser$LibraryChooserListener != null ? class$Lbluej$browser$LibraryChooserListener : LibraryChooser.class$("bluej.browser.LibraryChooserListener"))) {
                ((LibraryChooserListener)objectArray[n + 1]).nodeEvent(new LibraryChooserEvent(this, 1, null));
            }
            n -= 2;
        }
    }

    public String[] findClassesOfPackage(LibraryChooserNode libraryChooserNode) {
        Object[] objectArray = libraryChooserNode.getFiles();
        int n = objectArray == null ? 0 : objectArray.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = (String)objectArray[n2];
            ++n2;
        }
        return stringArray;
    }

    public String[] findNestedPackagesOfPackage(LibraryChooserNode libraryChooserNode) {
        int n = libraryChooserNode.getChildCount();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = ((LibraryChooserNode)libraryChooserNode.getChildAt(n2)).toString();
            ++n2;
        }
        return stringArray;
    }

    public void loadLibraries() {
        if (this.tree == null) {
            this.root = new LibraryChooserNode("");
            this.tree = new JTree(this.root);
            this.treeModel = (DefaultTreeModel)this.tree.getModel();
            this.tree.setRootVisible(false);
            this.tree.setBorder(new EmptyBorder(5, 5, 5, 5));
        } else {
            Enumeration<TreeNode> enumeration = this.root.children();
            while (enumeration.hasMoreElements()) {
                this.treeModel.removeNodeFromParent((DefaultMutableTreeNode)enumeration.nextElement());
            }
            this.root.removeAllChildren();
            this.treeModel.reload();
        }
        new Thread(this).start();
    }

    public void run() {
        Object object;
        Iterator iterator = ClassMgr.getClassMgr().getAllClassPathEntries();
        while (iterator.hasNext()) {
            object = (ClassPathEntry)iterator.next();
            this.addLibraryToTree(new ClassPathEntryNode((ClassPathEntry)object));
        }
        this.tree.getSelectionModel().setSelectionMode(1);
        LibraryChooser libraryChooser = this;
        if (libraryChooser == null) {
            throw null;
        }
        this.tree.addTreeSelectionListener(new TreeSelectionListener(libraryChooser){
            private final /* synthetic */ LibraryChooser this$0;

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                LibraryChooserNode libraryChooserNode = (LibraryChooserNode)treeSelectionEvent.getPath().getLastPathComponent();
                this.this$0.fireNodeEvent(libraryChooserNode);
            }
            {
                this.this$0 = libraryChooser;
                this.constructor$0(libraryChooser);
            }

            private final void constructor$0(LibraryChooser libraryChooser) {
            }
        });
        this.tree.setEditable(false);
        object = this.root.children();
        while (object.hasMoreElements()) {
            this.tree.expandPath(new TreePath(((DefaultMutableTreeNode)object.nextElement()).getPath()));
        }
        DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
        defaultTreeCellRenderer.setLeafIcon(null);
        defaultTreeCellRenderer.setClosedIcon(null);
        defaultTreeCellRenderer.setOpenIcon(null);
        this.tree.setCellRenderer(defaultTreeCellRenderer);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        this.add((Component)jScrollPane, "Center");
        this.revalidate();
        this.fireFinishedEvent();
    }

    /*
     * Unable to fully structure code
     */
    private void pruneNodeOfEmptyDirectories(LibraryChooserNode var1_1) {
        var2_2 = true;
        if (var1_1.getChildCount() != 0) ** GOTO lbl14
        var1_1.removeFromParent();
        return;
lbl-1000:
        // 1 sources

        {
            var2_2 = false;
            var3_3 = var1_1.depthFirstEnumeration();
            var4_4 = null;
            while (var3_3.hasMoreElements()) {
                var4_4 = (LibraryChooserNode)var3_3.nextElement();
                if (!var4_4.isLeaf() || var4_4.getFiles() != null || var4_4 == this.root) continue;
                var4_4.removeFromParent();
                var2_2 = true;
            }
lbl14:
            // 2 sources

            ** while (var2_2)
        }
lbl15:
        // 1 sources

    }

    public TreePath[] findAllLibrariesMatching(String string, boolean bl, boolean bl2) {
        Object[] objectArray;
        Enumeration<TreeNode> enumeration = this.root.depthFirstEnumeration();
        Vector<TreePath> vector = new Vector<TreePath>();
        while (enumeration.hasMoreElements()) {
            objectArray = (Object[])enumeration.nextElement();
            if (!LibraryChooser.doesLibraryMatchPattern(new TreePath(objectArray.getPath()), string, bl, bl2)) continue;
            vector.addElement(new TreePath(objectArray.getPath()));
        }
        if (vector.size() == 0) {
            return null;
        }
        objectArray = new TreePath[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private static boolean doesLibraryMatchPattern(TreePath treePath, String string, boolean bl, boolean bl2) {
        if (!bl) {
            string = string.toLowerCase();
        }
        String string2 = null;
        int n = 0;
        while (n < treePath.getPathCount()) {
            string2 = ((LibraryChooserNode)treePath.getPathComponent(n)).toString();
            if (!bl) {
                string2 = string2.toLowerCase();
            }
            if (bl2 ? string2.indexOf(string) != -1 : string2.equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private LibraryChooserNode getFirstNodeContainingDir(String string) {
        Enumeration<TreeNode> enumeration = this.root.children();
        LibraryChooserNode libraryChooserNode = null;
        while (enumeration.hasMoreElements()) {
            libraryChooserNode = (LibraryChooserNode)enumeration.nextElement();
        }
        return null;
    }

    private void addLibraryToTree(ClassPathEntryNode classPathEntryNode) {
        this.treeModel.insertNodeInto(classPathEntryNode, this.root, this.root.getChildCount());
        if (classPathEntryNode.isJar()) {
            this.openArchiveLibrary(classPathEntryNode);
        } else if (classPathEntryNode.isClassRoot()) {
            this.openDirectoryLibrary(classPathEntryNode);
        }
        this.pruneNodeOfEmptyDirectories(classPathEntryNode);
    }

    private void openArchiveLibrary(ClassPathEntryNode classPathEntryNode) {
        try {
            JarFile jarFile = new JarFile(classPathEntryNode.getFile());
            Enumeration<JarEntry> enumeration = jarFile.entries();
            String string = "";
            String string2 = Config.getString("browser.librarychooser.openingarchive.status") + " " + jarFile.getName();
            while (enumeration.hasMoreElements()) {
                string = enumeration.nextElement().getName();
                if (!string.endsWith(".class") || string.indexOf(36) != -1) continue;
                this.addArchiveEntry(classPathEntryNode, string);
            }
            jarFile.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void addArchiveEntry(LibraryChooserNode libraryChooserNode, String string) {
        int n;
        if (!string.endsWith(".class")) {
            return;
        }
        int n2 = string.indexOf("/");
        if (n2 == -1) {
            int n3 = string.indexOf(".class");
            if (n3 >= 0) {
                string = string.substring(0, n3);
            }
            libraryChooserNode.addFile(string);
            return;
        }
        if (n2 == 0) {
            string = string.substring(1, string.length());
        }
        if ((n = string.indexOf("/", n2)) == -1) {
            return;
        }
        PackageNode packageNode = new PackageNode(string.substring(0, n2));
        LibraryChooserNode libraryChooserNode2 = LibraryChooser.getFirstNodeWithObject(libraryChooserNode, packageNode.getUserObject().toString());
        if (libraryChooserNode2 != null) {
            this.addArchiveEntry(libraryChooserNode2, string.substring(n2 + 1, string.length()));
        } else {
            libraryChooserNode.add(packageNode);
            this.addArchiveEntry(packageNode, string.substring(n2 + 1, string.length()));
        }
    }

    private void openDirectoryLibrary(ClassPathEntryNode classPathEntryNode) {
        this.openDirectoryLibrary(classPathEntryNode, classPathEntryNode.getFile());
    }

    private void openDirectoryLibrary(LibraryChooserNode libraryChooserNode, File file) {
        if (!file.exists() && !file.isDirectory()) {
            DialogManager.showErrorWithText((JFrame)this.getParent(), "missing-shadow", file.getName());
            return;
        }
        String[] stringArray = file.list();
        File file2 = null;
        LibraryChooserNode libraryChooserNode2 = null;
        String string = file.getPath();
        int n = 0;
        while (n < stringArray.length) {
            file2 = new File(string, stringArray[n]);
            if (file2.isFile() || file2.isDirectory()) {
                if (file2.isFile()) {
                    if (file2.getName().endsWith(".class") && file2.getName().indexOf(36) == -1) {
                        String string2 = file2.getName();
                        int n2 = string2.indexOf(".class");
                        if (n2 >= 0) {
                            string2 = string2.substring(0, n2);
                        }
                        libraryChooserNode.addFile(string2);
                    }
                } else {
                    libraryChooserNode2 = new LibraryChooserNode(stringArray[n]);
                    libraryChooserNode.add(libraryChooserNode2);
                    if (file2.isDirectory()) {
                        this.openDirectoryLibrary(libraryChooserNode2, file2);
                    }
                }
            }
            ++n;
        }
    }

    private static LibraryChooserNode getFirstNodeWithObject(LibraryChooserNode libraryChooserNode, Object object) {
        LibraryChooserNode libraryChooserNode2 = null;
        if (!libraryChooserNode.isLeaf()) {
            Enumeration<TreeNode> enumeration = libraryChooserNode.children();
            while (enumeration.hasMoreElements()) {
                libraryChooserNode2 = (LibraryChooserNode)enumeration.nextElement();
                if (!libraryChooserNode2.getUserObject().equals(object)) continue;
                return libraryChooserNode2;
            }
        }
        return null;
    }

    public String pathToPackageName(TreePath treePath) {
        Object[] objectArray = treePath.getPath();
        String string = "";
        int n = 2;
        while (n < objectArray.length) {
            string = string + ((LibraryChooserNode)objectArray[n]).toString() + ".";
            ++n;
        }
        if (!string.equals("")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public LibraryChooser() {
        this.setBackground(Color.white);
        this.setLayout(new BorderLayout());
        this.loadLibraries();
    }
}

