/*
 * Decompiled with CFR 0.152.
 */
package bluej.browser;

import bluej.Config;
import bluej.prefmgr.PrefMgr;
import bluej.utility.Utility;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

public abstract class Target
extends JComponent {
    static final int DEF_WIDTH = 100;
    static final int DEF_HEIGHT = 50;
    static final int HANDLE_SIZE = 20;
    static final int TEXT_HEIGHT = 16;
    static final int TEXT_BORDER = 8;
    static final int SHAD_SIZE = 5;
    static final Color textbg = Config.getItemColour("colour.text.bg");
    static final Color shadowCol = Config.getItemColour("colour.target.shadow");
    static final Color graphbg = Config.getItemColour("colour.graph.background");
    static final Color defaultbg = Config.getItemColour("colour.class.bg.default");
    static final Color librarybg = Config.getItemColour("colour.class.bg.imported");
    static final Color compbg = Config.getItemColour("colour.target.bg.compiling");
    static final Color colBorder = Config.getItemColour("colour.target.border");
    static final Color textfg = Config.getItemColour("colour.text.fg");
    protected String displayName;
    protected int targetWidth;
    protected boolean selected;

    public Dimension getPreferredSize() {
        return new Dimension(this.targetWidth, 50);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.targetWidth, 50);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.isPopupTrigger()) {
            this.popupMenu(mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public boolean getSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
        this.repaint();
    }

    protected Color getBackgroundColour() {
        return defaultbg;
    }

    protected Color getBorderColour() {
        return colBorder;
    }

    protected Color getTextColour() {
        return textfg;
    }

    abstract void popupMenu(int var1, int var2);

    public void paintComponent(Graphics graphics) {
        Insets insets = this.getInsets();
        int n = this.getWidth() - insets.left - insets.right;
        int n2 = this.getHeight() - insets.top - insets.bottom;
        graphics.setColor(this.getBackgroundColour());
        graphics.fillRect(insets.left, insets.top, n, n2);
        graphics.setColor(textbg);
        graphics.fillRect(insets.left + 8, insets.top + 8, n - 16, 16);
        graphics.setColor(shadowCol);
        this.drawShadow(graphics);
        graphics.setColor(this.getBorderColour());
        graphics.drawRect(insets.left + 8, insets.top + 8, n - 16, 16);
        this.drawBorders(graphics);
        graphics.setColor(this.getTextColour());
        graphics.setFont(PrefMgr.getStandardFont());
        Utility.drawCentredText(graphics, this.displayName, insets.left + 8, insets.top + 8, n - 16, 16);
    }

    void drawShadow(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        graphics.fillRect(5, n2 - 5, n - 5, 5);
        graphics.fillRect(n - 5, 5, n2 - 5, n2);
    }

    void drawBorders(Graphics graphics) {
        Insets insets = this.getInsets();
        int n = this.getWidth() - insets.left - insets.right;
        int n2 = this.getHeight() - insets.top - insets.bottom;
        int n3 = this.selected ? 4 : 1;
        Utility.drawThickRect(graphics, insets.left, insets.top, n, n2, n3);
    }

    public Target(String string) {
        this.displayName = string;
        this.selected = false;
        this.targetWidth = (int)(32.0 + PrefMgr.getStandardFont().getStringBounds(string, new FontRenderContext(new AffineTransform(), false, false)).getWidth());
        if (this.targetWidth < 100) {
            this.targetWidth = 100;
        }
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 5));
        this.enableEvents(16L);
    }
}

