/*
 * Decompiled with CFR 0.152.
 */
package bluej.classmgr;

import bluej.Config;
import bluej.classmgr.ClassPath;
import bluej.classmgr.ClassPathEntry;
import bluej.classmgr.ClassPathLoader;
import bluej.utility.Debug;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.MissingResourceException;

public class ClassMgr {
    private static final String errorloadingconfig = Config.getString("classmgr.error.loadingconfig");
    private static final String errormissingclasspath = Config.getString("classmgr.error.missingclasspath");
    private static final String errormissingbootclasspath = Config.getString("classmgr.error.missingbootclasspath");
    private static final String userlibPrefix = "bluej.userlibrary";
    private static final String syslibPrefix = "bluej.systemlibrary";
    private static ClassMgr currentClassMgr = new ClassMgr();
    private BlueJLoader classloader;
    protected ClassPath systemLibraries;
    protected ClassPath userLibraries;
    protected ClassPath bootLibraries;

    public static ClassMgr getClassMgr() {
        return currentClassMgr;
    }

    public static ClassLoader getLoader(File file) {
        return new ClassPathLoader(new ClassPath(file.getPath(), "Project " + file), ClassMgr.getBlueJLoader());
    }

    public static Class loadBlueJClass(String string) throws ClassNotFoundException {
        return ClassMgr.getBlueJLoader().loadClass(string);
    }

    public static ClassLoader getBlueJLoader() {
        return ClassMgr.getClassMgr().classloader;
    }

    public Iterator getAllClassPathEntries() {
        LinkedList linkedList = new LinkedList();
        linkedList.addAll(this.systemLibraries.getEntries());
        linkedList.addAll(this.userLibraries.getEntries());
        linkedList.addAll(this.bootLibraries.getEntries());
        return linkedList.iterator();
    }

    public String getAllClassPath() {
        ClassPath classPath = new ClassPath();
        classPath.addClassPath(this.systemLibraries);
        classPath.addClassPath(this.userLibraries);
        classPath.addClassPath(this.bootLibraries);
        return classPath.toString();
    }

    public Iterator getNonBootClassPathEntries() {
        LinkedList linkedList = new LinkedList();
        linkedList.addAll(this.systemLibraries.getEntries());
        linkedList.addAll(this.userLibraries.getEntries());
        return linkedList.iterator();
    }

    public String getNonBootClassPath() {
        ClassPath classPath = new ClassPath();
        classPath.addClassPath(this.systemLibraries);
        classPath.addClassPath(this.userLibraries);
        return classPath.toString();
    }

    private void addConfigEntries(ClassPath classPath, String string) {
        int n = 1;
        try {
            while (true) {
                String string2 = Config.getPropString(string + n + ".location", null);
                String string3 = Config.getPropString(string + n + ".description", null);
                if (string2 != null && string3 != null) {
                    classPath.addClassPath(string2, string3);
                    ++n;
                    continue;
                }
                break;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    protected void saveUserLibraries() {
        int n = 1;
        while (true) {
            String string = Config.removeProperty(userlibPrefix + n + ".location");
            String string2 = Config.removeProperty(userlibPrefix + n + ".description");
            if (string == null || string2 == null) break;
            ++n;
        }
        Iterator iterator = this.userLibraries.getEntries().iterator();
        n = 1;
        while (iterator.hasNext()) {
            ClassPathEntry classPathEntry = (ClassPathEntry)iterator.next();
            Config.putPropString(userlibPrefix + n + ".location", classPathEntry.getPath());
            Config.putPropString(userlibPrefix + n + ".description", classPathEntry.getDescription());
            ++n;
        }
    }

    private ClassMgr() {
        ClassMgr classMgr = this;
        if (classMgr == null) {
            throw null;
        }
        this.classloader = classMgr.new BlueJLoader();
        this.systemLibraries = new ClassPath();
        this.userLibraries = new ClassPath();
        this.bootLibraries = new ClassPath();
        this.addConfigEntries(this.systemLibraries, syslibPrefix);
        this.addConfigEntries(this.userLibraries, userlibPrefix);
        String string = System.getProperty("sun.boot.class.path");
        String string2 = System.getProperty("java.class.path");
        if (string == null) {
            Debug.message(errormissingbootclasspath);
        } else if (string2 == null) {
            Debug.message(errormissingclasspath);
        }
        this.bootLibraries = new ClassPath(string, Config.getString("classmgr.bootclass"));
        if (string2 != null) {
            this.bootLibraries.addClassPath(string2, Config.getString("classmgr.bluejclass"));
        }
    }

    class BlueJLoader
    extends ClassLoader {
        protected Class findClass(String string) throws ClassNotFoundException {
            byte[] byArray = this.loadClassData(string);
            if (byArray != null) {
                return this.defineClass(string, byArray, 0, byArray.length);
            }
            throw new ClassNotFoundException("BlueJLoader");
        }

        protected byte[] loadClassData(String string) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                String string2 = string.replace('.', File.separatorChar) + ".class";
                InputStream inputStream = ClassMgr.this.systemLibraries.getFile(string2);
                if (inputStream == null) {
                    inputStream = ClassMgr.this.userLibraries.getFile(string2);
                }
                if (inputStream != null) {
                    int n;
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                    while ((n = bufferedInputStream.read()) != -1) {
                        byteArrayOutputStream.write(n);
                    }
                }
            }
            catch (Exception exception) {
                Debug.reportError("cannot load class " + string + ": " + exception);
                exception.printStackTrace();
                return null;
            }
            if (byteArrayOutputStream.size() == 0) {
                return null;
            }
            return byteArrayOutputStream.toByteArray();
        }

        BlueJLoader() {
        }
    }
}

