/*
 * Decompiled with CFR 0.152.
 */
package bluej.classmgr;

import bluej.Config;
import bluej.classmgr.ClassMgr;
import bluej.classmgr.ClassMgrCellRenderer;
import bluej.classmgr.ClassPathEntry;
import bluej.classmgr.ClassPathTableModel;
import bluej.classmgr.LibraryFileFilter;
import bluej.prefmgr.PrefMgrDialog;
import bluej.prefmgr.PrefPanelListener;
import bluej.utility.DialogManager;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class ClassMgrPrefPanel
extends JPanel
implements PrefPanelListener {
    static final String prefpaneltitle = Config.getString("classmgr.prefpaneltitle");
    private JTable userLibrariesTable = null;
    private ClassPathTableModel userLibrariesModel = null;

    public static void register() {
        ClassMgrPrefPanel classMgrPrefPanel = new ClassMgrPrefPanel();
        PrefMgrDialog.add(classMgrPrefPanel, prefpaneltitle, classMgrPrefPanel);
    }

    public void beginEditing() {
    }

    public void revertEditing() {
        this.userLibrariesModel.revertEntries();
    }

    public void commitEditing() {
        this.userLibrariesModel.commitEntries();
        ClassMgr.getClassMgr().saveUserLibraries();
    }

    private void addUserLibrary() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileFilter(new LibraryFileFilter());
        jFileChooser.setFileSelectionMode(2);
        jFileChooser.setDialogTitle("Select directory or jar/zip file");
        int n = jFileChooser.showOpenDialog(this.getParent());
        if (n == 0) {
            String string = jFileChooser.getSelectedFile().getAbsolutePath();
            this.userLibrariesModel.addEntry(new ClassPathEntry(string, ""));
            DialogManager.showMessage(null, "classmgr-changes-no-effect");
        }
    }

    private void deleteUserLibrary() {
        int n = this.userLibrariesTable.getSelectedRow();
        if (n != -1) {
            this.userLibrariesModel.deleteEntry(n);
        }
    }

    static /* synthetic */ void access$0(ClassMgrPrefPanel classMgrPrefPanel) {
        classMgrPrefPanel.addUserLibrary();
    }

    static /* synthetic */ void access$1(ClassMgrPrefPanel classMgrPrefPanel) {
        classMgrPrefPanel.deleteUserLibrary();
    }

    private ClassMgrPrefPanel() {
        Vector vector = new Vector(ClassMgr.getClassMgr().bootLibraries.getEntries());
        Vector vector2 = new Vector(ClassMgr.getClassMgr().systemLibraries.getEntries());
        JLabel jLabel = new JLabel(Config.getString("classmgr.userlibraries"));
        jLabel.setAlignmentX(0.0f);
        JPanel jPanel = new JPanel();
        JScrollPane jScrollPane = new JScrollPane();
        this.userLibrariesModel = new ClassPathTableModel(ClassMgr.getClassMgr().userLibraries);
        this.userLibrariesTable = new JTable(this.userLibrariesModel);
        this.userLibrariesTable.setSelectionMode(0);
        jScrollPane.setAlignmentY(0.0f);
        jScrollPane.setViewportView(this.userLibrariesTable);
        JComponent jComponent = new JPanel();
        jComponent.setLayout(new BoxLayout(jComponent, 1));
        jComponent.setAlignmentY(0.0f);
        JComponent jComponent2 = new JButton(Config.getString("classmgr.add"));
        ClassMgrPrefPanel classMgrPrefPanel = this;
        if (classMgrPrefPanel == null) {
            throw null;
        }
        ((AbstractButton)jComponent2).addActionListener(new ActionListener(classMgrPrefPanel){
            private final /* synthetic */ ClassMgrPrefPanel this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                ClassMgrPrefPanel.access$0(this.this$0);
            }
            {
                this.this$0 = classMgrPrefPanel;
                this.constructor$0(classMgrPrefPanel);
            }

            private final void constructor$0(ClassMgrPrefPanel classMgrPrefPanel) {
            }
        });
        JComponent jComponent3 = new JButton(Config.getString("classmgr.delete"));
        ClassMgrPrefPanel classMgrPrefPanel2 = this;
        if (classMgrPrefPanel2 == null) {
            throw null;
        }
        ((AbstractButton)jComponent3).addActionListener(new ActionListener(classMgrPrefPanel2){
            private final /* synthetic */ ClassMgrPrefPanel this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                ClassMgrPrefPanel.access$1(this.this$0);
            }
            {
                this.this$0 = classMgrPrefPanel;
                this.constructor$0(classMgrPrefPanel);
            }

            private final void constructor$0(ClassMgrPrefPanel classMgrPrefPanel) {
            }
        });
        jComponent.add(jComponent2);
        jComponent.add(Box.createVerticalStrut(5));
        jComponent.add(jComponent3);
        jComponent2.setMaximumSize(new Dimension(Integer.MAX_VALUE, jComponent2.getPreferredSize().height));
        jComponent3.setMaximumSize(new Dimension(Integer.MAX_VALUE, jComponent3.getPreferredSize().height));
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setAlignmentX(0.0f);
        jPanel.add(jScrollPane);
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add(jComponent);
        jScrollPane = new JScrollPane();
        jComponent = new JList();
        ((JList)jComponent).setListData(vector2);
        ((JList)jComponent).setCellRenderer(new ClassMgrCellRenderer());
        jComponent.setEnabled(false);
        jScrollPane.setViewportView(jComponent);
        jScrollPane.setAlignmentX(0.0f);
        jComponent = new JLabel(Config.getString("classmgr.systemlibraries"));
        jComponent.setAlignmentX(0.0f);
        ((JLabel)jComponent).setLabelFor(jScrollPane);
        jComponent2 = new JScrollPane();
        jComponent3 = new JList();
        ((JList)jComponent3).setListData(vector);
        ((JList)jComponent3).setCellRenderer(new ClassMgrCellRenderer());
        jComponent3.setEnabled(false);
        ((JScrollPane)jComponent2).setViewportView(jComponent3);
        jComponent2.setAlignmentX(0.0f);
        jComponent3 = new JLabel(Config.getString("classmgr.bootlibraries"));
        jComponent3.setAlignmentX(0.0f);
        ((JLabel)jComponent3).setLabelFor(jComponent2);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(Config.generalBorder);
        this.add(jLabel);
        this.add(jPanel);
        this.add(Box.createVerticalStrut(5));
        this.add(jComponent);
        this.add(jScrollPane);
        this.add(Box.createVerticalStrut(5));
        this.add(jComponent3);
        this.add(jComponent2);
    }
}

