/*
 * Decompiled with CFR 0.152.
 */
package bluej.classmgr;

import bluej.classmgr.ClassPathEntry;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassPath {
    private ArrayList entries = new ArrayList();

    protected List getEntries() {
        return this.entries;
    }

    public void removeClassPath(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                ((AbstractCollection)this.entries).remove(string2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void removeAll() {
        this.entries.clear();
    }

    public void addClassPath(ClassPath classPath) {
        Iterator iterator = ((AbstractList)classPath.entries).iterator();
        while (iterator.hasNext()) {
            ClassPathEntry classPathEntry = (ClassPathEntry)iterator.next();
            try {
                ClassPathEntry classPathEntry2 = (ClassPathEntry)classPathEntry.clone();
                if (this.entries.contains(classPathEntry2)) continue;
                this.entries.add(classPathEntry2);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
            }
        }
    }

    public void addClassPath(String string, String string2) {
        if (string == null) {
            return;
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                String string4 = new File(string3).getName();
                ClassPathEntry classPathEntry = new ClassPathEntry(string3, string2);
                if (this.entries.contains(classPathEntry)) continue;
                this.entries.add(classPathEntry);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public URL[] getURLs() {
        Iterator iterator = ((AbstractList)this.entries).iterator();
        URL[] uRLArray = new URL[this.entries.size()];
        int n = 0;
        while (iterator.hasNext()) {
            ClassPathEntry classPathEntry = (ClassPathEntry)iterator.next();
            try {
                uRLArray[n] = classPathEntry.getURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            ++n;
        }
        return uRLArray;
    }

    public InputStream getFile(String string) throws IOException {
        Iterator iterator = ((AbstractList)this.entries).iterator();
        while (iterator.hasNext()) {
            Object object;
            ClassPathEntry classPathEntry = (ClassPathEntry)iterator.next();
            if (classPathEntry.isJar()) {
                object = this.readJar(classPathEntry.getFile(), string);
                if (object == null) continue;
                return object;
            }
            if (!classPathEntry.isClassRoot() || !((File)(object = new File(classPathEntry.getFile(), string))).exists()) continue;
            return new FileInputStream((File)object);
        }
        return null;
    }

    private InputStream readJar(File file, String string) throws IOException {
        JarEntry jarEntry;
        JarFile jarFile = new JarFile(file);
        if (File.separatorChar != '/') {
            string = string.replace(File.separatorChar, '/');
        }
        if ((jarEntry = jarFile.getJarEntry(string)) == null) {
            return null;
        }
        InputStream inputStream = jarFile.getInputStream(jarEntry);
        return inputStream;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = ((AbstractList)this.entries).iterator();
        while (iterator.hasNext()) {
            ClassPathEntry classPathEntry = (ClassPathEntry)iterator.next();
            stringBuffer.append(classPathEntry.getPath());
            stringBuffer.append(File.pathSeparatorChar);
        }
        return stringBuffer.toString();
    }

    public ClassPath() {
    }

    public ClassPath(ClassPath classPath) {
        this.addClassPath(classPath);
    }

    public ClassPath(String string, String string2) {
        this.addClassPath(string, string2);
    }
}

