/*
 * Decompiled with CFR 0.152.
 */
package bluej.classmgr;

import bluej.Config;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class ClassPathEntry
implements Cloneable {
    private File file;
    private String description;

    public String getDescription() {
        if (this.description == null) {
            return Config.getString("classmgr.error.nodescription") + " (" + this.file.getPath() + ")";
        }
        return this.description;
    }

    protected void setDescription(String string) {
        this.description = string;
    }

    public File getFile() {
        return this.file;
    }

    public String getPath() {
        return this.file.getPath();
    }

    public String getCanonicalPathNoException() {
        String string;
        try {
            string = this.file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string = Config.getString("classmgr.error.unresolvable") + " (" + this.file.getPath() + ")";
        }
        return string;
    }

    public URL getURL() throws MalformedURLException {
        return this.file.toURL();
    }

    public boolean isJar() {
        String string = this.file.getName().toLowerCase();
        return this.file.isFile() && (string.endsWith(".zip") || string.endsWith(".jar"));
    }

    public boolean isClassRoot() {
        return this.file.isDirectory();
    }

    public String toString() {
        return this.getPath();
    }

    public boolean equals(Object object) {
        return this.file.equals(((ClassPathEntry)object).file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public ClassPathEntry(String string, String string2) {
        this.file = new File(string).getAbsoluteFile();
        this.description = string2;
    }
}

