/*
 * Decompiled with CFR 0.152.
 */
package bluej.classmgr;

import bluej.Config;
import bluej.classmgr.ClassPath;
import bluej.classmgr.ClassPathEntry;
import javax.swing.table.AbstractTableModel;

public class ClassPathTableModel
extends AbstractTableModel {
    static final String locationLabel = Config.getString("classmgr.locationcolumn");
    static final String descriptionLabel = Config.getString("classmgr.descriptioncolumn");
    private ClassPath origcp;
    private ClassPath cp;

    public String getColumnName(int n) {
        if (n == 0) {
            return locationLabel;
        }
        return descriptionLabel;
    }

    public int getRowCount() {
        return this.cp.getEntries().size();
    }

    public int getColumnCount() {
        return 2;
    }

    public Object getValueAt(int n, int n2) {
        ClassPathEntry classPathEntry = (ClassPathEntry)this.cp.getEntries().get(n);
        if (n2 == 0) {
            return classPathEntry.getCanonicalPathNoException();
        }
        return classPathEntry.getDescription();
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 == 1;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 1) {
            ClassPathEntry classPathEntry = (ClassPathEntry)this.cp.getEntries().get(n);
            classPathEntry.setDescription((String)object);
            this.fireTableCellUpdated(n, n2);
        }
    }

    public void addEntry(ClassPathEntry classPathEntry) {
        int n = this.cp.getEntries().size();
        this.cp.getEntries().add(classPathEntry);
        this.fireTableRowsInserted(n, n);
    }

    public void deleteEntry(int n) {
        if (n < this.cp.getEntries().size() && n >= 0) {
            this.cp.getEntries().remove(n);
            this.fireTableRowsDeleted(n, n);
        }
    }

    public void commitEntries() {
        this.origcp.removeAll();
        this.origcp.addClassPath(this.cp);
    }

    public void revertEntries() {
        this.cp = new ClassPath(this.origcp);
        this.fireTableDataChanged();
    }

    public ClassPathTableModel(ClassPath classPath) {
        this.origcp = classPath;
        this.cp = new ClassPath(classPath);
    }
}

