/*
 * Decompiled with CFR 0.152.
 */
package bluej.compiler;

import bluej.Config;
import bluej.compiler.Job;
import bluej.utility.Queue;

public class CompilerThread
extends Thread {
    static String title = Config.getString("compiler.thread.title");
    Queue jobs = new Queue();

    public void run() {
        while (true) {
            Job job;
            if ((job = (Job)this.jobs.dequeue()) != null) {
                job.compile();
                continue;
            }
            CompilerThread compilerThread = this;
            synchronized (compilerThread) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public synchronized void addJob(Job job) {
        this.jobs.enqueue(job);
        this.notify();
    }

    public CompilerThread() {
        super(title);
    }
}

