/*
 * Decompiled with CFR 0.152.
 */
package bluej.compiler;

import bluej.utility.Debug;
import bluej.utility.DialogManager;
import java.io.PrintStream;

class ErrorStream
extends PrintStream {
    private boolean haserror = false;
    private String filename;
    private String message;
    private int lineno;

    public void reset() {
        this.haserror = false;
    }

    public boolean hasError() {
        return this.haserror;
    }

    public String getFilename() {
        Debug.assert(this.haserror);
        return this.filename;
    }

    public int getLineNo() {
        Debug.assert(this.haserror);
        return this.lineno;
    }

    public String getMessage() {
        Debug.assert(this.haserror);
        return this.message;
    }

    public void print(String string) {
        int n;
        if (this.haserror) {
            return;
        }
        int n2 = string.indexOf(58, 0);
        if (n2 == -1) {
            DialogManager.showErrorWithText(null, "compiler-error", string);
            return;
        }
        this.filename = string.substring(0, n2);
        if (!this.filename.endsWith(".java")) {
            if ((n2 = string.indexOf(58, n2 + 1)) == -1) {
                DialogManager.showErrorWithText(null, "compiler-error", string);
                return;
            }
            this.filename = string.substring(0, n2);
        }
        if ((n = string.indexOf(58, n2 + 1)) == -1) {
            DialogManager.showErrorWithText(null, "compiler-error", string);
            return;
        }
        this.lineno = 0;
        try {
            this.lineno = Integer.parseInt(string.substring(n2 + 1, n));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.message = string.substring(n + 1);
        this.haserror = true;
    }

    public void println(String string) {
        this.print(string);
    }

    public void write(byte[] byArray, int n, int n2) {
        this.print(new String(byArray, n, n2));
    }

    public ErrorStream() {
        super(System.err);
    }
}

