/*
 * Decompiled with CFR 0.152.
 */
package bluej.compiler;

import bluej.compiler.CompileObserver;
import bluej.compiler.Compiler;
import bluej.utility.DialogManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;

public class JavacCompiler
extends Compiler {
    private String executable;
    private String destdir;
    private String classpath;
    private boolean debug;
    private boolean deprecation;

    public void setDestDir(String string) {
        this.destdir = string;
    }

    public void setClassPath(String string) {
        this.classpath = string;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public void setDeprecation(boolean bl) {
        this.deprecation = bl;
    }

    public boolean compile(String[] stringArray, CompileObserver compileObserver) {
        Vector<String> vector = new Vector<String>();
        vector.addElement(this.executable);
        if (this.destdir != null) {
            vector.addElement("-d");
            vector.addElement(this.destdir);
        }
        if (this.classpath != null) {
            vector.addElement("-classpath");
            vector.addElement(this.classpath);
        }
        if (this.debug) {
            vector.addElement("-g");
        }
        if (this.deprecation) {
            vector.addElement("-deprecation");
        }
        int n = 0;
        while (n < stringArray.length) {
            vector.addElement(stringArray[n]);
            ++n;
        }
        n = vector.size();
        Object[] objectArray = new String[n];
        vector.copyInto(objectArray);
        boolean bl = false;
        try {
            bl = this.executeCompiler((String[])objectArray, compileObserver);
        }
        catch (Exception exception) {
            DialogManager.showErrorWithText(null, "cannot-run-compiler", this.executable);
        }
        return bl;
    }

    private boolean executeCompiler(String[] stringArray, CompileObserver compileObserver) throws IOException, InterruptedException {
        String string;
        int n = 0;
        boolean bl = false;
        Process process = Runtime.getRuntime().exec(stringArray);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        while ((string = bufferedReader.readLine()) != null) {
            int n2;
            int n3 = string.indexOf(58, 0);
            if (n3 == -1) {
                DialogManager.showErrorWithText(null, "compiler-error", string);
                break;
            }
            String string2 = string.substring(0, n3);
            if (!string2.endsWith(".java")) {
                if ((n3 = string.indexOf(58, n3 + 1)) == -1) {
                    DialogManager.showErrorWithText(null, "compiler-error", string);
                    break;
                }
                string2 = string.substring(0, n3);
            }
            if ((n2 = string.indexOf(58, n3 + 1)) == -1) {
                DialogManager.showErrorWithText(null, "compiler-error", string);
                break;
            }
            int n4 = 0;
            try {
                n4 = Integer.parseInt(string.substring(n3 + 1, n2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            String string3 = string.substring(n2 + 1);
            if (bufferedReader.readLine() == null || bufferedReader.readLine() == null) {
                DialogManager.showError(null, "stream-incomplete");
                continue;
            }
            bl = true;
            compileObserver.errorMessage(string2, n4, string3, true);
            break;
        }
        n = process.waitFor();
        return n == 0 && !bl;
    }

    public JavacCompiler(String string) {
        this.executable = string;
        this.setDebug(true);
    }
}

