/*
 * Decompiled with CFR 0.152.
 */
package bluej.compiler;

import bluej.compiler.CompileObserver;
import bluej.compiler.Compiler;
import bluej.compiler.ErrorStream;
import com.sun.tools.javac.Main;
import java.io.PrintStream;
import java.util.Vector;

public class JavacCompilerInternal
extends Compiler {
    private ErrorStream firstStream = null;
    private String destdir;
    private String classpath;
    private boolean debug;
    private boolean deprecation;

    public void setDestDir(String string) {
        this.destdir = string;
    }

    public void setClassPath(String string) {
        this.classpath = string;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public void setDeprecation(boolean bl) {
        this.deprecation = bl;
    }

    public boolean compile(String[] stringArray, CompileObserver compileObserver) {
        Vector<String> vector = new Vector<String>();
        if (this.destdir != null) {
            vector.addElement("-d");
            vector.addElement(this.destdir);
        }
        if (this.classpath != null) {
            vector.addElement("-classpath");
            vector.addElement(this.classpath);
        }
        if (this.debug) {
            vector.addElement("-g");
        }
        if (this.deprecation) {
            vector.addElement("-deprecation");
        }
        int n = 0;
        while (n < stringArray.length) {
            vector.addElement(stringArray[n]);
            ++n;
        }
        n = vector.size();
        Object[] objectArray = new String[n];
        vector.copyInto(objectArray);
        PrintStream printStream = System.err;
        ErrorStream errorStream = new ErrorStream();
        if (this.firstStream == null) {
            this.firstStream = errorStream;
        }
        System.setErr(errorStream);
        Main main = new Main();
        int n2 = main.compile((String[])objectArray);
        if (errorStream.hasError()) {
            compileObserver.errorMessage(errorStream.getFilename(), errorStream.getLineNo(), errorStream.getMessage(), true);
        }
        if (this.firstStream != null && this.firstStream != errorStream && this.firstStream.hasError()) {
            compileObserver.errorMessage(this.firstStream.getFilename(), this.firstStream.getLineNo(), this.firstStream.getMessage(), true);
        }
        System.setErr(printStream);
        if (this.firstStream != null) {
            this.firstStream.reset();
        }
        return n2 == 0;
    }

    public JavacCompilerInternal() {
        this.setDebug(true);
    }
}

