/*
 * Decompiled with CFR 0.152.
 */
package bluej.compiler;

import bluej.Config;
import bluej.compiler.CompileObserver;
import bluej.compiler.Compiler;
import bluej.compiler.CompilerThread;
import bluej.compiler.JavacCompiler;
import bluej.compiler.JavacCompilerInternal;
import bluej.compiler.JikesCompiler;
import bluej.compiler.Job;
import bluej.utility.Debug;

public class JobQueue {
    private static JobQueue queue = null;
    private CompilerThread thread = null;
    private Compiler compiler = null;

    public static JobQueue getJobQueue() {
        if (queue == null) {
            queue = new JobQueue();
        }
        return queue;
    }

    public void addJob(String[] stringArray, CompileObserver compileObserver, String string, String string2) {
        this.thread.addJob(new Job(stringArray, this.compiler, compileObserver, string, string2));
    }

    public void addJob(String string, CompileObserver compileObserver, String string2, String string3) {
        this.thread.addJob(new Job(string, this.compiler, compileObserver, string2, string3));
    }

    private JobQueue() {
        String string = Config.getPropString("bluej.compiler.type");
        if (string.equals("internal")) {
            this.compiler = new JavacCompilerInternal();
        } else if (string.equals("javac")) {
            this.compiler = new JavacCompiler(Config.getPropString("bluej.compiler.executable", "javac"));
        } else if (string.equals("jikes")) {
            this.compiler = new JikesCompiler(Config.getPropString("bluej.compiler.executable", "jikes"));
        } else {
            Debug.message(Config.getString("compiler.invalidcompiler"));
        }
        this.thread = new CompilerThread();
        this.thread.setPriority(Thread.currentThread().getPriority() - 1);
        this.thread.start();
    }
}

