/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CallHistory {
    static final int DEFAULT_LENGTH = 6;
    static final String INT_NAME = "int";
    static final String BOOLEAN_NAME = "boolean";
    static final String LONG_NAME = "long";
    static final String FLOAT_NAME = "float";
    static final String DOUBLE_NAME = "double";
    static final String SHORT_NAME = "short";
    static final String STRING_NAME = "java.lang.String";
    private Map objectTypes = null;
    private List objectClasses = null;
    private List objectParams = null;
    private int historyLength;

    public List getHistory(Class clazz) {
        List list = null;
        if (this.objectTypes.containsKey(clazz.getName())) {
            list = (List)this.objectTypes.get(clazz.getName());
        } else {
            list = new ArrayList();
            int n = 0;
            while (n < this.objectClasses.size()) {
                if (clazz.isAssignableFrom((Class)this.objectClasses.get(n))) {
                    list.add(this.objectParams.get(n));
                }
                ++n;
            }
        }
        return list;
    }

    public void addCall(Class clazz, String string) {
        if (string != null) {
            if (this.objectTypes.containsKey(clazz.getName())) {
                List list = this.getHistory(clazz);
                int n = list.indexOf(string);
                if (n != 0) {
                    if (n > 0) {
                        list.remove(n);
                    }
                    list.add(0, string);
                }
                if (list.size() > this.historyLength) {
                    list.remove(this.historyLength);
                }
            } else {
                int n = this.objectParams.indexOf(string);
                if (n != 0) {
                    if (n > 0) {
                        this.objectParams.remove(n);
                        this.objectClasses.remove(n);
                    }
                    this.objectClasses.add(0, clazz);
                    this.objectParams.add(0, string);
                }
            }
        }
    }

    public CallHistory() {
        this(6);
    }

    public CallHistory(int n) {
        this.historyLength = n;
        this.objectTypes = new HashMap(8);
        this.objectTypes.put(INT_NAME, new ArrayList(n));
        this.objectTypes.put(LONG_NAME, new ArrayList(n));
        this.objectTypes.put(BOOLEAN_NAME, new ArrayList(n));
        this.objectTypes.put(FLOAT_NAME, new ArrayList(n));
        this.objectTypes.put(DOUBLE_NAME, new ArrayList(n));
        this.objectTypes.put(SHORT_NAME, new ArrayList(n));
        this.objectTypes.put(STRING_NAME, new ArrayList(n));
        this.objectClasses = new ArrayList();
        this.objectParams = new ArrayList();
    }
}

