/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger;

import bluej.debugger.DebuggerClassLoader;
import bluej.debugger.DebuggerObject;
import bluej.debugger.DebuggerThread;
import bluej.debugger.ExceptionDescription;
import bluej.debugger.jdi.JdiDebugger;
import com.sun.jdi.ThreadReference;
import java.util.Vector;

public abstract class Debugger {
    public static final int NORMAL_EXIT = 0;
    public static final int FORCED_EXIT = 1;
    public static final int EXCEPTION = 2;
    public static final int TERMINATED = 3;
    public static final int IDLE = 0;
    public static final int RUNNING = 1;
    public static final int SUSPENDED = 2;
    public static Debugger debugger = new JdiDebugger();

    public static void handleExit() {
        if (debugger != null) {
            debugger.endDebugger();
            debugger = null;
        }
    }

    protected abstract void startDebugger();

    protected abstract void endDebugger();

    public abstract DebuggerClassLoader createClassLoader(String var1, String var2);

    public abstract void removeClassLoader(DebuggerClassLoader var1);

    public abstract void addObjectToScope(String var1, String var2, String var3, String var4);

    public abstract void removeObjectFromScope(String var1, String var2);

    public abstract int getStatus();

    public abstract void setLibraries(String var1);

    public abstract void setDirectory(String var1);

    public abstract void serializeObject(String var1, String var2, String var3);

    public abstract DebuggerObject deserializeObject(String var1, String var2, String var3, String var4);

    public abstract void startClass(DebuggerClassLoader var1, String var2, Object var3);

    public abstract DebuggerObject getStaticValue(String var1, String var2) throws Exception;

    public abstract String toggleBreakpoint(String var1, int var2, boolean var3, DebuggerClassLoader var4);

    public abstract void saveBreakpoints();

    public abstract void restoreBreakpoints(DebuggerClassLoader var1);

    public abstract int getExitStatus();

    public abstract ExceptionDescription getException();

    public abstract Vector listThreads();

    public abstract void halt(DebuggerThread var1);

    public abstract void cont();

    public abstract void terminate(DebuggerThread var1);

    public abstract void showSource(DebuggerThread var1);

    public ThreadReference getServerThread() {
        return null;
    }
}

