/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger;

import bluej.Config;
import bluej.debugger.Debugger;
import bluej.debugger.DebuggerObject;
import bluej.debugger.DebuggerThread;
import bluej.debugger.ObjectViewer;
import bluej.utility.Debug;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ExecControls
extends JFrame
implements ActionListener,
ListSelectionListener {
    private static final String windowTitle = Config.getString("debugger.execControls.windowTitle");
    private static final String stackTitle = Config.getString("debugger.execControls.stackTitle");
    private static final String instanceTitle = Config.getString("debugger.execControls.instanceTitle");
    private static final String localTitle = Config.getString("debugger.execControls.localTitle");
    private static final String threadTitle = Config.getString("debugger.execControls.threadTitle");
    private static final String updateText = Config.getString("debugger.execControls.updateText");
    private static final String closeText = Config.getString("close");
    private static final String systemThreadText = Config.getString("debugger.execControls.systemThreads");
    private static String[] empty = new String[0];
    private static ExecControls execCtrlWindow = null;
    private JList threadList;
    private JList stackList;
    private JList instanceList;
    private JList localList;
    private JButton stopButton;
    private JButton stepButton;
    private JButton stepIntoButton;
    private JButton continueButton;
    private JButton terminateButton;
    private JButton updateButton;
    private JButton closeButton;
    private JCheckBox showSystemThreads;
    private List threads = new ArrayList();
    private DebuggerThread selectedThread;
    private DebuggerObject currentObject;
    private int currentFrame = 0;

    public static ExecControls getExecControls() {
        if (execCtrlWindow == null) {
            execCtrlWindow = new ExecControls();
        }
        return execCtrlWindow;
    }

    public static boolean execControlsShown() {
        return execCtrlWindow != null && execCtrlWindow.isShowing();
    }

    public static void showHide(boolean bl, boolean bl2, DebuggerThread debuggerThread) {
        ((Component)ExecControls.getExecControls()).setVisible(bl);
        if (bl && bl2) {
            ExecControls.getExecControls().updateThreads(debuggerThread);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        int n = Debugger.debugger.getStatus();
        if (object == this.updateButton) {
            this.updateThreads(this.selectedThread);
        } else if (object == this.closeButton) {
            ((Component)this).setVisible(false);
        } else if (object == this.showSystemThreads) {
            this.updateThreads(this.selectedThread);
        } else if (object == this.stopButton && n == 1) {
            Debugger.debugger.halt(this.selectedThread);
            this.updateThreads(this.selectedThread);
        } else if (object == this.continueButton && n == 2) {
            Debugger.debugger.cont();
            this.selectedThread = null;
            this.updateThreads(this.selectedThread);
        } else if (this.selectedThread != null) {
            if (object == this.stepButton && n == 2) {
                this.selectedThread.step();
            } else if (object == this.stepIntoButton && n == 2) {
                this.selectedThread.stepInto();
            } else if (object == this.terminateButton && n != 0) {
                Debugger.debugger.terminate(this.selectedThread);
                this.threadList.clearSelection();
                this.updateThreads(null);
            }
        } else {
            Debug.message("no thread selected...");
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        Object object = listSelectionEvent.getSource();
        if (object == this.threadList) {
            this.clearThreadDetails();
            this.selectThread(this.threadList.getSelectedIndex());
        } else if (object == this.stackList) {
            this.selectStackFrame(this.stackList.getSelectedIndex());
        }
    }

    public void listDoubleClick(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        if (component == this.instanceList && this.instanceList.getSelectedIndex() >= 0) {
            this.viewInstanceField(this.instanceList.getSelectedIndex());
        } else if (component == this.localList && this.localList.getSelectedIndex() >= 0) {
            this.viewLocalVar(this.localList.getSelectedIndex());
        }
    }

    public synchronized void updateThreads(DebuggerThread debuggerThread) {
        DefaultListModel defaultListModel = (DefaultListModel)this.threadList.getModel();
        defaultListModel.removeAllElements();
        int n = Debugger.debugger.getStatus();
        if (n == 1) {
            this.threads.clear();
            this.clearThreadDetails();
        } else {
            int n2 = 0;
            this.threads = Debugger.debugger.listThreads();
            if (this.threads == null) {
                Debug.reportError("cannot get thread info!");
                defaultListModel.addElement("(error: cannot list threads)");
            } else {
                this.threads = this.selectThreadsForDisplay(this.threads, debuggerThread);
                String string = debuggerThread == null ? "" : debuggerThread.getName();
                int n3 = 0;
                while (n3 < this.threads.size()) {
                    DebuggerThread debuggerThread2 = (DebuggerThread)this.threads.get(n3);
                    if (debuggerThread2.getName().equals(string)) {
                        n2 = n3;
                    }
                    String string2 = debuggerThread2.getStatus();
                    defaultListModel.addElement(debuggerThread2.getName() + " [" + string2 + "]");
                    ++n3;
                }
            }
            if (defaultListModel.getSize() > 0) {
                if (n2 != -1) {
                    this.threadList.setSelectedIndex(n2);
                    this.threadList.ensureIndexIsVisible(n2);
                }
            } else {
                this.clearThreadDetails();
            }
        }
        this.setButtonsEnabled(n);
    }

    private List selectThreadsForDisplay(List list, DebuggerThread debuggerThread) {
        boolean bl = this.showSystemThreads.isSelected();
        ArrayList<DebuggerThread> arrayList = new ArrayList<DebuggerThread>();
        String string = debuggerThread == null ? "" : debuggerThread.getName();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            boolean bl2;
            DebuggerThread debuggerThread2 = (DebuggerThread)iterator.next();
            boolean bl3 = bl2 = bl || !debuggerThread2.isKnownSystemThread() || debuggerThread2.getName().equals(string);
            if (!bl2 || debuggerThread2.getStatus().equals("finished")) continue;
            arrayList.add(debuggerThread2);
        }
        return arrayList;
    }

    private void selectThread(int n) {
        if (n >= 0 && n < this.threads.size()) {
            this.selectedThread = this.getThread(n);
            this.setThreadDetails();
        } else {
            this.selectedThread = null;
        }
    }

    private synchronized DebuggerThread getThread(int n) {
        return (DebuggerThread)this.threads.get(n);
    }

    private void setThreadDetails() {
        this.stackList.setFixedCellWidth(-1);
        List list = this.selectedThread.getStack();
        if (list.size() > 0) {
            this.stackList.setListData(list.toArray(new Object[0]));
            this.setStackFrameDetails(0);
        }
    }

    private void clearThreadDetails() {
        this.stackList.setListData(empty);
        this.instanceList.setListData(empty);
        this.localList.setListData(empty);
    }

    private void selectStackFrame(int n) {
        if (n >= 0) {
            this.setStackFrameDetails(n);
            this.selectedThread.setSelectedFrame(n);
            Debugger.debugger.showSource(this.selectedThread);
            this.currentFrame = n;
        }
    }

    private void setStackFrameDetails(int n) {
        this.currentObject = this.selectedThread.getCurrentObject(n);
        if (this.currentObject != null) {
            this.instanceList.setFixedCellWidth(-1);
            this.instanceList.setListData(this.currentObject.getAllFields(false).toArray(new Object[0]));
        }
        if (this.selectedThread != null) {
            this.localList.setFixedCellWidth(-1);
            this.localList.setListData(this.selectedThread.getLocalVariables(n).toArray(new Object[0]));
        }
    }

    private void viewInstanceField(int n) {
        if (this.currentObject.fieldIsObject(n)) {
            ObjectViewer objectViewer = ObjectViewer.getViewer(true, this.currentObject.getFieldObject(n), null, null, false, this);
        }
    }

    private void viewLocalVar(int n) {
        if (this.selectedThread.varIsObject(this.currentFrame, n)) {
            ObjectViewer objectViewer = ObjectViewer.getViewer(true, this.selectedThread.getStackObject(this.currentFrame, n), null, null, false, this);
        }
    }

    private void createWindow() {
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout(6, 6));
        jPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 0));
        Insets insets = new Insets(0, 0, 0, 0);
        this.stopButton = this.addButton("image.stop", jPanel2, insets);
        this.stepButton = this.addButton("image.step", jPanel2, insets);
        this.stepIntoButton = this.addButton("image.step_into", jPanel2, insets);
        this.continueButton = this.addButton("image.continue", jPanel2, insets);
        this.terminateButton = this.addButton("image.terminate", jPanel2, insets);
        jPanel.add((Component)jPanel2, "South");
        this.instanceList = new JList(new DefaultListModel());
        this.instanceList.setSelectionMode(0);
        this.instanceList.addListSelectionListener(this);
        this.instanceList.setVisibleRowCount(5);
        this.instanceList.setFixedCellWidth(150);
        JScrollPane jScrollPane = new JScrollPane(this.instanceList);
        jScrollPane.setColumnHeaderView(new JLabel(instanceTitle));
        this.localList = new JList(new DefaultListModel());
        this.localList.setSelectionMode(0);
        this.localList.addListSelectionListener(this);
        this.localList.setVisibleRowCount(5);
        this.localList.setFixedCellWidth(150);
        JScrollPane jScrollPane2 = new JScrollPane(this.localList);
        jScrollPane2.setColumnHeaderView(new JLabel(localTitle));
        ExecControls execControls = this;
        if (execControls == null) {
            throw null;
        }
        MouseAdapter mouseAdapter = new MouseAdapter(execControls){
            private final /* synthetic */ ExecControls this$0;

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    this.this$0.listDoubleClick(mouseEvent);
                }
            }
            {
                this.this$0 = execControls;
                this.constructor$0(execControls);
            }

            private final void constructor$0(ExecControls execControls) {
            }
        };
        this.instanceList.addMouseListener(mouseAdapter);
        this.localList.addMouseListener(mouseAdapter);
        JSplitPane jSplitPane = new JSplitPane(0, jScrollPane, jScrollPane2);
        jSplitPane.setDividerSize(6);
        this.stackList = new JList(new DefaultListModel());
        this.stackList.setSelectionMode(0);
        this.stackList.addListSelectionListener(this);
        this.stackList.setFixedCellWidth(150);
        JScrollPane jScrollPane3 = new JScrollPane(this.stackList);
        jScrollPane3.setColumnHeaderView(new JLabel(stackTitle));
        JSplitPane jSplitPane2 = new JSplitPane(1, jScrollPane3, jSplitPane);
        jSplitPane2.setDividerSize(6);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        this.threadList = new JList(new DefaultListModel());
        this.threadList.setSelectionMode(0);
        this.threadList.addListSelectionListener(this);
        this.threadList.setVisibleRowCount(4);
        JScrollPane jScrollPane4 = new JScrollPane(this.threadList);
        jScrollPane4.setColumnHeaderView(new JLabel(threadTitle));
        jPanel3.add((Component)jScrollPane4, "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel4.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.updateButton = new JButton(updateText);
        this.updateButton.addActionListener(this);
        jPanel4.add(this.updateButton);
        this.makeButtonNotGrow(this.updateButton);
        this.closeButton = new JButton(closeText);
        this.closeButton.addActionListener(this);
        jPanel4.add(this.closeButton);
        this.makeButtonNotGrow(this.closeButton);
        jPanel4.add(Box.createVerticalGlue());
        jPanel3.add((Component)jPanel4, "East");
        this.showSystemThreads = new JCheckBox(systemThreadText);
        Font font = this.showSystemThreads.getFont().deriveFont(10);
        this.showSystemThreads.setFont(font);
        this.showSystemThreads.addActionListener(this);
        JPanel jPanel5 = new JPanel(new FlowLayout(0, 5, 0));
        jPanel5.add(this.showSystemThreads);
        jPanel3.add((Component)jPanel5, "South");
        JSplitPane jSplitPane3 = new JSplitPane(0, jPanel3, jSplitPane2);
        jSplitPane3.setDividerSize(6);
        jPanel.add((Component)jSplitPane3, "Center");
        ExecControls execControls2 = this;
        if (execControls2 == null) {
            throw null;
        }
        this.addWindowListener(new WindowAdapter(execControls2){
            private final /* synthetic */ ExecControls this$0;

            public void windowClosing(WindowEvent windowEvent) {
                Window window = (Window)windowEvent.getSource();
                ((Component)window).setVisible(false);
            }
            {
                this.this$0 = execControls;
                this.constructor$0(execControls);
            }

            private final void constructor$0(ExecControls execControls) {
            }
        });
        ExecControls execControls3 = this;
        if (execControls3 == null) {
            throw null;
        }
        this.addComponentListener(new ComponentAdapter(execControls3){
            private final /* synthetic */ ExecControls this$0;

            public void componentMoved(ComponentEvent componentEvent) {
                Config.putLocation("bluej.debugger", this.this$0.getLocation());
            }
            {
                this.this$0 = execControls;
                this.constructor$0(execControls);
            }

            private final void constructor$0(ExecControls execControls) {
            }
        });
        ((Component)this).setLocation(Config.getLocation("bluej.debugger"));
        this.pack();
    }

    private void makeButtonNotGrow(JButton jButton) {
        Dimension dimension = jButton.getMinimumSize();
        dimension.width = Integer.MAX_VALUE;
        jButton.setMaximumSize(dimension);
    }

    private JButton addButton(String string, JPanel jPanel, Insets insets) {
        JButton jButton = new JButton(Config.getImageAsIcon(string));
        jButton.setMargin(insets);
        jButton.addActionListener(this);
        jPanel.add(jButton);
        return jButton;
    }

    private void setButtonsEnabled(int n) {
        switch (n) {
            case 0: {
                this.stopButton.setEnabled(false);
                this.stepButton.setEnabled(false);
                this.stepIntoButton.setEnabled(false);
                this.continueButton.setEnabled(false);
                this.terminateButton.setEnabled(false);
                break;
            }
            case 1: {
                this.stopButton.setEnabled(true);
                this.stepButton.setEnabled(false);
                this.stepIntoButton.setEnabled(false);
                this.continueButton.setEnabled(false);
                this.terminateButton.setEnabled(false);
                break;
            }
            case 2: {
                this.stopButton.setEnabled(false);
                this.stepButton.setEnabled(true);
                this.stepIntoButton.setEnabled(true);
                this.continueButton.setEnabled(true);
                this.terminateButton.setEnabled(true);
                break;
            }
        }
    }

    private ExecControls() {
        super(windowTitle);
        this.createWindow();
    }
}

