/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger;

import bluej.BlueJEvent;
import bluej.Config;
import bluej.compiler.CompileObserver;
import bluej.compiler.JobQueue;
import bluej.debugger.Debugger;
import bluej.debugger.DebuggerClassLoader;
import bluej.debugger.DebuggerObject;
import bluej.debugger.ExceptionDescription;
import bluej.debugger.MethodDialog;
import bluej.debugger.MethodDialogWatcher;
import bluej.debugger.ObjectViewer;
import bluej.debugger.ObjectWrapper;
import bluej.debugger.ResultWatcher;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.utility.BlueJFileReader;
import bluej.utility.Debug;
import bluej.utility.JavaNames;
import bluej.utility.Utility;
import bluej.views.CallableView;
import bluej.views.ConstructorView;
import bluej.views.LabelPrintWriter;
import bluej.views.MemberView;
import bluej.views.MethodView;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class Invoker
extends Thread
implements CompileObserver,
MethodDialogWatcher {
    private static final String creating = Config.getString("pkgmgr.creating");
    private static final String createDone = Config.getString("pkgmgr.createDone");
    public static final int OBJ_NAME_LENGTH = 8;
    public static final String SHELLNAME = "__SHELL";
    private static int shellNumber = 0;
    private static Map methods = new HashMap();
    private PkgMgrFrame pmf;
    private Package pkg;
    private ResultWatcher watcher;
    private CallableView member;
    private String shellName;
    private String objName;
    private String instanceName;
    private MethodDialog dialog;
    private boolean constructing;
    private String resultId;

    private static final synchronized String getShellName() {
        return SHELLNAME + shellNumber++;
    }

    private static final synchronized String getResultId() {
        return "#result" + shellNumber;
    }

    private void invoke() {
        if (!this.constructing && !this.member.hasParameters()) {
            this.doInvocation(null, null);
        } else {
            this.dialog = (MethodDialog)methods.get(this.member);
            if (this.dialog == null) {
                this.dialog = new MethodDialog(this.pmf, this.member.getClassName(), this.objName, this.member);
                methods.put(this.member, this.dialog);
            } else if (this.constructing) {
                this.dialog.setNewInstanceName(this.objName);
            } else {
                this.dialog.setInstanceName(this.objName);
            }
        }
        if (this.dialog != null) {
            LabelPrintWriter labelPrintWriter = new LabelPrintWriter();
            this.member.print(labelPrintWriter);
            this.dialog.setDescription(labelPrintWriter.getLabel());
            this.dialog.addWatcher(this);
            this.dialog.setVisible(true);
        }
    }

    public void methodDialogEvent(MethodDialog methodDialog, int n) {
        if (n == 1) {
            this.dialog.setVisible(false);
        } else if (n == 0) {
            this.instanceName = methodDialog.getNewInstanceName();
            this.doInvocation(methodDialog.getArgs(), methodDialog.getArgTypes());
            this.pmf.setWaitCursor(true);
            if (this.constructing) {
                this.pkg.setStatus(creating);
            }
        } else {
            Debug.reportError("Invoker: Unknown MethodDialog event");
        }
    }

    protected void doInvocation(String[] stringArray, Class[] classArray) {
        String string;
        String[] stringArray2;
        Object object;
        Object object2;
        Object object3;
        boolean bl = false;
        int n = stringArray == null ? 0 : stringArray.length;
        String string2 = this.member.getClassName();
        if (!this.pkg.isUnnamedPackage()) {
            object3 = this.pkg.getQualifiedName();
            int n2 = ((String)object3).indexOf(".");
            if (n2 >= 0) {
                object3 = ((String)object3).substring(0, n2);
            }
            if (this.pkg.getTarget((String)object3) != null) {
                bl = true;
            }
        }
        object3 = new Hashtable();
        if (this.pkg.isUnnamedPackage()) {
            ((Hashtable)object3).put("PKGLINE", "");
        } else {
            ((Hashtable)object3).put("PKGLINE", "package " + this.pkg.getQualifiedName() + ";");
        }
        ((Hashtable)object3).put("CLASSNAME", this.shellName);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.constructing) {
            stringBuffer.append("public static bluej.runtime.ObjectResultWrapper");
        } else {
            stringBuffer.append("public static Object");
        }
        stringBuffer.append(" __bluej_runtime_result;" + Config.nl);
        ((Hashtable)object3).put("VARDECL", stringBuffer.toString());
        stringBuffer = new StringBuffer("(");
        StringBuffer stringBuffer2 = new StringBuffer("(");
        if (n > 0) {
            stringBuffer.append("__bluej_param0");
            stringBuffer2.append(stringArray[0]);
        }
        int n3 = 1;
        while (n3 < n) {
            stringBuffer.append(",__bluej_param" + n3);
            stringBuffer2.append(", ");
            stringBuffer2.append(stringArray[n3]);
            ++n3;
        }
        stringBuffer.append(")");
        stringBuffer2.append(")");
        String string3 = stringBuffer.toString();
        String string4 = stringBuffer2.toString();
        Component[] componentArray = this.pmf.getObjectBench().getComponents();
        stringBuffer = new StringBuffer();
        String string5 = Utility.quoteSloshes(this.pkg.getId());
        if (componentArray.length > 0) {
            stringBuffer.append("java.util.Map __bluej_runtime_scope = getScope(\"" + string5 + "\");" + Config.nl);
        }
        int n4 = 0;
        while (n4 < componentArray.length) {
            object2 = (ObjectWrapper)componentArray[n4];
            object = bl ? JavaNames.getBase(((ObjectWrapper)object2).className) : ((ObjectWrapper)object2).className;
            stringArray2 = ((ObjectWrapper)object2).instanceName;
            stringBuffer.append("\t\t" + (String)object + " " + (String)stringArray2 + " = ");
            stringBuffer.append("(" + (String)object + ")__bluej_runtime_scope.get(\"");
            stringBuffer.append((String)stringArray2 + "\");" + Config.nl);
            ++n4;
        }
        n4 = 0;
        while (n4 < n) {
            stringBuffer.append("\t\t" + (bl ? JavaNames.getBase(JavaNames.typeName(classArray[n4].getName())) : JavaNames.typeName(classArray[n4].getName())));
            stringBuffer.append(" __bluej_param" + n4);
            stringBuffer.append(" = " + stringArray[n4]);
            stringBuffer.append(";" + Config.nl);
            ++n4;
        }
        ((Hashtable)object3).put("SCOPEINIT", stringBuffer.toString());
        stringBuffer = new StringBuffer();
        if (this.constructing) {
            string = "new " + (bl ? JavaNames.getBase(string2) : string2);
            stringBuffer.append("__bluej_runtime_result = makeObj((Object)");
            stringBuffer.append(string + string3 + ");" + Config.nl);
            stringBuffer.append("\t\tputObject(\"" + string5 + "\", \"");
            stringBuffer.append(this.instanceName);
            stringBuffer.append("\", __bluej_runtime_result.result);");
        } else {
            object2 = (MethodView)this.member;
            boolean bl2 = ((MethodView)object2).isVoid();
            string = ((MemberView)object2).isStatic() ? (bl ? JavaNames.getBase(string2) : string2) + "." + ((MethodView)object2).getName() : this.objName + "." + ((MethodView)object2).getName();
            if (!bl2) {
                stringBuffer.append("__bluej_runtime_result = makeObj(");
            }
            stringBuffer.append(string + string3);
            if (!bl2) {
                stringBuffer.append(")");
            }
            stringBuffer.append(";" + Config.nl);
            if (!bl2) {
                this.resultId = Invoker.getResultId();
                stringBuffer.append("\t\tputObject(\"" + string5 + "\", \"");
                stringBuffer.append(this.resultId);
                stringBuffer.append("\", __bluej_runtime_result);");
            }
        }
        ((Hashtable)object3).put("INVOCATION", stringBuffer.toString());
        object2 = Config.getTemplateFile("shell");
        object = new File(this.pkg.getPath(), this.shellName + ".java");
        try {
            BlueJFileReader.translateFile((File)object2, (File)object, (Dictionary)object3);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        BlueJEvent.raiseEvent(2, string + string4);
        stringArray2 = new String[]{((File)object).getPath()};
        JobQueue.getJobQueue().addJob(stringArray2, (CompileObserver)this, this.pkg.getProject().getClassPath(), this.pkg.getProject().getProjectDir().getPath());
    }

    public void startCompile(String[] stringArray) {
    }

    public void checkTarget(String string) {
    }

    public void errorMessage(String string, int n, String string2, boolean bl) {
        if (this.dialog != null) {
            this.dialog.setMessage("Error: " + string2);
        }
    }

    public void endCompile(String[] stringArray, boolean bl) {
        if (this.dialog != null) {
            this.dialog.setWaitCursor(false);
            if (bl) {
                this.dialog.setVisible(false);
                this.dialog.updateParameters();
            }
        }
        this.pmf.setWaitCursor(false);
        if (bl) {
            this.startClass();
        }
        File file = new File(this.pkg.getPath(), this.shellName + ".java");
        file.delete();
        File file2 = new File(this.pkg.getPath(), this.shellName + ".class");
        file2.delete();
        if (this.constructing) {
            this.pkg.setStatus(createDone);
        }
    }

    public void startClass() {
        try {
            BlueJEvent.raiseEvent(3, null);
            DebuggerClassLoader debuggerClassLoader = this.pkg.getRemoteClassLoader();
            String string = this.pkg.getQualifiedName(this.shellName);
            Debugger.debugger.startClass(debuggerClassLoader, string, this.pkg.getProject());
            BlueJEvent.raiseEvent(4, null);
            this.handleResult(string);
            ObjectViewer.updateViewers();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
        }
    }

    public void handleResult(String string) {
        try {
            int n = Debugger.debugger.getExitStatus();
            switch (n) {
                case 0: {
                    if (this.watcher != null) {
                        DebuggerObject debuggerObject = Debugger.debugger.getStaticValue(string, "__bluej_runtime_result");
                        if (this.constructing) {
                            this.watcher.putResult(debuggerObject, this.instanceName);
                            break;
                        }
                        this.watcher.putResult(debuggerObject, this.resultId);
                    }
                    break;
                }
                case 1: {
                    if (this.watcher != null) {
                        ExceptionDescription exceptionDescription = Debugger.debugger.getException();
                        this.pkg.reportExit(exceptionDescription.getText());
                    }
                    break;
                }
                case 2: {
                    ExceptionDescription exceptionDescription = Debugger.debugger.getException();
                    String string2 = JavaNames.stripPrefix(exceptionDescription.getClassName());
                    if (exceptionDescription.getText() != null) {
                        string2 = string2 + ":\n" + exceptionDescription.getText();
                    }
                    if (exceptionDescription.getClassName() == null) {
                        this.pkg.reportException(string2);
                        break;
                    }
                    this.pkg.exceptionMessage(exceptionDescription.getStack(), string2, false);
                    break;
                }
                case 3: {
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
        }
    }

    public Invoker(PkgMgrFrame pkgMgrFrame, CallableView callableView, String string, ResultWatcher resultWatcher) {
        if (pkgMgrFrame.isEmptyFrame()) {
            throw new IllegalArgumentException();
        }
        this.pmf = pkgMgrFrame;
        this.pkg = pkgMgrFrame.getPackage();
        this.member = callableView;
        this.watcher = resultWatcher;
        this.shellName = Invoker.getShellName();
        if (callableView instanceof ConstructorView) {
            String string2 = callableView.getClassName();
            int n = string2.lastIndexOf(46);
            if (n >= 0) {
                string2 = string2.substring(n + 1);
            }
            int n2 = string2.length() > 8 ? 8 : string2.length();
            String string3 = Character.toLowerCase(string2.charAt(0)) + string2.substring(1, n2);
            this.objName = string3 + "_" + callableView.getDeclaringView().getInstanceNum();
            this.constructing = true;
        } else if (callableView instanceof MethodView) {
            this.objName = ((MethodView)callableView).isStatic() ? JavaNames.stripPrefix(callableView.getClassName()) : string;
            this.constructing = false;
        } else {
            Debug.reportError("illegal member type in invokation");
        }
        this.invoke();
    }
}

