/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger;

import bluej.Config;
import bluej.debugger.ClassHistory;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.utility.DialogManager;
import bluej.utility.Utility;
import bluej.views.CallableView;
import bluej.views.View;
import bluej.views.ViewFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class LibraryCallDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    private static final String[] clickHere = new String[]{"    ", "    " + Config.getString("callLibraryDialog.clickHere1"), "    " + Config.getString("callLibraryDialog.clickHere2")};
    private static final String[] classNotFound = new String[]{"    ", "    " + Config.getString("callLibraryDialog.classNotFound1"), "    " + Config.getString("callLibraryDialog.classNotFound2")};
    private JComboBox classField;
    private JList methodList;
    private JButton docButton;
    private JButton okButton;
    private JButton cancelButton;
    private ClassHistory history;
    private Package pkg;
    private CallableView viewToCall;
    private Vector currentViews;

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.okButton.setEnabled(false);
            this.classField.setModel(new DefaultComboBoxModel(this.history.getHistory()));
            this.classSelected();
            this.classField.requestFocus();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.classField) {
            this.classSelected();
        } else if (object == this.docButton) {
            this.showDocumentation();
        } else if (object == this.okButton) {
            this.doOk();
        } else if (object == this.cancelButton) {
            this.doCancel();
        }
    }

    private void showDocumentation() {
        String string = (String)this.classField.getEditor().getItem();
        Utility.showClassDocumentation(string, "#constructor_summary");
    }

    private void doOk() {
        if (this.viewToCall == null) {
            return;
        }
        this.history.addClass((String)this.classField.getEditor().getItem());
        this.setVisible(false);
        this.pkg.getEditor().raiseMethodCallEvent(this.pkg, this.viewToCall);
    }

    private void doCancel() {
        this.setVisible(false);
    }

    private void classSelected() {
        Class<?> clazz = null;
        this.currentViews.clear();
        this.viewToCall = null;
        this.okButton.setEnabled(false);
        String string = (String)this.classField.getEditor().getItem();
        if (string.length() == 0) {
            this.displayTextInClassList(clickHere);
            return;
        }
        try {
            clazz = Class.forName(string, true, ClassLoader.getSystemClassLoader());
        }
        catch (Exception exception) {
            this.displayTextInClassList(classNotFound);
            return;
        }
        this.displayMethodsForClass(clazz);
    }

    private void displayMethodsForClass(Class clazz) {
        View view = View.getView(clazz);
        Vector vector = new Vector();
        CallableView[] callableViewArray = view.getConstructors();
        ViewFilter viewFilter = new ViewFilter(196609);
        this.addMethods(vector, callableViewArray, viewFilter);
        CallableView[] callableViewArray2 = view.getAllMethods();
        viewFilter = new ViewFilter(65549);
        this.addMethods(vector, callableViewArray2, viewFilter);
        this.methodList.setListData(vector);
        this.methodList.clearSelection();
        this.methodList.setEnabled(true);
        this.docButton.setEnabled(true);
    }

    private void displayTextInClassList(String[] stringArray) {
        this.methodList.setListData(stringArray);
        this.methodList.setEnabled(false);
        this.docButton.setEnabled(false);
    }

    public void addMethods(Vector vector, CallableView[] callableViewArray, ViewFilter viewFilter) {
        int n = 0;
        while (n < callableViewArray.length) {
            if (viewFilter.accept(callableViewArray[n])) {
                this.currentViews.add(callableViewArray[n]);
                vector.add(callableViewArray[n].getShortDesc());
            }
            ++n;
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        int n = this.methodList.getSelectedIndex();
        if (n == -1) {
            return;
        }
        String string = (String)this.methodList.getSelectedValue();
        if (string.charAt(0) == ' ') {
            return;
        }
        this.viewToCall = (CallableView)this.currentViews.get(n);
        this.okButton.setEnabled(true);
    }

    private void makeDialog() {
        JPanel jPanel = (JPanel)this.getContentPane();
        JPanel jPanel2 = new JPanel(new BorderLayout(4, 6));
        jPanel2.add((Component)new JLabel(Config.getString("callLibraryDialog.classLabel")), "West");
        this.classField = new JComboBox(this.history.getHistory());
        this.classField.setEditable(true);
        this.classField.setMaximumRowCount(10);
        JComponent jComponent = (JTextField)this.classField.getEditor().getEditorComponent();
        ((JTextField)jComponent).setColumns(16);
        this.classField.addActionListener(this);
        jPanel2.add((Component)this.classField, "Center");
        this.docButton = new JButton(Config.getString("callLibraryDialog.docButton"));
        this.docButton.addActionListener(this);
        this.docButton.setEnabled(false);
        jPanel2.add((Component)this.docButton, "East");
        jComponent = new JPanel(new BorderLayout());
        this.methodList = new JList();
        this.methodList.setSelectionMode(0);
        this.methodList.addListSelectionListener(this);
        this.methodList.setVisibleRowCount(8);
        JComponent jComponent2 = new JScrollPane(this.methodList);
        ((JScrollPane)jComponent2).setColumnHeaderView(new JLabel(Config.getString("callLibraryDialog.listHeading")));
        LibraryCallDialog libraryCallDialog = this;
        if (libraryCallDialog == null) {
            throw null;
        }
        MouseAdapter mouseAdapter = new MouseAdapter(libraryCallDialog){
            private final /* synthetic */ LibraryCallDialog this$0;

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    LibraryCallDialog.access$0(this.this$0);
                }
            }
            {
                this.this$0 = libraryCallDialog;
                this.constructor$0(libraryCallDialog);
            }

            private final void constructor$0(LibraryCallDialog libraryCallDialog) {
            }
        };
        this.methodList.addMouseListener(mouseAdapter);
        jComponent.add((Component)jComponent2, "Center");
        jComponent2 = new JPanel();
        jComponent2.setLayout(new FlowLayout(2));
        this.okButton = this.addButton((JPanel)jComponent2, Config.getString("okay"));
        this.cancelButton = this.addButton((JPanel)jComponent2, Config.getString("cancel"));
        this.getRootPane().setDefaultButton(this.okButton);
        this.okButton.setEnabled(false);
        this.okButton.setPreferredSize(new Dimension(this.cancelButton.getPreferredSize().width, this.okButton.getPreferredSize().height));
        jPanel.setLayout(new BorderLayout(6, 6));
        jPanel.setBorder(Config.generalBorder);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jComponent, "Center");
        jPanel.add((Component)jComponent2, "South");
        this.pack();
        DialogManager.centreDialog(this);
        LibraryCallDialog libraryCallDialog2 = this;
        if (libraryCallDialog2 == null) {
            throw null;
        }
        this.addWindowListener(new WindowAdapter(libraryCallDialog2){
            private final /* synthetic */ LibraryCallDialog this$0;

            public void windowClosing(WindowEvent windowEvent) {
                this.this$0.setVisible(false);
            }
            {
                this.this$0 = libraryCallDialog;
                this.constructor$0(libraryCallDialog);
            }

            private final void constructor$0(LibraryCallDialog libraryCallDialog) {
            }
        });
    }

    private JButton addButton(JPanel jPanel, String string) {
        JButton jButton = new JButton(string);
        jPanel.add(jButton);
        jButton.addActionListener(this);
        return jButton;
    }

    static /* synthetic */ void access$0(LibraryCallDialog libraryCallDialog) {
        libraryCallDialog.doOk();
    }

    public LibraryCallDialog(PkgMgrFrame pkgMgrFrame) {
        super(pkgMgrFrame, Config.getString("callLibraryDialog.title"), false);
        this.pkg = pkgMgrFrame.getPackage();
        this.currentViews = new Vector();
        this.viewToCall = null;
        this.history = ClassHistory.getClassHistory(10);
        this.makeDialog();
    }
}

