/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger;

import bluej.Config;
import bluej.debugger.CallHistory;
import bluej.debugger.MethodDialogWatcher;
import bluej.debugger.ObjectBench;
import bluej.debugger.ObjectBenchEvent;
import bluej.debugger.ObjectBenchListener;
import bluej.debugger.ObjectWrapper;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.utility.DialogManager;
import bluej.utility.JavaNames;
import bluej.utility.MultiLineLabel;
import bluej.views.CallableView;
import bluej.views.ConstructorView;
import bluej.views.MemberView;
import bluej.views.MethodView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class MethodDialog
extends JDialog
implements ActionListener,
FocusListener,
ObjectBenchListener {
    static final int MD_CREATE = 0;
    static final int MD_CALL = 1;
    static final String CMD_OKAY = "okay";
    static final String CMD_CANCEL = "cancel";
    static final String CMD_PARAM = "param";
    static final int OK = 0;
    static final int CANCEL = 1;
    static final String wCreateTitle = Config.getString("pkgmgr.methodCall.titleCreate");
    static final String wCallRoutineTitle = Config.getString("pkgmgr.methodCall.titleCall");
    static final String sNameOfInstance = Config.getString("pkgmgr.methodCall.namePrompt");
    static final String emptyFieldMsg = Config.getString("error.methodCall.emptyField");
    static final String illegalNameMsg = Config.getString("error.methodCall.illegalName");
    static final String duplicateNameMsg = Config.getString("error.methodCall.duplicateName");
    static final String commentSlash = "   ";
    int dialogType;
    private JButton bOk;
    private JButton bCancel;
    private String methodName;
    private JPanel descPanel;
    private JComboBox[] params;
    private MultiLineLabel status;
    private MethodDialogWatcher watcher;
    private JTextField instanceNameText;
    private JTextField focusedTextField;
    private JLabel callLabel;
    private CallHistory history;
    private ObjectBench bench;
    private String[] paramNames;
    private Class[] paramClasses;
    private boolean emptyField = false;
    private String defaultParamValue = "";

    private void makeCallDialog(String string, String string2, MemberView memberView, String[] stringArray, JPanel jPanel) {
        this.setTitle(wCallRoutineTitle);
        if (stringArray != null) {
            MethodView methodView = (MethodView)memberView;
            this.paramClasses = methodView.getParameters();
            JPanel jPanel2 = new JPanel();
            GridBagLayout gridBagLayout = new GridBagLayout();
            jPanel2.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            this.callLabel = new JLabel("", 4);
            if (memberView.isStatic()) {
                this.setCallLabel(string, this.methodName);
            } else {
                this.setCallLabel(string2, this.methodName);
            }
            if (methodView.isMain()) {
                this.defaultParamValue = "{ }";
            }
            gridBagLayout.setConstraints(this.callLabel, gridBagConstraints);
            jPanel2.add(this.callLabel);
            this.params = new JComboBox[this.paramClasses.length];
            int n = 0;
            while (n < this.paramClasses.length) {
                gridBagConstraints.gridx = 1;
                List list = this.history.getHistory(this.paramClasses[n]);
                this.params[n] = new JComboBox<Object>(list.toArray());
                this.params[n].insertItemAt(this.defaultParamValue, 0);
                this.params[n].setEditable(true);
                this.params[n].setActionCommand(CMD_PARAM);
                this.params[n].addActionListener(this);
                ((JTextField)this.params[n].getEditor().getEditorComponent()).addFocusListener(this);
                gridBagConstraints.gridy = n;
                gridBagLayout.setConstraints(this.params[n], gridBagConstraints);
                jPanel2.add(this.params[n]);
                gridBagConstraints.gridx = 2;
                gridBagConstraints.anchor = 17;
                JLabel jLabel = new JLabel(",     " + stringArray[n], 2);
                if (n == this.paramClasses.length - 1) {
                    if (this.paramClasses.length == 1) {
                        jLabel.setText(")");
                    } else {
                        jLabel.setText(")     " + stringArray[n]);
                    }
                }
                gridBagLayout.setConstraints(jLabel, gridBagConstraints);
                jPanel2.add(jLabel);
                ++n;
            }
            jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            jPanel2.setAlignmentX(0.0f);
            jPanel.add(jPanel2);
        }
    }

    private void setCallLabel(String string, String string2) {
        if (this.callLabel != null) {
            this.callLabel.setText(JavaNames.stripPrefix(string) + "." + string2 + " (");
        }
    }

    private void makeCreateDialog(String string, String string2, MemberView memberView, String[] stringArray, JPanel jPanel) {
        JPanel jPanel2;
        this.setTitle(wCreateTitle);
        JLabel jLabel = new JLabel(sNameOfInstance);
        this.instanceNameText = new JTextField(string2, 16);
        if (stringArray != null) {
            ConstructorView constructorView = (ConstructorView)memberView;
            this.paramClasses = constructorView.getParameters();
            jPanel2 = new JPanel();
            GridBagLayout gridBagLayout = new GridBagLayout();
            jPanel2.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            jPanel2.add(jLabel);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagLayout.setConstraints(this.instanceNameText, gridBagConstraints);
            jPanel2.add(this.instanceNameText);
            JLabel jLabel2 = new JLabel("new " + string + "(", 4);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.fill = 0;
            gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
            jPanel2.add(jLabel2);
            this.params = new JComboBox[this.paramClasses.length];
            int n = 0;
            while (n < this.paramClasses.length) {
                gridBagConstraints.gridy = n + 1;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.gridx = 1;
                gridBagConstraints.fill = 2;
                List list = this.history.getHistory(this.paramClasses[n]);
                this.params[n] = new JComboBox<Object>(list.toArray());
                this.params[n].insertItemAt(this.defaultParamValue, 0);
                this.params[n].setEditable(true);
                ((JTextField)this.params[n].getEditor().getEditorComponent()).addFocusListener(this);
                gridBagLayout.setConstraints(this.params[n], gridBagConstraints);
                jPanel2.add(this.params[n]);
                gridBagConstraints.fill = 0;
                gridBagConstraints.gridx = 2;
                JLabel jLabel3 = new JLabel(",     " + stringArray[n], 2);
                if (n == this.paramClasses.length - 1) {
                    if (this.paramClasses.length == 1) {
                        jLabel3.setText(")");
                    } else {
                        jLabel3.setText(")     " + stringArray[n]);
                    }
                }
                gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
                jPanel2.add(jLabel3);
                ++n;
            }
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            JPanel jPanel3 = new JPanel();
            gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
            jPanel2.add(jPanel3);
        } else {
            jPanel2 = new JPanel();
            jPanel2.add(jLabel);
            jPanel2.add(this.instanceNameText);
        }
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        jPanel.add("North", jPanel2);
    }

    public String[] parseParamNames(String string) {
        String[] stringArray = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",()", true);
        String string2 = "";
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.equals("(")) {
                bl = true;
                string2 = "";
                continue;
            }
            if (string3.equals(",")) {
                arrayList.add(string2);
                bl = true;
                string2 = "";
                continue;
            }
            if (string3.equals(")")) {
                arrayList.add(string2);
                bl = false;
                continue;
            }
            if (!bl) continue;
            string2 = string2 + string3;
        }
        stringArray = new String[arrayList.size()];
        int n = 0;
        while (n < arrayList.size()) {
            stringArray[n] = ((String)arrayList.get(n)).trim();
            ++n;
        }
        return stringArray;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.setMessage("");
        if (bl) {
            this.clearParameters();
            this.bench.addObjectBenchListener(this);
            if (this.params != null) {
                this.params[0].requestFocus();
            } else if (this.dialogType == 0) {
                this.instanceNameText.selectAll();
                this.instanceNameText.requestFocus();
            } else {
                this.bOk.requestFocus();
            }
        } else {
            this.getOwner().repaint();
            this.bench.removeObjectBenchListener(this);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (CMD_OKAY.equals(string)) {
            this.doOk();
        } else if (CMD_CANCEL.equals(string)) {
            this.doCancel();
        } else if (CMD_PARAM.equals(string)) {
            this.doParamEntered((JComponent)actionEvent.getSource());
        }
    }

    public void doOk() {
        this.paramNames = this.getParamNames();
        if (this.dialogType == 0) {
            if (!JavaNames.isIdentifier(this.getNewInstanceName())) {
                this.setMessage(illegalNameMsg);
                return;
            }
            if (this.bench.hasObject(this.getNewInstanceName())) {
                this.setMessage(duplicateNameMsg);
                return;
            }
        }
        if (this.emptyField) {
            this.setMessage(emptyFieldMsg);
            this.emptyField = false;
        } else {
            this.setWaitCursor(true);
            this.callWatcher(0);
        }
    }

    public void doCancel() {
        this.callWatcher(1);
    }

    public void doParamEntered(JComponent jComponent) {
        jComponent.transferFocus();
    }

    public void addWatcher(MethodDialogWatcher methodDialogWatcher) {
        if (methodDialogWatcher != null) {
            this.watcher = methodDialogWatcher;
        }
    }

    public void callWatcher(int n) {
        if (this.watcher != null) {
            this.watcher.methodDialogEvent(this, n);
        }
    }

    public void setDescription(MultiLineLabel multiLineLabel) {
        multiLineLabel.setAlignmentX(0.0f);
        this.descPanel.removeAll();
        this.descPanel.add(multiLineLabel);
        this.invalidate();
        this.validate();
    }

    public String[] getParamNames() {
        String[] stringArray = null;
        if (this.params != null) {
            stringArray = new String[this.params.length];
            int n = 0;
            while (n < this.params.length) {
                String string = (String)this.params[n].getEditor().getItem();
                if (string == null || string.trim().equals("")) {
                    this.emptyField = true;
                }
                stringArray[n] = string;
                ++n;
            }
        }
        return stringArray;
    }

    public void insertText(String string) {
        if (this.params != null && this.focusedTextField != null) {
            this.focusedTextField.setText(string);
            this.show();
        }
    }

    public void setMessage(String string) {
        this.status.setText(string);
        this.pack();
        this.invalidate();
        this.validate();
    }

    public void setInstanceName(String string) {
        this.setCallLabel(string, this.methodName);
    }

    public void setNewInstanceName(String string) {
        this.instanceNameText.setText(string);
    }

    public String getNewInstanceName() {
        if (this.instanceNameText == null) {
            return "";
        }
        return this.instanceNameText.getText().trim();
    }

    public String[] getArgs() {
        return this.paramNames;
    }

    public Class[] getArgTypes() {
        return this.paramClasses;
    }

    public void updateParameters() {
        if (this.params != null) {
            int n = 0;
            while (n < this.params.length) {
                this.history.addCall(this.paramClasses[n], (String)this.params[n].getEditor().getItem());
                List list = this.history.getHistory(this.paramClasses[n]);
                this.params[n].setModel(new DefaultComboBoxModel<Object>(list.toArray()));
                this.params[n].insertItemAt(this.defaultParamValue, 0);
                ++n;
            }
        }
    }

    private void clearParameters() {
        if (this.params != null) {
            int n = 0;
            while (n < this.params.length) {
                this.params[n].setSelectedIndex(0);
                ++n;
            }
        }
    }

    public void setWaitCursor(boolean bl) {
        if (bl) {
            this.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void objectEvent(ObjectBenchEvent objectBenchEvent) {
        ObjectWrapper objectWrapper = objectBenchEvent.getWrapper();
        this.insertText(objectWrapper.instanceName);
    }

    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getComponent() instanceof JTextField) {
            this.focusedTextField = (JTextField)focusEvent.getComponent();
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public MethodDialog(PkgMgrFrame pkgMgrFrame, String string, String string2, CallableView callableView) {
        super((Frame)pkgMgrFrame, false);
        Package package_ = pkgMgrFrame.getPackage();
        this.history = package_.getCallHistory();
        this.bench = pkgMgrFrame.getObjectBench();
        this.status = new MultiLineLabel("\n\n", 0.0f);
        this.status.setForeground(new Color(136, 56, 56));
        JPanel jPanel = new JPanel();
        jPanel.setMinimumSize(new Dimension(120, 40));
        if (callableView instanceof MethodView) {
            this.dialogType = 1;
            this.methodName = ((MethodView)callableView).getName();
        } else if (callableView instanceof ConstructorView) {
            this.dialogType = 0;
        }
        JPanel jPanel2 = new JPanel();
        this.descPanel = new JPanel();
        this.descPanel.setLayout(new BoxLayout(this.descPanel, 1));
        this.descPanel.setAlignmentX(0.0f);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.setAlignmentX(0.0f);
        Object object = null;
        if (callableView.hasParameters()) {
            object = this.parseParamNames(callableView.getLongDesc());
        }
        switch (this.dialogType) {
            case 1: {
                this.makeCallDialog(string, string2, callableView, (String[])object, jPanel3);
                break;
            }
            case 0: {
                this.makeCreateDialog(string, string2, callableView, (String[])object, jPanel3);
                break;
            }
            default: {
                throw new Error("Invalid MethodDialog type " + this.dialogType);
            }
        }
        object = new JPanel();
        ((Container)object).setLayout(new FlowLayout(2));
        ((JComponent)object).setAlignmentX(0.0f);
        this.bOk = new JButton(Config.getString(CMD_OKAY));
        ((Container)object).add(this.bOk);
        this.bOk.setActionCommand(CMD_OKAY);
        this.bOk.addActionListener(this);
        this.bCancel = new JButton(Config.getString(CMD_CANCEL));
        ((Container)object).add(this.bCancel);
        this.bCancel.setActionCommand(CMD_CANCEL);
        this.bCancel.addActionListener(this);
        this.getRootPane().setDefaultButton(this.bOk);
        this.bOk.setPreferredSize(new Dimension(this.bCancel.getPreferredSize().width, this.bOk.getPreferredSize().height));
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBorder(Config.generalBorder);
        jPanel2.add(this.descPanel);
        jPanel2.add(Box.createVerticalStrut(5));
        jPanel2.add(new JSeparator());
        jPanel2.add(Box.createVerticalStrut(5));
        jPanel2.add(jPanel3);
        jPanel2.add(this.status);
        jPanel2.add(new JSeparator());
        jPanel2.add(Box.createVerticalStrut(5));
        jPanel2.add((Component)object);
        this.getContentPane().add(jPanel2);
        this.pack();
        DialogManager.centreDialog(this);
        MethodDialog methodDialog = this;
        if (methodDialog == null) {
            throw null;
        }
        this.addWindowListener(new WindowAdapter(methodDialog){
            private final /* synthetic */ MethodDialog this$0;

            public void windowClosing(WindowEvent windowEvent) {
                this.this$0.setVisible(false);
            }
            {
                this.this$0 = methodDialog;
                this.constructor$0(methodDialog);
            }

            private final void constructor$0(MethodDialog methodDialog) {
            }
        });
    }
}

