/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger;

import bluej.Config;
import bluej.debugger.Debugger;
import bluej.debugger.DebuggerObject;
import bluej.debugger.Inspector;
import bluej.debugger.InspectorClassLoader;
import bluej.debugger.InspectorEvent;
import bluej.debugger.InspectorListener;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.Project;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.JavaNames;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ObjectViewer
extends JFrame
implements ActionListener,
ListSelectionListener,
InspectorListener {
    protected static int count = 0;
    protected static Hashtable viewers = new Hashtable();
    protected static final Color bgColor = new Color(208, 212, 208);
    protected static final String inspectorDirectoryName = "+inspector";
    protected static final String inspectTitle = Config.getString("debugger.objectviewer.title");
    protected static final String resultTitle = Config.getString("debugger.resultviewer.title");
    protected static final String staticListTitle = Config.getString("debugger.objectviewer.staticListTitle");
    protected static final String objListTitle = Config.getString("debugger.objectviewer.objListTitle");
    protected static final String inspectLabel = Config.getString("debugger.objectviewer.inspect");
    protected static final String getLabel = Config.getString("debugger.objectviewer.get");
    protected static final String close = Config.getString("close");
    protected static final String objectClassName = Config.getString("debugger.objectviewer.objectClassName");
    protected static Class[] insp = new Class[10];
    protected static int inspCnt = 0;
    protected static Set loadedProjects = new HashSet();
    private static final int VISIBLE_ARRAY_START = 40;
    private static final int VISIBLE_ARRAY_TAIL = 5;
    private static final int ARRAY_QUERY_SLOT_VALUE = -2;
    protected boolean isInspection;
    protected JList staticFieldList = null;
    protected JList objFieldList = null;
    protected TreeSet arraySet = null;
    protected List indexToSlotList = null;
    protected JScrollPane staticScrollPane = null;
    protected JScrollPane objectScrollPane = null;
    protected JSplitPane listPane = null;
    protected JButton inspectBtn;
    protected JButton getBtn;
    protected DebuggerObject obj;
    protected DebuggerObject selectedObject;
    protected String selectedObjectName;
    protected Package pkg;
    protected String pkgScopeId;
    protected boolean getEnabled;
    protected boolean isInScope;
    protected boolean queryArrayElementSelected;
    protected JTabbedPane inspectorTabs = null;
    protected String viewerId;

    public static ObjectViewer getViewer(boolean bl, DebuggerObject debuggerObject, String string, Package package_, boolean bl2, JFrame jFrame) {
        ObjectViewer objectViewer = (ObjectViewer)viewers.get(debuggerObject);
        if (objectViewer == null) {
            String string2;
            if (string == null) {
                string2 = "#viewer" + count;
                ++count;
            } else {
                string2 = string;
            }
            objectViewer = new ObjectViewer(bl, debuggerObject, package_, string2, bl2, jFrame);
            viewers.put(debuggerObject, objectViewer);
        }
        objectViewer.update();
        ((Component)objectViewer).setVisible(true);
        objectViewer.bringToFront();
        return objectViewer;
    }

    public static void updateViewers() {
        Enumeration enumeration = viewers.elements();
        while (enumeration.hasMoreElements()) {
            ObjectViewer objectViewer = (ObjectViewer)enumeration.nextElement();
            objectViewer.update();
        }
    }

    public String getId() {
        return this.viewerId;
    }

    public String getResult() {
        if (this.isInspection) {
            return "";
        }
        return (String)this.obj.getInstanceFields(false).get(0);
    }

    public void getEvent(InspectorEvent inspectorEvent) {
    }

    public void bringToFront() {
        this.setState(0);
        this.toFront();
    }

    public void update() {
        int n;
        int n2 = 7;
        if (this.isInspection && !this.obj.isArray() && this.staticFieldList != null) {
            this.staticFieldList.setListData(this.obj.getStaticFields(true).toArray(new Object[0]));
            n = this.obj.getStaticFieldCount() + 2;
            if (n > n2) {
                n = n2;
            }
            this.staticFieldList.setVisibleRowCount(n);
        }
        if (this.obj.isArray()) {
            this.objFieldList.setListData(this.compressArrayList(this.obj.getInstanceFields(this.isInspection)).toArray(new Object[0]));
        } else {
            this.objFieldList.setListData(this.obj.getInstanceFields(this.isInspection).toArray(new Object[0]));
        }
        if (this.objFieldList != null) {
            n = this.obj.getInstanceFieldCount() + 2;
            if (n > n2) {
                n = n2;
            }
            if (!this.isInspection) {
                n = 2;
            }
            this.objFieldList.setVisibleRowCount(n);
        }
        if (this.staticFieldList != null) {
            this.staticFieldList.revalidate();
        }
        if (this.objFieldList != null) {
            this.objFieldList.revalidate();
        }
        if (this.listPane != null) {
            this.listPane.resetToPreferredSizes();
        }
        double d = this.objFieldList.getPreferredScrollableViewportSize().getWidth();
        if (this.staticFieldList != null) {
            d = Math.max(d, this.staticFieldList.getPreferredScrollableViewportSize().getWidth());
        }
        if (d <= 200.0) {
            this.objFieldList.setFixedCellWidth(200);
        } else {
            this.objFieldList.setFixedCellWidth(-1);
        }
        this.pack();
        if (this.inspectorTabs != null) {
            int n3 = 1;
            while (n3 < this.inspectorTabs.getTabCount()) {
                ((Inspector)this.inspectorTabs.getComponentAt(n3)).refresh();
                ++n3;
            }
        }
        this.repaint();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (inspectLabel.equals(string)) {
            this.doInspect();
        } else if (getLabel.equals(string) && this.selectedObject != null) {
            this.doGet();
        } else if (close.equals(string)) {
            this.doClose();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        if (listSelectionEvent.getSource() == this.staticFieldList) {
            int n = this.staticFieldList.getSelectedIndex();
            if (n == -1) {
                return;
            }
            if (this.obj.staticFieldIsObject(n)) {
                this.setCurrentObj(this.obj.getStaticFieldObject(n), this.obj.getStaticFieldName(n));
                if (this.obj.staticFieldIsPublic(n)) {
                    this.setButtonsEnabled(true, true);
                } else {
                    this.setButtonsEnabled(true, false);
                }
            } else {
                this.setCurrentObj(null, null);
                this.setButtonsEnabled(false, false);
            }
            this.objFieldList.clearSelection();
        } else if (listSelectionEvent.getSource() == this.objFieldList) {
            int n = this.objFieldList.getSelectedIndex();
            if (n == -1) {
                return;
            }
            if (this.obj.isArray()) {
                n = this.indexToSlot(n);
            }
            boolean bl = this.queryArrayElementSelected = n == -2;
            if (this.queryArrayElementSelected) {
                this.setCurrentObj(null, null);
                if (this.obj.instanceFieldIsObject(0)) {
                    this.setButtonsEnabled(true, false);
                } else {
                    this.setButtonsEnabled(false, false);
                }
            } else if (this.obj.instanceFieldIsObject(n)) {
                this.setCurrentObj(this.obj.getInstanceFieldObject(n), this.obj.getInstanceFieldName(n));
                if (this.obj.instanceFieldIsPublic(n)) {
                    this.setButtonsEnabled(true, true);
                } else {
                    this.setButtonsEnabled(true, false);
                }
            } else {
                this.setCurrentObj(null, null);
                this.setButtonsEnabled(false, false);
            }
            if (this.staticFieldList != null) {
                this.staticFieldList.clearSelection();
            }
        }
    }

    public void inspectEvent(InspectorEvent inspectorEvent) {
        ObjectViewer.getViewer(true, inspectorEvent.getDebuggerObject(), null, this.pkg, false, this);
    }

    private void setCurrentObj(DebuggerObject debuggerObject, String string) {
        this.selectedObject = debuggerObject;
        this.selectedObjectName = string;
    }

    private void setButtonsEnabled(boolean bl, boolean bl2) {
        this.inspectBtn.setEnabled(bl);
        if (this.getEnabled) {
            this.getBtn.setEnabled(bl2);
        }
    }

    private List compressArrayList(List list) {
        if (this.arraySet == null) {
            this.arraySet = new TreeSet();
        }
        this.indexToSlotList = new LinkedList();
        if (list.size() > 46) {
            ArrayList arrayList = new ArrayList();
            LinkedList linkedList = new LinkedList(this.arraySet);
            int n = 0;
            while (n < 40) {
                arrayList.add(list.get(n));
                this.indexToSlotList.add(new Integer(n));
                ++n;
            }
            arrayList.add("[...]");
            this.indexToSlotList.add(new Integer(-2));
            if (linkedList.size() > 0) {
                while (linkedList.size() > 0) {
                    Integer n2 = (Integer)linkedList.removeFirst();
                    arrayList.add(list.get(n2));
                    this.indexToSlotList.add(new Integer(n2));
                }
                arrayList.add("[...]");
                this.indexToSlotList.add(new Integer(-2));
            }
            int n3 = 5;
            while (n3 > 0) {
                arrayList.add(list.get(list.size() - n3));
                this.indexToSlotList.add(new Integer(list.size() - n3));
                --n3;
            }
            return arrayList;
        }
        int n = 0;
        while (n < list.size()) {
            this.indexToSlotList.add(new Integer(n));
            ++n;
        }
        return list;
    }

    private int indexToSlot(int n) {
        Integer n2 = (Integer)this.indexToSlotList.get(n);
        return n2;
    }

    private void selectArrayElement() {
        block7: {
            String string = DialogManager.askString(this, "ask-index");
            if (string != null) {
                try {
                    int n = Integer.parseInt(string);
                    if (n >= 0 && n < this.obj.getInstanceFieldCount()) {
                        if (this.obj.instanceFieldIsObject(n)) {
                            this.setCurrentObj(this.obj.getInstanceFieldObject(n), this.obj.getInstanceFieldName(n));
                            this.setButtonsEnabled(true, false);
                        } else {
                            this.setButtonsEnabled(false, false);
                            this.arraySet.add(new Integer(n));
                            this.update();
                        }
                        break block7;
                    }
                    DialogManager.showError(this, "out-of-bounds");
                }
                catch (NumberFormatException numberFormatException) {
                    this.setCurrentObj(null, null);
                    DialogManager.showError(this, "cannot-access-element");
                }
            } else {
                this.setCurrentObj(null, null);
            }
        }
    }

    private void doInspect() {
        if (this.queryArrayElementSelected) {
            this.selectArrayElement();
        }
        if (this.selectedObject != null) {
            boolean bl = this.getBtn.isEnabled();
            ObjectViewer objectViewer = ObjectViewer.getViewer(true, this.selectedObject, null, this.pkg, bl, this);
            if (bl) {
                objectViewer.addToScope(this.viewerId, this.selectedObjectName);
            }
        }
    }

    private void doGet() {
        this.pkg.getEditor().raisePutOnBenchEvent(this.selectedObject, this.viewerId, this.selectedObjectName);
    }

    protected void addToScope(String string, String string2) {
        Debugger.debugger.addObjectToScope(this.pkgScopeId, string, string2, this.viewerId);
        this.isInScope = true;
    }

    private void doClose() {
        ((Component)this).setVisible(false);
        this.dispose();
        viewers.remove(this.obj);
        if (this.isInScope && this.viewerId.charAt(0) == '#') {
            Debugger.debugger.removeObjectFromScope(this.pkgScopeId, this.viewerId);
        }
    }

    private void calculateListSize(DebuggerObject debuggerObject, JList jList, JList jList2) {
    }

    private void makeFrame(JFrame jFrame, boolean bl, DebuggerObject debuggerObject) {
        JComponent jComponent;
        Object object;
        String string = "";
        if (bl) {
            string = JavaNames.stripPrefix(debuggerObject.getClassName());
            this.setTitle(inspectTitle + " " + string);
        } else {
            this.setTitle(resultTitle);
        }
        ((Component)this).setBackground(bgColor);
        ObjectViewer objectViewer = this;
        if (objectViewer == null) {
            throw null;
        }
        this.addWindowListener(new WindowAdapter(objectViewer){
            private final /* synthetic */ ObjectViewer this$0;

            public void windowClosing(WindowEvent windowEvent) {
                ObjectViewer.access$0(this.this$0);
            }
            {
                this.this$0 = objectViewer;
                this.constructor$0(objectViewer);
            }

            private final void constructor$0(ObjectViewer objectViewer) {
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(Config.generalBorder);
        if (bl) {
            object = new JPanel();
            ((JComponent)object).setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            jComponent = new JLabel(objectClassName + " " + string);
            ((Container)object).add((Component)jComponent, "Center");
            jPanel.add((Component)object, "North");
            if (!debuggerObject.isArray()) {
                this.staticFieldList = new JList(new DefaultListModel());
                this.staticFieldList.setSelectionMode(0);
                this.staticFieldList.addListSelectionListener(this);
                this.staticScrollPane = new JScrollPane(this.staticFieldList);
                this.staticScrollPane.setColumnHeaderView(new JLabel(staticListTitle));
            }
        }
        this.objFieldList = new JList(new DefaultListModel());
        this.objFieldList.setSelectionMode(0);
        this.objFieldList.addListSelectionListener(this);
        this.objectScrollPane = new JScrollPane(this.objFieldList);
        if (bl) {
            this.objectScrollPane.setColumnHeaderView(new JLabel(objListTitle));
        } else {
            this.objFieldList.setVisibleRowCount(4);
        }
        if (bl && !debuggerObject.isArray()) {
            this.listPane = new JSplitPane(0);
            this.listPane.setTopComponent(this.staticScrollPane);
            this.listPane.setBottomComponent(this.objectScrollPane);
            this.listPane.setDividerSize(3);
            this.listPane.resetToPreferredSizes();
            jPanel.add((Component)this.listPane, "Center");
        } else {
            jPanel.add(this.objectScrollPane);
        }
        ObjectViewer objectViewer2 = this;
        if (objectViewer2 == null) {
            throw null;
        }
        object = new MouseAdapter(objectViewer2){
            private final /* synthetic */ ObjectViewer this$0;

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    ObjectViewer.access$1(this.this$0);
                }
            }
            {
                this.this$0 = objectViewer;
                this.constructor$0(objectViewer);
            }

            private final void constructor$0(ObjectViewer objectViewer) {
            }
        };
        this.objFieldList.addMouseListener((MouseListener)object);
        if (this.staticFieldList != null) {
            this.staticFieldList.addMouseListener((MouseListener)object);
        }
        jComponent = new JPanel();
        jComponent.setLayout(new GridLayout(0, 1));
        this.inspectBtn = new JButton(inspectLabel);
        this.inspectBtn.addActionListener(this);
        this.inspectBtn.setEnabled(false);
        jComponent.add(this.inspectBtn);
        this.getBtn = new JButton(getLabel);
        this.getBtn.setEnabled(false);
        this.getBtn.addActionListener(this);
        jComponent.add(this.getBtn);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        jPanel2.add((Component)jComponent, "North");
        jPanel.add((Component)jPanel2, "East");
        this.inspectorTabs = new JTabbedPane();
        this.initInspectors(this.inspectorTabs);
        if (this.inspectorTabs.getTabCount() > 0) {
            this.inspectorTabs.insertTab("Standard", null, jPanel, "Standard", 0);
            ((JPanel)this.getContentPane()).add((Component)this.inspectorTabs, "Center");
        } else {
            this.inspectorTabs = null;
            ((JPanel)this.getContentPane()).add((Component)jPanel, "Center");
        }
        jComponent = new JPanel();
        jComponent.setLayout(new FlowLayout());
        jComponent.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        JButton jButton = new JButton(close);
        jComponent.add(jButton);
        jButton.addActionListener(this);
        this.getRootPane().setDefaultButton(jButton);
        ((JPanel)this.getContentPane()).add((Component)jComponent, "South");
        if (bl) {
            DialogManager.tileWindow(this, jFrame);
        } else {
            DialogManager.centreWindow(this, jFrame);
        }
        jButton.requestFocus();
    }

    private void initInspectors(JTabbedPane jTabbedPane) {
        if (inspCnt == 0) {
            this.loadInspectors(Config.getSystemInspectorDir());
        }
        Project project = null;
        if (this.pkg != null) {
            project = this.pkg.getProject();
        } else if (Project.getOpenProjectCount() == 1) {
            project = Project.getProject();
        }
        if (project != null && !loadedProjects.contains(project.getProjectDir())) {
            loadedProjects.add(project.getProjectDir());
            this.loadInspectors(new File(project.getProjectDir(), inspectorDirectoryName));
        }
        this.addInspectors(jTabbedPane);
    }

    private void loadInspectors(File file) {
        InspectorClassLoader inspectorClassLoader = new InspectorClassLoader(file);
        String[] stringArray = file.list();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                try {
                    if (stringArray[n].endsWith(".class")) {
                        try {
                            Class<?> clazz = inspectorClassLoader.loadClass(stringArray[n].substring(0, stringArray[n].length() - 6));
                            Inspector inspector = (Inspector)clazz.newInstance();
                            int n2 = inspCnt++;
                            if (inspCnt >= insp.length) {
                                Class[] classArray = new Class[insp.length * 2];
                                System.arraycopy(insp, 0, classArray, 0, insp.length);
                                insp = classArray;
                            }
                            ObjectViewer.insp[n2] = clazz;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                        }
                        catch (InstantiationException instantiationException) {
                        }
                        catch (IllegalAccessException illegalAccessException) {
                        }
                        catch (ClassCastException classCastException) {}
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                ++n;
            }
        }
    }

    private void addInspectors(JTabbedPane jTabbedPane) {
        int n = 0;
        while (n < inspCnt) {
            try {
                Inspector inspector = (Inspector)insp[n].newInstance();
                String[] stringArray = inspector.getInspectedClassnames();
                int n2 = 0;
                while (n2 < stringArray.length) {
                    if (this.obj.isAssignableTo(stringArray[n2])) {
                        boolean bl = inspector.initialize(this.obj);
                        if (bl) {
                            inspector.addInspectorListener(this);
                            jTabbedPane.add(inspector.getInspectorTitle(), inspector);
                        }
                        break;
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n;
        }
    }

    static /* synthetic */ void access$0(ObjectViewer objectViewer) {
        objectViewer.doClose();
    }

    static /* synthetic */ void access$1(ObjectViewer objectViewer) {
        objectViewer.doInspect();
    }

    protected ObjectViewer(boolean bl, DebuggerObject debuggerObject, Package package_, String string, boolean bl2, JFrame jFrame) {
        ((Frame)this).setIconImage(Config.frameImage);
        this.isInspection = bl;
        this.obj = debuggerObject;
        this.pkg = package_;
        this.viewerId = string;
        this.getEnabled = bl2;
        this.isInScope = false;
        if (package_ == null) {
            if (bl2) {
                Debug.reportError("cannot enable 'get' with null package");
            }
            this.pkgScopeId = "";
        } else {
            this.pkgScopeId = package_.getId();
        }
        this.makeFrame(jFrame, this.isInspection, debuggerObject);
    }
}

