/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger;

import bluej.BlueJEvent;
import bluej.Config;
import bluej.debugger.DebuggerObject;
import bluej.debugger.Invoker;
import bluej.debugger.ObjectBench;
import bluej.debugger.ObjectViewer;
import bluej.debugger.ResultWatcher;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.prefmgr.PrefMgr;
import bluej.utility.Debug;
import bluej.utility.JavaNames;
import bluej.utility.Utility;
import bluej.views.MethodView;
import bluej.views.View;
import bluej.views.ViewFilter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class ObjectWrapper
extends JComponent
implements ActionListener {
    static final Color shadow = Config.getItemColour("colour.wrapper.shadow");
    static final Color bg = Config.getItemColour("colour.wrapper.bg");
    static final Color envOpColour = Config.getItemColour("colour.menu.environOp");
    static final Color umlbg = Config.getItemColour("colour.uml.wrapper.bg");
    static final Color umlShadow = Config.getItemColour("colour.uml.wrapper.shadow");
    static final Color umlText = Color.white;
    public static final int WIDTH = 100;
    public static final int HEIGHT = 70;
    public static final int UML_WORD_GAP = 25;
    private static int itemHeight = 19;
    private static boolean itemHeightKnown = false;
    private static int itemsOnScreen;
    static String methodException;
    static String invocationException;
    static String inspect;
    static String remove;
    static String redefinedIn;
    static String inheritedFrom;
    static String serializable;
    private DebuggerObject obj;
    protected String className;
    protected String instanceName;
    private String displayClassName;
    private JPopupMenu menu;
    private Method[] methods;
    private Package pkg;
    private PkgMgrFrame pmf;
    private Hashtable methodsUsed;
    private Hashtable actions;

    public Package getPackage() {
        return this.pkg;
    }

    public PkgMgrFrame getFrame() {
        return this.pmf;
    }

    private void createMenu(String string) {
        Object object;
        Class clazz = this.pkg.loadClass(string);
        List list = this.getClassHierarchy(clazz);
        this.menu = new JPopupMenu(this.instanceName + " operations");
        if (clazz != null) {
            object = View.getView(clazz);
            this.actions = new Hashtable();
            this.methodsUsed = new Hashtable();
            ViewFilter viewFilter = new ViewFilter(196613);
            this.menu.addSeparator();
            MethodView[] methodViewArray = ((View)object).getDeclaredMethods();
            int n = itemsOnScreen - 8 - list.size();
            this.createMenuItems(this.menu, methodViewArray, viewFilter, 0, methodViewArray.length, n);
            int n2 = 1;
            while (n2 < list.size()) {
                Class clazz2 = (Class)list.get(n2);
                object = View.getView(clazz2);
                methodViewArray = ((View)object).getDeclaredMethods();
                JMenu jMenu = new JMenu(inheritedFrom + " " + JavaNames.stripPrefix(clazz2.getName()));
                jMenu.setFont(PrefMgr.getStandoutMenuFont());
                this.createMenuItems(jMenu, methodViewArray, viewFilter, 0, methodViewArray.length, itemsOnScreen / 2);
                this.menu.insert(jMenu, 0);
                ++n2;
            }
            this.menu.addSeparator();
        }
        object = new JMenuItem(inspect);
        this.menu.add((JMenuItem)object);
        ((AbstractButton)object).addActionListener(this);
        ((JComponent)object).setFont(PrefMgr.getStandoutMenuFont());
        ((JComponent)object).setForeground(envOpColour);
        object = new JMenuItem(remove);
        this.menu.add((JMenuItem)object);
        ((AbstractButton)object).addActionListener(this);
        ((JComponent)object).setFont(PrefMgr.getStandoutMenuFont());
        ((JComponent)object).setForeground(envOpColour);
        this.add(this.menu);
    }

    private void createMenuItems(JComponent jComponent, MethodView[] methodViewArray, ViewFilter viewFilter, int n, int n2, int n3) {
        Arrays.sort(methodViewArray);
        int n4 = n;
        while (n4 < n2) {
            try {
                MethodView methodView = methodViewArray[n4];
                if (viewFilter.accept(methodView)) {
                    String string;
                    if (this.methodsUsed.containsKey(methodView.getSignature())) {
                        string = methodView.getSignature() + "   [ " + redefinedIn + " " + JavaNames.stripPrefix((String)this.methodsUsed.get(methodView.getSignature())) + " ]";
                    } else {
                        string = methodView.getSignature();
                        this.methodsUsed.put(methodView.getSignature(), methodView.getClassName());
                    }
                    JMenuItem jMenuItem = new JMenuItem(string);
                    jMenuItem.addActionListener(this);
                    jMenuItem.setFont(PrefMgr.getPopupMenuFont());
                    this.actions.put(jMenuItem, methodView);
                    int n5 = jComponent instanceof JMenu ? ((JMenu)jComponent).getMenuComponentCount() : jComponent.getComponentCount();
                    if (n5 >= n3) {
                        JMenu jMenu = new JMenu("more methods");
                        jMenu.setFont(PrefMgr.getStandoutMenuFont());
                        jMenu.setForeground(envOpColour);
                        jComponent.add(jMenu);
                        jComponent = jMenu;
                        n3 = itemsOnScreen / 2;
                    }
                    jComponent.add(jMenuItem);
                }
            }
            catch (Exception exception) {
                Debug.reportError(methodException + exception);
                exception.printStackTrace();
            }
            ++n4;
        }
    }

    public List getClassHierarchy(Class clazz) {
        Class clazz2 = clazz;
        ArrayList arrayList = new ArrayList();
        while (clazz2 != null) {
            arrayList.add(clazz2);
            clazz2 = clazz2.getSuperclass();
        }
        return arrayList;
    }

    public Dimension getMinimumSize() {
        return new Dimension(100, 70);
    }

    public Dimension getPreferredSize() {
        return new Dimension(100, 70);
    }

    public String getName() {
        return this.instanceName;
    }

    public void setName(String string) {
        this.instanceName = string;
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (PrefMgr.isUML()) {
            this.drawUMLStyle(graphics2D);
        } else {
            this.drawBlueStyle(graphics2D);
        }
    }

    private void drawBlueStyle(Graphics2D graphics2D) {
        graphics2D.setFont(PrefMgr.getStandardFont());
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        graphics2D.setColor(shadow);
        graphics2D.fillOval(10, 5, 90, 65);
        graphics2D.setColor(bg);
        graphics2D.fillOval(10, 5, 85, 60);
        graphics2D.setColor(Color.black);
        graphics2D.drawOval(10, 5, 85, 60);
        graphics2D.setColor(Color.white);
        Utility.drawCentredText(graphics2D, this.displayClassName, 10, 5, 85, 65);
        int n = fontMetrics.stringWidth(this.instanceName) + 10;
        int n2 = fontMetrics.getAscent() + 4;
        graphics2D.fillRect(0, 10, n, n2);
        graphics2D.setColor(Color.black);
        graphics2D.drawRect(0, 10, n, n2);
        Utility.drawCentredText(graphics2D, this.instanceName, 0, 10, n, n2);
    }

    private void drawUMLStyle(Graphics2D graphics2D) {
        graphics2D.setFont(PrefMgr.getStandardFont());
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        graphics2D.setColor(shadow);
        graphics2D.fillRoundRect(10, 10, 90, 55, 8, 8);
        graphics2D.setColor(umlbg);
        graphics2D.fillRoundRect(5, 5, 90, 55, 8, 8);
        graphics2D.setColor(Color.black);
        graphics2D.drawRoundRect(5, 5, 90, 55, 8, 8);
        graphics2D.setColor(umlText);
        int n = 80;
        String string = this.instanceName + ":";
        int n2 = fontMetrics.getAscent() + 4;
        int n3 = fontMetrics.stringWidth(string);
        if (n3 > n) {
            n3 = n;
        }
        Utility.drawCentredText(graphics2D, this.instanceName + ":", 10, 10, 80, n2);
        int n4 = (100 - n3) / 2;
        int n5 = n2 + 12;
        graphics2D.drawLine(n4, n5, n4 + n3, n5);
        n3 = fontMetrics.stringWidth(this.displayClassName);
        if (n3 > n) {
            n3 = n;
        }
        Utility.drawCentredText(graphics2D, this.displayClassName, 10, 35, 80, n2);
        n4 = (100 - n3) / 2;
        graphics2D.drawLine(n4, n5 += 25, n4 + n3, n5);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (this.isPopupEvent(mouseEvent)) {
            int n;
            if (this.menu == null) {
                return;
            }
            if (!itemHeightKnown && (n = ((JComponent)this.menu.getComponent(0)).getHeight()) > 1) {
                itemHeight = n;
                itemsOnScreen = (int)Config.screenBounds.getHeight() / itemHeight;
                itemHeightKnown = true;
            }
            int n2 = (this.menu.getComponentCount() - 4) * itemHeight;
            this.menu.show(this, mouseEvent.getX(), mouseEvent.getY() - n2);
        } else if (mouseEvent.getID() == 500) {
            if (mouseEvent.getClickCount() > 1) {
                this.inspectObject();
            } else {
                ObjectBench objectBench = (ObjectBench)this.getParent();
                objectBench.fireObjectEvent(this);
            }
        }
    }

    private boolean isPopupEvent(MouseEvent mouseEvent) {
        return mouseEvent.isPopupTrigger() || mouseEvent.getID() == 501 && mouseEvent.isControlDown();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        MethodView methodView = (MethodView)this.actions.get(actionEvent.getSource());
        if (methodView != null) {
            this.executeMethod(methodView);
        } else {
            String string = actionEvent.getActionCommand();
            if (inspect.equals(string)) {
                this.inspectObject();
            } else if (remove.equals(string)) {
                ObjectBench objectBench = (ObjectBench)this.getParent();
                objectBench.remove(this, this.pkg.getId());
            }
        }
    }

    private void inspectObject() {
        ObjectViewer objectViewer = ObjectViewer.getViewer(true, this.obj, this.instanceName, this.pkg, true, this.pmf);
    }

    private void executeMethod(MethodView methodView) {
        ResultWatcher resultWatcher = null;
        this.pkg.forgetLastSource();
        if (!methodView.isVoid()) {
            ObjectWrapper objectWrapper = this;
            if (objectWrapper == null) {
                throw null;
            }
            resultWatcher = new ResultWatcher(objectWrapper){
                private final /* synthetic */ ObjectWrapper this$0;

                public void putResult(DebuggerObject debuggerObject, String string) {
                    ObjectViewer objectViewer = ObjectViewer.getViewer(false, debuggerObject, string, ObjectWrapper.access$0(this.this$0), true, ObjectWrapper.access$1(this.this$0));
                    BlueJEvent.raiseEvent(2, objectViewer.getResult());
                }
                {
                    this.this$0 = objectWrapper;
                    this.constructor$0(objectWrapper);
                }

                private final void constructor$0(ObjectWrapper objectWrapper) {
                }
            };
        }
        Invoker invoker = new Invoker(this.pmf, methodView, this.instanceName, resultWatcher);
    }

    static /* synthetic */ Package access$0(ObjectWrapper objectWrapper) {
        return objectWrapper.pkg;
    }

    static /* synthetic */ PkgMgrFrame access$1(ObjectWrapper objectWrapper) {
        return objectWrapper.pmf;
    }

    public ObjectWrapper(PkgMgrFrame pkgMgrFrame, DebuggerObject debuggerObject, String string) {
        int n;
        if (pkgMgrFrame.isEmptyFrame()) {
            throw new IllegalArgumentException();
        }
        this.pmf = pkgMgrFrame;
        this.pkg = pkgMgrFrame.getPackage();
        this.obj = debuggerObject;
        this.instanceName = string;
        if (!itemHeightKnown) {
            itemsOnScreen = (int)Config.screenBounds.getHeight() / itemHeight;
        }
        this.className = debuggerObject.getClassName();
        if (!debuggerObject.isArray()) {
            this.createMenu(this.className);
        }
        this.displayClassName = (n = this.className.lastIndexOf(46)) >= 0 ? this.className.substring(n + 1) : this.className;
        this.enableEvents(16L);
        this.setSize(100, 70);
    }

    static {
        methodException = Config.getString("debugger.objectwrapper.methodException");
        invocationException = Config.getString("debugger.objectwrapper.invocationException");
        inspect = Config.getString("debugger.objectwrapper.inspect");
        remove = Config.getString("debugger.objectwrapper.remove");
        redefinedIn = Config.getString("debugger.objectwrapper.redefined");
        inheritedFrom = Config.getString("debugger.objectwrapper.inherited");
        serializable = Config.getString("debugger.objectwrapper.serializable");
    }
}

