/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.jdi;

import bluej.BlueJEvent;
import bluej.Config;
import bluej.debugger.Debugger;
import bluej.debugger.DebuggerClassLoader;
import bluej.debugger.DebuggerObject;
import bluej.debugger.DebuggerThread;
import bluej.debugger.ExceptionDescription;
import bluej.debugger.jdi.JdiClassLoader;
import bluej.debugger.jdi.JdiObject;
import bluej.debugger.jdi.JdiThread;
import bluej.debugger.jdi.VMEventHandler;
import bluej.terminal.Terminal;
import bluej.utility.Debug;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Bootstrap;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidLineNumberException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.LaunchingConnector;
import com.sun.jdi.connect.VMStartException;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.EventRequestManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public final class JdiDebugger
extends Debugger {
    static final String SERVER_CLASSNAME = "bluej.runtime.ExecServer";
    static final String SERVER_FIELD_NAME = "server";
    static final String TERMINATE_FIELD_NAME = "terminateExc";
    static final String EXIT_FIELD_NAME = "exitExc";
    static final String EXIT_MARKER_METHOD_NAME = "exitMarker";
    static final String SERVER_SUSPEND_METHOD_NAME = "suspendExecution";
    static final String SERVER_PERFORM_METHOD_NAME = "performTask";
    private VirtualMachine machine = null;
    private Process process = null;
    private VMEventHandler eventHandler = null;
    private ReferenceType serverClass = null;
    private ObjectReference execServer = null;
    private ObjectReference exitException = null;
    private Method performTaskMethod = null;
    private ThreadReference serverThread = null;
    private volatile boolean initialised = false;
    private int machineStatus = 0;
    private List savedBreakpoints;
    private int exitStatus;
    private ExceptionDescription lastException;
    private Object executionUserParam = null;

    private synchronized VirtualMachine getVM() {
        while (!this.initialised) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.machine;
    }

    public synchronized void startDebugger() {
        if (this.initialised) {
            return;
        }
        BlueJEvent.raiseEvent(0, null);
        VirtualMachineManager virtualMachineManager = Bootstrap.virtualMachineManager();
        LaunchingConnector launchingConnector = virtualMachineManager.defaultConnector();
        Map<String, Connector.Argument> map = launchingConnector.defaultArguments();
        Connector.Argument argument = map.get("main");
        Connector.Argument argument2 = map.get("options");
        Connector.Argument argument3 = map.get("quote");
        if (argument == null || argument2 == null || argument3 == null) {
            Debug.reportError("Cannot start virtual machine.");
            Debug.reportError("(Incompatible launch connector)");
            return;
        }
        argument.setValue(SERVER_CLASSNAME);
        try {
            String string = Config.getSystemPropString("VmOptions");
            String string2 = argument3.value() + System.getProperty("java.class.path") + argument3.value();
            argument2.setValue(string + " -classpath " + string2);
            this.machine = launchingConnector.launch(map);
            this.process = this.machine.process();
            InputStreamReader inputStreamReader = new InputStreamReader(this.process.getErrorStream());
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(System.out);
            this.redirectIOStream(inputStreamReader, outputStreamWriter, false);
            InputStreamReader inputStreamReader2 = new InputStreamReader(this.process.getInputStream());
            Writer writer = Terminal.getTerminal().getWriter();
            this.redirectIOStream(inputStreamReader2, writer, false);
            OutputStreamWriter outputStreamWriter2 = new OutputStreamWriter(this.process.getOutputStream());
            Reader reader = Terminal.getTerminal().getReader();
            this.redirectIOStream(reader, outputStreamWriter2, false);
        }
        catch (VMStartException vMStartException) {
            Debug.reportError("Target VM did not initialise.");
            Debug.reportError("(check the 'VmOptions' setting in 'bluej.defs'.)");
            Debug.reportError(vMStartException.getMessage() + "\n");
            this.dumpFailedLaunchInfo(vMStartException.process());
        }
        catch (Exception exception) {
            Debug.reportError("Unable to launch target VM.");
            exception.printStackTrace();
        }
        this.setEventRequests(this.machine);
        this.eventHandler = new VMEventHandler(this, this.machine);
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.initialised = true;
        this.notifyAll();
        BlueJEvent.raiseEvent(1, null);
    }

    protected synchronized void endDebugger() {
        block6: {
            try {
                if (this.machine == null) break block6;
                try {
                    this.machine.dispose();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.machine = null;
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                if (this.process != null) {
                    this.process.destroy();
                    this.process = null;
                }
                throw throwable;
            }
        }
        Object var2_2 = null;
        if (this.process != null) {
            this.process.destroy();
            this.process = null;
        }
    }

    void serverClassAddBreakpoints() {
        EventRequestManager eventRequestManager = this.machine.eventRequestManager();
        this.serverClass = this.findClassByName(this.machine, SERVER_CLASSNAME, null);
        Method method = this.findMethodByName(this.serverClass, SERVER_SUSPEND_METHOD_NAME);
        if (method == null) {
            Debug.reportError("invalid VM server object");
            Debug.reportError("Fatal: User code execution will not work");
            return;
        }
        Location location = method.location();
        BreakpointRequest breakpointRequest = eventRequestManager.createBreakpointRequest(location);
        breakpointRequest.setSuspendPolicy(1);
        breakpointRequest.putProperty("isBluejBreak", "true");
        breakpointRequest.enable();
        Method method2 = this.findMethodByName(this.serverClass, EXIT_MARKER_METHOD_NAME);
        Location location2 = method2.location();
        BreakpointRequest breakpointRequest2 = eventRequestManager.createBreakpointRequest(location2);
        breakpointRequest2.setSuspendPolicy(0);
        breakpointRequest2.putProperty("isExitMarker", "true");
        breakpointRequest2.enable();
    }

    void serverClassPrepared() {
        EventRequestManager eventRequestManager = this.machine.eventRequestManager();
        List<ClassPrepareRequest> list = eventRequestManager.classPrepareRequests();
        if (list.size() != 1) {
            Debug.reportError("oops - found more than one prepare request!");
        }
        ClassPrepareRequest classPrepareRequest = list.get(0);
        eventRequestManager.deleteEventRequest(classPrepareRequest);
        this.serverClassAddBreakpoints();
    }

    public DebuggerClassLoader createClassLoader(String string, String string2) {
        ClassLoaderReference classLoaderReference = (ClassLoaderReference)this.startServer(0, string, string2, "", "");
        return new JdiClassLoader(string, classLoaderReference);
    }

    public void removeClassLoader(DebuggerClassLoader debuggerClassLoader) {
        this.startServer(1, debuggerClassLoader.getId(), "", "", "");
    }

    public int getStatus() {
        return this.machineStatus;
    }

    public void startClass(DebuggerClassLoader debuggerClassLoader, String string, Object object) {
        this.loadClass(debuggerClassLoader, string);
        ClassType classType = this.findClassByName(this.machine, string, debuggerClassLoader);
        Method method = this.findMethodByName(classType, "run");
        if (method == null) {
            Debug.reportError("Could not find shell run method");
            return;
        }
        ArrayList arrayList = new ArrayList();
        try {
            this.exitStatus = 0;
            this.executionUserParam = object;
            this.machineStatus = 1;
            Value value = classType.invokeMethod(this.serverThread, method, arrayList, 0);
            this.resumeMachine();
        }
        catch (InvocationException invocationException) {
            this.resumeMachine();
        }
        catch (Exception exception) {
            Debug.reportError("starting shell class failed: " + exception);
            this.exitStatus = 2;
            this.lastException = new ExceptionDescription("Internal BlueJ error!", "Cannot execute remote command", null);
        }
        this.machineStatus = 0;
    }

    private void loadClass(DebuggerClassLoader debuggerClassLoader, String string) {
        this.startServer(2, debuggerClassLoader.getId(), string, "", "");
    }

    public void addObjectToScope(String string, String string2, String string3, String string4) {
        this.startServer(3, string, string2, string3, string4);
    }

    public void removeObjectFromScope(String string, String string2) {
        this.startServer(4, string, string2, "", "");
    }

    public void setLibraries(String string) {
        this.startServer(5, string, "", "", "");
    }

    public void setDirectory(String string) {
        this.startServer(6, string, "", "", "");
    }

    public void serializeObject(String string, String string2, String string3) {
        this.startServer(7, string, string2, string3, "");
    }

    public DebuggerObject deserializeObject(String string, String string2, String string3, String string4) {
        ObjectReference objectReference = (ObjectReference)this.startServer(8, string, string2, string3, string4);
        if (objectReference == null) {
            return null;
        }
        return JdiObject.getDebuggerObject(objectReference);
    }

    public void disposeWindows() {
        this.startServer(11, "", "", "", "");
    }

    public void supressErrorOutput() {
        this.startServer(9, "", "", "", "");
    }

    public void restoreErrorOutput() {
        this.startServer(10, "", "", "", "");
    }

    private Value startServer(int n, String string, String string2, String string3, String string4) {
        VirtualMachine virtualMachine = this.getVM();
        if (this.execServer == null && !this.setupServerConnection(virtualMachine)) {
            return null;
        }
        try {
            ArrayList<Value> arrayList = new ArrayList<Value>(5);
            arrayList.add(virtualMachine.mirrorOf(n));
            arrayList.add(virtualMachine.mirrorOf(string));
            arrayList.add(virtualMachine.mirrorOf(string2));
            arrayList.add(virtualMachine.mirrorOf(string3));
            arrayList.add(virtualMachine.mirrorOf(string4));
            Value value = this.execServer.invokeMethod(this.serverThread, this.performTaskMethod, arrayList, 0);
            this.resumeMachine();
            return value;
        }
        catch (InternalException internalException) {
        }
        catch (Exception exception) {
            Debug.message("sending command to remote VM failed: " + exception);
            Debug.message("task: " + n + " " + string + " " + string2);
        }
        return null;
    }

    private boolean setupServerConnection(VirtualMachine virtualMachine) {
        if (this.serverClass == null) {
            Debug.reportError("server class not initialised!");
        }
        Field field = this.serverClass.fieldByName(SERVER_FIELD_NAME);
        this.execServer = (ObjectReference)this.serverClass.getValue(field);
        if (this.execServer == null) {
            this.sleep(3000);
            this.execServer = (ObjectReference)this.serverClass.getValue(field);
        }
        if (this.execServer == null) {
            Debug.reportError("Failed to load VM server object");
            Debug.reportError("Fatal: User code execution will not work");
            return false;
        }
        Field field2 = this.serverClass.fieldByName(TERMINATE_FIELD_NAME);
        ObjectReference objectReference = (ObjectReference)this.serverClass.getValue(field2);
        JdiThread.setTerminateException(objectReference);
        Field field3 = this.serverClass.fieldByName(EXIT_FIELD_NAME);
        this.exitException = (ObjectReference)this.serverClass.getValue(field3);
        this.performTaskMethod = this.findMethodByName(this.serverClass, SERVER_PERFORM_METHOD_NAME);
        if (this.performTaskMethod == null) {
            Debug.reportError("invalid VM server object");
            Debug.reportError("Fatal: User code execution will not work");
            return false;
        }
        List<ThreadReference> list = virtualMachine.allThreads();
        int n = 0;
        while (n < list.size()) {
            ThreadReference threadReference = list.get(n);
            if ("main".equals(threadReference.name())) {
                this.serverThread = threadReference;
            }
            ++n;
        }
        if (this.serverThread == null) {
            Debug.reportError("Cannot find server thread on remote VM");
            Debug.reportError("Fatal: User code execution will not work");
            return false;
        }
        return true;
    }

    public DebuggerObject getStaticValue(String string, String string2) throws Exception {
        JdiObject jdiObject = null;
        ClassType classType = this.findClassByName(this.getVM(), string, null);
        if (classType == null) {
            Debug.reportError("Cannot find class for result value");
            jdiObject = null;
        } else {
            Field field = classType.fieldByName(string2);
            ObjectReference objectReference = (ObjectReference)classType.getValue(field);
            jdiObject = JdiObject.getDebuggerObject(objectReference);
        }
        return jdiObject;
    }

    public int getExitStatus() {
        return this.exitStatus;
    }

    public ExceptionDescription getException() {
        return this.lastException;
    }

    public void exceptionEvent(ExceptionEvent exceptionEvent) {
        String string;
        String string2 = exceptionEvent.exception().type().name();
        ObjectReference objectReference = exceptionEvent.exception();
        if (string2.equals("bluej.runtime.TerminateException")) {
            this.disposeWindows();
            this.exitStatus = 3;
            this.machineStatus = 0;
            this.lastException = null;
            return;
        }
        Field field = objectReference.referenceType().fieldByName("detailMessage");
        StringReference stringReference = (StringReference)objectReference.getValue(field);
        String string3 = string = stringReference == null ? null : stringReference.value();
        if (string2.equals("bluej.runtime.ExitException")) {
            this.exitStatus = 1;
            this.machineStatus = 0;
            this.lastException = new ExceptionDescription(string);
        } else {
            Location location = exceptionEvent.location();
            String string4 = location.declaringType().name();
            try {
                String string5 = location.sourceName();
            }
            catch (Exception exception) {
                Object var9_10 = null;
            }
            int n = location.lineNumber();
            List list = new JdiThread(exceptionEvent.thread(), null).getStack();
            this.exitStatus = 2;
            this.lastException = new ExceptionDescription(string2, string, list);
        }
    }

    public void breakEvent(LocatableEvent locatableEvent, boolean bl) {
        if ("true".equals(locatableEvent.request().getProperty("isBluejBreak"))) {
            JdiDebugger jdiDebugger = this;
            synchronized (jdiDebugger) {
                this.notifyAll();
            }
        } else if ("true".equals(locatableEvent.request().getProperty("isExitMarker"))) {
            if (!this.serverThread.isSuspended()) {
                try {
                    this.serverThread.stop(this.exitException);
                }
                catch (InvalidTypeException invalidTypeException) {}
            }
        } else {
            this.machineStatus = 2;
            ThreadReference threadReference = locatableEvent.thread();
            JdiThread jdiThread = new JdiThread(threadReference, this.executionUserParam);
            if (jdiThread.getClassSourceName(0).startsWith("__SHELL")) {
                this.getVM().resume();
            } else if (bl) {
                BlueJEvent.raiseEvent(8, jdiThread);
            } else {
                BlueJEvent.raiseEvent(9, jdiThread);
            }
        }
    }

    private String setBreakpoint(String string, int n, DebuggerClassLoader debuggerClassLoader) throws AbsentInformationException {
        this.loadClass(debuggerClassLoader, string);
        ClassType classType = this.findClassByName(this.getVM(), string, debuggerClassLoader);
        if (classType == null) {
            return "Class not found";
        }
        Location location = this.findLocationInLine(classType, n);
        if (location == null) {
            return Config.getString("debugger.jdiDebugger.noCodeMsg");
        }
        EventRequestManager eventRequestManager = this.getVM().eventRequestManager();
        BreakpointRequest breakpointRequest = eventRequestManager.createBreakpointRequest(location);
        breakpointRequest.setSuspendPolicy(1);
        breakpointRequest.enable();
        return null;
    }

    private String clearBreakpoint(String string, int n, DebuggerClassLoader debuggerClassLoader) throws AbsentInformationException {
        this.loadClass(debuggerClassLoader, string);
        ClassType classType = this.findClassByName(this.getVM(), string, debuggerClassLoader);
        if (classType == null) {
            return "Class not found";
        }
        Location location = this.findLocationInLine(classType, n);
        if (location == null) {
            return Config.getString("debugger.jdiDebugger.noCodeMsg");
        }
        EventRequestManager eventRequestManager = this.getVM().eventRequestManager();
        boolean bl = false;
        List<BreakpointRequest> list = eventRequestManager.breakpointRequests();
        int n2 = 0;
        while (n2 < list.size()) {
            BreakpointRequest breakpointRequest = list.get(n2);
            if (breakpointRequest.location().equals(location)) {
                eventRequestManager.deleteEventRequest(breakpointRequest);
                bl = true;
            }
            ++n2;
        }
        if (bl) {
            return null;
        }
        return Config.getString("debugger.jdiDebugger.noBreakpointMsg");
    }

    public String toggleBreakpoint(String string, int n, boolean bl, DebuggerClassLoader debuggerClassLoader) {
        try {
            if (bl) {
                return this.setBreakpoint(string, n, debuggerClassLoader);
            }
            return this.clearBreakpoint(string, n, debuggerClassLoader);
        }
        catch (AbsentInformationException absentInformationException) {
            return Config.getString("debugger.jdiDebugger.noLineNumberMsg");
        }
        catch (InvalidLineNumberException invalidLineNumberException) {
            return Config.getString("debugger.jdiDebugger.noCodeMsg");
        }
        catch (Exception exception) {
            Debug.reportError("breakpoint error: " + exception);
            return Config.getString("debugger.jdiDebugger.internalErrorMsg");
        }
    }

    public void saveBreakpoints() {
        VirtualMachine virtualMachine = this.getVM();
        EventRequestManager eventRequestManager = virtualMachine.eventRequestManager();
        this.savedBreakpoints = new LinkedList();
        List<BreakpointRequest> list = eventRequestManager.breakpointRequests();
        Iterator<BreakpointRequest> iterator = list.iterator();
        while (iterator.hasNext()) {
            BreakpointRequest breakpointRequest = iterator.next();
            if (breakpointRequest.location().declaringType().name().equals(SERVER_CLASSNAME)) continue;
            this.savedBreakpoints.add(breakpointRequest.location());
        }
        eventRequestManager.deleteAllBreakpoints();
        this.serverClassAddBreakpoints();
    }

    public void restoreBreakpoints(DebuggerClassLoader debuggerClassLoader) {
        VirtualMachine virtualMachine = this.getVM();
        EventRequestManager eventRequestManager = virtualMachine.eventRequestManager();
        if (this.savedBreakpoints != null) {
            Iterator iterator = this.savedBreakpoints.iterator();
            while (iterator.hasNext()) {
                Location location = (Location)iterator.next();
                try {
                    this.setBreakpoint(location.declaringType().name(), location.lineNumber(), debuggerClassLoader);
                }
                catch (Exception exception) {
                    Debug.reportError("breakpoint error: " + exception);
                }
            }
        }
        this.savedBreakpoints = null;
    }

    public Vector listThreads() {
        List<ThreadReference> list = this.getVM().allThreads();
        int n = list.size();
        Vector<JdiThread> vector = new Vector<JdiThread>();
        int n2 = 0;
        while (n2 < n) {
            ThreadReference threadReference = list.get(n - n2 - 1);
            String string = threadReference.name();
            vector.addElement(new JdiThread(threadReference));
            ++n2;
        }
        return vector;
    }

    public void halt(DebuggerThread debuggerThread) {
        this.machine.suspend();
        this.machineStatus = 2;
        if (debuggerThread != null) {
            debuggerThread.setParam(this.executionUserParam);
        }
        BlueJEvent.raiseEvent(9, debuggerThread);
    }

    public void cont() {
        this.machineStatus = 1;
        BlueJEvent.raiseEvent(10, null);
        this.resumeMachine();
    }

    public void terminate(DebuggerThread debuggerThread) {
        debuggerThread.terminate();
    }

    public void showSource(DebuggerThread debuggerThread) {
        debuggerThread.setParam(this.executionUserParam);
        BlueJEvent.raiseEvent(11, debuggerThread);
    }

    private void resumeMachine() {
        if (this.serverThreadIdle()) {
            this.serverThread.suspend();
        }
        this.getVM().resume();
    }

    private boolean serverThreadIdle() {
        try {
            return this.serverThread.isAtBreakpoint() && this.serverThread.frame(0).location().declaringType().name().equals(SERVER_CLASSNAME) && this.serverThread.suspendCount() == 1;
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            Debug.reportError("debugger thread in run-away state...");
            return false;
        }
    }

    private ClassType findClassByName(VirtualMachine virtualMachine, String string, DebuggerClassLoader debuggerClassLoader) {
        JdiClassLoader jdiClassLoader = (JdiClassLoader)debuggerClassLoader;
        List<ReferenceType> list = virtualMachine.classesByName(string);
        if (list.size() == 1) {
            return (ClassType)list.get(0);
        }
        if (list.size() > 1) {
            if (debuggerClassLoader == null) {
                Debug.reportError("found more than one class: " + string);
                return null;
            }
            Iterator<ReferenceType> iterator = list.iterator();
            while (iterator.hasNext()) {
                ClassType classType = (ClassType)iterator.next();
                if (classType.classLoader() != jdiClassLoader.getLoader()) continue;
                return classType;
            }
            Debug.reportError("cannot load class: " + string);
            Debug.reportError("classes found, but none matches loader");
            return null;
        }
        Debug.reportError("cannot find class " + string);
        return null;
    }

    private Method findMethodByName(ReferenceType referenceType, String string) {
        List<Method> list = referenceType.methodsByName(string);
        if (list.size() != 1) {
            Debug.reportError("Problem getting method: " + string);
            return null;
        }
        return list.get(0);
    }

    private Location findLocationInLine(ClassType classType, int n) throws AbsentInformationException {
        List<Location> list = classType.locationsOfLine(n);
        if (list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    private void setEventRequests(VirtualMachine virtualMachine) {
        EventRequestManager eventRequestManager = virtualMachine.eventRequestManager();
        eventRequestManager.createExceptionRequest(null, false, true).enable();
        eventRequestManager.createClassPrepareRequest().enable();
    }

    private void redirectIOStream(Reader reader, Writer writer, boolean bl) {
        Thread thread;
        if (bl) {
            JdiDebugger jdiDebugger = this;
            if (jdiDebugger == null) {
                throw null;
            }
            thread = new Thread(jdiDebugger, reader, writer, "I/O reader"){
                private final /* synthetic */ JdiDebugger this$0;
                private final /* synthetic */ Reader val$reader;
                private final /* synthetic */ Writer val$writer;

                public void run() {
                    try {
                        JdiDebugger.access$0(this.this$0, this.val$reader, this.val$writer);
                    }
                    catch (IOException iOException) {
                        Debug.reportError("Cannot read output user VM.");
                    }
                }
                {
                    this.val$reader = reader;
                    this.val$writer = writer;
                    this.this$0 = jdiDebugger;
                    this.constructor$0(jdiDebugger, string);
                }

                private final void constructor$0(JdiDebugger jdiDebugger, String string) {
                }
            };
        } else {
            JdiDebugger jdiDebugger = this;
            if (jdiDebugger == null) {
                throw null;
            }
            thread = new Thread(jdiDebugger, reader, writer, "I/O reader"){
                private final /* synthetic */ JdiDebugger this$0;
                private final /* synthetic */ Reader val$reader;
                private final /* synthetic */ Writer val$writer;

                public void run() {
                    try {
                        JdiDebugger.access$1(this.this$0, this.val$reader, this.val$writer);
                    }
                    catch (IOException iOException) {
                        Debug.reportError("Cannot read output user VM.");
                    }
                }
                {
                    this.val$reader = reader;
                    this.val$writer = writer;
                    this.this$0 = jdiDebugger;
                    this.constructor$0(jdiDebugger, string);
                }

                private final void constructor$0(JdiDebugger jdiDebugger, String string) {
                }
            };
        }
        thread.setPriority(9);
        thread.start();
    }

    private void dumpStream(Reader reader, Writer writer) throws IOException {
        int n;
        while ((n = reader.read()) != -1) {
            writer.write(n);
            writer.flush();
        }
    }

    private void dumpStreamBuffered(Reader reader, Writer writer) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(reader);
        while ((string = bufferedReader.readLine()) != null) {
            string = string + "\n";
            writer.write(string.toCharArray(), 0, string.length());
            writer.flush();
        }
    }

    private void dumpFailedLaunchInfo(Process process) {
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(process.getErrorStream());
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(System.out);
            this.dumpStream(inputStreamReader, outputStreamWriter);
        }
        catch (IOException iOException) {
            Debug.message("Unable to display process output: " + iOException.getMessage());
        }
    }

    private void sleep(int n) {
        JdiDebugger jdiDebugger = this;
        synchronized (jdiDebugger) {
            try {
                this.wait(n);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void dumpThreadInfo() {
        Debug.message("threads:");
        Debug.message("--------");
        Vector vector = this.listThreads();
        if (vector == null) {
            Debug.message("cannot get thread info!");
        } else {
            int n = 0;
            while (n < vector.size()) {
                JdiThread jdiThread = (JdiThread)vector.get(n);
                String string = jdiThread.getStatus();
                Debug.message(jdiThread.getName() + " [" + string + "]");
                try {
                    Debug.message("  group: " + jdiThread.getRemoteThread().threadGroup());
                    Debug.message("  suspend count: " + jdiThread.getRemoteThread().suspendCount());
                    Debug.message("  monitor: " + jdiThread.getRemoteThread().currentContendedMonitor());
                }
                catch (Exception exception) {
                    Debug.message("  monitor: exc: " + exception);
                }
                ++n;
            }
        }
    }

    public ThreadReference getServerThread() {
        return this.serverThread;
    }

    static /* synthetic */ void access$0(JdiDebugger jdiDebugger, Reader reader, Writer writer) throws IOException {
        jdiDebugger.dumpStreamBuffered(reader, writer);
    }

    static /* synthetic */ void access$1(JdiDebugger jdiDebugger, Reader reader, Writer writer) throws IOException {
        jdiDebugger.dumpStream(reader, writer);
    }
}

