/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.jdi;

import bluej.debugger.Debugger;
import bluej.debugger.DebuggerObject;
import bluej.debugger.jdi.JdiArray;
import bluej.utility.Debug;
import bluej.utility.JavaNames;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.Field;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.LongValue;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.List;

public class JdiObject
extends DebuggerObject {
    ObjectReference obj;
    List fields;

    public String getClassName() {
        return this.obj.referenceType().name();
    }

    public boolean isAssignableTo(String string) {
        if (this.obj == null) {
            return false;
        }
        if (this.obj.referenceType() == null) {
            return false;
        }
        if (this.obj.referenceType().name() != null && string.equals(this.obj.referenceType().name())) {
            return true;
        }
        if (this.obj.referenceType() instanceof ClassType) {
            ClassType classType = (ClassType)this.obj.referenceType();
            InterfaceType[] interfaceTypeArray = classType.allInterfaces().toArray(new InterfaceType[0]);
            int n = 0;
            while (n < interfaceTypeArray.length) {
                if (string.equals(interfaceTypeArray[n].name())) {
                    return true;
                }
                ++n;
            }
            classType = classType.superclass();
            while (classType != null) {
                if (classType.name().equals(string)) {
                    return true;
                }
                classType = classType.superclass();
            }
        } else if (this.obj.referenceType() instanceof ArrayType) {
            // empty if block
        }
        return false;
    }

    public boolean isArray() {
        return false;
    }

    public int getStaticFieldCount() {
        return this.getFieldCount(true);
    }

    public int getInstanceFieldCount() {
        return this.getFieldCount(false);
    }

    public String getStaticFieldName(int n) {
        return this.getField(true, n).name();
    }

    public String getInstanceFieldName(int n) {
        return this.getField(false, n).name();
    }

    public DebuggerObject getStaticFieldObject(int n) {
        Field field = this.getField(true, n);
        ObjectReference objectReference = (ObjectReference)this.obj.getValue(field);
        return JdiObject.getDebuggerObject(objectReference);
    }

    public DebuggerObject getInstanceFieldObject(int n) {
        Field field = this.getField(false, n);
        ObjectReference objectReference = (ObjectReference)this.obj.getValue(field);
        return JdiObject.getDebuggerObject(objectReference);
    }

    public DebuggerObject getFieldObject(int n) {
        Field field = (Field)this.fields.get(n);
        ObjectReference objectReference = (ObjectReference)this.obj.getValue(field);
        return JdiObject.getDebuggerObject(objectReference);
    }

    public DebuggerObject getFieldObject(String string) {
        Field field = this.obj.referenceType().fieldByName(string);
        ObjectReference objectReference = (ObjectReference)this.obj.getValue(field);
        return JdiObject.getDebuggerObject(objectReference);
    }

    public ObjectReference getObjectReference() {
        return this.obj;
    }

    public List getStaticFields(boolean bl) {
        return this.getFields(false, true, bl);
    }

    public List getInstanceFields(boolean bl) {
        return this.getFields(false, false, bl);
    }

    public List getAllFields(boolean bl) {
        return this.getFields(true, true, bl);
    }

    public boolean staticFieldIsPublic(int n) {
        return this.getField(true, n).isPublic();
    }

    public boolean instanceFieldIsPublic(int n) {
        return this.getField(false, n).isPublic();
    }

    public boolean staticFieldIsObject(int n) {
        return this.checkFieldForObject(true, n);
    }

    public boolean instanceFieldIsObject(int n) {
        return this.checkFieldForObject(false, n);
    }

    public boolean fieldIsObject(int n) {
        Field field = (Field)this.fields.get(n);
        Value value = this.obj.getValue(field);
        return value instanceof ObjectReference;
    }

    public Object invokeMethod(String string, String string2, List list) {
        try {
            return this.obj.invokeMethod(Debugger.debugger.getServerThread(), ((ClassType)this.obj.referenceType()).concreteMethodByName(string, string2), list, 1);
        }
        catch (Exception exception) {
            return exception.toString();
        }
    }

    private int getFieldCount(boolean bl) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.fields.size()) {
            Field field = (Field)this.fields.get(n2);
            if (field.isStatic() == bl) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    private List getFields(boolean bl, boolean bl2, boolean bl3) {
        ArrayList<String> arrayList = new ArrayList<String>(this.fields.size());
        ReferenceType referenceType = this.obj.referenceType();
        List<Field> list = referenceType.visibleFields();
        int n = 0;
        while (n < this.fields.size()) {
            Field field = (Field)this.fields.get(n);
            if (bl || field.isStatic() == bl2) {
                Value value = this.obj.getValue(field);
                String string = JdiObject.getValueString(value);
                String string2 = "";
                if (bl3) {
                    if (field.isPrivate()) {
                        string2 = "private ";
                    }
                    if (field.isProtected()) {
                        string2 = "protected ";
                    }
                    if (field.isPublic()) {
                        string2 = "public ";
                    }
                }
                string2 = string2 + JavaNames.stripPrefix(field.typeName()) + " " + field.name() + " = " + string;
                if (!list.contains(field)) {
                    string2 = string2 + " (hidden)";
                }
                arrayList.add(string2);
            }
            ++n;
        }
        return arrayList;
    }

    private Field getField(boolean bl, int n) {
        int n2 = 0;
        while (n2 < this.fields.size()) {
            Field field = (Field)this.fields.get(n2);
            if (field.isStatic() == bl) {
                if (n == 0) {
                    return field;
                }
                --n;
            }
            ++n2;
        }
        Debug.reportError("invalid slot in remote object");
        return null;
    }

    private void getRemoteFields() {
        ReferenceType referenceType = this.obj.referenceType();
        if (referenceType != null) {
            this.fields = referenceType.allFields();
        } else {
            Debug.reportError("cannot get class for remote object");
            this.fields = new ArrayList();
        }
    }

    private boolean checkFieldForObject(boolean bl, int n) {
        Field field = this.getField(bl, n);
        Value value = this.obj.getValue(field);
        return value instanceof ObjectReference;
    }

    public static JdiObject getDebuggerObject(ObjectReference objectReference) {
        if (objectReference instanceof ArrayReference) {
            return new JdiArray((ArrayReference)objectReference);
        }
        return new JdiObject(objectReference);
    }

    public static String getValueString(Value value) {
        if (value == null) {
            return "<null>";
        }
        if (value instanceof StringReference) {
            return "\"" + ((StringReference)value).value() + "\"";
        }
        if (value instanceof ObjectReference) {
            return "<object reference>";
        }
        if (value instanceof BooleanValue) {
            return String.valueOf(((BooleanValue)value).value());
        }
        if (value instanceof ByteValue) {
            return String.valueOf(((ByteValue)value).value());
        }
        if (value instanceof CharValue) {
            return String.valueOf(((CharValue)value).value());
        }
        if (value instanceof DoubleValue) {
            return String.valueOf(((DoubleValue)value).value());
        }
        if (value instanceof FloatValue) {
            return String.valueOf(((FloatValue)value).value());
        }
        if (value instanceof IntegerValue) {
            return String.valueOf(((IntegerValue)value).value());
        }
        if (value instanceof LongValue) {
            return String.valueOf(((LongValue)value).value());
        }
        if (value instanceof ShortValue) {
            return String.valueOf(((ShortValue)value).value());
        }
        return value.toString();
    }

    protected JdiObject() {
    }

    private JdiObject(ObjectReference objectReference) {
        this.obj = objectReference;
        this.getRemoteFields();
    }
}

