/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.jdi;

import bluej.debugger.Debugger;
import bluej.debugger.DebuggerObject;
import bluej.debugger.DebuggerThread;
import bluej.debugger.SourceLocation;
import bluej.debugger.jdi.JdiObject;
import bluej.utility.Debug;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.StepRequest;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public final class JdiThread
extends DebuggerThread {
    private static List excludes;
    static ObjectReference terminateException;
    static final String MAIN_THREADGROUP = "main";
    ThreadReference rt;
    Object userParam;
    int selectedFrame;
    EventRequestManager eventReqMgr;

    private static List getExcludes() {
        if (excludes == null) {
            JdiThread.setExcludes("java.*, javax.*, sun.*, com.sun.*");
        }
        return excludes;
    }

    static void setExcludes(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,;");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        excludes = arrayList;
    }

    static void addExcludesToRequest(StepRequest stepRequest) {
        Iterator iterator = JdiThread.getExcludes().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stepRequest.addClassExclusionFilter(string);
        }
    }

    public static void setTerminateException(ObjectReference objectReference) {
        terminateException = objectReference;
    }

    public String getName() {
        String string = null;
        try {
            string = this.rt.name();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public void setParam(Object object) {
        this.userParam = object;
    }

    public Object getParam() {
        return this.userParam;
    }

    public ThreadReference getRemoteThread() {
        return this.rt;
    }

    public String getStatus() {
        try {
            if (this.rt.isAtBreakpoint()) {
                if (this.rt.frame(0).location().declaringType().name().equals("bluej.runtime.ExecServer")) {
                    return "finished";
                }
                return "at breakpoint";
            }
            if (this.rt.isSuspended()) {
                return "stopped";
            }
            int n = this.rt.status();
            switch (n) {
                case 3: {
                    return "at monitor";
                }
                case 5: {
                    return "not started";
                }
                case 1: {
                    return "running";
                }
                case 2: {
                    return "sleeping";
                }
                case -1: {
                    return "unknown status";
                }
                case 4: {
                    return "waiting";
                }
                case 0: {
                    return "zombie";
                }
            }
        }
        catch (Exception exception) {
            return "???";
        }
        return null;
    }

    public boolean isSuspended() {
        return this.rt.isSuspended();
    }

    public String getClass(int n) {
        try {
            return this.rt.frame(n).location().declaringType().name();
        }
        catch (Exception exception) {
            return "<error finding type at frame " + n + ">";
        }
    }

    public String getClassSourceName(int n) {
        try {
            return this.rt.frame(n).location().sourceName();
        }
        catch (Exception exception) {
            return "<no source at frame no " + n + ">";
        }
    }

    public int getLineNumber(int n) {
        try {
            return this.rt.frame(n).location().lineNumber();
        }
        catch (Exception exception) {
            return 1;
        }
    }

    public boolean isKnownSystemThread() {
        if (!this.rt.threadGroup().name().equals(MAIN_THREADGROUP)) {
            return true;
        }
        String string = this.rt.name();
        return string.startsWith("AWT-") || string.equals("Timer Queue") || string.equals("Screen Updater") || string.startsWith("SunToolkit.");
    }

    public List getStack() {
        try {
            if (this.rt.isSuspended()) {
                ArrayList<SourceLocation> arrayList = new ArrayList<SourceLocation>();
                List<StackFrame> list = this.rt.frames();
                int n = 0;
                while (n < list.size()) {
                    StackFrame stackFrame = list.get(n);
                    Location location = stackFrame.location();
                    String string = location.declaringType().name();
                    if (string.startsWith("__SHELL")) break;
                    String string2 = location.sourceName();
                    String string3 = location.method().name();
                    int n2 = location.lineNumber();
                    arrayList.add(new SourceLocation(string, string2, string3, n2));
                    ++n;
                }
                return arrayList;
            }
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            Debug.reportError("error while getting stack info");
        }
        catch (AbsentInformationException absentInformationException) {
            Debug.reportError("error while getting stack info");
        }
        return new ArrayList();
    }

    public List getLocalVariables(int n) {
        try {
            if (this.rt.isSuspended()) {
                StackFrame stackFrame = this.rt.frame(n);
                List<LocalVariable> list = stackFrame.visibleVariables();
                ArrayList<String> arrayList = new ArrayList<String>();
                int n2 = 0;
                while (n2 < list.size()) {
                    LocalVariable localVariable = list.get(n2);
                    String string = JdiObject.getValueString(stackFrame.getValue(localVariable));
                    arrayList.add(localVariable.typeName() + " " + localVariable.name() + " = " + string);
                    ++n2;
                }
                return arrayList;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ArrayList();
    }

    public boolean varIsObject(int n, int n2) {
        try {
            if (this.rt.isSuspended()) {
                StackFrame stackFrame = this.rt.frame(n);
                List<LocalVariable> list = stackFrame.visibleVariables();
                LocalVariable localVariable = list.get(n2);
                Value value = stackFrame.getValue(localVariable);
                return value instanceof ObjectReference;
            }
            return false;
        }
        catch (Exception exception) {
            Debug.reportError("could not get local variable info: " + exception);
            return false;
        }
    }

    public DebuggerObject getStackObject(int n, int n2) {
        try {
            if (this.rt.isSuspended()) {
                StackFrame stackFrame = this.rt.frame(n);
                List<LocalVariable> list = stackFrame.visibleVariables();
                LocalVariable localVariable = list.get(n2);
                ObjectReference objectReference = (ObjectReference)stackFrame.getValue(localVariable);
                return JdiObject.getDebuggerObject(objectReference);
            }
            return null;
        }
        catch (Exception exception) {
            Debug.reportError("could not get local variable info: " + exception);
            return null;
        }
    }

    public DebuggerObject getCurrentObject(int n) {
        try {
            if (this.rt.isSuspended()) {
                StackFrame stackFrame = this.rt.frame(n);
                return JdiObject.getDebuggerObject(stackFrame.thisObject());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void setSelectedFrame(int n) {
        this.selectedFrame = n;
    }

    public int getSelectedFrame() {
        return this.selectedFrame;
    }

    public void step() {
        this.doStep(2);
    }

    public void stepInto() {
        this.doStep(1);
    }

    private void doStep(int n) {
        this.clearPreviousStep(this.rt);
        StepRequest stepRequest = this.eventReqMgr.createStepRequest(this.rt, -2, n);
        JdiThread.addExcludesToRequest(stepRequest);
        stepRequest.addCountFilter(1);
        stepRequest.enable();
        Debugger.debugger.cont();
    }

    public void terminate() {
        try {
            if (this.rt.isSuspended()) {
                Debugger.debugger.cont();
            }
            this.rt.stop(terminateException);
        }
        catch (Exception exception) {
            Debug.reportError("cannot terminate thread: " + exception);
        }
    }

    private void clearPreviousStep(ThreadReference threadReference) {
        if (this.eventReqMgr == null) {
            this.getEventRequestManager();
        }
        List<StepRequest> list = this.eventReqMgr.stepRequests();
        Iterator<StepRequest> iterator = list.iterator();
        while (iterator.hasNext()) {
            StepRequest stepRequest = iterator.next();
            if (stepRequest == null || stepRequest.thread() == null || !stepRequest.thread().equals(threadReference)) continue;
            this.eventReqMgr.deleteEventRequest(stepRequest);
            break;
        }
    }

    private void getEventRequestManager() {
        this.eventReqMgr = this.rt.virtualMachine().eventRequestManager();
    }

    public JdiThread(ThreadReference threadReference, Object object) {
        this.rt = threadReference;
        this.userParam = object;
        this.selectedFrame = 0;
    }

    public JdiThread(ThreadReference threadReference) {
        this(threadReference, null);
    }
}

