/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.jdi;

import bluej.debugger.jdi.JdiDebugger;
import bluej.utility.Debug;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventIterator;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;

public class VMEventHandler
implements Runnable {
    JdiDebugger debugger;
    Thread thread;
    VirtualMachine vm;
    EventQueue queue;
    volatile boolean exiting = false;
    boolean exited = false;
    private boolean vmDied = false;

    public void run() {
        Object object;
        while (!this.exiting) {
            try {
                object = this.queue.remove();
                boolean bl = false;
                EventIterator eventIterator = object.eventIterator();
                while (eventIterator.hasNext()) {
                    bl |= this.handleEvent(eventIterator.nextEvent());
                }
                if (object.suspendPolicy() != 2 || !bl) continue;
                this.vm.resume();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                this.handleDisconnectedException();
                break;
            }
        }
        object = this;
        synchronized (object) {
            this.exited = true;
            this.notifyAll();
        }
    }

    private boolean handleEvent(Event event) {
        if (event instanceof ExceptionEvent) {
            return this.exceptionEvent(event);
        }
        if (event instanceof BreakpointEvent) {
            return this.breakpointEvent(event);
        }
        if (event instanceof StepEvent) {
            return this.stepEvent(event);
        }
        if (event instanceof ClassPrepareEvent) {
            return this.classPrepareEvent(event);
        }
        if (event instanceof VMDeathEvent) {
            return this.handleExitEvent(event);
        }
        if (event instanceof VMDisconnectEvent) {
            return this.handleExitEvent(event);
        }
        return true;
    }

    private boolean handleExitEvent(Event event) {
        if (event instanceof VMDeathEvent) {
            this.vmDied = true;
            return this.vmDeathEvent(event);
        }
        if (event instanceof VMDisconnectEvent) {
            this.exiting = true;
            if (!this.vmDied) {
                this.vmDisconnectEvent(event);
            }
            return false;
        }
        return false;
    }

    synchronized void handleDisconnectedException() {
        Debug.reportError("[VM Event] unexpected disconnection");
    }

    private boolean breakpointEvent(Event event) {
        this.debugger.breakEvent((LocatableEvent)event, true);
        return false;
    }

    private boolean stepEvent(Event event) {
        this.debugger.breakEvent((LocatableEvent)event, false);
        return false;
    }

    private boolean classPrepareEvent(Event event) {
        ClassPrepareEvent classPrepareEvent = (ClassPrepareEvent)event;
        ReferenceType referenceType = classPrepareEvent.referenceType();
        if (referenceType.name().equals("bluej.runtime.ExecServer")) {
            this.debugger.serverClassPrepared();
        }
        return true;
    }

    private boolean exceptionEvent(Event event) {
        this.debugger.exceptionEvent((ExceptionEvent)event);
        return true;
    }

    public boolean vmDeathEvent(Event event) {
        return false;
    }

    public boolean vmDisconnectEvent(Event event) {
        return false;
    }

    synchronized void finish() {
        this.exiting = true;
        this.thread.interrupt();
        while (!this.exited) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    VMEventHandler(JdiDebugger jdiDebugger, VirtualMachine virtualMachine) {
        this.debugger = jdiDebugger;
        this.vm = virtualMachine;
        this.queue = virtualMachine.eventQueue();
        this.thread = new Thread((Runnable)this, "vm-event-handler");
        this.thread.start();
    }
}

