/*
 * Decompiled with CFR 0.152.
 */
package bluej.graph;

import bluej.graph.Edge;
import bluej.graph.Vertex;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.Enumeration;

public abstract class Graph {
    public static final String UML = "uml";
    public static final String BLUE = "blue";
    private static final int RIGHT_PLACEMENT_MIN = 300;
    private static final int SNAP_GRID_SIZE = 10;
    private static final int WHITESPACE_SIZE = 10;

    public abstract Enumeration getVertices();

    public abstract Enumeration getEdges();

    public void draw(Graphics graphics) {
        Object object;
        Enumeration enumeration = this.getEdges();
        while (enumeration.hasMoreElements()) {
            object = (Edge)enumeration.nextElement();
            ((Edge)object).draw((Graphics2D)graphics.create());
        }
        enumeration = this.getVertices();
        while (enumeration.hasMoreElements()) {
            object = (Vertex)enumeration.nextElement();
            ((Vertex)object).drawUntranslated((Graphics2D)graphics.create());
        }
    }

    public void setActiveVertex(Vertex vertex) {
    }

    public Dimension getMinimumSize() {
        int n = 1;
        int n2 = 1;
        Enumeration enumeration = this.getVertices();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            if (vertex.x + vertex.width > n) {
                n = vertex.x + vertex.width;
            }
            if (vertex.y + vertex.height <= n2) continue;
            n2 = vertex.y + vertex.height;
        }
        return new Dimension(n, n2);
    }

    public void findSpaceForVertex(Vertex vertex) {
        Object object;
        Area area = new Area();
        Object object2 = this.getVertices();
        while (object2.hasMoreElements()) {
            object = (Vertex)object2.nextElement();
            if (object == vertex) continue;
            Rectangle rectangle = new Rectangle(((Vertex)object).x, ((Vertex)object).y, ((Vertex)object).width, ((Vertex)object).height);
            area.add(new Area(rectangle));
        }
        object2 = this.getMinimumSize();
        if (300 > ((Dimension)object2).width) {
            ((Dimension)object2).width = 300;
        }
        object = new Rectangle(vertex.width + 20, vertex.height + 20);
        int n = 0;
        while (n < 2 * ((Dimension)object2).height) {
            int n2 = 0;
            while (n2 < ((Dimension)object2).width - vertex.width - 20) {
                ((Rectangle)object).setLocation(n2, n);
                if (!area.intersects((Rectangle2D)object)) {
                    vertex.setPos(n2 + 10, n + 10);
                    return;
                }
                n2 += 10;
            }
            n += 10;
        }
        vertex.setPos(10, ((Dimension)object2).height + 10);
    }
}

