/*
 * Decompiled with CFR 0.152.
 */
package bluej.graph;

import bluej.Config;
import bluej.graph.Graph;
import bluej.graph.Vertex;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.PrintGraphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import javax.swing.JComponent;

public class GraphEditor
extends JComponent
implements MouseListener,
MouseMotionListener {
    static final long DBL_CLICK_TIME = 300L;
    static final Color background = Config.getItemColour("colour.background");
    static final Color realBackground = Config.getItemColour("colour.graph.background");
    private Graph graph;
    private Vertex activeVertex;
    private boolean motionListening;
    private boolean readOnly = false;

    public Dimension getPreferredSize() {
        return this.graph.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        return this.graph.getMinimumSize();
    }

    public void paint(Graphics graphics) {
        if (!(graphics instanceof PrintGraphics)) {
            Dimension dimension = this.getSize();
            graphics.setColor(realBackground);
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
        this.graph.draw(graphics);
    }

    public Graphics2D getGraphics2D() {
        return (Graphics2D)super.getGraphics();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.activeVertex = null;
        Enumeration enumeration = this.graph.getVertices();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            if (vertex.x > n || n >= vertex.x + vertex.width || vertex.y > n2 || n2 >= vertex.y + vertex.height) continue;
            this.activeVertex = vertex;
        }
        this.graph.setActiveVertex(this.activeVertex);
        if (this.activeVertex != null && !this.isPopupEvent(mouseEvent) && (mouseEvent.getModifiers() & 0x10) != 0) {
            this.activeVertex.mousePressed(mouseEvent, n, n2, this);
            if (!this.motionListening) {
                this.startMotionListening();
            }
        }
    }

    public void startMotionListening() {
        this.addMouseMotionListener(this);
        this.motionListening = true;
    }

    public void stopMotionListening() {
        this.removeMouseMotionListener(this);
        this.motionListening = false;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.activeVertex != null && (mouseEvent.getModifiers() & 0x10) != 0) {
            this.activeVertex.mouseReleased(mouseEvent, mouseEvent.getX(), mouseEvent.getY(), this);
            if (this.motionListening) {
                this.stopMotionListening();
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.activeVertex != null) {
            if (mouseEvent.getClickCount() > 1 && (mouseEvent.getModifiers() & 0x10) != 0) {
                this.activeVertex.doubleClick(mouseEvent, mouseEvent.getX(), mouseEvent.getY(), this);
            } else {
                this.activeVertex.singleClick(mouseEvent, mouseEvent.getX(), mouseEvent.getY(), this);
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.readOnly) {
            return;
        }
        if (this.activeVertex != null) {
            this.activeVertex.mouseDragged(mouseEvent, mouseEvent.getX(), mouseEvent.getY(), this);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.activeVertex != null) {
            this.activeVertex.mouseMoved(mouseEvent, mouseEvent.getX(), mouseEvent.getY(), this);
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (this.isPopupEvent(mouseEvent) && this.activeVertex != null) {
            this.activeVertex.popupMenu(mouseEvent, mouseEvent.getX(), mouseEvent.getY(), this);
        }
    }

    private boolean isPopupEvent(MouseEvent mouseEvent) {
        return mouseEvent.isPopupTrigger() || mouseEvent.getID() == 501 && mouseEvent.isControlDown();
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public GraphEditor(Graph graph) {
        this.graph = graph;
        this.activeVertex = null;
        this.motionListening = false;
        this.setBackground(background);
    }
}

