/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser.symtab;

import bluej.parser.symtab.ClassInfo;
import bluej.parser.symtab.Definition;
import bluej.parser.symtab.DummyClass;
import bluej.parser.symtab.HasImports;
import bluej.parser.symtab.JavaVector;
import bluej.parser.symtab.Occurrence;
import bluej.parser.symtab.PackageDef;
import bluej.parser.symtab.ScopedDef;
import bluej.parser.symtab.Selection;
import bluej.parser.symtab.SymbolTable;
import java.util.Enumeration;
import java.util.Vector;

class ClassDef
extends HasImports {
    static final int CLASS = 0;
    static final int INTERFACE = 1;
    static final int EITHER = 2;
    private int classOrInterface = 2;
    private boolean isAbstract = false;
    private boolean isPublic = false;
    private ClassDef superClass;
    private JavaVector subClasses;
    private JavaVector interfaces;
    private JavaVector implementers;
    private String comment;
    private Vector interfaceSelections;
    private Selection extendsInsert;
    private Selection implementsInsert;
    private Selection extendsReplace;
    private Selection superReplace;

    void addImplementer(ClassDef classDef) {
        this.getImplementers().addElement(classDef);
        this.setType(1);
        classDef.setType(0);
    }

    void addSubclass(ClassDef classDef) {
        this.getSubClasses().addElement(classDef);
    }

    public void setComment(String string) {
        this.comment = string;
    }

    JavaVector getImplementers() {
        if (this.implementers == null) {
            this.implementers = new JavaVector();
        }
        return this.implementers;
    }

    JavaVector getInterfaces() {
        return this.interfaces;
    }

    JavaVector getSubClasses() {
        if (this.subClasses == null) {
            this.subClasses = new JavaVector();
        }
        return this.subClasses;
    }

    ClassDef getSuperClass() {
        return this.superClass;
    }

    boolean isClass() {
        return this.classOrInterface == 0;
    }

    boolean isInterface() {
        return this.classOrInterface == 1;
    }

    void setExtendsInsert(Selection selection) {
        this.extendsInsert = selection;
    }

    void setImplementsInsert(Selection selection) {
        this.implementsInsert = selection;
    }

    void setExtendsReplace(Selection selection) {
        this.extendsReplace = selection;
    }

    void setSuperReplace(Selection selection) {
        this.superReplace = selection;
    }

    void setInterfaceSelections(Vector vector) {
        this.interfaceSelections = vector;
    }

    Definition lookup(String string, int n) {
        Definition definition = super.lookup(string, n);
        if (definition == null && this.getSuperClass() != null) {
            this.setType(0);
            this.getSuperClass().setType(0);
            definition = this.getSuperClass().lookup(string, n);
        }
        if (definition == null && this.interfaces != null) {
            Enumeration enumeration = this.interfaces.elements();
            while (definition == null && enumeration.hasMoreElements()) {
                definition = ((ClassDef)enumeration.nextElement()).lookup(string, n);
            }
        }
        return definition;
    }

    public void getInfo(ClassInfo classInfo, SymbolTable symbolTable) {
        if (this.getParentScope() instanceof PackageDef) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.isPublic && !classInfo.foundPublicClass() || !classInfo.foundClass()) {
                classInfo.setName(this.getName(), this.isPublic);
                if (this.getSuperClass() != null) {
                    classInfo.setSuperclass(this.getSuperClass().getQualifiedName());
                }
                if (this.isInterface()) {
                    classInfo.setInterface(true);
                    stringBuffer.append("interface ");
                } else {
                    stringBuffer.append("class ");
                }
                stringBuffer.append(this.getName());
                if (this.isAbstract) {
                    classInfo.setAbstract(true);
                }
                if (this.interfaces != null) {
                    Enumeration enumeration = this.interfaces.elements();
                    while (enumeration.hasMoreElements()) {
                        classInfo.addImplements(((ClassDef)enumeration.nextElement()).getName());
                    }
                }
                classInfo.addComment(stringBuffer.toString(), this.comment, null);
                classInfo.setExtendsInsertSelection(this.extendsInsert);
                classInfo.setImplementsInsertSelection(this.implementsInsert);
                classInfo.setExtendsReplaceSelection(this.extendsReplace);
                classInfo.setSuperReplaceSelection(this.superReplace);
                classInfo.setInterfaceSelections(this.interfaceSelections);
            }
        }
        this.getImportInfo(classInfo);
        this.getElementInfo(classInfo, symbolTable);
    }

    void resolveTypes(SymbolTable symbolTable) {
        Object object;
        ClassDef classDef;
        System.err.println("resolving: " + this.getQualifiedName());
        super.resolveTypes(symbolTable);
        if (this.subClasses != null) {
            this.subClasses.resolveTypes(symbolTable);
        }
        if ((classDef = this.getSuperClass()) != null && classDef instanceof DummyClass) {
            object = ((DummyClass)classDef).getPackage();
            if ((classDef = (ClassDef)symbolTable.lookupDummy(classDef)) == null) {
                classDef = new DummyClass(symbolTable.getUniqueName(this.getSuperClass().getName()), null, symbolTable.getUniqueName((String)object));
            }
            if (classDef != null) {
                classDef.addReference(this.getSuperClass().getOccurrence());
                this.setSuperClass(classDef);
                classDef.addSubclass(this);
                classDef.setType(0);
            }
            this.setType(0);
        }
        if (this.interfaces != null) {
            this.interfaces.resolveTypes(symbolTable);
            object = this.interfaces.elements();
            while (object.hasMoreElements()) {
                ((ClassDef)object.nextElement()).addImplementer(this);
            }
        }
        if (this.isTopLevel()) {
            this.closeImports(symbolTable);
        }
    }

    void setInterfaces(JavaVector javaVector) {
        this.interfaces = javaVector;
    }

    void setSuperClass(ClassDef classDef) {
        this.superClass = classDef;
        this.setType(0);
        classDef.setType(0);
    }

    void setType(int n) {
        this.classOrInterface = n;
    }

    ClassDef() {
        super("Object", null, null);
    }

    ClassDef(String string) {
        super(string, null, null);
    }

    ClassDef(String string, boolean bl, boolean bl2, Occurrence occurrence, ClassDef classDef, JavaVector javaVector, ScopedDef scopedDef) {
        super(string, occurrence, scopedDef);
        this.isAbstract = bl;
        this.isPublic = bl2;
        if (classDef != null) {
            this.superClass = classDef;
        }
        this.interfaces = javaVector;
    }
}

