/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser.symtab;

import bluej.parser.symtab.Selection;
import bluej.parser.symtab.SymbolTable;
import bluej.utility.SortedProperties;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public final class ClassInfo {
    private static final String[] appletClasses = new String[]{"Applet", "JApplet"};
    private boolean foundClass = false;
    private boolean foundPublicClass = false;
    private String name;
    private String superclass;
    private Vector implemented = new Vector();
    private Vector imported = new Vector();
    private Vector used = new Vector();
    private List comments = new LinkedList();
    private boolean isInterface = false;
    private boolean isAbstract = false;
    private boolean isApplet = false;
    private Selection extendsInsertSelection;
    private Selection implementsInsertSelection;
    private Selection extendsReplaceSelection;
    private Selection superReplaceSelection;
    private Vector interfaceSelections;
    private Vector interfaceTexts;
    private boolean packageStatementExists = false;
    private Selection packageStatementSelection = new Selection(null, 1, 1);
    private Selection packageNameSelection = new Selection(null, 1, 1);
    private Selection packageSemiSelection = new Selection(null, 1, 1);
    private String packageName = "";

    public boolean foundClass() {
        return this.foundClass;
    }

    public boolean foundPublicClass() {
        return this.foundPublicClass;
    }

    public void setName(String string, boolean bl) {
        this.name = string;
        this.foundClass = true;
        if (bl) {
            this.foundPublicClass = true;
        }
    }

    public void setSuperclass(String string) {
        if (string.equals(this.name)) {
            return;
        }
        this.superclass = string;
        if (this.used.contains(string)) {
            this.used.remove(string);
        }
        int n = 0;
        while (n < appletClasses.length) {
            if (string.equals(appletClasses[n])) {
                this.isApplet = true;
            }
            ++n;
        }
    }

    public void addImplements(String string) {
        if (string.equals(this.name)) {
            return;
        }
        if (!this.implemented.contains(string)) {
            this.implemented.addElement(string);
        }
    }

    public void addImported(String string) {
        if (string.equals(this.name)) {
            return;
        }
        if (!this.imported.contains(string)) {
            this.imported.addElement(string);
        }
    }

    public void addUsed(String string) {
        if (string.equals(this.name)) {
            return;
        }
        if (SymbolTable.getPredefined().contains(string)) {
            return;
        }
        if (string.equals(this.superclass)) {
            return;
        }
        if (!this.used.contains(string)) {
            this.used.addElement(string);
        }
    }

    public void addComment(String string, String string2) {
        this.addComment(string, string2, null);
    }

    public void addComment(String string, String string2, String string3) {
        if (string2 != null && string2.length() > 4) {
            string2 = string2.substring(2, string2.length() - 2);
            StringBuffer stringBuffer = new StringBuffer(string2.length());
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n\r\f");
            while (stringTokenizer.hasMoreTokens()) {
                StringBuffer stringBuffer2 = new StringBuffer(stringTokenizer.nextToken());
                int n = stringBuffer2.length() > 0 ? (int)stringBuffer2.charAt(0) : 120;
                while (n == 32 || n == 9 || n == 42) {
                    stringBuffer2.deleteCharAt(0);
                    int n2 = n = stringBuffer2.length() > 0 ? (int)stringBuffer2.charAt(0) : 120;
                }
                stringBuffer.append(stringBuffer2.toString());
                stringBuffer.append('\n');
            }
            string2 = stringBuffer.toString();
        }
        ClassInfo classInfo = this;
        if (classInfo == null) {
            throw null;
        }
        this.comments.add(classInfo.new SavedComment(string, string2, string3));
    }

    public void setInterface(boolean bl) {
        this.isInterface = bl;
    }

    public void setAbstract(boolean bl) {
        this.isAbstract = bl;
    }

    public void setExtendsInsertSelection(Selection selection) {
        this.extendsInsertSelection = selection;
    }

    public Selection getExtendsInsertSelection() {
        return this.extendsInsertSelection;
    }

    public void setImplementsInsertSelection(Selection selection) {
        this.implementsInsertSelection = selection;
    }

    public Selection getImplementsInsertSelection() {
        return this.implementsInsertSelection;
    }

    public void setExtendsReplaceSelection(Selection selection) {
        this.extendsReplaceSelection = selection;
    }

    public Selection getExtendsReplaceSelection() {
        return this.extendsReplaceSelection;
    }

    public void setSuperReplaceSelection(Selection selection) {
        this.superReplaceSelection = selection;
    }

    public Selection getSuperReplaceSelection() {
        return this.superReplaceSelection;
    }

    public void setInterfaceSelections(Vector vector) {
        this.interfaceSelections = vector;
        this.interfaceTexts = new Vector();
        Enumeration enumeration = this.interfaceSelections.elements();
        while (enumeration.hasMoreElements()) {
            Selection selection = (Selection)enumeration.nextElement();
            this.interfaceTexts.add(selection.getText());
        }
    }

    public Vector getInterfaceSelections() {
        return this.interfaceSelections;
    }

    public Vector getInterfaceTexts() {
        return this.interfaceTexts;
    }

    public boolean hasInterfaceSelections() {
        return this.interfaceSelections != null && this.interfaceSelections.size() > 0;
    }

    public void setPackageSelections(Selection selection, Selection selection2, String string, Selection selection3) {
        this.packageStatementSelection = selection;
        this.packageNameSelection = selection2;
        this.packageName = string;
        this.packageSemiSelection = selection3;
        this.packageStatementExists = true;
    }

    public boolean hasPackageStatement() {
        return this.packageStatementExists;
    }

    public Selection getPackageStatementSelection() {
        return this.packageStatementSelection;
    }

    public Selection getPackageNameSelection() {
        return this.packageNameSelection;
    }

    public Selection getPackageSemiSelection() {
        return this.packageSemiSelection;
    }

    public String getPackage() {
        return this.packageName;
    }

    public String getSuperclass() {
        return this.superclass;
    }

    public String getName() {
        return this.name;
    }

    public Vector getImplements() {
        return this.implemented;
    }

    public Vector getImported() {
        return this.imported;
    }

    public Vector getUsed() {
        return this.used;
    }

    public Properties getComments() {
        SortedProperties sortedProperties = new SortedProperties();
        sortedProperties.setProperty("numComments", String.valueOf(this.comments.size()));
        Iterator iterator = this.comments.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            SavedComment savedComment = (SavedComment)iterator.next();
            savedComment.save(sortedProperties, "comment" + n);
            ++n;
        }
        return sortedProperties;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isApplet() {
        return this.isApplet;
    }

    public void print() {
        System.out.println();
        System.out.println("superclass: " + this.superclass);
        System.out.println();
        System.out.println("implements:");
        Enumeration enumeration = this.implemented.elements();
        while (enumeration.hasMoreElements()) {
            System.out.println("   " + (String)enumeration.nextElement());
        }
        System.out.println();
        System.out.println("uses:");
        enumeration = this.used.elements();
        while (enumeration.hasMoreElements()) {
            System.out.println("   " + (String)enumeration.nextElement());
        }
        System.out.println();
        System.out.println("imports:");
        enumeration = this.imported.elements();
        while (enumeration.hasMoreElements()) {
            System.out.println("   " + (String)enumeration.nextElement());
        }
    }

    private class SavedComment {
        public String target;
        public String comment;
        public String paramnames;

        public void save(Properties properties, String string) {
            ((Hashtable)properties).put(string + ".target", this.target);
            if (this.comment != null) {
                properties.setProperty(string + ".text", this.comment);
            }
            if (this.paramnames != null) {
                properties.setProperty(string + ".params", this.paramnames);
            }
        }

        public SavedComment(String string, String string2, String string3) {
            if (string == null) {
                throw new NullPointerException();
            }
            this.target = string;
            this.comment = string2;
            this.paramnames = string3;
        }
    }
}

