/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser.symtab;

import bluej.parser.symtab.ClassInfo;
import bluej.parser.symtab.JavaVector;
import bluej.parser.symtab.Occurrence;
import bluej.parser.symtab.Reportable;
import bluej.parser.symtab.ScopedDef;
import bluej.parser.symtab.SymbolTable;

abstract class Definition
implements Reportable {
    private Occurrence definition;
    private ScopedDef parentScope;
    private JavaVector references;
    private String name;

    void addReference(Occurrence occurrence) {
        this.references.addElement(occurrence);
    }

    String getDef() {
        if (this.definition != null) {
            return this.definition.getLocation();
        }
        return "";
    }

    String getName() {
        if (this.name == null) {
            return "~NO NAME~";
        }
        return this.name;
    }

    Occurrence getOccurrence() {
        return this.definition;
    }

    ScopedDef getParentScope() {
        return this.parentScope;
    }

    String getQualifiedName() {
        String string = this.name;
        if (this.name == null) {
            string = "~NO NAME~";
        }
        if (this.getParentScope() != null && !this.getParentScope().isDefaultOrBaseScope()) {
            return this.getParentScope().getQualifiedName() + "." + string;
        }
        return string;
    }

    boolean isSuperClassOf(Definition definition) {
        return false;
    }

    Definition lookup(String string) {
        return this.lookup(string, -1);
    }

    Definition lookup(String string, int n) {
        throw new IllegalArgumentException("Can't lookup in a " + this.getClass());
    }

    public void getInfo(ClassInfo classInfo, SymbolTable symbolTable) {
    }

    void resolveTypes(SymbolTable symbolTable) {
    }

    void setParentScope(ScopedDef scopedDef) {
        this.parentScope = scopedDef;
    }

    public String toString() {
        return this.getClass().getName() + " [" + this.getQualifiedName() + "]";
    }

    Definition(String string, Occurrence occurrence, ScopedDef scopedDef) {
        this.definition = occurrence;
        this.parentScope = scopedDef;
        this.name = string;
        this.references = new JavaVector();
    }
}

