/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser.symtab;

import bluej.parser.symtab.Definition;
import bluej.parser.symtab.DummyClass;
import bluej.parser.symtab.IndentingPrintWriter;
import bluej.parser.symtab.SymbolTable;
import java.util.Enumeration;
import java.util.Hashtable;

class JavaHashtable
extends Hashtable {
    private static final int CLASS = 0;
    private static final int INTERFACE = 1;
    private static final int EITHER = 2;
    private boolean resolving = false;

    void list(IndentingPrintWriter indentingPrintWriter) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            indentingPrintWriter.println(((Definition)enumeration.nextElement()).getQualifiedName());
        }
    }

    void listIndented(IndentingPrintWriter indentingPrintWriter, String string) {
        if (string != null) {
            indentingPrintWriter.println(string);
        }
        indentingPrintWriter.indent();
        this.list(indentingPrintWriter);
        indentingPrintWriter.dedent();
    }

    void resolveTypes(SymbolTable symbolTable) {
        if (!this.resolving) {
            this.resolving = true;
            Enumeration enumeration = this.elements();
            while (enumeration.hasMoreElements()) {
                Definition definition = (Definition)enumeration.nextElement();
                if (definition instanceof DummyClass) {
                    String string = ((DummyClass)definition).getPackage();
                    Definition definition2 = symbolTable.lookupDummy(definition);
                    if (definition2 == null) continue;
                    definition2.addReference(definition.getOccurrence());
                    this.remove(definition.getName());
                    this.put(definition.getName(), definition2);
                    continue;
                }
                definition.resolveTypes(symbolTable);
            }
        }
    }

    JavaHashtable() {
    }
}

