/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser.symtab;

import bluej.parser.JavaToken;
import bluej.parser.symtab.ClassDef;
import bluej.parser.symtab.ClassInfo;
import bluej.parser.symtab.Definition;
import bluej.parser.symtab.DummyClass;
import bluej.parser.symtab.IndentingPrintWriter;
import bluej.parser.symtab.Occurrence;
import bluej.parser.symtab.SymbolTable;
import java.util.Enumeration;
import java.util.Vector;

public class JavaVector
extends Vector {
    private boolean resolvingRefs = false;
    private boolean resolvingTypes = false;

    public void addElement(Definition definition) {
        super.addElement(definition);
        if (definition == null) {
            throw new IllegalArgumentException("null element added to vector");
        }
    }

    public Definition getElement(String string) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Definition definition = (Definition)enumeration.nextElement();
            if (!definition.getName().equals(string)) continue;
            return definition;
        }
        return null;
    }

    void list(IndentingPrintWriter indentingPrintWriter) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            indentingPrintWriter.println(((Definition)enumeration.nextElement()).getQualifiedName());
        }
    }

    void listIndented(IndentingPrintWriter indentingPrintWriter, String string) {
        if (string != null) {
            indentingPrintWriter.println(string);
        }
        indentingPrintWriter.indent();
        this.list(indentingPrintWriter);
        indentingPrintWriter.dedent();
    }

    public void getUnresolvedInfo(ClassInfo classInfo, SymbolTable symbolTable) {
        if (!this.resolvingRefs) {
            this.resolvingRefs = true;
            Enumeration enumeration = this.elements();
            while (enumeration.hasMoreElements()) {
                Object object;
                JavaToken javaToken = (JavaToken)((Object)enumeration.nextElement());
                String string = javaToken.getText();
                int n = string.indexOf(".");
                while (n != -1) {
                    object = string.substring(0, n);
                    Definition definition = symbolTable.lookup((String)object);
                    if (definition != null && definition instanceof ClassDef) {
                        classInfo.addUsed(definition.getQualifiedName());
                    }
                    n = string.indexOf(".", n + 1);
                }
                object = symbolTable.lookup(string);
                if (object == null || !(object instanceof ClassDef)) continue;
                classInfo.addUsed(((Definition)object).getQualifiedName());
            }
        }
    }

    public void resolveRefs(SymbolTable symbolTable) {
        if (!this.resolvingRefs) {
            this.resolvingRefs = true;
            Enumeration enumeration = this.elements();
            while (enumeration.hasMoreElements()) {
                JavaToken javaToken = (JavaToken)((Object)enumeration.nextElement());
                Definition definition = symbolTable.lookup(javaToken.getText(), javaToken.getParamCount());
                if (definition == null) {
                    definition = symbolTable.findPackage(javaToken.getText());
                }
                if (definition == null) continue;
                definition.addReference(new Occurrence(javaToken.getFile(), javaToken.getLine(), javaToken.getColumn()));
            }
        }
    }

    public void resolveTypes(SymbolTable symbolTable) {
        if (!this.resolvingTypes) {
            this.resolvingTypes = true;
            Enumeration enumeration = this.elements();
            while (enumeration.hasMoreElements()) {
                Definition definition = (Definition)enumeration.nextElement();
                if (definition instanceof DummyClass) {
                    String string = ((DummyClass)definition).getPackage();
                    Definition definition2 = symbolTable.lookupDummy(definition);
                    if (definition2 == null) continue;
                    definition2.addReference(definition.getOccurrence());
                    this.removeElement(definition);
                    this.addElement(definition2);
                    continue;
                }
                definition.resolveTypes(symbolTable);
            }
        }
    }
}

