/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser.symtab;

import bluej.parser.symtab.ClassDef;
import bluej.parser.symtab.ClassInfo;
import bluej.parser.symtab.Definition;
import bluej.parser.symtab.DummyClass;
import bluej.parser.symtab.JavaVector;
import bluej.parser.symtab.Occurrence;
import bluej.parser.symtab.ScopedDef;
import bluej.parser.symtab.SymbolTable;
import bluej.parser.symtab.TypedDef;
import bluej.parser.symtab.VariableDef;
import java.util.Enumeration;

class MethodDef
extends ScopedDef
implements TypedDef {
    private String comment;
    private Definition type = null;
    private JavaVector parameters;
    private JavaVector exceptions;

    void add(ClassDef classDef) {
        if (this.exceptions == null) {
            this.exceptions = new JavaVector();
        }
        this.exceptions.addElement(classDef);
    }

    void add(VariableDef variableDef) {
        if (this.parameters == null) {
            this.parameters = new JavaVector();
        }
        this.parameters.addElement(variableDef);
    }

    int getParamCount() {
        if (this.parameters == null) {
            return 0;
        }
        return this.parameters.size();
    }

    public Definition getType() {
        return this.type;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    Definition lookup(String string, int n) {
        if (n == -1) {
            Definition definition = super.lookup(string, n);
            if (definition != null) {
                return definition;
            }
            if (this.parameters != null) {
                Enumeration enumeration = this.parameters.elements();
                while (enumeration.hasMoreElements()) {
                    definition = (Definition)enumeration.nextElement();
                    if (!definition.getName().equals(string)) continue;
                    return definition;
                }
            }
        }
        return null;
    }

    public void getInfo(ClassInfo classInfo, SymbolTable symbolTable) {
        int n;
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.type != null) {
            classInfo.addUsed(this.type.getQualifiedName());
            stringBuffer.append(this.type.getName());
            stringBuffer.append(" ");
        }
        stringBuffer.append(this.getName());
        stringBuffer.append("(");
        StringBuffer stringBuffer2 = new StringBuffer();
        if (this.parameters != null) {
            Enumeration enumeration = this.parameters.elements();
            while (enumeration.hasMoreElements()) {
                object = (VariableDef)enumeration.nextElement();
                stringBuffer2.append(((Definition)object).getName());
                stringBuffer2.append(" ");
                ((VariableDef)object).getInfo(classInfo, symbolTable);
                stringBuffer.append(((VariableDef)object).getType().getName());
                int n2 = 0;
                while (n2 < ((VariableDef)object).getArrayLevel()) {
                    stringBuffer.append("[]");
                    ++n2;
                }
                stringBuffer.append(",");
            }
        }
        if ((n = stringBuffer2.length() - 1) >= 0 && stringBuffer2.charAt(n) == ' ') {
            stringBuffer2.deleteCharAt(n);
        }
        if (stringBuffer.charAt(n = stringBuffer.length() - 1) == ',') {
            stringBuffer.deleteCharAt(n);
        }
        stringBuffer.append(")");
        if (this.exceptions != null) {
            object = this.exceptions.elements();
            while (object.hasMoreElements()) {
                classInfo.addUsed(((ClassDef)object.nextElement()).getQualifiedName());
            }
        }
        classInfo.addComment(stringBuffer.toString(), this.comment, stringBuffer2.toString());
        super.getInfo(classInfo, symbolTable);
    }

    void resolveTypes(SymbolTable symbolTable) {
        Definition definition;
        if (this.parameters != null) {
            this.parameters.resolveTypes(symbolTable);
        }
        if (this.exceptions != null) {
            this.exceptions.resolveTypes(symbolTable);
        }
        if (this.type != null && this.type instanceof DummyClass && (definition = symbolTable.lookupDummy(this.type)) != null) {
            definition.addReference(this.type.getOccurrence());
            this.type = definition;
        }
        super.resolveTypes(symbolTable);
    }

    void setExceptions(JavaVector javaVector) {
        this.exceptions = javaVector;
    }

    MethodDef(String string, Occurrence occurrence, ClassDef classDef, ScopedDef scopedDef) {
        super(string, occurrence, scopedDef);
        this.type = classDef;
    }
}

